/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$;
import kafka.admin.ConfigCommandTest$CredentialChange$4$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfigTest;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Sanitizer;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\r]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011cQ8oM&<7i\\7nC:$G+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000bi\u0001A\u0011A\u000e\u0002KMDw.\u001e7e\u000bbLGoV5uQ:{gNW3s_N#\u0018\r^;t\u001f:\f%oZ#se>\u0014H#\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\tUs\u0017\u000e\u001e\u0015\u00033\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u000b),h.\u001b;\u000b\u0003!\n1a\u001c:h\u0013\tQSE\u0001\u0003UKN$\b\"\u0002\u0017\u0001\t\u0003Y\u0012aK:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148[W\u000e{W.\\1oI\u0016\u0013(o\u001c:)\u0005-\u001a\u0003\"B\u0018\u0001\t\u0003Y\u0012aL:i_VdG-\u0012=ji^KG\u000f\u001b(p]j+'o\\*uCR,8o\u00148Ce>\\WM]\"p[6\fg\u000eZ#se>\u0014\bF\u0001\u0018$\u0011\u0015\u0011\u0004\u0001\"\u00034\u0003]\t7o]3si:{gNW3s_N#\u0018\r^;t\u000bbLG\u000f\u0006\u0002\u001di!)Q'\ra\u0001m\u0005!\u0011M]4t!\rir'O\u0005\u0003qy\u0011Q!\u0011:sCf\u0004\"AO\u001f\u000f\u0005uY\u0014B\u0001\u001f\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qr\u0002\"B!\u0001\t\u0003Y\u0012AN:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s\u00072LWM\u001c;t\u000b:$\u0018\u000e^=UsB,Wk]5oOj{wn[3fa\u0016\u0014\bF\u0001!$\u0011\u0015!\u0005\u0001\"\u0001\u001c\u0003Q\u001a\bn\\;mIB\u000b'o]3Be\u001e,X.\u001a8ug\u001a{'/V:feN,e\u000e^5usRK\b/Z+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0003\u0007\u000eBQa\u0012\u0001\u0005\u0002m\tQg\u001d5pk2$\u0007+\u0019:tK\u0006\u0013x-^7f]R\u001chi\u001c:U_BL7m]#oi&$\u0018\u0010V=qKV\u001b\u0018N\\4[_>\\W-\u001a9fe\"\u0012ai\t\u0005\u0006\u0015\u0002!\taG\u0001(g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J$v\u000e]5dg\u0016sG/\u001b;z)f\u0004X\r\u000b\u0002JG!)Q\n\u0001C\u00017\u000514\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN\u001d\"s_.,'o]#oi&$\u0018\u0010V=qKV\u001b\u0018N\\4[_>\\W-\u001a9fe\"\u0012Aj\t\u0005\u0006!\u0002!\taG\u0001)g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J\u0014%o\\6feN,e\u000e^5usRK\b/\u001a\u0015\u0003\u001f\u000eBQa\u0015\u0001\u0005\u0002m\taf\u001d5pk2$\u0007+\u0019:tK\u0006\u0013x-^7f]R\u001chi\u001c:Ce>\\WM\u001d'pO\u001e,'o]#oi&$\u0018\u0010V=qK\"\u0012!k\t\u0005\u0006-\u0002!\taV\u0001\u0012i\u0016\u001cH/\u0011:hk6,g\u000e\u001e)beN,Gc\u0001\u000fY5\")\u0011,\u0016a\u0001s\u0005QQM\u001c;jif$\u0016\u0010]3\t\u000bm+\u0006\u0019\u0001/\u0002\u0011i\\7i\u001c8gS\u001e\u0004\"!H/\n\u0005ys\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006A\u0002!\taG\u0001\u001ai\u0016\u001cHo\u00149uS>tWI\u001c;jif$\u0016\u0010]3OC6,7\u000f\u000b\u0002`G!)1\r\u0001C\u00017\u0005\u00014\u000f[8vY\u00124\u0015-\u001b7JMVs'/Z2pO:L7/\u001a3F]RLG/\u001f+za\u0016,6/\u001b8h5>|7.Z3qKJDCAY\u0012fM\u0006AQ\r\u001f9fGR,GmI\u0001h!\tA\u0007O\u0004\u0002j]:\u0011!.\\\u0007\u0002W*\u0011ANB\u0001\u0007yI|w\u000e\u001e \n\u0003}I!a\u001c\u0010\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'BA8\u001f\u0011\u0015!\b\u0001\"\u0001\u001c\u0003\t\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g+:\u0014XmY8h]&\u001cX\rZ#oi&$\u0018\u0010V=qK\"\"1oI3g\u0011\u00159\b\u0001\"\u0001\u001c\u0003a\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g\u0005J|7.\u001a:F]RLG/\u001f+za\u0016L5OT8u\u0003:Le\u000e^3hKJ,6/\u001b8h5>|7.Z3qKJDCA^\u0012fM\")!\u0010\u0001C\u00017\u0005Q3\u000f[8vY\u00124\u0015-\u001b7JM\n\u0013xn[3s\u000b:$\u0018\u000e^=UsB,\u0017j\u001d(pi\u0006s\u0017J\u001c;fO\u0016\u0014\b\u0006B=$K\u001aDQ! \u0001\u0005\u0002m\tQh\u001d5pk2$g)Y5m\u0013\u001a\u001c\u0006n\u001c:u\u0005J|7.\u001a:F]RLG/\u001f+za\u0016L5OT8u\u0003:Le\u000e^3hKJ,6/\u001b8h5>|7.Z3qKJDC\u0001`\u0012fM\"1\u0011\u0011\u0001\u0001\u0005\u0002m\tqf\u001d5pk2$g)Y5m\u0013\u001a\u001c\u0006n\u001c:u\u0005J|7.\u001a:F]RLG/\u001f+za\u0016L5OT8u\u0003:Le\u000e^3hKJDCa`\u0012fM\"1\u0011q\u0001\u0001\u0005\u0002m\taf\u001d5pk2$g)Y5m\u0013\u001al\u0015\u000e_3e\u000b:$\u0018\u000e^=UsB,g\t\\1hgV\u001b\u0018N\\4[_>\\W-\u001a9fe\"*\u0011QA\u0012fM\"1\u0011Q\u0002\u0001\u0005\u0002m\t1e\u001d5pk2$\u0017\t\u001a3DY&,g\u000e^\"p]\u001aLw-V:j]\u001eTvn\\6fKB,'\u000fK\u0002\u0002\f\rBa!a\u0005\u0001\t\u0003Y\u0012AI:i_VdG-\u00113e)>\u0004\u0018nY\"p]\u001aLw-V:j]\u001eTvn\\6fKB,'\u000fK\u0002\u0002\u0012\rBa!!\u0007\u0001\t\u0003Y\u0012AF:i_VdG-\u00117uKJ$v\u000e]5d\u0007>tg-[4)\u0007\u0005]1\u0005\u0003\u0004\u0002 \u0001!\taG\u0001\u001dg\"|W\u000f\u001c3EKN\u001c'/\u001b2f\u0007>tg-[4Ts:|g._7tQ\r\tib\t\u0005\u0007\u0003K\u0001A\u0011A\u000e\u00025MDw.\u001e7e\u0003\u0012$'I]8lKJ\fVo\u001c;b\u0007>tg-[4)\u0007\u0005\r2\u0005\u0003\u0004\u0002,\u0001!\taG\u0001\u001cg\"|W\u000f\u001c3BI\u0012\u0014%o\\6fe2{wmZ3s\u0007>tg-[4)\u0007\u0005%2\u0005\u0003\u0004\u00022\u0001!\taG\u0001<i\u0016\u001cHOT8Ta\u0016\u001c\u0017NZ5fI\u0016sG/\u001b;z\u001fB$\u0018n\u001c8XSRDG)Z:de&\u0014WM\u0011:pW\u0016\u00148/\u00138[\u0017&\u001b\u0018\t\u001c7po\u0016$\u0007fAA\u0018G!1\u0011q\u0007\u0001\u0005\u0002m\t\u0001\n^3ti:{7\u000b]3dS\u001aLW\rZ#oi&$\u0018p\u00149uS>tw+\u001b;i\t\u0016\u001c8M]5cK\n\u0013xn[3sg&s'i\\8ugR\u0014\u0018\r]*feZ,'/S:BY2|w/\u001a3)\u0007\u0005U2\u0005\u0003\u0004\u0002>\u0001!\taG\u0001\u001ci\u0016\u001cH\u000fR3tGJL'-Z!mY\n\u0013xn[3s\u0007>tg-[4)\u0007\u0005m2\u0005\u0003\u0004\u0002D\u0001!\taG\u0001\u001bi\u0016\u001cH\u000fR3tGJL'-Z!mYR{\u0007/[2D_:4\u0017n\u001a\u0015\u0004\u0003\u0003\u001a\u0003BBA%\u0001\u0011\u00051$\u0001\u001auKN$H)Z:de&\u0014W-\u00117m\u0005J|7.\u001a:D_:4\u0017n\u001a\"p_R\u001cHO]1q'\u0016\u0014h/\u001a:SKF,\u0018N]3eQ\u0015\t9eI3g\u0011\u0019\ty\u0005\u0001C\u00017\u0005YD/Z:u\u000b:$\u0018\u000e^=EK\u001a\fW\u000f\u001c;PaRLwN\\,ji\"$Um]2sS\n,'I]8lKJdunZ4fe&\u001bhj\u001c;BY2|w/\u001a3)\u000b\u000553%\u001a4\t\r\u0005U\u0003\u0001\"\u0001\u001c\u0003a\"Xm\u001d;F]RLG/\u001f#fM\u0006,H\u000e^(qi&|gnV5uQ\u0006cG/\u001a:Ce>\\WM\u001d'pO\u001e,'/S:O_R\fE\u000e\\8xK\u0012DS!a\u0015$K\u001aDa!a\u0017\u0001\t\u0003Y\u0012aS:i_VdGMU1jg\u0016LeN^1mS\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0016C8-\u001a9uS>tw\u000b[3o\u0003\u0012$\u0017N\\4J]Z\fG.\u001b3Ce>\\WM\u001d'pO\u001e,'oQ8oM&<\u0007FBA-G\u0015\fyf\t\u0002\u0002bA!\u00111MA:\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014AB3se>\u00148O\u0003\u0003\u0002l\u00055\u0014AB2p[6|gNC\u0002\u0006\u0003_R1!!\u001d(\u0003\u0019\t\u0007/Y2iK&!\u0011QOA3\u0005uIeN^1mS\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0016C8-\u001a9uS>t\u0007BBA=\u0001\u0011\u00051$A\u0012tQ>,H\u000eZ!eI\u0012+g-Y;mi\n\u0013xn[3s\tft\u0017-\\5d\u0007>tg-[4)\u0007\u0005]4\u0005\u0003\u0004\u0002\u0000\u0001!\taG\u0001\u001dg\"|W\u000f\u001c3BI\u0012\u0014%o\\6fe\u0012Kh.Y7jG\u000e{gNZ5hQ\r\tih\t\u0005\b\u0003\u000b\u0003A\u0011AAD\u0003]1XM]5gs\u0006cG/\u001a:Ce>\\WM]\"p]\u001aLw\rF\u0004\u001d\u0003\u0013\u000b)*!'\t\u0011\u0005-\u00151\u0011a\u0001\u0003\u001b\u000bAA\\8eKB!\u0011qRAI\u001b\t\tI'\u0003\u0003\u0002\u0014\u0006%$\u0001\u0002(pI\u0016Dq!a&\u0002\u0004\u0002\u0007\u0011(\u0001\u0007sKN|WO]2f\u001d\u0006lW\r\u0003\u0005\u0002\u001c\u0006\r\u0005\u0019AAO\u00031\u0011Xm]8ve\u000e,w\n\u001d;t!\u0011A\u0017qT\u001d\n\u0007\u0005\u0005&O\u0001\u0003MSN$\bBBAS\u0001\u0011\u00051$A\u0016tQ>,H\u000e\u001a#fg\u000e\u0014\u0018NY3D_:4\u0017n\u001a\"s_.,'oV5uQ>,H/\u00128uSRLh*Y7fQ\r\t\u0019k\t\u0005\b\u0003W\u0003A\u0011AAW\u0003u1XM]5gs\u0006cG/\u001a:Ce>\\WM\u001d'pO\u001e,'oQ8oM&<G#\u0003\u000f\u00020\u0006E\u00161WA\\\u0011!\tY)!+A\u0002\u00055\u0005bBAL\u0003S\u0003\r!\u000f\u0005\b\u0003k\u000bI\u000b1\u0001:\u0003))g\u000e^5us:\u000bW.\u001a\u0005\t\u0003s\u000bI\u000b1\u0001\u0002<\u0006)B-Z:de&\u0014WmQ8oM&<WI\u001c;sS\u0016\u001c\b#\u00025\u0002 \u0006u\u0006\u0003BA`\u0003\u000fl!!!1\u000b\u0007\r\t\u0019M\u0003\u0003\u0002F\u00065\u0014aB2mS\u0016tGo]\u0005\u0005\u0003\u0013\f\tMA\u0006D_:4\u0017nZ#oiJL\bBBAg\u0001\u0011\u00051$A\u0018tQ>,H\u000eZ*vaB|'\u000f^\"p[6\f7+\u001a9be\u0006$X\r\u001a,bYV,7/V:j]\u001eTvn\\6fKB,'\u000fK\u0002\u0002L\u000eBa!a5\u0001\t\u0003Y\u0012AP:i_VdGMT8u+B$\u0017\r^3Ce>\\WM]\"p]\u001aLw-\u00134NC24wN]7fI\u0016sG/\u001b;z\u001d\u0006lW-V:j]\u001eTvn\\6fKB,'\u000fK\u0003\u0002R\u000e*g\r\u0003\u0004\u0002Z\u0002!\taG\u00011g\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\n\u0013xn[3s\u0007>tg-[4JM6\u000bGNZ8s[\u0016$WI\u001c;jift\u0015-\\3)\u000b\u0005]7%\u001a4\t\r\u0005}\u0007\u0001\"\u0001\u001c\u0003-\"Xm\u001d;Es:\fW.[2Ce>\\WM]\"p]\u001aLw-\u00169eCR,Wk]5oOj{wnS3fa\u0016\u0014\bfAAoG!1\u0011Q\u001d\u0001\u0005\u0002m\t!h\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0007>tg-[4Vg&twMW8pW\u0016,\u0007/\u001a:)\u000b\u0005\r8%\u001a4\t\r\u0005-\b\u0001\"\u0001\u001c\u00031\u001a\bn\\;mI:{G/\u00169eCR,'I]8lKJ\u001cuN\u001c4jO&3W*\u00197g_JlW\rZ\"p]\u001aLw\rK\u0003\u0002j\u000e*g\r\u0003\u0004\u0002r\u0002!\taG\u0001Bg\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\n\u0013xn[3s\u0007>tg-[4JM6\u000bGNZ8s[\u0016$'I]1dW\u0016$8i\u001c8gS\u001e,6/\u001b8h5>|7.Z3qKJDS!a<$K\u001aDa!a>\u0001\t\u0003Y\u0012aM:i_VdGMT8u+B$\u0017\r^3Ce>\\WM]\"p]\u001aLw-\u00134NC24wN]7fI\n\u0013\u0018mY6fi\u000e{gNZ5hQ\u0015\t)pI3g\u0011\u0019\ti\u0010\u0001C\u00017\u0005q4\u000f[8vY\u0012tu\u000e^+qI\u0006$XmQ8oM&<\u0017J\u001a(p]\u0016C\u0018n\u001d;j]\u001e\u001cuN\u001c4jO&\u001bH)\u001a7fi\u0016$Wk]5oOj{wn[3qKJDc!a?$K\u0006}\u0003B\u0002B\u0002\u0001\u0011\u00051$A\u0019tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0007>tg-[4JM:{g.\u0012=jgRLgnZ\"p]\u001aLw-S:EK2,G/\u001a3)\r\t\u00051%ZA0\u0011\u0019\u0011I\u0001\u0001C\u00017\u0005A2\u000f[8vY\u0012$U\r\\3uK\n\u0013xn[3s\u0007>tg-[4)\u0007\t\u001d1\u0005\u0003\u0004\u0003\u0010\u0001!\taG\u0001\u0015i\u0016\u001cHoU2sC6\u001c%/\u001a3f]RL\u0017\r\\:)\u0007\t51\u0005\u0003\u0004\u0003\u0016\u0001!\taG\u0001\u0016i\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jO\u0016sG/\u001b;zQ\r\u0011\u0019b\t\u0005\u0007\u00057\u0001A\u0011A\u000e\u0002/Q,7\u000f^+tKJ\u001cE.[3oiF+x\u000e^1PaR\u001c\bf\u0001B\rG!1!\u0011\u0005\u0001\u0005\u0002m\t\u0011\u0004^3tiF+x\u000e^1EKN\u001c'/\u001b2f\u000b:$\u0018\u000e^5fg\"\u001a!qD\u0012\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*\u0005\u0011\"/Z4jgR,'O\u0011:pW\u0016\u0014\u0018J\u001c.l)\ra\"1\u0006\u0005\t\u0005[\u0011)\u00031\u0001\u00030\u0005\u0011\u0011\u000e\u001a\t\u0004;\tE\u0012b\u0001B\u001a=\t\u0019\u0011J\u001c;\u0007\r\t]\u0002\u0001\u0001B\u001d\u0005I!U/\\7z\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0014\t\tU\"1\b\t\u0004\u0013\tu\u0012b\u0001B \u0015\ti\u0011\tZ7j]j[7\t\\5f]RD1Ba\u0011\u00036\t\u0005\t\u0015!\u0003\u0003F\u0005A!p[\"mS\u0016tG\u000fE\u0002\n\u0005\u000fJ1A!\u0013\u000b\u00055Y\u0015MZ6b5.\u001cE.[3oi\"9QC!\u000e\u0005\u0002\t5C\u0003\u0002B(\u0005'\u0002BA!\u0015\u000365\t\u0001\u0001\u0003\u0005\u0003D\t-\u0003\u0019\u0001B#\u0011!\u00119F!\u000e\u0005B\te\u0013AE2iC:<WM\u0011:pW\u0016\u00148i\u001c8gS\u001e$R\u0001\bB.\u0005WB\u0001B!\u0018\u0003V\u0001\u0007!qL\u0001\nEJ|7.\u001a:JIN\u0004bA!\u0019\u0003h\t=RB\u0001B2\u0015\r\u0011)GH\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B5\u0005G\u00121aU3r\u0011!\u0011iG!\u0016A\u0002\t=\u0014aB2p]\u001aLwm\u001d\t\u0005\u0005c\u0012Y(\u0004\u0002\u0003t)!!Q\u000fB<\u0003\u0011)H/\u001b7\u000b\u0005\te\u0014\u0001\u00026bm\u0006LAA! \u0003t\tQ\u0001K]8qKJ$\u0018.Z:\t\u0011\t\u0005%Q\u0007C!\u0005\u0007\u000b\u0011CZ3uG\",e\u000e^5us\u000e{gNZ5h)\u0019\u0011yG!\"\u0003\b\"1\u0011La A\u0002eBq!!.\u0003\u0000\u0001\u0007\u0011\b\u0003\u0005\u0003\f\nUB\u0011\tBG\u0003Q\u0019\u0007.\u00198hK\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jOR)ADa$\u0003\u0014\"9!\u0011\u0013BE\u0001\u0004I\u0014\u0001C2mS\u0016tG/\u00133\t\u0011\t5$\u0011\u0012a\u0001\u0005_B\u0001Ba&\u00036\u0011\u0005#\u0011T\u0001\u001fG\"\fgnZ3Vg\u0016\u0014xJ]+tKJ\u001cE.[3oi&#7i\u001c8gS\u001e$R\u0001\bBN\u0005?CqA!(\u0003\u0016\u0002\u0007\u0011(A\ntC:LG/\u001b>fI\u0016sG/\u001b;z\u001d\u0006lW\r\u0003\u0005\u0003n\tU\u0005\u0019\u0001B8\u0011!\u0011\u0019K!\u000e\u0005B\t\u0015\u0016!E2iC:<W\rV8qS\u000e\u001cuN\u001c4jOR)ADa*\u0003,\"9!\u0011\u0016BQ\u0001\u0004I\u0014!\u0002;pa&\u001c\u0007\u0002\u0003B7\u0005C\u0003\rAa\u001c\t\r\t=\u0006\u0001\"\u0001\u001c\u0003\u0001\"Xm\u001d;SKBd\u0017nY1QY\u0006\u001cW-\\3oiN+Go\u001d)s_B,'\u000f^=)\u0007\t56\u0005\u0003\u0004\u00036\u0002!\taG\u0001$i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\r\u00157bG\u0016lWM\u001c;Qe>\u0004XM\u001d;zQ\u0015\u0011\u0019lI3g\u0011\u0019\u0011Y\f\u0001C\u00017\u0005iC/Z:u\u00132dWmZ1m)>\u001cV\r\u001e*fa2L7-\u0019)mC\u000e,W.\u001a8u/&$\b.\u00113e\u0007>tg-[4)\u000b\te6%\u001a4\u0007\r\t\u0005\u0007\u0001\u0001Bb\u0005A!U/\\7z\u0003\u0012l\u0017N\\\"mS\u0016tGo\u0005\u0003\u0003@\n\u0015\u0007\u0003BA`\u0005\u000fLAA!3\u0002B\nyQj\\2l\u0003\u0012l\u0017N\\\"mS\u0016tG\u000fC\u0006\u0002\f\n}&\u0011!Q\u0001\n\u00055\u0005bB\u000b\u0003@\u0012\u0005!q\u001a\u000b\u0005\u0005#\u0014\u0019\u000e\u0005\u0003\u0003R\t}\u0006\u0002CAF\u0005\u001b\u0004\r!!$\t\u0011\t]'q\u0018C!\u00053\fq\u0002Z3tGJL'-Z\"p]\u001aLwm\u001d\u000b\u0007\u00057\u0014\tOa>\u0011\t\u0005}&Q\\\u0005\u0005\u0005?\f\tMA\u000bEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001cX\u000f\u001c;\t\u0011\t\r(Q\u001ba\u0001\u0005K\f\u0011B]3t_V\u00148-Z:\u0011\r\tE$q\u001dBv\u0013\u0011\u0011IOa\u001d\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0003n\nMXB\u0001Bx\u0015\u0011\u0011\t0!\u001b\u0002\r\r|gNZ5h\u0013\u0011\u0011)Pa<\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dK\"A!\u0011 Bk\u0001\u0004\u0011Y0A\u0004paRLwN\\:\u0011\t\u0005}&Q`\u0005\u0005\u0005\u007f\f\tM\u0001\fEKN\u001c'/\u001b2f\u0007>tg-[4t\u001fB$\u0018n\u001c8t\u0011!\u0019\u0019Aa0\u0005B\r\u0015\u0011aF5oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t)\u0019\u00199a!\u0004\u0004\u001eA!\u0011qXB\u0005\u0013\u0011\u0019Y!!1\u0003%\u0005cG/\u001a:D_:4\u0017nZ:SKN,H\u000e\u001e\u0005\t\u0005[\u001a\t\u00011\u0001\u0004\u0010AA!\u0011OB\t\u0005W\u001c)\"\u0003\u0003\u0004\u0014\tM$aA'baB1!\u0011\u000fBt\u0007/\u0001B!a0\u0004\u001a%!11DAa\u00055\tE\u000e^3s\u0007>tg-[4Pa\"A!\u0011`B\u0001\u0001\u0004\u0019y\u0002\u0005\u0003\u0002@\u000e\u0005\u0012\u0002BB\u0012\u0003\u0003\u00141#\u00117uKJ\u001cuN\u001c4jON|\u0005\u000f^5p]ND\u0001ba\n\u0003@\u0012\u00053\u0011F\u0001\rC2$XM]\"p]\u001aLwm\u001d\u000b\u0007\u0007\u000f\u0019Yc!\u000e\t\u0011\t54Q\u0005a\u0001\u0007[\u0001\u0002B!\u001d\u0004\u0012\t-8q\u0006\t\u0005\u0003\u007f\u001b\t$\u0003\u0003\u00044\u0005\u0005'AB\"p]\u001aLw\r\u0003\u0005\u0003z\u000e\u0015\u0002\u0019AB\u0010\u0001")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigCommandTest$CredentialChange$4$ CredentialChange$2$lzycompute(scala.collection.mutable.Map x$1, VolatileObjectRef x$2) {
        ConfigCommandTest configCommandTest = this;
        synchronized (configCommandTest) {
            if (x$2.elem != null) return (ConfigCommandTest$CredentialChange$4$)((Object)x$2.elem);
            x$2.elem = new ConfigCommandTest$CredentialChange$4$(this, x$1);
            return (ConfigCommandTest$CredentialChange$4$)((Object)x$2.elem);
        }
    }

    @Test
    public void shouldExitWithNonZeroStatusOnArgError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--blah"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT"}));
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandError() {
        this.assertNonZeroStatusExit((String[])((Object[])new String[]{"--bootstrap-server", "invalid host", "--entity-type", "brokers", "--entity-name", "1", "--describe"}));
    }

    private void assertNonZeroStatusExit(String[] args) {
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this, exitStatus){
            public static final long serialVersionUID = 0L;
            private final ObjectRef exitStatus$1;

            public final Nothing$ apply(int status, Option<String> x$1) {
                this.exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
                throw new RuntimeException();
            }
            {
                this.exitStatus$1 = exitStatus$1;
            }
        });
        try {
            try {
                ConfigCommand$.MODULE$.main(args);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    @Test
    public void shouldParseArgumentsForClientsEntityTypeUsingZookeeper() {
        this.testArgumentParse("clients", true);
    }

    @Test
    public void shouldParseArgumentsForUsersEntityTypeUsingZookeeper() {
        this.testArgumentParse("clients", true);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityTypeUsingZookeeper() {
        this.testArgumentParse("topics", true);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics", false);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityTypeUsingZookeeper() {
        this.testArgumentParse("brokers", true);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers", false);
    }

    @Test
    public void shouldParseArgumentsForBrokerLoggersEntityType() {
        this.testArgumentParse("broker-loggers", false);
    }

    public void testArgumentParse(String entityType, boolean zkConfig) {
        String shortFlag = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(entityType)).dropRight(1)}));
        Tuple2 connectOpts = zkConfig ? new Tuple2((Object)"--zookeeper", (Object)this.zkConnect()) : new Tuple2((Object)"--bootstrap-server", (Object)"localhost:9092");
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--describe"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--delete-config", "a,b,c"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"}));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        Assert.assertEquals((long)1L, (long)deletedProps.size());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=,d=e,f="}));
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=,d=e,f="}));
        createOpts.checkArgs();
        Properties addedProps2 = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)4L, (long)addedProps2.size());
        Assert.assertEquals((Object)"b", (Object)addedProps2.getProperty("a"));
        Assert.assertEquals((Object)"e", (Object)addedProps2.getProperty("d"));
        Assert.assertTrue((boolean)addedProps2.getProperty("c").isEmpty());
        Assert.assertTrue((boolean)addedProps2.getProperty("f").isEmpty());
    }

    @Test
    public void testOptionEntityTypeNames() {
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Topic()})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics", "--entity-name", "A"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Broker()})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "0", "--entity-type", "brokers"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", ""})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients", "--entity-name", "A", "--entity-default"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.User(), ConfigType$.MODULE$.Client()})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "B"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-default", "--entity-name", "B", "--entity-type", "users", "--entity-type", "clients"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Topic()})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", "A"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Broker()})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--broker", "0"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Client(), ConfigType$.MODULE$.User()})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B", "A"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user", "A"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Client(), ConfigType$.MODULE$.User()})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B", ""})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user-defaults"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Client(), ConfigType$.MODULE$.User()})), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--entity-name", "A"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Topic()})), List$.MODULE$.empty(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.User()})), List$.MODULE$.empty(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users"}));
        this.testExpectedEntityTypeNames$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Broker()})), List$.MODULE$.empty(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "brokers"}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityTypeUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--broker", "A", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--broker", "A", "--alter", "--add-config", "a=b,c=d"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfMixedEntityTypeFlagsUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "users", "--client", "B", "--describe"}));
        createOpts.checkArgs();
    }

    @Test
    public void shouldAddClientConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            public void changeClientIdConfig(String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(this, this.zkClient()));
    }

    @Test
    public void shouldAddTopicConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(this, this.zkClient()));
    }

    @Test
    public void shouldAlterTopicConfig() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--add-config", "delete.retention.ms=1000000,min.insync.replicas=2", "--delete-config", "unclean.leader.election.enable"}));
        BooleanRef alteredConfigs = BooleanRef.create((boolean)false);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{this.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "1"), this.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", "1")}))).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(this, resourceName, alteredConfigs, describeResult, alterResult, node){
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String resourceName$1;
            private final BooleanRef alteredConfigs$1;
            private final DescribeConfigsResult describeResult$1;
            private final AlterConfigsResult alterResult$1;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$1);
                return this.describeResult$1;
            }

            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.TOPIC, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                Set expectedConfigOps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(this.$outer.kafka$admin$ConfigCommandTest$$newConfigEntry$1("delete.retention.ms", "1000000"), AlterConfigOp.OpType.SET), new AlterConfigOp(this.$outer.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "2"), AlterConfigOp.OpType.SET), new AlterConfigOp(this.$outer.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", ""), AlterConfigOp.OpType.DELETE)}));
                Assert.assertEquals((Object)expectedConfigOps, (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(alterConfigOps).asScala()).toSet());
                this.alteredConfigs$1.elem = true;
                return this.alterResult$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resourceName$1 = resourceName$1;
                this.alteredConfigs$1 = alteredConfigs$1;
                this.describeResult$1 = describeResult$1;
                this.alterResult$1 = alterResult$1;
                super(Collections.singletonList(node$1), node$1);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldDescribeConfigSynonyms() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--describe", "--all"}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(Collections.emptyList())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(this, resource, describeResult, node){
            private final ConfigResource resource$1;
            private final DescribeConfigsResult describeResult$2;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertTrue((String)"Synonyms not requested", (boolean)options.includeSynonyms());
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{this.resource$1})), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(resources).asScala()).toSet());
                return this.describeResult$2;
            }
            {
                this.resource$1 = resource$1;
                this.describeResult$2 = describeResult$2;
                super(Collections.singletonList(node$2), node$2);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.describeConfig((Admin)mockAdminClient, describeOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldAddBrokerQuotaConfig() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10,follower.replication.throttled.rate=20"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"10", (Object)configChange.get("leader.replication.throttled.rate"));
                Assert.assertEquals((Object)"20", (Object)configChange.get("follower.replication.throttled.rate"));
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, alterOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(this, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("kafka.log.LogCleaner", "INFO"), new ConfigEntry("kafka.server.ReplicaManager", "INFO"), new ConfigEntry("kafka.server.KafkaApi", "INFO")})));
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInZKIsAllowed() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", ConfigType$.MODULE$.Broker(), "--describe"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInBootstrapServerIsAllowed() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Broker(), "--describe"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllBrokerConfig() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllTopicConfig() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Topic(), "--entity-name", "foo", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDescribeAllBrokerConfigBootstrapServerRequired() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithDescribeBrokerLoggerIsNotAllowed() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--entity-default", "--describe"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithAlterBrokerLoggerIsNotAllowed() {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--entity-default", "--alter", "--add-config", "kafka.log.LogCleaner=DEBUG"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldRaiseInvalidConfigurationExceptionWhenAddingInvalidBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("kafka.server.KafkaApi", "INFO")})));
    }

    @Test
    public void shouldAddDefaultBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-default"})));
    }

    @Test
    public void shouldAddBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "1", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "1"})));
    }

    public void verifyAlterBrokerConfig(Node node, String resourceName, List<String> resourceOpts) {
        List optsList = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--alter", "--add-config", "message.max.bytes=10"})).$plus$plus(resourceOpts, List$.MODULE$.canBuildFrom());
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        scala.collection.mutable.Map brokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads"), (Object)"5")}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, resourceName);
        java.util.List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("num.io.threads", "5"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(this, node, resourceName, brokerConfigs, describeResult, alterResult){
            private final String resourceName$3;
            public final scala.collection.mutable.Map brokerConfigs$1;
            private final DescribeConfigsResult describeResult$3;
            private final AlterConfigsResult alterResult$2;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$3, (Object)resource.name());
                return this.describeResult$3;
            }

            public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Config> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Config config = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$3 $outer;

                    public final Option<String> apply(ConfigEntry e) {
                        return this.$outer.brokerConfigs$1.put((Object)e.name(), (Object)e.value());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return this.alterResult$2;
            }
            {
                this.resourceName$3 = resourceName$3;
                this.brokerConfigs$1 = brokerConfigs$1;
                this.describeResult$3 = describeResult$3;
                this.alterResult$2 = alterResult$2;
                super(Collections.singletonList(node$4), node$4);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.bytes"), (Object)"10"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num.io.threads"), (Object)"5")})), (Object)brokerConfigs.toMap(Predef$.MODULE$.$conforms()));
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldDescribeConfigBrokerWithoutEntityName() {
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--describe"}));
        String BrokerDefaultEntityName = "";
        ConfigResource resourceCustom = new ConfigResource(ConfigResource.Type.BROKER, "1");
        ConfigResource resourceDefault = new ConfigResource(ConfigResource.Type.BROKER, BrokerDefaultEntityName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        Config emptyConfig = new Config(Collections.emptyList());
        java.util.Map resultMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resourceCustom), (Object)emptyConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resourceDefault), (Object)emptyConfig)}))).asJava();
        future.complete((Object)resultMap);
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).times(2);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(this, resourceCustom, resourceDefault, describeResult, node){
            private final ConfigResource resourceCustom$1;
            private final ConfigResource resourceDefault$1;
            private final DescribeConfigsResult describeResult$4;

            /*
             * Unable to fully structure code
             */
            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertTrue((String)"Synonyms not requested", (boolean)options.includeSynonyms());
                resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                v0 = this.resourceCustom$1.name();
                var4_4 = resource.name();
                if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false)) ** GOTO lbl-1000
                v1 = this.resourceDefault$1.name();
                var5_5 = resource.name();
                if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                Assert.assertTrue((boolean)v2);
                Assert.assertEquals((long)1L, (long)resources.size());
                return this.describeResult$4;
            }
            {
                this.resourceCustom$1 = resourceCustom$1;
                this.resourceDefault$1 = resourceDefault$1;
                this.describeResult$4 = describeResult$4;
                super(Collections.singletonList(node$5), node$5);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.describeConfig((Admin)mockAdminClient, describeOpts);
        EasyMock.verify((Object[])new Object[]{describeResult});
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    public void verifyAlterBrokerLoggerConfig(Node node, String resourceName, String entityName, List<ConfigEntry> describeConfigEntries) {
        List optsList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--alter", "--entity-name", entityName, "--add-config", "kafka.log.LogCleaner=DEBUG", "--delete-config", "kafka.server.ReplicaManager,kafka.server.KafkaApi"}));
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        BooleanRef alteredConfigs = BooleanRef.create((boolean)false);
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(describeConfigEntries).asJava())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(this, node, resourceName, alteredConfigs, describeResult, alterResult){
            private final String resourceName$2;
            private final BooleanRef alteredConfigs$2;
            private final DescribeConfigsResult describeResult$5;
            private final AlterConfigsResult alterResult$3;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$2, (Object)resource.name());
                return this.describeResult$5;
            }

            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                List expectedConfigOps = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "DEBUG"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry("kafka.server.KafkaApi", ""), AlterConfigOp.OpType.DELETE)}));
                Assert.assertEquals((Object)expectedConfigOps, (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(alterConfigOps).asScala()).toList());
                this.alteredConfigs$2.elem = true;
                return this.alterResult$3;
            }
            {
                this.resourceName$2 = resourceName$2;
                this.alteredConfigs$2 = alteredConfigs$2;
                this.describeResult$5 = describeResult$5;
                this.alterResult$3 = alterResult$3;
                super(Collections.singletonList(node$3), node$3);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldSupportCommaSeparatedValuesUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(this, this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityNameUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test
    public void testDynamicBrokerConfigUpdateUsingZooKeeper() {
        String brokerId = "1";
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        String[] alterOpts = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", "brokers", "--alter"});
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"110000")})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"120000")})), (Option)None$.MODULE$, adminZkClient, alterOpts);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"130000")})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"140000")})), (Option)None$.MODULE$, adminZkClient, alterOpts);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"})), (Option)None$.MODULE$, adminZkClient, alterOpts);
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, brokerId, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String brokerId$1;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)new Some((Object)this.brokerId$1), this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.location"), (Object)"/tmp/test.jks")})), (Option)None$.MODULE$, this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        this.deleteAndVerifyConfig$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.ssl.keystore.location"})), (Option)new Some((Object)brokerId), adminZkClient, alterOpts);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, brokerId, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String brokerId$1;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password"), (Object)"secret")})), (Option)new Some((Object)this.brokerId$1), this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.external.ssl.keystore.password"), (Object)"secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"2")}));
        scala.collection.immutable.Map encoderConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Object)"encoder-secret")}));
        this.kafka$admin$ConfigCommandTest$$alterConfigWithZk$1(configs, (Option)new Some((Object)brokerId), encoderConfigs, adminZkClient, alterOpts);
        Properties brokerConfigs = this.zkClient().getEntityConfigs("brokers", brokerId);
        Assert.assertFalse((String)"Encoder secret stored in ZooKeeper", (boolean)brokerConfigs.contains(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()));
        Assert.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs);
        Assert.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assert.assertEquals((long)configs.size(), (long)brokerConfigs.size());
        scala.collection.immutable.Map configs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"listener.name.internal.ssl.keystore.password"), (Object)"secret2")}));
        scala.collection.immutable.Map encoderConfigs2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Object)"encoder-secret"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp()), (Object)"DES/CBC/PKCS5Padding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp()), (Object)"1024"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyFactoryAlgorithmProp()), (Object)"PBKDF2WithHmacSHA1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp()), (Object)"64")}));
        this.kafka$admin$ConfigCommandTest$$alterConfigWithZk$1(configs2, (Option)new Some((Object)brokerId), encoderConfigs2, adminZkClient, alterOpts);
        Properties brokerConfigs2 = this.zkClient().getEntityConfigs("brokers", brokerId);
        String encodedPassword2 = brokerConfigs2.getProperty("listener.name.internal.ssl.keystore.password");
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs).decode(encodedPassword2).value());
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs2).decode(encodedPassword2).value());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, adminZkClient, alterOpts, configs, encoderConfigs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;
            private final scala.collection.immutable.Map configs$1;
            private final scala.collection.immutable.Map encoderConfigs$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$1(this.configs$1, (Option)None$.MODULE$, this.encoderConfigs$1, this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
                this.configs$1 = configs$1;
                this.encoderConfigs$1 = encoderConfigs$1;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.registerBrokerInZk(new StringOps(Predef$.MODULE$.augmentString(brokerId)).toInt());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, brokerId, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String brokerId$1;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"210000")})), (Option)new Some((Object)this.brokerId$1), this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerId$1 = brokerId$1;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, adminZkClient, alterOpts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final AdminZkClient adminZkClient$1;
            private final String[] alterOpts$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"220000")})), (Option)None$.MODULE$, this.$outer.kafka$admin$ConfigCommandTest$$alterConfigWithZk$default$3$1(), this.adminZkClient$1, this.alterOpts$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.adminZkClient$1 = adminZkClient$1;
                this.alterOpts$1 = alterOpts$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.max.size"), (Object)"230000")})), (Option)new Some((Object)"2"), adminZkClient, alterOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"}));
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeletedUsingZookeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeleted() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"}));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(this, resourceName, describeResult, node){
            private final String resourceName$4;
            private final DescribeConfigsResult describeResult$6;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$4);
                return this.describeResult$6;
            }
            {
                this.resourceName$4 = resourceName$4;
                this.describeResult$6 = describeResult$6;
                super(Collections.singletonList(node$6), node$6);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, createOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"}));
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            public final /* synthetic */ ConfigCommandTest $outer;

            /*
             * WARNING - void declaration
             */
            public Properties fetchEntityConfig(String entityType, String entityName) {
                void var3_3;
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return var3_3;
            }

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$TestAdminZkClient$$$outer() {
                return this.$outer;
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(this, this.zkClient()));
    }

    @Test
    public void testScramCredentials() {
        VolatileObjectRef CredentialChange$module = VolatileObjectRef.zero();
        scala.collection.mutable.Map credentials = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        public class Kafka_admin_ConfigCommandTest$CredentialChange$3
        extends AdminZkClient
        implements Product,
        Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            public final /* synthetic */ ConfigCommandTest $outer;
            public final scala.collection.mutable.Map credentials$1;

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Properties apply() {
                        return new Properties();
                    }
                });
            }

            public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1)new Serializable(this, configChange){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Kafka_admin_ConfigCommandTest$CredentialChange$3 $outer;
                    private final Properties configChange$1;

                    public final Object apply(String mechanism) {
                        String value = this.configChange$1.getProperty(mechanism);
                        Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                        ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                        Assert.assertEquals((long)this.$outer.iterations(), (long)scramCredential.iterations());
                        return this.configChange$1 == null ? BoxedUnit.UNIT : this.$outer.credentials$1.put((Object)this.$outer.user(), (Object)this.configChange$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.configChange$1 = configChange$1;
                    }
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$3 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$3(this.kafka$admin$ConfigCommandTest$CredentialChange$$$outer(), user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        object = BoxesRunTime.boxToInteger((int)this.iterations());
                        break;
                    }
                    case 1: {
                        object = this.mechanisms();
                        break;
                    }
                    case 0: {
                        object = this.user();
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.mechanisms()));
                n = Statics.mix((int)n, (int)this.iterations());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Kafka_admin_ConfigCommandTest$CredentialChange$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$3 var4_4 = (Kafka_admin_ConfigCommandTest$CredentialChange$3)((Object)x$1);
                String string = this.user();
                String string2 = var4_4.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var4_4.mechanisms();
                if (set == null) {
                    if (set2 != null) {
                        return false;
                    }
                } else if (!set.equals(set2)) return false;
                if (this.iterations() != var4_4.iterations()) return false;
                if (!var4_4.canEqual((Object)((Object)this))) return false;
                return true;
            }

            public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$CredentialChange$$$outer() {
                return this.$outer;
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$3(ConfigCommandTest $outer, String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                super($outer.zkClient());
                Product.class.$init$((Product)this);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsA, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userA", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}))), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsB, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del256, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"}))), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del512, (AdminZkClient)this.CredentialChange$2(credentials, CredentialChange$module).apply("userB", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), 4096));
    }

    @Test
    public void testQuotaConfigEntity() {
        String[] describeOpts = (String[])((Object[])new String[]{"--describe"});
        String[] alterOpts = (String[])((Object[])new String[]{"--alter", "--add-config", "a=b,c=d"});
        String clientId = "client-1";
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, clientId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String clientId$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)this.clientId$1), this.clientId$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.clientId$1 = clientId$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, principal, sanitizedPrincipal){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String principal$1;
            private final String sanitizedPrincipal$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.sanitizedPrincipal$1, opts);
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts}))).foreach((Function1)new Serializable(this, describeOpts, clientId, principal, sanitizedPrincipal, userClient){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String[] describeOpts$1;
            private final String clientId$1;
            private final String principal$1;
            private final String sanitizedPrincipal$1;
            private final String userClient$1;

            public final void apply(String[] opts) {
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), this.userClient$1, (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)this.principal$1), new StringBuilder().append((Object)this.sanitizedPrincipal$1).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)this.clientId$1).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])this.describeOpts$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1(this.clientId$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                this.$outer.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder().append((Object)ConfigEntityName$.MODULE$.Default()).append((Object)"/clients/").append((Object)ConfigEntityName$.MODULE$.Default()).toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])opts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$admin$ConfigCommandTest$$clientIdOpts$1("")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.describeOpts$1 = describeOpts$1;
                this.clientId$1 = clientId$1;
                this.principal$1 = principal$1;
                this.sanitizedPrincipal$1 = sanitizedPrincipal$1;
                this.userClient$1 = userClient$1;
            }
        });
        this.kafka$admin$ConfigCommandTest$$checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients").toString(), (String[])Predef$.MODULE$.refArrayOps((Object[])describeOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.kafka$admin$ConfigCommandTest$$clientIdOpts$1(clientId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])Predef$.MODULE$.refArrayOps((Object[])alterOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--entity-type", "clients"}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("clients", Sanitizer.sanitize((String)"<default>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/client1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", "/clients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", new StringBuilder().append((Object)Sanitizer.sanitize((String)"CN=user1")).append((Object)"/clients/").append((Object)Sanitizer.sanitize((String)"client1?@%")).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
    }

    @Test
    public void testQuotaDescribeEntities() {
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/").append((Object)clientId).toString();
        String[] opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"});
        this.checkEntities$1(opts, Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/<default>").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-4").toString()})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"});
        this.checkEntities$1(opts, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"})))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkClient);
        opts = (String[])((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients"});
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"users/").append((Object)sanitizedPrincipal).append((Object)"/clients").toString()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"})))}));
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users/<default>/clients"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"})))}));
        this.checkEntities$1(opts, ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"users"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})))}))).$plus$plus((GenTraversableOnce)defaultUserMap).$plus$plus((GenTraversableOnce)userMap), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder().append((Object)sanitizedPrincipal).append((Object)"/clients/client-2").toString()})), zkClient);
    }

    private void registerBrokerInZk(int id) {
        this.zkClient().createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$), ApiVersion$.MODULE$.latestVersion(), 9192);
        this.zkClient().registerBroker(brokerInfo);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaPlacementSetsProperty() {
        Path file = Files.createTempFile("config-command", ".json", new FileAttribute[0]);
        try {
            String content = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"abc\"}}],\"observers\":[]}";
            Files.write(file, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            ConfigCommand.ConfigCommandOptions config = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--entity-name", "1", "--entity-type", "topics", "--alter", "--replica-placement", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file}))}));
            config.checkArgs();
            Properties props = ConfigCommand$.MODULE$.parseConfigsToBeAdded(config);
            Assert.assertEquals((long)1L, (long)props.size());
            Assert.assertEquals((Object)content, (Object)props.getProperty("confluent.placement.constraints"));
        }
        catch (Throwable throwable) {
            void var1_1;
            Files.delete((Path)var1_1);
            throw throwable;
        }
        Files.delete(file);
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=IllegalArgumentException.class)
    public void testInvalidReplicaPlacementProperty() {
        Path file = Files.createTempFile("config-command", ".json", new FileAttribute[0]);
        try {
            String content = "not a json object";
            Files.write(file, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            ConfigCommand.ConfigCommandOptions config = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--entity-name", "1", "--entity-type", "topics", "--alter", "--replica-placement", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file}))}));
            config.checkArgs();
            ConfigCommand$.MODULE$.parseConfigsToBeAdded(config);
        }
        catch (Throwable throwable) {
            void var1_1;
            Files.delete((Path)var1_1);
            throw throwable;
        }
        Files.delete(file);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalToSetReplicaPlacementWithAddConfig() {
        ConfigCommand.ConfigCommandOptions config = new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", "localhost:2181", "--entity-name", "1", "--entity-type", "topics", "--alter", "--add-config", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=anything"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"confluent.placement.constraints"}))}));
        config.checkArgs();
        ConfigCommand$.MODULE$.parseConfigsToBeAdded(config);
    }

    private final void testExpectedEntityTypeNames$1(List expectedTypes, List expectedNames, Seq args) {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe"}).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        createOpts.checkArgs();
        Assert.assertEquals((Object)createOpts.entityTypes(), (Object)expectedTypes);
        Assert.assertEquals((Object)createOpts.entityNames(), (Object)expectedNames);
    }

    public final ConfigEntry kafka$admin$ConfigCommandTest$$newConfigEntry$1(String name, String value) {
        return ConfigTest.newConfigEntry((String)name, (String)value, (ConfigEntry.ConfigSource)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, (boolean)false, (boolean)false, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()));
    }

    private final String[] entityOpt$1(Option brokerId) {
        return (String[])brokerId.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String id) {
                return (String[])((Object[])new String[]{"--entity-name", id});
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return (String[])((Object[])new String[]{"--entity-default"});
            }
        });
    }

    public final void kafka$admin$ConfigCommandTest$$alterConfigWithZk$1(scala.collection.immutable.Map configs, Option brokerId, scala.collection.immutable.Map encoderConfigs, AdminZkClient adminZkClient$1, String[] alterOpts$1) {
        String configStr = ((TraversableOnce)configs.$plus$plus((GenTraversableOnce)encoderConfigs).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])alterOpts$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.entityOpt$1(brokerId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--add-config", configStr}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), addOpts, adminZkClient$1);
    }

    public final scala.collection.immutable.Map kafka$admin$ConfigCommandTest$$alterConfigWithZk$default$3$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void verifyConfig$1(scala.collection.immutable.Map configs, Option brokerId) {
        Properties entityConfigs = this.zkClient().getEntityConfigs("brokers", (String)brokerId.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ConfigEntityName$.MODULE$.Default();
            }
        }));
        Assert.assertEquals((Object)configs, (Object)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(entityConfigs).asScala());
    }

    private final void alterAndVerifyConfig$1(scala.collection.immutable.Map configs, Option brokerId, AdminZkClient adminZkClient$1, String[] alterOpts$1) {
        this.kafka$admin$ConfigCommandTest$$alterConfigWithZk$1(configs, brokerId, this.kafka$admin$ConfigCommandTest$$alterConfigWithZk$default$3$1(), adminZkClient$1, alterOpts$1);
        this.verifyConfig$1(configs, brokerId);
    }

    private final void deleteAndVerifyConfig$1(Set configNames, Option brokerId, AdminZkClient adminZkClient$1, String[] alterOpts$1) {
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])alterOpts$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])this.entityOpt$1(brokerId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--delete-config", configNames.mkString(",")}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), deleteOpts, adminZkClient$1);
        this.verifyConfig$1(Predef$.MODULE$.Map().empty(), brokerId);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config}));
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism}));
    }

    private final ConfigCommandTest$CredentialChange$4$ CredentialChange$2(scala.collection.mutable.Map credentials$1, VolatileObjectRef CredentialChange$module$1) {
        return CredentialChange$module$1.elem == null ? this.CredentialChange$2$lzycompute(credentials$1, CredentialChange$module$1) : (ConfigCommandTest$CredentialChange$4$)((Object)CredentialChange$module$1.elem);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        Option option;
        block4: {
            String[] stringArray;
            String[] optArray;
            block3: {
                block2: {
                    optArray = (String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType});
                    option = entityName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String name = (String)some.x();
                    stringArray = (String[])((Object[])new String[]{"--entity-name", name});
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
            String[] nameArray = stringArray;
            return new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])optArray).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])nameArray), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])otherArgs), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
        throw new MatchError((Object)option);
    }

    public final void kafka$admin$ConfigCommandTest$$checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            Assert.fail((String)"Did not fail with invalid argument list");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public final String[] kafka$admin$ConfigCommandTest$$clientIdOpts$1(String name) {
        return (String[])((Object[])new String[]{"--entity-type", "clients", "--entity-name", name});
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, Seq args) {
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"--zookeeper", this.zkConnect()}).$plus$plus((GenTraversableOnce)args, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, KafkaZkClient zkClient$1) {
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])Predef$.MODULE$.refArrayOps((Object[])opts).$colon$plus((Object)"--describe", ClassTag$.MODULE$.apply(String.class))));
        expectedFetches.foreach((Function1)new Serializable(this, zkClient$1){
            public static final long serialVersionUID = 0L;
            private final KafkaZkClient zkClient$1;

            public final IExpectationSetters<Seq<String>> apply(Tuple2<String, Seq<String>> x0$2) {
                Tuple2<String, Seq<String>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Seq values = (Seq)tuple2._2();
                    IExpectationSetters iExpectationSetters = EasyMock.expect((Object)this.zkClient$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
                    return iExpectationSetters;
                }
                throw new MatchError(tuple2);
            }
            {
                this.zkClient$1 = zkClient$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{zkClient$1});
        Seq entities = entity.getAllEntities(zkClient$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigCommand.ConfigEntity e) {
                return e.fullSanitizedName();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        EasyMock.reset((Object[])new Object[]{zkClient$1});
    }

    public class DummyAdminClient
    extends MockAdminClient {
        public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
            return (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        }

        public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminClient(Node node) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
        }
    }

    public class DummyAdminZkClient
    extends AdminZkClient {
        public void changeBrokerConfig(Seq<Object> brokerIds, Properties configs) {
        }

        public Properties fetchEntityConfig(String entityType, String entityName) {
            return new Properties();
        }

        public void changeClientIdConfig(String clientId, Properties configs) {
        }

        public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        }

        public void changeTopicConfig(String topic, Properties configs) {
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminZkClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminZkClient(KafkaZkClient zkClient) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(zkClient);
        }
    }
}

