/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.RackAwareTest$class;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsIntegrationTest$;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u0001\u001d\u0011\u0011EU3bgNLwM\u001c)beRLG/[8og&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u000b\u0005$W.\u001b8\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u0005i\\\u0017BA\u0007\u000b\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u000e%\u0006\u001c7.Q<be\u0016$Vm\u001d;\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002CA\b\u0001\u0011\u001d9\u0002\u00011A\u0005\u0002a\tqa]3sm\u0016\u00148/F\u0001\u001a!\rQr$I\u0007\u00027)\u0011A$H\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001Z\"aA*fcB\u0011!%J\u0007\u0002G)\u0011A\u0005B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0019\u001a#aC&bM.\f7+\u001a:wKJDq\u0001\u000b\u0001A\u0002\u0013\u0005\u0011&A\u0006tKJ4XM]:`I\u0015\fHC\u0001\u0016/!\tYC&D\u0001\u001e\u0013\tiSD\u0001\u0003V]&$\bbB\u0018(\u0003\u0003\u0005\r!G\u0001\u0004q\u0012\n\u0004BB\u0019\u0001A\u0003&\u0011$\u0001\u0005tKJ4XM]:!\u0011\u001d\u0019\u0004A1A\u0005\u0002Q\nqA\u0019:pW\u0016\u0014\u0018'F\u00016!\tYc'\u0003\u00028;\t\u0019\u0011J\u001c;\t\re\u0002\u0001\u0015!\u00036\u0003!\u0011'o\\6feF\u0002\u0003bB\u001e\u0001\u0005\u0004%\t\u0001N\u0001\bEJ|7.\u001a:3\u0011\u0019i\u0004\u0001)A\u0005k\u0005A!M]8lKJ\u0014\u0004\u0005C\u0004@\u0001\t\u0007I\u0011\u0001\u001b\u0002\u000f\t\u0014xn[3sg!1\u0011\t\u0001Q\u0001\nU\n\u0001B\u0019:pW\u0016\u00148\u0007\t\u0005\b\u0007\u0002\u0011\r\u0011\"\u00015\u0003\u001d\u0011'o\\6feRBa!\u0012\u0001!\u0002\u0013)\u0014\u0001\u00032s_.,'\u000f\u000e\u0011\t\u000f\u001d\u0003!\u0019!C\u0001i\u00059!M]8lKJ,\u0004BB%\u0001A\u0003%Q'\u0001\u0005ce>\\WM]\u001b!\u0011\u001dY\u0005A1A\u0005\u0002Q\nqA\u0019:pW\u0016\u0014h\u0007\u0003\u0004N\u0001\u0001\u0006I!N\u0001\tEJ|7.\u001a:7A!9q\n\u0001b\u0001\n\u0003\u0001\u0016\u0001\u0002:bG.,\u0012!\u0015\t\u0005%V+t+D\u0001T\u0015\t!6$A\u0005j[6,H/\u00192mK&\u0011ak\u0015\u0002\u0004\u001b\u0006\u0004\bC\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0011a\u0017M\\4\u000b\u0003q\u000bAA[1wC&\u0011a,\u0017\u0002\u0007'R\u0014\u0018N\\4\t\r\u0001\u0004\u0001\u0015!\u0003R\u0003\u0015\u0011\u0018mY6!\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003\u0015\u0019X\r^+q)\u0005Q\u0003FA1f!\t17.D\u0001h\u0015\tA\u0017.A\u0003kk:LGOC\u0001k\u0003\ry'oZ\u0005\u0003Y\u001e\u0014aAQ3g_J,\u0007\"\u00028\u0001\t\u0003\u001a\u0017\u0001\u0003;fCJ$un\u001e8)\u00055\u0004\bC\u00014r\u0013\t\u0011xMA\u0003BMR,'\u000fC\u0003u\u0001\u0011\u00051-A\u000buKN$(+Y2l\u0003^\f'/\u001a*fCN\u001c\u0018n\u001a8)\u0005M4\bC\u00014x\u0013\tAxM\u0001\u0003UKN$\b\"\u0002>\u0001\t\u0003\u0019\u0017!\u0006;fgR\u0014V-Y:tS\u001et\u0007+\u0019:uSRLwN\u001c\u0015\u0003sZDQ! \u0001\u0005\u0002\r\fQ\u0003^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC&#7\u000f\u000b\u0002}m\u001e9\u0011\u0011\u0001\u0002\t\u0002\u0005\r\u0011!\t*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]NLe\u000e^3he\u0006$\u0018n\u001c8UKN$\bcA\b\u0002\u0006\u00191\u0011A\u0001E\u0001\u0003\u000f\u0019B!!\u0002\u0002\nA\u00191&a\u0003\n\u0007\u00055QD\u0001\u0004B]f\u0014VM\u001a\u0005\b'\u0005\u0015A\u0011AA\t)\t\t\u0019\u0001\u0003\u0005\u0002\u0016\u0005\u0015A\u0011AA\f\u00031\u0019'/Z1uK\u000e{gNZ5h)\u0011\tI\"a\f\u0011\u0011\u0005m\u0011\u0011EA\u0013\u0003Sq1aKA\u000f\u0013\r\ty\"H\u0001\u0007!J,G-\u001a4\n\u0007Y\u000b\u0019CC\u0002\u0002 u\u0001B!a\u0007\u0002(%\u0019a,a\t\u0011\u0007a\u000bY#C\u0002\u0002.e\u0013aa\u00142kK\u000e$\bBB\f\u0002\u0014\u0001\u0007\u0011\u0004\u0003\u0005\u00024\u0005\u0015A\u0011AA\u001b\u0003E\u0011X-Y:tS\u001etW.\u001a8u\u000b:$(/\u001f\u000b\u0005\u0003o\t9\u0006\u0005\u0004\u0002:\u0005}\u00121I\u0007\u0003\u0003wQ1!!\u0010\\\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00131\b\u0002\t\u001fB$\u0018n\u001c8bYB!\u0011QIA*\u001b\t\t9EC\u0002\u0004\u0003\u0013RA!a\u0013\u0002N\u000591\r\\5f]R\u001c(bA\u0003\u0002P)\u0019\u0011\u0011K5\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t)&a\u0012\u000319+w\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000f\u0003\u0005\u0002Z\u0005E\u0002\u0019AA.\u0003!\u0011X\r\u001d7jG\u0006\u001c\bc\u0001\u000e k!A\u0011qLA\u0003\t\u0003\t\t'A\u0011xC&$hi\u001c:BY2\u0014V-Y:tS\u001etW.\u001a8ugR{7i\\7qY\u0016$X\rF\u0002+\u0003GB\u0001\"!\u001a\u0002^\u0001\u0007\u0011qM\u0001\u0007G2LWM\u001c;\u0011\t\u0005\u0015\u0013\u0011N\u0005\u0005\u0003W\n9EA\u0006BI6Lgn\u00117jK:$\b")
public class ReassignPartitionsIntegrationTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers;
    private final int broker1;
    private final int broker2;
    private final int broker3;
    private final int broker4;
    private final int broker5;
    private final int broker6;
    private final scala.collection.immutable.Map<Object, String> rack;

    public static void waitForAllReassignmentsToComplete(AdminClient adminClient) {
        ReassignPartitionsIntegrationTest$.MODULE$.waitForAllReassignmentsToComplete(adminClient);
    }

    public static Optional<NewPartitionReassignment> reassignmentEntry(Seq<Object> seq) {
        return ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry(seq);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return ReassignPartitionsIntegrationTest$.MODULE$.createConfig(seq);
    }

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest$class.checkReplicaDistribution(this, assignment2, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment2, Map<Object, String> brokerRackMapping) {
        return RackAwareTest$class.getReplicaDistribution(this, assignment2, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest$class.toBrokerMetadata(this, rackMap, brokersWithoutRack);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest$class.checkReplicaDistribution$default$6(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest$class.checkReplicaDistribution$default$7(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest$class.checkReplicaDistribution$default$8(this);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest$class.toBrokerMetadata$default$2(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    public int broker4() {
        return this.broker4;
    }

    public int broker5() {
        return this.broker5;
    }

    public int broker6() {
        return this.broker6;
    }

    public scala.collection.immutable.Map<Object, String> rack() {
        return this.rack;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(6, this.zkConnect(), true, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

            public final KafkaServer apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)this.$outer.rack().apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))).toInt())));
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
                config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
                config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testRackAwareReassign() {
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--disable-rack-aware", "--topic", "foo"}));
        new TopicCommand.ZookeeperTopicService(this.zkClient()).createTopic(createOpts);
        String topicJson = "{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}";
        Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)this.rack().keys().toSeq().sorted((Ordering)Ordering.Int$.MODULE$), topicJson, false);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map proposedAssignment = (Map)tuple2._1();
            Map currentAssignment = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)proposedAssignment, (Object)currentAssignment);
            Map proposedAssignment2 = (Map)tuple23._1();
            Map currentAssignment2 = (Map)tuple23._2();
            Map assignment2 = (Map)proposedAssignment2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicPartition, Seq<Object>> x0$1) {
                    Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)replicas);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
            this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment2, (Map<Object, String>)this.rack(), this.rack().size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testReassignPartition() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ReassignPartitionsIntegrationTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

            public final void apply(AdminClient client) {
                String topic = "test-topic";
                Integer partition = Predef$.MODULE$.int2Integer(0);
                java.util.Map partitionAssignment = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.$outer.broker1()), Predef$.MODULE$.int2Integer(this.$outer.broker2())}))).asJava())}))).asJava();
                NewTopic newTopic = new NewTopic(topic, partitionAssignment);
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()})))))}))).asJava()).all().get();
                ReassignPartitionsIntegrationTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testInvalidReplicaIds() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ReassignPartitionsIntegrationTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

            public final InvalidReplicaAssignmentException apply(AdminClient client) {
                String topic = "test-topic";
                Integer partition = Predef$.MODULE$.int2Integer(0);
                java.util.Map partitionAssignment = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.$outer.broker1()), Predef$.MODULE$.int2Integer(this.$outer.broker2())}))).asJava())}))).asJava();
                NewTopic newTopic = new NewTopic(topic, partitionAssignment);
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                KafkaFuture future = client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker4(), this.$outer.broker5(), this.$outer.broker5()})))))}))).asJava()).all();
                TestUtils.assertFutureThrows((Future)future, InvalidReplicaAssignmentException.class);
                future = client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1, this.$outer.broker3()})))))}))).asJava()).all();
                TestUtils.assertFutureThrows((Future)future, InvalidReplicaAssignmentException.class);
                future = client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, this.$outer.broker2(), this.$outer.broker3()})))))}))).asJava()).all();
                return (InvalidReplicaAssignmentException)TestUtils.assertFutureThrows((Future)future, InvalidReplicaAssignmentException.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public ReassignPartitionsIntegrationTest() {
        RackAwareTest$class.$init$(this);
        this.servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
        this.broker4 = 3;
        this.broker5 = 4;
        this.broker6 = 5;
        this.rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker3())), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker4())), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker5())), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker6())), (Object)"rack3")}));
    }
}

