/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.RackAwareMode;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.api.BaseProducerSendTest$callback$4$;
import kafka.controller.ReplicaAssignment;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug!B\u0001\u0003\u0003\u00039!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002\u000e\u0015\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!)A\u0003\u0001C\u0001+\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001\u0017!\r9BDH\u0007\u00021)\u0011\u0011DG\u0001\u000bG>dG.Z2uS>t'\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uA\"aA*fcB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\r\u0002#aC&bM.\f7i\u001c8gS\u001eD\u0011\"\n\u0001A\u0002\u0003\u0007I\u0011\u0002\u0014\u0002\u0011\r|gn];nKJ,\u0012a\n\t\u0005QE\u001a4'D\u0001*\u0015\t)#F\u0003\u0002,Y\u000591\r\\5f]R\u001c(BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IJ#!D&bM.\f7i\u001c8tk6,'\u000fE\u00025k]j\u0011AG\u0005\u0003mi\u0011Q!\u0011:sCf\u0004\"\u0001\u000e\u001d\n\u0005eR\"\u0001\u0002\"zi\u0016D\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001f\u0002\u0019\r|gn];nKJ|F%Z9\u0015\u0005u\u0002\u0005C\u0001\u001b?\u0013\ty$D\u0001\u0003V]&$\bbB!;\u0003\u0003\u0005\raJ\u0001\u0004q\u0012\n\u0004BB\"\u0001A\u0003&q%A\u0005d_:\u001cX/\\3sA!9Q\t\u0001b\u0001\n\u00131\u0015!\u00039s_\u0012,8-\u001a:t+\u00059\u0005c\u0001%L\u001b6\t\u0011J\u0003\u0002K1\u00059Q.\u001e;bE2,\u0017B\u0001'J\u0005\u0019\u0011UO\u001a4feB!a*U\u001a4\u001b\u0005y%B\u0001)+\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018B\u0001*P\u00055Y\u0015MZ6b!J|G-^2fe\"1A\u000b\u0001Q\u0001\n\u001d\u000b!\u0002\u001d:pIV\u001cWM]:!\u0011\u001d1\u0006A1A\u0005\u0012]\u000bQ\u0001^8qS\u000e,\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000bA\u0001\\1oO*\tQ,\u0001\u0003kCZ\f\u0017BA0[\u0005\u0019\u0019FO]5oO\"1\u0011\r\u0001Q\u0001\na\u000ba\u0001^8qS\u000e\u0004\u0003bB2\u0001\u0005\u0004%I\u0001Z\u0001\u000b]Vl'+Z2pe\u0012\u001cX#A3\u0011\u0005Q2\u0017BA4\u001b\u0005\rIe\u000e\u001e\u0005\u0007S\u0002\u0001\u000b\u0011B3\u0002\u00179,XNU3d_J$7\u000f\t\u0005\u0006W\u0002!\t\u0005\\\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002{!\u0012!N\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c>\nQA[;oSRL!a\u001d9\u0003\r\t+gm\u001c:f\u0011\u0015)\b\u0001\"\u0011m\u0003!!X-\u0019:E_^t\u0007F\u0001;x!\ty\u00070\u0003\u0002za\n)\u0011I\u001a;fe\")1\u0010\u0001C\ty\u0006q1M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014HCD'~\u0003\u0017\ty!a\u0005\u0002\u0018\u0005m\u0011Q\u0005\u0005\u0006}j\u0004\ra`\u0001\u000bEJ|7.\u001a:MSN$\b\u0003BA\u0001\u0003\u000fq1\u0001NA\u0002\u0013\r\t)AG\u0001\u0007!J,G-\u001a4\n\u0007}\u000bIAC\u0002\u0002\u0006iA\u0001\"!\u0004{!\u0003\u0005\r!Z\u0001\tY&tw-\u001a:Ng\"A\u0011\u0011\u0003>\u0011\u0002\u0003\u0007Q-A\teK2Lg/\u001a:z)&lWm\\;u\u001bND\u0001\"!\u0006{!\u0003\u0005\r!Z\u0001\nE\u0006$8\r[*ju\u0016D\u0001\"!\u0007{!\u0003\u0005\ra`\u0001\u0010G>l\u0007O]3tg&|g\u000eV=qK\"I\u0011Q\u0004>\u0011\u0002\u0003\u0007\u0011qD\u0001\u000b[\u0006D(\t\\8dW6\u001b\bc\u0001\u001b\u0002\"%\u0019\u00111\u0005\u000e\u0003\t1{gn\u001a\u0005\n\u0003OQ\b\u0013!a\u0001\u0003?\t!BY;gM\u0016\u00148+\u001b>f\u0011\u001d\tY\u0003\u0001C\t\u0003[\t\u0001C]3hSN$XM\u001d)s_\u0012,8-\u001a:\u0015\u00075\u000by\u0003\u0003\u0004Q\u0003S\u0001\r!\u0014\u0005\u0007\u0003g\u0001A\u0011\u00017\u0002\u001dQ,7\u000f^*f]\u0012|eMZ:fi\"\"\u0011\u0011GA\u001c!\ry\u0017\u0011H\u0005\u0004\u0003w\u0001(\u0001\u0002+fgRDa!a\u0010\u0001\t\u0003a\u0017a\n;fgR\u001cVM\u001c3D_6\u0004(/Z:tK\u0012lUm]:bO\u0016<\u0016\u000e\u001e5De\u0016\fG/\u001a+j[\u0016DC!!\u0010\u00028!1\u0011Q\t\u0001\u0005\u00021\f!\u0006^3tiN+g\u000e\u001a(p]\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\r\u000b\u0003\u0002D\u0005]\u0002bBA&\u0001\u0011E\u0011QJ\u0001\u000eg\u0016tG-\u00118e-\u0016\u0014\u0018NZ=\u0015\u000fu\ny%!\u0015\u0002T!1\u0001+!\u0013A\u00025C\u0001bYA%!\u0003\u0005\r!\u001a\u0005\u000b\u0003+\nI\u0005%AA\u0002\u0005}\u0011!\u0003;j[\u0016|W\u000f^'t\u0011\u001d\tI\u0006\u0001C\t\u00037\nac]3oI\u0006sGMV3sS\u001aLH+[7fgR\fW\u000e\u001d\u000b\u0006{\u0005u\u0013q\f\u0005\u0007!\u0006]\u0003\u0019A'\t\u0011\u0005\u0005\u0014q\u000ba\u0001\u0003G\nQ\u0002^5nKN$\u0018-\u001c9UsB,\u0007\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0007\u00055D&\u0001\u0004d_6lwN\\\u0005\u0005\u0003c\n9GA\u0007US6,7\u000f^1naRK\b/\u001a\u0005\u0007\u0003k\u0002A\u0011\u00017\u0002\u0013Q,7\u000f^\"m_N,\u0007\u0006BA:\u0003oAa!a\u001f\u0001\t\u0003a\u0017a\u0005;fgR\u001cVM\u001c3U_B\u000b'\u000f^5uS>t\u0007\u0006BA=\u0003oAa!!!\u0001\t\u0003a\u0017\u0001\u000b;fgR\u001cVM\u001c3CK\u001a|'/Z!oI\u00063G/\u001a:QCJ$\u0018\u000e^5p]\u0016C\b/\u00198tS>t\u0007\u0006BA@\u0003oAa!a\"\u0001\t\u0003a\u0017!\u0003;fgR4E.^:iQ\u0011\t))a\u000e\t\r\u00055\u0005\u0001\"\u0001m\u0003!\"Xm\u001d;DY>\u001cXmV5uQj+'o\u001c+j[\u0016|W\u000f\u001e$s_6\u001c\u0015\r\u001c7feRC'/Z1eQ\u0011\tY)a\u000e\t\r\u0005M\u0005\u0001\"\u0001m\u0003!\"Xm\u001d;DY>\u001cXmV5uQj+'o\u001c+j[\u0016|W\u000f\u001e$s_6\u001cVM\u001c3feRC'/Z1eQ\u0011\t\t*a\u000e\t\u0013\u0005e\u0005!%A\u0005\u0012\u0005m\u0015\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0014\u0016\u0004K\u0006}5FAAQ!\u0011\t\u0019+!,\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-&$\u0001\u0006b]:|G/\u0019;j_:LA!a,\u0002&\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005M\u0006!%A\u0005\u0012\u0005m\u0015\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011q\u0017\u0001\u0012\u0002\u0013E\u00111T\u0001\u0019GJ,\u0017\r^3Qe>$WoY3sI\u0011,g-Y;mi\u0012\"\u0004\"CA^\u0001E\u0005I\u0011CA_\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003\u007fS3a`AP\u0011%\t\u0019\rAI\u0001\n#\t)-\u0001\rde\u0016\fG/\u001a)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIY*\"!a2+\t\u0005}\u0011q\u0014\u0005\n\u0003\u0017\u0004\u0011\u0013!C\t\u0003\u000b\f\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0011%\ty\rAI\u0001\n#\tY*A\ftK:$\u0017I\u001c3WKJLg-\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u00111\u001b\u0001\u0012\u0002\u0013E\u0011QY\u0001\u0018g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=%I\u00164\u0017-\u001e7uIM\u0002")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> kafka$api$BaseProducerSendTest$$consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1$lzycompute(int x$1, VolatileObjectRef x$2) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$2.elem != null) return (BaseProducerSendTest$callback$3$)x$2.elem;
            x$2.elem = new BaseProducerSendTest$callback$3$(this, x$1);
            return (BaseProducerSendTest$callback$3$)x$2.elem;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2$lzycompute(TimestampType x$1, int x$2, long x$3, long x$4, VolatileObjectRef x$5) {
        BaseProducerSendTest baseProducerSendTest = this;
        synchronized (baseProducerSendTest) {
            if (x$5.elem != null) return (BaseProducerSendTest$callback$4$)x$5.elem;
            x$5.elem = new BaseProducerSendTest$callback$4$(this, x$1, x$2, x$3, x$4);
            return (BaseProducerSendTest$callback$4$)x$5.elem;
        }
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)4)).toString());
        int x$19 = numServers;
        String x$20 = this.zkConnect();
        boolean x$21 = false;
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$23 = this.trustStoreFile();
        Option<Properties> x$24 = this.serverSaslProperties();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$30 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$31 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$33 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$34 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$19, x$20, x$21, x$25, (Option<SecurityProtocol>)x$22, x$23, x$24, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34).map((Function1)new Serializable(this, overridingProps){
            public static final long serialVersionUID = 0L;
            private final Properties overridingProps$1;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps$1);
            }
            {
                this.overridingProps$1 = overridingProps$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public KafkaConsumer<byte[], byte[]> kafka$api$BaseProducerSendTest$$consumer() {
        return this.kafka$api$BaseProducerSendTest$$consumer;
    }

    private void kafka$api$BaseProducerSendTest$$consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.kafka$api$BaseProducerSendTest$$consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$35 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$36 = SecurityProtocol.PLAINTEXT;
        String x$37 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$38 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$39 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$40 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$41 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$42 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$43 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$44 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$45 = TestUtils$.MODULE$.createConsumer$default$11();
        this.kafka$api$BaseProducerSendTest$$consumer_$eq(TestUtils$.MODULE$.createConsumer(x$35, x$37, x$38, x$39, x$40, x$41, x$36, x$42, x$43, x$44, x$45));
    }

    @Override
    @After
    public void tearDown() {
        this.kafka$api$BaseProducerSendTest$$consumer().close();
        this.producers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaProducer<byte[], byte[]> x$2) {
                x$2.close();
            }
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int lingerMs, int deliveryTimeoutMs, int batchSize, String compressionType, long maxBlockMs, long bufferSize) {
        String x$46 = brokerList;
        String x$47 = compressionType;
        SecurityProtocol x$48 = this.securityProtocol();
        Option<File> x$49 = this.trustStoreFile();
        Option<Properties> x$50 = this.clientSaslProperties();
        int x$51 = lingerMs;
        int x$52 = deliveryTimeoutMs;
        long x$53 = maxBlockMs;
        int x$54 = batchSize;
        long x$55 = bufferSize;
        int x$56 = TestUtils$.MODULE$.createProducer$default$2();
        int x$57 = TestUtils$.MODULE$.createProducer$default$5();
        int x$58 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$59 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$60 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$61 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$46, x$56, x$53, x$55, x$57, x$52, x$51, x$54, x$47, x$58, x$48, x$49, x$50, x$59, x$60, x$61);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public int createProducer$default$3() {
        return 120000;
    }

    public int createProducer$default$4() {
        return 16384;
    }

    public String createProducer$default$5() {
        return "none";
    }

    public long createProducer$default$6() {
        return 60000L;
    }

    public long createProducer$default$7() {
        return 0x100000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    @Test
    public void testSendOffset() {
        VolatileObjectRef callback$module = VolatileObjectRef.zero();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());
        int partition = 0;
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
                producer.send(record4, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module));
                throw Assertions$.MODULE$.fail("Should not allow sending a record without topic", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, partition, record0, callback$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$1;
                    private final int partition$1;
                    private final ProducerRecord record0$1;
                    private final VolatileObjectRef callback$module$1;

                    public final Future<RecordMetadata> apply(int _) {
                        return this.producer$1.send(this.record0$1, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$1(this.partition$1, this.callback$module$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$1 = producer$1;
                        this.partition$1 = partition$1;
                        this.record0$1 = record0$1;
                        this.callback$module$1 = callback$module$1;
                    }
                });
                Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)(this.kafka$api$BaseProducerSendTest$$numRecords() + 4))).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.kafka$api$BaseProducerSendTest$$callback$1(partition, callback$module)).get()).offset());
            }
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        String x$62 = this.brokerList();
        String x$63 = "gzip";
        int x$64 = Integer.MAX_VALUE;
        int x$65 = Integer.MAX_VALUE;
        int x$66 = this.createProducer$default$4();
        long x$67 = this.createProducer$default$6();
        long x$68 = this.createProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$62, x$64, x$65, x$66, x$63, x$67, x$68);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1)new Serializable(this, producer, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$3;
                private final int partition$2;

                public final Future<RecordMetadata> apply(int i) {
                    ProducerRecord record = new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$2), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8));
                    return this.producer$3.send(record);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$3 = producer$3;
                    this.partition$2 = partition$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(Duration.ofMillis(timeoutMs));
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$2;

                public final int apply(int offset, Future<RecordMetadata> future) {
                    RecordMetadata recordMetadata = future.get();
                    Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                    Assert.assertEquals((long)this.partition$2, (long)recordMetadata.partition());
                    Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                    return offset + 1;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$2 = partition$2;
                }
            }));
            Assert.assertEquals((long)numRecords, (long)lastOffset);
            return;
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        VolatileObjectRef callback$module = VolatileObjectRef.zero();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            Object object = !(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) ? topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime") : topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            this.createTopic(this.topic(), 1, 2, topicProps);
            IndexedSeq recordAndFutures = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, timestampType, partition, baseTimestamp, startTime, callback$module){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$2;
                private final TimestampType timestampType$1;
                private final int partition$3;
                private final long baseTimestamp$1;
                private final long startTime$1;
                private final VolatileObjectRef callback$module$2;

                public final Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> apply(int i) {
                    ProducerRecord record = new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$3), Predef$.MODULE$.long2Long(this.baseTimestamp$1 + (long)i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(StandardCharsets.UTF_8));
                    return new Tuple2((Object)record, (Object)this.producer$2.send(record, (Callback)this.$outer.kafka$api$BaseProducerSendTest$$callback$2(this.timestampType$1, this.partition$3, this.baseTimestamp$1, this.startTime$1, this.callback$module$2)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$2 = producer$2;
                    this.timestampType$1 = timestampType$1;
                    this.partition$3 = partition$3;
                    this.baseTimestamp$1 = baseTimestamp$1;
                    this.startTime$1 = startTime$1;
                    this.callback$module$2 = callback$module$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            producer.close(Duration.ofSeconds(20L));
            recordAndFutures.foreach((Function1)new Serializable(this, timestampType, startTime){
                public static final long serialVersionUID = 0L;
                private final TimestampType timestampType$1;
                private final long startTime$1;

                public final void apply(Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> x0$1) {
                    Tuple2<ProducerRecord<byte[], byte[]>, Future<RecordMetadata>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        ProducerRecord record = (ProducerRecord)tuple2._1();
                        Future future = (Future)tuple2._2();
                        RecordMetadata recordMetadata = (RecordMetadata)future.get();
                        TimestampType timestampType = this.timestampType$1;
                        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
                        if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                            Assert.assertTrue((recordMetadata.timestamp() >= this.startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Assert.assertEquals((Object)record.timestamp(), (Object)BoxesRunTime.boxToLong((long)recordMetadata.timestamp()));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.timestampType$1 = timestampType$1;
                    this.startTime$1 = startTime$1;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have offset ", " but only successfully sent ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords()), BoxesRunTime.boxToLong((long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset())})), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.kafka$api$BaseProducerSendTest$$callback$2(timestampType, partition, baseTimestamp, startTime, callback$module).offset());
            return;
        }
        finally {
            producer.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClose() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this, producer, record0){
                public static final long serialVersionUID = 0L;
                private final KafkaProducer producer$4;
                private final ProducerRecord record0$2;

                public final Future<RecordMetadata> apply(int _) {
                    return this.producer$4.send(this.record0$2);
                }
                {
                    this.producer$4 = producer$4;
                    this.record0$2 = record0$2;
                }
            });
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder().append((Object)"Should have offset ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$api$BaseProducerSendTest$$numRecords())).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendToPartition() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());
        try {
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            int partition = 1;
            long now = System.currentTimeMillis();
            IndexedSeq futures = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final KafkaProducer producer$5;
                private final int partition$4;
                private final long now$1;

                public final Future<RecordMetadata> apply(int i) {
                    return this.producer$5.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition$4), Predef$.MODULE$.long2Long(this.now$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$5 = producer$5;
                    this.partition$4 = partition$4;
                    this.now$1 = now$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RecordMetadata apply(Future<RecordMetadata> x$3) {
                    return x$3.get(30L, TimeUnit.SECONDS);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            ((TraversableLike)futures.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$1) {
                    Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, partition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$4;

                public final void apply(Tuple2<RecordMetadata, Object> x$4) {
                    Tuple2<RecordMetadata, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                        int offset = tuple2._2$mcI$sp();
                        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                        Assert.assertEquals((long)this.partition$4, (long)recordMetadata.partition());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$4 = partition$4;
                }
            });
            this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
            Seq<ConsumerRecord<byte[], byte[]>> records2 = TestUtils$.MODULE$.consumeRecords(this.kafka$api$BaseProducerSendTest$$consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.consumeRecords$default$3());
            ((IterableLike)records2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, partition, now){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                private final int partition$4;
                private final long now$1;

                public final void apply(Tuple2<ConsumerRecord<byte[], byte[]>, Object> x0$2) {
                    Tuple2<ConsumerRecord<byte[], byte[]>, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        ConsumerRecord record = (ConsumerRecord)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        Assert.assertEquals((Object)this.$outer.topic(), (Object)record.topic());
                        Assert.assertEquals((long)this.partition$4, (long)record.partition());
                        Assert.assertEquals((long)i, (long)record.offset());
                        Assert.assertNull((Object)record.key());
                        Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i + 1))})), (Object)new String((byte[])record.value()));
                        Assert.assertEquals((long)this.now$1, (long)record.timestamp());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.partition$4 = partition$4;
                    this.now$1 = now$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        String x$69 = this.brokerList();
        long x$70 = 5000L;
        int x$71 = this.createProducer$default$2();
        int x$72 = this.createProducer$default$3();
        int x$73 = this.createProducer$default$4();
        String x$74 = this.createProducer$default$5();
        long x$75 = this.createProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$69, x$71, x$72, x$73, x$74, x$70, x$75);
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition0 = 0;
        IndexedSeq futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final KafkaProducer producer$6;
            private final int partition0$1;

            public final Future<RecordMetadata> apply(int i) {
                return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition0$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$6 = producer$6;
                this.partition0$1 = partition0$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$5) {
                return x$5.get(30L, TimeUnit.SECONDS);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$2) {
                Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, partition0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final int partition0$1;

            public final void apply(Tuple2<RecordMetadata, Object> x$6) {
                Tuple2<RecordMetadata, Object> tuple2 = x$6;
                if (tuple2 != null) {
                    RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                    int offset = tuple2._2$mcI$sp();
                    Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                    Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                    Assert.assertEquals((long)this.partition0$1, (long)recordMetadata.partition());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition0$1 = partition0$1;
            }
        });
        int partition1 = 1;
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get();
            throw Assertions$.MODULE$.fail("Should not allow sending a record to a partition not present in the metadata", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof TimeoutException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, ReplicaAssignment> apply(Tuple2<TopicPartition, ReplicaAssignment> x0$3) {
                        Tuple2<TopicPartition, ReplicaAssignment> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = (TopicPartition)tuple2._1();
                            ReplicaAssignment assignment2 = (ReplicaAssignment)tuple2._2();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)assignment2);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom());
                AdminZkClient qual$1 = this.adminZkClient();
                String x$78 = this.topic();
                Map x$79 = existingAssignment;
                AdminZkClient qual$2 = this.adminZkClient();
                RackAwareMode x$76 = qual$2.getBrokerMetadatas$default$1();
                Option x$77 = qual$2.getBrokerMetadatas$default$2();
                Seq x$80 = qual$2.getBrokerMetadatas(x$76, x$77);
                int x$81 = 2;
                None$ x$82 = None$.MODULE$;
                Option x$83 = qual$1.addPartitions$default$5();
                boolean x$84 = qual$1.addPartitions$default$6();
                qual$1.addPartitions(x$78, x$79, x$80, x$81, x$83, x$84, (Option)x$82);
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
                IndexedSeq futures1 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$6;
                    private final int partition1$1;

                    public final Future<RecordMetadata> apply(int i) {
                        return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition1$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$6 = producer$6;
                        this.partition1$1 = partition1$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                        return x$7.get(30L, TimeUnit.SECONDS);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                ((TraversableLike)futures1.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$3) {
                        Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$3;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, partition1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final int partition1$1;

                    public final void apply(Tuple2<RecordMetadata, Object> x$8) {
                        Tuple2<RecordMetadata, Object> tuple2 = x$8;
                        if (tuple2 != null) {
                            RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                            int offset = tuple2._2$mcI$sp();
                            Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                            Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                            Assert.assertEquals((long)this.partition1$1, (long)recordMetadata.partition());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partition1$1 = partition1$1;
                    }
                });
                futures0 = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer, partition0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final KafkaProducer producer$6;
                    private final int partition0$1;

                    public final Future<RecordMetadata> apply(int i) {
                        return this.producer$6.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(this.partition0$1), null, (Object)new StringBuilder().append((Object)"value").append((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(StandardCharsets.UTF_8)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$6 = producer$6;
                        this.partition0$1 = partition0$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RecordMetadata apply(Future<RecordMetadata> x$9) {
                        return x$9.get(30L, TimeUnit.SECONDS);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                ((TraversableLike)futures0.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<RecordMetadata, Object> check$ifrefutable$4) {
                        Tuple2<RecordMetadata, Object> tuple2 = check$ifrefutable$4;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, partition0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BaseProducerSendTest $outer;
                    private final int partition0$1;

                    public final void apply(Tuple2<RecordMetadata, Object> x$10) {
                        Tuple2<RecordMetadata, Object> tuple2 = x$10;
                        if (tuple2 != null) {
                            RecordMetadata recordMetadata = (RecordMetadata)tuple2._1();
                            int offset = tuple2._2$mcI$sp();
                            Assert.assertEquals((long)offset, (long)recordMetadata.offset());
                            Assert.assertEquals((Object)this.$outer.topic(), (Object)recordMetadata.topic());
                            Assert.assertEquals((long)this.partition0$1, (long)recordMetadata.partition());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partition0$1 = partition0$1;
                    }
                });
                return;
            }
            throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFlush() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());
        try {
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, producer, record){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BaseProducerSendTest $outer;
                public final KafkaProducer producer$7;
                public final ProducerRecord record$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testFlush$1 $outer;

                        public final Future<RecordMetadata> apply(int x$11) {
                            return this.$outer.producer$7.send(this.$outer.record$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$12) {
                            return !x$12.isDone();
                        }
                    }));
                    this.producer$7.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$13) {
                            return x$13.isDone();
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.producer$7 = producer$7;
                    this.record$1 = record$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
        int partition = 0;
        this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, record0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            public final ProducerRecord record0$3;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                KafkaProducer<byte[], byte[]> producer = this.$outer.createProducer(this.$outer.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.$outer.createProducer$default$4(), this.$outer.createProducer$default$5(), this.$outer.createProducer$default$6(), this.$outer.createProducer$default$7());
                IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromCallerThread$1 $outer;
                    private final KafkaProducer producer$8;

                    public final Future<RecordMetadata> apply(int x$14) {
                        return this.producer$8.send(this.$outer.record0$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.producer$8 = producer$8;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Future<RecordMetadata> x$15) {
                        return !x$15.isDone();
                    }
                }));
                producer.close(Duration.ZERO);
                responses.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Future<RecordMetadata> future) {
                        try {
                            future.get();
                            throw Assertions$.MODULE$.fail("No message should be sent successfully.", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
                        }
                        catch (ExecutionException executionException) {
                            Assert.assertEquals(KafkaException.class, executionException.getCause().getClass());
                            return;
                        }
                    }
                });
                Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)this.$outer.kafka$api$BaseProducerSendTest$$consumer().poll(Duration.ofMillis(50L)).count());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record0$3 = record0$3;
            }
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition = 0;
        this.kafka$api$BaseProducerSendTest$$consumer().assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseProducerSendTest $outer;
            public final ProducerRecord record$2;

            /*
             * WARNING - void declaration
             */
            public final Seq<ConsumerRecord<byte[], byte[]>> apply(int i) {
                Seq<ConsumerRecord<byte[], byte[]>> seq;
                KafkaProducer<byte[], byte[]> producer = this.$outer.createProducer(this.$outer.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.$outer.createProducer$default$4(), this.$outer.createProducer$default$5(), this.$outer.createProducer$default$6(), this.$outer.createProducer$default$7());
                try {
                    IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1)new Serializable(this, producer){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testCloseWithZeroTimeoutFromSenderThread$1 $outer;
                        private final KafkaProducer producer$9;

                        public final Future<RecordMetadata> apply(int i) {
                            public class Kafka_api_BaseProducerSendTest$CloseCallback$1
                            implements Callback {
                                public final KafkaProducer<byte[], byte[]> kafka$api$BaseProducerSendTest$CloseCallback$$producer;
                                private final boolean sendRecords;
                                public final /* synthetic */ BaseProducerSendTest $outer;
                                public final ProducerRecord record$2;

                                public void onCompletion(RecordMetadata metadata, Exception exception) {
                                    if (this.sendRecords) {
                                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$CloseCallback$$$outer().kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ Kafka_api_BaseProducerSendTest$CloseCallback$1 $outer;

                                            public final Future<RecordMetadata> apply(int x$16) {
                                                return this.$outer.kafka$api$BaseProducerSendTest$CloseCallback$$producer.send(this.$outer.record$2);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close(Duration.ZERO);
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer.close();
                                }

                                public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$CloseCallback$$$outer() {
                                    return this.$outer;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public Kafka_api_BaseProducerSendTest$CloseCallback$1(BaseProducerSendTest $outer, KafkaProducer<byte[], byte[]> producer, boolean sendRecords2) {
                                    void var4_4;
                                    this.kafka$api$BaseProducerSendTest$CloseCallback$$producer = producer;
                                    this.sendRecords = sendRecords2;
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.record$2 = var4_4;
                                }
                            }
                            return this.producer$9.send(this.$outer.record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1(this.$outer.kafka$api$BaseProducerSendTest$$anonfun$$$outer(), this.producer$9, i == 0, this.$outer.record$2));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.producer$9 = producer$9;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$17) {
                            return !x$17.isDone();
                        }
                    }));
                    producer.flush();
                    Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Future<RecordMetadata> x$18) {
                            return x$18.isDone();
                        }
                    }));
                    seq = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(this.$outer.kafka$api$BaseProducerSendTest$$consumer(), this.$outer.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                }
                catch (Throwable throwable) {
                    void var2_2;
                    var2_2.close();
                    throw throwable;
                }
                producer.close();
                return seq;
            }

            public /* synthetic */ BaseProducerSendTest kafka$api$BaseProducerSendTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = record$2;
            }
        });
    }

    public final BaseProducerSendTest$callback$3$ kafka$api$BaseProducerSendTest$$callback$1(int partition$1, VolatileObjectRef callback$module$1) {
        return callback$module$1.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$1$lzycompute(partition$1, callback$module$1) : (BaseProducerSendTest$callback$3$)callback$module$1.elem;
    }

    public final BaseProducerSendTest$callback$4$ kafka$api$BaseProducerSendTest$$callback$2(TimestampType timestampType$1, int partition$3, long baseTimestamp$1, long startTime$1, VolatileObjectRef callback$module$2) {
        return callback$module$2.elem == null ? this.kafka$api$BaseProducerSendTest$$callback$2$lzycompute(timestampType$1, partition$3, baseTimestamp$1, startTime$1, callback$module$2) : (BaseProducerSendTest$callback$4$)callback$module$2.elem;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

