/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.BaseAdminIntegrationTest;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.api.PlaintextAdminIntegrationTest$$anonfun$testDescribeLogDirs$1$;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.Defaults$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.EligibleLeadersNotAvailableException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005b\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0004\u00157bS:$X\r\u001f;BI6Lg.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u00031\t\u000b7/Z!e[&t\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fC\u0003\u000e\u0001\u0011\u0005a\"\u0001\u0004=S:LGO\u0010\u000b\u0002\u001fA\u0011\u0011\u0002\u0001\u0005\u0006#\u0001!\tAE\u0001\fi&,'OR3biV\u0014X-F\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u001d\u0011un\u001c7fC:DQA\u0007\u0001\u0005Bm\t1\u0002\\8h\t&\u00148i\\;oiV\tA\u0004\u0005\u0002\u0015;%\u0011a$\u0006\u0002\u0004\u0013:$\bb\u0002\u0011\u0001\u0005\u0004%\t!I\u0001\u0006i>\u0004\u0018nY\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AB*ue&tw\r\u0003\u0004,\u0001\u0001\u0006IAI\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f5\u0002!\u0019!C\u00017\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005C\u00042\u0001\t\u0007I\u0011\u0001\u001a\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t1\u0007\u0005\u00025y5\tQG\u0003\u00027o\u000511m\\7n_:T!!\u0002\u001d\u000b\u0005eR\u0014AB1qC\u000eDWMC\u0001<\u0003\ry'oZ\u0005\u0003{U\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004@\u0001\u0001\u0006IaM\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA!I\u0011\t\u0001a\u0001\u0002\u0004%IAQ\u0001\u001bEJ|7.\u001a:M_\u001e<WM]\"p]\u001aLwMU3t_V\u00148-Z\u000b\u0002\u0007B\u0011AiR\u0007\u0002\u000b*\u0011a)N\u0001\u0007G>tg-[4\n\u0005!+%AD\"p]\u001aLwMU3t_V\u00148-\u001a\u0005\n\u0015\u0002\u0001\r\u00111A\u0005\n-\u000baD\u0019:pW\u0016\u0014Hj\\4hKJ\u001cuN\u001c4jOJ+7o\\;sG\u0016|F%Z9\u0015\u00051{\u0005C\u0001\u000bN\u0013\tqUC\u0001\u0003V]&$\bb\u0002)J\u0003\u0003\u0005\raQ\u0001\u0004q\u0012\n\u0004B\u0002*\u0001A\u0003&1)A\u000ece>\\WM\u001d'pO\u001e,'oQ8oM&<'+Z:pkJ\u001cW\r\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003Q\u0019\u0007.\u00198hK\u0012\u0014%o\\6fe2{wmZ3sgV\ta\u000bE\u0002X9zk\u0011\u0001\u0017\u0006\u00033j\u000bq!\\;uC\ndWM\u0003\u0002\\+\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uC&aA*fiB\u0011qL\u0019\b\u0003)\u0001L!!Y\u000b\u0002\rA\u0013X\rZ3g\u0013\tI3M\u0003\u0002b+!1Q\r\u0001Q\u0001\nY\u000bQc\u00195b]\u001e,GM\u0011:pW\u0016\u0014Hj\\4hKJ\u001c\b\u0005C\u0003h\u0001\u0011\u0005\u0003.A\u0003tKR,\u0006\u000fF\u0001MQ\t1'\u000e\u0005\u0002l]6\tAN\u0003\u0002nu\u0005)!.\u001e8ji&\u0011q\u000e\u001c\u0002\u0007\u0005\u00164wN]3\t\u000bE\u0004A\u0011\t5\u0002\u0011Q,\u0017M\u001d#po:D#\u0001]:\u0011\u0005-$\u0018BA;m\u0005\u0015\te\r^3s\u0011\u00159\b\u0001\"\u0001i\u0003%!Xm\u001d;DY>\u001cX\r\u000b\u0002wsB\u00111N_\u0005\u0003w2\u0014A\u0001V3ti\")Q\u0010\u0001C\u0001Q\u0006iA/Z:u\u0019&\u001cHOT8eKND#\u0001`=\t\r\u0005\u0005\u0001\u0001\"\u0001i\u0003E\"Xm\u001d;De\u0016\fG/Z#ySN$\u0018N\\4U_BL7m\u001d+ie><Hk\u001c9jG\u0016C\u0018n\u001d;t\u000bb\u001cW\r\u001d;j_:D#a`=\t\r\u0005\u001d\u0001\u0001\"\u0001i\u0003M!Xm\u001d;NKR\fG-\u0019;b%\u00164'/Z:iQ\r\t)!\u001f\u0005\u0007\u0003\u001b\u0001A\u0011\u00015\u00029Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3O_:,\u00050[:uS:<Gk\u001c9jG\"\u001a\u00111B=\t\r\u0005M\u0001\u0001\"\u0001i\u0003M!Xm\u001d;EKN\u001c'/\u001b2f\u00072,8\u000f^3sQ\r\t\t\"\u001f\u0005\u0007\u00033\u0001A\u0011\u00015\u0002'Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3M_\u001e$\u0015N]:)\u0007\u0005]\u0011\u0010\u0003\u0004\u0002 \u0001!\t\u0001[\u0001\u001bi\u0016\u001cH\u000fR3tGJL'-\u001a*fa2L7-\u0019'pO\u0012K'o\u001d\u0015\u0004\u0003;I\bBBA\u0013\u0001\u0011\u0005\u0001.A\fuKN$\u0018\t\u001c;feJ+\u0007\u000f\\5dC2{w\rR5sg\"\u001a\u00111E=\t\r\u0005-\u0002\u0001\"\u0001i\u0003m!Xm\u001d;EKN\u001c'/\u001b2f\u0003:$\u0017\t\u001c;fe\u000e{gNZ5hg\"\u001a\u0011\u0011F=\t\r\u0005E\u0002\u0001\"\u0001i\u0003Q!Xm\u001d;De\u0016\fG/\u001a)beRLG/[8og\"\u001a\u0011qF=\t\r\u0005]\u0002\u0001\"\u0001i\u0003i!Xm\u001d;TK\u0016\\\u0017I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3tQ\r\t)$\u001f\u0005\u0007\u0003{\u0001A\u0011\u00015\u00029Q,7\u000f\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oi\"\u001a\u00111H=\t\r\u0005\r\u0003\u0001\"\u0001i\u0003\u0011\"Xm\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\bfAA!s\"1\u0011\u0011\n\u0001\u0005\u0002!\fq\u0007^3tiJ+\u0007\u000f\\5dC\u000e\u000bgNR3uG\"4%o\\7M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\bfAA$s\"1\u0011q\n\u0001\u0005\u0002!\f!\u0005^3ti\u0006cG/\u001a:M_\u001e$\u0015N]:BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\bfAA's\"1\u0011Q\u000b\u0001\u0005\u0002!\fQ\u0005^3ti>3gm]3ug\u001a{'\u000fV5nKN\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\u0007\u0005M\u0013\u0010\u0003\u0004\u0002\\\u0001!\t\u0001[\u0001\u001ei\u0016\u001cHoQ8ogVlW-\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u001a\u0011\u0011L=\t\r\u0005\u0005\u0004\u0001\"\u0001i\u0003y!Xm\u001d;EK2,G/\u001a*fG>\u0014Hm],ji\",\u0005pY3qi&|g\u000eK\u0002\u0002`eDa!a\u001a\u0001\t\u0003A\u0017\u0001\t;fgR$Um]2sS\n,7i\u001c8gS\u001e\u001cH+[3s\r&dG/\u001a:j]\u001eD3!!\u001az\u0011\u0019\ti\u0007\u0001C\u0001Q\u0006YB/Z:u\t\u0016\u001c8M]5cK\u000e{gNZ5hg\u001a{'\u000fV8qS\u000eD3!a\u001bz\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\nQd];cg\u000e\u0014\u0018NY3B]\u0012<\u0016-\u001b;G_J\f5o]5h]6,g\u000e\u001e\u000b\u0006\u0019\u0006]\u0014\u0011\u0010\u0005\u0007A\u0005E\u0004\u0019\u00010\t\u0011\u0005m\u0014\u0011\u000fa\u0001\u0003{\n\u0001bY8ogVlWM\u001d\t\t\u0003\u007f\n9)a#\u0002\f6\u0011\u0011\u0011\u0011\u0006\u0005\u0003w\n\u0019IC\u0002\u0002\u0006^\nqa\u00197jK:$8/\u0003\u0003\u0002\n\u0006\u0005%!D&bM.\f7i\u001c8tk6,'\u000fE\u0003\u0015\u0003\u001b\u000b\t*C\u0002\u0002\u0010V\u0011Q!\u0011:sCf\u00042\u0001FAJ\u0013\r\t)*\u0006\u0002\u0005\u0005f$X\rC\u0004\u0002\u001a\u0002!I!a'\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\b\u0019\u0006u\u00151VAX\u0011!\ty*a&A\u0002\u0005\u0005\u0016\u0001\u00039s_\u0012,8-\u001a:\u0011\u0011\u0005\r\u0016qUAF\u0003\u0017k!!!*\u000b\t\u0005}\u00151Q\u0005\u0005\u0003S\u000b)KA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\u0005\b\u0003[\u000b9\n1\u0001\u001d\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\u0007c\u0005]\u0005\u0019A\u001a\t\r\u0005M\u0006\u0001\"\u0001i\u0003]!Xm\u001d;J]Z\fG.\u001b3BYR,'oQ8oM&<7\u000fK\u0002\u00022fDa!!/\u0001\t\u0003A\u0017!\u0005;fgR\f5\r\\(qKJ\fG/[8og\"\u001a\u0011qW=\t\r\u0005}\u0006\u0001\"\u0001i\u0003A!Xm\u001d;EK2\f\u00170\u001a3DY>\u001cX\rK\u0002\u0002>fDa!!2\u0001\t\u0003A\u0017A\u0004;fgR4uN]2f\u00072|7/\u001a\u0015\u0004\u0003\u0007L\bBBAf\u0001\u0011\u0005\u0001.\u0001\u000euKN$X*\u001b8j[Vl'+Z9vKN$H+[7f_V$8\u000fK\u0002\u0002JfDa!!5\u0001\t\u0003A\u0017\u0001\u0007;fgR\u001c\u0015\r\u001c7J]\u001ac\u0017n\u001a5u)&lWm\\;ug\"\u001a\u0011qZ=\t\r\u0005]\u0007\u0001\"\u0001i\u0003I!Xm\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f]:)\u0007\u0005U\u0017\u0010\u0003\u0004\u0002^\u0002!\t\u0001[\u0001\u001fi\u0016\u001cH\u000fR3mKR,7i\u001c8tk6,'o\u0012:pkB|eMZ:fiND3!a7z\u0011\u0019\t\u0019\u000f\u0001C\u0001Q\u0006IB/Z:u\u000b2,7\r\u001e)sK\u001a,'O]3e\u0019\u0016\fG-\u001a:tQ\r\t\t/\u001f\u0005\u0007\u0003S\u0004A\u0011\u00015\u0002MQ,7\u000f^#mK\u000e$XK\\2mK\u0006tG*Z1eKJ\u001chi\u001c:P]\u0016\u0004\u0016M\u001d;ji&|g\u000eK\u0002\u0002hfDa!a<\u0001\t\u0003A\u0017\u0001\u000b;fgR,E.Z2u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:t\r>\u0014X*\u00198z!\u0006\u0014H/\u001b;j_:\u001c\bfAAws\"1\u0011Q\u001f\u0001\u0005\u0002!\fq\u0005^3ti\u0016cWm\u0019;V]\u000edW-\u00198MK\u0006$WM]:G_J\fE\u000e\u001c)beRLG/[8og\"\u001a\u00111_=\t\r\u0005m\b\u0001\"\u0001i\u0003-\"Xm\u001d;FY\u0016\u001cG/\u00168dY\u0016\fg\u000eT3bI\u0016\u00148OR8s+:\\gn\\<o!\u0006\u0014H/\u001b;j_:\u001c\bfAA}s\"1!\u0011\u0001\u0001\u0005\u0002!\f\u0001\u0006^3ti\u0016cWm\u0019;V]\u000edW-\u00198MK\u0006$WM]:XQ\u0016tgj\u001c'jm\u0016\u0014%o\\6feND3!a@z\u0011\u0019\u00119\u0001\u0001C\u0001Q\u0006YB/Z:u\u000b2,7\r^+oG2,\u0017M\u001c'fC\u0012,'o\u001d(p_BD3A!\u0002z\u0011\u0019\u0011i\u0001\u0001C\u0001Q\u0006qB/Z:u\u000b2,7\r^+oG2,\u0017M\u001c'fC\u0012,'o]!oI:{w\u000e\u001d\u0015\u0004\u0005\u0017I\bB\u0002B\n\u0001\u0011\u0005\u0001.\u0001\u001duKN$H*[:u%\u0016\f7o]5h]6,g\u000e^:E_\u0016\u001chj\u001c;TQ><hj\u001c8SK\u0006\u001c8/[4oS:<\u0007+\u0019:uSRLwN\\:)\u0007\tE\u0011\u0010\u0003\u0004\u0003\u001a\u0001!\t\u0001[\u00012i\u0016\u001cH\u000fT5tiJ+\u0017m]:jO:lWM\u001c;t\t>,7OT8u'\"|w\u000fR3mKR,G\rU1si&$\u0018n\u001c8tQ\r\u00119\"\u001f\u0005\u0007\u0005?\u0001A\u0011\u00015\u0002AQ,7\u000f\u001e,bY&$\u0017J\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d\u0015\u0004\u0005;I\bB\u0002B\u0013\u0001\u0011\u0005\u0001.\u0001\u001buKN$\u0018J\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d#fY\u0016$X-\u00118e'\u0016$(I]8lKJ\u001cuN\u001c4jOND3Aa\tz\u0011\u0019\u0011Y\u0003\u0001C\u0001Q\u0006qC/Z:u\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON$U\r\\3uK\n\u0013xn[3s\u0007>tg-[4tQ\r\u0011I#\u001f\u0005\u0007\u0005c\u0001A\u0011\u00015\u0002EQ,7\u000f^%om\u0006d\u0017\u000eZ%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4tQ\r\u0011y#\u001f\u0005\u0007\u0005o\u0001A\u0011\u00015\u0002MQ,7\u000f^%om\u0006d\u0017\u000eZ!mi\u0016\u0014\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$8\u000fK\u0002\u00036eDaA!\u0010\u0001\t\u0003A\u0017A\u0005;fgRduN\\4U_BL7MT1nKND3Aa\u000fz\u0011\u0019\u0011\u0019\u0005\u0001C\u0001Q\u0006!C/Z:u\t\u0016\u001c8M]5cK\u000e{gNZ5hg\u001a{'\u000fT8hi)dun\u001a'fm\u0016d7\u000fK\u0002\u0003BeDaA!\u0013\u0001\t\u0003A\u0017\u0001\f;fgRLen\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7OR8s\u0019><GG\u001b'pO2+g/\u001a7tQ\u0011\u00119E!\u0014\u0011\u0007-\u0014y%C\u0002\u0003R1\u0014a!S4o_J,\u0007f\u0001B$s\"1!q\u000b\u0001\u0005\u0002!\fq\t^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001chi\u001c:M_\u001e$$\u000eT8h\u0019\u00164X\r\\:DC:\u0014Vm]3u\u0019><w-\u001a:U_\u000e+(O]3oiJ{w\u000e\u001e\u0015\u0005\u0005+\u0012i\u0005K\u0002\u0003VeDaAa\u0018\u0001\t\u0003A\u0017!\u0011;fgRLen\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7OR8s\u0019><GG\u001b'pO2+g/\u001a7t\u0007\u0006tgn\u001c;SKN,GOU8pi2{wmZ3sQ\u0011\u0011iF!\u0014)\u0007\tu\u0013\u0010\u0003\u0004\u0003h\u0001!\t\u0001[\u0001Ji\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:G_Jdun\u001a\u001bk\u0019><G*\u001a<fYN$u.Z:O_R<vN]6XSRD\u0017J\u001c<bY&$7i\u001c8gS\u001e\u001c\b\u0006\u0002B3\u0005\u001bB3A!\u001az\u0011\u0019\u0011y\u0007\u0001C\u0001Q\u0006aC/Z:u\u00032$XM]\"p]\u001aLwm\u001d$pe2{w\r\u000e6M_\u001edUM^3mg\u0012{Wm\u001d(pi^{'o\u001b\u0015\u0005\u0005[\u0012i\u0005K\u0002\u0003neDqAa\u001e\u0001\t\u0003\u0011I(\u0001\nbYR,'O\u0011:pW\u0016\u0014Hj\\4hKJ\u001cH#\u0002'\u0003|\t]\u0005\u0002\u0003B?\u0005k\u0002\rAa \u0002\u000f\u0015tGO]5fgB1!\u0011\u0011BD\u0005\u0017k!Aa!\u000b\u0007\t\u0015e%\u0001\u0003vi&d\u0017\u0002\u0002BE\u0005\u0007\u0013!bQ8mY\u0016\u001cG/[8o!\u0011\u0011iIa%\u000e\u0005\t=%\u0002\u0002BI\u0003\u0007\u000bQ!\u00193nS:LAA!&\u0003\u0010\ni\u0011\t\u001c;fe\u000e{gNZ5h\u001fBD\u0011B!'\u0003vA\u0005\t\u0019A\n\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\t\u000f\tu\u0005\u0001\"\u0001\u0003 \u0006)B-Z:de&\u0014WM\u0011:pW\u0016\u0014Hj\\4hKJ\u001cHC\u0001BQ!\u0011\u0011iIa)\n\t\t\u0015&q\u0012\u0002\u0007\u0007>tg-[4\t\r\t%\u0006\u0001\"\u0003i\u0003U!X-\u0019:e_^t'I]8lKJdunZ4feND\u0011B!,\u0001#\u0003%\tAa,\u00029\u0005dG/\u001a:Ce>\\WM\u001d'pO\u001e,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0017\u0016\u0004'\tM6F\u0001B[!\u0011\u00119L!1\u000e\u0005\te&\u0002\u0002B^\u0005{\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}V#\u0001\u0006b]:|G/\u0019;j_:LAAa1\u0003:\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u000f\t\u001d'\u0001#\u0001\u0003J\u0006i\u0002\u000b\\1j]R,\u0007\u0010^!e[&t\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fE\u0002\n\u0005\u00174a!\u0001\u0002\t\u0002\t57\u0003\u0002Bf\u0005\u001f\u00042\u0001\u0006Bi\u0013\r\u0011\u0019.\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000f5\u0011Y\r\"\u0001\u0003XR\u0011!\u0011\u001a\u0005\t\u00057\u0014Y\r\"\u0001\u0003^\u000612\r[3dWZ\u000bG.\u001b3BYR,'oQ8oM&<7\u000fF\u0004M\u0005?\u0014IO!<\t\u0011\t\u0005(\u0011\u001ca\u0001\u0005G\faa\u00197jK:$\b\u0003\u0002BG\u0005KLAAa:\u0003\u0010\n)\u0011\tZ7j]\"9!1\u001eBm\u0001\u0004\u0019\u0015A\u0004;pa&\u001c'+Z:pkJ\u001cW-\r\u0005\b\u0005_\u0014I\u000e1\u0001D\u00039!x\u000e]5d%\u0016\u001cx.\u001e:dKJB\u0001Ba=\u0003L\u0012\u0005!Q_\u0001\u0019G\",7m[%om\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001cHc\u0002'\u0003x\u000e\u001d1q\u0004\u0005\t\u0005s\u0014\t\u00101\u0001\u0003|\u0006A!p[\"mS\u0016tG\u000f\u0005\u0003\u0003~\u000e\rQB\u0001B\u0000\u0015\r\u0019\t\u0001B\u0001\u0003u.LAa!\u0002\u0003\u0000\ni1*\u00194lCj[7\t\\5f]RD\u0001b!\u0003\u0003r\u0002\u000711B\u0001\bg\u0016\u0014h/\u001a:t!\u0019\u0019iaa\u0004\u0004\u00145\t!,C\u0002\u0004\u0012i\u00131aU3r!\u0011\u0019)ba\u0007\u000e\u0005\r]!bAB\r\t\u000511/\u001a:wKJLAa!\b\u0004\u0018\tY1*\u00194lCN+'O^3s\u0011!\u0011\tO!=A\u0002\t\r\b")
public class PlaintextAdminIntegrationTest
extends BaseAdminIntegrationTest {
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private ConfigResource kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource;
    private final scala.collection.mutable.Set<String> kafka$api$PlaintextAdminIntegrationTest$$changedBrokerLoggers = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, Seq<KafkaServer> seq, Admin admin) {
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, admin);
    }

    public static void checkValidAlterConfigs(Admin admin, ConfigResource configResource, ConfigResource configResource2) {
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(admin, configResource, configResource2);
    }

    public boolean tierFeature() {
        return false;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ConfigResource kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource() {
        return this.kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource;
    }

    private void kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource_$eq(ConfigResource x$1) {
        this.kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource = x$1;
    }

    public scala.collection.mutable.Set<String> kafka$api$PlaintextAdminIntegrationTest$$changedBrokerLoggers() {
        return this.kafka$api$PlaintextAdminIntegrationTest$$changedBrokerLoggers;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource_$eq(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().head()).config().brokerId())).toString()));
    }

    @Override
    @After
    public void tearDown() {
        this.teardownBrokerLoggers();
        super.tearDown();
    }

    @Test
    public void testClose() {
        AdminClient client = AdminClient.create(this.createConfig());
        client.close();
        client.close();
    }

    @Test
    public void testListNodes() {
        Iterable nodes;
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        List brokerStrs = (List)Predef$.MODULE$.refArrayOps((Object[])this.brokerList().split(",")).toList().sorted((Ordering)Ordering.String$.MODULE$);
        List nodeStrs = null;
        while ((nodeStrs = (List)((TraversableOnce)(nodes = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Node node) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).size() < brokerStrs.size()) {
        }
        Assert.assertEquals((Object)brokerStrs.mkString(","), (Object)nodeStrs.mkString(","));
    }

    @Test
    public void testCreateExistingTopicsThrowTopicExistsException() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic = "mytopic";
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 1, (short)1)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        Seq newTopicsWithInvalidRF = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 1, (short)(this.servers().size() + 1))}));
        ExecutionException e = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, newTopicsWithInvalidRF){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final Seq newTopicsWithInvalidRF$1;

            public final Void apply() {
                return (Void)this.$outer.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.newTopicsWithInvalidRF$1).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newTopicsWithInvalidRF$1 = newTopicsWithInvalidRF$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        Assert.assertTrue((boolean)(e.getCause() instanceof TopicExistsException));
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic"}));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", 3, (short)3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        KafkaServer controller = (KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;

            public final boolean apply(KafkaServer x$1) {
                return x$1.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected(this.$outer.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicDesc.keySet()).asScala());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$2) {
                return new NewTopic(x$2, 1, (short)1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, nonExistingTopic, results){
            public static final long serialVersionUID = 0L;
            private final String nonExistingTopic$1;
            private final java.util.Map results$1;

            public final TopicDescription apply() {
                return (TopicDescription)((KafkaFuture)this.results$1.get(this.nonExistingTopic$1)).get();
            }
            {
                this.nonExistingTopic$1 = nonExistingTopic$1;
                this.results$1 = results$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Collection nodes = (Collection)result.nodes().get();
        String clusterId = (String)result.clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().clusterId(), (Object)clusterId);
        Node controller = (Node)result.controller().get();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().metadataCache().getControllerId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        })), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)Predef$.MODULE$.refArrayOps((Object[])brokers).size(), (long)nodes.size());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1)new Serializable(this, brokers){
            public static final long serialVersionUID = 0L;
            private final String[] brokers$1;

            public final void apply(Node node) {
                String hostStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host:port pair ", " in brokerVersionInfos"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostStr})), (boolean)Predef$.MODULE$.refArrayOps((Object[])this.brokers$1).contains((Object)hostStr));
            }
            {
                this.brokers$1 = brokers$1;
            }
        });
    }

    @Test
    public void testDescribeLogDirs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        scala.collection.immutable.Map partitionsByBroker = leaderByPartition.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int leaderId;
                    int n = leaderId = tuple2._2$mcI$sp();
                    return n;
                }
                throw new MatchError(tuple2);
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(scala.collection.immutable.Map<Object, Object> x$3) {
                return x$3.keys().toSeq();
            }
        });
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$1) {
                return x$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this, topic, partitionsByBroker, logDirInfosByBroker){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            public final String topic$1;
            private final scala.collection.immutable.Map partitionsByBroker$1;
            private final java.util.Map logDirInfosByBroker$1;

            public final void apply(int brokerId) {
                this.apply$mcVI$sp(brokerId);
            }

            public void apply$mcVI$sp(int brokerId) {
                KafkaServer server = (KafkaServer)this.$outer.servers().find((Function1)new Serializable(this, brokerId){
                    public static final long serialVersionUID = 0L;
                    private final int brokerId$1;

                    public final boolean apply(KafkaServer x$4) {
                        return x$4.config().brokerId() == this.brokerId$1;
                    }
                    {
                        this.brokerId$1 = brokerId$1;
                    }
                }).get();
                Seq expectedPartitions = (Seq)this.partitionsByBroker$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
                java.util.Map logDirInfos = (java.util.Map)this.logDirInfosByBroker$1.get(BoxesRunTime.boxToInteger((int)brokerId));
                Map replicaInfos = ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.mutable.Map<TopicPartition, DescribeLogDirsResponse.ReplicaInfo> apply(Tuple2<String, DescribeLogDirsResponse.LogDirInfo> x0$2) {
                        Tuple2<String, DescribeLogDirsResponse.LogDirInfo> tuple2 = x0$2;
                        if (tuple2 != null) {
                            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                            scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
                            return map;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Map$.MODULE$.canBuildFrom())).filterKeys((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDescribeLogDirs$1 $outer;

                    public final boolean apply(TopicPartition x$5) {
                        String string = x$5.topic();
                        String string2 = this.$outer.topic$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((TraversableOnce)replicaInfos.keys().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(TopicPartition x$6) {
                        return x$6.partition();
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    public final KafkaServer server$1;

                    public final void apply(Tuple2<String, DescribeLogDirsResponse.LogDirInfo> x0$3) {
                        Tuple2<String, DescribeLogDirsResponse.LogDirInfo> tuple2 = x0$3;
                        if (tuple2 != null) {
                            String logDir = (String)tuple2._1();
                            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)tuple2._2();
                            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1)new Serializable(this, logDir){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testDescribeLogDirs$1$$anonfun$apply$mcVI$sp$2 $outer;
                                private final String logDir$1;

                                public final void apply(TopicPartition tp) {
                                    LogManager qual$1 = this.$outer.server$1.logManager();
                                    TopicPartition x$25 = tp;
                                    boolean x$26 = qual$1.getLog$default$2();
                                    Assert.assertEquals((Object)((AbstractLog)qual$1.getLog(x$25, x$26).get()).dir().getParent(), (Object)this.logDir$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.logDir$1 = logDir$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.server$1 = server$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.partitionsByBroker$1 = partitionsByBroker$1;
                this.logDirInfosByBroker$1 = logDirInfosByBroker$1;
            }
        });
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic = "topic";
        scala.collection.immutable.Map<Object, Object> leaderByPartition = this.createTopic(topic, 10, 1, this.createTopic$default$4());
        Seq replicas = ((TraversableOnce)leaderByPartition.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final TopicPartitionReplica apply(Tuple2<Object, Object> x0$4) {
                Tuple2<Object, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    int brokerId = tuple2._2$mcI$sp();
                    TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(this.topic$2, partition, brokerId);
                    return topicPartitionReplica;
                }
                throw new MatchError(tuple2);
            }
            {
                this.topic$2 = topic$2;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;

            public final void apply(Tuple2<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> x0$5) {
                Tuple2<TopicPartitionReplica, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)tuple2._1();
                    DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)tuple2._2();
                    KafkaServer server = (KafkaServer)this.$outer.servers().find((Function1)new Serializable(this, topicPartitionReplica){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartitionReplica topicPartitionReplica$1;

                        public final boolean apply(KafkaServer x$7) {
                            return x$7.config().brokerId() == this.topicPartitionReplica$1.brokerId();
                        }
                        {
                            this.topicPartitionReplica$1 = topicPartitionReplica$1;
                        }
                    }).get();
                    TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
                    LogManager qual$2 = server.logManager();
                    TopicPartition x$27 = tp;
                    boolean x$28 = qual$2.getLog$default$2();
                    Assert.assertEquals((Object)((AbstractLog)qual$2.getLog(x$27, x$28).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((TraversableOnce)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<KafkaServer, Object> apply(KafkaServer server) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)server), (Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(2)));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map firstReplicaAssignment = ((TraversableOnce)this.servers().map((Function1)new Serializable(this, topic, randomNums){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final scala.collection.immutable.Map randomNums$1;

            public final Tuple2<TopicPartitionReplica, String> apply(KafkaServer server) {
                String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)this.randomNums$1.apply((Object)server)))).getAbsolutePath();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.randomNums$1 = randomNums$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map secondReplicaAssignment = ((TraversableOnce)this.servers().map((Function1)new Serializable(this, topic, randomNums){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final scala.collection.immutable.Map randomNums$1;

            public final Tuple2<TopicPartitionReplica, String> apply(KafkaServer server) {
                String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)this.randomNums$1.apply((Object)server)))).getAbsolutePath();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.randomNums$1 = randomNums$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable futures = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values();
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaFuture<Void> future) {
                ExecutionException exception = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, future){
                    public static final long serialVersionUID = 0L;
                    private final KafkaFuture future$1;

                    public final Void apply() {
                        return (Void)this.future$1.get();
                    }
                    {
                        this.future$1 = future$1;
                    }
                }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
                Assert.assertTrue((boolean)(exception.getCause() instanceof UnknownTopicOrPartitionException));
            }
        });
        this.createTopic(topic, 1, this.brokerCount(), this.createTopic$default$4());
        this.servers().foreach((Function1)new Serializable(this, topic, tp, firstReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final String topic$3;
            private final TopicPartition tp$1;
            private final scala.collection.immutable.Map firstReplicaAssignment$1;

            public final void apply(KafkaServer server) {
                LogManager qual$3 = server.logManager();
                TopicPartition x$29 = this.tp$1;
                boolean x$30 = qual$3.getLog$default$2();
                String logDir = ((AbstractLog)qual$3.getLog(x$29, x$30).get()).dir().getParent();
                Assert.assertEquals((Object)this.firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(this.topic$3, 0, server.config().brokerId())), (Object)logDir);
            }
            {
                this.topic$3 = topic$3;
                this.tp$1 = tp$1;
                this.firstReplicaAssignment$1 = firstReplicaAssignment$1;
            }
        });
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1)new Serializable(this, topic, tp, secondReplicaAssignment){
            public static final long serialVersionUID = 0L;
            public final String topic$3;
            public final TopicPartition tp$1;
            public final scala.collection.immutable.Map secondReplicaAssignment$1;

            public final void apply(KafkaServer server) {
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAlterReplicaLogDirs$5 $outer;
                    private final KafkaServer server$2;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        LogManager qual$4 = this.server$2.logManager();
                        TopicPartition x$31 = this.$outer.tp$1;
                        boolean x$32 = qual$4.getLog$default$2();
                        String logDir = ((AbstractLog)qual$4.getLog(x$31, x$32).get()).dir().getParent();
                        Object object = this.$outer.secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(this.$outer.topic$3, 0, this.server$2.config().brokerId()));
                        String string = logDir;
                        return !(object != null ? !object.equals(string) : string != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.server$2 = server$2;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "timed out waiting for replica movement";
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            }
            {
                this.topic$3 = topic$3;
                this.tp$1 = tp$1;
                this.secondReplicaAssignment$1 = secondReplicaAssignment$1;
            }
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        scala.concurrent.Future producerFuture = Future$.MODULE$.apply((Function0)new Serializable(this, topic, running, numMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final String topic$3;
            private final AtomicBoolean running$1;
            private final AtomicInteger numMessages$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            /*
             * WARNING - void declaration
             */
            public int apply$mcI$sp() {
                int n;
                String x$33 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.$outer.servers(), this.$outer.securityProtocol());
                SecurityProtocol x$34 = this.$outer.securityProtocol();
                Option<File> x$35 = this.$outer.trustStoreFile();
                int x$36 = 0;
                int x$37 = 10000;
                int x$38 = -1;
                long x$39 = TestUtils$.MODULE$.createProducer$default$3();
                long x$40 = TestUtils$.MODULE$.createProducer$default$4();
                int x$41 = TestUtils$.MODULE$.createProducer$default$6();
                int x$42 = TestUtils$.MODULE$.createProducer$default$7();
                int x$43 = TestUtils$.MODULE$.createProducer$default$8();
                String x$44 = TestUtils$.MODULE$.createProducer$default$9();
                Option<Properties> x$45 = TestUtils$.MODULE$.createProducer$default$13();
                ByteArraySerializer x$46 = TestUtils$.MODULE$.createProducer$default$14();
                ByteArraySerializer x$47 = TestUtils$.MODULE$.createProducer$default$15();
                boolean x$48 = TestUtils$.MODULE$.createProducer$default$16();
                KafkaProducer<K, V> producer = TestUtils$.MODULE$.createProducer(x$33, x$38, x$39, x$40, x$36, x$41, x$42, x$43, x$44, x$37, x$34, x$35, x$45, x$46, x$47, x$48);
                try {
                    while (this.running$1.get()) {
                        Future future = producer.send(new ProducerRecord(this.topic$3, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xxxxxxxxxxxxxxxxxxxx-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.numMessages$1})).getBytes()));
                        this.numMessages$1.incrementAndGet();
                        future.get(10L, TimeUnit.SECONDS);
                    }
                    n = this.numMessages$1.get();
                }
                catch (Throwable throwable) {
                    void var1_17;
                    var1_17.close();
                    throw throwable;
                }
                producer.close();
                return n;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
                this.running$1 = running$1;
                this.numMessages$1 = numMessages$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.numMessages$1.get() > 10;
                }
                {
                    this.numMessages$1 = numMessages$1;
                }
            }, (Function0<String>)new Serializable(this, numMessages, producerFuture){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;
                private final scala.concurrent.Future producerFuture$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"only ", " messages are produced before timeout. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.numMessages$1, this.producerFuture$1.value()}));
                }
                {
                    this.numMessages$1 = numMessages$1;
                    this.producerFuture$1 = producerFuture$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1)new Serializable(this, topic, tp, firstReplicaAssignment, producerFuture){
                public static final long serialVersionUID = 0L;
                public final String topic$3;
                public final TopicPartition tp$1;
                public final scala.collection.immutable.Map firstReplicaAssignment$1;
                public final scala.concurrent.Future producerFuture$1;

                public final void apply(KafkaServer server) {
                    TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, server){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testAlterReplicaLogDirs$7 $outer;
                        private final KafkaServer server$3;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            LogManager qual$5 = this.server$3.logManager();
                            TopicPartition x$49 = this.$outer.tp$1;
                            boolean x$50 = qual$5.getLog$default$2();
                            String logDir = ((AbstractLog)qual$5.getLog(x$49, x$50).get()).dir().getParent();
                            Object object = this.$outer.firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(this.$outer.topic$3, 0, this.server$3.config().brokerId()));
                            String string = logDir;
                            return !(object != null ? !object.equals(string) : string != null);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.server$3 = server$3;
                        }
                    }, (Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testAlterReplicaLogDirs$7 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timed out waiting for replica movement. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.producerFuture$1.value()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
                }
                {
                    this.topic$3 = topic$3;
                    this.tp$1 = tp$1;
                    this.firstReplicaAssignment$1 = firstReplicaAssignment$1;
                    this.producerFuture$1 = producerFuture$1;
                }
            });
            int currentMessagesNum = numMessages.get();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages, currentMessagesNum){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;
                private final int currentMessagesNum$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.numMessages$1.get() - this.currentMessagesNum$1 > 10;
                }
                {
                    this.numMessages$1 = numMessages$1;
                    this.currentMessagesNum$1 = currentMessagesNum$1;
                }
            }, (Function0<String>)new Serializable(this, numMessages, producerFuture, currentMessagesNum){
                public static final long serialVersionUID = 0L;
                private final AtomicInteger numMessages$1;
                private final scala.concurrent.Future producerFuture$1;
                private final int currentMessagesNum$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"only ", " messages are produced within timeout after replica movement. Producer future ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.numMessages$1.get() - this.currentMessagesNum$1)), this.producerFuture$1.value()}));
                }
                {
                    this.numMessages$1 = numMessages$1;
                    this.producerFuture$1 = producerFuture$1;
                    this.currentMessagesNum$1 = currentMessagesNum$1;
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            running.set(false);
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.set(false);
            throw throwable;
        }
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS)));
        Buffer<KafkaServer> x$51 = this.servers();
        String x$52 = topic;
        int x$53 = finalNumMessages;
        SecurityProtocol x$54 = this.securityProtocol();
        Option<File> x$55 = this.trustStoreFile();
        String x$56 = TestUtils$.MODULE$.consumeTopicRecords$default$4();
        long x$57 = TestUtils$.MODULE$.consumeTopicRecords$default$7();
        Seq<ConsumerRecord<byte[], byte[]>> consumerRecords = TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)x$51, x$52, x$53, x$56, x$54, x$55, x$57);
        ((IterableLike)consumerRecords.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<ConsumerRecord<byte[], byte[]>, Object> x0$6) {
                Tuple2<ConsumerRecord<byte[], byte[]>, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    ConsumerRecord consumerRecord = (ConsumerRecord)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Assert.assertEquals((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"xxxxxxxxxxxxxxxxxxxx-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)})), (Object)new String((byte[])consumerRecord.value()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString());
        Seq configResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MessageMaxBytes())).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)this.tierFeatureFilteredConfigCount$1((KafkaServer)this.servers().apply(1)), (long)this.customFilteredDescribedConfigCount$1(brokerResource1, configs));
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(1)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertFalse((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)this.tierFeatureFilteredConfigCount$1((KafkaServer)this.servers().apply(2)), (long)this.customFilteredDescribedConfigCount$1(brokerResource2, configs));
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().apply(2)).config().brokerId())).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testCreatePartitions() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        this.createTopic(topic2, 1, 2, this.createTopic$default$4());
        TopicDescription topic1_metadata = this.getTopicMetadata(this.client(), topic1, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        TopicDescription topic2_metadata = this.getTopicMetadata(this.client(), topic2, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topic1_metadata.partitions().size());
        Assert.assertEquals((long)1L, (long)topic2_metadata.partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        ObjectRef alterResult = ObjectRef.create((Object)this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), validateOnly));
        ObjectRef altered = ObjectRef.create((Object)((Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get()));
        Assert.assertEquals((long)1L, (long)this.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(topic1, this.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final String topic1$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()) == 3;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for new partitions to appear";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        java.util.List<Object> newPartition2Assignments = Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})});
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(topic2, this.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)3, newPartition2Assignments))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$9) {
                return x$9.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$10) {
                return x$10.id();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt}))).foreach((Function1)new Serializable(this, topic1, topic2, alterResult, altered, newPartition2Assignments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final String topic1$1;
            private final String topic2$1;
            private final ObjectRef alterResult$1;
            private final ObjectRef altered$1;
            private final java.util.List newPartition2Assignments$1;

            public final void apply(CreatePartitionsOptions option) {
                Object object;
                Object object2;
                String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$1), (Object)NewPartitions.increaseTo((int)1))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is a decrease"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when requesting a noop"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)this.newPartition2Assignments$1))}))).asJava(), option);
                try {
                    object2 = ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))));
                    object2 = BoxedUnit.UNIT;
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2$1), (Object)NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.newPartition2Assignments$1).asScala()).reverse()).toList()).asJava())))}))).asJava(), option);
                try {
                    object = ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic2$1)).get();
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic2$1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3))));
                    object = BoxedUnit.UNIT;
                }
                String unknownTopic = "an-unknown-topic";
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTopic), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), option);
                try {
                    ((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(unknownTopic)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidTopicException when using an unknown topic"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
                    Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)executionException.getCause().getMessage());
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$1), (Object)NewPartitions.increaseTo((int)-22))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when newCount is invalid"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidPartitionsException));
                    Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidPartitionsException when #brokers != replication factor"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$1), (Object)NewPartitions.increaseTo((int)6, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Duplicate replicas not allowed in partition assignment: 1, 1.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$1), (Object)NewPartitions.increaseTo((int)5, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$1), (Object)NewPartitions.increaseTo((int)4, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(12)})})))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
                }
                this.alterResult$1.elem = this.$outer.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1$1), (Object)NewPartitions.increaseTo((int)4, Collections.<T>emptyList()))}))).asJava(), option);
                try {
                    this.altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)this.alterResult$1.elem).values().get(this.topic1$1)).get();
                    Assert.fail((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Expect InvalidReplicaAssignmentException when assignments is empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc})));
                }
                catch (ExecutionException executionException) {
                    Assert.assertTrue((String)desc, (boolean)(executionException.getCause() instanceof InvalidReplicaAssignmentException));
                    Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)executionException.getCause().getMessage());
                    Assert.assertEquals((String)desc, (long)3L, (long)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
                this.topic2$1 = topic2$1;
                this.alterResult$1 = alterResult$1;
                this.altered$1 = altered$1;
                this.newPartition2Assignments$1 = newPartition2Assignments$1;
            }
        });
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2), (Object)NewPartitions.increaseTo((int)2))}))).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final String topic1$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(this.topic1$1, this.$outer.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()) == 4;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic1$1 = topic1$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for new partitions to appear";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((Object)"Topic currently has 3 partitions, which is higher than the requested 2.", (Object)executionException.getCause().getMessage());
            Assert.assertEquals((long)3L, (long)this.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(topic2, this.kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1()));
        }
        DeleteTopicsResult deleteResult = this.client().deleteTopics(Arrays.asList((Object[])new String[]{topic1}));
        ((KafkaFuture)deleteResult.values().get(topic1)).get();
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1), (Object)NewPartitions.increaseTo((int)4))}))).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            Assert.fail((String)"Expect InvalidTopicException when the topic is queued for deletion");
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)executionException.getCause().getMessage());
        }
    }

    @Test
    public void testSeekAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assert.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    @Test
    public void testLogStartOffsetCheckpoint() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        ObjectRef result = ObjectRef.create((Object)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()));
        ObjectRef lowWatermark = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)((KafkaFuture)((DeleteRecordsResult)result.elem).lowWatermarks().get(this.topicPartition())).get()).lowWatermark())));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)((Option)lowWatermark.elem));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.killBroker(i);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, result, lowWatermark){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final ObjectRef result$1;
            private final ObjectRef lowWatermark$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Throwable throwable2;
                block2: {
                    boolean bl;
                    this.result$1.elem = this.$outer.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)0L))}))).asJava());
                    this.lowWatermark$1.elem = None$.MODULE$;
                    KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)this.result$1.elem).lowWatermarks().get(this.$outer.topicPartition());
                    try {
                        this.lowWatermark$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)((DeletedRecords)future.get()).lowWatermark()));
                        bl = ((Option)this.lowWatermark$1.elem).contains((Object)BoxesRunTime.boxToLong((long)5L));
                    }
                    catch (Throwable throwable2) {
                        boolean bl2;
                        ExecutionException executionException;
                        Throwable throwable3 = throwable2;
                        if (!(throwable3 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable3).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderForPartitionException)) break block2;
                        bl = bl2 = false;
                    }
                    return bl;
                }
                throw throwable2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                this.lowWatermark$1 = lowWatermark$1;
            }
        }, (Function0<String>)new Serializable(this, lowWatermark){
            public static final long serialVersionUID = 0L;
            private final ObjectRef lowWatermark$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected low watermark of the partition to be 5 but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Option)this.lowWatermark$1.elem).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "no response within the timeout";
                    }
                })}));
            }
            {
                this.lowWatermark$1 = lowWatermark$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        long lowWatermark = ((DeletedRecords)((KafkaFuture)result.lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)3L, (long)lowWatermark);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)3L, (long)((AbstractLog)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localLog(this.$outer.topicPartition()).get()).logStartOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        scala.collection.immutable.Map<Object, Object> leaders = this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4());
        int followerIndex = BoxesRunTime.unboxToInt((Object)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)3L, (long)((AbstractLog)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localLog(this.$outer.topicPartition()).get()).logStartOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        DeleteRecordsResult result1 = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)117L))}))).asJava());
        result1.all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4());
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava());
        result.all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).foreach$mVc$sp((Function1)new Serializable(this, expectedLEO){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final int expectedLEO$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)3L, (long)((AbstractLog)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localLog(this.$outer.topicPartition()).get()).logStartOffset());
                Assert.assertEquals((long)this.expectedLEO$1, (long)((AbstractLog)((KafkaServer)this.$outer.servers().apply(i)).replicaManager().localLog(this.$outer.topicPartition()).get()).logEndOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expectedLEO$1 = expectedLEO$1;
            }
        });
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)futureReplica), (Object)futureLogDir)}))).asJava()).all().get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, futureLogDir){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final String futureLogDir$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                String string = this.futureLogDir$1;
                LogManager qual$6 = ((KafkaServer)this.$outer.servers().apply(0)).logManager();
                TopicPartition x$62 = this.$outer.topicPartition();
                boolean x$63 = qual$6.getLog$default$2();
                String string2 = ((AbstractLog)qual$6.getLog(x$62, x$63).get()).dir().getParent();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.futureLogDir$1 = futureLogDir$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timed out waiting for replica movement";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)3L, (long)((AbstractLog)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO, (long)((AbstractLog)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logEndOffset());
    }

    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        DeleteRecordsResult result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava());
        result.all().get();
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition())).offset());
        result = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)-1L))}))).asJava());
        result.all().get();
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)0L)}))).asJava()).get(this.topicPartition()));
    }

    @Test
    public void testConsumeAfterDeleteRecords() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        boolean messageCount = false;
        TestUtils$.MODULE$.consumeRecords(consumer, 10, TestUtils$.MODULE$.consumeRecords$default$3());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)3L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount = false;
        TestUtils$.MODULE$.consumeRecords(consumer, 7, TestUtils$.MODULE$.consumeRecords$default$3());
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)8L))}))).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        messageCount = false;
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
    }

    @Test
    public void testDeleteRecordsWithException() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Assert.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)5L))}))).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;

            public final DeletedRecords apply() {
                return (DeletedRecords)((KafkaFuture)this.$outer.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.topicPartition()), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.$outer.topicPartition())).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 890))).getCause();
        Assert.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, nonExistPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final TopicPartition nonExistPartition$1;

            public final DeletedRecords apply() {
                return (DeletedRecords)((KafkaFuture)this.$outer.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.nonExistPartition$1), (Object)RecordsToDelete.beforeOffset((long)20L))}))).asJava()).lowWatermarks().get(this.nonExistPartition$1)).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nonExistPartition$1 = nonExistPartition$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 897))).getCause();
        Assert.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsTierFiltering() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        Config configs = (Config)((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        boolean foundTierConfigs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(configs.entries()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigEntry x$11) {
                return x$11.name();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet().contains((Object)"confluent.tier.enable");
        Assert.assertTrue((this.tierFeature() && foundTierConfigs || !this.tierFeature() && !foundTierConfigs ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, nonExistentTopic, describeResult1){
            public static final long serialVersionUID = 0L;
            private final ConfigResource nonExistentTopic$1;
            private final DescribeConfigsResult describeResult1$1;

            public final Config apply() {
                return (Config)((KafkaFuture)this.describeResult1$1.values().get(this.nonExistentTopic$1)).get();
            }
            {
                this.nonExistentTopic$1 = nonExistentTopic$1;
                this.describeResult1$1 = describeResult1$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 925))).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, invalidTopic, describeResult2){
            public static final long serialVersionUID = 0L;
            private final ConfigResource invalidTopic$1;
            private final DescribeConfigsResult describeResult2$1;

            public final Config apply() {
                return (Config)((KafkaFuture)this.describeResult2$1.values().get(this.invalidTopic$1)).get();
            }
            {
                this.invalidTopic$1 = invalidTopic$1;
                this.describeResult2$1 = describeResult2$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 930))).getCause() instanceof InvalidTopicException));
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.pollUntilTrue((Consumer<?, ?>)consumer, (Function0<Object>)new Serializable(this, consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.consumer$1.assignment().isEmpty();
            }
            {
                this.consumer$1 = consumer$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected non-empty assignment";
            }
        }, TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this, producer, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final KafkaProducer producer$1;
            private final TopicPartition topicPartition$1;

            public final Future<RecordMetadata> apply(int i) {
                ProducerRecord record = new ProducerRecord(this.topicPartition$1.topic(), Predef$.MODULE$.int2Integer(this.topicPartition$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                this.$outer.debug((Function0<String>)new Serializable(this, record){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRecord record$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.record$1}));
                    }
                    {
                        this.record$1 = record$1;
                    }
                });
                return this.producer$1.send(record);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
                this.topicPartition$1 = topicPartition$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$12) {
                return x$12.get();
            }
        });
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testAclOperations() {
        AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(acl)).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(acl.toFilter())).all(), SecurityDisabledException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}));
        Seq newTopics = (Seq)topics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$13) {
                return new NewTopic(x$13, 1, (short)1);
            }
        }, Seq$.MODULE$.canBuildFrom());
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(java.time.Duration.ofHours(2L));
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        future.get();
        this.client().close(java.time.Duration.ofMinutes(30L));
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.IncorrectBrokerPort())})));
        this.client_$eq((Admin)AdminClient.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$14) {
                return new NewTopic(x$14, 1, (short)1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(900000))).all();
        this.client().close(java.time.Duration.ZERO);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)TestUtils$.MODULE$.IncorrectBrokerPort())})));
        config.put("request.timeout.ms", "0");
        this.client_$eq((Admin)AdminClient.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$15) {
                return new NewTopic(x$15, 1, (short)1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("default.api.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((Admin)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$16) {
                return new NewTopic(x$16, 1, (short)1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NewTopic apply(String x$17) {
                return new NewTopic(x$17, 1, (short)1);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        future2.get();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testConsumerGroups() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Test
    public void testDeleteConsumerGroupOffsets() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq((Admin)AdminClient.create(config));
        try {
            String testTopicName = "test_topic";
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String fakeGroupId = "fake_group_id";
            TopicPartition tp1 = new TopicPartition(testTopicName, 0);
            TopicPartition tp2 = new TopicPartition("foo", 0);
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, 1, (short)1))).all().get();
            this.waitForTopics(this.client(), (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTopicName})), (Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                producer.send(new ProducerRecord(testTopicName, Predef$.MODULE$.int2Integer(0), null, null)).get();
            }
            catch (Throwable throwable) {
                void var9_8;
                Utils.closeQuietly((AutoCloseable)var9_8, (String)"producer");
                throw throwable;
            }
            Utils.closeQuietly(producer, (String)"producer");
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            newConsumerConfig.setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
            newConsumerConfig.setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.GroupMaxSessionTimeoutMs())).toString());
            Properties x$68 = newConsumerConfig;
            ByteArrayDeserializer x$69 = this.createConsumer$default$1();
            ByteArrayDeserializer x$70 = this.createConsumer$default$2();
            List<String> x$71 = this.createConsumer$default$4();
            KafkaConsumer consumer = this.createConsumer(x$69, x$70, x$68, x$71);
            TestUtils$.MODULE$.subscribeAndWaitForRecords(testTopicName, consumer, TestUtils$.MODULE$.subscribeAndWaitForRecords$default$3());
            consumer.commitSync();
            DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp1), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            DeleteConsumerGroupOffsetsResult fakeDeleteResult = this.client().deleteConsumerGroupOffsets(fakeGroupId, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.all(), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp1), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp2), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            {
                catch (Throwable throwable) {
                    void var12_14;
                    Utils.closeQuietly((AutoCloseable)var12_14, (String)"consumer");
                    throw throwable;
                }
            }
            Utils.closeQuietly(consumer, (String)"consumer");
            DeleteConsumerGroupOffsetsResult offsetDeleteResult2 = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult2.all(), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            Assert.assertNull((Object)offsetDeleteResult2.partitionResult(tp1).get());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult2.partitionResult(tp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
            return;
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    @Test
    public void testElectPreferredLeaders() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        Seq prefer0 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Seq prefer1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Seq prefer2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1}));
        TopicPartition partition1 = new TopicPartition("elect-preferred-leaders-topic-1", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)prefer0)}))), (Seq<KafkaServer>)this.servers());
        TopicPartition partition2 = new TopicPartition("elect-preferred-leaders-topic-2", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition2.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)prefer0)}))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Throwable exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(ElectionNotNeededException.class, exception.getClass());
        Assert.assertEquals((Object)"Leader election not needed for topic partition", (Object)exception.getMessage());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assert.assertTrue((boolean)((java.util.Map)electResult.partitions().get()).isEmpty());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        Assert.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(((java.util.Map)electResult.partitions().get()).keySet()).asScala());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        TopicPartition unknownPartition = new TopicPartition("topic-does-not-exist", 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        this.changePreferredLeader$1(prefer2, partition1, partition2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        ((KafkaServer)this.servers().apply(1)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
        ElectLeadersOptions shortTimeout = (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Predef$.MODULE$.int2Integer(10000));
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), shortTimeout);
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null, shortTimeout);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-2-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
    }

    @Test
    public void testElectUncleanLeadersForOnePartition() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        TopicPartition partition1 = new TopicPartition("unclean-test-topic-1", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
    }

    @Test
    public void testElectUncleanLeadersForManyPartitions() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)assignment2)}))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition2);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker2);
    }

    @Test
    public void testElectUncleanLeadersForAllPartitions() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)assignment2)}))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, null);
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    @Test
    public void testElectUncleanLeadersForUnknownPartitions() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition unknownPartition = new TopicPartition(topic, 1);
        TopicPartition unknownTopic = new TopicPartition("unknown-topic", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)assignment1)}))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), new TopicPartition(topic, 0), broker1);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, unknownTopic}))).asJava());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get() instanceof UnknownTopicOrPartitionException));
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownTopic)).get() instanceof UnknownTopicOrPartitionException));
    }

    @Test
    public void testElectUncleanLeadersWhenNoLiveBrokers() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get() instanceof EligibleLeadersNotAvailableException));
    }

    @Test
    public void testElectUncleanLeadersNoop() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1)}))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        ((KafkaServer)this.servers().apply(broker1)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))).asJava());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get() instanceof ElectionNotNeededException));
    }

    @Test
    public void testElectUncleanLeadersAndNoop() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1.partition())), (Object)assignment1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition2.partition())), (Object)assignment2)}))), (Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{broker2}))));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertNoLeader(this.client(), partition1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2}))).asJava());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get() instanceof ElectionNotNeededException));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    @Test
    public void testListReassignmentsDoesNotShowNonReassigningPartitions() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        this.createTopic(topic, 1, 3, this.createTopic$default$4());
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assert.assertEquals((long)0L, (long)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assert.assertEquals((long)0L, (long)allReassignmentsMap.size());
    }

    @Test
    public void testListReassignmentsDoesNotShowDeletedPartitions() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        TopicPartition tp = new TopicPartition(topic, 0);
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).reassignments().get();
        Assert.assertEquals((long)0L, (long)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assert.assertEquals((long)0L, (long)allReassignmentsMap.size());
    }

    @Test
    public void testValidIncrementalAlterConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topic1CreateConfigs = new Properties();
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic1, 1, 1, topic1CreateConfigs);
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete()), AlterConfigOp.OpType.APPEND), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionMsProp(), ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        Collection topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assert.assertEquals((Object)"compact,delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)(Defaults$.MODULE$.LogRetentionHours() * 60 * 60 * 1000))).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)"lz4", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.SUBTRACT)}))).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava());
        alterResult.all().get();
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND)}))).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        alterResult.all().get();
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "zip"), AlterConfigOp.OpType.SET)}))).asJava();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testIncrementalAlterConfigsDeleteAndSetBrokerConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET)}))).asJavaCollection())}))).asJava()).all().get();
        Serializable x$72 = new Serializable(this, broker0Resource){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final ConfigResource broker0Resource$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)this.$outer.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{this.broker0Resource$1}))).asJava()).all().get()).get(this.broker0Resource$1)).entries()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(ConfigEntry x0$7) {
                        ConfigEntry configEntry2 = x0$7;
                        Tuple2 tuple2 = new Tuple2((Object)configEntry2.name(), (Object)configEntry2.value());
                        return tuple2;
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                return "123".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })) && "456".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broker0Resource$1 = broker0Resource$1;
            }
        };
        Serializable x$73 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected to see the broker properties we just set";
            }
        };
        long x$74 = 25L;
        long x$75 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$72, (Function0<String>)x$73, x$75, x$74);
        this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "654"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "987"), AlterConfigOp.OpType.SET)}))).asJavaCollection())}))).asJava()).all().get();
        Serializable x$76 = new Serializable(this, broker0Resource){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final ConfigResource broker0Resource$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)this.$outer.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{this.broker0Resource$1}))).asJava()).all().get()).get(this.broker0Resource$1)).entries()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(ConfigEntry x0$8) {
                        ConfigEntry configEntry2 = x0$8;
                        Tuple2 tuple2 = new Tuple2((Object)configEntry2.name(), (Object)configEntry2.value());
                        return tuple2;
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                return "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })) && "654".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })) && "987".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broker0Resource$1 = broker0Resource$1;
            }
        };
        Serializable x$77 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected to see the broker properties we just modified";
            }
        };
        long x$78 = 25L;
        long x$79 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$76, (Function0<String>)x$77, x$79, x$78);
    }

    @Test
    public void testIncrementalAlterConfigsDeleteBrokerConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "789"), AlterConfigOp.OpType.SET)}))).asJavaCollection())}))).asJava()).all().get();
        Serializable x$80 = new Serializable(this, broker0Resource){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final ConfigResource broker0Resource$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)this.$outer.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{this.broker0Resource$2}))).asJava()).all().get()).get(this.broker0Resource$2)).entries()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(ConfigEntry x0$9) {
                        ConfigEntry configEntry2 = x0$9;
                        Tuple2 tuple2 = new Tuple2((Object)configEntry2.name(), (Object)configEntry2.value());
                        return tuple2;
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                return "123".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })) && "456".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })) && "789".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broker0Resource$2 = broker0Resource$2;
            }
        };
        Serializable x$81 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected to see the broker properties we just set";
            }
        };
        long x$82 = 25L;
        long x$83 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$80, (Function0<String>)x$81, x$83, x$82);
        this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker0Resource), (Object)JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection())}))).asJava()).all().get();
        Serializable x$84 = new Serializable(this, broker0Resource){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final ConfigResource broker0Resource$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                scala.collection.immutable.Map broker0Configs = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)this.$outer.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{this.broker0Resource$2}))).asJava()).all().get()).get(this.broker0Resource$2)).entries()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(ConfigEntry x0$10) {
                        ConfigEntry configEntry2 = x0$10;
                        Tuple2 tuple2 = new Tuple2((Object)configEntry2.name(), (Object)configEntry2.value());
                        return tuple2;
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                return "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })) && "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })) && "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broker0Resource$2 = broker0Resource$2;
            }
        };
        Serializable x$85 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected to see the broker properties we just removed to be deleted";
            }
        };
        long x$86 = 25L;
        long x$87 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$84, (Function0<String>)x$85, x$87, x$86);
    }

    @Test
    public void testInvalidIncrementalAlterConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Collection topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.75"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.65"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Collection topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Error due to duplicate config keys"));
        ((KafkaFuture)alterResult.values().get(topic2Resource)).get();
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)Defaults$.MODULE$.CompressionType().toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.APPEND)}))).asJavaCollection();
        topic2AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), AlterConfigOp.OpType.SUBTRACT)}))).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic2Resource), (Object)topic2AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value append is not allowed for config"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic2Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value subtract is not allowed for config"));
        topic1AlterConfigs = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic1Resource), (Object)topic1AlterConfigs)}))).asJava());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    @Test
    public void testInvalidAlterPartitionReassignments() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String topic = "alter-reassignments-topic-1";
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        TopicPartition tp3 = new TopicPartition(topic, 2);
        this.createTopic(topic, 4, this.createTopic$default$3(), this.createTopic$default$4());
        Optional<NewPartitionReassignment> validAssignment = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$19) {
                return BoxesRunTime.boxToInteger((int)x$19);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).asJava()));
        TopicPartition nonExistentTp1 = new TopicPartition("topicA", 0);
        TopicPartition nonExistentTp2 = new TopicPartition(topic, 4);
        java.util.Map nonExistentPartitionsResult = this.client().alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp1), validAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentTp2), validAssignment)}))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp1), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp2), UnknownTopicOrPartitionException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Optional<NewPartitionReassignment> extraNonExistentReplica = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.brokerCount() + 1).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$20) {
                return BoxesRunTime.boxToInteger((int)x$20);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).asJava()));
        Optional<NewPartitionReassignment> negativeIdReplica = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-3, -2, -1}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$21) {
                return BoxesRunTime.boxToInteger((int)x$21);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava()));
        Optional<NewPartitionReassignment> duplicateReplica = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 1}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int x$22) {
                return BoxesRunTime.boxToInteger((int)x$22);
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava()));
        java.util.Map invalidReplicaResult = this.client().alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), extraNonExistentReplica), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), negativeIdReplica), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp3), duplicateReplica)}))).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp1), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp2), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp3), InvalidReplicaAssignmentException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    @Test
    public void testLongTopicNames() {
        AdminClient client = AdminClient.create(this.createConfig());
        String longTopicName = String.join((CharSequence)"", Collections.nCopies(249, "x"));
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(250, "x"));
        Seq newTopics2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(invalidTopicName, 3, (short)3), new NewTopic(longTopicName, 3, (short)3)}));
        java.util.Map results = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics2).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey(longTopicName));
        ((KafkaFuture)results.get(longTopicName)).get();
        Assert.assertTrue((boolean)results.containsKey(invalidTopicName));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get(invalidTopicName), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(client.alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(longTopicName, 0, 0)), ((KafkaServer)this.servers().apply(0)).config().logDirs().apply(0))}))).asJava()).all(), InvalidTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        client.close();
    }

    @Test
    public void testDescribeConfigsForLog4jLogLevels() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        Config loggerConfig = this.describeBrokerLoggers();
        String rootLogLevel = loggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        ConfigEntry logCleanerLogLevelConfig = loggerConfig.get("kafka.cluster.Replica");
        Assert.assertEquals((Object)rootLogLevel, (Object)logCleanerLogLevelConfig.value());
        Assert.assertEquals((Object)"kafka.cluster.Replica", (Object)logCleanerLogLevelConfig.name());
        Assert.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, (Object)logCleanerLogLevelConfig.source());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isReadOnly()));
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)logCleanerLogLevelConfig.isSensitive()));
        Assert.assertTrue((boolean)logCleanerLogLevelConfig.synonyms().isEmpty());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevels() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        Config initialLoggerConfig = this.describeBrokerLoggers();
        String initialRootLogLevel = initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.server.ReplicaManager").value());
        String newRootLogLevel = "DEBUG";
        Collection alterRootLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, true);
        Config validatedLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedRootLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterZKLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", "ERROR"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(alterZKLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedZKLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)"ERROR", (Object)changedZKLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Collection alterLogLevelsEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "ERROR"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", "TRACE"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        this.alterBrokerLoggers(alterLogLevelsEntries, this.alterBrokerLoggers$default$2());
        Config alteredLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)"INFO", (Object)alteredLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)"ERROR", (Object)alteredLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)"TRACE", (Object)alteredLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsCanResetLoggerToCurrentRoot() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String initialRootLogLevel = "TRACE";
        Collection alterRootLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), initialRootLogLevel), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config initialLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection alterControllerLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(alterControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedControllerLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)changedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)"INFO", (Object)changedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        Collection deleteControllerLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        this.alterBrokerLoggers(deleteControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config deletedControllerLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        String newRootLogLevel = "ERROR";
        Collection newAlterRootLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        this.alterBrokerLoggers(newAlterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config newRootLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get("kafka.controller.KafkaController").value());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsCannotResetRootLogger() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        Collection deleteRootLoggerEntry = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), ""), AlterConfigOp.OpType.DELETE)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, deleteRootLoggerEntry){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final Collection deleteRootLoggerEntry$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.alterBrokerLoggers(this.deleteRootLoggerEntry$1, this.$outer.alterBrokerLoggers$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteRootLoggerEntry$1 = deleteRootLoggerEntry$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2117))).getCause() instanceof InvalidRequestException));
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsDoesNotWorkWithInvalidConfigs() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        String validLoggerName = "kafka.server.KafkaRequestHandler";
        ConfigEntry expectedValidLoggerLogLevel = this.describeBrokerLoggers().get(validLoggerName);
        Collection appendLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.APPEND)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, appendLogLevelEntries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final Collection appendLogLevelEntries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.alterBrokerLoggers(this.appendLogLevelEntries$1, this.$outer.alterBrokerLoggers$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.appendLogLevelEntries$1 = appendLogLevelEntries$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2137))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(validLoggerName, expectedValidLoggerLogLevel);
        Collection subtractLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.SUBTRACT)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, subtractLogLevelEntries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final Collection subtractLogLevelEntries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.alterBrokerLoggers(this.subtractLogLevelEntries$1, this.$outer.alterBrokerLoggers$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.subtractLogLevelEntries$1 = subtractLogLevelEntries$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2144))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(validLoggerName, expectedValidLoggerLogLevel);
        Collection invalidLogLevelLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "OFF"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, invalidLogLevelLogLevelEntries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final Collection invalidLogLevelLogLevelEntries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.alterBrokerLoggers(this.invalidLogLevelLogLevelEntries$1, this.$outer.alterBrokerLoggers$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.invalidLogLevelLogLevelEntries$1 = invalidLogLevelLogLevelEntries$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2151))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(validLoggerName, expectedValidLoggerLogLevel);
        Collection invalidLoggerNameLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("Some Other LogCleaner", "ERROR"), AlterConfigOp.OpType.SET)}))).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, invalidLoggerNameLogLevelEntries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final Collection invalidLoggerNameLogLevelEntries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.alterBrokerLoggers(this.invalidLoggerNameLogLevelEntries$1, this.$outer.alterBrokerLoggers$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.invalidLoggerNameLogLevelEntries$1 = invalidLoggerNameLogLevelEntries$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2158))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(validLoggerName, expectedValidLoggerLogLevel);
    }

    @Test
    @Ignore
    public void testAlterConfigsForLog4jLogLevelsDoesNotWork() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        Collection alterLogLevelsEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("kafka.controller.KafkaController", "INFO")}))).asJavaCollection();
        AlterConfigsResult alterResult = this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource()), (Object)new Config(alterLogLevelsEntries))}))).asJava());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, alterResult){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final AlterConfigsResult alterResult$2;

            public final Void apply() {
                return (Void)((KafkaFuture)this.alterResult$2.values().get(this.$outer.kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource())).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.alterResult$2 = alterResult$2;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2174))).getCause() instanceof InvalidRequestException));
    }

    public void alterBrokerLoggers(Collection<AlterConfigOp> entries2, boolean validateOnly) {
        if (!validateOnly) {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(entries2).asScala()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PlaintextAdminIntegrationTest $outer;

                public final boolean apply(AlterConfigOp entry) {
                    return this.$outer.kafka$api$PlaintextAdminIntegrationTest$$changedBrokerLoggers().add((Object)entry.configEntry().name());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        ((KafkaFuture)this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource()), entries2)}))).asJava(), new AlterConfigsOptions().validateOnly(validateOnly)).values().get(this.kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource())).get();
    }

    public boolean alterBrokerLoggers$default$2() {
        return false;
    }

    public Config describeBrokerLoggers() {
        return (Config)((KafkaFuture)this.client().describeConfigs(Collections.singletonList(this.kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource())).values().get(this.kafka$api$PlaintextAdminIntegrationTest$$brokerLoggerConfigResource())).get();
    }

    private void teardownBrokerLoggers() {
        if (this.kafka$api$PlaintextAdminIntegrationTest$$changedBrokerLoggers().nonEmpty()) {
            scala.collection.immutable.Set validLoggers = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.describeBrokerLoggers().entries()).asScala()).filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ConfigEntry x$23) {
                    return x$23.name().equals(Log4jController$.MODULE$.ROOT_LOGGER());
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ConfigEntry x$24) {
                    return x$24.name();
                }
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
            Collection unsetBrokerLoggersEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((SetLike)this.kafka$api$PlaintextAdminIntegrationTest$$changedBrokerLoggers().intersect((GenSet)validLoggers)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final AlterConfigOp apply(String logger) {
                    return new AlterConfigOp(new ConfigEntry(logger, ""), AlterConfigOp.OpType.DELETE);
                }
            }, Set$.MODULE$.canBuildFrom())).asJavaCollection();
            this.alterBrokerLoggers(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), "FATAL"), AlterConfigOp.OpType.SET)}))).asJavaCollection(), this.alterBrokerLoggers$default$2());
            this.alterBrokerLoggers(unsetBrokerLoggersEntries, this.alterBrokerLoggers$default$2());
            this.kafka$api$PlaintextAdminIntegrationTest$$changedBrokerLoggers().clear();
        }
    }

    private final long tierFeatureFilteredConfigCount$1(KafkaServer server) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(server.config().values().keySet()).asScala()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;

            public final boolean apply(String config) {
                return !this.$outer.tierFeature() && config.startsWith(KafkaConfig$.MODULE$.ConfluentTierPrefix()) || config.equals("confluent.schema.registry.url") || config.equals("confluent.basic.auth.credentials.source") || config.equals("confluent.basic.auth.user.info") || config.equals("confluent.bearer.auth.credentials.source") || config.equals("confluent.bearer.auth.token") || config.equals(LogConfig$.MODULE$.AppendRecordInterceptorClassesProp()) || config.equals("confluent.ssl.protocol") || config.equals("confluent.ssl.keystore.type") || config.equals("confluent.ssl.keystore.location") || config.equals("confluent.ssl.keystore.password") || config.equals("confluent.ssl.key.password") || config.equals("confluent.ssl.truststore.type") || config.equals("confluent.ssl.truststore.location") || config.equals("confluent.ssl.truststore.password");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).size();
    }

    private final long customFilteredDescribedConfigCount$1(ConfigResource brokerResource, java.util.Map configs$1) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs$1.get(brokerResource)).entries()).asScala()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ConfigEntry x$8) {
                return x$8.name().startsWith("confluent.license");
            }
        })).size();
    }

    private final java.util.List partitions$1(String topic, Option expectedNumPartitionsOpt) {
        Admin x$58 = this.client();
        String x$59 = topic;
        Option x$60 = expectedNumPartitionsOpt;
        DescribeTopicsOptions x$61 = this.getTopicMetadata$default$3();
        return this.getTopicMetadata(x$58, x$59, x$61, (Option<Object>)x$60).partitions();
    }

    private final Option partitions$default$2$1() {
        return None$.MODULE$;
    }

    public final int kafka$api$PlaintextAdminIntegrationTest$$numPartitions$1(String topic, Option expectedNumPartitionsOpt) {
        return this.partitions$1(topic, expectedNumPartitionsOpt).size();
    }

    public final Option kafka$api$PlaintextAdminIntegrationTest$$numPartitions$default$2$1() {
        return None$.MODULE$;
    }

    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerIndex$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final int followerIndex$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                Option option = ((KafkaServer)this.$outer.servers().apply(this.followerIndex$1)).replicaManager().localLog(this.$outer.topicPartition());
                None$ none$ = None$.MODULE$;
                return option != null ? !option.equals(none$) : none$ != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerIndex$1 = followerIndex$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Expected follower to create replica for partition";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerIndex$1, expectedStartOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final int followerIndex$1;
            private final long expectedStartOffset$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((AbstractLog)((KafkaServer)this.$outer.servers().apply(this.followerIndex$1)).replicaManager().localLog(this.$outer.topicPartition()).get()).logStartOffset() == this.expectedStartOffset$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerIndex$1 = followerIndex$1;
                this.expectedStartOffset$1 = expectedStartOffset$1;
            }
        }, (Function0<String>)new Serializable(this, expectedStartOffset){
            public static final long serialVersionUID = 0L;
            private final long expectedStartOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected follower to discover new log start offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedStartOffset$1)}));
            }
            {
                this.expectedStartOffset$1 = expectedStartOffset$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerIndex$1, expectedEndOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final int followerIndex$1;
            private final long expectedEndOffset$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((AbstractLog)((KafkaServer)this.$outer.servers().apply(this.followerIndex$1)).replicaManager().localLog(this.$outer.topicPartition()).get()).logEndOffset() == this.expectedEndOffset$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerIndex$1 = followerIndex$1;
                this.expectedEndOffset$1 = expectedEndOffset$1;
            }
        }, (Function0<String>)new Serializable(this, expectedEndOffset){
            public static final long serialVersionUID = 0L;
            private final long expectedEndOffset$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected follower to catch up to log end offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.expectedEndOffset$1)}));
            }
            {
                this.expectedEndOffset$1 = expectedEndOffset$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public final int kafka$api$PlaintextAdminIntegrationTest$$preferredLeader$1(TopicPartition topicPartition) {
        TopicPartitionInfo partitionMetadata = (TopicPartitionInfo)this.getTopicMetadata(this.client(), topicPartition.topic(), this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4()).partitions().get(topicPartition.partition());
        Node preferredLeaderMetadata = (Node)partitionMetadata.replicas().get(0);
        return preferredLeaderMetadata.id();
    }

    private final void changePreferredLeader$1(Seq newAssignment, TopicPartition partition1$1, TopicPartition partition2$1) {
        int preferred = BoxesRunTime.unboxToInt((Object)newAssignment.head());
        int prior1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition1$1).get());
        int prior2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition2$1).get());
        scala.collection.immutable.Map m = Predef$.MODULE$.Map().empty();
        if (prior1 != preferred) {
            m = m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1$1), (Object)newAssignment));
        }
        if (prior2 != preferred) {
            m = m.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2$1), (Object)newAssignment));
        }
        this.zkClient().createPartitionReassignment((Map)m);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, partition1$1, partition2$1, preferred){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final TopicPartition partition1$1;
            private final TopicPartition partition2$1;
            private final int preferred$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$api$PlaintextAdminIntegrationTest$$preferredLeader$1(this.partition1$1) == this.preferred$1 && this.$outer.kafka$api$PlaintextAdminIntegrationTest$$preferredLeader$1(this.partition2$1) == this.preferred$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition1$1 = partition1$1;
                this.partition2$1 = partition2$1;
                this.preferred$1 = preferred$1;
            }
        }, (Function0<String>)new Serializable(this, partition1$1, partition2$1, preferred){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlaintextAdminIntegrationTest $outer;
            private final TopicPartition partition1$1;
            private final TopicPartition partition2$1;
            private final int preferred$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected preferred leader to become ", ", but is ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.preferred$1), BoxesRunTime.boxToInteger((int)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$preferredLeader$1(this.partition1$1)), BoxesRunTime.boxToInteger((int)this.$outer.kafka$api$PlaintextAdminIntegrationTest$$preferredLeader$1(this.partition2$1))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition1$1 = partition1$1;
                this.partition2$1 = partition2$1;
                this.preferred$1 = preferred$1;
            }
        }, 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1$1, prior1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2$1, prior2);
    }

    private final void assertLogLevelDidNotChange$1(String validLoggerName$1, ConfigEntry expectedValidLoggerLogLevel$1) {
        Assert.assertEquals((Object)expectedValidLoggerLogLevel$1, (Object)this.describeBrokerLoggers().get(validLoggerName$1));
    }

    public PlaintextAdminIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
    }
}

