/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u0001\u001d\u00111\u0004\u0015:pIV\u001cWM\u001d$bS2,(/\u001a%b]\u0012d\u0017N\\4UKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0006j]R,wM]1uS>t\u0017BA\u0007\u000b\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\nU\t!\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{KV\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0002J]RDa!\b\u0001!\u0002\u00131\u0012a\u00059s_\u0012,8-\u001a:Ck\u001a4WM]*ju\u0016\u0004\u0003bB\u0010\u0001\u0005\u0004%I!F\u0001\u0016g\u0016\u0014h/\u001a:NKN\u001c\u0018mZ3NCb\u0014\u0015\u0010^3t\u0011\u0019\t\u0003\u0001)A\u0005-\u000512/\u001a:wKJlUm]:bO\u0016l\u0015\r\u001f\"zi\u0016\u001c\b\u0005C\u0004$\u0001\t\u0007I\u0011B\u000b\u0002;I,\u0007\u000f\\5dC\u001a+Go\u00195NCb\u0004\u0016M\u001d;ji&|gNQ=uKNDa!\n\u0001!\u0002\u00131\u0012A\b:fa2L7-\u0019$fi\u000eDW*\u0019=QCJ$\u0018\u000e^5p]\nKH/Z:!\u0011\u001d9\u0003A1A\u0005\nU\tAD]3qY&\u001c\u0017MR3uG\"l\u0015\r\u001f*fgB|gn]3CsR,7\u000f\u0003\u0004*\u0001\u0001\u0006IAF\u0001\u001ee\u0016\u0004H.[2b\r\u0016$8\r['bqJ+7\u000f]8og\u0016\u0014\u0015\u0010^3tA!91\u0006\u0001b\u0001\n\u0003)\u0012A\u00038v[N+'O^3sg\"1Q\u0006\u0001Q\u0001\nY\t1B\\;n'\u0016\u0014h/\u001a:tA!9q\u0006\u0001b\u0001\n\u0003\u0001\u0014aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003E\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4G\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u000f\u0001!\u0002\u0013\t\u0014\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0011\u0015a\u0004\u0001\"\u0001>\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001 \u0011\u0007}\u0012E)D\u0001A\u0015\t\t\u0005$\u0001\u0006d_2dWm\u0019;j_:L!a\u0011!\u0003\u0007M+\u0017\u000f\u0005\u0002F\u00116\taI\u0003\u0002H\t\u000511/\u001a:wKJL!!\u0013$\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0017\u0002\u0001\r\u0011\"\u0003M\u0003%\u0001(o\u001c3vG\u0016\u0014\u0018'F\u0001N!\u0011q\u0005L\u0017.\u000e\u0003=S!\u0001U)\u0002\u0011A\u0014x\u000eZ;dKJT!AU*\u0002\u000f\rd\u0017.\u001a8ug*\u0011Q\u0001\u0016\u0006\u0003+Z\u000ba!\u00199bG\",'\"A,\u0002\u0007=\u0014x-\u0003\u0002Z\u001f\ni1*\u00194lCB\u0013x\u000eZ;dKJ\u00042aF.^\u0013\ta\u0006DA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0018=&\u0011q\f\u0007\u0002\u0005\u0005f$X\rC\u0004b\u0001\u0001\u0007I\u0011\u00022\u0002\u001bA\u0014x\u000eZ;dKJ\ft\fJ3r)\t\u0019g\r\u0005\u0002\u0018I&\u0011Q\r\u0007\u0002\u0005+:LG\u000fC\u0004hA\u0006\u0005\t\u0019A'\u0002\u0007a$\u0013\u0007\u0003\u0004j\u0001\u0001\u0006K!T\u0001\u000baJ|G-^2feF\u0002\u0003bB6\u0001\u0001\u0004%I\u0001T\u0001\naJ|G-^2feJBq!\u001c\u0001A\u0002\u0013%a.A\u0007qe>$WoY3se}#S-\u001d\u000b\u0003G>Dqa\u001a7\u0002\u0002\u0003\u0007Q\n\u0003\u0004r\u0001\u0001\u0006K!T\u0001\u000baJ|G-^2feJ\u0002\u0003bB:\u0001\u0001\u0004%I\u0001T\u0001\naJ|G-^2feNBq!\u001e\u0001A\u0002\u0013%a/A\u0007qe>$WoY3sg}#S-\u001d\u000b\u0003G^Dqa\u001a;\u0002\u0002\u0003\u0007Q\n\u0003\u0004z\u0001\u0001\u0006K!T\u0001\u000baJ|G-^2feN\u0002\u0003bB>\u0001\u0001\u0004%I\u0001T\u0001\naJ|G-^2feRBq! \u0001A\u0002\u0013%a0A\u0007qe>$WoY3si}#S-\u001d\u000b\u0003G~Dqa\u001a?\u0002\u0002\u0003\u0007Q\nC\u0004\u0002\u0004\u0001\u0001\u000b\u0015B'\u0002\u0015A\u0014x\u000eZ;dKJ$\u0004\u0005C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n\u00051Ao\u001c9jGF*\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u00056\u0003\u0011a\u0017M\\4\n\t\u0005U\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0017\tq\u0001^8qS\u000e\f\u0004\u0005C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003\u0002\n\u00051Ao\u001c9jGJB\u0001\"!\t\u0001A\u0003%\u00111B\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u001d\t)\u0003\u0001C!\u0003O\tQa]3u+B$\u0012a\u0019\u0015\u0005\u0003G\tY\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\tDV\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003k\tyC\u0001\u0004CK\u001a|'/\u001a\u0005\b\u0003s\u0001A\u0011IA\u0014\u0003!!X-\u0019:E_^t\u0007\u0006BA\u001c\u0003{\u0001B!!\f\u0002@%!\u0011\u0011IA\u0018\u0005\u0015\te\r^3s\u0011\u001d\t)\u0005\u0001C\u0001\u0003O\tQ\u0004^3tiR{w\u000eT1sO\u0016\u0014VmY8sI^KG\u000f[!dWj+'o\u001c\u0015\u0005\u0003\u0007\nI\u0005\u0005\u0003\u0002.\u0005-\u0013\u0002BA'\u0003_\u0011A\u0001V3ti\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005\u001d\u0012\u0001\b;fgR$vn\u001c'be\u001e,'+Z2pe\u0012<\u0016\u000e\u001e5BG.|e.\u001a\u0015\u0005\u0003\u001f\nI\u0005C\u0004\u0002X\u0001!I!!\u0017\u0002W\rDWmY6U_>d\u0015M]4f%\u0016\u001cwN\u001d3G_J\u0014V\r\u001d7jG\u0006$\u0018n\u001c8XSRD\u0017iY6BY2$2aYA.\u0011\u001d\ti&!\u0016A\u0002Y\tA\"\\1y\r\u0016$8\r[*ju\u0016Dq!!\u0019\u0001\t\u0003\t9#A\u0017uKN$\b+\u0019:uSRLwN\u001c+p_2\u000b'oZ3G_J\u0014V\r\u001d7jG\u0006$\u0018n\u001c8XSRD\u0017iY6BY2DC!a\u0018\u0002J!9\u0011q\r\u0001\u0005\u0002\u0005\u001d\u0012\u0001\f;fgR\u0014Vm\u001d9p]N,Gk\\8MCJ<WMR8s%\u0016\u0004H.[2bi&|gnV5uQ\u0006\u001b7.\u00117mQ\u0011\t)'!\u0013\t\u000f\u00055\u0004\u0001\"\u0001\u0002(\u0005!B/Z:u\u001d>tW\t_5ti\u0016tG\u000fV8qS\u000eDC!a\u001b\u0002J!9\u00111\u000f\u0001\u0005\u0002\u0005\u001d\u0012a\u0005;fgR<&o\u001c8h\u0005J|7.\u001a:MSN$\b\u0006BA9\u0003\u0013Bq!!\u001f\u0001\t\u0003\t9#\u0001\u000buKN$\u0018J\u001c<bY&$\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003o\nI\u0005C\u0004\u0002\u0000\u0001!\t!a\n\u0002'Q,7\u000f^*f]\u0012\fe\r^3s\u00072|7/\u001a3)\t\u0005u\u0014\u0011\n\u0005\b\u0003\u000b\u0003A\u0011AA\u0014\u0003u!Xm\u001d;DC:tw\u000e^*f]\u0012$v.\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007\u0006BAB\u0003\u0013Bq!a#\u0001\t\u0003\t9#A\u000buKN$hj\u001c;F]>,x\r\u001b*fa2L7-Y:)\t\u0005%\u0015\u0011\n\u0005\b\u0003#\u0003A\u0011AA\u0014\u0003!\"Xm\u001d;O_R,en\\;hQJ+\u0007\u000f\\5dCN\fe\r^3s\u0005J|7.\u001a:TQV$Hm\\<oQ\u0011\ty)!\u0013")
public class ProducerFailureHandlingTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int replicaFetchMaxPartitionBytes = this.serverMessageMaxBytes() + 200;
    private final int replicaFetchMaxResponseBytes = this.replicaFetchMaxPartitionBytes() + 200;
    private final int numServers;
    private final Properties overridingProps = new Properties();
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4;
    private final String topic1;
    private final String topic2;

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    private int replicaFetchMaxPartitionBytes() {
        return this.replicaFetchMaxPartitionBytes;
    }

    private int replicaFetchMaxResponseBytes() {
        return this.replicaFetchMaxResponseBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer1;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer2;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer3;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer4;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$2 = this.brokerList();
        int x$3 = 0;
        int x$4 = 0;
        int x$5 = 30000;
        long x$6 = 10000L;
        long x$7 = this.producerBufferSize();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$12 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$13 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$14 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$16 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$17 = TestUtils$.MODULE$.createProducer$default$16();
        this.kafka$api$ProducerFailureHandlingTest$$producer1_$eq(TestUtils$.MODULE$.createProducer(x$2, x$3, x$6, x$7, x$4, x$8, x$9, x$10, x$11, x$5, x$12, x$13, x$14, x$15, x$16, x$17));
        String x$18 = this.brokerList();
        int x$19 = 1;
        int x$20 = 0;
        int x$21 = 30000;
        long x$22 = 10000L;
        long x$23 = this.producerBufferSize();
        int x$24 = TestUtils$.MODULE$.createProducer$default$6();
        int x$25 = TestUtils$.MODULE$.createProducer$default$7();
        int x$26 = TestUtils$.MODULE$.createProducer$default$8();
        String x$27 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$28 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$29 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$30 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$31 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$32 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$33 = TestUtils$.MODULE$.createProducer$default$16();
        this.kafka$api$ProducerFailureHandlingTest$$producer2_$eq(TestUtils$.MODULE$.createProducer(x$18, x$19, x$22, x$23, x$20, x$24, x$25, x$26, x$27, x$21, x$28, x$29, x$30, x$31, x$32, x$33));
        String x$34 = this.brokerList();
        int x$35 = -1;
        int x$36 = 0;
        int x$37 = 30000;
        long x$38 = 10000L;
        long x$39 = this.producerBufferSize();
        int x$40 = TestUtils$.MODULE$.createProducer$default$6();
        int x$41 = TestUtils$.MODULE$.createProducer$default$7();
        int x$42 = TestUtils$.MODULE$.createProducer$default$8();
        String x$43 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$44 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$45 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$46 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$47 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$48 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$49 = TestUtils$.MODULE$.createProducer$default$16();
        this.kafka$api$ProducerFailureHandlingTest$$producer3_$eq(TestUtils$.MODULE$.createProducer(x$34, x$35, x$38, x$39, x$36, x$40, x$41, x$42, x$43, x$37, x$44, x$45, x$46, x$47, x$48, x$49));
    }

    @Override
    @After
    public void tearDown() {
        if (this.kafka$api$ProducerFailureHandlingTest$$producer1() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer1().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer2() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer2().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer3() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer4() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer4().close();
        }
        super.tearDown();
    }

    @Test
    public void testTooLargeRecordWithAckZero() {
        String x$50 = this.topic1();
        int x$51 = this.numServers();
        int x$52 = this.createTopic$default$2();
        Properties x$53 = this.createTopic$default$4();
        this.createTopic(x$50, x$52, x$51, x$53);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        RecordMetadata recordMetadata = (RecordMetadata)this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get();
        Assert.assertNotNull((Object)recordMetadata);
        Assert.assertFalse((boolean)recordMetadata.hasOffset());
        Assert.assertEquals((long)-1L, (long)recordMetadata.offset());
    }

    @Test
    public void testTooLargeRecordWithAckOne() {
        String x$54 = this.topic1();
        int x$55 = this.numServers();
        int x$56 = this.createTopic$default$2();
        Properties x$57 = this.createTopic$default$4();
        this.createTopic(x$54, x$56, x$55, x$57);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$1;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$1).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$1 = record$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }

    private void checkTooLargeRecordForReplicationWithAckAll(int maxFetchSize) {
        int maxMessageSize = maxFetchSize + 100;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
        topicConfig.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)maxMessageSize)).toString());
        String topic10 = "topic10";
        this.createTopic(topic10, this.servers().size(), this.numServers(), topicConfig);
        byte[] value = new byte[maxMessageSize - 61 - 21];
        ProducerRecord record = new ProducerRecord(topic10, null, (Object)value);
        RecordMetadata recordMetadata = (RecordMetadata)this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        Assert.assertEquals((Object)topic10, (Object)recordMetadata.topic());
    }

    @Test
    public void testPartitionTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxPartitionBytes());
    }

    @Test
    public void testResponseTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxResponseBytes());
    }

    @Test
    public void testNonExistentTopic() {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$2;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$2).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = record$2;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
    }

    @Test
    public void testWrongBrokerList() {
        String x$58 = this.topic1();
        int x$59 = this.numServers();
        int x$60 = this.createTopic$default$2();
        Properties x$61 = this.createTopic$default$4();
        this.createTopic(x$58, x$60, x$59, x$61);
        this.kafka$api$ProducerFailureHandlingTest$$producer4_$eq(TestUtils$.MODULE$.createProducer("localhost:8686,localhost:4242", 1, 10000L, this.producerBufferSize(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$3;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer4().send(this.record$3).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$3 = record$3;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
    }

    @Test
    public void testInvalidPartition() {
        this.createTopic(this.topic1(), 1, this.numServers(), this.createTopic$default$4());
        ProducerRecord higherRecord = new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        Throwable throwable = ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, higherRecord){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord higherRecord$1;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.higherRecord$1).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.higherRecord$1 = higherRecord$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195))).getCause();
        if (throwable instanceof TimeoutException) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
    }

    @Test
    public void testSendAfterClosed() {
        String x$62 = this.topic1();
        int x$63 = this.numServers();
        int x$64 = this.createTopic$default$2();
        Properties x$65 = this.createTopic$default$4();
        this.createTopic(x$62, x$64, x$63, x$65);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer2().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
    }

    @Test
    public void testCannotSendToInternalTopic() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ExecutionException thrown = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(new ProducerRecord("__consumer_offsets", (Object)"test".getBytes(), (Object)"test".getBytes())).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        Assert.assertTrue((String)new StringBuilder().append((Object)"Unexpected exception while sending to an invalid topic ").append((Object)thrown.getCause()).toString(), (boolean)(thrown.getCause() instanceof InvalidTopicException));
    }

    @Test
    public void testNotEnoughReplicas() {
        block2: {
            String topicName = "minisrtest";
            Properties topicProps = new Properties();
            topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)(this.numServers() + 1))).toString());
            String x$66 = topicName;
            int x$67 = this.numServers();
            Properties x$68 = topicProps;
            int x$69 = this.createTopic$default$2();
            this.createTopic(x$66, x$69, x$67, x$68);
            ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
            try {
                this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
                Assert.fail((String)"Expected exception when producing to topic with fewer brokers than min.insync.replicas");
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof NotEnoughReplicasException) break block2;
                Assert.fail((String)"Expected NotEnoughReplicasException when producing to topic with fewer brokers than min.insync.replicas");
            }
        }
    }

    @Test
    public void testNotEnoughReplicasAfterBrokerShutdown() {
        block2: {
            String topicName = "minisrtest2";
            Properties topicProps = new Properties();
            topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
            String x$70 = topicName;
            int x$71 = this.numServers();
            Properties x$72 = topicProps;
            int x$73 = this.createTopic$default$2();
            this.createTopic(x$70, x$73, x$71, x$72);
            ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
            this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
            ((KafkaServer)this.servers().head()).shutdown();
            ((KafkaServer)this.servers().head()).awaitShutdown();
            try {
                this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
                Assert.fail((String)"Expected exception when producing to topic with fewer brokers than min.insync.replicas");
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof NotEnoughReplicasException || executionException.getCause() instanceof NotEnoughReplicasAfterAppendException || executionException.getCause() instanceof TimeoutException) break block2;
                Assert.fail((String)new StringBuilder().append((Object)"Expected NotEnoughReplicasException or NotEnoughReplicasAfterAppendException when producing to topic with fewer brokers than min.insync.replicas, but saw ").append((Object)executionException.getCause()).toString());
            }
        }
        ((KafkaServer)this.servers().head()).startup();
    }

    public ProducerFailureHandlingTest() {
        this.producerBufferSize = 30000;
        this.numServers = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxPartitionBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxResponseBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = null;
        this.topic1 = "topic-1";
        this.topic2 = "topic-2";
    }
}

