/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001\u001d\u0011!\u0004\u0016:b]N\f7\r^5p]N,\u0005\u0010]5sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aC5oi\u0016<'/\u0019;j_:L!!\u0004\u0006\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u00051Ao\u001c9jGF*\u0012A\u0006\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tA\u0001\\1oO*\t1$\u0001\u0003kCZ\f\u0017BA\u000f\u0019\u0005\u0019\u0019FO]5oO\"1q\u0004\u0001Q\u0001\nY\tq\u0001^8qS\u000e\f\u0004\u0005C\u0004\"\u0001\t\u0007I\u0011A\u000b\u0002\rQ|\u0007/[23\u0011\u0019\u0019\u0003\u0001)A\u0005-\u00059Ao\u001c9jGJ\u0002\u0003bB\u0013\u0001\u0005\u0004%\tAJ\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u00121!\u00138u\u0011\u0019q\u0003\u0001)A\u0005O\u0005qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%\tAJ\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\bB\u0002\u001a\u0001A\u0003%q%\u0001\nsKBd\u0017nY1uS>tg)Y2u_J\u0004\u0003\"\u0003\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u00016\u0003!\u0001(o\u001c3vG\u0016\u0014X#\u0001\u001c\u0011\t]\u0002%IQ\u0007\u0002q)\u0011A'\u000f\u0006\u0003um\nqa\u00197jK:$8O\u0003\u0002\u0006y)\u0011QHP\u0001\u0007CB\f7\r[3\u000b\u0003}\n1a\u001c:h\u0013\t\t\u0005HA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004Q\r+\u0015B\u0001#*\u0005\u0015\t%O]1z!\tAc)\u0003\u0002HS\t!!)\u001f;f\u0011%I\u0005\u00011AA\u0002\u0013\u0005!*\u0001\u0007qe>$WoY3s?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011\u0001\u0006T\u0005\u0003\u001b&\u0012A!\u00168ji\"9q\nSA\u0001\u0002\u00041\u0014a\u0001=%c!1\u0011\u000b\u0001Q!\nY\n\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\t\u0013M\u0003\u0001\u0019!a\u0001\n\u0003!\u0016\u0001C2p]N,X.\u001a:\u0016\u0003U\u0003BA\u0016-C\u00056\tqK\u0003\u0002Ts%\u0011\u0011l\u0016\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\t\u0013m\u0003\u0001\u0019!a\u0001\n\u0003a\u0016\u0001D2p]N,X.\u001a:`I\u0015\fHCA&^\u0011\u001dy%,!AA\u0002UCaa\u0018\u0001!B\u0013)\u0016!C2p]N,X.\u001a:!\u0011\u0015\t\u0007\u0001\"\u0011c\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A2\u0011\u0007\u0011<\u0017.D\u0001f\u0015\t1\u0017&\u0001\u0006d_2dWm\u0019;j_:L!\u0001[3\u0003\u0007M+\u0017\u000f\u0005\u0002k[6\t1N\u0003\u0002m\t\u000511/\u001a:wKJL!A\\6\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0006a\u0002!\t%]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u0017\"\u0012qn\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mz\nQA[;oSRL!\u0001_;\u0003\r\t+gm\u001c:f\u0011\u0015Q\b\u0001\"\u0011r\u0003!!X-\u0019:E_^t\u0007FA=}!\t!X0\u0003\u0002\u007fk\n)\u0011I\u001a;fe\"1\u0011\u0011\u0001\u0001\u0005\u0002E\fq\u0007^3ti\n+X\u000e\u001d+sC:\u001c\u0018m\u0019;j_:\fG.\u00129pG\"\fe\r^3s\u0013:4\u0018\r\\5e!J|G-^2fe&#W*\u00199qS:<\u0007fA@\u0002\u0006A\u0019A/a\u0002\n\u0007\u0005%QO\u0001\u0003UKN$\bbBA\u0007\u0001\u0011%\u0011qB\u0001\fg\u0016\u0014h/\u001a:Qe>\u00048\u000f\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018i\tA!\u001e;jY&!\u00111DA\u000b\u0005)\u0001&o\u001c9feRLWm\u001d")
public class TransactionsExpirationTest
extends KafkaServerTestHarness {
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final int replicationFactor;
    private KafkaProducer<byte[], byte[]> producer;
    private KafkaConsumer<byte[], byte[]> consumer;

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionsExpirationTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.kafka$api$TransactionsExpirationTest$$serverProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTransactionalProducer$default$3(), TestUtils$.MODULE$.createTransactionalProducer$default$4(), TestUtils$.MODULE$.createTransactionalProducer$default$5(), TestUtils$.MODULE$.createTransactionalProducer$default$6()));
        String x$2 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$3 = false;
        boolean x$4 = true;
        String x$5 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$8 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$9 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$10 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$12 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$2, x$5, x$6, x$3, x$4, x$7, x$8, x$9, x$10, x$11, x$12));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), this.numPartitions(), 3, (Seq<KafkaServer>)this.servers(), new Properties());
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic2(), this.numPartitions(), 3, (Seq<KafkaServer>)this.servers(), new Properties());
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        this.consumer().close();
        super.tearDown();
    }

    @Test
    public void testBumpTransactionalEpochAfterInvalidProducerIdMapping() {
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(0), "4", "4", false));
        this.producer().abortTransaction();
        Thread.sleep(3000L);
        this.producer().beginTransaction();
        Future failedFuture = this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "1", "1", false));
        Thread.sleep(500L);
        TestUtils.assertFutureThrows((Future)failedFuture, InvalidPidMappingException.class);
        this.producer().abortTransaction();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(2), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "1", "1", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "3", "3", true));
        this.producer().commitTransaction();
        this.consumer().subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records2 = TestUtils$.MODULE$.consumeRecords(this.consumer(), 4, TestUtils$.MODULE$.consumeRecords$default$3());
        records2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConsumerRecord<byte[], byte[]> record) {
                return TestUtils$.MODULE$.assertCommittedAndGetValue(record);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties kafka$api$TransactionsExpirationTest$$serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        serverProps.put(KafkaConfig$.MODULE$.TransactionalIdExpirationMsProp(), "2000");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsRemoveExpiredTransactionalIdCleanupIntervalMsProp(), "500");
        return var1_1;
    }

    public TransactionsExpirationTest() {
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
        this.replicationFactor = 3;
    }
}

