/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager;
import kafka.controller.TopicDeletionManagerTest$;
import kafka.controller.TopicDeletionManagerTest$$anonfun$initContext$1$;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0004V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0006d_:$(o\u001c7mKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013%Q#\u0001\u0005ce>\\WM]%e+\u00051\u0002CA\u0005\u0018\u0013\tA\"BA\u0002J]RDaA\u0007\u0001!\u0002\u00131\u0012!\u00032s_.,'/\u00133!\u0011\u001da\u0002A1A\u0005\nu\taaY8oM&<W#\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\"\u0011AB:feZ,'/\u0003\u0002$A\tY1*\u00194lC\u000e{gNZ5h\u0011\u0019)\u0003\u0001)A\u0005=\u000591m\u001c8gS\u001e\u0004\u0003bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\u000fI\u0016dW\r^5p]\u000ec\u0017.\u001a8u+\u0005I\u0003C\u0001\n+\u0013\tY#A\u0001\bEK2,G/[8o\u00072LWM\u001c;\t\r5\u0002\u0001\u0015!\u0003*\u0003=!W\r\\3uS>t7\t\\5f]R\u0004\u0003\"B\u0018\u0001\t\u0003\u0001\u0014!B:fiV\u0004H#A\u0019\u0011\u0005%\u0011\u0014BA\u001a\u000b\u0005\u0011)f.\u001b;)\u00059*\u0004C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0015QWO\\5u\u0015\u0005Q\u0014aA8sO&\u0011Ah\u000e\u0002\u0007\u0005\u00164wN]3\t\u000by\u0002A\u0011\u0001\u0019\u0002%Q,7\u000f^%oSRL\u0017\r\\5{CRLwN\u001c\u0015\u0003{\u0001\u0003\"AN!\n\u0005\t;$\u0001\u0002+fgRDQ\u0001\u0012\u0001\u0005\u0002A\n\u0011\u0003^3ti\n\u000b7/[2EK2,G/[8oQ\t\u0019\u0005\tC\u0003H\u0001\u0011\u0005\u0001'\u0001\u0010uKN$()Y:jG\u0012+G.\u001a;j_:|e\rV5fe\u0016$Gk\u001c9jG\"\u0012a\t\u0011\u0005\u0006\u0015\u0002!\t\u0001M\u0001%i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8XQ\u0016tG)\u001a7fi&tw\rV5fe\u0016$Gk\u001c9jG\"\u0012\u0011\n\u0011\u0005\u0006\u001b\u0002!\t\u0001M\u0001\"i\u0016\u001cH\u000fR3mKRLwN\u001c#ve&twm\u00155vi\u0012|wO\u001c)s_\u000e,7o\u001d\u0015\u0003\u0019\u0002CQ\u0001\u0015\u0001\u0005\u0002A\nQ\u0004^3ti\u0012+G.\u001a;j_:<\u0016\u000e\u001e5Ce>\\WM](gM2Lg.\u001a\u0015\u0003\u001f\u0002CQa\u0015\u0001\u0005\u0002A\nQ\u0005^3ti\n\u0013xn[3s\r\u0006LG.\u001e:f\u0003\u001a$XM\u001d#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3)\u0005I\u0003\u0005\"\u0002,\u0001\t\u0003\u0001\u0014\u0001\t;fgRlU\u000f\u001c;ja2,G+[3sK\u0012$v\u000e]5d\t\u0016dW\r^5p]ND#!\u0016!\t\u000be\u0003A\u0011\u0001.\u0002\u0017%t\u0017\u000e^\"p]R,\u0007\u0010\u001e\u000b\u00077zc\u0007P\u001f?\u0011\u0005Ia\u0016BA/\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0006?b\u0003\r\u0001Y\u0001\bEJ|7.\u001a:t!\r\t\u0017N\u0006\b\u0003E\u001et!a\u00194\u000e\u0003\u0011T!!\u001a\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011B\u00015\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L!A[6\u0003\u0007M+\u0017O\u0003\u0002i\u0015!)Q\u000e\u0017a\u0001]\u00061Ao\u001c9jGN\u00042a\u001c:v\u001d\tI\u0001/\u0003\u0002r\u0015\u00051\u0001K]3eK\u001aL!a\u001d;\u0003\u0007M+GO\u0003\u0002r\u0015A\u0011qN^\u0005\u0003oR\u0014aa\u0015;sS:<\u0007\"B=Y\u0001\u00041\u0012!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0003|1\u0002\u0007a#A\tsKBd\u0017nY1uS>tg)Y2u_JDq! -\u0011\u0002\u0003\u0007a0\u0001\u0006bI\u0012$v\u000e]5d\u0013\u0012\u0004\"!C@\n\u0007\u0005\u0005!BA\u0004C_>dW-\u00198\t\u0013\u0005\u0015\u0001!%A\u0005\u0002\u0005\u001d\u0011!F5oSR\u001cuN\u001c;fqR$C-\u001a4bk2$H%N\u000b\u0003\u0003\u0013Q3A`A\u0006W\t\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\f\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0011\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TopicDeletionManagerTest {
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private DeletionClient deletionClient() {
        return this.deletionClient;
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.deletionClient().topicConfig((String)ArgumentMatchers.any(), (KafkaConfig)ArgumentMatchers.any())).thenReturn((Object)LogConfig$.MODULE$.fromProps(this.config().originals(), new Properties()));
    }

    @Test
    public void testInitialization() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar", "baz"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$);
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "baz"})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted().toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), (Object)controllerContext.topicsIneligibleForDeletion().toSet());
    }

    @Test
    public void testBasicDeletion() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$);
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        Set barPartitions = controllerContext.partitionsForTopic("bar");
        scala.collection.immutable.Set barReplicas = controllerContext.replicasForPartition(barPartitions).toSet();
        replicaStateMachine.clear();
        partitionStateMachine.clear();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assert.assertEquals((Object)barPartitions, (Object)controllerContext.partitionsInState("bar", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)barReplicas, (Object)controllerContext.replicasInState("bar", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions.$plus$plus((GenTraversableOnce)barPartitions));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion(fooReplicas.$plus$plus((GenTraversableOnce)barReplicas));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionAndReplica x$1) {
                String string = x$1.topic();
                String string2 = "foo";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("bar"));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionAndReplica x$2) {
                String string = x$2.topic();
                String string2 = "bar";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        Assert.assertEquals((long)1L, (long)partitionStateMachine.stateChangesCalls((PartitionState)OfflinePartition$.MODULE$));
        Assert.assertEquals((long)1L, (long)partitionStateMachine.stateChangesCalls((PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((long)1L, (long)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionIneligible$.MODULE$));
        Assert.assertEquals((long)1L, (long)replicaStateMachine.stateChangesCalls((ReplicaState)OfflineReplica$.MODULE$));
        Assert.assertEquals((long)1L, (long)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionStarted$.MODULE$));
        Assert.assertEquals((long)1L, (long)replicaStateMachine.stateChangesCalls((ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
    }

    @Test
    public void testBasicDeletionOfTieredTopic() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        Properties topicProperties = new Properties();
        topicProperties.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        Mockito.when((Object)this.deletionClient().topicConfig((String)ArgumentMatchers.any(), (KafkaConfig)ArgumentMatchers.any())).thenReturn((Object)LogConfig$.MODULE$.fromProps(config.originals(), topicProperties));
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager));
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        BooleanRef finishInvoked = BooleanRef.create((boolean)false);
        this.deletionClient().completeDeleteTopic((String)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this, deletionManager, finishInvoked){
            private final TopicDeletionManager deletionManager$1;
            private final BooleanRef finishInvoked$1;

            public void answer(InvocationOnMock invocation) {
                this.deletionManager$1.finishTopicDelete((String)invocation.getArgument(0));
                this.finishInvoked$1.elem = true;
            }
            {
                this.deletionManager$1 = deletionManager$1;
                this.finishInvoked$1 = finishInvoked$1;
            }
        });
        future.complete(TierPartitionState.AppendResult.ACCEPTED);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, finishInvoked){
            public static final long serialVersionUID = 0L;
            private final BooleanRef finishInvoked$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.finishInvoked$1.elem;
            }
            {
                this.finishInvoked$1 = finishInvoked$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for deletion to be completed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionAndReplica x$3) {
                String string = x$3.topic();
                String string2 = "foo";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    @Test
    public void testExceptionWhenDeletingTieredTopic() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        Properties topicProperties = new Properties();
        topicProperties.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        Mockito.when((Object)this.deletionClient().topicConfig((String)ArgumentMatchers.any(), (KafkaConfig)ArgumentMatchers.any())).thenReturn((Object)LogConfig$.MODULE$.fromProps(config.originals(), topicProperties));
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        CompletableFuture futureWithException = new CompletableFuture();
        futureWithException.completeExceptionally((Throwable)new TierMetadataRetriableException("exception on tier topic append"));
        CompletableFuture<TierPartitionState.AppendResult> successfulFuture = CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(futureWithException);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager));
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        this.deletionClient().completeDeleteTopic((String)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this, deletionManager){
            private final TopicDeletionManager deletionManager$2;

            public void answer(InvocationOnMock invocation) {
                this.deletionManager$2.finishTopicDelete((String)invocation.getArgument(0));
            }
            {
                this.deletionManager$2 = deletionManager$2;
            }
        });
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(successfulFuture);
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionAndReplica x$4) {
                String string = x$4.topic();
                String string2 = "foo";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    @Test
    public void testDeletionDuringShutdownProcess() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        Properties topicProperties = new Properties();
        topicProperties.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        Mockito.when((Object)this.deletionClient().topicConfig((String)ArgumentMatchers.any(), (KafkaConfig)ArgumentMatchers.any())).thenReturn((Object)LogConfig$.MODULE$.fromProps(config.originals(), topicProperties));
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        CompletableFuture futureWithException = new CompletableFuture();
        futureWithException.completeExceptionally(new CancellationException("TierTopicManager is shutting down"));
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(futureWithException);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager));
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
    }

    @Test
    public void testDeletionWithBrokerOffline() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$);
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1)new Serializable(this, failedBrokerId){
            public static final long serialVersionUID = 0L;
            private final int failedBrokerId$1;

            public final boolean apply(PartitionAndReplica x$5) {
                return x$5.replica() == this.failedBrokerId$1;
            }
            {
                this.failedBrokerId$1 = failedBrokerId$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
            scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)offlineReplicas, (Object)onlineReplicas);
            scala.collection.immutable.Set offlineReplicas2 = (scala.collection.immutable.Set)tuple23._1();
            scala.collection.immutable.Set onlineReplicas2 = (scala.collection.immutable.Set)tuple23._2();
            replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)offlineReplicas2.toSeq(), (ReplicaState)OfflineReplica$.MODULE$, replicaStateMachine.handleStateChanges$default$3());
            deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
            Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
            ((DeletionClient)Mockito.verify((Object)this.deletionClient())).sendMetadataUpdate(fooPartitions);
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
            deletionManager.completeReplicaDeletion((Set)onlineReplicas2);
            Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)OfflineReplica$.MODULE$));
            controllerContext.addLiveBrokersAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
            deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            deletionManager.completeReplicaDeletion((Set)offlineReplicas2);
            Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.partitionsForTopic("foo"));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)controllerContext.replicaStates().keySet().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(PartitionAndReplica x$7) {
                    String string = x$7.topic();
                    String string2 = "foo";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
            }));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testBrokerFailureAfterDeletionStarted() {
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, this.initContext$default$5());
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(this.config(), controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)None$.MODULE$);
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((Object)fooPartitions, (Object)controllerContext.partitionsInState("foo", (PartitionState)NonExistentPartition$.MODULE$));
        Assert.assertEquals((Object)fooReplicas, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
        int failedBrokerId = 2;
        Broker offlineBroker = (Broker)controllerContext.liveOrShuttingDownBroker(failedBrokerId).get();
        long lastEpoch = BoxesRunTime.unboxToLong((Object)controllerContext.liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)failedBrokerId)));
        controllerContext.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{failedBrokerId})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})), (Object)controllerContext.liveBrokerIds());
        Tuple2 tuple2 = fooReplicas.partition((Function1)new Serializable(this, failedBrokerId){
            public static final long serialVersionUID = 0L;
            private final int failedBrokerId$2;

            public final boolean apply(PartitionAndReplica x$8) {
                return x$8.replica() == this.failedBrokerId$2;
            }
            {
                this.failedBrokerId$2 = failedBrokerId$2;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Set offlineReplicas = (scala.collection.immutable.Set)tuple2._1();
            scala.collection.immutable.Set onlineReplicas = (scala.collection.immutable.Set)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)offlineReplicas, (Object)onlineReplicas);
            scala.collection.immutable.Set offlineReplicas2 = (scala.collection.immutable.Set)tuple23._1();
            scala.collection.immutable.Set onlineReplicas2 = (scala.collection.immutable.Set)tuple23._2();
            deletionManager.failReplicaDeletion((Set)offlineReplicas2);
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsIneligibleForDeletion());
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            controllerContext.addLiveBrokersAndEpochs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)offlineBroker), (Object)BoxesRunTime.boxToLong((long)(lastEpoch + 1L)))})));
            deletionManager.resumeDeletionForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionIneligible$.MODULE$));
            deletionManager.completeReplicaDeletion((Set)onlineReplicas2);
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsToBeDeleted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)controllerContext.topicsWithDeletionStarted());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)controllerContext.topicsIneligibleForDeletion());
            Assert.assertEquals((Object)onlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionSuccessful$.MODULE$));
            Assert.assertEquals((Object)offlineReplicas2, (Object)controllerContext.replicasInState("foo", (ReplicaState)ReplicaDeletionStarted$.MODULE$));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testMultipleTieredTopicDeletions() {
        Properties brokerProperties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProperties.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(brokerProperties);
        Properties topicProperties = new Properties();
        topicProperties.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        Mockito.when((Object)this.deletionClient().topicConfig((String)ArgumentMatchers.any(), (KafkaConfig)ArgumentMatchers.any())).thenReturn((Object)LogConfig$.MODULE$.fromProps(config.originals(), topicProperties));
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        ControllerContext controllerContext = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3, true);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(controllerContext);
        replicaStateMachine.startup();
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(controllerContext, false);
        partitionStateMachine.startup();
        TopicDeletionManager deletionManager = new TopicDeletionManager(config, controllerContext, (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, this.deletionClient(), (Option)new Some((Object)tierTopicManager));
        Assert.assertTrue((boolean)deletionManager.isDeleteTopicEnabled());
        deletionManager.init((Set)Predef$.MODULE$.Set().empty(), (Set)Predef$.MODULE$.Set().empty());
        ListBuffer deletionsBeingCompleted = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deletionClient().completeDeleteTopic((String)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(this, deletionsBeingCompleted){
            private final ListBuffer deletionsBeingCompleted$1;

            public void answer(InvocationOnMock invocation) {
                this.deletionsBeingCompleted$1.$plus$eq(invocation.getArgument(0));
            }
            {
                this.deletionsBeingCompleted$1 = deletionsBeingCompleted$1;
            }
        });
        Set fooPartitions = controllerContext.partitionsForTopic("foo");
        scala.collection.immutable.Set fooReplicas = controllerContext.replicasForPartition(fooPartitions).toSet();
        Set barPartitions = controllerContext.partitionsForTopic("bar");
        scala.collection.immutable.Set barReplicas = controllerContext.replicasForPartition(barPartitions).toSet();
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        deletionManager.completeReplicaDeletion((Set)fooReplicas);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Object)deletionsBeingCompleted);
        deletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})));
        deletionManager.completeReplicaDeletion((Set)barReplicas);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Object)deletionsBeingCompleted);
    }

    public ControllerContext initContext(Seq<Object> brokers, scala.collection.immutable.Set<String> topics, int numPartitions, int replicationFactor, boolean addTopicId) {
        ControllerContext context = new ControllerContext();
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)brokers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Broker, Object> apply(int brokerId) {
                EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(brokerId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        context.setLiveBrokerAndEpochs((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        topics.foreach((Function1)new Serializable(this, brokers, numPartitions, replicationFactor, context, leaderIndex){
            public static final long serialVersionUID = 0L;
            public final Seq brokers$1;
            private final int numPartitions$1;
            public final int replicationFactor$1;
            public final ControllerContext context$1;
            public final IntRef leaderIndex$1;

            public final void apply(String topic) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions$1).foreach$mVc$sp((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$initContext$1 $outer;
                    private final String topic$1;

                    public final void apply(int partitionId) {
                        this.apply$mcVI$sp(partitionId);
                    }

                    public void apply$mcVI$sp(int partitionId) {
                        TopicPartition partition = new TopicPartition(this.topic$1, partitionId);
                        IndexedSeq replicas = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.replicationFactor$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$initContext$1$$anonfun$apply$1 $outer;

                            public final int apply(int i) {
                                return this.apply$mcII$sp(i);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public int apply$mcII$sp(int i) {
                                void var2_2;
                                int replica = BoxesRunTime.unboxToInt((Object)this.$outer.kafka$controller$TopicDeletionManagerTest$$anonfun$$anonfun$$$outer().brokers$1.apply((i + this.$outer.kafka$controller$TopicDeletionManagerTest$$anonfun$$anonfun$$$outer().leaderIndex$1.elem) % this.$outer.kafka$controller$TopicDeletionManagerTest$$anonfun$$anonfun$$$outer().brokers$1.size()));
                                return (int)var2_2;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        this.$outer.context$1.updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas, (Seq)Seq$.MODULE$.empty()));
                        ++this.$outer.leaderIndex$1.elem;
                    }

                    public /* synthetic */ $anonfun$initContext$1 kafka$controller$TopicDeletionManagerTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$1 = topic$1;
                    }
                });
            }
            {
                this.brokers$1 = brokers$1;
                this.numPartitions$1 = numPartitions$1;
                this.replicationFactor$1 = replicationFactor$1;
                this.context$1 = context$1;
                this.leaderIndex$1 = leaderIndex$1;
            }
        });
        if (addTopicId) {
            topics.foreach((Function1)new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final ControllerContext context$1;

                public final void apply(String topic) {
                    this.context$1.addTopicId(topic, UUID.randomUUID());
                }
                {
                    this.context$1 = context$1;
                }
            });
        }
        return context;
    }

    public boolean initContext$default$5() {
        return false;
    }

    public TopicDeletionManagerTest() {
        this.brokerId = 1;
    }
}

