/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.util.List;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.JoinGroupResult$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import kafka.coordinator.group.SyncGroupResult$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0001\u0003\u0001%\u0011\u0011c\u0012:pkBlU\r^1eCR\fG+Z:u\u0015\t\u0019A!A\u0003he>,\bO\u0003\u0002\u0006\r\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002A1A\u0005\n]\tA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016,\u0012\u0001\u0007\t\u00033yi\u0011A\u0007\u0006\u00037q\tA\u0001\\1oO*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u0019\u0019FO]5oO\"1\u0011\u0005\u0001Q\u0001\na\tQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0003bB\u0012\u0001\u0005\u0004%IaF\u0001\bOJ|W\u000f]%e\u0011\u0019)\u0003\u0001)A\u00051\u0005AqM]8va&#\u0007\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u001f\u001d\u0014x.\u001e9J]N$\u0018M\\2f\u0013\u0012,\u0012!\u000b\t\u0004\u0017)B\u0012BA\u0016\r\u0005\u0011\u0019v.\\3\t\r5\u0002\u0001\u0015!\u0003*\u0003A9'o\\;q\u0013:\u001cH/\u00198dK&#\u0007\u0005C\u00040\u0001\t\u0007I\u0011B\f\u0002\u00115,WNY3s\u0013\u0012Da!\r\u0001!\u0002\u0013A\u0012!C7f[\n,'/\u00133!\u0011\u001d\u0019\u0004A1A\u0005\n]\t\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\r\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003bB\u001c\u0001\u0005\u0004%IaF\u0001\u000bG2LWM\u001c;I_N$\bBB\u001d\u0001A\u0003%\u0001$A\u0006dY&,g\u000e\u001e%pgR\u0004\u0003bB\u001e\u0001\u0005\u0004%I\u0001P\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRl5/F\u0001>!\tYa(\u0003\u0002@\u0019\t\u0019\u0011J\u001c;\t\r\u0005\u0003\u0001\u0015!\u0003>\u0003M\u0011XMY1mC:\u001cW\rV5nK>,H/T:!\u0011\u001d\u0019\u0005A1A\u0005\nq\n\u0001c]3tg&|g\u000eV5nK>,H/T:\t\r\u0015\u0003\u0001\u0015!\u0003>\u0003E\u0019Xm]:j_:$\u0016.\\3pkRl5\u000f\t\u0005\b\u0007\u0001\u0001\r\u0011\"\u0003H+\u0005A\u0005C\u0001\u000bJ\u0013\tQ%AA\u0007He>,\b/T3uC\u0012\fG/\u0019\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003N\u0003%9'o\\;q?\u0012*\u0017\u000f\u0006\u0002O#B\u00111bT\u0005\u0003!2\u0011A!\u00168ji\"9!kSA\u0001\u0002\u0004A\u0015a\u0001=%c!1A\u000b\u0001Q!\n!\u000baa\u001a:pkB\u0004\u0003b\u0002,\u0001\u0001\u0004%IaV\u0001\u0007[\u0016l'-\u001a:\u0016\u0003a\u0003\"\u0001F-\n\u0005i\u0013!AD'f[\n,'/T3uC\u0012\fG/\u0019\u0005\b9\u0002\u0001\r\u0011\"\u0003^\u0003)iW-\u001c2fe~#S-\u001d\u000b\u0003\u001dzCqAU.\u0002\u0002\u0003\u0007\u0001\f\u0003\u0004a\u0001\u0001\u0006K\u0001W\u0001\b[\u0016l'-\u001a:!\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u0015\u0019X\r^+q)\u0005q\u0005FA1f!\t17.D\u0001h\u0015\tA\u0017.A\u0003kk:LGOC\u0001k\u0003\ry'oZ\u0005\u0003Y\u001e\u0014aAQ3g_J,\u0007\"\u00028\u0001\t\u0003\u0019\u0017A\u0007;fgR\u001c\u0015M\u001c*fE\u0006d\u0017M\\2f/\",gn\u0015;bE2,\u0007FA7q!\t1\u0017/\u0003\u0002sO\n!A+Z:u\u0011\u0015!\b\u0001\"\u0001d\u0003\u001d\"Xm\u001d;DC:\u0014VMY1mC:\u001cWm\u00165f]\u000e{W\u000e\u001d7fi&twMU3cC2\fgnY3)\u0005M\u0004\b\"B<\u0001\t\u0003\u0019\u0017!\u000b;fgR\u001c\u0015M\u001c8piJ+'-\u00197b]\u000e,w\u000b[3o!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\r\u000b\u0002wa\")!\u0010\u0001C\u0001G\u0006YB/Z:u\u0007\u0006tgn\u001c;SK\n\fG.\u00198dK^CWM\u001c#fC\u0012D#!\u001f9\t\u000bu\u0004A\u0011A2\u0002QQ,7\u000f^*uC\ndW\rV8Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,GK]1og&$\u0018n\u001c8)\u0005q\u0004\bBBA\u0001\u0001\u0011\u00051-\u0001\u000euKN$8\u000b^1cY\u0016$v\u000eR3bIR\u0013\u0018M\\:ji&|g\u000e\u000b\u0002\u0000a\"1\u0011q\u0001\u0001\u0005\u0002\r\f1\u0007^3ti\u0006;\u0018-\u001b;j]\u001e\u0014VMY1mC:\u001cW\rV8Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,GK]1og&$\u0018n\u001c8)\u0007\u0005\u0015\u0001\u000f\u0003\u0004\u0002\u000e\u0001!\taY\u0001'i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{G)Z1e)J\fgn]5uS>t\u0007fAA\u0006a\"1\u00111\u0003\u0001\u0005\u0002\r\fq\u0005^3tiB\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+p\u000b6\u0004H/\u001f+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011\u0011\u00039\t\r\u0005e\u0001\u0001\"\u0001d\u0003e!Xm\u001d;F[B$\u0018\u0010V8EK\u0006$GK]1og&$\u0018n\u001c8)\u0007\u0005]\u0001\u000f\u0003\u0004\u0002 \u0001!\taY\u0001(i\u0016\u001cH/Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f)>\u001cF/\u00192mKR\u0013\u0018M\\:ji&|g\u000eK\u0002\u0002\u001eADa!!\n\u0001\t\u0003\u0019\u0017A\t;fgR,U\u000e\u001d;z)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004\u0002$A\fI#a\u000b\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!!\f\u0011\u0007e\ty#C\u0002\u00022i\u0011Q#\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g\u000e\u0003\u0004\u00026\u0001!\taY\u0001$i\u0016\u001cHo\u0015;bE2,Gk\\*uC\ndW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\r\t\u0019\u0004\u001d\u0005\u0007\u0003w\u0001A\u0011A2\u0002[Q,7\u000f^#naRLHk\\!xC&$\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004\u0002:A\fI#a\u000b\t\r\u0005\u0005\u0003\u0001\"\u0001d\u0003m\"Xm\u001d;Qe\u0016\u0004\u0018M]5oOJ+'-\u00197b]\u000e,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\b\u0003\u007f\u0001\u0018\u0011FA\u0016\u0011\u0019\t9\u0005\u0001C\u0001G\u0006yC/Z:u!J,\u0007/\u0019:j]\u001e\u0014VMY1mC:\u001cW\rV8Ti\u0006\u0014G.Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\":\u0011Q\t9\u0002*\u0005-\u0002BBA'\u0001\u0011\u00051-A\u001duKN$\u0018i^1ji&twMU3cC2\fgnY3U_\u0006;\u0018-\u001b;j]\u001e\u0014VMY1mC:\u001cW-\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8oQ\u001d\tY\u0005]A\u0015\u0003WAa!a\u0015\u0001\t\u0003\u0019\u0017a\b;fgR$U-\u00193U_\u0012+\u0017\rZ%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"1\u0011q\u000b\u0001\u0005\u0002\r\f\u0011\u0005^3ti\u0012+\u0017\r\u001a+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds!!\u0016q\u0003S\tY\u0003\u0003\u0004\u0002^\u0001!\taY\u0001.i\u0016\u001cH\u000fR3bIR{\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fBA.a\u0006%\u00121\u0006\u0005\u0007\u0003G\u0002A\u0011A2\u0002YQ,7\u000f\u001e#fC\u0012$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fBA1a\u0006%\u00121\u0006\u0005\u0007\u0003S\u0002A\u0011A2\u0002%Q,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c\u0015\u0004\u0003O\u0002\bBBA8\u0001\u0011\u00051-A\u0012uKN$8+\u001a7fGR\u0004&o\u001c;pG>d'+Y5tKNLeMT8NK6\u0014WM]:)\u000f\u00055\u0004/!\u000b\u0002,!1\u0011Q\u000f\u0001\u0005\u0002\r\f1\u0006^3tiN+G.Z2u!J|Go\\2pY\u000eCwn\\:fg\u000e{W\u000e]1uS\ndW\r\u0015:pi>\u001cw\u000e\u001c\u0015\u0004\u0003g\u0002\bBBA>\u0001\u0011\u00051-A\u000buKN$8+\u001e9q_J$8\u000f\u0015:pi>\u001cw\u000e\\:)\u0007\u0005e\u0004\u000f\u0003\u0004\u0002\u0002\u0002!\taY\u0001\u0015i\u0016\u001cHoU;cg\u000e\u0014\u0018NY3e)>\u0004\u0018nY:)\u0007\u0005}\u0004\u000f\u0003\u0004\u0002\b\u0002!\taY\u0001%i\u0016\u001cHoU;cg\u000e\u0014\u0018NY3e)>\u0004\u0018nY:O_:\u001cuN\\:v[\u0016\u0014xI]8va\"\u001a\u0011Q\u00119\t\r\u00055\u0005\u0001\"\u0001d\u0003Y!Xm\u001d;J]&$h*\u001a=u\u000f\u0016tWM]1uS>t\u0007fAAFa\"1\u00111\u0013\u0001\u0005\u0002\r\f\u0001\u0005^3ti&s\u0017\u000e\u001e(fqR<UM\\3sCRLwN\\#naRLxI]8va\"\u001a\u0011\u0011\u00139\t\r\u0005e\u0005\u0001\"\u0001d\u0003A!Xm\u001d;PM\u001a\u001cX\r^\"p[6LG\u000fK\u0002\u0002\u0018BDa!a(\u0001\t\u0003\u0019\u0017a\u0006;fgR|eMZ:fi\u000e{W.\\5u\r\u0006LG.\u001e:fQ\r\ti\n\u001d\u0005\u0007\u0003K\u0003A\u0011A2\u0002SQ,7\u000f^(gMN,GoQ8n[&$h)Y5mkJ,w+\u001b;i\u0003:|G\u000f[3s!\u0016tG-\u001b8hQ\r\t\u0019\u000b\u001d\u0005\u0007\u0003W\u0003A\u0011A2\u0002EQ,7\u000f^(gMN,GoQ8n[&$x+\u001b;i\u0003:|G\u000f[3s!\u0016tG-\u001b8hQ\r\tI\u000b\u001d\u0005\u0007\u0003c\u0003A\u0011A2\u0002UQ,7\u000f^\"p]N,X.\u001a:CK\u0006$8\u000f\u0016:b]N\f7\r^5p]\u0006dwJ\u001a4tKR\u001cu.\\7ji\"\u001a\u0011q\u00169\t\r\u0005]\u0006\u0001\"\u0001d\u0003!\"Xm\u001d;Ue\u0006t7/Y2uS>t')Z1ug\u000e{gn];nKJ|eMZ:fi\u000e{W.\\5uQ\r\t)\f\u001d\u0005\u0007\u0003{\u0003A\u0011A2\u0002kQ,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\fGnQ8n[&$\u0018j]!c_J$X\rZ!oI\u000e{gn];nKJ\u001cu.\\7ji^Kgn\u001d\u0015\u0004\u0003w\u0003\bBBAb\u0001\u0011\u00051-A\u0017uKN$h)Y5mK\u0012$\u0006P\\(gMN,GoQ8n[&$H*Z1wKNtu\u000eU3oI&twm\u0015;bi\u0016D3!!1q\u0011\u0019\tI\r\u0001C\u0001G\u0006\u0001D/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3XSRDW)\u001c9us\u001e\u0013x.\u001e9J]N$\u0018M\\2f\u0013\u0012Ds!a2q\u0003S\tim\t\u0002\u0002PB!\u0011\u0011[Aq\u001d\u0011\t\u0019.!8\u000f\t\u0005U\u00171\\\u0007\u0003\u0003/T1!!7\t\u0003\u0019a$o\\8u}%\tQ\"C\u0002\u0002`2\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002d\u0006\u0015(\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0019\u0011q\u001c\u0007\t\r\u0005%\b\u0001\"\u0001d\u00035\"Xm\u001d;SKBd\u0017mY3He>,\b/\u00138ti\u0006t7-Z,ji\"tuN\\#ySN$\u0018N\\4NK6\u0014WM\u001d\u0015\b\u0003O\u0004\u0018\u0011FAg\u0011\u0019\ty\u000f\u0001C\u0001G\u0006AB/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3)\u0007\u00055\b\u000f\u0003\u0004\u0002v\u0002!\taY\u0001\u0017i\u0016\u001cH/\u00138w_.,'j\\5o\u0007\u0006dGNY1dW\"\u001a\u00111\u001f9\t\r\u0005m\b\u0001\"\u0001d\u0003e!Xm\u001d;O_RLeN^8lK*{\u0017N\\\"bY2\u0014\u0017mY6)\u0007\u0005e\b\u000f\u0003\u0004\u0003\u0002\u0001!\taY\u0001\u0017i\u0016\u001cH/\u00138w_.,7+\u001f8d\u0007\u0006dGNY1dW\"\u001a\u0011q 9\t\r\t\u001d\u0001\u0001\"\u0001d\u0003e!Xm\u001d;O_RLeN^8lKNKhnY\"bY2\u0014\u0017mY6)\u0007\t\u0015\u0001\u000f\u0003\u0004\u0003\u000e\u0001!\taY\u0001\u001ci\u0016\u001cH\u000fS1t!\u0016tG-\u001b8h\u001d>tG\u000b\u001f8PM\u001a\u001cX\r^:)\u0007\t-\u0001\u000f\u0003\u0004\u0003\u0014\u0001!\taY\u0001\u0019i\u0016\u001cH\u000fS1t!\u0016tG-\u001b8h)btwJ\u001a4tKR\u001c\bf\u0001B\ta\"9!\u0011\u0004\u0001\u0005\n\tm\u0011aC1tg\u0016\u0014Ho\u0015;bi\u0016$RA\u0014B\u000f\u0005?Aaa\u0001B\f\u0001\u0004A\u0005\u0002\u0003B\u0011\u0005/\u0001\rAa\t\u0002\u0017Q\f'oZ3u'R\fG/\u001a\t\u0004)\t\u0015\u0012b\u0001B\u0014\u0005\tQqI]8vaN#\u0018\r^3\t\u000f\t-\u0002\u0001\"\u0003\u0003.\u0005\trN\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\u0015\t\t=\"1\b\t\u0005\u0005c\u00119$\u0004\u0002\u00034)\u0019!Q\u0007\u0004\u0002\r\r|W.\\8o\u0013\u0011\u0011IDa\r\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\r\u0003\u0005\u0003>\t%\u0002\u0019\u0001B \u0003\u0019ygMZ:fiB\u00191B!\u0011\n\u0007\t\rCB\u0001\u0003M_:<\u0007")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupId;
    private final Some<String> groupInstanceId = new Some((Object)"groupInstanceId");
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;
    private MemberMetadata member = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId() {
        return this.groupId;
    }

    private Some<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    private MemberMetadata member() {
        return this.member;
    }

    private void member_$eq(MemberMetadata x$1) {
        this.member = x$1;
    }

    @Before
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
        this.member_$eq(new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))}))));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToStableIllegalTransition() {
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        try {
            this.group().transitionTo((GroupState)Stable$.MODULE$);
            Assert.fail((String)"should have failed due to illegal transition");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$4 = member;
        Function1 x$5 = qual$1.add$default$2();
        qual$1.add(x$4, x$5);
        Assert.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$6 = otherMember;
        Function1 x$7 = qual$2.add$default$2();
        qual$2.add(x$6, x$7);
        Assert.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$3 = this.group();
        MemberMetadata x$8 = lastMember;
        Function1 x$9 = qual$3.add$default$2();
        qual$3.add(x$8, x$9);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test(expected=IllegalStateException.class)
    public void testSelectProtocolRaisesIfNoMembers() {
        this.group().selectProtocol();
        Assert.fail();
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$4 = this.group();
        MemberMetadata x$10 = member;
        Function1 x$11 = qual$4.add$default$2();
        qual$4.add(x$10, x$11);
        GroupMetadata qual$5 = this.group();
        MemberMetadata x$12 = otherMember;
        Function1 x$13 = qual$5.add$default$2();
        qual$5.add(x$12, x$13);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$6 = this.group();
        MemberMetadata x$14 = this.member();
        Function1 x$15 = qual$6.add$default$2();
        qual$6.add(x$14, x$15);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        GroupMetadata qual$7 = this.group();
        MemberMetadata x$16 = otherMember;
        Function1 x$17 = qual$7.add$default$2();
        qual$7.add(x$16, x$17);
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testSubscribedTopics() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).asJava())).array())})));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$8 = this.group();
        MemberMetadata x$18 = member;
        Function1 x$19 = qual$8.add$default$2();
        qual$8.add(x$18, x$19);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().empty()), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$9 = this.group();
        MemberMetadata x$20 = memberWithFaultyProtocol;
        Function1 x$21 = qual$9.add$default$2();
        qual$9.add(x$20, x$21);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$10 = this.group();
        MemberMetadata x$22 = member;
        Function1 x$23 = qual$10.add$default$2();
        qual$10.add(x$22, x$23);
        this.group().initNextGeneration();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        this.member().supportedProtocols_$eq(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()))})));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(this.member(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(JoinGroupResult x$1) {
            }
        });
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithEmptyGroupInstanceId() {
        GroupMetadata qual$11 = this.group();
        MemberMetadata x$24 = this.member();
        Function1 x$25 = qual$11.add$default$2();
        qual$11.add(x$24, x$25);
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, Option$.MODULE$.empty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
    }

    @Test
    public void testReplaceGroupInstance() {
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1)new Serializable(this, joinAwaitingMemberFenced){
            public static final long serialVersionUID = 0L;
            private final BooleanRef joinAwaitingMemberFenced$1;

            public final void apply(JoinGroupResult joinGroupResult) {
                Errors errors = joinGroupResult.error();
                Errors errors2 = Errors.FENCED_INSTANCE_ID;
                this.joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
            {
                this.joinAwaitingMemberFenced$1 = joinAwaitingMemberFenced$1;
            }
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.member().awaitingSyncCallback_$eq((Function1)new Serializable(this, syncAwaitingMemberFenced){
            public static final long serialVersionUID = 0L;
            private final BooleanRef syncAwaitingMemberFenced$1;

            public final void apply(SyncGroupResult syncGroupResult) {
                Errors errors = syncGroupResult.error();
                Errors errors2 = Errors.FENCED_INSTANCE_ID;
                this.syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
            {
                this.syncAwaitingMemberFenced$1 = syncAwaitingMemberFenced$1;
            }
        });
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
        Assert.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assert.assertEquals((Object)newMemberId, (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        Assert.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assert.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1)new Serializable(this, invoked){
            public static final long serialVersionUID = 0L;
            private final BooleanRef invoked$1;

            public final void apply(JoinGroupResult x$2) {
                this.invoked$1.elem = true;
            }
            {
                this.invoked$1 = invoked$1;
            }
        });
        Assert.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(this.member(), JoinGroupResult$.MODULE$.apply(this.member().memberId(), Errors.NONE));
        Assert.assertTrue((boolean)invoked.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        GroupMetadata qual$12 = this.group();
        MemberMetadata x$26 = this.member();
        Function1 x$27 = qual$12.add$default$2();
        qual$12.add(x$26, x$27);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(this.member(), JoinGroupResult$.MODULE$.apply(this.member().memberId(), Errors.NONE));
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        GroupMetadata qual$13 = this.group();
        MemberMetadata x$28 = this.member();
        Function1 x$29 = qual$13.add$default$2();
        qual$13.add(x$28, x$29);
        this.member().awaitingSyncCallback_$eq((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(SyncGroupResult x$3) {
            }
        });
        boolean invoked = this.group().maybeInvokeSyncCallback(this.member(), SyncGroupResult$.MODULE$.apply(Errors.NONE));
        Assert.assertTrue((boolean)invoked);
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        GroupMetadata qual$14 = this.group();
        MemberMetadata x$30 = this.member();
        Function1 x$31 = qual$14.add$default$2();
        qual$14.add(x$30, x$31);
        boolean invoked = this.group().maybeInvokeSyncCallback(this.member(), SyncGroupResult$.MODULE$.apply(Errors.NONE));
        Assert.assertFalse((boolean)invoked);
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testHasPendingNonTxnOffsets() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(partition));
    }

    @Test
    public void testHasPendingTxnOffsets() {
        TopicPartition txnPartition = new TopicPartition("foo", 1);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int producerId = 5;
        this.group().prepareTxnOffsetCommit((long)producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)txnPartition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(txnPartition));
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(new TopicPartition("non-exist", 0)));
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        Set states = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}));
        Set otherStates = (Set)states.$minus((Object)targetState);
        otherStates.foreach((Function1)new Serializable(this, group){
            public static final long serialVersionUID = 0L;
            private final GroupMetadata group$1;

            public final void apply(GroupState otherState) {
                Assert.assertFalse((boolean)this.group$1.is(otherState));
            }
            {
                this.group$1 = group$1;
            }
        });
        Assert.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", Time.SYSTEM.milliseconds());
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupId = "groupId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

