/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnKey;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u0013\t\u0011BK]1og\u0006\u001cG/[8o\u0019><G+Z:u\u0015\t\u0019A!A\u0006ue\u0006t7/Y2uS>t'BA\u0003\u0007\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\t\u000fY\u0001!\u0019!C\u0001/\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012\u0001\u0007\t\u0003\u0017eI!A\u0007\u0007\u0003\u000bMCwN\u001d;\t\rq\u0001\u0001\u0015!\u0003\u0019\u00039\u0001(o\u001c3vG\u0016\u0014X\t]8dQ\u0002BqA\b\u0001C\u0002\u0013\u0005q$\u0001\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj]\u000b\u0002AA\u00111\"I\u0005\u0003E1\u00111!\u00138u\u0011\u0019!\u0003\u0001)A\u0005A\u0005)BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\u0004\u0003b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogV\t\u0001\u0006E\u0002*Y=r!a\u0003\u0016\n\u0005-b\u0011A\u0002)sK\u0012,g-\u0003\u0002.]\t\u00191+\u001a;\u000b\u0005-b\u0001C\u0001\u00199\u001b\u0005\t$B\u0001\u001a4\u0003\u0019\u0019w.\\7p]*\u0011q\u0001\u000e\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014x-\u0003\u0002:c\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB\u001e\u0001A\u0003%\u0001&\u0001\tu_BL7\rU1si&$\u0018n\u001c8tA!)Q\b\u0001C\u0001}\u0005\u00193\u000f[8vY\u0012$\u0006N]8x\u000bb\u001cW\r\u001d;j_:<&/\u001b;f\u0013:4\u0018\r\\5e)btG#A \u0011\u0005-\u0001\u0015BA!\r\u0005\u0011)f.\u001b;)\u0005q\u001a\u0005C\u0001#H\u001b\u0005)%B\u0001$7\u0003\u0015QWO\\5u\u0013\tAUI\u0001\u0003UKN$\b\"\u0002&\u0001\t\u0003q\u0014aF:i_VdGMU3bI^\u0013\u0018\u000e^3NKN\u001c\u0018mZ3tQ\tI5\tC\u0003N\u0001\u0011\u0005a(\u0001\u0010uKN$HK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCB\u000b'o]5oO\"\u0012Aj\u0011\u0005\u0006!\u0002!\tAP\u0001(i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006$v.\u001c2ti>tW\rU1sg&tw\r\u000b\u0002P\u0007\u0002")
public class TransactionLogTest {
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final scala.collection.immutable.Set<TopicPartition> topicPartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)}));

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public scala.collection.immutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void shouldThrowExceptionWriteInvalidTxn() {
        String transactionalId = "transactionalId";
        long producerId = 23423L;
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), 0L);
        txnMetadata.addPartitions(this.topicPartitions());
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, txnMetadata){
            public static final long serialVersionUID = 0L;
            private final TransactionMetadata txnMetadata$1;

            public final byte[] apply() {
                return TransactionLog$.MODULE$.valueToBytes(this.txnMetadata$1.prepareNoTransit());
            }
            {
                this.txnMetadata$1 = txnMetadata$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TransactionLogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    @Test
    public void shouldReadWriteMessages() {
        Map pidMappings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zero"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"one"), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"two"), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"three"), (Object)BoxesRunTime.boxToLong((long)3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"four"), (Object)BoxesRunTime.boxToLong((long)4L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"five"), (Object)BoxesRunTime.boxToLong((long)5L))}));
        Map transactionStates = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)Empty$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)Ongoing$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)PrepareCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)CompleteCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)4L)), (Object)PrepareAbort$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)5L)), (Object)CompleteAbort$.MODULE$)}));
        Seq txnRecords = ((TraversableOnce)pidMappings.map((Function1)new Serializable(this, transactionStates){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionLogTest $outer;
            private final Map transactionStates$1;

            public final SimpleRecord apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    long producerId;
                    String transactionalId = (String)tuple2._1();
                    TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId = tuple2._2$mcJ$sp(), this.$outer.producerEpoch(), this.$outer.transactionTimeoutMs(), (TransactionState)this.transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)producerId)), 0L);
                    if (!txnMetadata.state().equals(Empty$.MODULE$)) {
                        txnMetadata.addPartitions(this.$outer.topicPartitions());
                    }
                    byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
                    byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
                    SimpleRecord simpleRecord = new SimpleRecord(keyBytes, valueBytes);
                    return simpleRecord;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionStates$1 = transactionStates$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        MemoryRecords records2 = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])txnRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        IntRef count = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this, pidMappings, transactionStates, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TransactionLogTest $outer;
            private final Map pidMappings$1;
            private final Map transactionStates$1;
            private final IntRef count$1;

            public final void apply(Record record) {
                TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
                String transactionalId = txnKey.transactionalId();
                TransactionMetadata txnMetadata = (TransactionMetadata)TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value()).get();
                Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.pidMappings$1.apply((Object)transactionalId)), (long)txnMetadata.producerId());
                Assert.assertEquals((long)this.$outer.producerEpoch(), (long)txnMetadata.producerEpoch());
                Assert.assertEquals((long)this.$outer.transactionTimeoutMs(), (long)txnMetadata.txnTimeoutMs());
                Assert.assertEquals((Object)this.transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId())), (Object)txnMetadata.state());
                if (txnMetadata.state().equals(Empty$.MODULE$)) {
                    Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)txnMetadata.topicPartitions());
                } else {
                    Assert.assertEquals(this.$outer.topicPartitions(), (Object)txnMetadata.topicPartitions());
                }
                ++this.count$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pidMappings$1 = pidMappings$1;
                this.transactionStates$1 = transactionStates$1;
                this.count$1 = count$1;
            }
        });
        Assert.assertEquals((long)pidMappings.size(), (long)count.elem);
    }

    @Test
    public void testTransactionMetadataParsing() {
        String transactionalId = "id";
        long producerId = 1334L;
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)Ongoing$.MODULE$, 0L);
        txnMetadata.addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
        Record transactionMetadataRecord = (Record)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(keyBytes, valueBytes)}))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()).records()).asScala()).head();
        Tuple2 tuple2 = TransactionLog$.MODULE$.formatRecordKeyAndValue(transactionMetadataRecord);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option keyStringOpt = (Option)tuple2._1();
            Option valueStringOpt = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)keyStringOpt, (Object)valueStringOpt);
            Option keyStringOpt2 = (Option)tuple23._1();
            Option valueStringOpt2 = (Option)tuple23._2();
            Assert.assertEquals((Object)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transaction_metadata::transactionalId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId}))), (Object)keyStringOpt2);
            Assert.assertEquals((Object)new Some((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId:", ",producerEpoch:", ",state=Ongoing,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId), BoxesRunTime.boxToShort((short)this.producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitions=[", "],txnLastUpdateTimestamp=0,txnTimeoutMs=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToInteger((int)this.transactionTimeoutMs())}))).toString()), (Object)valueStringOpt2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testTransactionMetadataTombstoneParsing() {
        String transactionalId = "id";
        Record transactionMetadataRecord = (Record)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(TransactionLog$.MODULE$.keyToBytes(transactionalId), null)}))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()).records()).asScala()).head();
        Tuple2 tuple2 = TransactionLog$.MODULE$.formatRecordKeyAndValue(transactionMetadataRecord);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option keyStringOpt = (Option)tuple2._1();
            Option valueStringOpt = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)keyStringOpt, (Object)valueStringOpt);
            Option keyStringOpt2 = (Option)tuple23._1();
            Option valueStringOpt2 = (Option)tuple23._2();
            Assert.assertEquals((Object)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transaction_metadata::transactionalId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId}))), (Object)keyStringOpt2);
            Assert.assertEquals((Object)new Some((Object)"<DELETE>"), (Object)valueStringOpt2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public TransactionLogTest() {
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 1000;
    }
}

