/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.controller.ControllerStats;
import kafka.controller.ReplicaAssignment$;
import kafka.network.Processor;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001\u001d\u0011\u0011$\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eV3ti*\u00111\u0001B\u0001\fS:$Xm\u001a:bi&|gNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#A\u0005ce>\\WM]%ecU\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0002J]RDa!\b\u0001!\u0002\u00131\u0012A\u00032s_.,'/\u001332A!9q\u0004\u0001b\u0001\n\u0003)\u0012!\u00032s_.,'/\u001333\u0011\u0019\t\u0003\u0001)A\u0005-\u0005Q!M]8lKJLEM\r\u0011\t\u000f\r\u0002!\u0019!C\u0001I\u0005ARM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8\u0016\u0003\u0015\u0002\"a\u0006\u0014\n\u0005\u001dB\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007S\u0001\u0001\u000b\u0011B\u0013\u00023\u0015t\u0017M\u00197f\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000e\t\u0005\bW\u0001\u0001\r\u0011\"\u0001-\u00031\u0019wN\u001c4jOB\u0013x\u000e]:2+\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002\u001c\u0001\u0001\u0004%\taN\u0001\u0011G>tg-[4Qe>\u00048/M0%KF$\"\u0001O\u001e\u0011\u0005]I\u0014B\u0001\u001e\u0019\u0005\u0011)f.\u001b;\t\u000fq*\u0014\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\ry\u0002\u0001\u0015)\u0003.\u00035\u0019wN\u001c4jOB\u0013x\u000e]:2A!9\u0001\t\u0001a\u0001\n\u0003a\u0013\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0004b\u0002\"\u0001\u0001\u0004%\taQ\u0001\u0011G>tg-[4Qe>\u00048OM0%KF$\"\u0001\u000f#\t\u000fq\n\u0015\u0011!a\u0001[!1a\t\u0001Q!\n5\nQbY8oM&<\u0007K]8qgJ\u0002\u0003b\u0002%\u0001\u0001\u0004%\t!S\u0001\bG>tg-[4t+\u0005Q\u0005cA&O!6\tAJ\u0003\u0002N1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=c%aA*fcB\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005U\u0013&aC&bM.\f7i\u001c8gS\u001eDqa\u0016\u0001A\u0002\u0013\u0005\u0001,A\u0006d_:4\u0017nZ:`I\u0015\fHC\u0001\u001dZ\u0011\u001dad+!AA\u0002)Caa\u0017\u0001!B\u0013Q\u0015\u0001C2p]\u001aLwm\u001d\u0011\t\u000fu\u0003\u0001\u0019!C\u0001=\u000691/\u001a:wKJ\u001cX#A0\u0011\u0007-s\u0005\r\u0005\u0002RC&\u0011!M\u0015\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0004e\u0001\u0001\u0007I\u0011A3\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003q\u0019Dq\u0001P2\u0002\u0002\u0003\u0007q\f\u0003\u0004i\u0001\u0001\u0006KaX\u0001\tg\u0016\u0014h/\u001a:tA!9!\u000e\u0001b\u0001\n\u0003Y\u0017A\u0002:b]\u0012|W.F\u0001m!\tiw.D\u0001o\u0015\t\u0001\u0004$\u0003\u0002q]\n1!+\u00198e_6DaA\u001d\u0001!\u0002\u0013a\u0017a\u0002:b]\u0012|W\u000e\t\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0003\u0015!x\u000e]5d+\u00051\bCA<{\u001b\u0005A(BA=2\u0003\u0011a\u0017M\\4\n\u0005mD(AB*ue&tw\r\u0003\u0004~\u0001\u0001\u0006IA^\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f}\u0004!\u0019!C\u0001+\u0005Y\u0001/\u0019:uSRLwN\\%e\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nY\tA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0011\"a\u0002\u0001\u0005\u0004%\t!!\u0003\u0002\u001f-\fgm[1Ba&\u001cHj\\4hKJ,\"!a\u0003\u0011\t\u00055\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005)An\\45U*!\u0011QCA\f\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011D\u0001\u0004_J<\u0017\u0002BA\u000f\u0003\u001f\u0011a\u0001T8hO\u0016\u0014\b\u0002CA\u0011\u0001\u0001\u0006I!a\u0003\u0002!-\fgm[1Ba&\u001cHj\\4hKJ\u0004\u0003\"CA\u0013\u0001\t\u0007I\u0011AA\u0005\u0003YqW\r^<pe.\u0004&o\\2fgN|'\u000fT8hO\u0016\u0014\b\u0002CA\u0015\u0001\u0001\u0006I!a\u0003\u0002/9,Go^8sWB\u0013xnY3tg>\u0014Hj\\4hKJ\u0004\u0003bBA\u0017\u0001\u0011\u0005\u0013qF\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002q!\"\u00111FA\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"\u0002BA\u001d\u0003/\tQA[;oSRLA!!\u0010\u00028\t1!)\u001a4pe\u0016Dq!!\u0011\u0001\t\u0003\ny#\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\ty$!\u0012\u0011\t\u0005U\u0012qI\u0005\u0005\u0003\u0013\n9DA\u0003BMR,'\u000fC\u0004\u0002N\u0001!I!a\u0014\u0002\u0019M$\u0018M\u001d;Ce>\\WM]:\u0015\u0007a\n\t\u0006\u0003\u0005\u0002T\u0005-\u0003\u0019AA+\u0003\u001d\u0019G.^:uKJ\u00042a\u0013(.\u0011\u001d\tI\u0006\u0001C\u0001\u0003_\t\u0001\u0005^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\"\"\u0011qKA/!\u0011\t)$a\u0018\n\t\u0005\u0005\u0014q\u0007\u0002\u0005)\u0016\u001cH\u000fC\u0004\u0002f\u0001!\t!a\f\u0002CQ,7\u000f^+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3)\t\u0005\r\u0014Q\f\u0005\b\u0003W\u0002A\u0011AA\u0018\u0003=\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3CsR{\u0007/[2Pm\u0016\u0014(/\u001b3fQ\u0011\tI'!\u0018\t\u000f\u0005E\u0004\u0001\"\u0001\u00020\u0005\u0001D/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016DC!a\u001c\u0002^!9\u0011q\u000f\u0001\u0005\u0002\u0005=\u0012!\f;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:LeN^1mS\u0012$v\u000e]5d\u001fZ,'O]5eK\"\"\u0011QOA/\u0011\u001d\ti\b\u0001C\u0001\u0003_\t!E^3sS\u001aLXK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016$\u0007bBAA\u0001\u0011\u0005\u0011qF\u0001$m\u0016\u0014\u0018NZ=V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8ESN\f'\r\\3e\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000bab\u001d5vi\u0012|wO\\*feZ,'\u000fF\u00029\u0003\u0013CaaUAB\u0001\u0004\u0001\u0007bBAG\u0001\u0011%\u0011qR\u0001\u0013G>t7/^7f\u00032dW*Z:tC\u001e,7\u000f\u0006\u0004\u0002\u0012\u0006}\u0015\u0011\u0015\t\u0005\u0017:\u000b\u0019\n\u0005\u0003\u0002\u0016\u0006mebA\f\u0002\u0018&\u0019\u0011\u0011\u0014\r\u0002\rA\u0013X\rZ3g\u0013\rY\u0018Q\u0014\u0006\u0004\u00033C\u0002b\u0002;\u0002\f\u0002\u0007\u00111\u0013\u0005\b\u0003G\u000bY\t1\u0001\u0017\u0003-qW/\\'fgN\fw-Z:\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u00020\u0005!C/Z:u)>\u0004\u0018nY+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\r\u000b\u0003\u0002&\u0006u\u0003bBAW\u0001\u0011%\u0011qV\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HCAAY!\u0011\t\u0019,a0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000bQ!\u00193nS:TA!a/\u0002>\u000691\r\\5f]R\u001c(bA\u0003\u0002\u0014%!\u0011\u0011YA[\u0005\u0015\tE-\\5o\u0001")
public class UncleanLeaderElectionTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1 = null;
    private Properties configProps2 = null;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final Random random = new Random();
    private final String topic = new StringBuilder().append((Object)"topic").append((Object)BoxesRunTime.boxToLong((long)this.random().nextLong())).toString();
    private final int partitionId;
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final Object apply(Properties configProps) {
                configProps.put("controlled.shutdown.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.enableControlledShutdown())).toString());
                configProps.put("controlled.shutdown.max.retries", "1");
                return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                CoreUtils$.MODULE$.delete(server.config().logDirs());
            }
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        super.tearDown();
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(Properties props) {
                KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
                KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
                this.$outer.configs_$eq((Seq<KafkaConfig>)((Seq)this.$outer.configs().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{config})), Seq$.MODULE$.canBuildFrom())));
                this.$outer.servers_$eq((Seq<KafkaServer>)((Seq)this.$outer.servers().$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server})), Seq$.MODULE$.canBuildFrom())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testUncleanLeaderElectionEnabled() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testUncleanLeaderElectionDisabled() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testUncleanLeaderElectionDisabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicProps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final Properties topicProps$1;

            public final scala.collection.immutable.Map<Object, Object> apply() {
                return TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), this.$outer.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.$outer.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.brokerId1()})))}))), this.$outer.servers(), this.topicProps$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicProps$1 = topicProps$1;
            }
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int leaderId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderId$1 = leaderId$1;
            }
        });
        Assert.assertTrue((String)new StringBuilder().append((Object)"Leader id is set to expected value for topic: ").append((Object)this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;
            private final int followerId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Follower for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.followerId$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.followerId$1 = followerId$1;
            }
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$1;

            public final boolean apply(KafkaServer server) {
                return server.config().brokerId() == this.followerId$1;
            }
            {
                this.followerId$1 = followerId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                ControllerStats qual$1 = x$1.kafkaController().controllerContext().stats();
                String x$7 = "UncleanLeaderElectionsPerSec";
                Map x$8 = qual$1.removeMetric$default$2();
                qual$1.removeMetric(x$7, x$8);
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaServer x$2) {
                return x$2.config().brokerId() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UncleanLeaderElectionTest $outer;

            public final void apply(KafkaServer server) {
                this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, followerId){
            public static final long serialVersionUID = 0L;
            private final int followerId$1;

            public final boolean apply(KafkaServer x$3) {
                return x$3.config().brokerId() == this.followerId$1;
            }
            {
                this.followerId$1 = followerId$1;
            }
        }).get();
        followerServer.startup();
        KafkaZkClient x$9 = this.zkClient();
        String x$10 = this.topic();
        int x$11 = this.partitionId();
        Some x$12 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$13 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$14 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$9, x$10, x$11, x$13, x$14, (Option<Object>)x$12);
        Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "third"})), this.consumeAllMessages(this.topic(), 2));
    }

    public void verifyUncleanLeaderElectionDisabled() {
        Throwable throwable2;
        block2: {
            int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            this.debug((Function0<String>)new Serializable(this, leaderId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UncleanLeaderElectionTest $outer;
                private final int leaderId$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Leader for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.leaderId$2)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.leaderId$2 = leaderId$2;
                }
            });
            Assert.assertTrue((String)new StringBuilder().append((Object)"Leader id is set to expected value for topic: ").append((Object)this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
            int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
            this.debug((Function0<String>)new Serializable(this, followerId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UncleanLeaderElectionTest $outer;
                private final int followerId$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Follower for ").append((Object)this.$outer.topic()).append((Object)new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.followerId$2)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.followerId$2 = followerId$2;
                }
            });
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic(), 1));
            ((IterableLike)this.servers().filter((Function1)new Serializable(this, followerId){
                public static final long serialVersionUID = 0L;
                private final int followerId$2;

                public final boolean apply(KafkaServer server) {
                    return server.config().brokerId() == this.followerId$2;
                }
                {
                    this.followerId$2 = followerId$2;
                }
            })).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UncleanLeaderElectionTest $outer;

                public final void apply(KafkaServer server) {
                    this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic(), 2));
            this.servers().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer server) {
                    ControllerStats qual$2 = server.kafkaController().controllerContext().stats();
                    String x$15 = "UncleanLeaderElectionsPerSec";
                    Map x$16 = qual$2.removeMetric$default$2();
                    qual$2.removeMetric(x$15, x$16);
                }
            });
            ((IterableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
                public static final long serialVersionUID = 0L;
                private final int leaderId$2;

                public final boolean apply(KafkaServer server) {
                    return server.config().brokerId() == this.leaderId$2;
                }
                {
                    this.leaderId$2 = leaderId$2;
                }
            })).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UncleanLeaderElectionTest $outer;

                public final void apply(KafkaServer server) {
                    this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            KafkaServer followerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, followerId){
                public static final long serialVersionUID = 0L;
                private final int followerId$2;

                public final boolean apply(KafkaServer x$4) {
                    return x$4.config().brokerId() == this.followerId$2;
                }
                {
                    this.followerId$2 = followerId$2;
                }
            }).get();
            followerServer.startup();
            KafkaZkClient x$17 = this.zkClient();
            String x$18 = this.topic();
            int x$19 = this.partitionId();
            Some x$20 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
            long x$21 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$22 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$17, x$18, x$19, x$21, x$22, (Option<Object>)x$20);
            Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
            try {
                TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
                Assert.fail((String)"Message produced while leader is down should fail, but it succeeded");
            }
            catch (Throwable throwable2) {
                ExecutionException executionException;
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable3).getCause() instanceof TimeoutException)) break block2;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
            ((IterableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
                public static final long serialVersionUID = 0L;
                private final int leaderId$2;

                public final boolean apply(KafkaServer server) {
                    return server.config().brokerId() == this.leaderId$2;
                }
                {
                    this.leaderId$2 = leaderId$2;
                }
            })).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer server) {
                    server.startup();
                }
            });
            KafkaZkClient x$23 = this.zkClient();
            String x$24 = this.topic();
            int x$25 = this.partitionId();
            Some x$26 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
            long x$27 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$28 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$23, x$24, x$25, x$27, x$28, (Option<Object>)x$26);
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, followerId, followerServer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UncleanLeaderElectionTest $outer;
                private final int followerId$2;
                private final KafkaServer followerServer$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    Option partitionInfoOpt = this.followerServer$1.metadataCache().getPartitionInfo(this.$outer.topic(), this.$outer.partitionId());
                    return partitionInfoOpt.isDefined() && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).isr().contains(BoxesRunTime.boxToInteger((int)this.followerId$2));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.followerId$2 = followerId$2;
                    this.followerServer$1 = followerServer$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Inconsistent metadata after first server startup";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            ((IterableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
                public static final long serialVersionUID = 0L;
                private final int leaderId$2;

                public final boolean apply(KafkaServer server) {
                    return server.config().brokerId() == this.leaderId$2;
                }
                {
                    this.leaderId$2 = leaderId$2;
                }
            })).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UncleanLeaderElectionTest $outer;

                public final void apply(KafkaServer server) {
                    this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            KafkaZkClient x$29 = this.zkClient();
            String x$30 = this.topic();
            int x$31 = this.partitionId();
            Some x$32 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
            long x$33 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$34 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$29, x$30, x$31, x$33, x$34, (Option<Object>)x$32);
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second", "third"})), this.consumeAllMessages(this.topic(), 3));
            return;
        }
        throw throwable2;
    }

    public void kafka$integration$UncleanLeaderElectionTest$$shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList;
        String x$35 = brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        String x$36 = new StringBuilder().append((Object)"group").append((Object)BoxesRunTime.boxToLong((long)this.random().nextLong())).toString();
        boolean x$37 = false;
        StringDeserializer x$38 = new StringDeserializer();
        String x$39 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$40 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$41 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$42 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$43 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$44 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$45 = TestUtils$.MODULE$.createConsumer$default$10();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$35, x$36, x$39, x$37, x$40, x$41, x$42, x$43, x$44, x$45, x$38);
        try {
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, TestUtils$.MODULE$.consumeRecords$default$3()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ConsumerRecord<byte[], String> x$5) {
                    return (String)x$5.value();
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            void var4_15;
            var4_15.close();
            throw throwable;
        }
        consumer.close();
        return seq;
    }

    @Test
    public void testTopicUncleanLeaderElectionEnable() {
        Throwable throwable2;
        block2: {
            this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
            AdminZkClient qual$3 = this.adminZkClient();
            String x$46 = this.topic();
            Properties x$47 = new Properties();
            scala.collection.immutable.Map x$48 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})), (Seq)Seq$.MODULE$.empty()))}));
            boolean x$49 = qual$3.createTopicWithAssignment$default$4();
            qual$3.createTopicWithAssignment(x$46, x$47, (Map)x$48, x$49);
            int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first"})), this.consumeAllMessages(this.topic(), 1));
            ((TraversableLike)this.servers().filter((Function1)new Serializable(this, followerId){
                public static final long serialVersionUID = 0L;
                private final int followerId$3;

                public final boolean apply(KafkaServer server) {
                    return server.config().brokerId() == this.followerId$3;
                }
                {
                    this.followerId$3 = followerId$3;
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UncleanLeaderElectionTest $outer;

                public final void apply(KafkaServer server) {
                    this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom());
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"})), this.consumeAllMessages(this.topic(), 2));
            this.servers().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(KafkaServer server) {
                    ControllerStats qual$4 = server.kafkaController().controllerContext().stats();
                    String x$50 = "UncleanLeaderElectionsPerSec";
                    Map x$51 = qual$4.removeMetric$default$2();
                    qual$4.removeMetric(x$50, x$51);
                }
            }, Seq$.MODULE$.canBuildFrom());
            ((TraversableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
                public static final long serialVersionUID = 0L;
                private final int leaderId$3;

                public final boolean apply(KafkaServer server) {
                    return server.config().brokerId() == this.leaderId$3;
                }
                {
                    this.leaderId$3 = leaderId$3;
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UncleanLeaderElectionTest $outer;

                public final void apply(KafkaServer server) {
                    this.$outer.kafka$integration$UncleanLeaderElectionTest$$shutdownServer(server);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom());
            KafkaServer followerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this, followerId){
                public static final long serialVersionUID = 0L;
                private final int followerId$3;

                public final boolean apply(KafkaServer x$6) {
                    return x$6.config().brokerId() == this.followerId$3;
                }
                {
                    this.followerId$3 = followerId$3;
                }
            }).get();
            followerServer.startup();
            Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
            try {
                TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
                Assert.fail((String)"Message produced while leader is down should fail, but it succeeded");
            }
            catch (Throwable throwable2) {
                ExecutionException executionException;
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof ExecutionException) || !((executionException = (ExecutionException)throwable3).getCause() instanceof TimeoutException)) break block2;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
            Admin adminClient = this.createAdminClient();
            Properties newProps = new Properties();
            newProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
            TestUtils$.MODULE$.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
            adminClient.close();
            KafkaZkClient x$52 = this.zkClient();
            String x$53 = this.topic();
            int x$54 = this.partitionId();
            Some x$55 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
            long x$56 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$57 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$52, x$53, x$54, x$56, x$57, (Option<Object>)x$55);
            Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "third"})), this.consumeAllMessages(this.topic(), 2));
            return;
        }
        throw throwable2;
    }

    private Admin createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers2 = TestUtils$.MODULE$.bootstrapServers(this.servers(), new ListenerName("PLAINTEXT"));
        config.put("bootstrap.servers", bootstrapServers2);
        config.put("metadata.max.age.ms", "10");
        return AdminClient.create((Properties)config);
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

