/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.MergedLog;
import kafka.log.ProducerStateManager;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tier.state.TierPartitionState;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\tue\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%\taG\u0001\u0007i6\u0004H)\u001b:\u0016\u0003q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\u0005%|'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011AAR5mK\"1Q\u0005\u0001Q\u0001\nq\tq\u0001^7q\t&\u0014\b\u0005C\u0004(\u0001\t\u0007I\u0011A\u000e\u0002\r1|w\rR5s\u0011\u0019I\u0003\u0001)A\u00059\u00059An\\4ESJ\u0004\u0003bB\u0016\u0001\u0005\u0004%\t\u0001L\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005i\u0003C\u0001\u00187\u001b\u0005y#B\u0001\u00192\u0003\u0019\u0019w.\\7p]*\u0011QA\r\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028_\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB\u001d\u0001A\u0003%Q&A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011\u001dY\u0004A1A\u0005\u0002q\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tI\u0001\u0005kRLG.\u0003\u0002C\u007f\tQ\u0001K]8qKJ$\u0018.Z:\t\r\u0011\u0003\u0001\u0015!\u0003>\u0003%awn\u001a)s_B\u001c\b\u0005C\u0004G\u0001\t\u0007I\u0011A$\u0002\u00131|wmQ8oM&<W#\u0001%\u0011\u0005aI\u0015B\u0001&\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004M\u0001\u0001\u0006I\u0001S\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002(\u0001\u0005\u0004%\taT\u0001\u0005i&lW-F\u0001Q!\ty\u0011+\u0003\u0002S!\tAQj\\2l)&lW\r\u0003\u0004U\u0001\u0001\u0006I\u0001U\u0001\u0006i&lW\r\t\u0005\b-\u0002\u0011\r\u0011\"\u0001X\u0003I\u0019G.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0003a\u0003B!\u00170.A6\t!L\u0003\u0002\\9\u00069Q.\u001e;bE2,'BA/\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003?j\u00131!T1q!\tI\u0011-\u0003\u0002c\u0015\t!Aj\u001c8h\u0011\u0019!\u0007\u0001)A\u00051\u0006\u00192\r\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;tA\u0019!a\r\u0001\u0001h\u0005UaunZ\"mK\u0006tWM]'b]\u0006<WM]'pG.\u001c\"!\u001a5\u0011\u0005aI\u0017B\u00016\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\nY\u0016\u0014\t\u0011)A\u0005[f\fq\u0001\\8h\t&\u00148\u000fE\u0002omrq!a\u001c;\u000f\u0005A\u001cX\"A9\u000b\u0005I4\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t)(\"A\u0004qC\u000e\\\u0017mZ3\n\u0005]D(aA*fc*\u0011QOC\u0005\u0003Y&D!b_3\u0003\u0002\u0003\u0006I\u0001`A\u0003\u0003\u0011awnZ:\u0011\t=iXf`\u0005\u0003}B\u0011A\u0001U8pYB\u0019\u0001$!\u0001\n\u0007\u0005\r!AA\u0006BEN$(/Y2u\u0019><\u0017BA>j\u00111\tI!\u001aB\u0001B\u0003%\u00111BA\f\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYB!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012\u0011\taa]3sm\u0016\u0014\u0018\u0002BA\u000b\u0003\u001f\u0011A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017bAA\u0005S\"1Q#\u001aC\u0001\u00037!\u0002\"!\b\u0002\"\u0005\r\u0012Q\u0005\t\u0004\u0003?)W\"\u0001\u0001\t\r1\fI\u00021\u0001n\u0011\u0019Y\u0018\u0011\u0004a\u0001y\"A\u0011\u0011BA\r\u0001\u0004\tY\u0001C\u0004\u0002*\u0015$\t%a\u000b\u0002+\u0005dGn\u00117fC:,'o\u00115fG.\u0004x.\u001b8ugV\u0011\u0011Q\u0006\t\u0007\u0003_\t)$\f1\u000f\u0007%\t\t$C\u0002\u00024)\ta\u0001\u0015:fI\u00164\u0017bA0\u00028)\u0019\u00111\u0007\u0006\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u0005AA/Z1s\t><h\u000e\u0006\u0002\u0002@A\u0019\u0011\"!\u0011\n\u0007\u0005\r#B\u0001\u0003V]&$\b\u0006BA\u001d\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\"\u0014!\u00026v]&$\u0018\u0002BA)\u0003\u0017\u0012Q!\u00114uKJDq!!\u0016\u0001\t\u0013\t9&A\u000etKR,\b/\u00138de\u0016\f7/\u001b8hYf4\u0015\u000e\u001c;is2{wm\u001d\u000b\by\u0006e\u0013qLA5\u0011!\tY&a\u0015A\u0002\u0005u\u0013A\u00039beRLG/[8ogB\u0019aN^\u0017\t\u0011\u0005\u0005\u00141\u000ba\u0001\u0003G\nqb\u001d;beRtU/\u001c\"bi\u000eDWm\u001d\t\u0004\u0013\u0005\u0015\u0014bAA4\u0015\t\u0019\u0011J\u001c;\t\u0011\u0005-\u00141\u000ba\u0001\u0003G\naBY1uG\"Len\u0019:f[\u0016tG\u000fC\u0004\u0002p\u0001!\t!!\u0010\u0002YQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$\u0006N]8xg\u0016C8-\u001a9uS>t\u0007\u0006BA7\u0003g\u0002B!!\u0013\u0002v%!\u0011qOA&\u0005\u0011!Vm\u001d;\t\u000f\u0005m\u0004\u0001\"\u0001\u0002>\u0005AD/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{wMU3ukJt7\u000fT8h/&$\b\u000eR5si&,7\u000f\u001e*bi&|\u0007\u0006BA=\u0003gBq!!!\u0001\t\u0003\ti$A\u001duKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h\u0013\u001etwN]3t+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tQ\u0011\ty(a\u001d\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002>\u0005AD/Z:u\u000fJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w-S4o_J,7/\u00138Qe><'/Z:t!\u0006\u0014H/\u001b;j_:\u001c\b\u0006BAC\u0003gBq!!$\u0001\t\u0003\ti$\u0001+uKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h\u0013\u001etwN]3t\u0005>$\b.\u00138Qe><'/Z:t!\u0006\u0014H/\u001b;j_:\u001c\u0018I\u001c3V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\t\u0005-\u00151\u000f\u0005\b\u0003'\u0003A\u0011AA\u001f\u0003%\"Xm\u001d;ESJ$\u0018p\u00144gg\u0016$(+Z:fi&3G*\u0019:hKJ$\u0006.\u00198F]\u0012|eMZ:fi\"\"\u0011\u0011SA:\u0011\u001d\tI\n\u0001C\u0001\u0003{\tA\u0006^3ti\u0012K'\u000f^=PM\u001a\u001cX\r\u001e*fg\u0016$\u0018JZ*nC2dWM\u001d+iC:\u001cF/\u0019:u\u001f\u001a47/\u001a;)\t\u0005]\u00151\u000f\u0005\b\u0003?\u0003A\u0011AA\u001f\u0003M\"Xm\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;MCJ<WM\u001d+iC:\f5\r^5wKN+w-\\3oi\n\u000b7/Z(gMN,G\u000f\u000b\u0003\u0002\u001e\u0006M\u0004bBAS\u0001\u0011\u0005\u0011QH\u00011i\u0016\u001cH\u000fR5sif|eMZ:fi2\u000b'oZ3s)\"\fg.Q2uSZ,7+Z4nK:$()Y:f\u001f\u001a47/\u001a;)\t\u0005\r\u00161\u000f\u0005\b\u0003W\u0003A\u0011AA\u001f\u0003\u0011#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI:{GoQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017\u0010R3mKR,Gj\\4tQ\u0011\tI+a\u001d\t\u000f\u0005E\u0006\u0001\"\u0001\u0002>\u0005AE/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf\u001cu.\u001c9bGR$U\r\\3uK2{wm\u001d\u0015\u0005\u0003_\u000b\u0019\bC\u0004\u00028\u0002!\t!!\u0010\u0002\u0005R,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u0007>t7/\u001b3fe\u000ecW-\u00198vaB{G.[2z\u0007>l\u0007/Y2u\u0019><7\u000f\u000b\u0003\u00026\u0006M\u0004bBA_\u0001\u0011\u0005\u0011QH\u0001,i\u0016\u001cH\u000fT8hgVsG-\u001a:DY\u0016\fg.\u001e9J]\u0016d\u0017nZ5cY\u00164uN]\"p[B\f7\r^5p]\"\"\u00111XA:\u0011\u001d\t\u0019\r\u0001C\u0001\u0003{\t\u0001\u0006^3ti\u000e{gnY;se\u0016tG\u000fT8h\u00072,\u0017M\\;q\u0003:$Gj\\4UeVt7-\u0019;j_:DC!!1\u0002t!9\u0011\u0011\u001a\u0001\u0005\u0002\u0005u\u0012\u0001\u000b;fgR\u001cuN\\2veJ,g\u000e\u001e'pO\u000ecW-\u00198va\u0006sG\rV8qS\u000e$U\r\\3uS>t\u0007\u0006BAd\u0003gBq!a4\u0001\t\u0003\ti$\u0001\"uKN$Hj\\4t/&$\bnU3h[\u0016tGo\u001d+p\t\u0016dW\r^3TQ>,H\u000e\u001a(pi\u000e{gn]5eKJ,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]NDC!!4\u0002t!9\u0011Q\u001b\u0001\u0005\u0002\u0005u\u0012a\u0007;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s\u001d>tW\r\u000b\u0003\u0002T\u0006M\u0004bBAn\u0001\u0011\u0005\u0011QH\u0001\u001ci\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:G_J$\u0016.\\3)\t\u0005e\u00171\u000f\u0005\b\u0003C\u0004A\u0011AA\u001f\u0003\u0001\"Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'o\u00155peR$\u0016.\\3)\t\u0005}\u00171\u000f\u0005\b\u0003O\u0004A\u0011AA\u001f\u0003)\"Xm\u001d;V]\u0012,7-\u001b3fIR\u0013\u0018M\\:bGRLwN\\1m\t\u0006$\u0018MT8u\u00072,\u0017M\\1cY\u0016DC!!:\u0002t!9\u0011Q\u001e\u0001\u0005\u0002\u0005u\u0012\u0001\u0005;fgR$uN\\3DY\u0016\fg.\u001b8hQ\u0011\tY/a\u001d\t\u000f\u0005M\b\u0001\"\u0001\u0002>\u0005\u0001B/Z:u\t>tW\rR3mKRLgn\u001a\u0015\u0005\u0003c\f\u0019\bC\u0004\u0002z\u0002!I!a?\u0002)\r\u0014X-\u0019;f\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\rA\u0017Q \u0005\u0007\u0007\u0005]\b\u0019A@\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u0005A2M]3bi\u0016\u001cE.Z1oKJl\u0015M\\1hKJlunY6\u0015\t\u0005u!Q\u0001\u0005\b\u0005\u000f\ty\u00101\u0001}\u0003\u0011\u0001xn\u001c7\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e\u0005I1M]3bi\u0016dun\u001a\u000b\t\u0005\u001f\u0011)B!\u0007\u0003$A\u0019\u0001D!\u0005\n\u0007\tM!AA\u0005NKJ<W\r\u001a'pO\"A!q\u0003B\u0005\u0001\u0004\t\u0019'A\u0006tK\u001elWM\u001c;TSj,\u0007\u0002\u0003B\u000e\u0005\u0013\u0001\rA!\b\u0002\u001b\rdW-\u00198vaB{G.[2z!\u0011\tyCa\b\n\t\t\u0005\u0012q\u0007\u0002\u0007'R\u0014\u0018N\\4\t\u0011-\u0012I\u0001%AA\u00025BqAa\n\u0001\t\u0013\u0011I#A\u000ede\u0016\fG/\u001a'poJ+G/\u001a8uS>tGj\\4D_:4\u0017n\u001a\u000b\u0006\u0011\n-\"Q\u0006\u0005\t\u0005/\u0011)\u00031\u0001\u0002d!A!1\u0004B\u0013\u0001\u0004\u0011i\u0002C\u0004\u00032\u0001!IAa\r\u0002\u0019]\u0014\u0018\u000e^3SK\u000e|'\u000fZ:\u0015\u0015\u0005}\"Q\u0007B\u001c\u0005w\u0011y\u0004\u0003\u0004\u0004\u0005_\u0001\ra \u0005\t\u0005s\u0011y\u00031\u0001\u0002d\u0005Qa.^7CCR\u001c\u0007.Z:\t\u0011\tu\"q\u0006a\u0001\u0003G\nqB]3d_J$7\u000fU3s\u0005\u0006$8\r\u001b\u0005\t\u0005\u0003\u0012y\u00031\u0001\u0002d\u0005\t\"-\u0019;dQ\u0016\u001c\b+\u001a:TK\u001elWM\u001c;\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H\u0005i\u0011\r\u001d9f]\u0012\u0014VmY8sIN$b!a\u0010\u0003J\t-\u0003BB\u0002\u0003D\u0001\u0007q\u0010\u0003\u0005\u0003N\t\r\u0003\u0019AA2\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\b\u0005#\u0002A\u0011\u0002B*\u0003\u001di\u0017m[3M_\u001e$bAa\u0004\u0003V\te\u0003\"\u0003B,\u0005\u001f\u0002\n\u00111\u0001\u001d\u0003\r!\u0017N\u001d\u0005\b\u00057\u0012y\u00051\u0001I\u0003\u0019\u0019wN\u001c4jO\"9!q\f\u0001\u0005\n\t\u0005\u0014a\u0002:fG>\u0014Hm\u001d\u000b\t\u0005G\u0012yGa\u001d\u0003xA!!Q\rB6\u001b\t\u00119GC\u0002\u0003j=\naA]3d_J$\u0017\u0002\u0002B7\u0005O\u0012Q\"T3n_JL(+Z2pe\u0012\u001c\b\u0002\u0003B9\u0005;\u0002\r!a\u0019\u0002\u0007-,\u0017\u0010\u0003\u0005\u0003v\tu\u0003\u0019AA2\u0003\u00151\u0018\r\\;f\u0011\u001d\u0011IH!\u0018A\u0002\u0001\f\u0011\u0002^5nKN$\u0018-\u001c9\t\u0013\tu\u0004!%A\u0005\n\t}\u0014aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\u001aTC\u0001BAU\ri#1Q\u0016\u0003\u0005\u000b\u0003BAa\"\u0003\u00126\u0011!\u0011\u0012\u0006\u0005\u0005\u0017\u0013i)A\u0005v]\u000eDWmY6fI*\u0019!q\u0012\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0014\n%%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!q\u0013\u0001\u0012\u0002\u0013%!\u0011T\u0001\u0012[\u0006\\W\rT8hI\u0011,g-Y;mi\u0012\nTC\u0001BNU\ra\"1\u0011")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final TopicPartition topicPartition;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, AbstractLog> setupIncreasinglyFilthyLogs(Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1)new Serializable(this, batchIncrement, logs, numBatches){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final int batchIncrement$1;
            private final Pool logs$1;
            private final IntRef numBatches$1;

            public final void apply(TopicPartition tp) {
                MergedLog log2 = this.$outer.kafka$log$LogCleanerManagerTest$$createLog(2048, LogConfig$.MODULE$.Compact(), tp);
                this.logs$1.put((Object)tp, (Object)log2);
                this.$outer.kafka$log$LogCleanerManagerTest$$writeRecords((AbstractLog)log2, this.numBatches$1.elem, 1, 5);
                this.numBatches$1.elem += this.batchIncrement$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchIncrement$1 = batchIncrement$1;
                this.logs$1 = logs$1;
                this.numBatches$1 = numBatches$1;
            }
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        Log localLog = new Log(tpDir, this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact()), 0L, (Scheduler)this.time().scheduler(), new BrokerTopicStats(), (Time)this.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), this.topicPartition(), new ProducerStateManager(tp, tpDir, 3600000), new LogDirFailureChannel(10), Log$.MODULE$.$lessinit$greater$default$12(), Log$.MODULE$.$lessinit$greater$default$13());
        TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
        TierPartitionState tierPartitionState2 = tierLogComponents.partitionStateFactory().initState(this.logDir(), this.topicPartition(), localLog.config());
        MergedLog log2 = new MergedLog(this, localLog, tierLogComponents, tierPartitionState2){

            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }
        };
        this.kafka$log$LogCleanerManagerTest$$writeRecords((AbstractLog)log2, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log2);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, cleanerManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final LogCleanerManagerMock cleanerManager$1;

            public final LogToClean apply() {
                return (LogToClean)this.cleanerManager$1.grabFilthiestCompactedLog((Time)this.$outer.time(), this.cleanerManager$1.grabFilthiestCompactedLog$default$2()).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cleanerManager$1 = cleanerManager$1;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        Assert.assertEquals((Object)log2, (Object)thrownException.log());
        Assert.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;

            public final Option<Object> apply(TopicPartition partition) {
                return this.$outer.cleanerCheckpoints().put((Object)partition, (Object)BoxesRunTime.boxToLong((long)20L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;

            public final Option<Object> apply(TopicPartition partition) {
                return this.$outer.cleanerCheckpoints().put((Object)partition, (Object)BoxesRunTime.boxToLong((long)20L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;

            public final Option<Object> apply(TopicPartition partition) {
                return this.$outer.cleanerCheckpoints().put((Object)partition, (Object)BoxesRunTime.boxToLong((long)20L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;

            public final Option<Object> apply(TopicPartition partition) {
                return this.$outer.cleanerCheckpoints().put((Object)partition, (Object)BoxesRunTime.boxToLong((long)20L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((AbstractLog)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, AbstractLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        ((AbstractLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)tp, (Object)log2);
        this.kafka$log$LogCleanerManagerTest$$appendRecords((AbstractLog)log2, 3);
        this.kafka$log$LogCleanerManagerTest$$appendRecords((AbstractLog)log2, 3);
        this.kafka$log$LogCleanerManagerTest$$appendRecords((AbstractLog)log2, 3);
        Assert.assertEquals((long)1L, (long)log2.localLogSegments().size());
        log2.maybeIncrementLogStartOffset(2L);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs.put((Object)tp, (Object)log2);
        this.kafka$log$LogCleanerManagerTest$$appendRecords((AbstractLog)log2, 3);
        this.kafka$log$LogCleanerManagerTest$$appendRecords((AbstractLog)log2, 3);
        Assert.assertEquals((long)1L, (long)log2.localLogSegments().size());
        Assert.assertEquals((long)0L, (long)log2.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, AbstractLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log2);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log2);
        log2.appendAsLeader(records2, 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(records2, 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log2.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log2.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log2.updateConfig(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, AbstractLog> x$1) {
                return (TopicPartition)x$1._1();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log2.updateConfig(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{((LogToClean)cleanable2.get()).topicPartition()})));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log2);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log2.topicPartition());
        cleanerManager.resumeCleaning((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{log2.topicPartition()})));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, AbstractLog> x$2) {
                return (TopicPartition)x$2._1();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log2.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log2);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log2.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, AbstractLog> x$3) {
                return (TopicPartition)x$3._1();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log2.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log2);
        cleanerManager.markPartitionUncleanable(log2.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$15 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$16 = this.makeLog$default$1();
        MergedLog log2 = this.makeLog(x$16, x$15);
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.time().milliseconds()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log2, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log2.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$17 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$18 = this.makeLog$default$1();
        MergedLog log2 = this.makeLog(x$18, x$17);
        long t0 = this.time().milliseconds();
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t0), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        LogSegment activeSegAtT0 = log2.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t1), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log2, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$19 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$20 = this.makeLog$default$1();
        MergedLog log2 = this.makeLog(x$20, x$19);
        long t0 = this.time().milliseconds();
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), t0), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log2, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log2.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$21 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$22 = this.makeLog$default$1();
        MergedLog log2 = this.makeLog(x$22, x$21);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log2.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        log2.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._2$mcJ$sp());
        log2.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log2.appendAsLeader$default$4());
        log2.roll(log2.roll$default$1());
        log2.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)3L, (long)cleanableOffsets._2$mcJ$sp());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets((AbstractLog)log2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)4L, (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$23 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$24 = this.makeLog$default$1();
        MergedLog log2 = this.makeLog(x$24, x$23);
        while (log2.numberOfSegments() < 8) {
            log2.appendAsLeader(this.records((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.time().milliseconds()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log2);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, log2, cleanerManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final MergedLog log$2;
            private final LogCleanerManager cleanerManager$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$2.doneCleaning(this.$outer.topicPartition(), this.log$2.dir(), 1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.cleanerManager$2 = cleanerManager$2;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, log2, cleanerManager){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final MergedLog log$2;
            private final LogCleanerManager cleanerManager$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$2.doneCleaning(this.$outer.topicPartition(), this.log$2.dir(), 1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.cleanerManager$2 = cleanerManager$2;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log2.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log2.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        MergedLog log2 = this.kafka$log$LogCleanerManagerTest$$createLog(records2.sizeInBytes() * 5, new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager((AbstractLog)log2);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, cleanerManager, tp){
            public static final long serialVersionUID = 0L;
            private final LogCleanerManager cleanerManager$3;
            private final TopicPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$3.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$1})));
            }
            {
                this.cleanerManager$3 = cleanerManager$3;
                this.tp$1 = tp$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, cleanerManager, tp){
            public static final long serialVersionUID = 0L;
            private final LogCleanerManager cleanerManager$3;
            private final TopicPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleanerManager$3.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp$1})));
            }
            {
                this.cleanerManager$3 = cleanerManager$3;
                this.tp$1 = tp$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    private LogCleanerManager createCleanerManager(AbstractLog log2) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log2);
        return new LogCleanerManager((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, AbstractLog> pool) {
        return new LogCleanerManagerMock((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null);
    }

    public MergedLog kafka$log$LogCleanerManagerTest$$createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        File partitionDir;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        File x$25 = partitionDir = new File(this.logDir(), Log$.MODULE$.logDirName(topicPartition));
        LogConfig x$26 = config;
        long x$27 = 0L;
        long x$28 = 0L;
        MockScheduler x$29 = this.time().scheduler();
        MockTime x$30 = this.time();
        BrokerTopicStats x$31 = new BrokerTopicStats();
        int x$32 = 3600000;
        int x$33 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$34 = new LogDirFailureChannel(10);
        Option x$35 = Log$.MODULE$.apply$default$11();
        return Log$.MODULE$.apply(x$25, x$26, x$27, x$28, (Scheduler)x$29, x$31, (Time)x$30, x$32, x$33, x$34, x$35);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    public void kafka$log$LogCleanerManagerTest$$writeRecords(AbstractLog log2, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1)new Serializable(this, log2, recordsPerBatch, batchesPerSegment){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final AbstractLog log$1;
            private final int recordsPerBatch$1;
            private final int batchesPerSegment$1;

            public final Object apply(int i) {
                this.$outer.kafka$log$LogCleanerManagerTest$$appendRecords(this.log$1, this.recordsPerBatch$1);
                return i % this.batchesPerSegment$1 == 0 ? this.log$1.roll(this.log$1.roll$default$1()) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
                this.recordsPerBatch$1 = recordsPerBatch$1;
                this.batchesPerSegment$1 = batchesPerSegment$1;
            }
        });
        log2.roll(log2.roll$default$1());
    }

    public void kafka$log$LogCleanerManagerTest$$appendRecords(AbstractLog log2, int numRecords) {
        long startOffset = log2.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records2 = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1)new Serializable(this, endOffset, lastTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManagerTest $outer;
            private final long endOffset$1;
            private final LongRef lastTimestamp$1;

            public final SimpleRecord apply(long offset) {
                long currentTimestamp = this.$outer.time().milliseconds();
                if (offset == this.endOffset$1 - 1L) {
                    this.lastTimestamp$1.elem = currentTimestamp;
                }
                return new SimpleRecord(currentTimestamp, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset)})).getBytes(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset)})).getBytes());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.endOffset$1 = endOffset$1;
                this.lastTimestamp$1 = lastTimestamp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        log2.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records2.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 1, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4());
        log2.maybeIncrementHighWatermark(log2.logEndOffsetMetadata());
    }

    private MergedLog makeLog(File dir, LogConfig config) {
        File x$4 = dir;
        LogConfig x$5 = config;
        long x$6 = 0L;
        long x$7 = 0L;
        MockScheduler x$8 = this.time().scheduler();
        MockTime x$9 = this.time();
        BrokerTopicStats x$10 = new BrokerTopicStats();
        int x$11 = 3600000;
        int x$12 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$13 = new LogDirFailureChannel(10);
        Option x$14 = Log$.MODULE$.apply$default$11();
        return Log$.MODULE$.apply(x$4, x$5, x$6, x$7, (Scheduler)x$8, x$10, (Time)x$9, x$11, x$12, x$13, x$14);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public LogCleanerManagerTest() {
        Logging.class.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

