/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.AbstractLog;
import kafka.log.Log$;
import kafka.log.LogConcurrencyTest$;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\tUd\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003T8h\u0007>t7-\u001e:sK:\u001c\u0017\u0010V3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\taa]3sm\u0016\u0014\u0018BA\u000e\u0019\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0003\u0004\u001e\u0001\u0001\u0006IAF\u0001\u0012EJ|7.\u001a:U_BL7m\u0015;biN\u0004\u0003bB\u0010\u0001\u0005\u0004%I\u0001I\u0001\u0007e\u0006tGm\\7\u0016\u0003\u0005\u0002\"AI\u0013\u000e\u0003\rR!\u0001\n\u0006\u0002\tU$\u0018\u000e\\\u0005\u0003M\r\u0012aAU1oI>l\u0007B\u0002\u0015\u0001A\u0003%\u0011%A\u0004sC:$w.\u001c\u0011\t\u000f)\u0002!\u0019!C\u0005W\u0005I1o\u00195fIVdWM]\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\u0011q\u0006B\u0001\u0006kRLGn]\u0005\u0003c9\u0012abS1gW\u0006\u001c6\r[3ek2,'\u000f\u0003\u00044\u0001\u0001\u0006I\u0001L\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0003bB\u001b\u0001\u0005\u0004%IAN\u0001\u0007i6\u0004H)\u001b:\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u0005%|'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012AAR5mK\"1\u0001\t\u0001Q\u0001\n]\nq\u0001^7q\t&\u0014\b\u0005C\u0004C\u0001\t\u0007I\u0011\u0002\u001c\u0002\r1|w\rR5s\u0011\u0019!\u0005\u0001)A\u0005o\u00059An\\4ESJ\u0004\u0003\"\u0002$\u0001\t\u00039\u0015!B:fiV\u0004H#\u0001%\u0011\u0005%I\u0015B\u0001&\u000b\u0005\u0011)f.\u001b;)\u0005\u0015c\u0005CA'S\u001b\u0005q%BA(Q\u0003\u0015QWO\\5u\u0015\u0005\t\u0016aA8sO&\u00111K\u0014\u0002\u0007\u0005\u00164wN]3\t\u000bU\u0003A\u0011A$\u0002\u0011MDW\u000f\u001e3po:D#\u0001V,\u0011\u00055C\u0016BA-O\u0005\u0015\te\r^3s\u0011\u0015Y\u0006\u0001\"\u0001H\u0003y!Xm\u001d;V]\u000e|W.\\5ui\u0016$G)\u0019;b\u001d>$8i\u001c8tk6,G\r\u000b\u0002[;B\u0011QJX\u0005\u0003?:\u0013A\u0001V3ti\")\u0011\r\u0001C\u0001\u000f\u0006\u0011D/Z:u+:\u001cw.\\7jiR,G\rR1uC:{GoQ8ogVlW\r\u001a$sKF,XM\u001c;TK\u001elWM\u001c;S_2d7\u000f\u000b\u0002a;\")1\f\u0001C\u0001IR\u0011\u0001*\u001a\u0005\u0006\u0007\r\u0004\rA\u001a\t\u0003%\u001dL!\u0001\u001b\u0002\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0004\u0005U\u0002!1N\u0001\u0007D_:\u001cX/\\3s)\u0006\u001c8nE\u0002jYJ\u0004\"!\u001c9\u000e\u00039T!a\\\u001e\u0002\t1\fgnZ\u0005\u0003c:\u0014aa\u00142kK\u000e$\bcA:x\u00116\tAO\u0003\u0002vm\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0011Z\u0014B\u0001=u\u0005!\u0019\u0015\r\u001c7bE2,\u0007\u0002C\u0002j\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011mL'\u0011!Q\u0001\nq\f!\u0002\\1ti>3gm]3u!\tIQ0\u0003\u0002\u007f\u0015\t\u0019\u0011J\u001c;\t\r=IG\u0011AA\u0001)\u0019\t\u0019!a\u0002\u0002\nA\u0019\u0011QA5\u000e\u0003\u0001AQaA@A\u0002\u0019DQa_@A\u0002qD\u0011\"!\u0004j\u0005\u0004%\t!a\u0004\u0002\u001f\r|gn];nK\u0012\u0014\u0015\r^2iKN,\"!!\u0005\u0011\r\u0005M\u0011QDA\u0011\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u00037Q\u0011AC2pY2,7\r^5p]&!\u0011qDA\u000b\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0005\u0003\u000b\t\u0019C\u0002\u0004\u0002&\u0001!\u0015q\u0005\u0002\r\r\u0016$8\r[3e\u0005\u0006$8\r[\n\b\u0003GA\u0011\u0011FA\u0018!\rI\u00111F\u0005\u0004\u0003[Q!a\u0002)s_\u0012,8\r\u001e\t\u0004\u0013\u0005E\u0012bAA\u001a\u0015\ta1+\u001a:jC2L'0\u00192mK\"Y\u0011qGA\u0012\u0005+\u0007I\u0011AA\u001d\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0003\u0003w\u00012!CA\u001f\u0013\r\tyD\u0003\u0002\u0005\u0019>tw\rC\u0006\u0002D\u0005\r\"\u0011#Q\u0001\n\u0005m\u0012a\u00032bg\u0016|eMZ:fi\u0002B1\"a\u0012\u0002$\tU\r\u0011\"\u0001\u0002J\u0005)Q\r]8dQV\tA\u0010\u0003\u0006\u0002N\u0005\r\"\u0011#Q\u0001\nq\fa!\u001a9pG\"\u0004\u0003bB\b\u0002$\u0011\u0005\u0011\u0011\u000b\u000b\u0007\u0003C\t\u0019&!\u0016\t\u0011\u0005]\u0012q\na\u0001\u0003wAq!a\u0012\u0002P\u0001\u0007A\u0010\u0003\u0005\u0002Z\u0005\rB\u0011IA.\u0003!!xn\u0015;sS:<GCAA/!\u0011\ty&!\u001a\u000f\u0007%\t\t'C\u0002\u0002d)\ta\u0001\u0015:fI\u00164\u0017\u0002BA4\u0003S\u0012aa\u0015;sS:<'bAA2\u0015!Q\u0011QNA\u0012\u0003\u0003%\t!a\u001c\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003C\t\t(a\u001d\t\u0015\u0005]\u00121\u000eI\u0001\u0002\u0004\tY\u0004C\u0005\u0002H\u0005-\u0004\u0013!a\u0001y\"Q\u0011qOA\u0012#\u0003%\t!!\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0010\u0016\u0005\u0003w\tih\u000b\u0002\u0002\u0000A!\u0011\u0011QAF\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015!C;oG\",7m[3e\u0015\r\tIIC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAG\u0003\u0007\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\t\t*a\t\u0012\u0002\u0013\u0005\u00111S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)JK\u0002}\u0003{B!\"!'\u0002$\u0005\u0005I\u0011IAN\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0014\t\u0004[\u0006}\u0015bAA4]\"Q\u00111UA\u0012\u0003\u0003%\t!!\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\u0005\u001d\u00161EA\u0001\n\u0003\tI+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-\u0016\u0011\u0017\t\u0004\u0013\u00055\u0016bAAX\u0015\t\u0019\u0011I\\=\t\u0013\u0005M\u0016QUA\u0001\u0002\u0004a\u0018a\u0001=%c!Q\u0011qWA\u0012\u0003\u0003%\t%!/\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a/\u0011\r\u0005u\u0016qXAV\u001b\t\tI\"\u0003\u0003\u0002B\u0006e!\u0001C%uKJ\fGo\u001c:\t\u0015\u0005\u0015\u00171EA\u0001\n\u0003\t9-\u0001\u0005dC:,\u0015/^1m)\u0011\tI-a4\u0011\u0007%\tY-C\u0002\u0002N*\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u00024\u0006\r\u0017\u0011!a\u0001\u0003WC!\"a5\u0002$\u0005\u0005I\u0011IAk\u0003!A\u0017m\u001d5D_\u0012,G#\u0001?\t\u0015\u0005e\u00171EA\u0001\n\u0003\nY.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0013\fi\u000e\u0003\u0006\u00024\u0006]\u0017\u0011!a\u0001\u0003WC\u0001\"!9jA\u0003%\u0011\u0011C\u0001\u0011G>t7/^7fI\n\u000bGo\u00195fg\u0002Ba!!:j\t\u0003:\u0015\u0001B2bY24a!!;\u0001\t\u0005-(!\u0004'pO\u0006\u0003\b/\u001a8e)\u0006\u001c8n\u0005\u0003\u0002h2\u0014\b\"C\u0002\u0002h\n\u0005\t\u0015!\u0003g\u0011)Y\u0018q\u001dB\u0001B\u0003%\u00111\b\u0005\b\u001f\u0005\u001dH\u0011AAz)\u0019\t)0a>\u0002zB!\u0011QAAt\u0011\u0019\u0019\u0011\u0011\u001fa\u0001M\"910!=A\u0002\u0005m\u0002bBAs\u0003O$\te\u0012\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0003%\u0019'/Z1uK2{w\rF\u0002g\u0005\u0007A!B!\u0002\u0002~B\u0005\t\u0019\u0001B\u0004\u0003\u0019\u0019wN\u001c4jOB\u0019!C!\u0003\n\u0007\t-!AA\u0005M_\u001e\u001cuN\u001c4jO\"9!q\u0002\u0001\u0005\n\tE\u0011\u0001\u0006<bY&$\u0017\r^3D_:\u001cX/\\3e\t\u0006$\u0018\rF\u0003I\u0005'\u0011)\u0002\u0003\u0004\u0004\u0005\u001b\u0001\rA\u001a\u0005\t\u0003\u001b\u0011i\u00011\u0001\u0003\u0018A1!\u0011\u0004B\u0015\u0003CqAAa\u0007\u0003&9!!Q\u0004B\u0012\u001b\t\u0011yBC\u0002\u0003\"\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0007\t\u001d\"\"A\u0004qC\u000e\\\u0017mZ3\n\t\t-\"Q\u0006\u0002\t\u0013R,'/\u00192mK*\u0019!q\u0005\u0006\b\u0013\tE\u0002!!A\t\n\tM\u0012\u0001\u0004$fi\u000eDW\r\u001a\"bi\u000eD\u0007\u0003BA\u0003\u0005k1\u0011\"!\n\u0001\u0003\u0003EIAa\u000e\u0014\r\tU\"\u0011HA\u0018!%\u0011YD!\u0011\u0002<q\f\t#\u0004\u0002\u0003>)\u0019!q\b\u0006\u0002\u000fI,h\u000e^5nK&!!1\tB\u001f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b\u001f\tUB\u0011\u0001B$)\t\u0011\u0019\u0004\u0003\u0006\u0002Z\tU\u0012\u0011!C#\u0005\u0017\"\"!!(\t\u0015\t=#QGA\u0001\n\u0003\u0013\t&A\u0003baBd\u0017\u0010\u0006\u0004\u0002\"\tM#Q\u000b\u0005\t\u0003o\u0011i\u00051\u0001\u0002<!9\u0011q\tB'\u0001\u0004a\bB\u0003B-\u0005k\t\t\u0011\"!\u0003\\\u00059QO\\1qa2LH\u0003\u0002B/\u0005S\u0002R!\u0003B0\u0005GJ1A!\u0019\u000b\u0005\u0019y\u0005\u000f^5p]B1\u0011B!\u001a\u0002<qL1Aa\u001a\u000b\u0005\u0019!V\u000f\u001d7fe!Q!1\u000eB,\u0003\u0003\u0005\r!!\t\u0002\u0007a$\u0003\u0007C\u0005\u0003p\u0001\t\n\u0011\"\u0003\u0003r\u0005\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u000f\u0016\u0005\u0005\u000f\ti\b")
public class LogConcurrencyTest {
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private volatile LogConcurrencyTest$FetchedBatch$ kafka$log$LogConcurrencyTest$$FetchedBatch$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LogConcurrencyTest$FetchedBatch$ kafka$log$LogConcurrencyTest$$FetchedBatch$lzycompute() {
        LogConcurrencyTest logConcurrencyTest = this;
        synchronized (logConcurrencyTest) {
            if (this.kafka$log$LogConcurrencyTest$$FetchedBatch$module != null) return this.kafka$log$LogConcurrencyTest$$FetchedBatch$module;
            this.kafka$log$LogConcurrencyTest$$FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            return this.kafka$log$LogConcurrencyTest$$FetchedBatch$module;
        }
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @Before
    public void setup() {
        this.scheduler().startup();
    }

    @After
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    /*
     * WARNING - void declaration
     */
    public void testUncommittedDataNotConsumed(AbstractLog log2) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log2, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log2, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            Future<BoxedUnit> fetcherTaskFuture = executor.submit(appendTask);
            fetcherTaskFuture.get();
            consumerFuture.get();
            this.validateConsumedData(log2, (Iterable<FetchedBatch>)consumer.consumedBatches());
            executor.shutdownNow();
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.shutdownNow();
            throw throwable;
        }
    }

    private AbstractLog createLog(LogConfig config) {
        return Log$.MODULE$.apply(this.logDir(), config, 0L, 0L, (Scheduler)this.scheduler(), this.brokerTopicStats(), Time.SYSTEM, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10), Log$.MODULE$.apply$default$11());
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
    }

    private void validateConsumedData(AbstractLog log2, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log2.localLogSegments().foreach((Function1)new Serializable(this, iter){
            public static final long serialVersionUID = 0L;
            public final Iterator iter$1;

            public final void apply(LogSegment segment) {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$validateConsumedData$1 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        if (!this.$outer.iter$1.hasNext()) return;
                        FetchedBatch consumedBatch = (FetchedBatch)this.$outer.iter$1.next();
                        try {
                            Assert.assertEquals((String)"Consumed batch with unexpected leader epoch", (long)batch.partitionLeaderEpoch(), (long)consumedBatch.epoch());
                            Assert.assertEquals((String)"Consumed batch with unexpected base offset", (long)batch.baseOffset(), (long)consumedBatch.baseOffset());
                            return;
                        }
                        catch (Throwable throwable) {
                            throw new AssertionError(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumed batch ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumedBatch}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not match next expected batch in log ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch}))).toString(), throwable);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.iter$1 = iter$1;
            }
        });
    }

    public LogConcurrencyTest$FetchedBatch$ kafka$log$LogConcurrencyTest$$FetchedBatch() {
        return this.kafka$log$LogConcurrencyTest$$FetchedBatch$module == null ? this.kafka$log$LogConcurrencyTest$$FetchedBatch$lzycompute() : this.kafka$log$LogConcurrencyTest$$FetchedBatch$module;
    }

    public class ConsumerTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                FetchDataInfo readInfo = this.log.readLocal(fetchOffset.elem, 1, (FetchIsolation)FetchHighWatermark$.MODULE$, true);
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(readInfo.records().batches()).asScala()).foreach((Function1)new Serializable(this, fetchOffset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ConsumerTask $outer;
                    private final LongRef fetchOffset$1;

                    public final void apply(RecordBatch batch) {
                        this.$outer.consumedBatches().$plus$eq((Object)new FetchedBatch(this.$outer.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                        this.fetchOffset$1.elem = batch.lastOffset() + 1L;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fetchOffset$1 = fetchOffset$1;
                    }
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, AbstractLog log2, int lastOffset) {
            this.log = log2;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = (ListBuffer)ListBuffer$.MODULE$.empty();
        }
    }

    public class FetchedBatch
    implements Product,
    Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FetchedBatch(baseOffset=", ", epoch=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.baseOffset()), BoxesRunTime.boxToInteger((int)this.epoch())}));
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    number = BoxesRunTime.boxToInteger((int)this.epoch());
                    break;
                }
                case 0: {
                    number = BoxesRunTime.boxToLong((long)this.baseOffset());
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.baseOffset()));
            n = Statics.mix((int)n, (int)this.epoch());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FetchedBatch)) return false;
            boolean bl = true;
            if (!bl) return false;
            FetchedBatch fetchedBatch = (FetchedBatch)x$1;
            if (this.baseOffset() != fetchedBatch.baseOffset()) return false;
            if (this.epoch() != fetchedBatch.epoch()) return false;
            if (!fetchedBatch.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }

    public class LogAppendTask
    implements Callable<BoxedUnit> {
        private final AbstractLog log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                    case 1: {
                        Object object;
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) {
                            object = BoxedUnit.UNIT;
                            break;
                        }
                        object = BoxesRunTime.boxToBoolean((boolean)this.log.truncateTo(this.log.highWatermark()));
                        break;
                    }
                    case 0: {
                        Object object;
                        LogOffsetMetadata logEndOffsetMetadata2 = this.log.logEndOffsetMetadata();
                        long logEndOffset2 = logEndOffsetMetadata2.messageOffset();
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final SimpleRecord apply(int i) {
                                return new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records2, TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4());
                            object = this.log.maybeIncrementHighWatermark(logEndOffsetMetadata2);
                            break;
                        }
                        IndexedSeq x$1 = records2;
                        long x$2 = logEndOffset2;
                        int x$3 = leaderEpoch;
                        byte x$4 = TestUtils$.MODULE$.records$default$2();
                        CompressionType x$5 = TestUtils$.MODULE$.records$default$3();
                        long x$6 = TestUtils$.MODULE$.records$default$4();
                        short x$7 = TestUtils$.MODULE$.records$default$5();
                        int x$8 = TestUtils$.MODULE$.records$default$6();
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$1, x$4, x$5, x$6, x$7, x$8, x$2, x$3));
                        object = BoxesRunTime.boxToLong((long)this.log.updateHighWatermark(logEndOffset2));
                    }
                }
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public LogAppendTask(LogConcurrencyTest $outer, AbstractLog log2, long lastOffset) {
            this.log = log2;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

