/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogConfigTest$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u000f\tiAj\\4D_:4\u0017n\u001a+fgRT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011\u0005Q#A\u0016f]N,(/\u001a(p'R\fG/[2J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Pe\u0012,'\u000fR3qK:$WM\\2z)\u00051\u0002CA\u0005\u0018\u0013\tA\"B\u0001\u0003V]&$\bFA\n\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0003kk:LGOC\u0001 \u0003\ry'oZ\u0005\u0003Cq\u0011A\u0001V3ti\")1\u0005\u0001C\u0001+\u00051B/Z:u\u0017\u000647.Y\"p]\u001aLw\rV8Qe>\u00048\u000f\u000b\u0002#5!)a\u0005\u0001C\u0001+\u0005\u0011D/Z:u\u000b:\f'\r\\3TG\",W.\u0019,bY&$\u0017\r^5p]^KG\u000f[8viN\u001b\u0007.Z7b%\u0016<\u0017n\u001d;ssV\u0013H\u000e\u000b\u0002&5!)\u0011\u0006\u0001C\u0001+\u0005yC/Z:u\u000b:\f'\r\\3TG\",W.\u0019,bY&$\u0017\r^5p]^KG\u000f[*dQ\u0016l\u0017MU3hSN$(/_+sY\"\u0012\u0001F\u0007\u0005\u0006Y\u0001!\t!F\u0001\u0013i\u0016\u001cHO\u0012:p[B\u0013x\u000e]:F[B$\u0018\u0010\u000b\u0002,5!)q\u0006\u0001C\u0001+\u0005!B/Z:u\rJ|W\u000e\u0015:paNLeN^1mS\u0012D#A\f\u000e\t\u000bI\u0002A\u0011A\u000b\u0002=Q,7\u000f^%om\u0006d\u0017\u000eZ\"p[B\f7\r^5p]2\u000bwmQ8oM&<\u0007FA\u0019\u001b\u0011\u0015)\u0004\u0001\"\u0001\u0016\u0003\u0015\u001a\bn\\;mIZ\u000bG.\u001b3bi\u0016$\u0006N]8ui2,GMU3qY&\u001c\u0017m]\"p]\u001aLw\r\u000b\u000255!)\u0001\b\u0001C\u0001+\u0005yA/Z:u)>DE/\u001c7UC\ndW\r\u000b\u000285!)1\b\u0001C\u0001+\u0005QA/Z:u)>DE/\u001c7)\u0005iR\u0002\"\u0002 \u0001\t\u0003)\u0012!\u0005;fgR$v.\u00128sS\u000eDW\r\u001a*ti\"\u0012QH\u0007\u0005\u0006\u0003\u0002!\t!F\u0001\ni\u0016\u001cH\u000fV8SgRD#\u0001\u0011\u000e\t\u000b\u0011\u0003A\u0011A\u000b\u0002%Q,7\u000f^$fi\u000e{gNZ5h-\u0006dW/\u001a\u0015\u0003\u0007jAQa\u0012\u0001\u0005\u0002U\tQ\u0005^3ti>3XM\u001d:jI\u0012,gnQ8oM&<7/Q:M_\u001e<\u0017M\u00197f'R\u0014\u0018N\\4)\u0005\u0019S\u0002\"\u0002&\u0001\t\u0013Y\u0015aB5t-\u0006d\u0017\u000e\u001a\u000b\u0003\u0019>\u0003\"!C'\n\u00059S!a\u0002\"p_2,\u0017M\u001c\u0005\u0006!&\u0003\r!U\u0001\fG>tg-[4WC2,X\r\u0005\u0002S+:\u0011\u0011bU\u0005\u0003)*\ta\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011AK\u0003\u0005\u00063\u0002!IAW\u0001\u0016CN\u001cXM\u001d;Qe>\u0004XM\u001d;z\u0013:4\u0018\r\\5e)\r12,\u0018\u0005\u00069b\u0003\r!U\u0001\u0005]\u0006lW\rC\u0003_1\u0002\u0007q,\u0001\u0004wC2,Xm\u001d\t\u0004\u0013\u0001D\u0011BA1\u000b\u0005)a$/\u001a9fCR,GM\u0010")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assert.assertTrue((KafkaConfig$.MODULE$.LogRetentionTimeMillisProp() != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)LogConfig$.MODULE$.configNames().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String config) {
                Option serverConfigOpt;
                boolean bl;
                String string = config;
                String string2 = LogConfig$.MODULE$.TopicPlacementConstraintsProp();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    bl = true;
                } else {
                    String string4 = LogConfig$.MODULE$.KeySchemaValidationEnableProp();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        bl = true;
                    } else {
                        String string6 = LogConfig$.MODULE$.ValueSchemaValidationEnableProp();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            bl = true;
                        } else {
                            String string8 = LogConfig$.MODULE$.KeySchemaValidationStrategyProp();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                bl = true;
                            } else {
                                String string10 = LogConfig$.MODULE$.ValueSchemaValidationStrategyProp();
                                String string11 = string;
                                bl = !(string10 != null ? !string10.equals(string11) : string11 != null);
                            }
                        }
                    }
                }
                boolean bl2 = bl ? !LogConfig$.MODULE$.serverConfigName(config).isDefined() : (serverConfigOpt = LogConfig$.MODULE$.serverConfigName(config)).isDefined() && serverConfigOpt.get() != null;
                return bl2;
            }
        }));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.SegmentJitterMsProp()));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get(LogConfig$.MODULE$.RetentionMsProp()));
    }

    @Test
    public void testEnableSchemaValidationWithoutSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), LogConfig$.MODULE$.KeySchemaValidationEnableProp()})).foreach((Function1)new Serializable(this, logProps){
            public static final long serialVersionUID = 0L;
            public final Map logProps$1;

            public final InvalidConfigurationException apply(String cfg) {
                this.logProps$1.put(cfg, "true");
                return (InvalidConfigurationException)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testEnableSchemaValidationWithoutSchemaRegistryUrl$1 $outer;

                    public final LogConfig apply() {
                        return new LogConfig(this.$outer.logProps$1, LogConfig$.MODULE$.apply$default$2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            }
            {
                this.logProps$1 = logProps$1;
            }
        });
    }

    @Test
    public void testEnableSchemaValidationWithSchemaRegistryUrl() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("confluent.schema.registry.url", "bogus");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Map logProps = KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig);
        KafkaServer$.MODULE$.augmentWithKafkaConfig(logProps, kafkaConfig);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.ValueSchemaValidationEnableProp(), LogConfig$.MODULE$.KeySchemaValidationEnableProp()})).foreach((Function1)new Serializable(this, logProps){
            public static final long serialVersionUID = 0L;
            public final Map logProps$2;

            public final void apply(String cfg) {
                this.logProps$2.put(cfg, "true");
                KafkaException e = (KafkaException)((Object)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testEnableSchemaValidationWithSchemaRegistryUrl$1 $outer;

                    public final LogConfig apply() {
                        return new LogConfig(this.$outer.logProps$2, LogConfig$.MODULE$.apply$default$2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(KafkaException.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106)));
                Assert.assertEquals((Object)"Class io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator cannot be found", (Object)e.getMessage());
            }
            {
                this.logProps$2 = logProps$2;
            }
        });
    }

    @Test
    public void testFromPropsEmpty() {
        Properties p = new Properties();
        LogConfig config = new LogConfig((Map)p, LogConfig$.MODULE$.apply$default$2());
        Assert.assertEquals((Object)LogConfig$.MODULE$.apply(), (Object)config);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x$1) {
                return x$1._2() == null;
            }
        }));
        Assert.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get(LogConfig$.MODULE$.ValueSchemaValidationStrategyProp()));
        Assert.assertEquals((Object)"io.confluent.kafka.serializers.subject.TopicNameStrategy", config.values().get(LogConfig$.MODULE$.KeySchemaValidationStrategyProp()));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig$.MODULE$.configNames().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogConfigTest $outer;

            public final void apply(String name) {
                String string = name;
                String string2 = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string4 = LogConfig$.MODULE$.RetentionBytesProp();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string6 = LogConfig$.MODULE$.RetentionMsProp();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string8 = LogConfig$.MODULE$.CleanupPolicyProp();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String string10 = LogConfig$.MODULE$.MinCleanableDirtyRatioProp();
                                String string11 = string;
                                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                    this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    String string12 = LogConfig$.MODULE$.MinInSyncReplicasProp();
                                    String string13 = string;
                                    if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                        this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        String string14 = LogConfig$.MODULE$.MessageFormatVersionProp();
                                        String string15 = string;
                                        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                            this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            String string16 = LogConfig$.MODULE$.TierLocalHotsetBytesProp();
                                            String string17 = string;
                                            if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                                this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                String string18 = LogConfig$.MODULE$.TierLocalHotsetMsProp();
                                                String string19 = string;
                                                if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                                                    this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    String string20 = LogConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp();
                                                    String string21 = string;
                                                    if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
                                                        this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        String string22 = LogConfig$.MODULE$.PreferTierFetchMsProp();
                                                        String string23 = string;
                                                        if (!(string22 != null ? !string22.equals(string23) : string23 != null)) {
                                                            this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        } else {
                                                            String string24 = LogConfig$.MODULE$.TopicPlacementConstraintsProp();
                                                            String string25 = string;
                                                            if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                                                                this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"json only", "null"}));
                                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            } else {
                                                                String string26 = LogConfig$.MODULE$.KeySchemaValidationStrategyProp();
                                                                String string27 = string;
                                                                if (!(string26 != null ? !string26.equals(string27) : string27 != null)) {
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                } else {
                                                                    String string28 = LogConfig$.MODULE$.ValueSchemaValidationStrategyProp();
                                                                    String string29 = string;
                                                                    if (!(string28 != null ? !string28.equals(string29) : string29 != null)) {
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    } else {
                                                                        this.$outer.kafka$log$LogConfigTest$$assertPropertyInvalid(name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxCompactionLagMsProp(), "100");
        props.setProperty(LogConfig$.MODULE$.MinCompactionLagMsProp(), "200");
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogConfig$.MODULE$.validate(this.props$1);
            }
            {
                this.props$1 = props$1;
            }
        }, ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assert.assertTrue((boolean)this.isValid("*"));
        Assert.assertTrue((boolean)this.isValid("* "));
        Assert.assertTrue((boolean)this.isValid(""));
        Assert.assertTrue((boolean)this.isValid(" "));
        Assert.assertTrue((boolean)this.isValid("100:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assert.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assert.assertTrue((boolean)this.isValid("100:0,"));
        Assert.assertFalse((boolean)this.isValid("100"));
        Assert.assertFalse((boolean)this.isValid("100:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:"));
        Assert.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assert.assertFalse((boolean)this.isValid("100:0,10 :   "));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find `", "` in:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedConfig, html})), (boolean)html.contains(expectedConfig));
    }

    @Test
    public void testToHtml() {
        String html = LogConfig$.MODULE$.configDefCopy().toHtml();
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\" href=\"#file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find `", "` in:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedConfig, html})), (boolean)html.contains(expectedConfig));
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find `", "` in:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedConfig, rst})), (boolean)rst.contains(expectedConfig));
    }

    @Test
    public void testToRst() {
        String rst = LogConfig$.MODULE$.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find `", "` in:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedConfig, rst})), (boolean)rst.contains(expectedConfig));
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig$.MODULE$.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " doc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configNameWithNoServerMapping})));
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, LogConfig$.MODULE$.ServerDefaultHeaderName());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        String nullServerDefault = configDef.getConfigValue(keyWithNoServerMapping, LogConfig$.MODULE$.ServerDefaultHeaderName());
        Assert.assertNull((Object)nullServerDefault);
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(kafkaConfig), topicOverrides);
        Assert.assertEquals((Object)"{min.insync.replicas=2, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        boolean bl;
        try {
            ThrottledReplicaListValidator$.MODULE$.ensureValidString("", configValue);
            bl = true;
        }
        catch (ConfigException configException) {
            bl = false;
        }
        return bl;
    }

    public void kafka$log$LogConfigTest$$assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final Exception apply(Object value) {
                Properties props = new Properties();
                props.setProperty(this.name$1, value.toString());
                return (Exception)Assertions$.MODULE$.intercept((Function0)new Serializable(this, props){
                    public static final long serialVersionUID = 0L;
                    private final Properties props$2;

                    public final LogConfig apply() {
                        return new LogConfig((Map)this.props$2, LogConfig$.MODULE$.apply$default$2());
                    }
                    {
                        this.props$2 = props$2;
                    }
                }, ClassTag$.MODULE$.apply(Exception.class), new Position("LogConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            }
            {
                this.name$1 = name$1;
            }
        });
    }
}

