/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.common.LongRef;
import kafka.common.RecordValidationException;
import kafka.log.AppendOrigin;
import kafka.log.InterceptorStats;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.log.LogValidatorTest$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.InterceptorUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r5h\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003T8h-\u0006d\u0017\u000eZ1u_J$Vm\u001d;\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012\u0001\u0002;j[\u0016,\u0012A\u0006\t\u0003/\u0005j\u0011\u0001\u0007\u0006\u00033i\tQ!\u001e;jYNT!a\u0007\u000f\u0002\r\r|W.\\8o\u0015\t)QD\u0003\u0002\u001f?\u00051\u0011\r]1dQ\u0016T\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u0019\u0005\u0011!\u0016.\\3\t\r\u0011\u0002\u0001\u0015!\u0003\u0017\u0003\u0015!\u0018.\\3!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001)!\tI#&D\u0001\u001b\u0013\tY#D\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r5\u0002\u0001\u0015!\u0003)\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003i\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001c4\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0003\u00049\u0001\u0001\u0006I!M\u0001\u0012EJ|7.\u001a:U_BL7m\u0015;biN\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%\taO\u0001\u0011S:$XM]2faR|'o\u0015;biN,\u0012\u0001\u0010\t\u0003%uJ!A\u0010\u0002\u0003!%sG/\u001a:dKB$xN]*uCR\u001c\bB\u0002!\u0001A\u0003%A(A\tj]R,'oY3qi>\u00148\u000b^1ug\u0002BqA\u0011\u0001C\u0002\u0013\u00051)A\u0007nKR\u0014\u0018nY:LKf\u001cV\r^\u000b\u0002\tB\u0019QI\u0013'\u000e\u0003\u0019S!a\u0012%\u0002\u000f5,H/\u00192mK*\u0011\u0011JC\u0001\u000bG>dG.Z2uS>t\u0017BA&G\u0005\r\u0019V\r\u001e\t\u0003\u001bZk\u0011A\u0014\u0006\u0003\u001fB\u000bAaY8sK*\u0011\u0011KU\u0001\b[\u0016$(/[2t\u0015\t\u0019F+\u0001\u0004zC6lWM\u001d\u0006\u0002+\u0006\u00191m\\7\n\u0005]s%AC'fiJL7MT1nK\"1\u0011\f\u0001Q\u0001\n\u0011\u000ba\"\\3ue&\u001c7oS3z'\u0016$\b\u0005C\u0003\\\u0001\u0011\u0005A,\u0001\tuKN$xJ\u001c7z\u001f:,')\u0019;dQR\tQ\f\u0005\u0002\n=&\u0011qL\u0003\u0002\u0005+:LG\u000f\u000b\u0002[CB\u0011!-Z\u0007\u0002G*\u0011AmH\u0001\u0006UVt\u0017\u000e^\u0005\u0003M\u000e\u0014A\u0001V3ti\")\u0001\u000e\u0001C\u00019\u0006\u0019B/Z:u\u00032dwn^'vYRL')\u0019;dQ\"\u0012q-\u0019\u0005\u0006W\u0002!\t\u0001X\u00015i\u0016\u001cHOV1mS\u0012\fG/[8o\u001f\u001a\u0014\u0015\r^2iKN<\u0016\u000e\u001e5O_:\u001cV-];f]RL\u0017\r\\%o]\u0016\u0014xJ\u001a4tKR\u001c\bF\u00016b\u0011\u0015q\u0007\u0001\"\u0001]\u0003E!Xm\u001d;NSNl\u0015\r^2i\u001b\u0006<\u0017n\u0019\u0015\u0003[\u0006DQ!\u001d\u0001\u0005\nI\f\u0011c\u00195fG.|e\u000e\\=P]\u0016\u0014\u0015\r^2i)\u0015i6\u000f_A\u0001\u0011\u0015!\b\u000f1\u0001v\u0003\u0015i\u0017mZ5d!\tIa/\u0003\u0002x\u0015\t!!)\u001f;f\u0011\u0015I\b\u000f1\u0001{\u0003U\u0019x.\u001e:dK\u000e{W\u000e\u001d:fgNLwN\u001c+za\u0016\u0004\"a\u001f@\u000e\u0003qT!! \u000e\u0002\rI,7m\u001c:e\u0013\tyHPA\bD_6\u0004(/Z:tS>tG+\u001f9f\u0011\u0019\t\u0019\u0001\u001da\u0001u\u0006)B/\u0019:hKR\u001cu.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007bBA\u0004\u0001\u0011%\u0011\u0011B\u0001\u0015G\",7m[!mY><X*\u001e7uS\n\u000bGo\u00195\u0015\u000fu\u000bY!!\u0004\u0002\u0010!1A/!\u0002A\u0002UDa!_A\u0003\u0001\u0004Q\bbBA\u0002\u0003\u000b\u0001\rA\u001f\u0005\b\u0003'\u0001A\u0011BA\u000b\u0003I\u0019\u0007.Z2l\u001b&\u001cX.\u0019;dQ6\u000bw-[2\u0015\u000fu\u000b9\"a\u0007\u0002 !9\u0011\u0011DA\t\u0001\u0004)\u0018A\u00032bi\u000eDW*Y4jG\"9\u0011QDA\t\u0001\u0004)\u0018a\u0003:fG>\u0014H-T1hS\u000eDq!!\t\u0002\u0012\u0001\u0007!0A\bd_6\u0004(/Z:tS>tG+\u001f9f\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\t\u0001C^1mS\u0012\fG/Z'fgN\fw-Z:\u0015\u0015\u0005%\u0012QIA(\u0003#\n\u0019\u0006\u0005\u0003\u0002,\u0005}b\u0002BA\u0017\u0003wqA!a\f\u0002:9!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0003\n\u0005\r!\u0011bAA\u001f\u0005\u0005aAj\\4WC2LG-\u0019;pe&!\u0011\u0011IA\"\u0005}1\u0016\r\\5eCRLwN\\!oI>3gm]3u\u0003N\u001c\u0018n\u001a8SKN,H\u000e\u001e\u0006\u0004\u0003{\u0011\u0001\u0002CA$\u0003G\u0001\r!!\u0013\u0002\u000fI,7m\u001c:egB\u001910a\u0013\n\u0007\u00055CPA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\u0007i\u0006\r\u0002\u0019A;\t\re\f\u0019\u00031\u0001{\u0011\u001d\t\u0019!a\tA\u0002iDa!a\u0016\u0001\t\u0003a\u0016\u0001\t;fgRdunZ!qa\u0016tG\rV5nK:{gnQ8naJ,7o]3e-FB3!!\u0016b\u0011\u001d\ti\u0006\u0001C\u0005\u0003?\nqd\u00195fG.dunZ!qa\u0016tG\rV5nK:{gnQ8naJ,7o]3e)\ri\u0016\u0011\r\u0005\u0007i\u0006m\u0003\u0019A;\t\r\u0005\u0015\u0004\u0001\"\u0001]\u0003\u0001\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GM\u0016\u001a\t\r\u0005%\u0004\u0001\"\u0001]\u0003\u0011\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]Z\u000b\u0004fAA4C\"9\u0011q\u000e\u0001\u0005\n\u0005E\u0014aI2iK\u000e\\Gj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5SK\u000e|W\u000e\u001d:fgNLwN\u001c\u000b\u0004;\u0006M\u0004bBA;\u0003[\u0002\r!^\u0001\fi\u0006\u0014x-\u001a;NC\u001eL7\r\u0003\u0004\u0002z\u0001!\t\u0001X\u0001%i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8We!\u001a\u0011qO1\t\r\u0005}\u0004\u0001\"\u0001]\u0003\u001d\"Xm\u001d;M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"|W\u000f\u001e*fG>l\u0007O]3tg&|gNV\u0019)\u0007\u0005u\u0014\rC\u0004\u0002\u0006\u0002!I!a\"\u0002M\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"|W\u000f\u001e*fG>l\u0007O]3tg&|g\u000eF\u0002^\u0003\u0013Ca\u0001^AB\u0001\u0004)\bBBAG\u0001\u0011\u0005A,\u0001\u0013uKN$\u0018J\u001c<bY&$wJ\u001a4tKR\u0014\u0016M\\4f\u0003:$'+Z2pe\u0012\u001cu.\u001e8uQ\r\tY)\u0019\u0005\b\u0003'\u0003A\u0011BAK\u0003\u0001\n7o]3si&sg/\u00197jI\n\u000bGo\u00195D_VtGo\u0014<feJLG-Z:\u0015\u000bu\u000b9*!)\t\u0011\u0005e\u0015\u0011\u0013a\u0001\u00037\u000bq\u0002\\1ti>3gm]3u\t\u0016dG/\u0019\t\u0004\u0013\u0005u\u0015bAAP\u0015\t\u0019\u0011J\u001c;\t\u0011\u0005\r\u0016\u0011\u0013a\u0001\u00037\u000bQaY8v]RDq!a*\u0001\t\u0013\tI+A\u0013wC2LG-\u0019;f%\u0016\u001cwN\u001d3CCR\u001c\u0007nV5uQ\u000e{WO\u001c;Pm\u0016\u0014(/\u001b3fgR)Q,a+\u0002.\"A\u0011\u0011TAS\u0001\u0004\tY\n\u0003\u0005\u0002$\u0006\u0015\u0006\u0019AAN\u0011\u0019\t\t\f\u0001C\u00019\u00069C/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRDw.\u001e;SK\u000e|W\u000e\u001d:fgNLwN\u001c,3Q\r\ty+\u0019\u0005\u0007\u0003o\u0003A\u0011\u0001/\u0002'Q,7\u000f\u001e(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007\u0005U\u0016\rC\u0004\u0002>\u0002!I!a0\u0002%\rDWmY6O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u000b\u0004;\u0006\u0005\u0007B\u0002;\u0002<\u0002\u0007Q\u000f\u0003\u0004\u0002F\u0002!\t\u0001X\u0001\u0014i\u0016\u001cHOT8o\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004\u0003\u0007\f\u0007BBAf\u0001\u0011\u0005A,A\nuKN$(+Z2p[B\u0014Xm]:j_:4\u0016\u0007K\u0002\u0002J\u0006Dq!!5\u0001\t\u0013\t\u0019.\u0001\ndQ\u0016\u001c7NU3d_6\u0004(/Z:tS>tGcA/\u0002V\"1A/a4A\u0002UDa!!7\u0001\t\u0003a\u0016a\u0005;fgR\u0014VmY8naJ,7o]5p]Z\u0013\u0004fAAlC\"1\u0011q\u001c\u0001\u0005\u0002q\u000b\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0006\u0007V8Wc!\u001a\u0011Q\\1\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\u0006\t3\r[3dW\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4%o\\7WaQ\u0019Q,!;\t\u000f\u0005-\u00181\u001da\u0001k\u00069Ao\\'bO&\u001c\u0007BBAx\u0001\u0011\u0005A,\u0001\u0011uKN$8I]3bi\u0016$\u0016.\\3Va\u000e{gN^3sg&|gN\u0016\u0019U_Z\u0013\u0004fAAwC\"1\u0011Q\u001f\u0001\u0005\u0002q\u000b\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0016\u0007V8We!\u001a\u00111_1\t\r\u0005m\b\u0001\"\u0001]\u0003A!Xm\u001d;D_6\u0004(/Z:tK\u00124\u0016\u0007K\u0002\u0002z\u0006DqA!\u0001\u0001\t\u0013\u0011\u0019!A\bdQ\u0016\u001c7nQ8naJ,7o]3e)\ri&Q\u0001\u0005\u0007i\u0006}\b\u0019A;\t\r\t%\u0001\u0001\"\u0001]\u0003A!Xm\u001d;D_6\u0004(/Z:tK\u00124&\u0007K\u0002\u0003\b\u0005DaAa\u0004\u0001\t\u0003a\u0016\u0001\n;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u000f\t5\u0011Ma\u0005\u0003\u0016\u0005AQ\r\u001f9fGR,Gm\t\u0002\u0003\u0018A!!\u0011\u0004B\u000f\u001b\t\u0011YB\u0003\u0002\u001c\t%!!q\u0004B\u000e\u0005e\u0011VmY8sIZ\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8\t\r\t\r\u0002\u0001\"\u0001]\u0003\u0011\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016tuN\\\"p[B\u0014Xm]:fIZ\u0013\u0004f\u0002B\u0011C\nM!Q\u0003\u0005\u0007\u0005S\u0001A\u0011\u0001/\u0002CQ,7\u000f^%om\u0006d\u0017\u000eZ\"sK\u0006$X\rV5nK\u000e{W\u000e\u001d:fgN,GMV\u0019)\u000f\t\u001d\u0012Ma\u0005\u0003\u0016!1!q\u0006\u0001\u0005\u0002q\u000b\u0011\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWmQ8naJ,7o]3e-JBsA!\fb\u0005'\u0011)\u0002\u0003\u0004\u00036\u0001!\t\u0001X\u0001*i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007\tM\u0012\r\u0003\u0004\u0003<\u0001!\t\u0001X\u0001'i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u0007>l\u0007O]3tg\u0016$\u0007f\u0001B\u001dC\"1!\u0011\t\u0001\u0005\u0002q\u000b1\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGOT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004\u0005\u007f\t\u0007B\u0002B$\u0001\u0011\u0005A,A\u0016uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\r\u0011)%\u0019\u0005\u0007\u0005\u001b\u0002A\u0011\u0001/\u0002QQ,7\u000f\u001e*fY\u0006$\u0018N^3PM\u001a\u001cX\r^!tg&<g.\\3oi\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007\t-\u0013\r\u0003\u0004\u0003T\u0001!\t\u0001X\u0001)i\u0016\u001cHOU3mCRLg/Z(gMN,G/Q:tS\u001etW.\u001a8u\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004\u0005#\n\u0007B\u0002B-\u0001\u0011\u0005A,\u0001\u001duKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,2\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007\t]\u0013\r\u0003\u0004\u0003`\u0001!\t\u0001X\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8We9{gnQ8naJ,7o]3eQ\r\u0011i&\u0019\u0005\u0007\u0005K\u0002A\u0011\u0001/\u0002kQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM]+q\u0007>tg/\u001a:tS>tg\u000b\r+p-F\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0004\u0005G\n\u0007B\u0002B6\u0001\u0011\u0005A,A\u001buKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014X\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,3\u0007>l\u0007O]3tg\u0016$\u0007f\u0001B5C\"1!\u0011\u000f\u0001\u0005\u0002q\u000bq\u0005^3ti\u000e{g\u000e\u001e:pYJ+7m\u001c:eg:{G/\u00117m_^,GM\u0012:p[\u000ec\u0017.\u001a8ug\":!qN1\u0003\u0014\tU4E\u0001B<!\rI#\u0011P\u0005\u0004\u0005wR\"AF%om\u0006d\u0017\u000e\u001a*fG>\u0014H-\u0012=dKB$\u0018n\u001c8\t\r\t}\u0004\u0001\"\u0001]\u0003}!Xm\u001d;D_:$(o\u001c7SK\u000e|'\u000fZ:O_R\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004\u0005{\n\u0007B\u0002BC\u0001\u0011\u0005A,\u0001\u001euKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014Hi\\<o\u0007>tg/\u001a:tS>tg+\r+p-BruN\\\"p[B\u0014Xm]:fI\"\u001a!1Q1\t\r\t-\u0005\u0001\"\u0001]\u0003]\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WcQ{g\u000bM\"p[B\u0014Xm]:fI\"\u001a!\u0011R1\t\r\tE\u0005\u0001\"\u0001]\u0003a\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gNV\u0019U_Z\u0013dj\u001c8D_6\u0004(/Z:tK\u0012D3Aa$b\u0011\u0019\u00119\n\u0001C\u00019\u0006)D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s+B\u001cuN\u001c<feNLwN\u001c,2)>4&gQ8naJ,7o]3eQ\r\u0011)*\u0019\u0005\u0007\u0005;\u0003A\u0011\u0001/\u0002uQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0016GT8o\u0007>l\u0007O]3tg\u0016$\u0007f\u0001BNC\"1!1\u0015\u0001\u0005\u0002q\u000bq\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u0013Dk\u001c,2\u0007>l\u0007O]3tg\u0016$\u0007f\u0001BQC\"1!\u0011\u0016\u0001\u0005\u0002q\u000bA\u0007^3ti\u0012{wO\\\"p]Z,'o]5p]>3GK]1og\u0006\u001cG/[8oC2\u0014VmY8sINtu\u000e\u001e)fe6LG\u000f^3eQ\u001d\u00119+\u0019B\n\u0005[\u001b#Aa,\u0011\t\tE&qW\u0007\u0003\u0005gS1A!.\u001b\u0003\u0019)'O]8sg&!!\u0011\u0018BZ\u0005\u0011*fn];qa>\u0014H/\u001a3G_JlUm]:bO\u00164uN]7bi\u0016C8-\u001a9uS>t\u0007B\u0002B_\u0001\u0011\u0005A,A\u0019uKN$Hi\\<o\u0007>tg/\u001a:tS>twJZ%eK6\u0004x\u000e^3oiJ+7m\u001c:eg:{G\u000fU3s[&$H/\u001a3)\u000f\tm\u0016Ma\u0005\u0003.\"1!1\u0019\u0001\u0005\u0002q\u000b!\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u0013Dk\u001c,1\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007\t\u0005\u0017\r\u0003\u0004\u0003J\u0002!\t\u0001X\u00018i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u00034i\\7qe\u0016\u001c8/\u001a3)\u0007\t\u001d\u0017\r\u0003\u0004\u0003P\u0002!\t\u0001X\u00013i\u0016\u001cHOT8o\u0013:\u001c'/Z1tS:<wJ\u001a4tKR\u0014VmY8sI\n\u000bGo\u00195ICNlU\r\u001e:jGNdunZ4fI\"\u001a!QZ1\t\r\tU\u0007\u0001\"\u0001]\u0003-\"Xm\u001d;D_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007f\u0002BjC\nM!Q\u000f\u0005\u0007\u00057\u0004A\u0011\u0001/\u0002WQ,7\u000f\u001e.Ti\u0012\u001cu.\u001c9sKN\u001cX\rZ,ji\",f.\u0019<bS2\f'\r\\3J\u0005B3VM]:j_:DsA!7b\u0005'\u0011yn\t\u0002\u0003bB!!\u0011\u0017Br\u0013\u0011\u0011)Oa-\u0003GUs7/\u001e9q_J$X\rZ\"p[B\u0014Xm]:j_:$\u0016\u0010]3Fq\u000e,\u0007\u000f^5p]\"1!\u0011\u001e\u0001\u0005\u0002q\u000bQ\u0006^3tiVs7m\\7qe\u0016\u001c8/\u001a3CCR\u001c\u0007nV5uQ>,HOU3d_J$7OT8u\u00032dwn^3eQ\u001d\u00119/\u0019B\n\u0005kBaAa<\u0001\t\u0003a\u0016!\f;fgR\u0014VmY8naJ,7o]3e\u0005\u0006$8\r[,ji\"|W\u000f\u001e*fG>\u0014Hm\u001d(pi\u0006cGn\\<fI\":!Q^1\u0003\u0014\tU\u0004B\u0002B{\u0001\u0011\u0005A,\u0001\u0016uKN$\u0018J\u001c<bY&$G+[7fgR\fW\u000e]#yG\u0016\u0004H/[8o\u0011\u0006\u001c()\u0019;dQ&sG-\u001a=)\u0007\tM\u0018\r\u0003\u0004\u0003|\u0002!\t\u0001X\u0001(i\u0016\u001cH/\u00138wC2LGMU3d_J$W\t_2faRLwN\u001c%bg\n\u000bGo\u00195J]\u0012,\u0007\u0010K\u0002\u0003z\u0006Daa!\u0001\u0001\t\u0003a\u0016A\f;fgR\u0014\u0015\r^2i/&$\b.\u00138wC2LGMU3d_J$7/\u00118e\u0013:4\u0018\r\\5e)&lWm\u001d;b[BD3Aa@b\u0011\u0019\u00199\u0001\u0001C\u00019\u0006ID/Z:u\u0005\u0006$8\r[,ji\"LeN^1mS\u0012$\u0016.\\3ti\u0006l\u0007/\u00138uKJ\u001cW\r\u001d;fI\u0006sG-\u00138wC2LGMU3d_J$7\u000fK\u0002\u0004\u0006\u0005Daa!\u0004\u0001\t\u0003a\u0016!\u000b;fgR\u0014\u0015\r^2i/&$\b.\u00138uKJ\u001cW\r\u001d;fI\u0006sG-\u00138wC2LGMU3d_J$7\u000fK\u0002\u0004\f\u0005Dqaa\u0005\u0001\t\u0013\u0019)\"A\u0011uKN$()\u0019;dQ^KG\u000f[8viJ+7m\u001c:eg:{G/\u00117m_^,G\rF\u0003^\u0007/\u00199\u0003\u0003\u0005\u0004\u001a\rE\u0001\u0019AB\u000e\u0003-\u0019x.\u001e:dK\u000e{G-Z2\u0011\t\ru11E\u0007\u0003\u0007?Q1a!\t\u0005\u0003\u001diWm]:bO\u0016LAa!\n\u0004 \t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0005\t\u0007S\u0019\t\u00021\u0001\u0004\u001c\u0005YA/\u0019:hKR\u001cu\u000eZ3d\u0011\u001d\u0019i\u0003\u0001C\u0005\u0007_\tQb\u0019:fCR,'+Z2pe\u0012\u001cH\u0003CA%\u0007c\u0019)da\u0010\t\u000f\rM21\u0006a\u0001k\u0006QQ.Y4jGZ\u000bG.^3\t\u0015\r]21\u0006I\u0001\u0002\u0004\u0019I$A\u0005uS6,7\u000f^1naB\u0019\u0011ba\u000f\n\u0007\ru\"B\u0001\u0003M_:<\u0007bBB!\u0007W\u0001\rA_\u0001\u0006G>$Wm\u0019\u0005\b\u0007\u000b\u0002A\u0011BB$\u0003\u0001\u001a'/Z1uK:{g.\u00138de\u0016\f7/\u001b8h\u001f\u001a47/\u001a;SK\u000e|'\u000fZ:\u0015\u0011\u0005%3\u0011JB&\u0007\u001bBqaa\r\u0004D\u0001\u0007Q\u000f\u0003\u0006\u00048\r\r\u0003\u0013!a\u0001\u0007sA\u0011b!\u0011\u0004DA\u0005\t\u0019\u0001>\t\u000f\rE\u0003\u0001\"\u0003\u0004T\u000592M]3bi\u0016$vo\u001c\"bi\u000eDW\r\u001a*fG>\u0014Hm\u001d\u000b\t\u0003\u0013\u001a)fa\u0016\u0004Z!911GB(\u0001\u0004)\b\u0002CB\u001c\u0007\u001f\u0002\ra!\u000f\t\u000f\r\u00053q\na\u0001u\"91Q\f\u0001\u0005\u0002\r}\u0013\u0001D2iK\u000e\\wJ\u001a4tKR\u001cH#B/\u0004b\r\r\u0004\u0002CA$\u00077\u0002\r!!\u0013\t\u0011\r\u001541\fa\u0001\u0007s\t!BY1tK>3gm]3u\u0011\u001d\u0019I\u0007\u0001C\u0005\u0007W\nAE]3d_J$7oV5uQ:{gnU3rk\u0016tG/[1m\u0013:tWM](gMN,Go\u001d\u000b\t\u0003\u0013\u001aiga\u001c\u0004r!911GB4\u0001\u0004)\bbBB!\u0007O\u0002\rA\u001f\u0005\t\u0007g\u001a9\u00071\u0001\u0002\u001c\u0006Qa.^7SK\u000e|'\u000fZ:\t\u000f\r]\u0004\u0001\"\u0003\u0004z\u0005a\"/Z2pe\u0012\u001cx+\u001b;i\u0013:4\u0018\r\\5e\u0013:tWM]'bO&\u001cG\u0003CA%\u0007w\u001ayha!\t\u000f\ru4Q\u000fa\u0001k\u0006y!-\u0019;dQ6\u000bw-[2WC2,X\rC\u0004\u0004\u0002\u000eU\u0004\u0019A;\u0002!I,7m\u001c:e\u001b\u0006<\u0017n\u0019,bYV,\u0007bBB!\u0007k\u0002\rA\u001f\u0005\b\u0007\u000f\u0003A\u0011ABE\u0003]i\u0017-\u001f2f\u0007\",7m\u001b\"bg\u0016$\u0016.\\3ti\u0006l\u0007\u000fF\u0003^\u0007\u0017\u001bi\t\u0003\u0005\u0003\u0014\r\u0015\u0005\u0019AB\u001d\u0011!\u0019yi!\"A\u0002\rE\u0015!\u00022bi\u000eD\u0007cA>\u0004\u0014&\u00191Q\u0013?\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\b\u00073\u0003A\u0011ABN\u0003U1\u0018\r\\5eCR,Gj\\4BaB,g\u000e\u001a+j[\u0016$r!XBO\u0007C\u001b)\u000b\u0003\u0005\u0004 \u000e]\u0005\u0019AB\u001d\u0003U)\u0007\u0010]3di\u0016$Gj\\4BaB,g\u000e\u001a+j[\u0016D\u0001ba)\u0004\u0018\u0002\u00071\u0011H\u0001\u0016Kb\u0004Xm\u0019;fI\n\u000b7/\u001a+j[\u0016\u001cH/Y7q\u0011!\u0019yia&A\u0002\rE\u0005bBBU\u0001\u0011\u000511V\u0001\u001cm\u0016\u0014\u0018NZ=SK\u000e|'\u000fZ\"p]Z,'o]5p]N#\u0018\r^:\u0015\u0013u\u001bika.\u0004<\u000eu\u0006\u0002CBX\u0007O\u0003\ra!-\u0002\u000bM$\u0018\r^:\u0011\u0007m\u001c\u0019,C\u0002\u00046r\u0014QCU3d_J$7i\u001c8wKJ\u001c\u0018n\u001c8Ti\u0006$8\u000f\u0003\u0005\u0004:\u000e\u001d\u0006\u0019AAN\u0003MqW/\\\"p]Z,'\u000f^3e%\u0016\u001cwN\u001d3t\u0011!\t9ea*A\u0002\u0005%\u0003\u0002CB`\u0007O\u0003\ra!1\u0002\u0015\r|W\u000e\u001d:fgN,G\rE\u0002\n\u0007\u0007L1a!2\u000b\u0005\u001d\u0011un\u001c7fC:D\u0011b!3\u0001#\u0003%Iaa3\u0002/\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u0012TCABgU\u0011\u0019Ida4,\u0005\rE\u0007\u0003BBj\u0007;l!a!6\u000b\t\r]7\u0011\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa7\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007?\u001c)NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011ba9\u0001#\u0003%Iaa3\u0002U\r\u0014X-\u0019;f\u001d>t\u0017J\\2sK\u0006\u001c\u0018N\\4PM\u001a\u001cX\r\u001e*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%e!I1q\u001d\u0001\u0012\u0002\u0013%1\u0011^\u0001+GJ,\u0017\r^3O_:Len\u0019:fCNLgnZ(gMN,GOU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019YOK\u0002{\u0007\u001f\u0004")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final InterceptorStats interceptorStats = new InterceptorStats();
    private final Set<MetricName> metricsKeySet = (Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public InterceptorStats interceptorStats() {
        return this.interceptorStats;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testValidationOfBatchesWithNonSequentialInnerOffsets() {
        Predef$.MODULE$.refArrayOps((Object[])RecordVersion.values()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;

            public final void apply(RecordVersion version) {
                this.$outer.kafka$log$LogValidatorTest$$testMessageValidation$1(version.value);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, magic, sourceCompressionType, targetCompressionType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final byte magic$1;
            private final CompressionType sourceCompressionType$1;
            private final CompressionType targetCompressionType$1;

            public final LogValidator.ValidationAndOffsetAssignResult apply() {
                return this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.$outer.kafka$log$LogValidatorTest$$createTwoBatchedRecords(this.magic$1, 0L, this.sourceCompressionType$1), this.magic$1, this.sourceCompressionType$1, this.targetCompressionType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.magic$1 = magic$1;
                this.sourceCompressionType$1 = sourceCompressionType$1;
                this.targetCompressionType$1 = targetCompressionType$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.kafka$log$LogValidatorTest$$validateMessages(this.kafka$log$LogValidatorTest$$createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, batchMagic, recordMagic, compressionType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final byte batchMagic$1;
            private final byte recordMagic$1;
            private final CompressionType compressionType$1;

            public final Nothing$ apply() {
                this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.$outer.kafka$log$LogValidatorTest$$recordsWithInvalidInnerMagic(this.batchMagic$1, this.recordMagic$1, this.compressionType$1), this.batchMagic$1, this.compressionType$1, this.compressionType$1);
                return Assertions$.MODULE$.fail("InvalidRecordException should have been thrown", new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchMagic$1 = batchMagic$1;
                this.recordMagic$1 = recordMagic$1;
                this.compressionType$1 = compressionType$1;
            }
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$2) {
                return x$2.getMBeanName().endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()})));
            }
        }), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()}))) > 0L ? 1 : 0) != 0);
    }

    public LogValidator.ValidationAndOffsetAssignResult kafka$log$LogValidatorTest$$validateMessages(MemoryRecords records2, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), 0L, CompressionCodec$.MODULE$.getCompressionCodec(sourceCompressionType.name), CompressionCodec$.MODULE$.getCompressionCodec(targetCompressionType.name), false, magic, TimestampType.CREATE_TIME, 1000L, (Iterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InterceptorUtils.MockRecordInterceptor[]{new InterceptorUtils.MockRecordInterceptor()})), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_3_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$1;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$1, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be 0"})).s((Seq)Nil$.MODULE$), (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, false);
    }

    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$13 = 0;
        CompressionType x$14 = CompressionType.GZIP;
        long x$15 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$13, x$15, x$14);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$2;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$2, -1L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$2 = now$2;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records2, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long now$3;

            public final void apply(MutableRecordBatch batch) {
                this.$outer.validateLogAppendTime(this.now$3, 1234L, (RecordBatch)batch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$3 = now$3;
            }
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)})), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions$.MODULE$.intercept((Function0)new Serializable(this, lastOffsetDelta, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final int lastOffsetDelta$1;
            private final int count$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(this.lastOffsetDelta$1, this.count$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastOffsetDelta$1 = lastOffsetDelta$1;
                this.count$1 = count$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
    }

    public void kafka$log$LogValidatorTest$$validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records2 = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records2.buffer().putInt(57, count);
        records2.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    private void checkNonCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), partitionLeaderEpoch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, isTransactional2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$1;
                private final long producerId$1;
                private final short producerEpoch$1;
                private final int baseSequence$1;
                private final boolean isTransactional$1;
                private final int partitionLeaderEpoch$1;
                public final IntRef i$1;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$1.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$4) {
                            return x$4.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$1, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$1, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$1, (long)batch.baseSequence());
                    Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
                    Assert.assertEquals((long)this.partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkNonCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$1.apply(this.$outer.i$1.elem)), (long)record.timestamp());
                            ++this.$outer.i$1.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$1 = timestampSeq$1;
                    this.producerId$1 = producerId$1;
                    this.producerEpoch$1 = producerEpoch$1;
                    this.baseSequence$1 = baseSequence$1;
                    this.isTransactional$1 = isTransactional$1;
                    this.partitionLeaderEpoch$1 = partitionLeaderEpoch$1;
                    this.i$1 = i$1;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be 1"})).s((Seq)Nil$.MODULE$), (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records2, false);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    private void checkRecompression(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), partitionLeaderEpoch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
            MemoryRecords validatedRecords = validatingResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$2;
                private final long producerId$2;
                private final short producerEpoch$2;
                private final int baseSequence$2;
                private final int partitionLeaderEpoch$2;
                public final IntRef i$2;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$2.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$6) {
                            return x$6.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$2, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$2, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$2, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkRecompression$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$2.apply(this.$outer.i$2.elem)), (long)record.timestamp());
                            ++this.$outer.i$2.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$2 = timestampSeq$2;
                    this.producerId$2 = producerId$2;
                    this.producerEpoch$2 = producerEpoch$2;
                    this.baseSequence$2 = baseSequence$2;
                    this.partitionLeaderEpoch$2 = partitionLeaderEpoch$2;
                    this.i$2 = i$2;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatingResults.maxTimestamp());
            Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
            Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records2, true);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        MemoryRecords records2;
        byte x$16 = 0;
        CompressionType x$17 = CompressionType.GZIP;
        long x$18 = this.createRecords$default$2();
        MemoryRecords x$19 = records2 = this.createRecords(x$16, x$18, x$17);
        TopicPartition x$20 = this.topicPartition();
        LongRef x$21 = new LongRef(0L);
        Time x$22 = this.time();
        long x$23 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$24 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$25 = DefaultCompressionCodec$.MODULE$;
        byte x$26 = toMagic;
        boolean x$27 = false;
        TimestampType x$28 = TimestampType.CREATE_TIME;
        long x$29 = 1000L;
        Buffer x$30 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
        InterceptorStats x$31 = this.interceptorStats();
        int x$32 = -1;
        AppendOrigin.Client$ x$33 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$34 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$35 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$19, x$20, x$21, x$22, x$23, (CompressionCodec)x$24, (CompressionCodec)x$25, x$27, x$26, x$28, x$29, (Iterable)x$30, x$31, x$32, (AppendOrigin)x$33, x$34, x$35);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
                Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-1L)})), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        MemoryRecords records2;
        long timestamp = System.currentTimeMillis();
        byte x$36 = 1;
        CompressionType x$37 = CompressionType.GZIP;
        long x$38 = timestamp;
        MemoryRecords x$39 = records2 = this.createRecords(x$36, x$38, x$37);
        TopicPartition x$40 = this.topicPartition();
        LongRef x$41 = new LongRef(0L);
        Time x$42 = this.time();
        long x$43 = timestamp;
        DefaultCompressionCodec$ x$44 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$45 = DefaultCompressionCodec$.MODULE$;
        byte x$46 = 2;
        boolean x$47 = false;
        TimestampType x$48 = TimestampType.CREATE_TIME;
        long x$49 = 1000L;
        Buffer x$50 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
        InterceptorStats x$51 = this.interceptorStats();
        int x$52 = -1;
        AppendOrigin.Client$ x$53 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$54 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$55 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$39, x$40, x$41, x$42, x$43, (CompressionCodec)x$44, (CompressionCodec)x$45, x$47, x$46, x$48, x$49, (Iterable)x$50, x$51, x$52, (AppendOrigin)x$53, x$54, x$55);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final long timestamp$1;

            public final void apply(MutableRecordBatch batch) {
                Assert.assertTrue((boolean)batch.isValid());
                this.$outer.maybeCheckBaseTimestamp(this.timestamp$1, (RecordBatch)batch);
                Assert.assertEquals((long)this.timestamp$1, (long)batch.maxTimestamp());
                Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
                Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
                Assert.assertEquals((long)-1L, (long)batch.producerId());
                Assert.assertEquals((long)-1L, (long)batch.baseSequence());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
            }
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    private void checkCompressed(byte magic) {
        Tuple5 tuple5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple52 = tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        if (tuple5 != null) {
            MemoryRecords records2;
            Tuple5 tuple53;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple54 = tuple53 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple54._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple54._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple54._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple54._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple54._5());
            MemoryRecords x$56 = records2 = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (int)partitionLeaderEpoch2, (boolean)isTransactional2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
            TopicPartition x$57 = this.topicPartition();
            LongRef x$58 = new LongRef(0L);
            Time x$59 = this.time();
            long x$60 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$61 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$62 = DefaultCompressionCodec$.MODULE$;
            byte x$63 = magic;
            boolean x$64 = false;
            TimestampType x$65 = TimestampType.CREATE_TIME;
            long x$66 = 1000L;
            Buffer x$67 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
            InterceptorStats x$68 = this.interceptorStats();
            int x$69 = partitionLeaderEpoch2;
            AppendOrigin.Client$ x$70 = AppendOrigin.Client$.MODULE$;
            ApiVersion x$71 = ApiVersion$.MODULE$.latestVersion();
            BrokerTopicStats x$72 = this.brokerTopicStats();
            LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$56, x$57, x$58, x$59, x$60, (CompressionCodec)x$61, (CompressionCodec)x$62, x$64, x$63, x$65, x$66, (Iterable)x$67, x$68, x$69, (AppendOrigin)x$70, x$71, x$72);
            MemoryRecords validatedRecords = validatedResults.validatedRecords();
            IntRef i = IntRef.create((int)0);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1)new Serializable(this, timestampSeq, producerId2, producerEpoch2, baseSequence2, partitionLeaderEpoch2, i){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                public final Seq timestampSeq$3;
                private final long producerId$3;
                private final short producerEpoch$3;
                private final int baseSequence$3;
                private final int partitionLeaderEpoch$3;
                public final IntRef i$3;

                public final void apply(MutableRecordBatch batch) {
                    Assert.assertTrue((boolean)batch.isValid());
                    Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
                    this.$outer.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)this.timestampSeq$3.apply(0)), (RecordBatch)batch);
                    Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Record x$8) {
                            return x$8.timestamp();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
                    Assert.assertEquals((long)this.producerEpoch$3, (long)batch.producerEpoch());
                    Assert.assertEquals((long)this.producerId$3, (long)batch.producerId());
                    Assert.assertEquals((long)this.baseSequence$3, (long)batch.baseSequence());
                    Assert.assertEquals((long)this.partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$checkCompressed$1 $outer;

                        public final void apply(Record record) {
                            Assert.assertTrue((boolean)record.isValid());
                            Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)this.$outer.timestampSeq$3.apply(this.$outer.i$3.elem)), (long)record.timestamp());
                            ++this.$outer.i$3.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.timestampSeq$3 = timestampSeq$3;
                    this.producerId$3 = producerId$3;
                    this.producerEpoch$3 = producerEpoch$3;
                    this.baseSequence$3 = baseSequence$3;
                    this.partitionLeaderEpoch$3 = partitionLeaderEpoch$3;
                    this.i$3 = i$3;
                }
            });
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + 1L))})), (long)(now + 1L), (long)validatedResults.maxTimestamp());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offset of max timestamp should be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1))})), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
            Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
            this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records2, true);
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV1() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$73 = records2 = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        TopicPartition x$74 = this.topicPartition();
        LongRef x$75 = new LongRef(0L);
        Time x$76 = this.time();
        long x$77 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$78 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$79 = DefaultCompressionCodec$.MODULE$;
        byte x$80 = 1;
        boolean x$81 = false;
        TimestampType x$82 = TimestampType.CREATE_TIME;
        long x$83 = 1000L;
        Buffer x$84 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
        InterceptorStats x$85 = this.interceptorStats();
        int x$86 = -1;
        AppendOrigin.Client$ x$87 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$88 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$89 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$73, x$74, x$75, x$76, x$77, (CompressionCodec)x$78, (CompressionCodec)x$79, x$81, x$80, x$82, x$83, (Iterable)x$84, x$85, x$86, (AppendOrigin)x$87, x$88, x$89);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV2() {
        MemoryRecords records2;
        long now = System.currentTimeMillis();
        MemoryRecords x$90 = records2 = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        TopicPartition x$91 = this.topicPartition();
        LongRef x$92 = new LongRef(0L);
        Time x$93 = this.time();
        long x$94 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$95 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$96 = DefaultCompressionCodec$.MODULE$;
        byte x$97 = 1;
        boolean x$98 = false;
        TimestampType x$99 = TimestampType.CREATE_TIME;
        long x$100 = 1000L;
        Buffer x$101 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
        InterceptorStats x$102 = this.interceptorStats();
        int x$103 = -1;
        AppendOrigin.Client$ x$104 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$105 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$106 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$90, x$91, x$92, x$93, x$94, (CompressionCodec)x$95, (CompressionCodec)x$96, x$98, x$97, x$99, x$100, (Iterable)x$101, x$102, x$103, (AppendOrigin)x$104, x$105, x$106);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$107 = 0;
        CompressionType x$108 = CompressionType.NONE;
        long x$109 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$107, x$109, x$108);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords x$110 = records2;
        TopicPartition x$111 = this.topicPartition();
        LongRef x$112 = new LongRef((long)offset);
        Time x$113 = this.time();
        long x$114 = System.currentTimeMillis();
        NoCompressionCodec$ x$115 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$116 = NoCompressionCodec$.MODULE$;
        byte x$117 = 0;
        boolean x$118 = false;
        TimestampType x$119 = TimestampType.CREATE_TIME;
        long x$120 = 1000L;
        Buffer x$121 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala();
        InterceptorStats x$122 = this.interceptorStats();
        int x$123 = -1;
        AppendOrigin.Client$ x$124 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$125 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$126 = this.brokerTopicStats();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$110, x$111, x$112, x$113, x$114, (CompressionCodec)x$115, (CompressionCodec)x$116, x$118, x$117, x$119, x$120, (Iterable)x$121, x$122, x$123, (AppendOrigin)x$124, x$125, x$126).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$127 = 0;
        CompressionType x$128 = CompressionType.GZIP;
        long x$129 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$127, x$129, x$128);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$130 = 0;
        CompressionType x$131 = CompressionType.NONE;
        long x$132 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$130, x$132, x$131);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$133 = 0;
        CompressionType x$134 = CompressionType.NONE;
        long x$135 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$133, x$135, x$134);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$136 = 0;
        CompressionType x$137 = CompressionType.GZIP;
        long x$138 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$136, x$138, x$137);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$139 = 0;
        CompressionType x$140 = CompressionType.GZIP;
        long x$141 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$139, x$141, x$140);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records2, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records2 = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator.ValidationAndOffsetAssignResult result = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        List batches = TestUtils.toList((java.lang.Iterable)result.validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
        Assert.assertFalse((boolean)batch.isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$142 = 1;
        CompressionType x$143 = CompressionType.NONE;
        long x$144 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$142, x$144, x$143);
        this.checkOffsets(records2, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$145 = 1;
        CompressionType x$146 = CompressionType.GZIP;
        long x$147 = this.createRecords$default$2();
        MemoryRecords records2 = this.createRecords(x$145, x$147, x$146);
        int offset = 1234567;
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records2 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records2, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records2 = this.createNonIncreasingOffsetRecords((byte)2, this.createNonIncreasingOffsetRecords$default$2(), this.createNonIncreasingOffsetRecords$default$3());
        ((MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.batches()).asScala()).head()).setLastOffset(2L);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final MemoryRecords records$1;

            public final LogValidator.ValidationAndOffsetAssignResult apply() {
                return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(this.records$1, this.$outer.topicPartition(), new LongRef(0L), this.$outer.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.<T>emptyList()).asScala(), this.$outer.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.$outer.brokerTopicStats());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.records$1 = records$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1298));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName x$9) {
                return x$9.getMBeanName().endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()})));
            }
        }), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()}))) > 0L ? 1 : 0) != 0);
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test(expected=UnsupportedCompressionTypeException.class)
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_0_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test(expected=InvalidRecordException.class)
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records2 = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, records2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final MemoryRecords records$2;

            public final LogValidator.ValidationAndOffsetAssignResult apply() {
                MemoryRecords x$148 = this.records$2;
                TopicPartition x$149 = this.$outer.topicPartition();
                LongRef x$150 = new LongRef(0L);
                Time x$151 = this.$outer.time();
                long x$152 = System.currentTimeMillis();
                DefaultCompressionCodec$ x$153 = DefaultCompressionCodec$.MODULE$;
                DefaultCompressionCodec$ x$154 = DefaultCompressionCodec$.MODULE$;
                byte x$155 = 1;
                boolean x$156 = false;
                TimestampType x$157 = TimestampType.CREATE_TIME;
                long x$158 = 1000L;
                int x$159 = -1;
                AppendOrigin.Client$ x$160 = AppendOrigin.Client$.MODULE$;
                ApiVersion x$161 = ApiVersion$.MODULE$.latestVersion();
                BrokerTopicStats x$162 = this.$outer.brokerTopicStats();
                Buffer x$163 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.<T>emptyList()).asScala();
                InterceptorStats x$164 = this.$outer.interceptorStats();
                return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(x$148, x$149, x$150, x$151, x$152, (CompressionCodec)x$153, (CompressionCodec)x$154, x$156, x$155, x$157, x$158, (Iterable)x$163, x$164, x$159, (AppendOrigin)x$160, x$161, x$162);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.records$2 = records$2;
            }
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1365));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)e.recordErrors().size(), (long)3L);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;

            public final LogValidator.ValidationAndOffsetAssignResult apply() {
                return this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.$outer.kafka$log$LogValidatorTest$$recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1393));
        e.recordErrors().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ProduceResponse.RecordError e) {
                Predef$.MODULE$.println((Object)new StringBuilder().append(e.batchIndex).append((Object)" ").append((Object)e.message).toString());
            }
        });
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)e.recordErrors().size(), (long)20L);
        e.recordErrors().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ProduceResponse.RecordError x$10) {
                Assert.assertNotNull((Object)x$10);
            }
        });
    }

    @Test
    public void testBatchWithInvalidRecordsAndInvalidTimestamp() {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(int id) {
                return LegacyRecord.create((byte)0, (long)0L, null, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)1200L, null, (byte[])"timestamp".getBytes()));
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final IntRef offset$1;

            public final void apply(LegacyRecord record) {
                this.offset$1.elem += 30;
                this.builder$1.appendUncheckedWithOffset((long)this.offset$1.elem, record);
            }
            {
                this.builder$1 = builder$1;
                this.offset$1 = offset$1;
            }
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, invalidOffsetTimestampRecords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final MemoryRecords invalidOffsetTimestampRecords$1;

            public final LogValidator.ValidationAndOffsetAssignResult apply() {
                return this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.invalidOffsetTimestampRecords$1, (byte)0, CompressionType.GZIP, CompressionType.GZIP);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.invalidOffsetTimestampRecords$1 = invalidOffsetTimestampRecords$1;
            }
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1427));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)6L, (long)e.recordErrors().size());
    }

    @Test
    public void testBatchWithInvalidTimestampInterceptedAndInvalidRecords() {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(int id) {
                return LegacyRecord.create((byte)0, (long)0L, null, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)1200L, null, (byte[])"timestamp".getBytes()));
        ++offset.elem;
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)0L, null, (byte[])"reject me".getBytes()));
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$2;
            private final IntRef offset$2;

            public final void apply(LegacyRecord record) {
                this.offset$2.elem += 30;
                this.builder$2.appendUncheckedWithOffset((long)this.offset$2.elem, record);
            }
            {
                this.builder$2 = builder$2;
                this.offset$2 = offset$2;
            }
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, invalidOffsetTimestampRecords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final MemoryRecords invalidOffsetTimestampRecords$2;

            public final LogValidator.ValidationAndOffsetAssignResult apply() {
                return this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.invalidOffsetTimestampRecords$2, (byte)0, CompressionType.GZIP, CompressionType.GZIP);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.invalidOffsetTimestampRecords$2 = invalidOffsetTimestampRecords$2;
            }
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1462));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)7L, (long)e.recordErrors().size());
        Assert.assertTrue((boolean)((ProduceResponse.RecordError)e.recordErrors().apply((int)1)).message.endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rejected by the record interceptor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{InterceptorUtils.MockRecordInterceptor.class.getName()}))));
    }

    @Test
    public void testBatchWithInterceptedAndInvalidRecords() {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(int id) {
                return LegacyRecord.create((byte)0, (long)0L, null, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)0L, null, (byte[])"reject me".getBytes()));
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$3;
            private final IntRef offset$3;

            public final void apply(LegacyRecord record) {
                this.offset$3.elem += 30;
                this.builder$3.appendUncheckedWithOffset((long)this.offset$3.elem, record);
            }
            {
                this.builder$3 = builder$3;
                this.offset$3 = offset$3;
            }
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, invalidOffsetTimestampRecords){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogValidatorTest $outer;
            private final MemoryRecords invalidOffsetTimestampRecords$3;

            public final LogValidator.ValidationAndOffsetAssignResult apply() {
                return this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.invalidOffsetTimestampRecords$3, (byte)0, CompressionType.GZIP, CompressionType.GZIP);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.invalidOffsetTimestampRecords$3 = invalidOffsetTimestampRecords$3;
            }
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1495));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assert.assertEquals((Object)"One or more records have been rejected", (Object)e.invalidException().getMessage());
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)6L, (long)e.recordErrors().size());
        Assert.assertTrue((boolean)((ProduceResponse.RecordError)e.recordErrors().head()).message.endsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rejected by the record interceptor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{InterceptorUtils.MockRecordInterceptor.class.getName()}))));
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40));
        if (tuple5 != null) {
            Tuple5 tuple52;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
            int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
            int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple53 = tuple52 = new Tuple5((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)baseSequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional), (Object)BoxesRunTime.boxToInteger((int)partitionLeaderEpoch));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple53._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple53._2());
            int baseSequence2 = BoxesRunTime.unboxToInt((Object)tuple53._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple53._4());
            int partitionLeaderEpoch2 = BoxesRunTime.unboxToInt((Object)tuple53._5());
            ByteBuffer buffer = ByteBuffer.allocate(61);
            DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)producerId2, (short)producerEpoch2, (int)baseSequence2, (long)0L, (long)5L, (int)partitionLeaderEpoch2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)isTransactional2, (boolean)false);
            buffer.flip();
            MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records2, this.topicPartition(), new LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala(), this.interceptorStats(), -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    public MemoryRecords kafka$log$LogValidatorTest$$createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records2, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).nonEmpty());
        scala.runtime.LongRef offset = scala.runtime.LongRef.create((long)baseOffset);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final scala.runtime.LongRef offset$4;

            public final void apply(Record entry) {
                Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)this.offset$4.elem, (long)entry.offset());
                ++this.offset$4.elem;
            }
            {
                this.offset$4 = offset$4;
            }
        });
    }

    private MemoryRecords recordsWithNonSequentialInnerOffsets(byte magicValue, CompressionType codec, int numRecords) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(int id) {
                return new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$4;

            public final void apply(SimpleRecord record) {
                this.builder$4.appendUncheckedWithOffset(0L, record);
            }
            {
                this.builder$4 = builder$4;
            }
        });
        return builder.build();
    }

    public MemoryRecords kafka$log$LogValidatorTest$$recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1)new Serializable(this, recordMagicValue){
            public static final long serialVersionUID = 0L;
            private final byte recordMagicValue$1;

            public final LegacyRecord apply(int id) {
                return LegacyRecord.create((byte)this.recordMagicValue$1, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
            {
                this.recordMagicValue$1 = recordMagicValue$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$12) {
                return x$12.sizeInBytes();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)1234567);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$5;
            private final IntRef offset$5;

            public final void apply(LegacyRecord record) {
                this.builder$5.appendUncheckedWithOffset((long)this.offset$5.elem, record);
                ++this.offset$5.elem;
            }
            {
                this.builder$5 = builder$5;
                this.offset$5 = offset$5;
            }
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        RecordBatch recordBatch = batch;
        if (recordBatch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)recordBatch;
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected base timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expected, (long)defaultRecordBatch.firstTimestamp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected max timestamp of batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batch})), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this, expectedLogAppendTime){
            public static final long serialVersionUID = 0L;
            private final long expectedLogAppendTime$1;

            public final void apply(Record record) {
                Assert.assertTrue((boolean)record.isValid());
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected timestamp of record ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})), (long)this.expectedLogAppendTime$1, (long)record.timestamp());
            }
            {
                this.expectedLogAppendTime$1 = expectedLogAppendTime$1;
            }
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records2, boolean compressed) {
        Assert.assertNotNull((String)"Records processing info is null", (Object)stats);
        Assert.assertEquals((long)numConvertedRecords, (long)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion time not recorded ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats})), (stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Conversion time not valid ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stats})), (stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0);
        }
        int originalSize = records2.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Temp bytes too small, orig=", " actual=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)originalSize), BoxesRunTime.boxToLong((long)tempBytes)})), (tempBytes > (long)originalSize ? 1 : 0) != 0);
        } else if (numConvertedRecords > 0 || compressed) {
            Assert.assertTrue((String)"Temp bytes not updated", (tempBytes > 0L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((long)0L, (long)tempBytes);
        }
    }

    public final void kafka$log$LogValidatorTest$$testMessageValidation$1(byte magicValue) {
        int numRecords = 20;
        MemoryRecords invalidRecords = this.recordsWithNonSequentialInnerOffsets(magicValue, CompressionType.GZIP, numRecords);
        if (magicValue >= 2) {
            Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, magicValue, invalidRecords){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogValidatorTest $outer;
                private final byte magicValue$1;
                private final MemoryRecords invalidRecords$1;

                public final LogValidator.ValidationAndOffsetAssignResult apply() {
                    return this.$outer.kafka$log$LogValidatorTest$$validateMessages(this.invalidRecords$1, this.magicValue$1, CompressionType.GZIP, CompressionType.GZIP);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.magicValue$1 = magicValue$1;
                    this.invalidRecords$1 = invalidRecords$1;
                }
            }, ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        } else {
            LogValidator.ValidationAndOffsetAssignResult result = this.kafka$log$LogValidatorTest$$validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP);
            Assert.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords), (Object)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(result.validatedRecords().records()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(Record x$1) {
                    return x$1.offset();
                }
            }, Iterable$.MODULE$.canBuildFrom()));
        }
    }
}

