/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.NavigableSet;
import java.util.UUID;
import kafka.api.ApiVersion;
import kafka.log.AppendOrigin;
import kafka.log.HotsetRetention$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.RetentionType;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.TierPartitionState;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class MergedLogTest$ {
    public static final MergedLogTest$ MODULE$;

    static {
        new MergedLogTest$();
    }

    public MemoryRecords createRecords(int segmentIdx, int messageIdx, long timestamp) {
        String segmentStr = new StringOps(Predef$.MODULE$.augmentString("%06d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)segmentIdx)}));
        String messageStr = new StringOps(Predef$.MODULE$.augmentString("%06d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)messageIdx)}));
        byte[] x$530 = new StringBuilder().append((Object)"test").append((Object)segmentStr).append((Object)messageStr).toString().getBytes();
        long x$531 = timestamp;
        byte[] x$532 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$533 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$534 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$530, x$532, x$533, x$531, x$534);
    }

    public int createRecords$default$1() {
        return 0;
    }

    public int createRecords$default$2() {
        return 0;
    }

    public long createRecords$default$3() {
        return -1L;
    }

    public MergedLog createLogWithOverlap(int numTieredSegments, int numLocalSegments, int numOverlap, TierLogComponents tierLogComponents, File dir, LogConfig logConfig, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, TopicIdPartition topicIdPartition, long logStartOffset, long recoveryPoint, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, Function0<Object> segmentMaxTimestampCbk) {
        long x$535 = 1L;
        boolean x$536 = true;
        int x$537 = Predef$.MODULE$.Integer2int(logConfig.segmentSize());
        long x$538 = Predef$.MODULE$.Long2long(logConfig.segmentMs());
        long x$539 = 1L;
        long x$540 = LogTest$.MODULE$.createLogConfig$default$3();
        long x$541 = LogTest$.MODULE$.createLogConfig$default$5();
        String x$542 = LogTest$.MODULE$.createLogConfig$default$6();
        int x$543 = LogTest$.MODULE$.createLogConfig$default$7();
        int x$544 = LogTest$.MODULE$.createLogConfig$default$8();
        int x$545 = LogTest$.MODULE$.createLogConfig$default$9();
        String x$546 = LogTest$.MODULE$.createLogConfig$default$10();
        long x$547 = LogTest$.MODULE$.createLogConfig$default$11();
        long x$548 = LogTest$.MODULE$.createLogConfig$default$14();
        int x$549 = LogTest$.MODULE$.createLogConfig$default$15();
        long x$550 = LogTest$.MODULE$.createLogConfig$default$16();
        LogConfig tempConfig = LogTest$.MODULE$.createLogConfig(x$538, x$537, x$540, x$535, x$541, x$542, x$543, x$544, x$545, x$546, x$547, x$536, x$539, x$548, x$549, x$550);
        ObjectRef log2 = ObjectRef.create((Object)this.createMergedLog(tierLogComponents, dir, tempConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs));
        ObjectRef tierPartitionState2 = ObjectRef.create((Object)((MergedLog)log2.elem).tierPartitionState());
        ((TierPartitionState)tierPartitionState2.elem).setTopicId(topicIdPartition.topicId());
        ((TierPartitionState)tierPartitionState2.elem).onCatchUpComplete();
        int epoch = 0;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTieredSegments + numLocalSegments + numOverlap - 1).foreach$mVc$sp((Function1)new Serializable(segmentMaxTimestampCbk, log2){
            public static final long serialVersionUID = 0L;
            private final Function0 segmentMaxTimestampCbk$3;
            private final ObjectRef log$13;

            public final void apply(int segment) {
                this.apply$mcVI$sp(segment);
            }

            public void apply$mcVI$sp(int segment) {
                int currentNumSegments = ((MergedLog)this.log$13.elem).localLogSegments().size();
                long timestamp = this.segmentMaxTimestampCbk$3.apply$mcJ$sp();
                int message = 0;
                while (((MergedLog)this.log$13.elem).localLogSegments().size() == currentNumSegments) {
                    MergedLog qual$1 = (MergedLog)this.log$13.elem;
                    MemoryRecords x$551 = MergedLogTest$.MODULE$.createRecords(segment, message, timestamp);
                    int x$552 = 0;
                    AppendOrigin x$553 = qual$1.appendAsLeader$default$3();
                    ApiVersion x$554 = qual$1.appendAsLeader$default$4();
                    qual$1.appendAsLeader(x$551, x$552, x$553, x$554);
                    ++message;
                }
            }
            {
                this.segmentMaxTimestampCbk$3 = segmentMaxTimestampCbk$3;
                this.log$13 = log$13;
            }
        });
        ((MergedLog)log2.elem).updateHighWatermark(((MergedLog)log2.elem).logEndOffset());
        Assert.assertEquals((long)(numTieredSegments + numLocalSegments + numOverlap), (long)((MergedLog)log2.elem).localLogSegments().size());
        ((TierPartitionState)tierPartitionState2.elem).append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, epoch, UUID.randomUUID(), 0), 0L);
        Iterable segmentsToTier = (Iterable)((MergedLog)log2.elem).localLogSegments().take(numTieredSegments + numOverlap);
        segmentsToTier.foreach((Function1)new Serializable(topicIdPartition, tierPartitionState2, epoch){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition topicIdPartition$1;
            private final ObjectRef tierPartitionState$7;
            private final int epoch$3;

            public final void apply(LogSegment segment) {
                TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata((TierPartitionState)this.tierPartitionState$7.elem, this.topicIdPartition$1, this.epoch$3, UUID.randomUUID(), segment.baseOffset(), segment.readNextOffset() - 1L, segment.largestTimestamp(), segment.lastModified(), segment.size(), false, true, TierTestUtils$.MODULE$.uploadWithMetadata$default$12());
                ((TierPartitionState)this.tierPartitionState$7.elem).flush();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.tierPartitionState$7 = tierPartitionState$7;
                this.epoch$3 = epoch$3;
            }
        });
        Iterable localSegmentsToDelete = (Iterable)segmentsToTier.take(numTieredSegments);
        Log qual$2 = ((MergedLog)log2.elem).localLog();
        Some x$555 = new Some((Object)BoxesRunTime.boxToLong((long)((LogSegment)localSegmentsToDelete.last()).readNextOffset()));
        int x$556 = Integer.MAX_VALUE;
        HotsetRetention$ x$557 = HotsetRetention$.MODULE$;
        Function1 x$558 = qual$2.deleteOldSegments$default$4();
        qual$2.deleteOldSegments((Option)x$555, x$556, (RetentionType)x$557, x$558);
        ((MergedLog)log2.elem).close();
        log2.elem = this.createMergedLog(tierLogComponents, dir, logConfig, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs);
        ((MergedLog)log2.elem).updateHighWatermark(((MergedLog)log2.elem).logEndOffset());
        tierPartitionState2.elem = ((MergedLog)log2.elem).tierPartitionState();
        Assert.assertEquals((long)(numLocalSegments + numOverlap), (long)((MergedLog)log2.elem).localLogSegments().size());
        Assert.assertEquals((long)(numTieredSegments + numOverlap), (long)((TierPartitionState)tierPartitionState2.elem).segmentOffsets().size());
        Tuple2 tuple2 = ((MergedLog)log2.elem).uniqueLogSegments();
        if (tuple2 != null) {
            NavigableSet tierLogSegments = (NavigableSet)tuple2._1();
            Iterable localLogSegments = (Iterable)tuple2._2();
            Assert.assertEquals((long)numTieredSegments, (long)tierLogSegments.size());
            Assert.assertEquals((long)(numLocalSegments + numOverlap), (long)localLogSegments.size());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return (MergedLog)log2.elem;
        }
        throw new MatchError((Object)tuple2);
    }

    public long createLogWithOverlap$default$11() {
        return 0L;
    }

    public long createLogWithOverlap$default$12() {
        return 0L;
    }

    public int createLogWithOverlap$default$13() {
        return 3600000;
    }

    public int createLogWithOverlap$default$14() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public Function0<Object> createLogWithOverlap$default$15() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        };
    }

    public MergedLog createMergedLog(TierLogComponents tierLogComponents, File dir, LogConfig config, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, long logStartOffset, long recoveryPoint, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs) {
        return MergedLog$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, new LogDirFailureChannel(10), tierLogComponents);
    }

    public long createMergedLog$default$7() {
        return 0L;
    }

    public long createMergedLog$default$8() {
        return 0L;
    }

    public int createMergedLog$default$9() {
        return 3600000;
    }

    public int createMergedLog$default$10() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public void kafka$log$MergedLogTest$$deleteOldLogSegments(MergedLog log2, int expectedNumDeleted) {
        int maxNumSegmentsToDeletePerRun = 1;
        IntRef numDeleted = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), expectedNumDeleted).foreach$mVc$sp((Function1)new Serializable(log2, maxNumSegmentsToDeletePerRun, numDeleted){
            public static final long serialVersionUID = 0L;
            private final MergedLog log$10;
            private final int maxNumSegmentsToDeletePerRun$1;
            private final IntRef numDeleted$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.numDeleted$1.elem += this.log$10.deleteOldSegments(this.maxNumSegmentsToDeletePerRun$1);
                Assert.assertEquals((long)i, (long)this.numDeleted$1.elem);
            }
            {
                this.log$10 = log$10;
                this.maxNumSegmentsToDeletePerRun$1 = maxNumSegmentsToDeletePerRun$1;
                this.numDeleted$1 = numDeleted$1;
            }
        });
        Assert.assertEquals((long)expectedNumDeleted, (long)numDeleted.elem);
        Assert.assertEquals((long)0L, (long)log2.deleteOldSegments());
    }

    private MergedLogTest$() {
        MODULE$ = this;
    }
}

