/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kafka.network.RequestChannel;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u000f\t\u0011\"+Z9vKN$8\t[1o]\u0016dG+Z:u\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000bQ\u0001A\u0011A\u000b\u0002#Q,7\u000f^!mi\u0016\u0014(+Z9vKN$8\u000fF\u0001\u0017!\tIq#\u0003\u0002\u0019\u0015\t!QK\\5uQ\t\u0019\"\u0004\u0005\u0002\u001cA5\tAD\u0003\u0002\u001e=\u0005)!.\u001e8ji*\tq$A\u0002pe\u001eL!!\t\u000f\u0003\tQ+7\u000f\u001e\u0005\u0006G\u0001!\t!F\u0001\u001di\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:SKF,Xm\u001d;tQ\t\u0011#\u0004C\u0003'\u0001\u0011\u0005Q#\u0001\u0012uKN$hj\u001c8BYR,'OU3rk\u0016\u001cHo\u001d(piR\u0013\u0018M\\:g_JlW\r\u001a\u0015\u0003KiAQ!\u000b\u0001\u0005\u0002)\nqA]3rk\u0016\u001cH\u000f\u0006\u0002,eA\u0011Af\f\b\u0003%5J!A\f\u0002\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011\u0001'\r\u0002\b%\u0016\fX/Z:u\u0015\tq#\u0001C\u00034Q\u0001\u0007A'A\u0002sKF\u0004\"!N\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u0011I,\u0017/^3tiNT!!\u000f\u001e\u0002\r\r|W.\\8o\u0015\t)1H\u0003\u0002==\u00051\u0011\r]1dQ\u0016L!A\u0010\u001c\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDQ\u0001\u0011\u0001\u0005\n\u0005\u000b\u0011C\\3x%\u0016\fX/Z:u\u0007>tG/\u001a=u)\t\u0011U\t\u0005\u00026\u0007&\u0011AI\u000e\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u00151u\b1\u0001H\u0003\u0019\u0011WO\u001a4feB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0004]&|'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013!BQ=uK\n+hMZ3s\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0003\u0015!x.T1q)\t\u0011F\f\u0005\u0003T-fKfBA\u0005U\u0013\t)&\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u00131!T1q\u0015\t)&\u0002\u0005\u0002T5&\u00111\f\u0017\u0002\u0007'R\u0014\u0018N\\4\t\u000bu{\u0005\u0019\u00010\u0002\r\r|gNZ5h!\tyvN\u0004\u0002a[:\u0011\u0011\r\u001c\b\u0003E.t!a\u00196\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4\u0007\u0003\u0019a$o\\8u}%\tq$\u0003\u0002==%\u0011QaO\u0005\u0003siJ!a\u000e\u001d\n\u000594\u0014aE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z9vKN$\u0018B\u00019r\u0005\u0019\u0019uN\u001c4jO*\u0011aN\u000e\u0005\u0006!\u0002!Ia\u001d\u000b\u0003%RDQ!\u0018:A\u0002U\u0004\"A\u001e?\u000f\u0005]TX\"\u0001=\u000b\u0005eD\u0014aB7fgN\fw-Z\u0005\u0003wb\f!%\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:SKF,Xm\u001d;ECR\f\u0017BA?\u007f\u0005e\tE\u000e^3sC\ndWmQ8oM&<7i\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005mD\b")
public class RequestChannelTest {
    @Test
    public void testAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{keystorePassword})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry keystoreLocation = new AlterConfigsRequest.ConfigEntry("ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{keystoreLocation})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{keystoreLocation, keystorePassword})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeyPassword = new AlterConfigsRequest.ConfigEntry(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ssl.key.password"})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{listenerKeyPassword})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeyPassword.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeystore = new AlterConfigsRequest.ConfigEntry(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ssl.keystore.location"})), "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{listenerKeystore})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeystore.name()), (Object)"/path/to/keystore")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainJaasConfig = new AlterConfigsRequest.ConfigEntry(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.plain.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"sasl.jaas.config"})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{plainJaasConfig})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainJaasConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainLoginCallback = new AlterConfigsRequest.ConfigEntry(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.plain.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"sasl.login.callback.handler.class"})), "test.LoginClass");
        this.verifyConfig$1(brokerResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{plainLoginCallback})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainLoginCallback.name()), (Object)plainLoginCallback.value())})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry customConfig = new AlterConfigsRequest.ConfigEntry("custom.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{customConfig})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        AlterConfigsRequest.ConfigEntry compressionType = new AlterConfigsRequest.ConfigEntry("compression.type", "lz4");
        this.verifyConfig$1(topicResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{compressionType})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")})), sensitiveValue);
        this.verifyConfig$1(topicResource, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsRequest.ConfigEntry[]{customConfig})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        RequestChannel.Request alterConfigs2 = this.request(new AlterConfigsRequest.Builder(Collections.emptyMap(), true).build());
        Assert.assertEquals(Collections.emptyMap(), (Object)((AlterConfigsRequest)alterConfigs2.loggableRequest()).configs());
    }

    @Test
    public void testIncrementalAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Map keystorePassword = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation.$plus$plus((GenTraversableOnce)keystorePassword), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeyPassword = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ssl.key.password"}))), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeyPassword, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ssl.key.password"}))), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeystore = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ssl.keystore.location"}))), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeystore, listenerKeystore, sensitiveValue);
        Map plainJaasConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.plain.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"sasl.jaas.config"}))), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainJaasConfig, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.plain.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"sasl.jaas.config"}))), (Object)"[hidden]")})), sensitiveValue);
        Map plainLoginCallback = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.internal.plain.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"sasl.login.callback.handler.class"}))), (Object)"test.LoginClass")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainLoginCallback, plainLoginCallback, sensitiveValue);
        Map sslProtocols = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.APPEND, sslProtocols, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SUBTRACT, sslProtocols, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        Map cipherSuites = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.cipher.suites"), null)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.DELETE, cipherSuites, cipherSuites, sensitiveValue);
        Map customConfig = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, customConfig, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        Map compressionType = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")}));
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, compressionType, compressionType, sensitiveValue);
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, customConfig, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testNonAlterRequestsNotTransformed() {
        RequestChannel.Request metadataRequest = this.request(new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic"}))).asJava(), true).build());
        Assert.assertSame((Object)metadataRequest.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())), (Object)metadataRequest.loggableRequest());
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serialize(new RequestHeader(req.api, req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)EasyMock.createNiceMock(MemoryPool.class), buffer, (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class));
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"));
    }

    private Map<String, String> toMap(AlterConfigsRequest.Config config) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(AlterConfigsRequest.ConfigEntry e) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> toMap(IncrementalAlterConfigsRequestData.AlterableConfigCollection config) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)config).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(IncrementalAlterConfigsRequestData.AlterableConfig e) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private final void verifyConfig$1(ConfigResource resource, Seq entries2, Map expectedValues, String sensitiveValue$1) {
        RequestChannel.Request alterConfigs2 = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)entries2).asJavaCollection())), true).build());
        AlterConfigsRequest loggableAlterConfigs = (AlterConfigsRequest)alterConfigs2.loggableRequest();
        AlterConfigsRequest.Config loggedConfig = (AlterConfigsRequest.Config)loggableAlterConfigs.configs().get(resource);
        Assert.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = alterConfigs2.requestDesc(true);
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensitive config logged ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{alterConfigsDesc})), (boolean)alterConfigsDesc.contains(sensitiveValue$1));
    }

    private final IncrementalAlterConfigsRequest incrementalAlterConfigs$1(ConfigResource resource, Map entries2, AlterConfigOp.OpType op) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        entries2.foreach((Function1)new Serializable(this, op, alterableConfigs){
            public static final long serialVersionUID = 0L;
            private final AlterConfigOp.OpType op$1;
            private final IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs$1;

            public final boolean apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    boolean bl = this.alterableConfigs$1.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(name).setValue(value).setConfigOperation(this.op$1.id()));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.op$1 = op$1;
                this.alterableConfigs$1 = alterableConfigs$1;
            }
        });
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resource.name()).setResourceType(resource.type().id()).setConfigs(alterableConfigs));
        return (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(data).build();
    }

    private final void verifyConfig$2(ConfigResource resource, AlterConfigOp.OpType op, Map entries2, Map expectedValues, String sensitiveValue$2) {
        RequestChannel.Request alterConfigs2 = this.request((AbstractRequest)this.incrementalAlterConfigs$1(resource, entries2, op));
        IncrementalAlterConfigsRequest loggableAlterConfigs = (IncrementalAlterConfigsRequest)alterConfigs2.loggableRequest();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection loggedConfig = loggableAlterConfigs.data().resources().find(resource.type().id(), resource.name()).configs();
        Assert.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = alterConfigs2.requestDesc(true);
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensitive config logged ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{alterConfigsDesc})), (boolean)alterConfigsDesc.contains(sensitiveValue$2));
    }
}

