/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import kafka.common.KafkaException;
import kafka.security.auth.Group$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.Topic$;
import org.apache.kafka.common.resource.PatternType;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001\u0013\ta!+Z:pkJ\u001cW\rV3ti*\u00111\u0001B\u0001\u0005CV$\bN\u0003\u0002\u0006\r\u0005A1/Z2ve&$\u0018PC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u0015\u00015\t!\u0001C\u0003\u0017\u0001\u0011\u0005q#A\u0019tQ>,H\u000e\u001a+ie><xJ\u001c+x_B\u000b'\u000f^*ue&twmV5uQVs7N\\8x]J+7o\\;sG\u0016$\u0016\u0010]3\u0015\u0003a\u0001\"aC\r\n\u0005ia!\u0001B+oSRDC!\u0006\u000f%KA\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002C\u0005\u0019qN]4\n\u0005\rr\"\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002MA\u0011qEK\u0007\u0002Q)\u0011\u0011FB\u0001\u0007G>lWn\u001c8\n\u0005-B#AD&bM.\fW\t_2faRLwN\u001c\u0005\u0006[\u0001!\taF\u0001&g\"|W\u000f\u001c3UQJ|wo\u00148CC\u0012\u0014Vm]8ve\u000e,G+\u001f9f'\u0016\u0004\u0018M]1u_JDC\u0001\f\u000f%K!)\u0001\u0007\u0001C\u0001/\u0005Y2\u000f[8vY\u0012\u0004\u0016M]:f\u001f2$Gk^8QCJ$8\u000b\u001e:j]\u001eD#a\f\u000f\t\u000bM\u0002A\u0011A\f\u0002WMDw.\u001e7e!\u0006\u00148/Z(mIR;x\u000eU1si^KG\u000f[#nE\u0016$G-\u001a3TKB\f'/\u0019;peND#A\r\u000f\t\u000bY\u0002A\u0011A\f\u00025MDw.\u001e7e!\u0006\u00148/\u001a+ie\u0016,\u0007+\u0019:u'R\u0014\u0018N\\4)\u0005Ub\u0002\"B\u001d\u0001\t\u00039\u0012AK:i_VdG\rU1sg\u0016$\u0006N]3f!\u0006\u0014HoV5uQ\u0016k'-\u001a3eK\u0012\u001cV\r]1sCR|'o\u001d\u0015\u0003qqAQ\u0001\u0010\u0001\u0005\u0002]\t\u0001d\u001d5pk2$'k\\;oIR\u0013\u0018\u000e\u001d,jCN#(/\u001b8hQ\tYD\u0004\u000b\u0003\u0001\u007f\t#\u0005CA\u0006A\u0013\t\tEB\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0013aQ\u00015+N,\u0007e\u001c:h]\u0005\u0004\u0018m\u00195f]-\fgm[1/G>lWn\u001c8/e\u0016\u001cx.\u001e:dK:\u0012Vm]8ve\u000e,\u0007+\u0019;uKJt\u0017%A#\u0002\u0013MKgnY3!e9*\u0004")
public class ResourceTest {
    @Test(expected=KafkaException.class)
    public void shouldThrowOnTwoPartStringWithUnknownResourceType() {
        Resource$.MODULE$.fromString("Unknown:fred");
    }

    @Test(expected=KafkaException.class)
    public void shouldThrowOnBadResourceTypeSeparator() {
        Resource$.MODULE$.fromString("Topic-fred");
    }

    @Test
    public void shouldParseOldTwoPartString() {
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, "fred", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Group:fred"));
        Assert.assertEquals((Object)new Resource((ResourceType)Topic$.MODULE$, "t", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Topic:t"));
    }

    @Test
    public void shouldParseOldTwoPartWithEmbeddedSeparators() {
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, ":This:is:a:weird:group:name:", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Group::This:is:a:weird:group:name:"));
    }

    @Test
    public void shouldParseThreePartString() {
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, "fred", PatternType.PREFIXED), (Object)Resource$.MODULE$.fromString("Group:PREFIXED:fred"));
        Assert.assertEquals((Object)new Resource((ResourceType)Topic$.MODULE$, "t", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Topic:LITERAL:t"));
    }

    @Test
    public void shouldParseThreePartWithEmbeddedSeparators() {
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, ":This:is:a:weird:group:name:", PatternType.PREFIXED), (Object)Resource$.MODULE$.fromString("Group:PREFIXED::This:is:a:weird:group:name:"));
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, ":This:is:a:weird:group:name:", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Group:LITERAL::This:is:a:weird:group:name:"));
    }

    @Test
    public void shouldRoundTripViaString() {
        Resource expected = new Resource((ResourceType)Group$.MODULE$, "fred", PatternType.PREFIXED);
        Resource actual = Resource$.MODULE$.fromString(expected.toString());
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

