/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.nio.charset.StandardCharsets;
import kafka.security.authorizer.AclEntry;
import kafka.security.authorizer.AclEntry$;
import kafka.utils.Json$;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.Assert;
import org.junit.Test;
import org.scalatestplus.junit.JUnitSuite;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001\u0013\ta\u0011i\u00197F]R\u0014\u0018\u0010V3ti*\u00111\u0001B\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(BA\u0003\u0007\u0003!\u0019XmY;sSRL(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u0017Ii\u0011\u0001\u0004\u0006\u0003\u001b9\tQA[;oSRT!a\u0004\t\u0002\u001bM\u001c\u0017\r\\1uKN$\b\u000f\\;t\u0015\u0005\t\u0012aA8sO&\u00111\u0003\u0004\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\u0002m\tq!Q2m\u0015N|g.F\u0001\u001d!\ti\"%D\u0001\u001f\u0015\ty\u0002%\u0001\u0003mC:<'\"A\u0011\u0002\t)\fg/Y\u0005\u0003Gy\u0011aa\u0015;sS:<\u0007BB\u0013\u0001A\u0003%A$\u0001\u0005BG2T5o\u001c8!\u0011\u00159\u0003\u0001\"\u0001)\u0003U!Xm\u001d;BG2T5o\u001c8D_:4XM]:j_:$\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0005+:LG\u000f\u000b\u0002'aA\u0011\u0011gM\u0007\u0002e)\u0011Q\u0002E\u0005\u0003iI\u0012A\u0001V3ti\u0002")
public class AclEntryTest
extends JUnitSuite {
    private final String AclJson;

    public String AclJson() {
        return this.AclJson;
    }

    @Test
    public void testAclJsonConversion() {
        AclEntry acl1 = AclEntry$.MODULE$.apply(new KafkaPrincipal("User", "alice"), AclPermissionType.DENY, "host1", AclOperation.READ);
        AclEntry acl2 = AclEntry$.MODULE$.apply(new KafkaPrincipal("User", "bob"), AclPermissionType.ALLOW, "*", AclOperation.READ);
        AclEntry acl3 = AclEntry$.MODULE$.apply(new KafkaPrincipal("User", "bob"), AclPermissionType.DENY, "host1", AclOperation.READ);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclEntry[]{acl1, acl2, acl3}));
        byte[] jsonAcls = Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)AclEntry$.MODULE$.toJsonCompatibleMap(acls)).asJava());
        Assert.assertEquals((Object)acls, (Object)AclEntry$.MODULE$.fromBytes(jsonAcls));
        Assert.assertEquals((Object)acls, (Object)AclEntry$.MODULE$.fromBytes(this.AclJson().getBytes(StandardCharsets.UTF_8)));
    }

    public AclEntryTest() {
        this.AclJson = "{\"version\": 1, \"acls\": [{\"host\": \"host1\",\"permissionType\": \"Deny\",\"operation\": \"READ\", \"principal\": \"User:alice\"  },  {  \"host\":  \"*\" ,  \"permissionType\": \"Allow\",  \"operation\":  \"Read\", \"principal\": \"User:bob\"  },  {  \"host\": \"host1\",  \"permissionType\": \"Deny\",  \"operation\":   \"Read\" ,  \"principal\": \"User:bob\"}  ]}";
    }
}

