/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import java.util.UUID;
import kafka.cluster.Broker;
import kafka.controller.ReplicaAssignment;
import kafka.log.LogConfig$;
import kafka.server.AdminManager;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001#\u00113nS:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\t\u0007I\u0011B\u000b\u0002\u0011i\\7\t\\5f]R,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\t!A_6\n\u0005mA\"!D&bM.\f'l[\"mS\u0016tG\u000f\u0003\u0004\u001e\u0001\u0001\u0006IAF\u0001\nu.\u001cE.[3oi\u0002Bqa\b\u0001C\u0002\u0013%\u0001%A\u0004nKR\u0014\u0018nY:\u0016\u0003\u0005\u0002\"AI\u0016\u000e\u0003\rR!a\b\u0013\u000b\u0005\u00152\u0013AB2p[6|gN\u0003\u0002\u0006O)\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0013\ta3EA\u0004NKR\u0014\u0018nY:\t\r9\u0002\u0001\u0015!\u0003\"\u0003!iW\r\u001e:jGN\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%I!M\u0001\tEJ|7.\u001a:JIV\t!\u0007\u0005\u0002\ng%\u0011AG\u0003\u0002\u0004\u0013:$\bB\u0002\u001c\u0001A\u0003%!'A\u0005ce>\\WM]%eA!9\u0001\b\u0001b\u0001\n\u0013I\u0014!\u00032s_.,'o\u00148f+\u0005Q\u0004CA\u001e?\u001b\u0005a$BA\u001f\u0005\u0003\u001d\u0019G.^:uKJL!a\u0010\u001f\u0003\r\t\u0013xn[3s\u0011\u0019\t\u0005\u0001)A\u0005u\u0005Q!M]8lKJ|e.\u001a\u0011\t\u000f\r\u0003!\u0019!C\u0005\t\u0006)Ao\u001c9jGV\tQ\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006!A.\u00198h\u0015\u0005Q\u0015\u0001\u00026bm\u0006L!\u0001T$\u0003\rM#(/\u001b8h\u0011\u0019q\u0005\u0001)A\u0005\u000b\u00061Ao\u001c9jG\u0002Bq\u0001\u0015\u0001C\u0002\u0013%A)A\bbgNLwM\\7f]R$v\u000e]5d\u0011\u0019\u0011\u0006\u0001)A\u0005\u000b\u0006\u0001\u0012m]:jO:lWM\u001c;U_BL7\r\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u00035iW\r^1eCR\f7)Y2iKV\ta\u000b\u0005\u0002\u0013/&\u0011\u0001L\u0001\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\t\ri\u0003\u0001\u0015!\u0003W\u00039iW\r^1eCR\f7)Y2iK\u0002Bq\u0001\u0018\u0001C\u0002\u0013%Q,A\u0005qe&t7-\u001b9bYV\ta\f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006!\u0011-\u001e;i\u0015\t\u0019G%\u0001\u0005tK\u000e,(/\u001b;z\u0013\t)\u0007M\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\r\u001d\u0004\u0001\u0015!\u0003_\u0003)\u0001(/\u001b8dSB\fG\u000e\t\u0005\nS\u0002\u0001\r\u00111A\u0005\n)\fA\"\u00193nS:l\u0015M\\1hKJ,\u0012a\u001b\t\u0003%1L!!\u001c\u0002\u0003\u0019\u0005#W.\u001b8NC:\fw-\u001a:\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0013\u0001\u0018\u0001E1e[&tW*\u00198bO\u0016\u0014x\fJ3r)\t\tH\u000f\u0005\u0002\ne&\u00111O\u0003\u0002\u0005+:LG\u000fC\u0004v]\u0006\u0005\t\u0019A6\u0002\u0007a$\u0013\u0007\u0003\u0004x\u0001\u0001\u0006Ka[\u0001\u000eC\u0012l\u0017N\\'b]\u0006<WM\u001d\u0011\t\u000fe\u0004!\u0019!C\u0005u\u0006\u0019A\u000f\u001d\u0019\u0016\u0003m\u0004\"\u0001`?\u000e\u0003\u0011J!A \u0013\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011\u0001\u0001!\u0002\u0013Y\u0018\u0001\u0002;qa\u0001B\u0001\"!\u0002\u0001\u0005\u0004%IA_\u0001\u0004iB\f\u0004bBA\u0005\u0001\u0001\u0006Ia_\u0001\u0005iB\f\u0004\u0005\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003{\u0003\r!\bO\r\u0005\b\u0003#\u0001\u0001\u0015!\u0003|\u0003\u0011!\bO\r\u0011\t\u0011\u0005U\u0001A1A\u0005\ni\faA\\3x)B\u001c\u0004bBA\r\u0001\u0001\u0006Ia_\u0001\b]\u0016<H\u000b]\u001a!\u0011!\ti\u0002\u0001b\u0001\n\u0013Q\u0018A\u00028foR\u0003H\u0007C\u0004\u0002\"\u0001\u0001\u000b\u0011B>\u0002\u000f9,w\u000f\u001695A!I\u0011Q\u0005\u0001C\u0002\u0013%\u0011qE\u0001\u001fKb\u0004Xm\u0019;fI\u000e\u0013X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001c(+Z:vYR,\"!!\u000b\u0011\u000f\u0005-\u0012\u0011G#\u000265\u0011\u0011Q\u0006\u0006\u0004\u0003_Q\u0011AC2pY2,7\r^5p]&!\u00111GA\u0017\u0005\ri\u0015\r\u001d\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b\u0013\u0002\u0011I,\u0017/^3tiNLA!a\u0010\u0002:\tA\u0011\t]5FeJ|'\u000f\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u0015\u0003})\u0007\u0010]3di\u0016$7I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d*fgVdG\u000f\t\u0005\t\u0003\u000f\u0002!\u0019!C\u0005c\u0005ia.^7QCJ$\u0018\u000e^5p]NDq!a\u0013\u0001A\u0003%!'\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u0011\u0005=\u0003A1A\u0005\nE\nQB\\3x!\u0006\u0014H/\u001b;j_:\u001c\bbBA*\u0001\u0001\u0006IAM\u0001\u000f]\u0016<\b+\u0019:uSRLwN\\:!\u0011!\t9\u0006\u0001b\u0001\n\u0013\t\u0014!\u0007;pi\u0006d7I]3bi\u0016\u0004\u0016M\u001d;ji&|gnQ8v]RDq!a\u0017\u0001A\u0003%!'\u0001\u000eu_R\fGn\u0011:fCR,\u0007+\u0019:uSRLwN\\\"pk:$\b\u0005C\u0004\u0002`\u0001!\t!!\u0019\u0002\u000bM,G/\u00169\u0015\u0003EDC!!\u0018\u0002fA!\u0011qMA7\u001b\t\tIGC\u0002\u0002l%\nQA[;oSRLA!a\u001c\u0002j\t1!)\u001a4pe\u0016Dq!a\u001d\u0001\t\u0003\t\t'\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t\t(a\u001e\u0011\t\u0005\u001d\u0014\u0011P\u0005\u0005\u0003w\nIGA\u0003BMR,'\u000fC\u0004\u0002\u0000\u0001!\t!!!\u0002!\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cHCBAB\u0003#\u000b)\n\u0005\u0005\u0002,\u0005E\u0012QQA\u001b!\u0011\t9)!$\u000f\u0007%\tI)C\u0002\u0002\f*\ta\u0001\u0015:fI\u00164\u0017b\u0001'\u0002\u0010*\u0019\u00111\u0012\u0006\t\u000f\u0005M\u0015Q\u0010a\u0001e\u0005yAo\u001c;bYB\u000b'\u000f^5uS>t7\u000f\u0003\u0006\u0002\u0018\u0006u\u0004\u0013!a\u0001\u00033\u000b!d\u0019:fCR,\u0007+\u0019:uSRLwN\\!tg&<g.\\3oiN\u0004b!a'\u0002,\u0006Ef\u0002BAO\u0003OsA!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0004\u0003G3\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\r\tIKC\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti+a,\u0003\t1K7\u000f\u001e\u0006\u0004\u0003SS\u0001\u0003BAZ\u0003#tA!!.\u0002L:!\u0011qWAd\u001d\u0011\tI,!2\u000f\t\u0005m\u00161\u0019\b\u0005\u0003{\u000b\tM\u0004\u0003\u0002 \u0006}\u0016\"\u0001\u0016\n\u0005!J\u0013BA\u0003(\u0013\t)c%C\u0002\u0002J\u0012\nq!\\3tg\u0006<W-\u0003\u0003\u0002N\u0006=\u0017aG\"sK\u0006$X\rU1si&$\u0018n\u001c8t%\u0016\fX/Z:u\t\u0006$\u0018MC\u0002\u0002J\u0012JA!a5\u0002V\nQ2I]3bi\u0016\u0004\u0016M\u001d;ji&|gn]!tg&<g.\\3oi*!\u0011QZAh\u0011\u001d\tI\u000e\u0001C\u0001\u00037\f!c\u0019:fCR,\u0017\tZ7j]6\u000bg.Y4feR\t1\u000eC\u0004\u0002`\u0002!\t!!\u0019\u0002IQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:XSRDGi\\2v[\u0016tG/\u0019;j_:DC!!8\u0002dB!\u0011qMAs\u0013\u0011\t9/!\u001b\u0003\tQ+7\u000f\u001e\u0005\b\u0003W\u0004A\u0011AA1\u0003]\"Xm\u001d;De\u0016\fG/\u001a)beRLG/[8o!J|g/\u001b3fI\u0006\u001b8/[4o[\u0016tGoV5uQR{\u0007/[2QY\u0006\u001cW-\\3oi\"\"\u0011\u0011^Ar\u0011\u001d\t\t\u0010\u0001C\u0001\u0003C\n!\b^3ti\u000e\u0013X-\u0019;f!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e(piB\u0013xN^5eK\u0012<\u0016\u000e\u001e5U_BL7\r\u00157bG\u0016lWM\u001c;)\t\u0005=\u00181\u001d\u0005\b\u0003o\u0004A\u0011AA}\u0003\u0019jwnY6De\u0016\fG/\u001a)beRLG/[8og^KG\u000f\u001b+pa&\u001c\u0007\u000b\\1dK6,g\u000e\u001e\u000b\u0004c\u0006m\b\u0002CA\u007f\u0003k\u0004\r!a@\u0002%\u0015D\u0018n\u001d;j]\u001e\f5o]5h]6,g\u000e\u001e\t\u0005\u0005\u0003\u0011yA\u0004\u0003\u0003\u0004\t-a\u0002\u0002B\u0003\u0005\u0013qA!a(\u0003\b%\tQ!\u0003\u0002\u001a\t%\u0019!Q\u0002\r\u0002\u0015Q{\u0007/[2[\u001d>$W-\u0003\u0003\u0003\u0012\tM!\u0001\u0007+pa&\u001c\u0017\n\u001a*fa2L7-Y!tg&<g.\\3oi*\u0019!Q\u0002\r\t\u0013\t]\u0001!%A\u0005\u0002\te\u0011AG2sK\u0006$X\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u000eU\u0011\tIJ!\b,\u0005\t}\u0001\u0003\u0002B\u0011\u0005Wi!Aa\t\u000b\t\t\u0015\"qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u000b\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005[\u0011\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class AdminManagerTest {
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final Broker brokerOne = new Broker(this.brokerId(), (Seq)Nil$.MODULE$, (Option)new Some((Object)"rack-1"));
    private final String topic;
    private final String assignmentTopic;
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
    private final KafkaPrincipal principal = (KafkaPrincipal)EasyMock.createNiceMock(KafkaPrincipal.class);
    private AdminManager adminManager;
    private final TopicPartition tp0 = new TopicPartition(this.assignmentTopic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.assignmentTopic(), 1);
    private final TopicPartition tp2 = new TopicPartition(this.assignmentTopic(), 2);
    private final TopicPartition newTp3 = new TopicPartition(this.assignmentTopic(), 3);
    private final TopicPartition newTp4 = new TopicPartition(this.assignmentTopic(), 4);
    private final Map<String, ApiError> expectedCreatePartitionsResult = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.assignmentTopic()), (Object)ApiError.NONE)}));
    private final int numPartitions;
    private final int newPartitions;
    private final int totalCreatePartitionCount = this.numPartitions() + this.newPartitions();

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private Broker brokerOne() {
        return this.brokerOne;
    }

    private String topic() {
        return this.topic;
    }

    private String assignmentTopic() {
        return this.assignmentTopic;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private AdminManager adminManager() {
        return this.adminManager;
    }

    private void adminManager_$eq(AdminManager x$1) {
        this.adminManager = x$1;
    }

    private TopicPartition tp0() {
        return this.tp0;
    }

    private TopicPartition tp1() {
        return this.tp1;
    }

    private TopicPartition tp2() {
        return this.tp2;
    }

    private TopicPartition newTp3() {
        return this.newTp3;
    }

    private TopicPartition newTp4() {
        return this.newTp4;
    }

    private Map<String, ApiError> expectedCreatePartitionsResult() {
        return this.expectedCreatePartitionsResult;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private int newPartitions() {
        return this.newPartitions;
    }

    private int totalCreatePartitionCount() {
        return this.totalCreatePartitionCount;
    }

    @Before
    public void setUp() {
        this.adminManager_$eq(this.createAdminManager());
    }

    @After
    public void tearDown() {
        this.metrics().close();
        this.adminManager().shutdown();
    }

    public Map<String, ApiError> createPartitions(int totalPartitions, List<CreatePartitionsRequestData.CreatePartitionsAssignment> createPartitionAssignments) {
        ObjectRef returnedResult = ObjectRef.create((Object)Option$.MODULE$.empty());
        CreatePartitionsRequestData.CreatePartitionsTopic createPartitions2 = new CreatePartitionsRequestData.CreatePartitionsTopic().setName(this.assignmentTopic()).setAssignments(createPartitionAssignments.isEmpty() ? null : (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(createPartitionAssignments).asJava()).setCount(totalPartitions);
        this.adminManager().createPartitions(1000, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsRequestData.CreatePartitionsTopic[]{createPartitions2})), false, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), (Function1)new Serializable(this, returnedResult){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManagerTest $outer;
            private final ObjectRef returnedResult$1;

            public final void apply(Map<String, ApiError> result) {
                this.$outer.kafka$server$AdminManagerTest$$callback$1(result, this.returnedResult$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.returnedResult$1 = returnedResult$1;
            }
        });
        return (Map)((Option)returnedResult.elem).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new RuntimeException("Expected the create partitions callback to have been called");
            }
        });
    }

    public List<CreatePartitionsRequestData.CreatePartitionsAssignment> createPartitions$default$2() {
        return List$.MODULE$.empty();
    }

    public AdminManager createAdminManager() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        return new AdminManager(KafkaConfig$.MODULE$.fromProps(props), this.metrics(), this.metadataCache(), this.zkClient());
    }

    @Test
    public void testDescribeConfigsWithDocumentation() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)new Properties());
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString())).andReturn((Object)new Properties());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.metadataCache().contains(this.topic()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        Map resources = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, this.topic())), (Object)Option$.MODULE$.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString())), (Object)Option$.MODULE$.empty())}));
        Map results = this.adminManager().describeConfigs(resources, true, this.principal());
        Assert.assertEquals((long)2L, (long)results.size());
        results.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<ConfigResource, DescribeConfigsResponse.Config> x0$1) {
                Tuple2<ConfigResource, DescribeConfigsResponse.Config> tuple2 = x0$1;
                if (tuple2 != null) {
                    DescribeConfigsResponse.Config config = (DescribeConfigsResponse.Config)tuple2._2();
                    Assert.assertEquals((Object)Errors.NONE, (Object)config.error().error());
                    Assert.assertFalse((String)"Should return configs", (boolean)config.entries().isEmpty());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    @Test
    public void testCreatePartitionProvidedAssignmentWithTopicPlacement() {
        int brokerTwoId = 2;
        List brokerIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), brokerTwoId}));
        ReplicaAssignment defaultMultiBrokerAssignment = new ReplicaAssignment((Seq)brokerIds, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Option)None$.MODULE$);
        scala.collection.immutable.Map expectedDefaultMultiBrokerAssignment = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp0()), (Object)defaultMultiBrokerAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)defaultMultiBrokerAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)defaultMultiBrokerAssignment)}));
        TopicZNode.TopicIdReplicaAssignment existingMultiBrokerAssignment = new TopicZNode.TopicIdReplicaAssignment(this.assignmentTopic(), (Option)None$.MODULE$, (Map)expectedDefaultMultiBrokerAssignment);
        this.mockCreatePartitionsWithTopicPlacement(existingMultiBrokerAssignment);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        CreatePartitionsRequestData.CreatePartitionsAssignment assignment2 = new CreatePartitionsRequestData.CreatePartitionsAssignment().setBrokerIds((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokerIds.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Integer apply(int brokerId) {
                return Predef$.MODULE$.int2Integer(brokerId);
            }
        }, List$.MODULE$.canBuildFrom())).asJava());
        List newPartitionAssignments = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsRequestData.CreatePartitionsAssignment[]{assignment2, assignment2}));
        Map<String, ApiError> returnedResult = this.createPartitions(this.totalCreatePartitionCount(), (List<CreatePartitionsRequestData.CreatePartitionsAssignment>)newPartitionAssignments);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returned result ", " doesn't contain ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{returnedResult, this.assignmentTopic()})), (boolean)returnedResult.contains((Object)this.assignmentTopic()));
        ApiError apiError = (ApiError)returnedResult.apply((Object)this.assignmentTopic());
        Assert.assertEquals((Object)apiError.error(), (Object)Errors.INVALID_REPLICA_ASSIGNMENT);
        String errMsg = "Replicas ([2]) do not match the sync replicas constraints ([ConstraintCount(count=1,constraints={rack=rack-1})]). The following replicas matched: [1].";
        Assert.assertEquals((Object)apiError.message(), (Object)errMsg);
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    @Test
    public void testCreatePartitionAssignmentNotProvidedWithTopicPlacement() {
        ReplicaAssignment defaultMultiBrokerAssignment = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Option)None$.MODULE$);
        scala.collection.immutable.Map expectedDefaultMultiBrokerAssignment = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp0()), (Object)defaultMultiBrokerAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)defaultMultiBrokerAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)defaultMultiBrokerAssignment)}));
        TopicZNode.TopicIdReplicaAssignment existingMultiBrokerAssignment = new TopicZNode.TopicIdReplicaAssignment(this.assignmentTopic(), (Option)None$.MODULE$, (Map)expectedDefaultMultiBrokerAssignment);
        this.mockCreatePartitionsWithTopicPlacement(existingMultiBrokerAssignment);
        Capture assignmentsCapture = EasyMock.newCapture();
        this.zkClient().setTopicAssignment((String)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Map)EasyMock.capture((Capture)assignmentsCapture), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Map<String, ApiError> returnedResult = this.createPartitions(this.totalCreatePartitionCount(), this.createPartitions$default$2());
        Assert.assertEquals(this.expectedCreatePartitionsResult(), returnedResult);
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
        scala.collection.immutable.Map expectedCreatePartitionsMultiBrokerDefaultAssignment = expectedDefaultMultiBrokerAssignment.$plus$plus((GenTraversableOnce)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.newTp3()), (Object)defaultMultiBrokerAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.newTp4()), (Object)defaultMultiBrokerAssignment)})));
        Assert.assertEquals((Object)expectedCreatePartitionsMultiBrokerDefaultAssignment, (Object)assignmentsCapture.getValue());
    }

    public void mockCreatePartitionsWithTopicPlacement(TopicZNode.TopicIdReplicaAssignment existingAssignment) {
        String topicPlacement = Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString("\n        |{\n        | \"version\": 1,\n        | \"replicas\": [{\n        |   \"count\": 1,\n        |   \"constraints\": {\n        |     \"rack\": \"rack-1\"\n        |     }\n        | }],\n        | \"observers\": [{\n        |   \"count\": 1,\n        |   \"constraints\":{\n        |     \"rack\": \"rack-2\"\n        |   }\n        | }]\n        |}\n        |")).stripMargin().split("\\s+")).mkString();
        Properties topicProperties = new Properties();
        topicProperties.put(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), topicPlacement);
        int brokerTwoId = 2;
        Broker brokerTwo = new Broker(brokerTwoId, (Seq)Nil$.MODULE$, (Option)new Some((Object)"rack-2"));
        EasyMock.expect((Object)this.zkClient().getTopicIdsForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.assignmentTopic()})))).andReturn((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.assignmentTopic()), (Object)UUID.randomUUID())}))).times(0, 1);
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.assignmentTopic())).andReturn((Object)topicProperties).times(0, 100);
        EasyMock.expect((Object)this.zkClient().getEntityConfigs((String)EasyMock.anyObject(), (String)EasyMock.anyObject())).andReturn((Object)new Properties()).times(0, 100);
        EasyMock.expect((Object)this.zkClient().getFullReplicaAssignmentForTopics((Set)EasyMock.anyObject())).andReturn((Object)existingAssignment.assignment()).times(1, 100);
        EasyMock.expect((Object)this.zkClient().getAllBrokersInCluster()).andReturn((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.brokerOne(), brokerTwo}))).times(0, 100);
        EasyMock.expect((Object)this.metadataCache().getPartitionInfo((String)EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()))).andReturn((Object)new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setLeader(this.brokerId()))).times(0, 100);
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
    }

    public final void kafka$server$AdminManagerTest$$callback$1(Map result, ObjectRef returnedResult$1) {
        returnedResult$1.elem = new Some((Object)result);
    }

    public AdminManagerTest() {
        this.brokerId = 1;
        this.topic = "topic-1";
        this.assignmentTopic = "assignment-topic-1";
        this.numPartitions = 3;
        this.newPartitions = 2;
    }
}

