/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\re\u0001B\u0001\u0003\u0001\u001d\u0011ac\u00117jK:$\u0018+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0005i&lW-F\u0001\u0017!\t9\u0012%D\u0001\u0019\u0015\tI\"$A\u0003vi&d7O\u0003\u0002\u001c9\u000511m\\7n_:T!!B\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ea\u0011\u0001\"T8dWRKW.\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\f\u0002\u000bQLW.\u001a\u0011\t\u000f\u0019\u0002!\u0019!C\u0005O\u00059Q.\u001a;sS\u000e\u001cX#\u0001\u0015\u0011\u0005%ZS\"\u0001\u0016\u000b\u0005\u0019R\u0012B\u0001\u0017+\u0005\u001diU\r\u001e:jGNDaA\f\u0001!\u0002\u0013A\u0013\u0001C7fiJL7m\u001d\u0011\t\u000fA\u0002!\u0019!C\u0005c\u000511m\u001c8gS\u001e,\u0012A\r\t\u0003%MJ!\u0001\u000e\u0002\u00031\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\"p]\u001aLw\r\u0003\u00047\u0001\u0001\u0006IAM\u0001\bG>tg-[4!\u0011\u001dA\u0004\u00011A\u0005\u0002e\nAB\\;n\u0007\u0006dGNY1dWN,\u0012A\u000f\t\u0003\u0013mJ!\u0001\u0010\u0006\u0003\u0007%sG\u000fC\u0004?\u0001\u0001\u0007I\u0011A \u0002!9,XnQ1mY\n\f7m[:`I\u0015\fHC\u0001!D!\tI\u0011)\u0003\u0002C\u0015\t!QK\\5u\u0011\u001d!U(!AA\u0002i\n1\u0001\u001f\u00132\u0011\u00191\u0005\u0001)Q\u0005u\u0005ia.^7DC2d'-Y2lg\u0002BQ\u0001\u0013\u0001\u0005\u0002%\u000b\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002\u0001\"\u0012qi\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d~\tQA[;oSRL!\u0001U'\u0003\u000b\u00053G/\u001a:\t\u000bI\u0003A\u0011A*\u0002\u0011\r\fG\u000e\u001c2bG.$\"\u0001\u0011+\t\u000bU\u000b\u0006\u0019\u0001,\u0002\u0011I,7\u000f]8og\u0016\u0004\"aV/\u000f\u0005a[V\"A-\u000b\u0005i#\u0011a\u00028fi^|'o[\u0005\u00039f\u000baBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002_?\nA!+Z:q_:\u001cXM\u0003\u0002]3\")\u0011\r\u0001C\u0005E\u0006a!-^5mIJ+\u0017/^3tiV\u00111-\u001b\u000b\u0005Ib\f\u0019\u0001\u0005\u0003\nK\u001e,\u0018B\u00014\u000b\u0005\u0019!V\u000f\u001d7feA\u0011\u0001.\u001b\u0007\u0001\t\u0015Q\u0007M1\u0001l\u0005\u0005!\u0016C\u00017p!\tIQ.\u0003\u0002o\u0015\t9aj\u001c;iS:<\u0007C\u00019t\u001b\u0005\t(B\u0001:\u001b\u0003!\u0011X-];fgR\u001c\u0018B\u0001;r\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\bCA,w\u0013\t9xLA\u0004SKF,Xm\u001d;\t\u000be\u0004\u0007\u0019\u0001>\u0002\u000f\t,\u0018\u000e\u001c3feB\u00191P`4\u000f\u0005Ad\u0018BA?r\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018bA@\u0002\u0002\t9!)^5mI\u0016\u0014(BA?r\u0011%\t)\u0001\u0019I\u0001\u0002\u0004\t9!\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002\n\u00055QBAA\u0006\u0015\tQ&$\u0003\u0003\u0002\u0010\u0005-!\u0001\u0004'jgR,g.\u001a:OC6,\u0007bBA\n\u0001\u0011%\u0011QC\u0001\f[\u0006L(-\u001a*fG>\u0014H\rF\u0005;\u0003/\t\t#a\r\u00028!A\u0011\u0011DA\t\u0001\u0004\tY\"\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000fE\u0002\u0013\u0003;I1!a\b\u0003\u0005I\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:\t\u0011\u0005\r\u0012\u0011\u0003a\u0001\u0003K\tA!^:feB!\u0011qEA\u0017\u001d\rI\u0011\u0011F\u0005\u0004\u0003WQ\u0011A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,)A\u0001\"!\u000e\u0002\u0012\u0001\u0007\u0011QE\u0001\tG2LWM\u001c;JI\"A\u0011\u0011HA\t\u0001\u0004\tY$A\u0003wC2,X\rE\u0002\n\u0003{I1!a\u0010\u000b\u0005\u0019!u.\u001e2mK\"9\u00111\t\u0001\u0005\n\u0005\u0015\u0013\u0001\u0003;ie>$H\u000f\\3\u0015\u0017\u0001\u000b9%!\u0013\u0002L\u00055\u0013\u0011\u000b\u0005\t\u00033\t\t\u00051\u0001\u0002\u001c!A\u00111EA!\u0001\u0004\t)\u0003\u0003\u0005\u00026\u0005\u0005\u0003\u0019AA\u0013\u0011\u001d\ty%!\u0011A\u0002i\na\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000f\u0003\u0005\u0002T\u0005\u0005\u0003\u0019AA+\u0003e\u0019\u0007.\u00198oK2$\u0006N]8ui2LgnZ\"bY2\u0014\u0017mY6\u0011\u000b%\t9F\u0016!\n\u0007\u0005e#BA\u0005Gk:\u001cG/[8oc!9\u0011Q\f\u0001\u0005\n\u0005}\u0013\u0001\u0005;fgR\fVo\u001c;b!\u0006\u00148/\u001b8h)-\u0001\u0015\u0011MA2\u0005\u0013\u0012iE!\u0015\t\rA\nY\u00061\u00013\u0011!\t)'a\u0017A\u0002\u0005\u001d\u0014aB2mS\u0016tG/\r\t\u0005\u0003S\nY'D\u0001\u0001\r\u0019\ti\u0007\u0001#\u0002p\tQQk]3s\u00072LWM\u001c;\u0014\u000f\u0005-\u0004\"!\u001d\u0002xA\u0019\u0011\"a\u001d\n\u0007\u0005U$BA\u0004Qe>$Wo\u0019;\u0011\u0007%\tI(C\u0002\u0002|)\u0011AbU3sS\u0006d\u0017N_1cY\u0016D1\"a\t\u0002l\tU\r\u0011\"\u0001\u0002\u0000U\u0011\u0011Q\u0005\u0005\f\u0003\u0007\u000bYG!E!\u0002\u0013\t)#A\u0003vg\u0016\u0014\b\u0005C\u0006\u00026\u0005-$Q3A\u0005\u0002\u0005}\u0004bCAE\u0003W\u0012\t\u0012)A\u0005\u0003K\t\u0011b\u00197jK:$\u0018\n\u001a\u0011\t\u0017\u00055\u00151\u000eBK\u0002\u0013\u0005\u0011qR\u0001\u000bG>tg-[4Vg\u0016\u0014XCAAI!\u0015I\u00111SA\u0013\u0013\r\t)J\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0017\u0005e\u00151\u000eB\tB\u0003%\u0011\u0011S\u0001\fG>tg-[4Vg\u0016\u0014\b\u0005C\u0006\u0002\u001e\u0006-$Q3A\u0005\u0002\u0005=\u0015AD2p]\u001aLwm\u00117jK:$\u0018\n\u001a\u0005\f\u0003C\u000bYG!E!\u0002\u0013\t\t*A\bd_:4\u0017nZ\"mS\u0016tG/\u00133!\u0011\u001dy\u00111\u000eC\u0001\u0003K#\"\"a\u001a\u0002(\u0006%\u00161VAW\u0011!\t\u0019#a)A\u0002\u0005\u0015\u0002\u0002CA\u001b\u0003G\u0003\r!!\n\t\u0015\u00055\u00151\u0015I\u0001\u0002\u0004\t\t\n\u0003\u0006\u0002\u001e\u0006\r\u0006\u0013!a\u0001\u0003#C\u0001\"!-\u0002l\u0011\u0005\u00111W\u0001\u0018g\u0006t\u0017\u000e^5{K\u0012\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012,\"!!.\u0011\u000b%\t\u0019*a.\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u0006!A.\u00198h\u0015\t\t\t-\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003wC!\"a2\u0002l\u0005\u0005I\u0011AAe\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005\u001d\u00141ZAg\u0003\u001f\f\t\u000e\u0003\u0006\u0002$\u0005\u0015\u0007\u0013!a\u0001\u0003KA!\"!\u000e\u0002FB\u0005\t\u0019AA\u0013\u0011)\ti)!2\u0011\u0002\u0003\u0007\u0011\u0011\u0013\u0005\u000b\u0003;\u000b)\r%AA\u0002\u0005E\u0005BCAk\u0003W\n\n\u0011\"\u0001\u0002X\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAmU\u0011\t)#a7,\u0005\u0005u\u0007\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a:\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\f\tOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a<\u0002lE\u0005I\u0011AAl\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB!\"a=\u0002lE\u0005I\u0011AA{\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a>+\t\u0005E\u00151\u001c\u0005\u000b\u0003w\fY'%A\u0005\u0002\u0005U\u0018AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0003\u007f\fY'!A\u0005B\t\u0005\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00028\"I!QAA6\u0003\u0003%\t!O\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0005\u0013\tY'!A\u0005\u0002\t-\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u001b\u0011\u0019\u0002E\u0002\n\u0005\u001fI1A!\u0005\u000b\u0005\r\te.\u001f\u0005\t\t\n\u001d\u0011\u0011!a\u0001u!Q!qCA6\u0003\u0003%\tE!\u0007\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0007\u0011\r\tu!1\u0005B\u0007\u001b\t\u0011yBC\u0002\u0003\")\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ca\b\u0003\u0011%#XM]1u_JD!B!\u000b\u0002l\u0005\u0005I\u0011\u0001B\u0016\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0017\u0005g\u00012!\u0003B\u0018\u0013\r\u0011\tD\u0003\u0002\b\u0005>|G.Z1o\u0011%!%qEA\u0001\u0002\u0004\u0011i\u0001\u0003\u0006\u00038\u0005-\u0014\u0011!C!\u0005s\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002u!Q!QHA6\u0003\u0003%\tEa\u0010\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a.\t\u0015\t\r\u00131NA\u0001\n\u0003\u0012)%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005[\u00119\u0005C\u0005E\u0005\u0003\n\t\u00111\u0001\u0003\u000e!A!1JA.\u0001\u0004\t9'A\u0004dY&,g\u000e\u001e\u001a\t\u0011\t=\u00131\fa\u0001\u0003O\nAB]1oI>l7\t\\5f]RD\u0001Ba\u0015\u0002\\\u0001\u0007\u0011qM\u0001\u0014I\u00164\u0017-\u001e7u\u0007>tg-[4DY&,g\u000e\u001e\u0005\u0007\u0005/\u0002A\u0011A%\u00021Q,7\u000f^\"mS\u0016tG/\u00133Rk>$\u0018\rU1sg&tw\r\u000b\u0003\u0003V\tm\u0003c\u0001'\u0003^%\u0019!qL'\u0003\tQ+7\u000f\u001e\u0005\u0007\u0005G\u0002A\u0011A%\u0002)Q,7\u000f^+tKJ\fVo\u001c;b!\u0006\u00148/\u001b8hQ\u0011\u0011\tGa\u0017\t\r\t%\u0004\u0001\"\u0001J\u0003q!Xm\u001d;Vg\u0016\u00148\t\\5f]RLE-U;pi\u0006\u0004\u0016M]:j]\u001eDCAa\u001a\u0003\\!1!q\u000e\u0001\u0005\u0002%\u000bA\u0006^3tiV\u001bXM])v_R\f\u0007+\u0019:tS:<w+\u001b;i\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1)\t\t5$1\f\u0005\u0007\u0005k\u0002A\u0011A%\u0002iQ,7\u000f^+tKJ\u001cE.[3oiF+x\u000e^1QCJ\u001c\u0018N\\4JI^KG\u000f\u001b#fM\u0006,H\u000e^\"mS\u0016tG/\u00133Rk>$\u0018\r\u000b\u0003\u0003t\tm\u0003b\u0002B>\u0001\u0011%!QP\u0001\u000bG\",7m[)v_R\fG#\u0004!\u0003\u0000\t\u0005%1\u0011BC\u0005\u001f\u0013\t\n\u0003\u0005\u0002\u001a\te\u0004\u0019AA\u000e\u0011!\t\u0019C!\u001fA\u0002\u0005\u0015\u0002\u0002CA\u001b\u0005s\u0002\r!!\n\t\u0011\t\u001d%\u0011\u0010a\u0001\u0005\u0013\u000bQ\"\u001a=qK\u000e$X\r\u001a\"pk:$\u0007cA\u0005\u0003\f&\u0019!Q\u0012\u0006\u0003\t1{gn\u001a\u0005\b\u0003s\u0011I\b1\u0001;\u0011!\u0011\u0019J!\u001fA\u0002\t5\u0012AD3ya\u0016\u001cG\u000f\u00165s_R$H.\u001a\u0005\u0007\u0005/\u0003A\u0011A%\u0002kQ,7\u000f^$fi6\u000b\u0007PV1mk\u0016Le.U;pi\u0006<\u0016N\u001c3po^KG\u000f\u001b(p]\u0012+g-Y;miF+x\u000e^1XS:$wn\u001e\u0015\u0005\u0005+\u0013Y\u0006\u0003\u0004\u0003\u001e\u0002!\t!S\u0001!i\u0016\u001cHoU3u\u0003:$'+Z7pm\u0016$UMZ1vYR,6/\u001a:Rk>$\u0018\r\u000b\u0003\u0003\u001c\nm\u0003B\u0002BR\u0001\u0011\u0005\u0011*A\ruKN$8+\u001a;B]\u0012\u0014V-\\8wKV\u001bXM])v_R\f\u0007\u0006\u0002BQ\u00057BaA!+\u0001\t\u0003I\u0015a\b;fgR\u001cV\r^!oIJ+Wn\u001c<f+N,'o\u00117jK:$\u0018+^8uC\"\"!q\u0015B.\u0011\u0019\u0011y\u000b\u0001C\u0001\u0013\u0006IB/Z:u#V|G/Y\"p]\u001aLw\r\u0015:fG\u0016$WM\\2fQ\u0011\u0011iKa\u0017\t\r\tU\u0006\u0001\"\u0001J\u0003I!Xm\u001d;Rk>$\u0018MV5pY\u0006$\u0018n\u001c8)\t\tM&1\f\u0005\u0007\u0005w\u0003A\u0011A%\u0002GQ,7\u000f\u001e*fcV,7\u000f\u001e)fe\u000e,g\u000e^1hKF+x\u000e^1WS>d\u0017\r^5p]\"\"!\u0011\u0018B.\u0011\u0019\u0011\t\r\u0001C\u0001\u0013\u0006aB/Z:u\u000bb\u0004\u0018N]3UQJ|G\u000f\u001e7f)&lWmU3og>\u0014\b\u0006\u0002B`\u00057BaAa2\u0001\t\u0003I\u0015A\u0006;fgR,\u0005\u0010]5sKF+x\u000e^1TK:\u001cxN]:)\t\t\u0015'1\f\u0005\u0007\u0005\u001b\u0004A\u0011A%\u00021Q,7\u000f^\"mS\u0016tG/\u00133O_R\u001c\u0016M\\5uSj,G\r\u000b\u0003\u0003L\nm\u0003B\u0002Bj\u0001\u0011\u0005\u0011*A\u0010uKN$XK\\5wKJ\u001c\u0018\r\\5us>3\u0017i\u0019;jm\u0016$VM\\1oiNDCA!5\u0003\\!1!\u0011\u001c\u0001\u0005\u0002%\u000bA\u0004^3ti\u001a\u0013X-];f]\u000eLxJZ!vi>$VO\\3Rk>$\u0018\r\u000b\u0003\u0003X\nm\u0003B\u0002Bp\u0001\u0011\u0005\u0011*A\u000fuKN$\u0018J\\1di&4X\rV3oC:$8OU3tKR\fVo\u001c;bQ\u0011\u0011iNa\u0017\t\r\t\u0015\b\u0001\"\u0001J\u0003-\"Xm\u001d;BkR|G+\u001e8f\u0005\u0006tGm^5ei\"\fVo\u001c;b\u00032d\u0017IY8wK\u001a\u000b\u0017N\u001d'j[&$\b\u0006\u0002Br\u00057BaAa;\u0001\t\u0003I\u0015\u0001\r;fgR\fU\u000f^8Uk:,')\u00198eo&$G\u000f[)v_R\f\u0017IY8wK\u0006sGMQ3m_^4\u0015-\u001b:MS6LG\u000f\u000b\u0003\u0003j\nm\u0003B\u0002By\u0001\u0011\u0005\u0011*A\u0016uKN$\u0018)\u001e;p)VtWMQ1oI^LG\r\u001e5Rk>$\u0018-\u00117m\u0005\u0016dwn\u001e$bSJd\u0015.\\5uQ\u0011\u0011yOa\u0017\t\r\t]\b\u0001\"\u0001J\u0003!\"Xm\u001d;BkR|G+\u001e8f/&$\bn\u00115b]\u001eLgn\u001a\"s_.,'/U;pi\u0006d\u0015.\\5uQ\u0011\u0011)Pa\u0017\t\r\tu\b\u0001\"\u0001J\u0003-\"Xm\u001d;BkR|G+\u001e8f/&$\bn\u00115b]\u001eLgnZ(sS\u001eLg.\u00197DY&,g\u000e^)v_R\f\u0007\u0006\u0002B~\u00057Baaa\u0001\u0001\t\u0003I\u0015A\n;fgR\fU\u000f^8Uk:,w\u000b[3o\u00072LWM\u001c;Ti>\u00048oU3oI&tw\rT8bI\"\"1\u0011\u0001B.\u0011\u0019\u0019I\u0001\u0001C\u0001\u0013\u0006\u0019D/Z:u\u0003V$x\u000eV;oK^CWM\\\"mS\u0016tG/V:bO\u0016$Um\u0019:fCNLgnZ!gi\u0016\u0014H\u000b\u001b:piRdW\r\u001a\u0015\u0005\u0007\u000f\u0011Y\u0006C\u0004\u0004\u0010\u0001!\ta!\u0005\u0002\u001f5LG\u000e\\5t)>\u0004VM]2f]R$B!a\u000f\u0004\u0014!A1QCB\u0007\u0001\u0004\tY$\u0001\u0004nS2d\u0017n\u001d\u0005\b\u00073\u0001A\u0011AB\u000e\u0003)iW\r\u001e:jGR\u000bwm\u001d\u000b\u0007\u0007;\u0019\u0019c!\n\u0011\u0011\u0005\u001d2qDA\u0013\u0003KIAa!\t\u00022\t\u0019Q*\u00199\t\u0011\u0005\r2q\u0003a\u0001\u0003KA\u0001\"!\u000e\u0004\u0018\u0001\u0007\u0011Q\u0005\u0005\u0007\u0007S\u0001A\u0011A\u0014\u0002\u00159,w/T3ue&\u001c7oB\u0005\u0004.\u0001\t\t\u0011#\u0003\u00040\u0005QQk]3s\u00072LWM\u001c;\u0011\t\u0005%4\u0011\u0007\u0004\n\u0003[\u0002\u0011\u0011!E\u0005\u0007g\u0019ba!\r\u00046\u0005]\u0004CDB\u001c\u0007{\t)#!\n\u0002\u0012\u0006E\u0015qM\u0007\u0003\u0007sQ1aa\u000f\u000b\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\u0010\u0004:\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\t\u000f=\u0019\t\u0004\"\u0001\u0004DQ\u00111q\u0006\u0005\u000b\u0005{\u0019\t$!A\u0005F\t}\u0002BCB%\u0007c\t\t\u0011\"!\u0004L\u0005)\u0011\r\u001d9msRQ\u0011qMB'\u0007\u001f\u001a\tfa\u0015\t\u0011\u0005\r2q\ta\u0001\u0003KA\u0001\"!\u000e\u0004H\u0001\u0007\u0011Q\u0005\u0005\u000b\u0003\u001b\u001b9\u0005%AA\u0002\u0005E\u0005BCAO\u0007\u000f\u0002\n\u00111\u0001\u0002\u0012\"Q1qKB\u0019\u0003\u0003%\ti!\u0017\u0002\u000fUt\u0017\r\u001d9msR!11LB2!\u0015I\u00111SB/!-I1qLA\u0013\u0003K\t\t*!%\n\u0007\r\u0005$B\u0001\u0004UkBdW\r\u000e\u0005\u000b\u0007K\u001a)&!AA\u0002\u0005\u001d\u0014a\u0001=%a!Q1\u0011NB\u0019#\u0003%\t!!>\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIMB!b!\u001c\u00042E\u0005I\u0011AA{\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0004BCB9\u0007c\t\n\u0011\"\u0001\u0002v\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMB!b!\u001e\u00042E\u0005I\u0011AA{\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i!I1\u0011\u0010\u0001\u0012\u0002\u0013%11P\u0001\u0017EVLG\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU!1QPBA+\t\u0019yH\u000b\u0003\u0002\b\u0005mGA\u00026\u0004x\t\u00071\u000e")
public class ClientQuotaManagerTest {
    private final MockTime kafka$server$ClientQuotaManagerTest$$time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.kafka$server$ClientQuotaManagerTest$$time());
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4());
    private int numCallbacks = 0;
    private volatile ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() {
        ClientQuotaManagerTest clientQuotaManagerTest = this;
        synchronized (clientQuotaManagerTest) {
            if (this.kafka$server$ClientQuotaManagerTest$$UserClient$module != null) return this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
            this.kafka$server$ClientQuotaManagerTest$$UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            return this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
        }
    }

    public MockTime kafka$server$ClientQuotaManagerTest$$time() {
        return this.kafka$server$ClientQuotaManagerTest$$time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    public void callback(RequestChannel.Response response) {
        RequestChannel.Response response2;
        block4: {
            block3: {
                block2: {
                    response2 = response;
                    if (!(response2 instanceof RequestChannel.StartThrottlingResponse)) break block2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(response2 instanceof RequestChannel.EndThrottlingResponse)) break block4;
                this.numCallbacks_$eq(this.numCallbacks() + 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)response2);
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public int kafka$server$ClientQuotaManagerTest$$maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        RequestChannel.Session session = new RequestChannel.Session(principal, null);
        return quotaManager.maybeRecordAndGetThrottleTimeMs(session, clientId, value, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
    }

    private void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 != null) {
            RequestChannel.Request request;
            RequestChannel.Request request2;
            RequestChannel.Request request3 = request2 = (request = (RequestChannel.Request)tuple2._2());
            quotaManager.throttle(request3, throttleTimeMs, channelThrottlingCallback);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder().append((Object)"Default producer quota should be ").append((Object)BoxesRunTime.boxToLong((long)config.quotaBytesPerSecondDefault())).toString(), (double)config.quotaBytesPerSecondDefault(), (double)clientMetrics.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (2000)", (double)2000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client2.user(), client2.clientId()).bound(), (double)0.0);
            int throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (double)3000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (double)500.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assert.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        double expectedMaxValueInQuotaWindow = expectedBound < Long.MAX_VALUE ? (double)((long)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * expectedBound) : Double.MAX_VALUE;
        Assert.assertEquals((double)expectedMaxValueInQuotaWindow, (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be > 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (throttleTimeMs > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"throttleTimeMs should be 0. was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)throttleTimeMs)})), (long)0L, (long)throttleTimeMs);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(Long.MAX_VALUE, numFullQuotaWindows + 1, ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4());
        ClientQuotaManager quotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assert.assertEquals((double)Double.MAX_VALUE, (double)quotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assert.assertEquals((double)(10 * numFullQuotaWindows), (double)quotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 10L, 1000, true);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 10L, 1000, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 10L, 1000, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(quotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(quotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(quotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(quotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(quotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(quotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(quotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(quotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(quotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(quotaManager, "userE", "client1", 3000L, 2500, false);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(quotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(quotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(quotaManager, "userF", "client5", 1000L, 800, true);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(quotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(quotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(quotaManager, "userG", "client5", 2000L, 0, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(quotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(quotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(quotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(quotaManager, "userA", "client1", 10000L, 6000, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client6", 8000L, 0, true);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(quotaManager, "userA", "client6", 11000L, 8500, false);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(quotaManager, "userA", "client6", 12000L, 4000, true);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    Assert.assertEquals((long)0L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.clientMetrics$1, "ANONYMOUS", "unknown", 400.0));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int sleepTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 2300.0);
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            this.throttle(clientMetrics, "ANONYMOYUS", "unknown", sleepTime, (Function1<RequestChannel.Response, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)sleepTime);
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, clientMetrics){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager clientMetrics$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.clientMetrics$1, "ANONYMOUS", "unknown", 400.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientMetrics$1 = clientMetrics$1;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 0.0));
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRequestPercentageQuotaViolation() {
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), this.metrics(), (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, (Option)None$.MODULE$);
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Request", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    Assert.assertEquals((long)0L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)this.quotaManager$1, "ANONYMOUS", "test-client", this.$outer.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(4.0)));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$1 = quotaManager$1;
                }
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(500L);
            int throttleTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", this.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(67.1));
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            this.throttle((ClientQuotaManager)quotaManager, "ANONYMOYUS", "test-client", throttleTime, (Function1<RequestChannel.Response, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)throttleTime);
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)this.quotaManager$1, "ANONYMOUS", "test-client", this.$outer.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(4.0));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$1 = quotaManager$1;
                }
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            Assert.assertEquals((long)1000L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", this.kafka$server$ClientQuotaManagerTest$$millisToPercent$1(500.0)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientRequestQuotaManager quotaManager$1;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                    Assert.assertEquals((long)1000L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)this.quotaManager$1, "ANONYMOUS", "test-client", 0.0));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$1 = quotaManager$1;
                }
            });
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        quotaManager.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        String clientId = "client@#$%";
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(clientMetrics, "ANONYMOUS", clientId, 100.0);
            Sensor throttleTimeSensor = this.metrics().getSensor(new StringBuilder().append((Object)"ProduceThrottleTime-:").append((Object)clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = this.metrics().getSensor(new StringBuilder().append((Object)"Produce-:").append((Object)clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUniversalityOfActiveTenants() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        ClientRequestQuotaManager requestQuotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        Set activeTenants = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(quotaManager, "User1", "Client1", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client1"));
            Assert.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants());
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord((ClientQuotaManager)requestQuotaManager, "User3", "Client3", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client3"));
            Assert.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants());
        }
        catch (Throwable throwable) {
            void var1_1;
            void var4_4;
            void var3_3;
            var3_3.shutdown();
            var4_4.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        requestQuotaManager.shutdown();
        metrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFrequencyOfAutoTuneQuota() {
        Metrics metrics = this.newMetrics();
        long x$1 = 500L;
        BrokerBackpressureConfig x$2 = new BrokerBackpressureConfig(true, 1000L, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), BrokerBackpressureConfig$.MODULE$.apply$default$4());
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$2);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        quotaManager.setBrokerQuotaLimit(250.0);
        Assert.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTime = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$2, "", "Client1", 300.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(100, throttleTime));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            Assert.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$2;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTime = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$2, "", "Client1", 300.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(100, throttleTime));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$2 = quotaManager$2;
                }
            });
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var9_8;
            var9_8.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        metrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInactiveTenantsResetQuota() {
        Metrics metrics = this.newMetrics();
        long x$5 = 500L;
        BrokerBackpressureConfig x$6 = new BrokerBackpressureConfig(true, 1000L, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), BrokerBackpressureConfig$.MODULE$.apply$default$4());
        int x$7 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        int x$8 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$5, x$7, x$8, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        quotaManager.setBrokerQuotaLimit(250.0);
        Assert.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 12).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$3;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTime1 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$3, "", "Client1", 300.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(100, throttleTime1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$3 = quotaManager$3;
                }
            });
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            this.kafka$server$ClientQuotaManagerTest$$time().sleep(11000L);
            this.kafka$server$ClientQuotaManagerTest$$maybeRecord(quotaManager, "", "", 300.0);
            Assert.assertEquals((double)quotaManager.quota("", "Client1").bound(), (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var9_8;
            var9_8.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        metrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoTuneBandwidthQuotaAllAboveFairLimit() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        quotaManager.setBrokerQuotaLimit(500.0);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$4;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTime1 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$4, "", "Client1", 300.0);
                    int throttleTime2 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$4, "", "Client2", 300.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$4 = quotaManager$4;
                }
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client2").bound(), (double)0.0);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var3_3;
            var3_3.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        metrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoTuneBandwidthQuotaAboveAndBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        quotaManager.setBrokerQuotaLimit(500.0);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$5;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTime1 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$5, "", "Client1", 350.0);
                    int throttleTime2 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$5, "", "Client2", 200.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$5 = quotaManager$5;
                }
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client2").bound(), (double)0.0);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var3_3;
            var3_3.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        metrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoTuneBandwidthQuotaAllBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        quotaManager.setBrokerQuotaLimit(500.0);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$6;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTime1 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$6, "", "Client1", 200.0);
                    int throttleTime2 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$6, "", "Client2", 200.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(1000, Math.max(throttleTime1, throttleTime2)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$6 = quotaManager$6;
                }
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)quotaManager.quota("", "Client2").bound(), (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            Assert.assertEquals((double)quotaManager.quota("", "Client2").bound(), (double)quotaManager.dynamicQuota("", "Client2").bound(), (double)0.0);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var3_3;
            var3_3.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        metrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoTuneWithChangingBrokerQuotaLimit() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        quotaManager.setBrokerQuotaLimit(250.0);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$7;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTimeMs = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$7, "", "Client1", 300.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(1000, throttleTimeMs));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$7 = quotaManager$7;
                }
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            quotaManager.setBrokerQuotaLimit(500.0);
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            quotaManager.setBrokerQuotaLimit(250.0);
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var3_3;
            var3_3.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        metrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoTuneWithChangingOriginalClientQuota() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        quotaManager.setBrokerQuotaLimit(250.0);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$8;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTimeMs = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$8, "", "Client1", 300.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(1000, throttleTimeMs));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$8 = quotaManager$8;
                }
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(300.0, true)));
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(200.0, true)));
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)200.0, (double)quotaManager.dynamicQuota("", "Client1").bound(), (double)0.0);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var3_3;
            var3_3.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        metrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoTuneWhenClientStopsSendingLoad() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        quotaManager.setBrokerQuotaLimit(500.0);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$9;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTimeMs1 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$9, "", "C1", 200.0);
                    int throttleTimeMs2 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$9, "", "C2", 400.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(1000, Math.max(throttleTimeMs1, throttleTimeMs2)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$9 = quotaManager$9;
                }
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assert.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$9;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    int throttleTimeMs1 = this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$9, "", "C2", 400.0);
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(1000, throttleTimeMs1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$9 = quotaManager$9;
                }
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assert.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var3_3;
            var3_3.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        metrics.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoTuneWhenClientUsageDecreasingAfterThrottled() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ClientQuotaManagerTest$$time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        quotaManager.setBrokerQuotaLimit(500.0);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, quotaManager){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientQuotaManagerTest $outer;
                private final ClientQuotaManager quotaManager$10;

                public final void apply(int _) {
                    this.apply$mcVI$sp(_);
                }

                public void apply$mcVI$sp(int _) {
                    Assert.assertEquals((long)0L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$10, "", "C1", 350.0));
                    Assert.assertEquals((long)0L, (long)this.$outer.kafka$server$ClientQuotaManagerTest$$maybeRecord(this.quotaManager$10, "", "C2", 200.0));
                    this.$outer.kafka$server$ClientQuotaManagerTest$$time().sleep(1000L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.quotaManager$10 = quotaManager$10;
                }
            });
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
            int throttleTimeMs1 = this.kafka$server$ClientQuotaManagerTest$$maybeRecord(quotaManager, "", "C1", 100.0);
            Assert.assertEquals((long)0L, (long)this.kafka$server$ClientQuotaManagerTest$$maybeRecord(quotaManager, "", "C2", 100.0));
            this.kafka$server$ClientQuotaManagerTest$$time().sleep((long)Math.max(1000, throttleTimeMs1));
            quotaManager.maybeAutoTuneQuota(activeTenantsManager, this.kafka$server$ClientQuotaManagerTest$$time().milliseconds());
            Assert.assertEquals((double)330.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assert.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
        }
        catch (Throwable throwable) {
            void var1_1;
            void var3_3;
            var3_3.shutdown();
            var1_1.close();
            throw throwable;
        }
        quotaManager.shutdown();
        metrics.close();
    }

    public double millisToPercent(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public Map<String, String> metricTags(String user, String clientId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.kafka$server$ClientQuotaManagerTest$$time());
    }

    public ClientQuotaManagerTest$UserClient$ kafka$server$ClientQuotaManagerTest$$UserClient() {
        return this.kafka$server$ClientQuotaManagerTest$$UserClient$module == null ? this.kafka$server$ClientQuotaManagerTest$$UserClient$lzycompute() : this.kafka$server$ClientQuotaManagerTest$$UserClient$module;
    }

    public final double kafka$server$ClientQuotaManagerTest$$millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    String string = x;
                    String string2 = ConfigEntityName$.MODULE$.Default();
                    return !(string != null ? !string.equals(string2) : string2 != null) ? ConfigEntityName$.MODULE$.Default() : Sanitizer.sanitize((String)x);
                }
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = this.configClientId();
                    break;
                }
                case 2: {
                    object = this.configUser();
                    break;
                }
                case 1: {
                    object = this.clientId();
                    break;
                }
                case 0: {
                    object = this.user();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UserClient)) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

