/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.common.TopicPlacement;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.AdminManager$;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001\u000f\tI2i\u001c8gYV,g\u000e^!e[&tW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0003\u0016\u00035\u0001H.Y2f[\u0016tGOS:p]V\ta\u0003\u0005\u0002\u001859\u0011\u0011\u0002G\u0005\u00033)\ta\u0001\u0015:fI\u00164\u0017BA\u000e\u001d\u0005\u0019\u0019FO]5oO*\u0011\u0011D\u0003\u0005\u0007=\u0001\u0001\u000b\u0011\u0002\f\u0002\u001dAd\u0017mY3nK:$(j]8oA!)\u0001\u0005\u0001C\u0001C\u0005iB/Z:u)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$8\u000fF\u0001#!\tI1%\u0003\u0002%\u0015\t!QK\\5uQ\tyb\u0005\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005)!.\u001e8ji*\t1&A\u0002pe\u001eL!!\f\u0015\u0003\tQ+7\u000f\u001e\u0005\u0006_\u0001!\t!I\u0001'i\u0016\u001cH\u000fV8qS\u000e\u0004F.Y2f[\u0016tGo\u00142tKJ4XM\u001d(piN+\b\u000f]8si\u0016$\u0007\u0006\u0002\u0018'cI\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002gA\u0011A\u0007P\u0007\u0002k)\u0011agN\u0001\u0007KJ\u0014xN]:\u000b\u0005aJ\u0014AB2p[6|gN\u0003\u0002\u0006u)\u00111HK\u0001\u0007CB\f7\r[3\n\u0005u*$!I%om\u0006d\u0017\u000e\u001a*fa2L7-Y!tg&<g.\\3oi\u0016C8-\u001a9uS>t\u0007\"B \u0001\t\u0003\t\u0013A\u000f;fgR$v\u000e]5d!2\f7-Z7f]R\u0014u\u000e\u001e5U_BL7\r\u00157bG\u0016lWM\u001c;B]\u0012\f5o]5h]6,g\u000e^*qK\u000eLg-[3eQ\tqd\u0005C\u0003C\u0001\u0011\u0005\u0011%A!uKN$Hk\u001c9jGBc\u0017mY3nK:$(i\u001c;i)>\u0004\u0018n\u0019)mC\u000e,W.\u001a8u\u0003:$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:Ta\u0016\u001c\u0017NZ5fI\"\u0012\u0011I\n")
public class ConfluentAdminManagerTest {
    private final String placementJson = new StringOps(Predef$.MODULE$.augmentString("{\n                                 | \"version\": 1,\n                                 |  \"replicas\": [{\n                                 |      \"count\": 2,\n                                 |      \"constraints\": {\n                                 |      }\n                                 |    }\n                                 |  ],\n                                 |  \"observers\": [{\n                                 |    \"count\": 1,\n                                 |    \"constraints\": {\n                                 |    }\n                                 |  }]\n                                 |}")).stripMargin();

    private String placementJson() {
        return this.placementJson;
    }

    @Test
    public void testTopicPlacementConstraints() {
        KafkaConfig kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Properties topicConfigs = new Properties();
        CreateTopicsRequestData.CreatableTopic topic = new CreateTopicsRequestData.CreatableTopic();
        Assert.assertEquals((Object)None$.MODULE$, (Object)AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic));
        topicConfigs.setProperty("confluent.placement.constraints", "");
        Assert.assertEquals((Object)None$.MODULE$, (Object)AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic));
        topicConfigs.setProperty("confluent.placement.constraints", " ");
        Assert.assertEquals((Object)None$.MODULE$, (Object)AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic));
        topicConfigs.setProperty("confluent.placement.constraints", "\t");
        Assert.assertEquals((Object)None$.MODULE$, (Object)AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic));
        topicConfigs.setProperty("confluent.placement.constraints", this.placementJson());
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)this.placementJson())));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kafkaConfig.isObserverSupportEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        topic.setReplicationFactor((short)-1);
        Option topicPlacementOpt = AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic);
        Assert.assertEquals((Object)topicPlacement.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TopicPlacement x$1) {
                return x$1.toJson();
            }
        }), (Object)topicPlacementOpt.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TopicPlacement x$2) {
                return x$2.toJson();
            }
        }));
    }

    @Test(expected=InvalidReplicaAssignmentException.class)
    public void testTopicPlacementObserverNotSupported() {
        KafkaConfig kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        CreateTopicsRequestData.CreatableTopic topic = new CreateTopicsRequestData.CreatableTopic();
        Properties topicConfigs = new Properties();
        topicConfigs.setProperty("confluent.placement.constraints", this.placementJson());
        AdminManager$.MODULE$.validateAndGetTopicPlacement(kafkaConfig, new LogConfig((Map)topicConfigs, LogConfig$.MODULE$.apply$default$2()), topic);
    }

    @Test
    public void testTopicPlacementBothTopicPlacementAndAssignmentSpecified() {
        KafkaConfig kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kafkaConfig.isObserverSupportEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CreateTopicsRequestData.CreatableTopic topic = new CreateTopicsRequestData.CreatableTopic();
        CreateTopicsRequestData.CreatableReplicaAssignment assignment2 = new CreateTopicsRequestData.CreatableReplicaAssignment();
        CreateTopicsRequestData.CreatableReplicaAssignmentCollection assignments = new CreateTopicsRequestData.CreatableReplicaAssignmentCollection(((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateTopicsRequestData.CreatableReplicaAssignment[]{assignment2}))).asJava()).iterator());
        topic.setAssignments(assignments);
        Properties topicConfigs = new Properties();
        topicConfigs.setProperty("confluent.placement.constraints", this.placementJson());
        InvalidRequestException caught = (InvalidRequestException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, kafkaConfig, topic, topicConfigs){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig kafkaConfig$1;
            private final CreateTopicsRequestData.CreatableTopic topic$1;
            private final Properties topicConfigs$1;

            public final Option<TopicPlacement> apply() {
                return AdminManager$.MODULE$.validateAndGetTopicPlacement(this.kafkaConfig$1, new LogConfig((Map)this.topicConfigs$1, LogConfig$.MODULE$.apply$default$2()), this.topic$1);
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
                this.topic$1 = topic$1;
                this.topicConfigs$1 = topicConfigs$1;
            }
        }, ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ConfluentAdminManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        String expectedErrMsg = "Both assignments and confluent.placement.constraints are set. Both cannot be used at the same time.";
        Assert.assertEquals((Object)caught.getMessage(), (Object)expectedErrMsg);
    }

    @Test
    public void testTopicPlacementBothTopicPlacementAndReplicationFactorSpecified() {
        KafkaConfig kafkaConfig = (KafkaConfig)Mockito.mock(KafkaConfig.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)kafkaConfig.isObserverSupportEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        CreateTopicsRequestData.CreatableTopic topic = new CreateTopicsRequestData.CreatableTopic();
        topic.setReplicationFactor((short)3);
        Properties topicConfigs = new Properties();
        topicConfigs.setProperty("confluent.placement.constraints", this.placementJson());
        InvalidRequestException caught = (InvalidRequestException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, kafkaConfig, topic, topicConfigs){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig kafkaConfig$2;
            private final CreateTopicsRequestData.CreatableTopic topic$2;
            private final Properties topicConfigs$2;

            public final Option<TopicPlacement> apply() {
                return AdminManager$.MODULE$.validateAndGetTopicPlacement(this.kafkaConfig$2, new LogConfig((Map)this.topicConfigs$2, LogConfig$.MODULE$.apply$default$2()), this.topic$2);
            }
            {
                this.kafkaConfig$2 = kafkaConfig$2;
                this.topic$2 = topic$2;
                this.topicConfigs$2 = topicConfigs$2;
            }
        }, ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ConfluentAdminManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        String expectedErrMsg = "Both replicationFactor and confluent.placement.constraints are set. Both cannot be used at the same time.";
        Assert.assertEquals((Object)caught.getMessage(), (Object)expectedErrMsg);
    }
}

