/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogConfig$;
import kafka.server.ConfluentBrokerPlacementConstraintTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u0005\u001d\u0011aeQ8oM2,XM\u001c;Ce>\\WM\u001d)mC\u000e,W.\u001a8u\u0007>t7\u000f\u001e:bS:$H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0001\u0004%\t!F\u0001\bg\u0016\u0014h/\u001a:t+\u00051\u0002cA\f\u001d=5\t\u0001D\u0003\u0002\u001a5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003m\tQa]2bY\u0006L!!\b\r\u0003\u0007M+\u0017\u000f\u0005\u0002\u0013?%\u0011\u0001E\u0001\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0004#\u0001\u0001\u0007I\u0011A\u0012\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003I!\u0002\"!\n\u0014\u000e\u0003iI!a\n\u000e\u0003\tUs\u0017\u000e\u001e\u0005\bS\u0005\n\t\u00111\u0001\u0017\u0003\rAH%\r\u0005\u0007W\u0001\u0001\u000b\u0015\u0002\f\u0002\u0011M,'O^3sg\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\u0004ce>\\WM]\u0019\u0016\u0003=\u0002\"!\n\u0019\n\u0005ER\"aA%oi\"11\u0007\u0001Q\u0001\n=\n\u0001B\u0019:pW\u0016\u0014\u0018\u0007\t\u0005\bk\u0001\u0011\r\u0011\"\u0001/\u0003\u001d\u0011'o\\6feJBaa\u000e\u0001!\u0002\u0013y\u0013\u0001\u00032s_.,'O\r\u0011\t\u000fe\u0002!\u0019!C\u0001u\u0005)\"M]8lKJ\u001cuN\\:ue\u0006Lg\u000e\u001e,bYV,W#A\u001e\u0011\u0005q\nU\"A\u001f\u000b\u0005yz\u0014\u0001\u00027b]\u001eT\u0011\u0001Q\u0001\u0005U\u00064\u0018-\u0003\u0002C{\t11\u000b\u001e:j]\u001eDa\u0001\u0012\u0001!\u0002\u0013Y\u0014A\u00062s_.,'oQ8ogR\u0014\u0018-\u001b8u-\u0006dW/\u001a\u0011\t\u000b\u0019\u0003A\u0011I$\u0002\u000bM,G/\u00169\u0015\u0003\u0011B#!R%\u0011\u0005){U\"A&\u000b\u00051k\u0015!\u00026v]&$(\"\u0001(\u0002\u0007=\u0014x-\u0003\u0002Q\u0017\n1!)\u001a4pe\u0016DQA\u0015\u0001\u0005B\u001d\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003#R\u0003\"AS+\n\u0005Y[%!B!gi\u0016\u0014\b\"\u0002-\u0001\t\u00039\u0015a\b;fgR\u001c%/Z1uKR{\u0007/[2XSRD'I]8lKJ4\u0016\r\\;fg\"\u0012qK\u0017\t\u0003\u0015nK!\u0001X&\u0003\tQ+7\u000f\u001e\u0005\u0006=\u0002!\taR\u0001\u001fi\u0016\u001cHo\u0011:fCR,Gk\u001c9jG>3XM\u001d:jI\u0016$UMZ1vYRD#!\u0018.\t\u000b\u0005\u0004A\u0011A$\u0002[Q,7\u000f\u001e#fY\u0016$\u0018N\\4U_BL7mQ8oM&<Gi\\3t\u001d>$(+\u001a<feR$v\u000eR3gCVdG\u000f\u000b\u0002a5\")A\r\u0001C\u0001\u000f\u0006iB/Z:u-\u0006d\u0017\u000eZ1uK\u000e{gn\u001d;sC&tG\u000fR3gCVdG\u000f\u000b\u0002d5\u001e)qM\u0001E\u0001Q\u000613i\u001c8gYV,g\u000e\u001e\"s_.,'\u000f\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]R$Vm\u001d;\u0011\u0005IIg!B\u0001\u0003\u0011\u0003Q7CA5l!\t)C.\u0003\u0002n5\t1\u0011I\\=SK\u001aDQaD5\u0005\u0002=$\u0012\u0001\u001b\u0005\u0006c&$\tA]\u0001\rGJ,\u0017\r^3D_:4\u0017n\u001a\u000b\u0003g~\u0004B\u0001^<{y:\u0011Q%^\u0005\u0003mj\ta\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\ri\u0015\r\u001d\u0006\u0003mj\u0001\"\u0001^>\n\u0005\tK\bC\u0001\u001f~\u0013\tqXH\u0001\u0004PE*,7\r\u001e\u0005\u0007)A\u0004\r!!\u0001\u0011\u000b\u0005\r\u00111\u0003\u0010\u000f\t\u0005\u0015\u0011q\u0002\b\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012bAA\t5\u00059\u0001/Y2lC\u001e,\u0017bA\u000f\u0002\u0016)\u0019\u0011\u0011\u0003\u000e\t\u000f\u0005e\u0011\u000e\"\u0001\u0002\u001c\u0005\u0001\"m\\8ugR\u0014\u0018\r]*feZ,'o\u001d\u000b\u0004u\u0006u\u0001b\u0002\u000b\u0002\u0018\u0001\u0007\u0011\u0011\u0001")
public final class ConfluentBrokerPlacementConstraintTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int broker1;
    private final int broker2;
    private final String brokerConstraintValue;

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return ConfluentBrokerPlacementConstraintTest$.MODULE$.bootstrapServers(seq);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(seq);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public String brokerConstraintValue() {
        return this.brokerConstraintValue;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        scala.collection.immutable.Map rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"b")}));
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), true, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1)new Serializable(this, rack){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentBrokerPlacementConstraintTest $outer;
            private final scala.collection.immutable.Map rack$1;

            public final KafkaServer apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)this.rack$1.apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))).toInt())));
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
                config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
                config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
                config.setProperty(KafkaConfig$.MODULE$.TopicPlacementConstraintsProp(), this.$outer.brokerConstraintValue());
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rack$1 = rack$1;
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testCreateTopicWithBrokerValues() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentBrokerPlacementConstraintTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                Config config = (Config)((KafkaFuture)client.describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{resource}))).asJava()).values().get(resource)).get();
                ConfigEntry constraint = config.get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
                Assert.assertEquals((Object)this.$outer.brokerConstraintValue(), (Object)constraint.value());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCreateTopicOverrideDefault() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentBrokerPlacementConstraintTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                String overrideConstraintValue = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"b\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"a\"}}]}";
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)overrideConstraintValue)}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                Config config = (Config)((KafkaFuture)client.describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{resource}))).asJava()).values().get(resource)).get();
                ConfigEntry constraint = config.get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
                Assert.assertNotEquals((Object)this.$outer.brokerConstraintValue(), (Object)constraint.value());
                Assert.assertEquals((Object)overrideConstraintValue, (Object)constraint.value());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testDeletingTopicConfigDoesNotRevertToDefault() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp operation = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ""), AlterConfigOp.OpType.DELETE);
                client.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{operation}))).asJavaCollection())}))).asJava()).all().get();
                Config config = (Config)((KafkaFuture)client.describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{resource}))).asJava()).values().get(resource)).get();
                ConfigEntry constraint = config.get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
                Assert.assertEquals((Object)Defaults$.MODULE$.TopicPlacementConstraints(), (Object)constraint.value());
            }
        });
    }

    @Test
    public void testValidateConstraintDefault() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentBrokerPlacementConstraintTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentBrokerPlacementConstraintTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                CreateTopicsOptions option = new CreateTopicsOptions().validateOnly(true);
                Config config = (Config)client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava(), option).config(topic).get();
                ConfigEntry constraint = config.get(LogConfig$.MODULE$.TopicPlacementConstraintsProp());
                Assert.assertEquals((Object)this.$outer.brokerConstraintValue(), (Object)constraint.value());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public ConfluentBrokerPlacementConstraintTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.brokerConstraintValue = "{\"version\":1,\"replicas\":[{\"count\":1,\"constraints\":{\"rack\":\"a\"}}],\"observers\":[{\"count\":1,\"constraints\":{\"rack\":\"b\"}}]}";
    }
}

