/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.server.ConfluentObserverTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZkVersion$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\u0015a\u0001B\u0001\u0003\u0005\u001d\u0011QcQ8oM2,XM\u001c;PEN,'O^3s)\u0016\u001cHO\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\tqa]3sm\u0016\u00148/F\u0001\u0017!\r9BDH\u0007\u00021)\u0011\u0011DG\u0001\u000bG>dG.Z2uS>t'\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uA\"aA*fcB\u0011!cH\u0005\u0003A\t\u00111bS1gW\u0006\u001cVM\u001d<fe\"9!\u0005\u0001a\u0001\n\u0003\u0019\u0013aC:feZ,'o]0%KF$\"\u0001\n\u0015\u0011\u0005\u00152S\"\u0001\u000e\n\u0005\u001dR\"\u0001B+oSRDq!K\u0011\u0002\u0002\u0003\u0007a#A\u0002yIEBaa\u000b\u0001!B\u00131\u0012\u0001C:feZ,'o\u001d\u0011\t\u000f5\u0002!\u0019!C\u0001]\u00059!M]8lKJ\fT#A\u0018\u0011\u0005\u0015\u0002\u0014BA\u0019\u001b\u0005\rIe\u000e\u001e\u0005\u0007g\u0001\u0001\u000b\u0011B\u0018\u0002\u0011\t\u0014xn[3sc\u0001Bq!\u000e\u0001C\u0002\u0013\u0005a&A\u0004ce>\\WM\u001d\u001a\t\r]\u0002\u0001\u0015!\u00030\u0003!\u0011'o\\6feJ\u0002\u0003bB\u001d\u0001\u0005\u0004%\tAL\u0001\bEJ|7.\u001a:4\u0011\u0019Y\u0004\u0001)A\u0005_\u0005A!M]8lKJ\u001c\u0004\u0005C\u0004>\u0001\t\u0007I\u0011\u0001\u0018\u0002\u000f\t\u0014xn[3si!1q\b\u0001Q\u0001\n=\n\u0001B\u0019:pW\u0016\u0014H\u0007\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001/\u0003\u001d\u0011'o\\6feVBaa\u0011\u0001!\u0002\u0013y\u0013\u0001\u00032s_.,'/\u000e\u0011\t\u000b\u0015\u0003A\u0011\t$\u0002\u000bM,G/\u00169\u0015\u0003\u0011B#\u0001\u0012%\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015!\u00026v]&$(\"A'\u0002\u0007=\u0014x-\u0003\u0002P\u0015\n1!)\u001a4pe\u0016DQ!\u0015\u0001\u0005B\u0019\u000b\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003!N\u0003\"!\u0013+\n\u0005US%!B!gi\u0016\u0014\b\"B,\u0001\t\u00031\u0015!\b;fgR|%m]3sm\u0016\u00148o\u00155pk2$gj\u001c;K_&t\u0017j\u001d:)\u0005YK\u0006CA%[\u0013\tY&J\u0001\u0003UKN$\b\"B/\u0001\t\u00031\u0015\u0001\u0006;fgR|%m]3sm\u0016\u0014X\t\\3di&|g\u000e\u000b\u0002]3\")\u0001\r\u0001C\u0001\r\u00061C/Z:u%\u0016\f7o]5h]>\u00137/\u001a:wKJl\u0015\r^2iS:<7i\u001c8tiJ\f\u0017N\u001c;)\u0005}K\u0006\"B2\u0001\t\u00031\u0015!\u000b;fgR\u0014V-Y:tS\u001etw+\u001b;i\u0007\"\fgnZ3e\u001f\n\u001cXM\u001d<fe\u000e{gn\u001d;sC&tG\u000f\u000b\u0002c3\")a\r\u0001C\u0001\r\u0006\tC/Z:u%\u0016\f7o]5h]NKhn\u0019*fa2L7-\u0019+p\u001f\n\u001cXM\u001d<fe\"\u0012Q-\u0017\u0005\u0006S\u0002!\tAR\u00012i\u0016\u001cHOU3bgNLwM\\,ji\"\u001cv/\u00199qK\u0012\u001c\u0016P\\2B]\u0012|%m]3sm\u0016\u00148i\u001c8tiJ\f\u0017N\u001c;tQ\tA\u0017\fC\u0003m\u0001\u0011\u0005a)A\u0011uKN$(+Z1tg&<gn\u00142tKJ4XM\u001d+p'ft7MU3qY&\u001c\u0017\r\u000b\u0002l3\")q\u000e\u0001C\u0001\r\u0006yB/Z:u%\u0016\f7o]5h]^KG\u000f\u001b*f[>4X\rZ(cg\u0016\u0014h/\u001a:)\u00059L\u0006\"\u0002:\u0001\t\u00031\u0015!\b;fgR\u0014V-Y:tS\u001etw+\u001b;i\u0003\u0012$W\rZ(cg\u0016\u0014h/\u001a:)\u0005EL\u0006\"B;\u0001\t\u00031\u0015a\t;fgR\u0014V-Y:tS\u001etw+\u001b;i\u0013:4\u0018\r\\5e'ft7MU3qY&\u001c\u0017m\u001d\u0015\u0003ifCQ\u0001\u001f\u0001\u0005\u0002\u0019\u000bq\u0005^3tiJ+\u0017m]:jO:\u0014V-\u0019:sC:<WMU3qY&\u001c\u0017-\u00118e\u001f\n\u001cXM\u001d<fe\"\u0012q/\u0017\u0005\u0006w\u0002!\tAR\u0001(i\u0016\u001cHOU3bgNLwM\\,ji\"LeN^1mS\u0012|%m]3sm\u0016\u0014(+\u001a9mS\u000e\f7\u000f\u000b\u0002{3\")a\u0010\u0001C\u0001\r\u0006\tC/Z:u%\u0016\f7o]5h]^KG\u000f\u001b(fo>3g\r\\5oK\n\u0013xn[3sg\"\u0012Q0\u0017\u0005\u0007\u0003\u0007\u0001A\u0011\u0001$\u0002GQ,7\u000f\u001e$mSB\u0014V-Y:tS\u001etw+\u001b;i\u001f\u001a4G.\u001b8f\u001f\n\u001cXM\u001d<fe\"\u001a\u0011\u0011A-\t\r\u0005%\u0001\u0001\"\u0001G\u0003}!Xm\u001d;GY&\u0004(+Z1tg&<gnV5uQ>3g\r\\5oKNKhn\u0019\u0015\u0004\u0003\u000fI\u0006BBA\b\u0001\u0011\u0005a)A\u0012uKN$(l\u001b*fCN\u001c\u0018n\u001a8XSRD\u0017J\u001c<bY&$\u0017i]:jO:lWM\u001c;)\u0007\u00055\u0011\f\u0003\u0004\u0002\u0016\u0001!\tAR\u0001.i\u0016\u001cH/\u00138wC2LG\r\u00157bG\u0016lWM\u001c;D_:\u001cHO]1j]RLenQ8oM&<WO]1uS>t\u0007fAA\n3\"9\u00111\u0004\u0001\u0005\n\u0005u\u0011aC3mK\u000e$H*Z1eKJ$r\u0001JA\u0010\u0003s\tI\u0005\u0003\u0005\u0002\"\u0005e\u0001\u0019AA\u0012\u0003\u0019\u0019G.[3oiB!\u0011QEA\u001b\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012!B1e[&t'\u0002BA\u0017\u0003_\tqa\u00197jK:$8OC\u0002\u0006\u0003cQ1!a\rM\u0003\u0019\t\u0007/Y2iK&!\u0011qGA\u0014\u0005\u0015\tE-\\5o\u0011!\tY$!\u0007A\u0002\u0005u\u0012A\u0001;q!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#\u0002BA\"\u0003_\taaY8n[>t\u0017\u0002BA$\u0003\u0003\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002L\u0005e\u0001\u0019AA'\u00031)G.Z2uS>tG+\u001f9f!\u0011\ty$a\u0014\n\t\u0005E\u0013\u0011\t\u0002\r\u000b2,7\r^5p]RK\b/\u001a\u0005\b\u0003+\u0002A\u0011BA,\u0003}9\u0018-\u001b;G_JT6NU3bgNLwM\\7f]R$vnQ8na2,G/\u001a\u000b\u0004I\u0005e\u0003BCA.\u0003'\u0002\n\u00111\u0001\u0002^\u0005)\u0001/Y;tKB\u0019Q%a\u0018\n\u0007\u0005\u0005$D\u0001\u0003M_:<\u0007\"CA3\u0001E\u0005I\u0011BA4\u0003%:\u0018-\u001b;G_JT6NU3bgNLwM\\7f]R$vnQ8na2,G/\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u000e\u0016\u0005\u0003;\nYg\u000b\u0002\u0002nA!\u0011qNA=\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014!C;oG\",7m[3e\u0015\r\t9HG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA>\u0003c\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f\u001d\tyH\u0001E\u0001\u0003\u0003\u000bQcQ8oM2,XM\u001c;PEN,'O^3s)\u0016\u001cH\u000fE\u0002\u0013\u0003\u00073a!\u0001\u0002\t\u0002\u0005\u00155\u0003BAB\u0003\u000f\u00032!JAE\u0013\r\tYI\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f=\t\u0019\t\"\u0001\u0002\u0010R\u0011\u0011\u0011\u0011\u0004\b\u0003'\u000b\u0019\tQAK\u0005=\u0011\u0015m]5d\u0007>t7\u000f\u001e:bS:$8\u0003CAI\u0003\u000f\u000b9*!(\u0011\u0007\u0015\nI*C\u0002\u0002\u001cj\u0011q\u0001\u0015:pIV\u001cG\u000fE\u0002&\u0003?K1!!)\u001b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011)\t)+!%\u0003\u0016\u0004%\tAL\u0001\u0006G>,h\u000e\u001e\u0005\u000b\u0003S\u000b\tJ!E!\u0002\u0013y\u0013AB2pk:$\b\u0005C\u0006\u0002.\u0006E%Q3A\u0005\u0002\u0005=\u0016\u0001\u0002:bG.,\"!!-\u0011\t\u0005M\u0016\u0011\u0018\b\u0004K\u0005U\u0016bAA\\5\u00051\u0001K]3eK\u001aLA!a/\u0002>\n11\u000b\u001e:j]\u001eT1!a.\u001b\u0011-\t\t-!%\u0003\u0012\u0003\u0006I!!-\u0002\u000bI\f7m\u001b\u0011\t\u000f=\t\t\n\"\u0001\u0002FR1\u0011qYAf\u0003\u001b\u0004B!!3\u0002\u00126\u0011\u00111\u0011\u0005\b\u0003K\u000b\u0019\r1\u00010\u0011!\ti+a1A\u0002\u0005E\u0006BCAi\u0003#\u000b\t\u0011\"\u0001\u0002T\u0006!1m\u001c9z)\u0019\t9-!6\u0002X\"I\u0011QUAh!\u0003\u0005\ra\f\u0005\u000b\u0003[\u000by\r%AA\u0002\u0005E\u0006BCAn\u0003#\u000b\n\u0011\"\u0001\u0002^\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAApU\ry\u00131\u000e\u0005\u000b\u0003G\f\t*%A\u0005\u0002\u0005\u0015\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003OTC!!-\u0002l!Q\u00111^AI\u0003\u0003%\t%!<\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u000f\u0005\u0003\u0002r\u0006mXBAAz\u0015\u0011\t)0a>\u0002\t1\fgn\u001a\u0006\u0003\u0003s\fAA[1wC&!\u00111XAz\u0011%\ty0!%\u0002\u0002\u0013\u0005a&\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0003\u0004\u0005E\u0015\u0011!C\u0001\u0005\u000b\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\b\t5\u0001cA\u0013\u0003\n%\u0019!1\u0002\u000e\u0003\u0007\u0005s\u0017\u0010\u0003\u0005*\u0005\u0003\t\t\u00111\u00010\u0011)\u0011\t\"!%\u0002\u0002\u0013\u0005#1C\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0003\t\u0006/\t]!qA\u0005\u0004\u00053A\"\u0001C%uKJ\fGo\u001c:\t\u0015\tu\u0011\u0011SA\u0001\n\u0003\u0011y\"\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\tCa\n\u0011\u0007\u0015\u0012\u0019#C\u0002\u0003&i\u0011qAQ8pY\u0016\fg\u000eC\u0005*\u00057\t\t\u00111\u0001\u0003\b!Q!1FAI\u0003\u0003%\tE!\f\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\f\u0005\u000b\u0005c\t\t*!A\u0005B\tM\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005=\bB\u0003B\u001c\u0003#\u000b\t\u0011\"\u0011\u0003:\u00051Q-];bYN$BA!\t\u0003<!I\u0011F!\u000e\u0002\u0002\u0003\u0007!qA\u0004\u000b\u0005\u007f\t\u0019)!A\t\u0002\t\u0005\u0013a\u0004\"bg&\u001c7i\u001c8tiJ\f\u0017N\u001c;\u0011\t\u0005%'1\t\u0004\u000b\u0003'\u000b\u0019)!A\t\u0002\t\u00153C\u0002B\"\u0005\u000f\ni\nE\u0005\u0003J\t=s&!-\u0002H6\u0011!1\n\u0006\u0004\u0005\u001bR\u0012a\u0002:v]RLW.Z\u0005\u0005\u0005#\u0012YEA\tBEN$(/Y2u\rVt7\r^5p]JBqa\u0004B\"\t\u0003\u0011)\u0006\u0006\u0002\u0003B!Q!\u0011\u0007B\"\u0003\u0003%)Ea\r\t\u0015\tm#1IA\u0001\n\u0003\u0013i&A\u0003baBd\u0017\u0010\u0006\u0004\u0002H\n}#\u0011\r\u0005\b\u0003K\u0013I\u00061\u00010\u0011!\tiK!\u0017A\u0002\u0005E\u0006B\u0003B3\u0005\u0007\n\t\u0011\"!\u0003h\u00059QO\\1qa2LH\u0003\u0002B5\u0005k\u0002R!\nB6\u0005_J1A!\u001c\u001b\u0005\u0019y\u0005\u000f^5p]B1QE!\u001d0\u0003cK1Aa\u001d\u001b\u0005\u0019!V\u000f\u001d7fe!Q!q\u000fB2\u0003\u0003\u0005\r!a2\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003|\t\r\u0013\u0011!C\u0005\u0005{\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0010\t\u0005\u0003c\u0014\t)\u0003\u0003\u0003\u0004\u0006M(AB(cU\u0016\u001cG\u000f\u0003\u0005\u0003\b\u0006\rE\u0011\u0001BE\u00031\u0019'/Z1uK\u000e{gNZ5h)\u0011\u0011YI!%\u0011\u0011\u0005M&QRAY\u0005\u007fJAAa$\u0002>\n\u0019Q*\u00199\t\u000fQ\u0011)\t1\u0001\u0003\u0014B)!Q\u0013BS=9!!q\u0013BQ\u001d\u0011\u0011IJa(\u000e\u0005\tm%b\u0001BO\r\u00051AH]8pizJ\u0011aG\u0005\u0004\u0005GS\u0012a\u00029bG.\fw-Z\u0005\u0004;\t\u001d&b\u0001BR5!A!1VAB\t\u0003\u0011i+A\tsK\u0006\u001c8/[4o[\u0016tG/\u00128uef$bAa,\u0003B\n\u001d\u0007C\u0002BY\u0005o\u0013Y,\u0004\u0002\u00034*!!QWA|\u0003\u0011)H/\u001b7\n\t\te&1\u0017\u0002\t\u001fB$\u0018n\u001c8bYB!\u0011Q\u0005B_\u0013\u0011\u0011y,a\n\u000319+w\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tG\u000f\u0003\u0005\u0003D\n%\u0006\u0019\u0001Bc\u0003!\u0011X\r\u001d7jG\u0006\u001c\b#\u0002BK\u0005K{\u0003\u0002\u0003Be\u0005S\u0003\rA!2\u0002\u0013=\u00147/\u001a:wKJ\u001c\b\u0002\u0003Bg\u0003\u0007#\tAa4\u0002C]\f\u0017\u000e\u001e$pe\u0006cGNU3bgNLwM\\7f]R\u001cHk\\\"p[BdW\r^3\u0015\u0007\u0011\u0012\t\u000e\u0003\u0005\u0002\"\t-\u0007\u0019\u0001Bj!\u0011\t)C!6\n\t\t]\u0017q\u0005\u0002\f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0003\u0005\u0003\\\u0006\rE\u0011\u0001Bo\u0003Y!Wm]2sS\n,Gk\u001c9jGB\u000b'\u000f^5uS>tGC\u0002Bp\u0005O\u0014I\u000fE\u0003&\u0005W\u0012\t\u000f\u0005\u0003\u0002@\t\r\u0018\u0002\u0002Bs\u0003\u0003\u0012!\u0003V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00138g_\"A\u0011\u0011\u0005Bm\u0001\u0004\u0011\u0019\u000e\u0003\u0005\u0003l\ne\u0007\u0019AA\u001f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001Ba<\u0002\u0004\u0012\u0005!\u0011_\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<feN$B!!-\u0003t\"9AC!<A\u0002\tM\u0005\u0002\u0003B|\u0003\u0007#\tA!?\u0002'\t\f7/[2U_BL7\r\u00157bG\u0016lWM\u001c;\u0015\r\u0005E&1 B\u0000\u0011!\u0011iP!>A\u0002\u0005\u001d\u0017!\u0005:fa2L7-Y\"p]N$(/Y5oi\"A1\u0011\u0001B{\u0001\u0004\u0019\u0019!\u0001\npEN,'O^3s\u0007>t7\u000f\u001e:bS:$\b#B\u0013\u0003l\u0005\u001d\u0007")
public final class ConfluentObserverTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int broker1;
    private final int broker2;
    private final int broker3;
    private final int broker4;
    private final int broker5;

    public static String basicTopicPlacement(BasicConstraint basicConstraint, Option<BasicConstraint> option) {
        return ConfluentObserverTest$.MODULE$.basicTopicPlacement(basicConstraint, option);
    }

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return ConfluentObserverTest$.MODULE$.bootstrapServers(seq);
    }

    public static Option<TopicPartitionInfo> describeTopicPartition(AdminClient adminClient, TopicPartition topicPartition) {
        return ConfluentObserverTest$.MODULE$.describeTopicPartition(adminClient, topicPartition);
    }

    public static void waitForAllReassignmentsToComplete(AdminClient adminClient) {
        ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(adminClient);
    }

    public static Optional<NewPartitionReassignment> reassignmentEntry(Seq<Object> seq, Seq<Object> seq2) {
        return ConfluentObserverTest$.MODULE$.reassignmentEntry(seq, seq2);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return ConfluentObserverTest$.MODULE$.createConfig(seq);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    public int broker4() {
        return this.broker4;
    }

    public int broker5() {
        return this.broker5;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        scala.collection.immutable.Map rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker3())), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker4())), (Object)"b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker5())), (Object)"c")}));
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(5, this.zkConnect(), true, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1)new Serializable(this, rack){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map rack$1;

            public final KafkaServer apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)this.rack$1.apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))).toInt())));
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
                config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
                config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
            }
            {
                this.rack$1 = rack$1;
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testObserversShouldNotJoinIsr() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testObserverElection() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                Seq rollingServers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}));
                rollingServers.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testObserverElection$1 $outer;

                    public final void apply(int broker) {
                        this.apply$mcVI$sp(broker);
                    }

                    public void apply$mcVI$sp(int broker) {
                        ((KafkaServer)this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().servers().apply(broker)).shutdown();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.kafka$server$ConfluentObserverTest$$electLeader((Admin)client, topicPartition, ElectionType.UNCLEAN);
                TestUtils$.MODULE$.waitForLeaderToBecomeOneOf((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                rollingServers.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testObserverElection$1 $outer;

                    public final void apply(int broker) {
                        this.apply$mcVI$sp(broker);
                    }

                    public void apply$mcVI$sp(int broker) {
                        ((KafkaServer)this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().servers().apply(broker)).startup();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3(), this.$outer.broker4()}))));
                this.$outer.kafka$server$ConfluentObserverTest$$electLeader((Admin)client, topicPartition, ElectionType.PREFERRED);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
            }

            public /* synthetic */ ConfluentObserverTest kafka$server$ConfluentObserverTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignObserverMatchingConstraint() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()}))));
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker4()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker4()})))))}))).asJava()).all().get();
                ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker4()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker4()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignWithChangedObserverConstraint() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()}))));
                Properties observerCConfig = new Properties();
                observerCConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "c"))));
                TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, observerCConfig);
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker5()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker5()})))))}))).asJava()).all().get();
                ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker5()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker5()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignSyncReplicaToObserver() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3()}));
                TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment2)}))), this.$outer.servers(), new Properties());
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForLeaderToBecome((Admin)client, topicPartition, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.$outer.broker1())));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3()}))));
                Properties observerBConfig = new Properties();
                observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))));
                TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, observerBConfig);
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()})))))}))).asJava()).all().get();
                ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignWithSwappedSyncAndObserverConstraints() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                Properties observerBConfig = new Properties();
                observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "b"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "a"))));
                TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, observerBConfig);
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4(), this.$outer.broker1(), this.$outer.broker2()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()})))))}))).asJava()).all().get();
                ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4(), this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignObserverToSyncReplica() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()}))));
                TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, new Properties());
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3()}))), (Seq<Object>)((Seq)Seq$.MODULE$.empty())))}))).asJava()).all().get();
                ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignWithRemovedObserver() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()}))));
                TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, new Properties());
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))), (Seq<Object>)((Seq)Seq$.MODULE$.empty())))}))).asJava()).all().get();
                ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignWithAddedObserver() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                Seq assignment2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}));
                TestUtils$.MODULE$.createTopic(this.$outer.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment2)}))), this.$outer.servers(), new Properties());
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForLeaderToBecome((Admin)client, topicPartition, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.$outer.broker1())));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                Properties observerBConfig = new Properties();
                observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(1, "b"))));
                TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, observerBConfig);
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()})))))}))).asJava()).all().get();
                ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignWithInvalidSyncReplicas() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                ExecutionException exception = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicPartition, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testReassignWithInvalidSyncReplicas$1 $outer;
                    private final TopicPartition topicPartition$1;
                    private final AdminClient client$2;

                    public final Void apply() {
                        return (Void)this.client$2.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$1), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker1(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker5(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker3(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker4()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker3(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker4()})))))}))).asJava()).all().get();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topicPartition$1 = topicPartition$1;
                        this.client$2 = client$2;
                    }
                }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ConfluentObserverTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
                Assert.assertEquals(InvalidReplicaAssignmentException.class, exception.getCause().getClass());
            }

            public /* synthetic */ ConfluentObserverTest kafka$server$ConfluentObserverTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignRearrangeReplicaAndObserver() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                scala.collection.mutable.Map description = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)client.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).all().get()).asScala();
                Seq replicas = ((TraversableOnce)((TraversableLike)description.values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Buffer<Node> apply(TopicDescription x$1) {
                        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.partitions()).asScala()).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Buffer<Node> apply(TopicPartitionInfo x$2) {
                                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2.replicas()).asScala();
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$3) {
                        return x$3.id();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq();
                Seq newReplicaOrder = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)replicas.apply(1)), BoxesRunTime.unboxToInt((Object)replicas.apply(0)), BoxesRunTime.unboxToInt((Object)replicas.apply(3)), BoxesRunTime.unboxToInt((Object)replicas.apply(2))}));
                Seq newObserverOrder = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)replicas.apply(3)), BoxesRunTime.unboxToInt((Object)replicas.apply(2))}));
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)newReplicaOrder, (Seq<Object>)newObserverOrder))}))).asJava()).all().get();
                ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)newReplicaOrder);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker2(), this.$outer.broker1()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker4(), this.$outer.broker3()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignWithInvalidObserverReplicas() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                ExecutionException exception = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicPartition, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testReassignWithInvalidObserverReplicas$1 $outer;
                    private final TopicPartition topicPartition$2;
                    private final AdminClient client$3;

                    public final Void apply() {
                        return (Void)this.client$3.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$2), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker1(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker2(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker3(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker5()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker3(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker5()})))))}))).asJava()).all().get();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topicPartition$2 = topicPartition$2;
                        this.client$3 = client$3;
                    }
                }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ConfluentObserverTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
                Assert.assertEquals(InvalidReplicaAssignmentException.class, exception.getCause().getClass());
            }

            public /* synthetic */ ConfluentObserverTest kafka$server$ConfluentObserverTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testReassignWithNewOfflineBrokers() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final InvalidReplicaAssignmentException apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                int offlineBrokerId = 5;
                KafkaFuture future = client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3(), offlineBrokerId}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), offlineBrokerId})))))}))).asJava()).all();
                return (InvalidReplicaAssignmentException)TestUtils.assertFutureThrows((Future)future, InvalidReplicaAssignmentException.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testFlipReassignWithOfflineObserver() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                Properties observerBConfig = new Properties();
                observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "b"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "a"))));
                TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, observerBConfig);
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker1())).shutdown();
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4(), this.$outer.broker1(), this.$outer.broker2()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()})))))}))).asJava()).all().get();
                ConfluentObserverTest$.MODULE$.waitForAllReassignmentsToComplete(client);
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4(), this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testFlipReassignWithOfflineSync() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                Properties observerBConfig = new Properties();
                observerBConfig.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "b"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "a"))));
                TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, observerBConfig);
                ((KafkaServer)this.$outer.servers().apply(this.$outer.broker3())).shutdown();
                ExecutionException exception = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, topicPartition, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testFlipReassignWithOfflineSync$1 $outer;
                    private final TopicPartition topicPartition$3;
                    private final AdminClient client$4;

                    public final Void apply() {
                        return (Void)this.client$4.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition$3), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker3(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker4(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker1(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker2()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker1(), this.$outer.kafka$server$ConfluentObserverTest$$anonfun$$$outer().broker2()})))))}))).asJava()).all().get();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topicPartition$3 = topicPartition$3;
                        this.client$4 = client$4;
                    }
                }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ConfluentObserverTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 605));
                Assert.assertEquals(InvalidReplicaAssignmentException.class, exception.getCause().getClass());
            }

            public /* synthetic */ ConfluentObserverTest kafka$server$ConfluentObserverTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testZkReassignWithInvalidAssignment() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                int partition = 0;
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new BasicConstraint(2, "a"), (Option<BasicConstraint>)new Some((Object)new BasicConstraint(2, "b"))))}))).asJava());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
                scala.collection.immutable.Map zkReassignments = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2(), this.$outer.broker3(), this.$outer.broker4()})))}));
                this.$outer.zkClient().setOrCreatePartitionReassignment((Map)zkReassignments, ZkVersion$.MODULE$.MatchAnyVersion());
                this.$outer.kafka$server$ConfluentObserverTest$$waitForZkReassignmentToComplete(this.$outer.kafka$server$ConfluentObserverTest$$waitForZkReassignmentToComplete$default$1());
                TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1(), this.$outer.broker2()}))));
                TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker3(), this.$outer.broker4()}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testInvalidPlacementConstraintInConfiguration() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                Properties configUpdate = new Properties();
                configUpdate.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), "invalid json");
                KafkaFuture alterConfigFuture = TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, configUpdate).all();
                TestUtils.assertFutureError((Future)alterConfigFuture, InvalidRequestException.class);
                KafkaFuture incrementalAlterConfigFuture = TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, configUpdate).all();
                TestUtils.assertFutureError((Future)incrementalAlterConfigFuture, InvalidRequestException.class);
            }
        });
    }

    public void kafka$server$ConfluentObserverTest$$electLeader(Admin client, TopicPartition tp, ElectionType electionType) {
        ElectLeadersResult electionResult = client.electLeaders(electionType, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric((Optional)((java.util.Map)electionResult.partitions().get()).get(tp))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Throwable exception) {
                throw exception;
            }
        });
    }

    public void kafka$server$ConfluentObserverTest$$waitForZkReassignmentToComplete(long pause) {
        Serializable x$4 = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConfluentObserverTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.$outer.zkClient().reassignPartitionsInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        Serializable x$5 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Znode ", " wasn't deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReassignPartitionsZNode$.MODULE$.path()}));
            }
        };
        long x$6 = pause;
        long x$7 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$4, (Function0<String>)x$5, x$7, x$6);
    }

    public long kafka$server$ConfluentObserverTest$$waitForZkReassignmentToComplete$default$1() {
        return 100L;
    }

    public ConfluentObserverTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
        this.broker4 = 3;
        this.broker5 = 4;
    }

    public static class BasicConstraint
    implements Product,
    Serializable {
        private final int count;
        private final String rack;

        public int count() {
            return this.count;
        }

        public String rack() {
            return this.rack;
        }

        public BasicConstraint copy(int count, String rack) {
            return new BasicConstraint(count, rack);
        }

        public int copy$default$1() {
            return this.count();
        }

        public String copy$default$2() {
            return this.rack();
        }

        public String productPrefix() {
            return "BasicConstraint";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.rack();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.count());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BasicConstraint;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.count());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rack()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof BasicConstraint)) return false;
            boolean bl = true;
            if (!bl) return false;
            BasicConstraint basicConstraint = (BasicConstraint)x$1;
            if (this.count() != basicConstraint.count()) return false;
            String string = this.rack();
            String string2 = basicConstraint.rack();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!basicConstraint.canEqual(this)) return false;
            return true;
        }

        public BasicConstraint(int count, String rack) {
            this.count = count;
            this.rack = rack;
            Product.class.$init$((Product)this);
        }
    }
}

