/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierFetchDataInfo;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchResult;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0003R3mCf,GMR3uG\"$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001C3bgflwnY6\u000b\u00035\t1a\u001c:h\u0013\ty!BA\bFCNLXj\\2l'V\u0004\bo\u001c:u\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u0015\u00015\t!\u0001C\u0004\u0017\u0001\t\u0007I\u0011B\f\u0002\u00115\f\u0007PQ=uKN,\u0012\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0004\u0013:$\bBB\u0010\u0001A\u0003%\u0001$A\u0005nCb\u0014\u0015\u0010^3tA!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0013\u0001C7pG.$\u0016.\\3\u0016\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005!*#\u0001C'pG.$\u0016.\\3\t\r)\u0002\u0001\u0015!\u0003$\u0003%iwnY6US6,\u0007\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\ta\u0006\u0005\u0002\u0015_%\u0011\u0001G\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0019\u0011\u0004\u0001)A\u0005]\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b\u0005C\u00045\u0001\t\u0007I\u0011B\u001b\u0002\u0019I,\u0007\u000f\\5dCF+x\u000e^1\u0016\u0003Y\u0002\"\u0001F\u001c\n\u0005a\u0012!\u0001\u0004*fa2L7-Y)v_R\f\u0007B\u0002\u001e\u0001A\u0003%a'A\u0007sKBd\u0017nY1Rk>$\u0018\r\t\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8/F\u0001?!\t!r(\u0003\u0002A\u0005\t\u0001\"I]8lKJ$v\u000e]5d'R\fGo\u001d\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002 \u0002#\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b\u0005C\u0003E\u0001\u0011\u0005Q)\u0001\u0005uK\u0006\u0014Hi\\<o)\u00051\u0005CA\rH\u0013\tA%D\u0001\u0003V]&$\bFA\"K!\tYe*D\u0001M\u0015\tiE\"A\u0003kk:LG/\u0003\u0002P\u0019\n)\u0011I\u001a;fe\")\u0011\u000b\u0001C\u0001\u000b\u0006\u0011B/Z:u\u001b&DX\r\u001a+jKJ4U\r^2iQ\t\u00016\u000b\u0005\u0002L)&\u0011Q\u000b\u0014\u0002\u0005)\u0016\u001cH\u000fC\u0003X\u0001\u0011\u0005Q)\u0001\ruKN$H+[3s\r\u0016$8\r[3s\u000bb\u001cW\r\u001d;j_:D#AV*\t\u000bi\u0003A\u0011A#\u00021Q,7\u000f\u001e$fi\u000eDw+\u001b;i\r\u0016t7-\u001a3Fa>\u001c\u0007\u000e\u000b\u0002Z'\")Q\f\u0001C\u0001\u000b\u00069B/Z:u%\u0016\u0004H.[2b\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u0015\u00039NCQ\u0001\u0019\u0001\u0005\u0002\u0005\f!e\u00195fG.\u001cu.\u001c9mKR,w\u000b[3o\r>dGn\\<fe2\u000bwmZ5oO\";Fc\u0001$cU\")1m\u0018a\u0001I\u0006Qam\u001c7m_^,'\u000fS,\u0011\u0007e)w-\u0003\u0002g5\t1q\n\u001d;j_:\u0004\"!\u00075\n\u0005%T\"\u0001\u0002'p]\u001eDQa[0A\u00021\f1b\u00195fG.\u0014Vm];miB!\u0011$\\8G\u0013\tq'DA\u0005Gk:\u001cG/[8ocA\u0011A\u0003]\u0005\u0003c\n\u0011A\u0002R3mCf,GMR3uG\"DQa\u001d\u0001\u0005\u0002\u0015\u000b\u0011\u0005^3ti\u000e{W\u000e\u001d7fi\u0016<\u0006.\u001a8G_2dwn^3s\u0019\u0006<w-\u001b8h\u0011^C#A]*\t\u000bY\u0004A\u0011A#\u0002eQ,7\u000f\u001e$pY2|w/\u001a:GKR\u001c\u0007\u000eV5nK2\u000bwMT8u%\u0016\u001cwN\u001d3fI\u0006\u001b8i\u001c8tk6,'OR3uG\"D#!^*\t\u000be\u0004A\u0011A#\u00029Q,7\u000f^\"p]N,X.\u001a:US\u0016\u0014h)\u001a;dQRKW.\u001a'bO\"\u0012\u0001p\u0015\u0005\u0006y\u0002!\t!R\u00011i\u0016\u001cH\u000fT8dC2\u001cVmZ7f]R$U\r\\3uK\u0012\fe\r^3s\t\u0016d\u0017-_3e\r\u0016$8\r[\"sK\u0006$\u0018n\u001c8)\u0005m\u001c\u0006BB@\u0001\t\u0013\t\t!\u0001\u0011ck&dG-T;mi&\u0004\u0016M\u001d;ji&|gNR3uG\"lU\r^1eCR\fG\u0003CA\u0002\u0003\u0013\ti!a\u000f\u0011\u0007Q\t)!C\u0002\u0002\b\t\u0011QBR3uG\"lU\r^1eCR\f\u0007BBA\u0006}\u0002\u0007\u0001$A\u0005sKBd\u0017nY1JI\"9\u0011q\u0002@A\u0002\u0005E\u0011\u0001\u00064fi\u000eD\u0007+\u0019:uSRLwN\\*uCR,8\u000f\u0005\u0004\u0002\u0014\u0005e\u0011QD\u0007\u0003\u0003+Q1!a\u0006\u001b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t)BA\u0002TKF\u0004r!GA\u0010\u0003G\t)$C\u0002\u0002\"i\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA\u0013\u0003ci!!a\n\u000b\t\u0005%\u00121F\u0001\u0007G>lWn\u001c8\u000b\u0007\u0015\tiCC\u0002\u000201\ta!\u00199bG\",\u0017\u0002BA\u001a\u0003O\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002\u0015\u0003oI1!!\u000f\u0003\u0005Q1U\r^2i!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;vg\"I\u0011Q\b@\u0011\u0002\u0003\u0007\u0011qH\u0001\u000fSN4%o\\7G_2dwn^3s!\rI\u0012\u0011I\u0005\u0004\u0003\u0007R\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u000f\u0002A\u0011BA%\u0003I\u0011W/\u001b7e\r\u0016$8\r['fi\u0006$\u0017\r^1\u0015\u0011\u0005\r\u00111JA'\u0003#Bq!a\u0003\u0002F\u0001\u0007\u0001\u0004\u0003\u0005\u0002P\u0005\u0015\u0003\u0019AA\u0012\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"a\u0004\u0002F\u0001\u0007\u0011Q\u0007\u0005\b\u0003+\u0002A\u0011BA,\u0003y)\u0007\u0010]3diJ+\u0017\r\u001a$s_6\u0014V\r\u001d7jG\u0006<\u0016\u000e\u001e5FeJ|'\u000fF\u0005G\u00033\nY&!\u0018\u0002v!9\u00111BA*\u0001\u0004A\u0002\u0002CA(\u0003'\u0002\r!a\t\t\u0011\u0005}\u00131\u000ba\u0001\u0003C\n!CZ3uG\"\u0004\u0016M\u001d;ji&|g\u000eR1uCB!\u00111MA8\u001d\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$\u0002BA5\u0003O\t\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003[\n9'\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0002r\u0005M$!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u0002n\u0005\u001d\u0004\u0002CA<\u0003'\u0002\r!!\u001f\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{RA!a \u0002(\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u0004\u0006u$AB#se>\u00148\u000fC\u0004\u0002\b\u0002!I!!#\u0002+\u0015D\b/Z2u%\u0016\fGM\u0012:p[J+\u0007\u000f\\5dCR9a)a#\u0002\u000e\u0006=\u0005bBA\u0006\u0003\u000b\u0003\r\u0001\u0007\u0005\t\u0003\u001f\n)\t1\u0001\u0002$!A\u0011qLAC\u0001\u0004\t\t\u0007C\u0004\u0002\u0014\u0002!I!!&\u00021\t,\u0018\u000e\u001c3SK\u0006$'+Z:vYR<\u0016\u000e\u001e5FeJ|'\u000f\u0006\u0003\u0002\u0018\u0006u\u0005c\u0001\u000b\u0002\u001a&\u0019\u00111\u0014\u0002\u0003\u001b1{wMU3bIJ+7/\u001e7u\u0011!\t9(!%A\u0002\u0005e\u0004bBAQ\u0001\u0011%\u00111U\u0001\u001aKb\u0004Xm\u0019;HKR$\u0016.\u001a:GKR\u001c\u0007NU3tk2$8\u000fF\u0004G\u0003K\u000bI,a7\t\u0011\u0005\u001d\u0016q\u0014a\u0001\u0003S\u000bA\u0002]3oI&twMR3uG\"\u0004B!a+\u000266\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,A\u0004gKR\u001c\u0007.\u001a:\u000b\u0007\u0005MF!\u0001\u0003uS\u0016\u0014\u0018\u0002BA\\\u0003[\u0013A\u0002U3oI&twMR3uG\"D\u0001\"a/\u0002 \u0002\u0007\u0011QX\u0001\u0018i>\u0004\u0018n\u0019)beRLG/[8o\u000bb\u001cW\r\u001d;j_:\u0004b!a\u0005\u0002\u001a\u0005}\u0006cB\r\u0002 \u0005\r\u0012\u0011\u0019\t\u00053\u0015\f\u0019\r\u0005\u0003\u0002F\u0006Ug\u0002BAd\u0003#tA!!3\u0002P6\u0011\u00111\u001a\u0006\u0004\u0003\u001b4\u0011A\u0002\u001fs_>$h(C\u0001\u001c\u0013\r\t\u0019NG\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9.!7\u0003\u0013QC'o\\<bE2,'bAAj5!Q\u0011Q\\AP!\u0003\u0005\r!a8\u0002\u000fI,7m\u001c:egB!\u0011\u0011]At\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0012A\u0002:fG>\u0014H-\u0003\u0003\u0002j\u0006\r(!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0002n\u0002!I!a<\u0002-\u0015D\b/Z2u%\u0016\fGM\u0012:p[2{7-\u00197M_\u001e$rARAy\u0003g\u0014)\u0001\u0003\u0004-\u0003W\u0004\rA\f\u0005\t\u0003k\fY\u000f1\u0001\u0002x\u0006qa-\u001a;dQ\u0012\u000bG/Y%oM>\u001c\bCBA\n\u00033\tI\u0010E\u0005\u001a\u0003w\f\u0019#a@\u0002B&\u0019\u0011Q \u000e\u0003\rQ+\b\u000f\\34!\r!\"\u0011A\u0005\u0004\u0005\u0007\u0011!!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007\u000eR1uC&sgm\u001c\u0005\n\u0005\u000f\tY\u000f%AA\u0002\u001d\fQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007b\u0002B\u0006\u0001\u0011%!QB\u0001\u001aEVLG\u000e\u001a$fi\u000eD\u0007+\u0019:uSRLwN\\*uCR,8\u000f\u0006\u0004\u00026\t=!1\u0003\u0005\b\u0005#\u0011I\u00011\u0001h\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u0011\tU!\u0011\u0002a\u0001\u0005/\t\u0011\u0003\\8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b!\r!\"\u0011D\u0005\u0004\u00057\u0011!!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"I!q\u0004\u0001\u0012\u0002\u0013%!\u0011E\u0001+EVLG\u000eZ'vYRL\u0007+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019C\u000b\u0003\u0002@\t\u00152F\u0001B\u0014!\u0011\u0011ICa\r\u000e\u0005\t-\"\u0002\u0002B\u0017\u0005_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tE\"$\u0001\u0006b]:|G/\u0019;j_:LAA!\u000e\u0003,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\te\u0002!%A\u0005\n\tm\u0012aI3ya\u0016\u001cGoR3u)&,'OR3uG\"\u0014Vm];miN$C-\u001a4bk2$HeM\u000b\u0003\u0005{QC!a8\u0003&!I!\u0011\t\u0001\u0012\u0002\u0013%!1I\u0001!Kb\u0004Xm\u0019;SK\u0006$gI]8n\u0019>\u001c\u0017\r\u001c'pO\u0012\"WMZ1vYR$3'\u0006\u0002\u0003F)\u001aqM!\n")
public class DelayedFetchTest
extends EasyMockSupport {
    private final int maxBytes;
    private final MockTime kafka$server$DelayedFetchTest$$mockTime = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)this.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)this.mock(ReplicaQuota.class);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();

    private int maxBytes() {
        return this.maxBytes;
    }

    public MockTime kafka$server$DelayedFetchTest$$mockTime() {
        return this.kafka$server$DelayedFetchTest$$mockTime;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    @After
    public void tearDown() {
        this.brokerTopicStats().close();
    }

    @Test
    public void testMixedTierFetch() {
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        TopicPartition topicPartition1 = new TopicPartition("topic", 1);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, FetchPartitionStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)this.buildFetchPartitionStatus(fetchOffset, new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()))), new Tuple2((Object)topicPartition1, (Object)this.buildFetchPartitionStatus(fetchOffset, LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata()))}))), this.buildMultiPartitionFetchMetadata$default$3());
        PendingFetch pendingFetch = (PendingFetch)this.mock(PendingFetch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1)new Serializable(this, callbackPromise){
            public static final long serialVersionUID = 0L;
            private final Promise callbackPromise$1;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> value) {
                this.callbackPromise$1.success(value);
            }
            {
                this.callbackPromise$1 = callbackPromise$1;
            }
        });
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition1, (Object)None$.MODULE$)}))), this.expectGetTierFetchResults$default$3());
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)topicPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (Object)None$.MODULE$), new Tuple3((Object)topicPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$)}))), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assert.assertTrue((String)"Expected forceComplete to complete the request", (boolean)callbackPromise.isCompleted());
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"Expected both a tiered and non-tiered fetch result", (results.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected HWM to be set for both tiered and non-tiered results", (boolean)results.forall((Function1)new Serializable(this, highWatermark){
            public static final long serialVersionUID = 0L;
            private final int highWatermark$1;

            public final boolean apply(Tuple2<TopicPartition, FetchPartitionData> x0$1) {
                Tuple2<TopicPartition, FetchPartitionData> tuple2 = x0$1;
                if (tuple2 != null) {
                    FetchPartitionData result = (FetchPartitionData)tuple2._2();
                    boolean bl = result.highWatermark() == (long)this.highWatermark$1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.highWatermark$1 = highWatermark$1;
            }
        }));
    }

    @Test
    public void testTierFetcherException() {
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        TopicPartition topicPartition1 = new TopicPartition("topic", 1);
        TopicPartition topicPartition2 = new TopicPartition("topic", 2);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, FetchPartitionStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)this.buildFetchPartitionStatus(fetchOffset, LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata())), new Tuple2((Object)topicPartition1, (Object)this.buildFetchPartitionStatus(fetchOffset, LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata())), new Tuple2((Object)topicPartition2, (Object)this.buildFetchPartitionStatus(fetchOffset, LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata()))}))), this.buildMultiPartitionFetchMetadata$default$3());
        PendingFetch pendingFetch = (PendingFetch)this.mock(PendingFetch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1)new Serializable(this, callbackPromise){
            public static final long serialVersionUID = 0L;
            private final Promise callbackPromise$2;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> value) {
                this.callbackPromise$2.success(value);
            }
            {
                this.callbackPromise$2 = callbackPromise$2;
            }
        });
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)None$.MODULE$), new Tuple2((Object)topicPartition1, (Object)new Some((Object)new UnknownServerException())), new Tuple2((Object)topicPartition2, (Object)new Some((Object)new UnknownServerException()))}))), this.expectGetTierFetchResults$default$3());
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)topicPartition0, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)new Some((Object)new FencedLeaderEpochException(""))), new Tuple3((Object)topicPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), new Tuple3((Object)topicPartition2, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)new Some((Object)new FencedLeaderEpochException("")))}))), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assert.assertTrue((String)"Expected forceComplete to complete the request", (boolean)callbackPromise.isCompleted());
        scala.collection.immutable.Map results = ((TraversableOnce)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap(Predef$.MODULE$.$conforms());
        Assert.assertTrue((String)"Expected 3 fetch results", (results.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected topicPartition0 to return a FencedLeaderException", (Object)((FetchPartitionData)results.apply((Object)topicPartition0)).error(), (Object)Errors.FENCED_LEADER_EPOCH);
        Assert.assertEquals((String)"Expected topicPartition1 to return a UnknownServerErrorException", (Object)((FetchPartitionData)results.apply((Object)topicPartition1)).error(), (Object)Errors.UNKNOWN_SERVER_ERROR);
        Assert.assertEquals((String)"Expected topicPartition2 to return a FencedLeaderException as it takes precedence over TierFetcher exceptions", (Object)((FetchPartitionData)results.apply((Object)topicPartition2)).error(), (Object)Errors.FENCED_LEADER_EPOCH);
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1)new Serializable(this, fetchResultOpt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedFetchTest $outer;
            private final ObjectRef fetchResultOpt$1;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responses) {
                this.$outer.kafka$server$DelayedFetchTest$$callback$1(responses, this.fetchResultOpt$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResultOpt$1 = fetchResultOpt$1;
            }
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition, true)).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andThrow((Throwable)new FencedLeaderEpochException("Requested epoch has been fenced"));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.expectReadFromReplicaWithError(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    @Test
    public void testReplicaNotAvailable() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1)new Serializable(this, fetchResultOpt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedFetchTest $outer;
            private final ObjectRef fetchResultOpt$2;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responses) {
                this.$outer.kafka$server$DelayedFetchTest$$callback$2(responses, this.fetchResultOpt$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResultOpt$2 = fetchResultOpt$2;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition, true)).andThrow((Throwable)new ReplicaNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica for ", " not available"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition}))));
        this.expectReadFromReplicaWithError(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.REPLICA_NOT_AVAILABLE);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    public void checkCompleteWhenFollowerLaggingHW(Option<Object> followerHW, Function1<DelayedFetch, BoxedUnit> checkResult) {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1)new Serializable(this, fetchResultOpt){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedFetchTest $outer;
            private final ObjectRef fetchResultOpt$3;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responses) {
                this.$outer.kafka$server$DelayedFetchTest$$callback$3(responses, this.fetchResultOpt$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchResultOpt$3 = fetchResultOpt$3;
            }
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition, true)).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andReturn((Object)new LogOffsetSnapshot(0L, new LogOffsetMetadata(500L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), new LogOffsetMetadata(480L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), new LogOffsetMetadata(400L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())));
        this.expectReadFromReplica(replicaId, topicPartition, fetchStatus.fetchInfo());
        Replica follower2 = new Replica(replicaId, topicPartition);
        followerHW.foreach((Function1)new Serializable(this, follower2){
            public static final long serialVersionUID = 0L;
            private final Replica follower$1;

            public final void apply(long hw) {
                this.apply$mcVJ$sp(hw);
            }

            public void apply$mcVJ$sp(long hw) {
                this.follower$1.updateFetchState(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), 0L, 0L, 0L, hw);
            }
            {
                this.follower$1 = follower$1;
            }
        });
        EasyMock.expect((Object)partition.getReplica(replicaId)).andReturn((Object)new Some((Object)follower2));
        this.replayAll();
        checkResult.apply((Object)delayedFetch);
    }

    @Test
    public void testCompleteWhenFollowerLaggingHW() {
        this.resetAll();
        this.checkCompleteWhenFollowerLaggingHW((Option<Object>)None$.MODULE$, (Function1<DelayedFetch, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelayedFetch delayedFetch) {
                Assert.assertTrue((boolean)delayedFetch.tryComplete());
                Assert.assertTrue((boolean)delayedFetch.isCompleted());
            }
        });
        this.resetAll();
        this.checkCompleteWhenFollowerLaggingHW((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)500L)), (Function1<DelayedFetch, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelayedFetch delayedFetch) {
                Assert.assertFalse((boolean)delayedFetch.tryComplete());
                Assert.assertFalse((boolean)delayedFetch.isCompleted());
            }
        });
        this.resetAll();
        this.checkCompleteWhenFollowerLaggingHW((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)480L)), (Function1<DelayedFetch, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelayedFetch delayedFetch) {
                Assert.assertFalse((boolean)delayedFetch.tryComplete());
                Assert.assertFalse((boolean)delayedFetch.isCompleted());
            }
        });
        this.resetAll();
        this.checkCompleteWhenFollowerLaggingHW((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)470L)), (Function1<DelayedFetch, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DelayedFetch delayedFetch) {
                Assert.assertTrue((boolean)delayedFetch.tryComplete());
                Assert.assertTrue((boolean)delayedFetch.isCompleted());
            }
        });
    }

    @Test
    public void testFollowerFetchTimeLagNotRecordedAsConsumerFetch() {
        boolean isFromFollower = true;
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, FetchPartitionStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)this.buildFetchPartitionStatus(fetchOffset, new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3())))}))), isFromFollower);
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Option)None$.MODULE$, this.brokerTopicStats(), (Function1)new Serializable(this, callbackPromise){
            public static final long serialVersionUID = 0L;
            private final Promise callbackPromise$3;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> value) {
                this.callbackPromise$3.success(value);
            }
            {
                this.callbackPromise$3 = callbackPromise$3;
            }
        });
        byte[] x$1 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message"})).s((Seq)Nil$.MODULE$).getBytes();
        long x$2 = this.kafka$server$DelayedFetchTest$$mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)topicPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)records2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (Object)None$.MODULE$)}))), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assert.assertTrue((String)"Expected forceComplete to complete the request", (boolean)callbackPromise.isCompleted());
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"Expected tiered fetch result", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Follower fetch is not recorded, snapshot size is 0", (long)0L, (long)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size());
    }

    @Test
    public void testConsumerTierFetchTimeLag() {
        boolean isFromFollower = false;
        int fetchDelta = 3;
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        TopicPartition topicPartition1 = new TopicPartition("topic", 1);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, FetchPartitionStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)this.buildFetchPartitionStatus(fetchOffset, new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()))), new Tuple2((Object)topicPartition1, (Object)this.buildFetchPartitionStatus(fetchOffset, LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata()))}))), isFromFollower);
        PendingFetch pendingFetch = (PendingFetch)this.mock(PendingFetch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1)new Serializable(this, callbackPromise){
            public static final long serialVersionUID = 0L;
            private final Promise callbackPromise$4;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> value) {
                this.callbackPromise$4.success(value);
            }
            {
                this.callbackPromise$4 = callbackPromise$4;
            }
        });
        byte[] x$6 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message"})).s((Seq)Nil$.MODULE$).getBytes();
        long x$7 = this.kafka$server$DelayedFetchTest$$mockTime().milliseconds();
        byte[] x$8 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$9 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$10 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords(x$6, x$8, x$9, x$7, x$10);
        this.kafka$server$DelayedFetchTest$$mockTime().sleep(fetchDelta);
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition1, (Object)None$.MODULE$)}))), records2);
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)topicPartition0, (Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)records2, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (Object)None$.MODULE$), new Tuple3((Object)topicPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$)}))), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assert.assertTrue((String)"Expected forceComplete to complete the request", (boolean)callbackPromise.isCompleted());
        Seq results = (Seq)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"Expected tiered and local fetch result", (long)2L, (long)results.size());
        Assert.assertEquals((String)"Expected size of recorded consumer fetch lag snapshot", (long)2L, (long)this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().size());
        int expectedTimeLagMs = fetchDelta;
        double firstLagTimeMs = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues()).headOption().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return -1.0;
            }
        }));
        Assert.assertEquals((String)"Fetch Time lag last histogram value", (double)expectedTimeLagMs, (double)firstLagTimeMs, (double)0.0);
        double lastLagTimeMs = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.brokerTopicStats().allTopicsStats().consumerFetchLagTimeMs().getSnapshot().getValues()).lastOption().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return -1.0;
            }
        }));
        Assert.assertEquals((String)"Fetch Time lag last histogram value", (double)expectedTimeLagMs, (double)lastLagTimeMs, (double)0.0);
    }

    @Test
    public void testLocalSegmentDeletedAfterDelayedFetchCreation() {
        TopicPartition topicPartition0 = new TopicPartition("topic", 0);
        TopicPartition topicPartition1 = new TopicPartition("topic", 1);
        int replicaId = 1;
        long fetchOffset = 500L;
        int highWatermark = 50;
        FetchMetadata fetchMetadata = this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, FetchPartitionStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition0, (Object)this.buildFetchPartitionStatus(fetchOffset, new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3()))), new Tuple2((Object)topicPartition1, (Object)this.buildFetchPartitionStatus(fetchOffset, new LogOffsetMetadata(0L, 0L, LogOffsetMetadata$.MODULE$.apply$default$3())))}))), this.buildMultiPartitionFetchMetadata$default$3());
        PendingFetch pendingFetch = (PendingFetch)this.mock(PendingFetch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)pendingFetch.isComplete())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        pendingFetch.cancel();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Promise callbackPromise = Promise$.MODULE$.apply();
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)new Some((Object)pendingFetch), (Option)None$.MODULE$, this.brokerTopicStats(), (Function1)new Serializable(this, callbackPromise){
            public static final long serialVersionUID = 0L;
            private final Promise callbackPromise$5;

            public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> value) {
                this.callbackPromise$5.success(value);
            }
            {
                this.callbackPromise$5 = callbackPromise$5;
            }
        });
        this.expectGetTierFetchResults(pendingFetch, (Seq<Tuple2<TopicPartition, Option<Throwable>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition1, (Object)None$.MODULE$)}))), this.expectGetTierFetchResults$default$3());
        this.expectReadFromLocalLog(this.replicaManager(), (Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)topicPartition0, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$), new Tuple3((Object)topicPartition1, (Object)new TierFetchDataInfo(null, (Option)None$.MODULE$), (Object)None$.MODULE$)}))), highWatermark);
        this.replayAll();
        delayedFetch.forceComplete();
        Assert.assertTrue((String)"Expected forceComplete to complete the request", (boolean)callbackPromise.isCompleted());
        scala.collection.immutable.Map results = ((TraversableOnce)Await$.MODULE$.result((Awaitable)callbackPromise.future(), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.SECONDS))).toMap(Predef$.MODULE$.$conforms());
        Assert.assertTrue((String)"Expected both a tiered and non-tiered fetch result", (results.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected HWM to be set for both tiered and non-tiered results", (boolean)results.forall((Function1)new Serializable(this, highWatermark){
            public static final long serialVersionUID = 0L;
            private final int highWatermark$3;

            public final boolean apply(Tuple2<TopicPartition, FetchPartitionData> x0$2) {
                Tuple2<TopicPartition, FetchPartitionData> tuple2 = x0$2;
                if (tuple2 != null) {
                    FetchPartitionData result = (FetchPartitionData)tuple2._2();
                    boolean bl = result.highWatermark() == (long)this.highWatermark$3;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.highWatermark$3 = highWatermark$3;
            }
        }));
        Assert.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicPartition0)).records(), (Object)MemoryRecords.EMPTY);
        Assert.assertEquals((Object)((FetchPartitionData)results.apply((Object)topicPartition1)).records(), (Object)MemoryRecords.EMPTY);
    }

    private FetchMetadata buildMultiPartitionFetchMetadata(int replicaId, Seq<Tuple2<TopicPartition, FetchPartitionStatus>> fetchPartitionStatus, boolean isFromFollower) {
        return new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchLogEnd$.MODULE$, isFromFollower, replicaId, fetchPartitionStatus);
    }

    private boolean buildMultiPartitionFetchMetadata$default$3() {
        return true;
    }

    private FetchMetadata buildFetchMetadata(int replicaId, TopicPartition topicPartition, FetchPartitionStatus fetchPartitionStatus) {
        return this.buildMultiPartitionFetchMetadata(replicaId, (Seq<Tuple2<TopicPartition, FetchPartitionStatus>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchPartitionStatus)}))), this.buildMultiPartitionFetchMetadata$default$3());
    }

    private void expectReadFromReplicaWithError(int replicaId, TopicPartition topicPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        int x$11 = replicaId;
        boolean x$12 = true;
        FetchLogEnd$ x$13 = FetchLogEnd$.MODULE$;
        int x$14 = this.maxBytes();
        boolean x$15 = false;
        Seq x$16 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchPartitionData)}));
        None$ x$17 = None$.MODULE$;
        ReplicaQuota x$18 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(x$11, x$12, (FetchIsolation)x$13, x$14, x$15, x$16, x$18, (Option)x$17)).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)this.buildReadResultWithError(error))})));
    }

    private void expectReadFromReplica(int replicaId, TopicPartition topicPartition, FetchRequest.PartitionData fetchPartitionData) {
        None$ x$19 = None$.MODULE$;
        FetchDataInfo x$20 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        long x$21 = -1L;
        long x$22 = -1L;
        long x$23 = -1L;
        long x$24 = -1L;
        long x$25 = -1L;
        boolean x$26 = false;
        int x$27 = -1;
        None$ x$28 = None$.MODULE$;
        Option x$29 = LogReadResult$.MODULE$.apply$default$10();
        boolean x$30 = LogReadResult$.MODULE$.apply$default$11();
        LogReadResult result = new LogReadResult(x$20, x$21, x$22, x$23, x$24, x$25, x$27, (Option)x$28, x$26, x$29, x$30, (Option)x$19);
        int x$31 = replicaId;
        boolean x$32 = true;
        FetchLogEnd$ x$33 = FetchLogEnd$.MODULE$;
        int x$34 = this.maxBytes();
        boolean x$35 = false;
        Seq x$36 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)fetchPartitionData)}));
        None$ x$37 = None$.MODULE$;
        ReplicaQuota x$38 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(x$31, x$32, (FetchIsolation)x$33, x$34, x$35, x$36, x$38, (Option)x$37)).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)topicPartition, (Object)result)}))).anyTimes();
    }

    private LogReadResult buildReadResultWithError(Errors error) {
        Some x$39 = new Some((Object)error.exception());
        FetchDataInfo x$40 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        long x$41 = -1L;
        long x$42 = -1L;
        long x$43 = -1L;
        long x$44 = -1L;
        long x$45 = -1L;
        boolean x$46 = false;
        int x$47 = -1;
        None$ x$48 = None$.MODULE$;
        Option x$49 = LogReadResult$.MODULE$.apply$default$10();
        boolean x$50 = LogReadResult$.MODULE$.apply$default$11();
        return new LogReadResult(x$40, x$41, x$42, x$43, x$44, x$45, x$47, (Option)x$48, x$46, x$49, x$50, (Option)x$39);
    }

    private void expectGetTierFetchResults(PendingFetch pendingFetch, Seq<Tuple2<TopicPartition, Option<Throwable>>> topicPartitionException, MemoryRecords records2) {
        java.util.Map results = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topicPartitionException.map((Function1)new Serializable(this, records2){
            public static final long serialVersionUID = 0L;
            private final MemoryRecords records$1;

            public final Tuple2<TopicPartition, TierFetchResult> apply(Tuple2<TopicPartition, Option<Throwable>> x0$3) {
                Tuple2<TopicPartition, Option<Throwable>> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    Option exceptionOpt = (Option)tuple2._2();
                    if (topicPartition != null) {
                        TopicPartition topicPartition2 = topicPartition;
                        if (exceptionOpt != null) {
                            Option option = exceptionOpt;
                            Tuple2 tuple22 = new Tuple2((Object)topicPartition2, (Object)new TierFetchResult((Records)this.records$1, Collections.<T>emptyList(), (Throwable)option.orNull(Predef$.MODULE$.$conforms())));
                            return tuple22;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.records$1 = records$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        EasyMock.expect((Object)pendingFetch.finish()).andReturn((Object)results);
    }

    private MemoryRecords expectGetTierFetchResults$default$3() {
        return MemoryRecords.EMPTY;
    }

    private void expectReadFromLocalLog(ReplicaManager replicaManager, Seq<Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>>> fetchDataInfos, long highWatermark) {
        Seq readResults = (Seq)fetchDataInfos.map((Function1)new Serializable(this, highWatermark){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedFetchTest $outer;
            private final long highWatermark$2;

            public final Tuple2<TopicPartition, Product> apply(Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>> x0$4) {
                Tuple3<TopicPartition, AbstractFetchDataInfo, Option<Throwable>> tuple3;
                block4: {
                    Tuple2 tuple2;
                    block3: {
                        block2: {
                            tuple3 = x0$4;
                            if (tuple3 == null) break block2;
                            TopicPartition tp = (TopicPartition)tuple3._1();
                            AbstractFetchDataInfo tierFetchDataInfo = (AbstractFetchDataInfo)tuple3._2();
                            Option exceptionOpt = (Option)tuple3._3();
                            if (!(tierFetchDataInfo instanceof TierFetchDataInfo)) break block2;
                            TierFetchDataInfo tierFetchDataInfo2 = (TierFetchDataInfo)tierFetchDataInfo;
                            if (exceptionOpt == null) break block2;
                            Option option = exceptionOpt;
                            tuple2 = new Tuple2((Object)tp, (Object)new TierLogReadResult(tierFetchDataInfo2, this.highWatermark$2, 0L, 0L, 0L, this.$outer.kafka$server$DelayedFetchTest$$mockTime().milliseconds(), 0, (Option)None$.MODULE$, (Option)None$.MODULE$, option));
                            break block3;
                        }
                        if (tuple3 == null) break block4;
                        TopicPartition tp = (TopicPartition)tuple3._1();
                        AbstractFetchDataInfo fetchDataInfo = (AbstractFetchDataInfo)tuple3._2();
                        Option exceptionOpt = (Option)tuple3._3();
                        if (!(fetchDataInfo instanceof FetchDataInfo)) break block4;
                        FetchDataInfo fetchDataInfo2 = (FetchDataInfo)fetchDataInfo;
                        if (exceptionOpt == null) break block4;
                        Option option = exceptionOpt;
                        tuple2 = new Tuple2((Object)tp, (Object)new LogReadResult(fetchDataInfo2, this.highWatermark$2, 0L, 0L, 0L, this.$outer.kafka$server$DelayedFetchTest$$mockTime().milliseconds(), 0, (Option)None$.MODULE$, true, (Option)None$.MODULE$, false, option));
                    }
                    return tuple2;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.highWatermark$2 = highWatermark$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).anyTimes();
        EasyMock.expect((Object)replicaManager.readFromLocalLog(BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (FetchIsolation)EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Option)EasyMock.anyObject())).andReturn((Object)readResults);
    }

    private long expectReadFromLocalLog$default$3() {
        return 0L;
    }

    private FetchPartitionStatus buildFetchPartitionStatus(long fetchOffset, LogOffsetMetadata logOffsetMetadata) {
        return new FetchPartitionStatus(logOffsetMetadata, new FetchRequest.PartitionData(fetchOffset, 0L, Integer.MAX_VALUE, Optional.empty()));
    }

    public final void kafka$server$DelayedFetchTest$$callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    public final void kafka$server$DelayedFetchTest$$callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    public final void kafka$server$DelayedFetchTest$$callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

