/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedFuture;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedOperationTest;
import kafka.server.DelayedOperationTest$;
import kafka.server.DelayedOperationTest$MockDelayedOperation$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012!\u00039ve\u001e\fGo\u001c:z+\u00051\u0002c\u0001\n\u00183%\u0011\u0001D\u0001\u0002\u001a\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u0004VO]4bi>\u0014\u0018\u0010\u0005\u0002\u001b75\t\u0001A\u0002\u0003\u001d\u0001\u0001i\"\u0001F'pG.$U\r\\1zK\u0012|\u0005/\u001a:bi&|gn\u0005\u0002\u001c=A\u0011!cH\u0005\u0003A\t\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\t\u0013\tZ\"\u0011!Q\u0001\n\r2\u0013a\u00023fY\u0006LXj\u001d\t\u0003\u0013\u0011J!!\n\u0006\u0003\t1{gnZ\u0005\u0003E}A\u0001\u0002K\u000e\u0003\u0002\u0003\u0006I!K\u0001\bY>\u001c7n\u00149u!\rI!\u0006L\u0005\u0003W)\u0011aa\u00149uS>t\u0007CA\u00177\u001b\u0005q#BA\u00181\u0003\u0015awnY6t\u0015\t\t$'\u0001\u0006d_:\u001cWO\u001d:f]RT!a\r\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002k\u0005!!.\u0019<b\u0013\t9dFA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\tsm\u0011)\u0019!C\u0001u\u0005y!/Z:q_:\u001cX\rT8dW>\u0003H/F\u0001*\u0011!a4D!A!\u0002\u0013I\u0013\u0001\u0005:fgB|gn]3M_\u000e\\w\n\u001d;!\u0011\u0015y1\u0004\"\u0001?)\u0011Ir\bQ!\t\u000b\tj\u0004\u0019A\u0012\t\u000f!j\u0004\u0013!a\u0001S!9\u0011(\u0010I\u0001\u0002\u0004I\u0003bB\"\u001c\u0001\u0004%\t\u0001R\u0001\fG>l\u0007\u000f\\3uC\ndW-F\u0001F!\tIa)\u0003\u0002H\u0015\t9!i\\8mK\u0006t\u0007bB%\u001c\u0001\u0004%\tAS\u0001\u0010G>l\u0007\u000f\\3uC\ndWm\u0018\u0013fcR\u00111J\u0014\t\u0003\u00131K!!\u0014\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u001f\"\u000b\t\u00111\u0001F\u0003\rAH%\r\u0005\u0007#n\u0001\u000b\u0015B#\u0002\u0019\r|W\u000e\u001d7fi\u0006\u0014G.\u001a\u0011\t\u000bM[B\u0011\u0001+\u0002\u001f\u0005<\u0018-\u001b;FqBL'/\u0019;j_:$\u0012a\u0013\u0005\u0006-n!\teV\u0001\fiJL8i\\7qY\u0016$X\rF\u0001F\u0011\u0015I6\u0004\"\u0011U\u00031yg.\u0012=qSJ\fG/[8o\u0011\u0015Y6\u0004\"\u0011U\u0003)ygnQ8na2,G/\u001a\u0005\b;\u0002\u0001\r\u0011\"\u0001_\u00035\u0001XO]4bi>\u0014\u0018p\u0018\u0013fcR\u00111j\u0018\u0005\b\u001fr\u000b\t\u00111\u0001\u0017\u0011\u0019\t\u0007\u0001)Q\u0005-\u0005Q\u0001/\u001e:hCR|'/\u001f\u0011\t\u000f\r\u0004\u0001\u0019!C\u0001I\u0006yQ\r_3dkR|'oU3sm&\u001cW-F\u0001f!\t1w-D\u00011\u0013\tA\u0007GA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011\u001dQ\u0007\u00011A\u0005\u0002-\f1#\u001a=fGV$xN]*feZL7-Z0%KF$\"a\u00137\t\u000f=K\u0017\u0011!a\u0001K\"1a\u000e\u0001Q!\n\u0015\f\u0001#\u001a=fGV$xN]*feZL7-\u001a\u0011\t\u000bA\u0004A\u0011\u0001+\u0002\u000bM,G/\u00169)\u0005=\u0014\bCA:y\u001b\u0005!(BA;w\u0003\u0015QWO\\5u\u0015\u00059\u0018aA8sO&\u0011\u0011\u0010\u001e\u0002\u0007\u0005\u00164wN]3\t\u000bm\u0004A\u0011\u0001+\u0002\u0011Q,\u0017M\u001d#po:D#A_?\u0011\u0005Mt\u0018BA@u\u0005\u0015\te\r^3s\u0011\u0019\t\u0019\u0001\u0001C\u0001)\u00069B/Z:u%\u0016\fX/Z:u'\u0006$\u0018n\u001d4bGRLwN\u001c\u0015\u0005\u0003\u0003\t9\u0001E\u0002t\u0003\u0013I1!a\u0003u\u0005\u0011!Vm\u001d;\t\r\u0005=\u0001\u0001\"\u0001U\u0003E!Xm\u001d;SKF,Xm\u001d;FqBL'/\u001f\u0015\u0005\u0003\u001b\t9\u0001\u0003\u0004\u0002\u0016\u0001!\t\u0001V\u0001\u0012i\u0016\u001cH\u000fR3mCf,GMR;ukJ,\u0007\u0006BA\n\u0003\u000fAa!a\u0007\u0001\t\u0003!\u0016\u0001\u0005;fgR\u0014V-];fgR\u0004VO]4fQ\u0011\tI\"a\u0002\t\r\u0005\u0005\u0002\u0001\"\u0001U\u00039\u001a\bn\\;mI\u000e\u000bgnY3m\r>\u00148*Z=SKR,(O\\5oO\u000e\u000bgnY3mY\u0016$w\n]3sCRLwN\\:)\t\u0005}\u0011q\u0001\u0005\u0007\u0003O\u0001A\u0011\u0001+\u0002sMDw.\u001e7e%\u0016$XO\u001d8OS2|\u0005/\u001a:bi&|gn](o\u0007\u0006t7-\u001a7G_J\\U-_,iK:\\U-\u001f#pKNtG/\u0012=jgRDC!!\n\u0002\b!1\u0011Q\u0006\u0001\u0005\u0002Q\u000bQ\u0004^3tiR\u0013\u0018pQ8na2,G/\u001a'pG.\u001cuN\u001c;f]RLwN\u001c\u0015\u0005\u0003W\t9\u0001\u0003\u0004\u00024\u0001!\t\u0001V\u0001#i\u0016\u001cH\u000f\u0016:z\u0007>l\u0007\u000f\\3uK^KG\u000f['vYRL\u0007\u000f\\3UQJ,\u0017\rZ:)\t\u0005E\u0012q\u0001\u0005\u0007\u0003s\u0001A\u0011\u0001+\u00021Q,7\u000f\u001e#fY\u0006LX\rZ(qKJ\fG/[8o\u0019>\u001c7\u000e\u000b\u0003\u00028\u0005\u001d\u0001BBA \u0001\u0011\u0005A+\u0001\u0011uKN$H)\u001a7bs\u0016$w\n]3sCRLwN\u001c'pG.|e/\u001a:sS\u0012,\u0007\u0006BA\u001f\u0003\u000fAq!!\u0012\u0001\t\u0003\t9%\u0001\u000ewKJLg-\u001f#fY\u0006LX\rZ(qKJ\fG/[8o\u0019>\u001c7\u000eF\u0003L\u0003\u0013\n\u0019\u0006C\u0005\u0002L\u0005\rC\u00111\u0001\u0002N\u0005!Rn\\2l\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u0004B!CA(3%\u0019\u0011\u0011\u000b\u0006\u0003\u0011q\u0012\u0017P\\1nKzBq!!\u0016\u0002D\u0001\u0007Q)A\bnSNl\u0017\r^2iK\u0012dunY6t\u0011\u001d\tI\u0006\u0001C\u0005\u00037\n!C];o\u001f:\fen\u001c;iKJ$\u0006N]3bIR1\u0011QLA>\u0003\u0003\u0003D!a\u0018\u0002jA)a-!\u0019\u0002f%\u0019\u00111\r\u0019\u0003\r\u0019+H/\u001e:f!\u0011\t9'!\u001b\r\u0001\u0011a\u00111NA,\u0003\u0003\u0005\tQ!\u0001\u0002n\t\u0019q\f\n\u001a\u0012\t\u0005=\u0014Q\u000f\t\u0004\u0013\u0005E\u0014bAA:\u0015\t9aj\u001c;iS:<\u0007cA\u0005\u0002x%\u0019\u0011\u0011\u0010\u0006\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002~\u0005]C\u00111\u0001\u0002\u0000\u0005\u0019a-\u001e8\u0011\t%\tye\u0013\u0005\b\u0003\u0007\u000b9\u00061\u0001F\u00039\u0019\bn\\;mI\u000e{W\u000e\u001d7fi\u0016<\u0011\"a\"\u0001\u0003\u0003E\t!!#\u0002)5{7m\u001b#fY\u0006LX\rZ(qKJ\fG/[8o!\rQ\u00121\u0012\u0004\t9\u0001\t\t\u0011#\u0001\u0002\u000eN\u0019\u00111\u0012\u0005\t\u000f=\tY\t\"\u0001\u0002\u0012R\u0011\u0011\u0011\u0012\u0005\u000b\u0003+\u000bY)%A\u0005\u0002\u0005]\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u001a*\u001a\u0011&a',\u0005\u0005u\u0005\u0003BAP\u0003Sk!!!)\u000b\t\u0005\r\u0016QU\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a*\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\u000b\tKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a,\u0002\fF\u0005I\u0011AAL\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class DelayedOperationTest {
    private DelayedOperationPurgatory<MockDelayedOperation> purgatory = null;
    private ExecutorService executorService = null;
    private volatile DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$lzycompute() {
        DelayedOperationTest delayedOperationTest = this;
        synchronized (delayedOperationTest) {
            if (this.MockDelayedOperation$module != null) return this.MockDelayedOperation$module;
            this.MockDelayedOperation$module = new DelayedOperationTest$MockDelayedOperation$(this);
            return this.MockDelayedOperation$module;
        }
    }

    public DelayedOperationPurgatory<MockDelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<MockDelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public void executorService_$eq(ExecutorService x$1) {
        this.executorService = x$1;
    }

    @Before
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<MockDelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", DelayedOperationPurgatory$.MODULE$.apply$default$2(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()));
    }

    @After
    public void tearDown() {
        this.purgatory().shutdown();
        if (this.executorService() != null) {
            this.executorService().shutdown();
        }
    }

    @Test
    public void testRequestSatisfaction() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        r1.completable_$eq(true);
        Assert.assertEquals((String)"r1 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        r2.completable_$eq(true);
        Assert.assertEquals((String)"r2 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start2 = Time.SYSTEM.hiResClockMs();
        MockDelayedOperation r1 = new MockDelayedOperation(this, expiration, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 200000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start2;
        Assert.assertTrue((String)"r1 completed due to expiration", (boolean)r1.isCompleted());
        Assert.assertFalse((String)"r2 hasn't completed", (boolean)r2.isCompleted());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time for expiration ", " should at least ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)elapsed), BoxesRunTime.boxToLong((long)expiration)})), (elapsed >= expiration ? 1 : 0) != 0);
    }

    @Test
    public void testDelayedFuture() {
        String purgatoryName = "testDelayedFuture";
        DelayedFuturePurgatory purgatory = new DelayedFuturePurgatory(purgatoryName, 0);
        AtomicInteger result = new AtomicInteger();
        Assert.assertFalse((String)"Unnecessary thread created", (boolean)this.hasExecutorThread$1(purgatoryName));
        List futures1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompletableFuture[]{CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)10)), CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)11))}));
        DelayedFuture r1 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures1, (Function0)new Serializable(this, result, futures1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final AtomicInteger result$1;
            private final List futures1$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$DelayedOperationTest$$updateResult$1(this.futures1$1, this.result$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                this.futures1$1 = futures1$1;
            }
        });
        Assert.assertTrue((String)"r1 not completed", (boolean)r1.isCompleted());
        Assert.assertEquals((long)21L, (long)result.get());
        Assert.assertFalse((String)"Unnecessary thread created", (boolean)this.hasExecutorThread$1(purgatoryName));
        result.set(-1);
        List futures2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompletableFuture[]{new CompletableFuture(), new CompletableFuture()}));
        DelayedFuture r2 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures2, (Function0)new Serializable(this, result, futures2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final AtomicInteger result$1;
            private final List futures2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$DelayedOperationTest$$updateResult$1(this.futures2$1, this.result$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                this.futures2$1 = futures2$1;
            }
        });
        Assert.assertFalse((String)"r2 should be incomplete", (boolean)r2.isCompleted());
        ((CompletableFuture)futures2.head()).complete(Predef$.MODULE$.int2Integer(20));
        Assert.assertFalse((boolean)r2.isCompleted());
        Assert.assertEquals((long)-1L, (long)result.get());
        ((CompletableFuture)futures2.apply(1)).complete(Predef$.MODULE$.int2Integer(21));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, r2){
            public static final long serialVersionUID = 0L;
            private final DelayedFuture r2$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.r2$1.isCompleted();
            }
            {
                this.r2$1 = r2$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "r2 not completed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final AtomicInteger result$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.result$1.get() == 41;
            }
            {
                this.result$1 = result$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "callback not invoked";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((String)"Thread not created for executing delayed task", (boolean)this.hasExecutorThread$1(purgatoryName));
        result.set(-1);
        List futures3 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompletableFuture[]{new CompletableFuture(), CompletableFuture.completedFuture(BoxesRunTime.boxToInteger((int)31))}));
        DelayedFuture r3 = purgatory.tryCompleteElseWatch(100000L, (Seq)futures3, (Function0)new Serializable(this, result, futures3){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final AtomicInteger result$1;
            private final List futures3$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$DelayedOperationTest$$updateResult$1(this.futures3$1, this.result$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                this.futures3$1 = futures3$1;
            }
        });
        Assert.assertFalse((String)"r3 should be incomplete", (boolean)r3.isCompleted());
        Assert.assertEquals((long)-1L, (long)result.get());
        ((CompletableFuture)futures3.head()).complete(Predef$.MODULE$.int2Integer(30));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, r3){
            public static final long serialVersionUID = 0L;
            private final DelayedFuture r3$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.r3$1.isCompleted();
            }
            {
                this.r3$1 = r3$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "r3 not completed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final AtomicInteger result$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.result$1.get() == 61;
            }
            {
                this.result$1 = result$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "callback not invoked";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        result.set(-1);
        long start2 = Time.SYSTEM.hiResClockMs();
        long expirationMs = 2000L;
        List futures4 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CompletableFuture[]{new CompletableFuture(), new CompletableFuture()}));
        DelayedFuture r4 = purgatory.tryCompleteElseWatch(expirationMs, (Seq)futures4, (Function0)new Serializable(this, result, futures4){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final AtomicInteger result$1;
            private final List futures4$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$DelayedOperationTest$$updateResult$1(this.futures4$1, this.result$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.result$1 = result$1;
                this.futures4$1 = futures4$1;
            }
        });
        ((CompletableFuture)futures4.head()).complete(Predef$.MODULE$.int2Integer(40));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, futures4){
            public static final long serialVersionUID = 0L;
            private final List futures4$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((CompletableFuture)this.futures4$1.apply(1)).isDone();
            }
            {
                this.futures4$1 = futures4$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "r4 futures not expired";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((String)"r4 not completed after timeout", (boolean)r4.isCompleted());
        long elapsed = Time.SYSTEM.hiResClockMs() - start2;
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Time for expiration ", " should at least ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)elapsed), BoxesRunTime.boxToLong((long)expirationMs)})), (elapsed >= expirationMs ? 1 : 0) != 0);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)40), ((CompletableFuture)futures4.head()).get());
        Assert.assertEquals(TimeoutException.class, ((Throwable)Assertions$.MODULE$.intercept((Function0)new Serializable(this, futures4){
            public static final long serialVersionUID = 0L;
            private final List futures4$1;

            public final Integer apply() {
                return (Integer)((CompletableFuture)this.futures4$1.apply(1)).get();
            }
            {
                this.futures4$1 = futures4$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("DelayedOperationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141))).getCause().getClass());
        Assert.assertEquals((long)40L, (long)result.get());
    }

    @Test
    public void testRequestPurge() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r3 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assert.assertEquals((String)"Purgatory should have 3 total delayed operations", (long)3L, (long)this.purgatory().numDelayed());
        Assert.assertEquals((String)"Purgatory should have 6 watched elements", (long)6L, (long)this.purgatory().watched());
        r2.completable_$eq(true);
        r2.tryComplete();
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 2 total delayed operations instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().numDelayed())).toString(), (long)2L, (long)this.purgatory().numDelayed());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 1 total delayed operations instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().numDelayed())).toString(), (long)1L, (long)this.purgatory().numDelayed());
        this.purgatory().checkAndComplete((Object)"test1");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 4 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)4L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test2");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 2 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)2L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test3");
        Assert.assertEquals((String)new StringBuilder().append((Object)"Purgatory should have 1 watched elements instead of ").append((Object)BoxesRunTime.boxToInteger((int)this.purgatory().watched())).toString(), (long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key2"})));
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((long)2L, (long)cancelledOperations.size());
        Assert.assertEquals((long)1L, (long)this.purgatory().numDelayed());
        Assert.assertEquals((long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)cancelledOperations);
    }

    @Test
    public void testTryCompleteLockContention() {
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        AtomicInteger completionAttemptsRemaining = new AtomicInteger(Integer.MAX_VALUE);
        Semaphore tryCompleteSemaphore = new Semaphore(1);
        String key = "key";
        MockDelayedOperation op = new MockDelayedOperation(this, completionAttemptsRemaining, tryCompleteSemaphore){
            private final AtomicInteger completionAttemptsRemaining$1;
            private final Semaphore tryCompleteSemaphore$1;

            public boolean tryComplete() {
                boolean shouldComplete = this.completionAttemptsRemaining$1.decrementAndGet() <= 0;
                this.tryCompleteSemaphore$1.acquire();
                try {
                    boolean bl = shouldComplete ? this.forceComplete() : false;
                    return bl;
                }
                finally {
                    this.tryCompleteSemaphore$1.release();
                }
            }
            {
                this.completionAttemptsRemaining$1 = completionAttemptsRemaining$1;
                this.tryCompleteSemaphore$1 = tryCompleteSemaphore$1;
                super($outer, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
            }
        };
        this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key})));
        completionAttemptsRemaining.set(2);
        tryCompleteSemaphore.acquire();
        Future<?> future = this.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final String key$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.purgatory().checkAndComplete((Object)this.key$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
            }
        }, false);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tryCompleteSemaphore){
            public static final long serialVersionUID = 0L;
            private final Semaphore tryCompleteSemaphore$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.tryCompleteSemaphore$1.hasQueuedThreads();
            }
            {
                this.tryCompleteSemaphore$1 = tryCompleteSemaphore$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Not attempting to complete";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.purgatory().checkAndComplete((Object)key);
        Assert.assertFalse((String)"Operation should not have completed", (boolean)op.isCompleted());
        tryCompleteSemaphore.release();
        future.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
    }

    @Test
    public void testTryCompleteWithMultipleThreads() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(20);
        this.executorService_$eq(executor);
        Random random = new Random();
        int maxDelayMs = 10;
        int completionAttempts = 20;
        IndexedSeq ops = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1)new Serializable(this, random, maxDelayMs, completionAttempts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Random random$1;
            private final int maxDelayMs$1;
            private final int completionAttempts$1;

            /*
             * WARNING - void declaration
             */
            public final TestDelayOperation.1 apply(int index) {
                void var2_2;
                public class Kafka_server_DelayedOperationTest$TestDelayOperation$1
                extends MockDelayedOperation {
                    private final String key;
                    private final AtomicInteger completionAttemptsRemaining;
                    public final /* synthetic */ DelayedOperationTest $outer;
                    private final Random random$1;
                    private final int maxDelayMs$1;

                    public String key() {
                        return this.key;
                    }

                    public AtomicInteger completionAttemptsRemaining() {
                        return this.completionAttemptsRemaining;
                    }

                    public boolean tryComplete() {
                        boolean shouldComplete = this.completable();
                        Thread.sleep(this.random$1.nextInt(this.maxDelayMs$1));
                        return shouldComplete ? this.forceComplete() : false;
                    }

                    public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$TestDelayOperation$$$outer() {
                        return this.$outer;
                    }

                    public Kafka_server_DelayedOperationTest$TestDelayOperation$1(DelayedOperationTest $outer, int index, Random random$1, int maxDelayMs$1, int completionAttempts$1) {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.random$1 = random$1;
                        this.maxDelayMs$1 = maxDelayMs$1;
                        super($outer, 10000L, $outer.MockDelayedOperation().$lessinit$greater$default$2(), $outer.MockDelayedOperation().$lessinit$greater$default$3());
                        this.key = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                        this.completionAttemptsRemaining = new AtomicInteger(completionAttempts$1);
                    }
                }
                Kafka_server_DelayedOperationTest$TestDelayOperation$1 op = new Kafka_server_DelayedOperationTest$TestDelayOperation$1(this.$outer, index, this.random$1, this.maxDelayMs$1, this.completionAttempts$1);
                this.$outer.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{op.key()})));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.random$1 = random$1;
                this.maxDelayMs$1 = maxDelayMs$1;
                this.completionAttempts$1 = completionAttempts$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), completionAttempts).flatMap((Function1)new Serializable(this, executor, random, maxDelayMs, ops){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            public final ScheduledExecutorService executor$1;
            public final Random random$1;
            public final int maxDelayMs$1;
            private final IndexedSeq ops$1;

            public final IndexedSeq<Future<?>> apply(int x$5) {
                return (IndexedSeq)this.ops$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTryCompleteWithMultipleThreads$1 $outer;

                    public final Future<?> apply(TestDelayOperation.1 op) {
                        return this.$outer.kafka$server$DelayedOperationTest$$anonfun$$$outer().kafka$server$DelayedOperationTest$$scheduleTryComplete$1(op, this.$outer.random$1.nextInt(this.$outer.maxDelayMs$1), this.$outer.executor$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executor$1 = executor$1;
                this.random$1 = random$1;
                this.maxDelayMs$1 = maxDelayMs$1;
                this.ops$1 = ops$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Future<?> future) {
                return future.get();
            }
        });
        ops.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TestDelayOperation.1 op) {
                Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
            }
        });
    }

    @Test
    public void testDelayedOperationLock() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;

            public final MockDelayedOperation apply() {
                return new MockDelayedOperation(this.$outer, 100000L, this.$outer.MockDelayedOperation().$lessinit$greater$default$2(), this.$outer.MockDelayedOperation().$lessinit$greater$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, false);
    }

    @Test
    public void testDelayedOperationLockOverride() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;

            public final MockDelayedOperation apply() {
                return this.$outer.kafka$server$DelayedOperationTest$$newMockOperation$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, false);
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;

            public final MockDelayedOperation apply() {
                return new MockDelayedOperation(this.$outer, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)new Some((Object)new ReentrantLock()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, true);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDelayedOperationLock(Function0<MockDelayedOperation> mockDelayedOperation, boolean mismatchedLocks) {
        String key = "key";
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        ObjectRef ops = ObjectRef.create((Object)this.createDelayedOperations$1(2, mockDelayedOperation, key));
        this.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)ops.elem, (Seq)ops.elem, key);
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        CoreUtils$.MODULE$.inLock(((DelayedOperation)((Seq)ops.elem).apply(1)).lock(), (Function0)new Serializable(this, key, ops){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final String key$2;
            private final ObjectRef ops$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)this.ops$2.elem, (Seq)this.ops$2.elem, this.key$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$2 = key$2;
                this.ops$2 = ops$2;
            }
        });
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        this.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, ops){
            public static final long serialVersionUID = 0L;
            private final ObjectRef ops$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((DelayedOperation)((Seq)this.ops$2.elem).apply(0)).lock().lock();
            }
            {
                this.ops$2 = ops$2;
            }
        }, true);
        try {
            this.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)ops.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(1))})), key);
            this.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, ops){
                public static final long serialVersionUID = 0L;
                private final ObjectRef ops$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ((DelayedOperation)((Seq)this.ops$2.elem).apply(0)).lock().unlock();
                }
                {
                    this.ops$2 = ops$2;
                }
            }, true);
        }
        catch (Throwable throwable) {
            void var3_3;
            void var4_4;
            this.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, true);
            this.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)var4_4.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)var4_4.elem).apply(0))})), (String)var3_3);
            throw throwable;
        }
        this.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), key);
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        ((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))).responseLockOpt().foreach((Function1)new Serializable(this, mismatchedLocks, key, ops){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final boolean mismatchedLocks$1;
            private final String key$2;
            private final ObjectRef ops$2;

            public final void apply(ReentrantLock lock) {
                this.$outer.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, lock){
                    public static final long serialVersionUID = 0L;
                    private final ReentrantLock lock$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.lock$1.lock();
                    }
                    {
                        this.lock$1 = lock$1;
                    }
                }, true);
                try {
                    try {
                        this.$outer.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)this.ops$2.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(1))})), this.key$2);
                        Assert.assertFalse((String)"Should have failed with mismatched locks", (boolean)this.mismatchedLocks$1);
                    }
                    catch (IllegalStateException illegalStateException) {
                        Assert.assertTrue((String)"Should not have failed with valid locks", (boolean)this.mismatchedLocks$1);
                    }
                }
                catch (Throwable throwable) {
                    this.$outer.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new Serializable(this, lock){
                        public static final long serialVersionUID = 0L;
                        private final ReentrantLock lock$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.lock$1.unlock();
                        }
                        {
                            this.lock$1 = lock$1;
                        }
                    }, true);
                    this.$outer.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(0))})), this.key$2);
                    throw throwable;
                }
                this.$outer.kafka$server$DelayedOperationTest$$runOnAnotherThread((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */, true);
                this.$outer.kafka$server$DelayedOperationTest$$checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)this.ops$2.elem).apply(0))})), this.key$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mismatchedLocks$1 = mismatchedLocks$1;
                this.key$2 = key$2;
                this.ops$2 = ops$2;
            }
        });
        ops.elem = this.createCompletableOperations$1(2, mockDelayedOperation);
        ((Seq)ops.elem).foreach((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final String key$2;

            public final void apply(MockDelayedOperation op) {
                Assert.assertTrue((String)"Should have completed", (boolean)this.$outer.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.key$2}))));
                Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$2 = key$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public Future<?> kafka$server$DelayedOperationTest$$runOnAnotherThread(Function0<BoxedUnit> fun, boolean shouldComplete) {
        void var3_3;
        Object object;
        Future<?> future = this.executorService().submit(new Runnable(this, fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
        if (shouldComplete) {
            object = future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)future.isDone());
            object = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    public DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation() {
        return this.MockDelayedOperation$module == null ? this.MockDelayedOperation$lzycompute() : this.MockDelayedOperation$module;
    }

    private final boolean hasExecutorThread$1(String purgatoryName$1) {
        return ((IterableLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Thread x$1) {
                return x$1.getName();
            }
        }, Set$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this, purgatoryName$1){
            public static final long serialVersionUID = 0L;
            private final String purgatoryName$1;

            public final boolean apply(String x$2) {
                return x$2.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DelayedExecutor-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.purgatoryName$1})));
            }
            {
                this.purgatoryName$1 = purgatoryName$1;
            }
        });
    }

    public final void kafka$server$DelayedOperationTest$$updateResult$1(List futures, AtomicInteger result$1) {
        result$1.set(BoxesRunTime.unboxToInt((Object)((TraversableOnce)((List)futures.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CompletableFuture<Integer> x$3) {
                return x$3.isCompletedExceptionally();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(CompletableFuture<Integer> x$4) {
                return x$4.get();
            }
        }, List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    public final Future kafka$server$DelayedOperationTest$$scheduleTryComplete$1(TestDelayOperation.1 op, long delayMs, ScheduledExecutorService executor$1) {
        return executor$1.schedule(new Runnable(this, op){
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Kafka_server_DelayedOperationTest$TestDelayOperation$1 op$1;

            public void run() {
                if (this.op$1.completionAttemptsRemaining().decrementAndGet() == 0) {
                    this.op$1.completable_$eq(true);
                }
                this.$outer.purgatory().checkAndComplete((Object)this.op$1.key());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$1 = op$1;
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    public final MockDelayedOperation kafka$server$DelayedOperationTest$$newMockOperation$1() {
        ReentrantLock lock = new ReentrantLock();
        return new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)new Some((Object)lock), (Option<ReentrantLock>)new Some((Object)lock));
    }

    private final Seq createDelayedOperations$1(int count, Function0 mockDelayedOperation$1, String key$2) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1)new Serializable(this, mockDelayedOperation$1, key$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Function0 mockDelayedOperation$1;
            private final String key$2;

            /*
             * WARNING - void declaration
             */
            public final MockDelayedOperation apply(int x$6) {
                void var2_2;
                MockDelayedOperation op = (MockDelayedOperation)((Object)this.mockDelayedOperation$1.apply());
                this.$outer.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.key$2})));
                Assert.assertFalse((String)"Not completable", (boolean)op.isCompleted());
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mockDelayedOperation$1 = mockDelayedOperation$1;
                this.key$2 = key$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private final Seq createCompletableOperations$1(int count, Function0 mockDelayedOperation$1) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1)new Serializable(this, mockDelayedOperation$1){
            public static final long serialVersionUID = 0L;
            private final Function0 mockDelayedOperation$1;

            /*
             * WARNING - void declaration
             */
            public final MockDelayedOperation apply(int x$7) {
                void var2_2;
                MockDelayedOperation op = (MockDelayedOperation)((Object)this.mockDelayedOperation$1.apply());
                op.completable_$eq(true);
                return var2_2;
            }
            {
                this.mockDelayedOperation$1 = mockDelayedOperation$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public final void kafka$server$DelayedOperationTest$$checkAndComplete$1(Seq completableOps, Seq expectedComplete, String key$2) {
        completableOps.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MockDelayedOperation op) {
                op.completable_$eq(true);
            }
        });
        int completed = this.purgatory().checkAndComplete((Object)key$2);
        Assert.assertEquals((long)expectedComplete.size(), (long)completed);
        expectedComplete.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MockDelayedOperation op) {
                Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
            }
        });
        Set expectedNotComplete = (Set)completableOps.toSet().$minus$minus((GenTraversableOnce)expectedComplete);
        expectedNotComplete.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MockDelayedOperation op) {
                Assert.assertFalse((String)"Should not have completed", (boolean)op.isCompleted());
            }
        });
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private final Option<ReentrantLock> responseLockOpt;
        private boolean completable;
        public final /* synthetic */ DelayedOperationTest $outer;

        public Option<ReentrantLock> responseLockOpt() {
            return this.responseLockOpt;
        }

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            ((Object)((Object)this)).wait();
        }

        public boolean tryComplete() {
            return this.completable() ? this.forceComplete() : false;
        }

        public void onExpiration() {
        }

        public void onComplete() {
            this.responseLockOpt().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ReentrantLock lock) {
                    if (lock.tryLock()) {
                        return;
                    }
                    throw new IllegalStateException("Response callback lock could not be acquired in callback");
                }
            });
            MockDelayedOperation mockDelayedOperation = this;
            synchronized (mockDelayedOperation) {
                ((Object)((Object)this)).notify();
                return;
            }
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return this.$outer;
        }

        public MockDelayedOperation(DelayedOperationTest $outer, long delayMs, Option<ReentrantLock> lockOpt, Option<ReentrantLock> responseLockOpt) {
            this.responseLockOpt = responseLockOpt;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(delayMs, lockOpt);
            this.completable = false;
        }
    }
}

