/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.charset.StandardCharsets;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfig;
import kafka.server.DynamicConfigManager;
import kafka.server.DynamicConfigManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Quota;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001\u001d\u0011q\u0003R=oC6L7mQ8oM&<7\t[1oO\u0016$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aC5oi\u0016<'/\u0019;j_:L!!\u0004\u0006\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000bQ\u0001A\u0011A\u000b\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012A\u0006\t\u0004/y\u0001S\"\u0001\r\u000b\u0005eQ\u0012!C5n[V$\u0018M\u00197f\u0015\tYB$\u0001\u0006d_2dWm\u0019;j_:T\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?a\u0011A\u0001T5tiB\u0011!#I\u0005\u0003E\t\u00111bS1gW\u0006\u001cuN\u001c4jO\")A\u0005\u0001C\u0001K\u0005\u0001B/Z:u\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0002MA\u0011q\u0005K\u0007\u00029%\u0011\u0011\u0006\b\u0002\u0005+:LG\u000f\u000b\u0002$WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002a\u0005\u0019qN]4\n\u0005Ij#\u0001\u0002+fgRDQ\u0001\u000e\u0001\u0005\u0002\u0015\nA\u0004^3ti\u0012Kh.Y7jGR{\u0007/[2D_:4\u0017nZ\"iC:<W\r\u000b\u00024W!)q\u0007\u0001C\u0005q\u0005)B/Z:u#V|G/Y\"p]\u001aLwm\u00115b]\u001e,G#\u0002\u0014:\u0005\u00123\u0005\"\u0002\u001e7\u0001\u0004Y\u0014\u0001B;tKJ\u0004\"\u0001P \u000f\u0005\u001dj\u0014B\u0001 \u001d\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yb\u0002\"B\"7\u0001\u0004Y\u0014\u0001C2mS\u0016tG/\u00133\t\u000b\u00153\u0004\u0019A\u001e\u0002\u001dI|w\u000e^#oi&$\u0018\u0010V=qK\")qI\u000ea\u0001w\u0005\u00012m\u001c8gS\u001e,e\u000e^5us:\u000bW.\u001a\u0005\u0006\u0013\u0002!\t!J\u0001\u001ei\u0016\u001cHo\u00117jK:$\u0018\nZ)v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012\u0001j\u000b\u0005\u0006\u0019\u0002!\t!J\u0001\u001ai\u0016\u001cH/V:feF+x\u000e^1D_:4\u0017nZ\"iC:<W\r\u000b\u0002LW!)q\n\u0001C\u0001K\u0005YB/Z:u+N,'o\u00117jK:$\u0018\nZ)v_R\f7\t[1oO\u0016D#AT\u0016\t\u000bI\u0003A\u0011A\u0013\u0002IQ,7\u000f\u001e#fM\u0006,H\u000e^\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#!U\u0016\t\u000bU\u0003A\u0011A\u0013\u0002AQ,7\u000f\u001e#fM\u0006,H\u000e^+tKJ\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u0015\u0003).BQ\u0001\u0017\u0001\u0005\u0002\u0015\n\u0001\u0006^3ti\u0012+g-Y;miV\u001bXM]\"mS\u0016tG/\u00133Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#aV\u0016\t\u000bm\u0003A\u0011A\u0013\u0002/Q,7\u000f^)v_R\f\u0017J\\5uS\u0006d\u0017N_1uS>t\u0007F\u0001.,\u0011\u0015q\u0006\u0001\"\u0001&\u0003\t\"Xm\u001d;D_:4\u0017nZ\"iC:<Wm\u00148O_:,\u00050[:uS:<Gk\u001c9jG\"\u0012Ql\u000b\u0005\u0006C\u0002!\t!J\u0001\u0018i\u0016\u001cH\u000f\u0015:pG\u0016\u001c8OT8uS\u001aL7-\u0019;j_:D#\u0001Y\u0016\t\u000b\u0011\u0004A\u0011A\u0013\u0002KMDw.\u001e7e!\u0006\u00148/\u001a*fa2L7-\u0019;j_:\fVo\u001c;b!J|\u0007/\u001a:uS\u0016\u001c\bFA2,\u0011\u00159\u0007\u0001\"\u0001&\u00035\u001a\bn\\;mIB\u000b'o]3XS2$7-\u0019:e%\u0016\u0004H.[2bi&|g.U;pi\u0006\u0004&o\u001c9feRLWm\u001d\u0015\u0003M.BQA\u001b\u0001\u0005\u0002\u0015\n\u0001e\u001d5pk2$\u0007+\u0019:tKJ+\u0007\u000f\\5dCRLwN\\)v_R\f'+Z:fi\"\u0012\u0011n\u000b\u0005\u0006[\u0002!\t!J\u0001.g\"|W\u000f\u001c3QCJ\u001cXMU3hCJ$G.Z:t\u001f\u001a<\u0006.\u001b;fgB\f7-Z!s_VtGMV1mk\u0016\u001c\bF\u00017,\u0011\u0015\u0001\b\u0001\"\u0001r\u0003\u0015\u0001\u0018M]:f)\r\u0011\u0018P \t\u0004gR4X\"\u0001\u000e\n\u0005UT\"aA*fcB\u0011qe^\u0005\u0003qr\u00111!\u00138u\u0011\u0015Qx\u000e1\u0001|\u00035\u0019wN\u001c4jO\"\u000bg\u000e\u001a7feB\u0011!\u0003`\u0005\u0003{\n\u0011!\u0003V8qS\u000e\u001cuN\u001c4jO\"\u000bg\u000e\u001a7fe\")qp\u001ca\u0001w\u0005)a/\u00197vK\u0002")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()))}));
    }

    @Test
    public void testConfigChange() {
        Assert.assertTrue((String)"Should contain a ConfigHandler for topics", (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()));
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, oldVal, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final Long oldVal$1;
            private final TopicPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogManager qual$1 = ((KafkaServer)this.$outer.servers().head()).logManager();
                TopicPartition x$2 = this.tp$1;
                boolean x$3 = qual$1.getLog$default$2();
                Option logOpt = qual$1.getLog(x$2, x$3);
                Assert.assertTrue((boolean)logOpt.isDefined());
                Assert.assertEquals((Object)this.oldVal$1, (Object)((AbstractLog)logOpt.get()).config().flushInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.oldVal$1 = oldVal$1;
                this.tp$1 = tp$1;
            }
        });
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, newVal, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final Long newVal$1;
            private final TopicPartition tp$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogManager qual$2 = ((KafkaServer)this.$outer.servers().head()).logManager();
                TopicPartition x$4 = this.tp$1;
                boolean x$5 = qual$2.getLog$default$2();
                Assert.assertEquals((Object)this.newVal$1, (Object)((AbstractLog)qual$2.getLog(x$4, x$5).get()).config().flushInterval());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newVal$1 = newVal$1;
                this.tp$1 = tp$1;
            }
        });
    }

    @Test
    public void testDynamicTopicConfigChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)oldSegmentSize)).toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, tp, oldSegmentSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final TopicPartition tp$2;
            private final int oldSegmentSize$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogManager qual$3 = ((KafkaServer)this.$outer.servers().head()).logManager();
                TopicPartition x$6 = this.tp$2;
                boolean x$7 = qual$3.getLog$default$2();
                Option logOpt = qual$3.getLog(x$6, x$7);
                Assert.assertTrue((boolean)logOpt.isDefined());
                Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)this.oldSegmentSize$1), (Object)((AbstractLog)logOpt.get()).config().segmentSize());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$2 = tp$2;
                this.oldSegmentSize$1 = oldSegmentSize$1;
            }
        });
        LogManager qual$4 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$8 = tp;
        boolean x$9 = qual$4.getLog$default$2();
        AbstractLog log2 = (AbstractLog)qual$4.getLog(x$8, x$9).get();
        int newSegmentSize = 2000;
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)newSegmentSize)).toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, log2, newSegmentSize){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$1;
            private final int newSegmentSize$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)this.newSegmentSize$1), (Object)this.log$1.config().segmentSize());
            }
            {
                this.log$1 = log$1;
                this.newSegmentSize$1 = newSegmentSize$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)new Serializable(this, tp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;
            private final TopicPartition tp$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)this.$outer.servers(), this.tp$2.topic(), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$2 = tp$2;
            }
        });
        Assert.assertTrue((String)"Log segment size change not applied", (boolean)log2.localLogSegments().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$1) {
                return x$1.size() > 1000;
            }
        }));
    }

    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assert.assertTrue((String)new StringBuilder().append((Object)"Should contain a ConfigHandler for ").append((Object)rootEntityType).toString(), (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType));
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().quotas();
        String string = rootEntityType;
        String string2 = ConfigType$.MODULE$.Client();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, user, clientId, quotaManagers){
            public static final long serialVersionUID = 0L;
            private final String user$1;
            private final String clientId$1;
            private final QuotaFactory.QuotaManagers quotaManagers$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Quota overrideProducerQuota = this.quotaManagers$1.produce().quota(this.user$1, this.clientId$1);
                Quota overrideConsumerQuota = this.quotaManagers$1.fetch().quota(this.user$1, this.clientId$1);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have overridden producer quota of 1000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1})), (Object)Quota.upperBound((double)1000.0), (Object)overrideProducerQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have overridden consumer quota of 2000"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1})), (Object)Quota.upperBound((double)2000.0), (Object)overrideConsumerQuota);
            }
            {
                this.user$1 = user$1;
                this.clientId$1 = clientId$1;
                this.quotaManagers$1 = quotaManagers$1;
            }
        });
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string4 = rootEntityType;
        String string5 = ConfigType$.MODULE$.Client();
        String string6 = string4;
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, user, clientId, quotaManagers, defaultProducerQuota, defaultConsumerQuota){
            public static final long serialVersionUID = 0L;
            private final String user$1;
            private final String clientId$1;
            private final QuotaFactory.QuotaManagers quotaManagers$1;
            private final double defaultProducerQuota$1;
            private final double defaultConsumerQuota$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Quota producerQuota = this.quotaManagers$1.produce().quota(this.user$1, this.clientId$1);
                Quota consumerQuota = this.quotaManagers$1.fetch().quota(this.user$1, this.clientId$1);
                Assert.assertEquals((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have reset producer quota to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1}))).append((Object)BoxesRunTime.boxToDouble((double)this.defaultProducerQuota$1)).toString(), (Object)Quota.upperBound((double)this.defaultProducerQuota$1), (Object)producerQuota);
                Assert.assertEquals((String)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " clientId ", " must have reset consumer quota to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.user$1, this.clientId$1}))).append((Object)BoxesRunTime.boxToDouble((double)this.defaultConsumerQuota$1)).toString(), (Object)Quota.upperBound((double)this.defaultConsumerQuota$1), (Object)consumerQuota);
            }
            {
                this.user$1 = user$1;
                this.clientId$1 = clientId$1;
                this.quotaManagers$1 = quotaManagers$1;
                this.defaultProducerQuota$1 = defaultProducerQuota$1;
                this.defaultConsumerQuota$1 = defaultConsumerQuota$1;
            }
        });
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        Properties userProps = new Properties();
        userProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "10000");
        userProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "100000");
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("overriddenUser", userProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DynamicConfigChangeTest $outer;

            public final void apply(String p) {
                KafkaZkClient qual$5 = this.$outer.zkClient();
                String x$10 = new StringBuilder().append((Object)ConfigEntityChangeNotificationZNode$.MODULE$.path()).append((Object)"/").append((Object)p).toString();
                int x$11 = qual$5.deletePath$default$2();
                boolean x$12 = qual$5.deletePath$default$3();
                qual$5.deletePath(x$10, x$11, x$12);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        Assert.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)10000.0), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)20000.0), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)100000.0), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)200000.0), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try {
            Properties logProps = new Properties();
            logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), Predef$.MODULE$.int2Integer(10000));
            this.adminZkClient().changeTopicConfig(topic, logProps);
            Assert.fail((String)"Should fail with AdminOperationException for topic doesn't exist");
        }
        catch (AdminOperationException adminOperationException) {}
    }

    @Test
    public void testProcessNotification() {
        Properties props = new Properties();
        props.put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})), DynamicConfigManager$.MODULE$.$lessinit$greater$default$3(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$4());
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        try {
            Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter(jsonMap).asJava()));
            Assert.fail((String)new StringBuilder().append((Object)"Should have thrown an Exception while parsing incorrect notification ").append((Object)jsonMap).toString());
        }
        catch (Throwable throwable) {}
        try {
            Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter(jsonMap).asJava()));
            Assert.fail((String)new StringBuilder().append((Object)"Should have thrown an Exception while parsing incorrect notification ").append((Object)jsonMap).toString());
        }
        catch (Throwable throwable) {}
        try {
            Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter(jsonMap).asJava()));
            Assert.fail((String)new StringBuilder().append((Object)"Should have thrown an Exception while parsing incorrect notification ").append((Object)jsonMap).toString());
        }
        catch (Throwable throwable) {}
        Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter(jsonMap).asJava()));
        EasyMock.verify((Object[])new Object[]{handler});
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)configHandler.parseThrottledPartitions(props, 103, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.parse(configHandler, " "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }
}

