/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.server.ConfluentObserverTest;
import kafka.server.ConfluentObserverTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u000f\tIrJY:feZ,'oQ8na\u0006$\u0018NY5mSRLH+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0001\u0004%\t!F\u0001\bg\u0016\u0014h/\u001a:t+\u00051\u0002cA\f\u001d=5\t\u0001D\u0003\u0002\u001a5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003m\tQa]2bY\u0006L!!\b\r\u0003\u0007M+\u0017\u000f\u0005\u0002\u0013?%\u0011\u0001E\u0001\u0002\f\u0017\u000647.Y*feZ,'\u000fC\u0004#\u0001\u0001\u0007I\u0011A\u0012\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003I!\u0002\"!\n\u0014\u000e\u0003iI!a\n\u000e\u0003\tUs\u0017\u000e\u001e\u0005\bS\u0005\n\t\u00111\u0001\u0017\u0003\rAH%\r\u0005\u0007W\u0001\u0001\u000b\u0015\u0002\f\u0002\u0011M,'O^3sg\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\u0004ce>\\WM]\u0019\u0016\u0003=\u0002\"!\n\u0019\n\u0005ER\"aA%oi\"11\u0007\u0001Q\u0001\n=\n\u0001B\u0019:pW\u0016\u0014\u0018\u0007\t\u0005\bk\u0001\u0011\r\u0011\"\u0001/\u0003\u001d\u0011'o\\6feJBaa\u000e\u0001!\u0002\u0013y\u0013\u0001\u00032s_.,'O\r\u0011\t\u000be\u0002A\u0011\t\u001e\u0002\u000bM,G/\u00169\u0015\u0003\u0011B#\u0001\u000f\u001f\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015!\u00026v]&$(\"A!\u0002\u0007=\u0014x-\u0003\u0002D}\t1!)\u001a4pe\u0016DQ!\u0012\u0001\u0005Bi\n\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\t\u001e\u0003\"!\u0010%\n\u0005%s$!B!gi\u0016\u0014\b\"B&\u0001\t\u0003Q\u0014\u0001\u000e;fgR\u001c\u0015M\\+tKJ+\u0007\u000f\\5dCBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;XSRDw.\u001e;PEN,'O^3sg\"\u0012!*\u0014\t\u0003{9K!a\u0014 \u0003\tQ+7\u000f\u001e\u0005\u0006#\u0002!\tAO\u0001 i\u0016\u001cHoQ1o%\u0016\f7o]5h]R{W)\u001c9us>\u00137/\u001a:wKJ\u001c\bF\u0001)N\u0011\u0015!\u0006\u0001\"\u0001;\u0003Q\"Xm\u001d;DC:tw\u000e^+tKJ+\u0007\u000f\\5dCBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;XSRDwJY:feZ,'o\u001d\u0015\u0003'6CQa\u0016\u0001\u0005\u0002i\nQ\u0004^3ti\u000e\u000bgN\\8u%\u0016\f7o]5h]R{wJY:feZ,'o\u001d\u0015\u0003-6CQA\u0017\u0001\u0005\u0002i\nq\u0006^3ti\u000e\u000bgN\\8u\u000b:\f'\r\\3PEN,'O^3sgRC'o\\;hQ\u0006cG/\u001a:D_:4\u0017nZ!Q\u0013ND#!W'")
public class ObserverCompatibilityTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int broker1;
    private final int broker2;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        scala.collection.immutable.Map rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"b")}));
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1)new Serializable(this, rack){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map rack$1;

            public final KafkaServer apply(Properties config) {
                config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)this.rack$1.apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))).toInt())));
                config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.3");
                return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
            }
            {
                this.rack$1 = rack$1;
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testCanUseReplicaPlacementConstraintWithoutObservers() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Void apply(AdminClient client) {
                String topic = "observer-topic";
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(1, "a"), (Option<ConfluentObserverTest.BasicConstraint>)None$.MODULE$))}))).asJava());
                return (Void)client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
            }
        });
    }

    @Test
    public void testCanReassignToEmptyObservers() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                TopicPartition topicPartition = new TopicPartition(topic, 0);
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.of(Predef$.MODULE$.short2Short((short)2)));
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                scala.collection.mutable.Map description = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)client.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).all().get()).asScala();
                Seq replicas = ((TraversableOnce)((TraversableLike)description.values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Buffer<Node> apply(TopicDescription x$1) {
                        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.partitions()).asScala()).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Buffer<Node> apply(TopicPartitionInfo x$2) {
                                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2.replicas()).asScala();
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$3) {
                        return x$3.id();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq();
                Seq swappedBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)replicas.apply(1)), BoxesRunTime.unboxToInt((Object)replicas.apply(0))}));
                client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)swappedBrokers, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))))}))).asJava()).all().get();
                TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)swappedBrokers);
            }
        });
    }

    @Test
    public void testCannotUseReplicaPlacementConstraintWithObservers() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                newTopic.configs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(1, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "b"))))}))).asJava());
                KafkaFuture future = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all();
                TestUtils.assertFutureError((Future)future, InvalidReplicaAssignmentException.class);
            }
        });
    }

    @Test
    public void testCannotReassignToObservers() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ObserverCompatibilityTest $outer;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                TopicPartition topicPartition = new TopicPartition(topic, 0);
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                KafkaFuture future = client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker1()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.broker2()})))))}))).asJava()).all();
                TestUtils.assertFutureError((Future)future, InvalidReplicaAssignmentException.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCannotEnableObserversThroughAlterConfigAPIs() {
        TestUtils$.MODULE$.resource(AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava())), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AdminClient client) {
                String topic = "observer-topic";
                NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.<T>empty());
                client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
                Properties configUpdate = new Properties();
                configUpdate.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(1, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "b"))));
                KafkaFuture alterConfigFuture = TestUtils$.MODULE$.alterTopicConfigs((Admin)client, topic, configUpdate).all();
                TestUtils.assertFutureError((Future)alterConfigFuture, InvalidConfigurationException.class);
                KafkaFuture incrementalAlterConfigFuture = TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, configUpdate).all();
                TestUtils.assertFutureError((Future)incrementalAlterConfigFuture, InvalidConfigurationException.class);
            }
        });
    }

    public ObserverCompatibilityTest() {
        this.broker1 = 0;
        this.broker2 = 1;
    }
}

