/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.network.SocketServer$;
import kafka.server.RequestQueueSizePercentiles$;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u000f\ty\"+Z9vKN$\u0018+^3vKNK'0\u001a)fe\u000e,g\u000e^5mKN$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0005\u0015\u0001\u0001\u0007\t\u0019!C\u0005+\u0005!A/[7f+\u00051\u0002CA\f\"\u001b\u0005A\"BA\r\u001b\u0003\u0015)H/\u001b7t\u0015\tYB$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000buQ!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO&\u0011!\u0005\u0007\u0002\t\u001b>\u001c7\u000eV5nK\"IA\u0005\u0001a\u0001\u0002\u0004%I!J\u0001\ti&lWm\u0018\u0013fcR\u0011a%\u000b\t\u0003\u0013\u001dJ!\u0001\u000b\u0006\u0003\tUs\u0017\u000e\u001e\u0005\bU\r\n\t\u00111\u0001\u0017\u0003\rAH%\r\u0005\u0007Y\u0001\u0001\u000b\u0015\u0002\f\u0002\u000bQLW.\u001a\u0011\t\u00139\u0002\u0001\u0019!a\u0001\n\u0013y\u0013aB7fiJL7m]\u000b\u0002aA\u0011\u0011gM\u0007\u0002e)\u0011aFG\u0005\u0003iI\u0012q!T3ue&\u001c7\u000fC\u00057\u0001\u0001\u0007\t\u0019!C\u0005o\u0005YQ.\u001a;sS\u000e\u001cx\fJ3r)\t1\u0003\bC\u0004+k\u0005\u0005\t\u0019\u0001\u0019\t\ri\u0002\u0001\u0015)\u00031\u0003!iW\r\u001e:jGN\u0004\u0003\"\u0002\u001f\u0001\t\u0003i\u0014\u0001\u00042fM>\u0014X-T3uQ>$G#\u0001\u0014)\u0005mz\u0004C\u0001!D\u001b\u0005\t%B\u0001\" \u0003\u0015QWO\\5u\u0013\t!\u0015I\u0001\u0004CK\u001a|'/\u001a\u0005\u0006\r\u0002!\t!P\u0001\fC\u001a$XM]'fi\"|G\r\u000b\u0002F\u0011B\u0011\u0001)S\u0005\u0003\u0015\u0006\u0013Q!\u00114uKJDQ\u0001\u0014\u0001\u0005\u0002u\n\u0001\u0004^3tiF+X-^3TSj,\u0007+\u001a:dK:$\u0018\u000e\\3tQ\tYe\n\u0005\u0002A\u001f&\u0011\u0001+\u0011\u0002\u0005)\u0016\u001cH\u000fC\u0003S\u0001\u0011\u0005Q(A\u0010uKN$\u0018+^3vKNK'0\u001a)fe\u000e,g\u000e^5mKN,\u0006\u000fV8NCbD#!\u0015(")
public class RequestQueueSizePercentilesTest {
    private MockTime time;
    private Metrics metrics;

    private MockTime time() {
        return this.time;
    }

    private void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    @Before
    public void beforeMethod() {
        this.time_$eq(new MockTime());
        this.metrics_$eq(new Metrics(new MetricConfig().timeWindow(1L, TimeUnit.SECONDS), Collections.emptyList(), (Time)this.time()));
    }

    @After
    public void afterMethod() {
        this.metrics().close();
    }

    @Test
    public void testQueueSizePercentiles() {
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Percentiles queueSizePercentiles = RequestQueueSizePercentiles$.MODULE$.createPercentiles(this.metrics(), 500, SocketServer$.MODULE$.DataPlaneMetricPrefix());
        queueSizeSensor.add((CompoundStat)queueSizePercentiles);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)new Serializable(this, queueSizeSensor){
            public static final long serialVersionUID = 0L;
            private final Sensor queueSizeSensor$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.queueSizeSensor$1.record((double)(i % 100));
            }
            {
                this.queueSizeSensor$1 = queueSizeSensor$1;
            }
        });
        Assert.assertEquals((double)80.0, (double)RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p80"), (double)1.0);
        Assert.assertEquals((double)90.0, (double)RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p90"), (double)1.0);
        Assert.assertEquals((double)95.0, (double)RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p95"), (double)1.0);
        Assert.assertEquals((double)99.0, (double)RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p99"), (double)1.0);
    }

    @Test
    public void testQueueSizePercentilesUpToMax() {
        Sensor queueSizeSensor = this.metrics().sensor("RequestQueueSize");
        Percentiles queueSizePercentiles = RequestQueueSizePercentiles$.MODULE$.createPercentiles(this.metrics(), 500, SocketServer$.MODULE$.DataPlaneMetricPrefix());
        queueSizeSensor.add((CompoundStat)queueSizePercentiles);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp((Function1)new Serializable(this, queueSizeSensor){
            public static final long serialVersionUID = 0L;
            private final Sensor queueSizeSensor$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.queueSizeSensor$2.record((double)(i % 500));
            }
            {
                this.queueSizeSensor$2 = queueSizeSensor$2;
            }
        });
        Assert.assertEquals((double)400.0, (double)RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p80"), (double)1.0);
        Assert.assertEquals((double)450.0, (double)RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p90"), (double)1.0);
        Assert.assertEquals((double)475.0, (double)RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p95"), (double)1.0);
        Assert.assertEquals((double)495.0, (double)RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p99"), (double)1.0);
    }
}

