/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.server.Defaults$;
import kafka.server.VerifyGroupSubscriptionPrefixTest$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015s!B\u0001\u0003\u0011\u00039\u0011!\t,fe&4\u0017p\u0012:pkB\u001cVOY:de&\u0004H/[8o!J,g-\u001b=UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003CY+'/\u001b4z\u000fJ|W\u000f]*vEN\u001c'/\u001b9uS>t\u0007K]3gSb$Vm\u001d;\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a#\u0003b\u0001\n\u00039\u0012A\u00029sK\u001aL\u00070F\u0001\u0019!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0003mC:<'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011aa\u0015;sS:<\u0007BB\u0011\nA\u0003%\u0001$A\u0004qe\u00164\u0017\u000e\u001f\u0011\u0007\t)\u0011\u0001aI\n\u0003E\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R!a\n\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002*M\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0014E\u0011\u00051\u0006F\u0001-!\tA!\u0005C\u0003/E\u0011Es&A\u0006ce>\\WM]\"pk:$X#\u0001\u0019\u0011\u00055\t\u0014B\u0001\u001a\u000f\u0005\rIe\u000e\u001e\u0005\u0006i\t\"\t%N\u0001\u000e[>$\u0017NZ=D_:4\u0017nZ:\u0015\u0005YJ\u0004CA\u00078\u0013\tAdB\u0001\u0003V]&$\b\"\u0002\u001e4\u0001\u0004Y\u0014!\u00029s_B\u001c\bc\u0001\u001fE\u000f:\u0011QH\u0011\b\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u001a\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005\rs\u0011a\u00029bG.\fw-Z\u0005\u0003\u000b\u001a\u00131aU3r\u0015\t\u0019e\u0002\u0005\u0002I\u00176\t\u0011J\u0003\u0002K9\u0005!Q\u000f^5m\u0013\ta\u0015J\u0001\u0006Qe>\u0004XM\u001d;jKNDQA\u0014\u0012\u0005\u0002=\u000b\u0011\u0006^3tiN+8mY3tg\u001a,H\u000e\\=EK2,G/Z(gMN,Go],ji\"\u0004&/\u001a4jq\u0016\u001cH#\u0001\u001c)\u00055\u000b\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0015QWO\\5u\u0015\u00051\u0016aA8sO&\u0011\u0001l\u0015\u0002\u0005)\u0016\u001cH\u000fC\u0003[E\u0011\u0005q*\u0001\u0017uKN$8+^2dKN\u001ch-\u001e7ms\u0012+G.\u001a;f\u001f\u001a47/\u001a;t/&$\bn\\;u!J,g-\u001b=fg\"\u0012\u0011,\u0015\u0005\u0006;\n\"\taT\u0001 i\u0016\u001cH/\u00168tk\u000e\u001cWm]:gk2d\u0017\u0010R3mKR,wJ\u001a4tKR\u001c\bF\u0001/R\u0011\u0015\u0001'\u0005\"\u0003b\u0003E!Xm\u001d;EK2,G/Z(gMN,Go\u001d\u000b\u0005E6,x\u000f\u0005\u0002dW6\tAM\u0003\u0002fM\u0006)\u0011\rZ7j]*\u0011q\r[\u0001\bG2LWM\u001c;t\u0015\t)\u0011N\u0003\u0002k+\u00061\u0011\r]1dQ\u0016L!\u0001\u001c3\u0003A\u0011+G.\u001a;f\u0007>t7/^7fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:SKN,H\u000e\u001e\u0005\u0006]~\u0003\ra\\\u0001\u0006OJ|W\u000f\u001d\t\u0003aNt!!D9\n\u0005It\u0011A\u0002)sK\u0012,g-\u0003\u0002 i*\u0011!O\u0004\u0005\u0006m~\u0003\ra\\\u0001\u0010gV\u00147o\u0019:jE\u0016$Gk\u001c9jG\")\u0001p\u0018a\u0001_\u0006\tRO\\:vEN\u001c'/\u001b2fIR{\u0007/[2\t\u000bi\u0014C\u0011B>\u0002!\u0005\u001c8/\u001a:u\rV$XO]3Ok2dG\u0003\u0002\u001c}\u0003CAQ!`=A\u0002y\faAZ;ukJ,\u0007gA@\u0002\u0010A1\u0011\u0011AA\u0004\u0003\u0017i!!a\u0001\u000b\u0007\u0005\u0015\u0001.\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u0013\t\u0019AA\u0006LC\u001a\\\u0017MR;ukJ,\u0007\u0003BA\u0007\u0003\u001fa\u0001\u0001B\u0006\u0002\u0012q\f\t\u0011!A\u0003\u0002\u0005M!aA0%cE!\u0011QCA\u000e!\ri\u0011qC\u0005\u0004\u00033q!a\u0002(pi\"Lgn\u001a\t\u0004\u001b\u0005u\u0011bAA\u0010\u001d\t\u0019\u0011I\\=\t\u0013\u0005\r\u0012\u0010%AA\u0002\u0005\u0015\u0012aB7fgN\fw-\u001a\t\u0005\u001b\u0005\u001dr.C\u0002\u0002*9\u0011aa\u00149uS>t\u0007\"CA\u0017EE\u0005I\u0011BA\u0018\u0003i\t7o]3si\u001a+H/\u001e:f\u001dVdG\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tD\u000b\u0003\u0002&\u0005M2FAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}b\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0011\u0002:\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class VerifyGroupSubscriptionPrefixTest
extends IntegrationTestHarness {
    public static String prefix() {
        return VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix();
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(Properties p) {
                return p.put("confluent.verify.group.subscription.prefix", "true");
            }
        });
    }

    @Test
    public void testSuccessfullyDeleteOffsetsWithPrefixes() {
        String group = new StringBuilder().append((Object)VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix()).append((Object)"group").toString();
        String subscribedTopic = new StringBuilder().append((Object)VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix()).append((Object)"subscribed-topic").toString();
        String unsubscribedTopic = new StringBuilder().append((Object)VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix()).append((Object)"not-subscribed-topic").toString();
        DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.testDeleteOffsets(group, subscribedTopic, unsubscribedTopic);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(new TopicPartition(subscribedTopic, 0)), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        this.assertFutureNull(offsetDeleteResult.partitionResult(new TopicPartition(unsubscribedTopic, 0)), this.assertFutureNull$default$2());
    }

    @Test
    public void testSuccessfullyDeleteOffsetsWithoutPrefixes() {
        String group = "group";
        String subscribedTopic = "subscribed-topic";
        String unsubscribedTopic = "not-subscribed-topic";
        DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.testDeleteOffsets(group, subscribedTopic, unsubscribedTopic);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(new TopicPartition(subscribedTopic, 0)), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        this.assertFutureNull(offsetDeleteResult.partitionResult(new TopicPartition(unsubscribedTopic, 0)), this.assertFutureNull$default$2());
    }

    @Test
    public void testUnsuccessfullyDeleteOffsets() {
        String group = new StringBuilder().append((Object)VerifyGroupSubscriptionPrefixTest$.MODULE$.prefix()).append((Object)"group").toString();
        String subscribedTopic = "subscribed-topic";
        String unsubscribedTopic = "not-subscribed-topic";
        DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.testDeleteOffsets(group, subscribedTopic, unsubscribedTopic);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(new TopicPartition(subscribedTopic, 0)), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(new TopicPartition(unsubscribedTopic, 0)), GroupSubscribedToTopicException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
    }

    private DeleteConsumerGroupOffsetsResult testDeleteOffsets(String group, String subscribedTopic, String unsubscribedTopic) {
        this.createTopic(subscribedTopic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        this.createTopic(unsubscribedTopic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        producer.send(new ProducerRecord(subscribedTopic, Predef$.MODULE$.int2Integer(0), null, null)).get();
        producer.send(new ProducerRecord(unsubscribedTopic, Predef$.MODULE$.int2Integer(0), null, null)).get();
        Properties newConsumerConfig = new Properties(this.consumerConfig());
        newConsumerConfig.setProperty("group.id", group);
        newConsumerConfig.setProperty("max.poll.interval.ms", ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        newConsumerConfig.setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.GroupMaxSessionTimeoutMs())).toString());
        Properties x$1 = newConsumerConfig;
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        TestUtils$.MODULE$.subscribeAndWaitForRecords(subscribedTopic, consumer, TestUtils$.MODULE$.subscribeAndWaitForRecords$default$3());
        consumer.commitSync();
        Admin admin = this.createAdminClient(this.createAdminClient$default$1());
        return admin.deleteConsumerGroupOffsets(group, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(subscribedTopic, 0), new TopicPartition(unsubscribedTopic, 0)}))).asJava());
    }

    private void assertFutureNull(KafkaFuture<?> future, Option<String> message) {
        Option<String> option;
        block4: {
            block3: {
                block2: {
                    option = message;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String msg = (String)some.x();
                    Assert.assertNull((String)msg, (Object)future.get());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Assert.assertNull((Object)future.get());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    private Option<String> assertFutureNull$default$2() {
        return None$.MODULE$;
    }
}

