/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogTest$;
import kafka.server.BrokerTopicStats;
import kafka.server.ReplicaManager;
import kafka.tier.AwaitingDeleteComplete$;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.DeletionState;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.MaterializationComplete$;
import kafka.tier.MaterializingState$;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierDeletedPartitionsCoordinatorTest$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011A\u0005V5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;peR+7\u000f\u001e\u0006\u0003\u0007\u0011\tA\u0001^5fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002-A\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005mA\"A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0007;\u0001\u0001\u000b\u0011\u0002\f\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002Bqa\b\u0001C\u0002\u0013%\u0001%A\tuS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ,\u0012!\t\t\u0003E\u0015j\u0011a\t\u0006\u0003I\t\tQ\u0001^8qS\u000eL!AJ\u0012\u0003#QKWM\u001d+pa&\u001c7i\u001c8tk6,'\u000f\u0003\u0004)\u0001\u0001\u0006I!I\u0001\u0013i&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\b\u0005C\u0004+\u0001\t\u0007I\u0011B\u0016\u0002\tQLW.Z\u000b\u0002YA\u0011Q\u0006M\u0007\u0002])\u0011q\u0006B\u0001\u0006kRLGn]\u0005\u0003c9\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007g\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u000bQLW.\u001a\u0011\t\u000fU\u0002!\u0019!C\u0005m\u0005I1o\u00195fIVdWM]\u000b\u0002oA\u0011Q\u0006O\u0005\u0003s9\u0012Q\"T8dWN\u001b\u0007.\u001a3vY\u0016\u0014\bBB\u001e\u0001A\u0003%q'\u0001\u0006tG\",G-\u001e7fe\u0002Bq!\u0010\u0001C\u0002\u0013%a(A\u0007uS\u0016\u0014X\rZ(cU\u0016\u001cGo]\u000b\u0002\u007fA!\u0001)R$K\u001b\u0005\t%B\u0001\"D\u0003\u001diW\u000f^1cY\u0016T!\u0001\u0012\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002G\u0003\n\u0019Q*\u00199\u0011\u0005IA\u0015BA%\u0003\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eE\u0002L'Zs!\u0001T)\u000f\u00055\u0003V\"\u0001(\u000b\u0005=3\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t\u0011&\"A\u0004qC\u000e\\\u0017mZ3\n\u0005Q+&\u0001\u0002'jgRT!A\u0015\u0006\u0011\u0005]kfB\u0001-\\\u001b\u0005I&B\u0001.\u0003\u0003\u0015\u0019Ho\u001c:f\u0013\ta\u0016,A\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0013\tqvL\u0001\bPE*,7\r^'fi\u0006$\u0017\r^1\u000b\u0005qK\u0006BB1\u0001A\u0003%q(\u0001\buS\u0016\u0014X\rZ(cU\u0016\u001cGo\u001d\u0011\t\u000f\r\u0004!\u0019!C\u0005I\u0006aB-\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014X#A3\u0011\u0005I1\u0017BA4\u0003\u0005\u0001\"\u0016.\u001a:EK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001cun\u001c:eS:\fGo\u001c:\t\r%\u0004\u0001\u0015!\u0003f\u0003u!W\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\u0004\u0003bB6\u0001\u0005\u0004%I\u0001\\\u0001\u0004I&\u0014X#A7\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018AA5p\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\t\u0019KG.\u001a\u0005\u0007m\u0002\u0001\u000b\u0011B7\u0002\t\u0011L'\u000f\t\u0005\bq\u0002\u0011\r\u0011\"\u0003m\u0003\u0019awn\u001a#je\"1!\u0010\u0001Q\u0001\n5\fq\u0001\\8h\t&\u0014\b\u0005C\u0004}\u0001\t\u0007I\u0011B?\u0002%QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002}B\u0019q0a\u0004\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\taaY8n[>t'bA\u0003\u0002\b)!\u0011\u0011BA\u0006\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QB\u0001\u0004_J<\u0017\u0002BA\t\u0003\u0003\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0016\u0001\u0001\u000b\u0011\u0002@\u0002'QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\u0005)1/\u001a;vaR\u0011\u0011Q\u0004\t\u0004\u0013\u0005}\u0011bAA\u0011\u0015\t!QK\\5uQ\u0011\t9\"!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQA!a\u000b\u0002\f\u0005)!.\u001e8ji&!\u0011qFA\u0015\u0005\u0019\u0011UMZ8sK\"9\u00111\u0007\u0001\u0005\u0002\u0005m\u0011\u0001\u0003;fCJ$wn\u001e8)\t\u0005E\u0012q\u0007\t\u0005\u0003O\tI$\u0003\u0003\u0002<\u0005%\"!B!gi\u0016\u0014\bbBA \u0001\u0011\u0005\u00111D\u0001\u0015i\u0016\u001cH/\u00138ji&\fG/\u001a#fY\u0016$\u0018n\u001c8)\t\u0005u\u00121\t\t\u0005\u0003O\t)%\u0003\u0003\u0002H\u0005%\"\u0001\u0002+fgRDq!a\u0013\u0001\t\u0003\tY\"\u0001\u000buKN$8i\\7qY\u0016$X\rR3mKRLwN\u001c\u0015\u0005\u0003\u0013\n\u0019\u0005C\u0004\u0002R\u0001!\t!a\u0007\u00021Q,7\u000f\u001e\"fO&tW*\u0019;fe&\fG.\u001b>bi&|g\u000e\u000b\u0003\u0002P\u0005\r\u0003bBA,\u0001\u0011\u0005\u00111D\u0001\u0014i\u0016\u001cH\u000fR3mKR,\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003+\n\u0019\u0005C\u0004\u0002^\u0001!\t!a\u0007\u00027Q,7\u000f\u001e#va2L7-\u0019;f\t\u0016dW\r^3J]&$\u0018.\u0019;fQ\u0011\tY&a\u0011\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002\u001c\u0005aB/Z:u\u0007>dG.Z2u\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c\b\u0006BA1\u0003\u0007Bq!!\u001b\u0001\t\u0013\tY'A\u000bj]&$\u0018.\u0019;f'\u0016<W.\u001a8u+Bdw.\u00193\u0015\u0019\u00055\u0014\u0011PA?\u0003\u000f\u000b9*!)\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cRA!a\u001d\u0002\u0002\u00051!/Z2pe\u0012LA!a\u001e\u0002r\tiQ*Z7pef\u0014VmY8sINDq!a\u001f\u0002h\u0001\u0007q)\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\"A\u0011qPA4\u0001\u0004\t\t)A\u0006mK\u0006$WM]#q_\u000eD\u0007cA\u0005\u0002\u0004&\u0019\u0011Q\u0011\u0006\u0003\u0007%sG\u000f\u0003\u0005\u0002\n\u0006\u001d\u0004\u0019AAF\u0003!y'M[3di&#\u0007\u0003BAG\u0003'k!!a$\u000b\u0007\u0005E\u0015/\u0001\u0003vi&d\u0017\u0002BAK\u0003\u001f\u0013A!V+J\t\"A\u0011\u0011TA4\u0001\u0004\tY*\u0001\u0006cCN,wJ\u001a4tKR\u00042!CAO\u0013\r\tyJ\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0002$\u0006\u001d\u0004\u0019AAN\u0003%)g\u000eZ(gMN,G\u000fC\u0004\u0002(\u0002!I!!+\u00023%t\u0017\u000e^5bi\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0005\u0003[\nY\u000bC\u0004\u0002|\u0005\u0015\u0006\u0019A$\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\u0006I2m\\7qY\u0016$X\rU1si&$\u0018n\u001c8EK2,G/[8o)\u0011\ti'a-\t\u000f\u0005m\u0014Q\u0016a\u0001\u000f\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0016!D7f[>\u0014\u0018PU3d_J$7\u000f\u0006\u0003\u0002n\u0005m\u0006\u0002CA_\u0003k\u0003\r!a0\u0002\u00115,G/\u00193bi\u0006\u0004B!!1\u0002H6\u0011\u00111\u0019\u0006\u0004\u0003\u000b\u0014\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002J\u0006\r'\u0001F!cgR\u0014\u0018m\u0019;US\u0016\u0014X*\u001a;bI\u0006$\u0018\rC\u0004\u0002N\u0002!I!a4\u0002\u0013\r\u0014X-\u0019;f\u0019><G\u0003FAi\u0003;\fy.!;\u0002t\u0006]\u00181 B\u0002\u0005\u001f\u0011\u0019\u0002\u0005\u0003\u0002T\u0006eWBAAk\u0015\r\t9\u000eB\u0001\u0004Y><\u0017\u0002BAn\u0003+\u00141\"\u00112tiJ\f7\r\u001e'pO\"11.a3A\u00025D!\"!9\u0002LB\u0005\t\u0019AAr\u0003\u0019\u0019wN\u001c4jOB!\u00111[As\u0013\u0011\t9/!6\u0003\u00131{wmQ8oM&<\u0007BCAv\u0003\u0017\u0004\n\u00111\u0001\u0002n\u0006\u0001\"M]8lKJ$v\u000e]5d'R\fGo\u001d\t\u0004/\u0005=\u0018bAAy1\t\u0001\"I]8lKJ$v\u000e]5d'R\fGo\u001d\u0005\u000b\u0003k\fY\r%AA\u0002\u0005m\u0015A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\u000b\u0003s\fY\r%AA\u0002\u0005m\u0015!\u0004:fG>4XM]=Q_&tG\u000fC\u00056\u0003\u0017\u0004\n\u00111\u0001\u0002~B\u0019Q&a@\n\u0007\t\u0005aFA\u0005TG\",G-\u001e7fe\"I!&a3\u0011\u0002\u0003\u0007!Q\u0001\t\u0005\u0005\u000f\u0011Y!\u0004\u0002\u0003\n)\u0019q&!\u0001\n\t\t5!\u0011\u0002\u0002\u0005)&lW\r\u0003\u0006\u0003\u0012\u0005-\u0007\u0013!a\u0001\u0003\u0003\u000b\u0011$\\1y!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\"Q!QCAf!\u0003\u0005\r!!!\u0002GA\u0014x\u000eZ;dKJLE-\u0012=qSJ\fG/[8o\u0007\",7m[%oi\u0016\u0014h/\u00197Ng\u001a1!\u0011\u0004\u0001\u0005\u00057\u0011\u0001\u0002T5ti\u0016tWM]\n\u0006\u0005/A!Q\u0004\t\u0004%\t}\u0011b\u0001B\u0011\u0005\tyB)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:DQ\u0006tw-\u001a'jgR,g.\u001a:\t\u000f=\u00119\u0002\"\u0001\u0003&Q\u0011!q\u0005\t\u0005\u0005S\u00119\"D\u0001\u0001\u0011!\t9Ka\u0006\u0005B\t5BCBA\u000f\u0005_\u0011\t\u0004C\u0004\u0002|\t-\u0002\u0019A$\t\ru\u0012Y\u00031\u0001K\u0011!\u0011)Da\u0006\u0005B\t]\u0012!F:u_B\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0005\u0003;\u0011I\u0004C\u0004\u0002|\tM\u0002\u0019A$\t\u0013\tu\u0002!%A\u0005\n\t}\u0012aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\u0012TC\u0001B!U\u0011\t\u0019Oa\u0011,\u0005\t\u0015\u0003\u0003\u0002B$\u0005#j!A!\u0013\u000b\t\t-#QJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0014\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005'\u0012IEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba\u0016\u0001#\u0003%IA!\u0017\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tm#\u0006BAw\u0005\u0007B\u0011Ba\u0018\u0001#\u0003%IA!\u0019\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\r$\u0006BAN\u0005\u0007B\u0011Ba\u001a\u0001#\u0003%IA!\u0019\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001b\t\u0013\t-\u0004!%A\u0005\n\t5\u0014aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u00122TC\u0001B8U\u0011\tiPa\u0011\t\u0013\tM\u0004!%A\u0005\n\tU\u0014aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012:TC\u0001B<U\u0011\u0011)Aa\u0011\t\u0013\tm\u0004!%A\u0005\n\tu\u0014aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012BTC\u0001B@U\u0011\t\tIa\u0011\t\u0013\t\r\u0005!%A\u0005\n\tu\u0014aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012J\u0004")
public class TierDeletedPartitionsCoordinatorTest {
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = this.time().scheduler();
    private final scala.collection.mutable.Map<TopicIdPartition, List<TierObjectStore.ObjectMetadata>> tieredObjects = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final TierDeletedPartitionsCoordinator kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator = new TierDeletedPartitionsCoordinator((Scheduler)this.scheduler(), this.replicaManager(), this.tierTopicConsumer(), 1L, "foo", (Time)this.time());
    private final File dir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.dir());
    private final TopicPartition tierTopicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir());

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    private MockTime time() {
        return this.time;
    }

    private MockScheduler scheduler() {
        return this.scheduler;
    }

    private scala.collection.mutable.Map<TopicIdPartition, List<TierObjectStore.ObjectMetadata>> tieredObjects() {
        return this.tieredObjects;
    }

    public TierDeletedPartitionsCoordinator kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator;
    }

    private File dir() {
        return this.dir;
    }

    private File logDir() {
        return this.logDir;
    }

    private TopicPartition tierTopicPartition() {
        return this.tierTopicPartition;
    }

    @Before
    public void setup() {
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().registerListener((DeletedPartitionsChangeListener)new Listener());
    }

    @After
    public void teardown() {
        this.dir().delete();
    }

    @Test
    public void testInitiateDeletion() {
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-1", UUID.randomUUID(), 0), new TopicIdPartition("foo-2", UUID.randomUUID(), 2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-3", UUID.randomUUID(), 0)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierDeletedPartitionsCoordinatorTest $outer;

            public final void apply(int tierTopicPartitionId) {
                this.apply$mcVI$sp(tierTopicPartitionId);
            }

            public void apply$mcVI$sp(int tierTopicPartitionId) {
                this.$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        deletedPartitionsMap.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierDeletedPartitionsCoordinatorTest $outer;

            public final void apply(Tuple2<Object, scala.collection.immutable.Set<TopicIdPartition>> x0$1) {
                Tuple2<Object, scala.collection.immutable.Set<TopicIdPartition>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int tierTopicPartitionId = tuple2._1$mcI$sp();
                    scala.collection.immutable.Set deletedPartitions = (scala.collection.immutable.Set)tuple2._2();
                    deletedPartitions.foreach((Function1)new Serializable(this, tierTopicPartitionId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testInitiateDeletion$2 $outer;
                        private final int tierTopicPartitionId$1;

                        public final void apply(TopicIdPartition deletedPartition) {
                            this.$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$anonfun$$$outer().kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(this.tierTopicPartitionId$1, deletedPartition, 10L);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.tierTopicPartitionId$1 = tierTopicPartitionId$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ TierDeletedPartitionsCoordinatorTest kafka$tier$TierDeletedPartitionsCoordinatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        scala.collection.mutable.Map immigratedPartitions = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().immigratedPartitions();
        Assert.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Set<TopicIdPartition>> apply(Tuple2<Object, ImmigratedTierTopicPartition> x0$2) {
                Tuple2<Object, ImmigratedTierTopicPartition> tuple2 = x0$2;
                if (tuple2 != null) {
                    int tierTopicPartitionId = tuple2._1$mcI$sp();
                    ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom()));
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(1, new TopicIdPartition("foo", UUID.randomUUID(), 0), 20L);
        Assert.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Set<TopicIdPartition>> apply(Tuple2<Object, ImmigratedTierTopicPartition> x0$3) {
                Tuple2<Object, ImmigratedTierTopicPartition> tuple2 = x0$3;
                if (tuple2 != null) {
                    int tierTopicPartitionId = tuple2._1$mcI$sp();
                    ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCompleteDeletion() {
        TopicIdPartition foo_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition foo_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 2);
        TopicIdPartition foo_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 5);
        LongRef offset = LongRef.create((long)0L);
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_1, foo_2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierDeletedPartitionsCoordinatorTest $outer;

            public final void apply(int tierTopicPartitionId) {
                this.apply$mcVI$sp(tierTopicPartitionId);
            }

            public void apply$mcVI$sp(int tierTopicPartitionId) {
                this.$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        deletedPartitionsMap.foreach((Function1)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierDeletedPartitionsCoordinatorTest $outer;
            public final LongRef offset$1;

            public final void apply(Tuple2<Object, scala.collection.immutable.Set<TopicIdPartition>> x0$4) {
                Tuple2<Object, scala.collection.immutable.Set<TopicIdPartition>> tuple2 = x0$4;
                if (tuple2 != null) {
                    int tierTopicPartitionId = tuple2._1$mcI$sp();
                    scala.collection.immutable.Set deletedPartitions = (scala.collection.immutable.Set)tuple2._2();
                    deletedPartitions.foreach((Function1)new Serializable(this, tierTopicPartitionId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testCompleteDeletion$2 $outer;
                        private final int tierTopicPartitionId$2;

                        public final void apply(TopicIdPartition deletedPartition) {
                            this.$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$anonfun$$$outer().kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(this.tierTopicPartitionId$2, deletedPartition, this.$outer.offset$1.elem);
                            ++this.$outer.offset$1.elem;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.tierTopicPartitionId$2 = tierTopicPartitionId$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ TierDeletedPartitionsCoordinatorTest kafka$tier$TierDeletedPartitionsCoordinatorTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
            }
        });
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackCompletePartitionDelete(0, foo_1);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackCompletePartitionDelete(3, foo_3);
        scala.collection.mutable.Map immigratedPartitions = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().immigratedPartitions();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_2})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)0))).pendingDeletions().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)3))).pendingDeletions().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)5))).pendingDeletions().keySet());
        Assert.assertEquals((long)3L, (long)immigratedPartitions.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().handleEmigration(0);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), (Object)immigratedPartitions.keySet());
    }

    @Test
    public void testBeginMaterialization() {
        Tuple2 foo_1 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-1", UUID.randomUUID(), 0));
        Tuple2 foo_2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-2", UUID.randomUUID(), 2));
        Tuple2 foo_3 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-3", UUID.randomUUID(), 2));
        Tuple2 foo_4 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new TopicIdPartition("foo-4", UUID.randomUUID(), 5));
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().handleImmigration(0);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().handleImmigration(3);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 10L);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 20L);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_4._1$mcI$sp(), (TopicIdPartition)foo_4._2(), 30L);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 31L);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map immigratedPartitions = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().immigratedPartitions();
        Assert.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_1._1$mcI$sp()))).inProgressDeletions().contains(foo_1._2()));
        Assert.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_2._1$mcI$sp()))).inProgressDeletions().contains(foo_2._2()));
        Assert.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_4._1$mcI$sp()))).inProgressDeletions().contains(foo_4._2()));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)immigratedPartitions.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ImmigratedTierTopicPartition x$1) {
                return x$1.pendingDeletions().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 32L);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 34L);
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)immigratedPartitions.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ImmigratedTierTopicPartition x$2) {
                return x$2.pendingDeletions().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        ((TierTopicConsumer)Mockito.verify((Object)this.tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).register((Map)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Map<TopicIdPartition, TierTopicConsumer.ClientCtx>>(this, foo_1, foo_2, foo_4){
            private final Tuple2 foo_1$1;
            private final Tuple2 foo_2$1;
            private final Tuple2 foo_4$1;

            public boolean matches(Map<TopicIdPartition, TierTopicConsumer.ClientCtx> argument) {
                Object object = JavaConverters$.MODULE$.asScalaSetConverter(argument.keySet()).asScala();
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)this.foo_1$1._2(), (TopicIdPartition)this.foo_2$1._2(), (TopicIdPartition)this.foo_4$1._2()}));
                return !(object != null ? !object.equals(genTraversable) : genTraversable != null);
            }
            {
                this.foo_1$1 = foo_1$1;
                this.foo_2$1 = foo_2$1;
                this.foo_4$1 = foo_4$1;
            }
        }));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tierTopicConsumer()});
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_3._1$mcI$sp(), (TopicIdPartition)foo_3._2(), 100L);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).pendingDeletions().keySet());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).inProgressDeletions().keySet());
    }

    @Test
    public void testDeletePartition() {
        int tierTopicPartition = 1;
        TopicIdPartition deletedPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        TopicIdPartition deletedPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 0);
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments_1 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this, deletedPartition_1){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition deletedPartition_1$1;

            public final TierObjectStore.ObjectMetadata apply(int i) {
                return new TierObjectStore.ObjectMetadata(this.deletedPartition_1$1, UUID.randomUUID(), 0, (long)i, false);
            }
            {
                this.deletedPartition_1$1 = deletedPartition_1$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.tieredObjects().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deletedPartition_1), (Object)tieredSegments_1.toList()));
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_1, (long)deleteInitiateOffset_1);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_2, (long)deleteInitiateOffset_2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)((ImmigratedTierTopicPartition)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().keySet());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map inProgressPartitions = ((ImmigratedTierTopicPartition)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions();
        Assert.assertEquals((long)2L, (long)inProgressPartitions.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MaterializingState$[]{MaterializingState$.MODULE$, MaterializingState$.MODULE$})), (Object)inProgressPartitions.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DeletionState apply(InProgressDeletion x$3) {
                return x$3.currentState();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
        Assert.assertTrue((boolean)((ImmigratedTierTopicPartition)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().isEmpty());
        InProgressDeletion inProgress_1 = (InProgressDeletion)inProgressPartitions.apply((Object)deletedPartition_1);
        tieredSegments_1.foreach((Function1)new Serializable(this, inProgress_1){
            public static final long serialVersionUID = 0L;
            private final InProgressDeletion inProgress_1$1;

            public final TierPartitionState.AppendResult apply(TierObjectStore.ObjectMetadata segment) {
                return this.inProgress_1$1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100, false, false, false), 0L);
            }
            {
                this.inProgress_1$1 = inProgress_1$1;
            }
        });
        inProgress_1.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(deletedPartition_1, 0, UUID.randomUUID()), (long)deleteInitiateOffset_1);
        Assert.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().maybeBeginDeletion();
        Assert.assertEquals((Object)AwaitingDeleteComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackCompletePartitionDelete(tierTopicPartition, deletedPartition_1);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MaterializingState$[]{MaterializingState$.MODULE$})), (Object)inProgressPartitions.values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DeletionState apply(InProgressDeletion x$4) {
                return x$4.currentState();
            }
        }, Iterable$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDuplicateDeleteInitiate() {
        int tierTopicPartition = 1;
        TopicIdPartition partition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        int deleteCompleteOffset_1 = 15;
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition partition$1;

            public final TierObjectStore.ObjectMetadata apply(int i) {
                return new TierObjectStore.ObjectMetadata(this.partition$1, UUID.randomUUID(), 0, (long)i, false);
            }
            {
                this.partition$1 = partition$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.tieredObjects().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)tieredSegments.toList()));
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, partition, (long)deleteInitiateOffset_2);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map inProgressPartitions = ((ImmigratedTierTopicPartition)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions();
        InProgressDeletion inProgress = (InProgressDeletion)inProgressPartitions.apply((Object)partition);
        LongRef offset = LongRef.create((long)0L);
        tieredSegments.foreach((Function1)new Serializable(this, inProgress, offset){
            public static final long serialVersionUID = 0L;
            private final InProgressDeletion inProgress$1;
            private final LongRef offset$2;

            public final void apply(TierObjectStore.ObjectMetadata segment) {
                this.inProgress$1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100, false, false, false), this.offset$2.elem);
                ++this.offset$2.elem;
            }
            {
                this.inProgress$1 = inProgress$1;
                this.offset$2 = offset$2;
            }
        });
        Mockito.reset((Object[])new TierTopicConsumer[]{this.tierTopicConsumer()});
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), (long)deleteInitiateOffset_1);
        Assert.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), (long)deleteCompleteOffset_1);
        Assert.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        ((TierTopicConsumer)Mockito.verify((Object)this.tierTopicConsumer(), (VerificationMode)Mockito.never())).deregister(partition);
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), (long)deleteInitiateOffset_2);
        Assert.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), (long)(deleteInitiateOffset_2 + 1));
        ((TierTopicConsumer)Mockito.verify((Object)this.tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).deregister(partition);
    }

    @Test
    public void testCollectDeletedPartitions() {
        AbstractLog log2 = this.createLog(this.logDir(), this.createLog$default$2(), this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9());
        int leaderEpoch = 0;
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().handleImmigration(this.tierTopicPartition().partition());
        Mockito.when((Object)this.replicaManager().getLog(this.tierTopicPartition())).thenReturn((Object)new Some((Object)log2));
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 3);
        List records2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MemoryRecords[]{this.initiateSegmentUpload(topicIdPartition_1, 0, UUID.randomUUID(), 0L, 100L), this.initiatePartitionDeletion(topicIdPartition_1), this.initiateSegmentUpload(topicIdPartition_2, 0, UUID.randomUUID(), 100L, 1000L), this.initiatePartitionDeletion(topicIdPartition_2), this.completePartitionDeletion(topicIdPartition_1)}));
        records2.foreach((Function1)new Serializable(this, log2, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$1;
            private final int leaderEpoch$1;

            public final LogAppendInfo apply(MemoryRecords record) {
                return this.log$1.appendAsLeader(record, this.leaderEpoch$1, this.log$1.appendAsLeader$default$3(), this.log$1.appendAsLeader$default$4());
            }
            {
                this.log$1 = log$1;
                this.leaderEpoch$1 = leaderEpoch$1;
            }
        });
        log2.updateHighWatermark(log2.logEndOffset());
        ByteBuffer buffer = ByteBuffer.allocate(200);
        Tuple2 tuple2 = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), 0L, buffer);
        if (tuple2 != null) {
            long lastReadOffset;
            long l;
            long lastReadOffset2 = l = (lastReadOffset = tuple2._1$mcJ$sp());
            Assert.assertEquals((long)log2.logEndOffset(), (long)lastReadOffset2);
            ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)this.tierTopicPartition().partition()));
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition_2})), (Object)immigratedPartition.pendingDeletions().keySet().toList());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private MemoryRecords initiateSegmentUpload(TopicIdPartition topicIdPartition, int leaderEpoch, UUID objectId, long baseOffset, long endOffset) {
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, objectId, baseOffset, endOffset, 10L, 500, true, true, true);
        return this.memoryRecords((AbstractTierMetadata)uploadInitiate);
    }

    private MemoryRecords initiatePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteInitiate(topicIdPartition, 0, UUID.randomUUID()));
    }

    private MemoryRecords completePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteComplete(topicIdPartition, UUID.randomUUID()));
    }

    private MemoryRecords memoryRecords(AbstractTierMetadata metadata) {
        return MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, metadata.serializeKey(), metadata.serializeValue())});
    }

    private AbstractLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, long logStartOffset, long recoveryPoint, Scheduler scheduler, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs) {
        return LogTest$.MODULE$.createLog(dir, config, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, LogTest$.MODULE$.createLog$default$10());
    }

    private LogConfig createLog$default$2() {
        return LogTest$.MODULE$.createLogConfig(LogTest$.MODULE$.createLogConfig$default$1(), LogTest$.MODULE$.createLogConfig$default$2(), LogTest$.MODULE$.createLogConfig$default$3(), LogTest$.MODULE$.createLogConfig$default$4(), LogTest$.MODULE$.createLogConfig$default$5(), LogTest$.MODULE$.createLogConfig$default$6(), LogTest$.MODULE$.createLogConfig$default$7(), LogTest$.MODULE$.createLogConfig$default$8(), LogTest$.MODULE$.createLogConfig$default$9(), LogTest$.MODULE$.createLogConfig$default$10(), LogTest$.MODULE$.createLogConfig$default$11(), LogTest$.MODULE$.createLogConfig$default$12(), LogTest$.MODULE$.createLogConfig$default$13(), LogTest$.MODULE$.createLogConfig$default$14(), LogTest$.MODULE$.createLogConfig$default$15(), LogTest$.MODULE$.createLogConfig$default$16());
    }

    private BrokerTopicStats createLog$default$3() {
        return new BrokerTopicStats();
    }

    private long createLog$default$4() {
        return 0L;
    }

    private long createLog$default$5() {
        return 0L;
    }

    private Scheduler createLog$default$6() {
        return this.scheduler();
    }

    private Time createLog$default$7() {
        return this.time();
    }

    private int createLog$default$8() {
        return 3600000;
    }

    private int createLog$default$9() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public class Listener
    implements DeletedPartitionsChangeListener {
        public void initiatePartitionDeletion(TopicIdPartition topicIdPartition, List<TierObjectStore.ObjectMetadata> tieredObjects) {
        }

        public void stopPartitionDeletion(TopicIdPartition topicIdPartition) {
        }

        public /* synthetic */ TierDeletedPartitionsCoordinatorTest kafka$tier$TierDeletedPartitionsCoordinatorTest$Listener$$$outer() {
            return TierDeletedPartitionsCoordinatorTest.this;
        }

        public Listener() {
            if (TierDeletedPartitionsCoordinatorTest.this == null) {
                throw null;
            }
        }
    }
}

