/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.TierEpochStateRevolvingReplicationTest$;
import kafka.tier.TierTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001\u001d\u0011a\u0005V5fe\u0016\u0003xn\u00195Ti\u0006$XMU3w_24\u0018N\\4SKBd\u0017nY1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0003uS\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aA1qS&\u0011QB\u0003\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tgB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!9!\u0004\u0001b\u0001\n#Z\u0012a\u00032s_.,'oQ8v]R,\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0004\u0013:$\bBB\u0012\u0001A\u0003%A$\u0001\u0007ce>\\WM]\"pk:$\b\u0005C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002\u000bQ|\u0007/[2\u0016\u0003\u001d\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\t1\fgn\u001a\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013F\u0001\u0004TiJLgn\u001a\u0005\u0007a\u0001\u0001\u000b\u0011B\u0014\u0002\rQ|\u0007/[2!\u0011\u001d\u0011\u0004A1A\u0005\u0002M\n1!\\:h+\u0005!\u0004cA\u000f6o%\u0011aG\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003;aJ!!\u000f\u0010\u0003\t\tKH/\u001a\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u001b\u0002\t5\u001cx\r\t\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0003\u0019)\u00070\u001b;fIV\tq\b\u0005\u0002A\u000f6\t\u0011I\u0003\u0002C\u0007\u00061\u0011\r^8nS\u000eT!\u0001R#\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002GW\u0005!Q\u000f^5m\u0013\tA\u0015IA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007\u0015\u0002\u0001\u000b\u0011B \u0002\u000f\u0015D\u0018\u000e^3eA!)A\n\u0001C!\u001b\u0006)1/\u001a;VaR\ta\n\u0005\u0002\u001e\u001f&\u0011\u0001K\b\u0002\u0005+:LG\u000f\u000b\u0002L%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002/\u0006\u0019qN]4\n\u0005e#&A\u0002\"fM>\u0014X\rC\u0003\\\u0001\u0011\u0005S*\u0001\u0005uK\u0006\u0014Hi\\<oQ\tQV\f\u0005\u0002T=&\u0011q\f\u0016\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006C\u0002!\t!T\u0001\"i\u0016\u001cH\u000fV5feN#\u0018\r^3SKN$xN]3U_J+\u0007\u000f\\5dCRLwN\u001c\u0015\u0003A\u000e\u0004\"a\u00153\n\u0005\u0015$&\u0001\u0002+fgRDQa\u001a\u0001\u0005\n!\f!d^1ji\u001a{'\u000fT8h\u000b:$wJ\u001a4tKR$v.T1uG\"$BAT5rg\")!N\u001aa\u0001W\u0006\u0011!-\r\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u0012\taa]3sm\u0016\u0014\u0018B\u00019n\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000bI4\u0007\u0019A6\u0002\u0005\t\u0014\u0004\"\u0002;g\u0001\u0004a\u0012!\u00039beRLG/[8o\u0011\u00151\b\u0001\"\u0003x\u0003\u00199W\r\u001e'pOR!\u0001P`A\u0001!\tIH0D\u0001{\u0015\tYH!A\u0002m_\u001eL!! >\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\u0006\u007fV\u0004\ra[\u0001\u0007EJ|7.\u001a:\t\u000bQ,\b\u0019\u0001\u000f\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\u0005QQ\r]8dQ\u000e\u000b7\r[3\u0015\t\u0005%\u0011Q\u0003\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB7\u0002\u000b\u0015\u0004xn\u00195\n\t\u0005M\u0011Q\u0002\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3\t\r}\f\u0019\u00011\u0001l\u0011\u001d\tI\u0002\u0001C\u0005\u00037\t\u0001\"Y<bSRL5K\u0015\u000b\b\u001d\u0006u\u00111GA\u001c\u0011!\ty\"a\u0006A\u0002\u0005\u0005\u0012A\u0001;q!\u0011\t\u0019#a\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\taaY8n[>t'bA\u0003\u0002,)\u0019\u0011Q\u0006,\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\t$!\n\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011QGA\f\u0001\u0004a\u0012a\u00038v[J+\u0007\u000f\\5dCNDq!!\u000f\u0002\u0018\u0001\u00071.\u0001\u0004mK\u0006$WM\u001d")
public class TierEpochStateRevolvingReplicationTest
extends IntegrationTestHarness {
    private final int brokerCount;
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final AtomicBoolean exited = new AtomicBoolean(false);

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @Before
    public void setUp() {
        Exit.setExitProcedure((Exit.Procedure)new Exit.Procedure(this){
            private final /* synthetic */ TierEpochStateRevolvingReplicationTest $outer;

            public void execute(int statusCode, String message) {
                this.$outer.exited().set(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        Assert.assertFalse((boolean)this.exited().get());
        super.tearDown();
    }

    @Test
    public void testTierStateRestoreToReplication() {
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("segment.bytes", "2000");
        properties.put("retention.bytes", "-1");
        properties.put("confluent.tier.local.hotset.bytes", "0");
        properties.put("min.insync.replicas", "2");
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        int leaderId = ((Tuple2)this.createTopic(this.topic(), 1, 3, properties).head())._2$mcI$sp();
        KafkaServer leader2 = (KafkaServer)this.servers().find((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaServer x$1) {
                return x$1.config().brokerId() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }).get();
        this.kafka$tier$TierEpochStateRevolvingReplicationTest$$awaitISR(tp, 3, leader2);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer b) {
                TierTestUtils$.MODULE$.awaitTierTopicPartition(b, Predef$.MODULE$.int2Integer(0));
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, tp, leaderId, leader2, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierEpochStateRevolvingReplicationTest $outer;
            public final TopicPartition tp$1;
            public final int leaderId$1;
            public final KafkaServer leader$1;
            public final KafkaProducer producer$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                int followerToShutdown = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.$outer.servers().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(KafkaServer x$2) {
                        return x$2.config().brokerId();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTierStateRestoreToReplication$1 $outer;

                    public final boolean apply(int x$3) {
                        return this.apply$mcZI$sp(x$3);
                    }

                    public boolean apply$mcZI$sp(int x$3) {
                        return x$3 != this.$outer.leaderId$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).head());
                this.$outer.killBroker(followerToShutdown);
                this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$awaitISR(this.tp$1, 2, this.leader$1);
                this.producer$1.send(new ProducerRecord(this.tp$1.topic(), Predef$.MODULE$.int2Integer(this.tp$1.partition()), null, (Object)this.$outer.msg())).get();
                LogManager qual$1 = this.leader$1.replicaManager().logManager();
                TopicPartition x$4 = this.tp$1;
                boolean x$5 = qual$1.getLog$default$2();
                long logEndPriorToProduce = ((AbstractLog)qual$1.getLog(x$4, x$5).get()).localLogEndOffset();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTierStateRestoreToReplication$1 $outer;

                    public final RecordMetadata apply(int _) {
                        return (RecordMetadata)this.$outer.producer$1.send(new ProducerRecord(this.$outer.tp$1.topic(), Predef$.MODULE$.int2Integer(this.$outer.tp$1.partition()), null, (Object)this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$anonfun$$$outer().msg())).get();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, logEndPriorToProduce){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTierStateRestoreToReplication$1 $outer;
                    private final long logEndPriorToProduce$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        boolean x$7;
                        TopicPartition x$6;
                        LogManager qual$2 = this.$outer.leader$1.replicaManager().logManager();
                        Option leaderLog = qual$2.getLog(x$6 = this.$outer.tp$1, x$7 = qual$2.getLog$default$2());
                        return ((AbstractLog)leaderLog.get()).localLogStartOffset() > this.logEndPriorToProduce$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.logEndPriorToProduce$1 = logEndPriorToProduce$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "timed out waiting for segment tiering and deletion";
                    }
                }, 60000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
                this.$outer.restartDeadBrokers();
                this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$awaitISR(this.tp$1, 3, this.leader$1);
                this.producer$1.send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg())).get();
                this.$outer.servers().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTierStateRestoreToReplication$1 $outer;

                    public final void apply(KafkaServer broker) {
                        this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$anonfun$$$outer().kafka$tier$TierEpochStateRevolvingReplicationTest$$waitForLogEndOffsetToMatch(this.$outer.leader$1, broker, 0);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.servers().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testTierStateRestoreToReplication$1 $outer;

                    public final void apply(KafkaServer broker) {
                        Assert.assertEquals((Object)this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$anonfun$$$outer().kafka$tier$TierEpochStateRevolvingReplicationTest$$epochCache(broker).epochEntries(), (Object)this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$anonfun$$$outer().kafka$tier$TierEpochStateRevolvingReplicationTest$$epochCache(this.$outer.leader$1).epochEntries());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TierEpochStateRevolvingReplicationTest kafka$tier$TierEpochStateRevolvingReplicationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
                this.leaderId$1 = leaderId$1;
                this.leader$1 = leader$1;
                this.producer$1 = producer$1;
            }
        });
    }

    public void kafka$tier$TierEpochStateRevolvingReplicationTest$$waitForLogEndOffsetToMatch(KafkaServer b1, KafkaServer b2, int partition) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, b1, b2, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierEpochStateRevolvingReplicationTest $outer;
            private final KafkaServer b1$1;
            private final KafkaServer b2$1;
            private final int partition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$getLog(this.b1$1, this.partition$1).logEndOffset() == this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$getLog(this.b2$1, this.partition$1).logEndOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.b1$1 = b1$1;
                this.b2$1 = b2$1;
                this.partition$1 = partition$1;
            }
        }, (Function0<String>)new Serializable(this, b1, b2, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierEpochStateRevolvingReplicationTest $outer;
            private final KafkaServer b1$1;
            private final KafkaServer b2$1;
            private final int partition$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logs didn't match ", " vs ", ". ", " v ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$getLog(this.b1$1, this.partition$1).logEndOffset()), BoxesRunTime.boxToLong((long)this.$outer.kafka$tier$TierEpochStateRevolvingReplicationTest$$getLog(this.b2$1, this.partition$1).logEndOffset()), BoxesRunTime.boxToInteger((int)this.b1$1.config().brokerId()), BoxesRunTime.boxToInteger((int)this.b2$1.config().brokerId())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.b1$1 = b1$1;
                this.b2$1 = b2$1;
                this.partition$1 = partition$1;
            }
        }, 60000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public AbstractLog kafka$tier$TierEpochStateRevolvingReplicationTest$$getLog(KafkaServer broker, int partition) {
        LogManager qual$3 = broker.logManager();
        TopicPartition x$8 = new TopicPartition(this.topic(), partition);
        boolean x$9 = qual$3.getLog$default$2();
        return (AbstractLog)qual$3.getLog(x$8, x$9).orNull(Predef$.MODULE$.$conforms());
    }

    public LeaderEpochFileCache kafka$tier$TierEpochStateRevolvingReplicationTest$$epochCache(KafkaServer broker) {
        AbstractLog log2 = this.kafka$tier$TierEpochStateRevolvingReplicationTest$$getLog(broker, 0);
        return (LeaderEpochFileCache)log2.leaderEpochCache().get();
    }

    public void kafka$tier$TierEpochStateRevolvingReplicationTest$$awaitISR(TopicPartition tp, int numReplicas, KafkaServer leader2) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, numReplicas, leader2){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$2;
            private final int numReplicas$1;
            private final KafkaServer leader$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Partition)this.leader$2.replicaManager().nonOfflinePartition(this.tp$2).get()).inSyncReplicaIds().size() == this.numReplicas$1;
            }
            {
                this.tp$2 = tp$2;
                this.numReplicas$1 = numReplicas$1;
                this.leader$2 = leader$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for replicas to join ISR";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public TierEpochStateRevolvingReplicationTest() {
        this.brokerCount = 3;
        this.topic = "topic1";
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "5");
    }
}

