/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TierIntegrationTransactionTest$;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0001\u0003\u0001\u001d\u0011a\u0004V5fe&sG/Z4sCRLwN\u001c+sC:\u001c\u0018m\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u0002;jKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0019\u0011\r]5\n\u00055Q!AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t#*\u0012a\u00032s_.,'oQ8v]R,\u0012A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0004\u0013:$\b\"B\u000f\u0001\t\u0013q\u0012!D2p]\u001aLw-\u001e:f\u001b>\u001c7.F\u0001 !\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0003mC:<'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u0012aa\u00142kK\u000e$\bb\u0002\u0015\u0001\u0005\u0004%I!K\u0001\u0006i>\u0004\u0018nY\u000b\u0002UA\u0011\u0001eK\u0005\u0003Y\u0005\u0012aa\u0015;sS:<\u0007B\u0002\u0018\u0001A\u0003%!&\u0001\u0004u_BL7\r\t\u0005\ba\u0001\u0011\r\u0011\"\u0003\u0016\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\u0005\u0007e\u0001\u0001\u000b\u0011\u0002\f\u0002\u0017A\f'\u000f^5uS>t7\u000f\t\u0005\bi\u0001\u0001\r\u0011\"\u00036\u0003E\u0001\u0018M\u001d;ji&|g\u000eV8MK\u0006$WM]\u000b\u0002mA!qG\u000f\f\u0017\u001d\t9\u0002(\u0003\u0002:1\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\u00075\u000b\u0007O\u0003\u0002:1!9a\b\u0001a\u0001\n\u0013y\u0014!\u00069beRLG/[8o)>dU-\u00193fe~#S-\u001d\u000b\u0003\u0001\u000e\u0003\"aF!\n\u0005\tC\"\u0001B+oSRDq\u0001R\u001f\u0002\u0002\u0003\u0007a'A\u0002yIEBaA\u0012\u0001!B\u00131\u0014A\u00059beRLG/[8o)>dU-\u00193fe\u0002BQ\u0001\u0013\u0001\u0005\n%\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0002\u0015B\u00191j\u0015,\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(\u0007\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002S1\u00059\u0001/Y2lC\u001e,\u0017B\u0001+V\u0005\r\u0019V-\u001d\u0006\u0003%b\u0001\"aV0\u000e\u0003aS!!\u0017.\u0002\r\r|W.\\8o\u0015\t)1L\u0003\u0002];\u00061\u0011\r]1dQ\u0016T\u0011AX\u0001\u0004_J<\u0017B\u00011Y\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DqA\u0019\u0001C\u0002\u0013\u00051-\u0001\u0004fq&$X\rZ\u000b\u0002IB\u0011Q\r\\\u0007\u0002M*\u0011q\r[\u0001\u0007CR|W.[2\u000b\u0005%T\u0017AC2p]\u000e,(O]3oi*\u00111nI\u0001\u0005kRLG.\u0003\u0002nM\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:Daa\u001c\u0001!\u0002\u0013!\u0017aB3ySR,G\r\t\u0005\u0006c\u0002!\tE]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u0001\"\u0012\u0001\u000f\u001e\t\u0003kbl\u0011A\u001e\u0006\u0003ov\u000bQA[;oSRL!!\u001f<\u0003\r\t+gm\u001c:f\u0011\u0015Y\b\u0001\"\u0011s\u0003!!X-\u0019:E_^t\u0007F\u0001>~!\t)h0\u0003\u0002\u0000m\n)\u0011I\u001a;fe\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0011A\u00049s_\u0012,8-\u001a*fG>\u0014Hm\u001d\u000b\u0006\u0001\u0006\u001d\u00111\u0002\u0005\b\u0003\u0013\t\t\u00011\u0001\u0017\u0003!q')\u0019;dQ\u0016\u001c\bbBA\u0007\u0003\u0003\u0001\rAF\u0001\u0010e\u0016\u001cwN\u001d3t!\u0016\u0014()\u0019;dQ\"9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0011AG4fi2+\u0017\rZ3s\r>\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tGc\u0001\f\u0002\u0016!9\u0011qCA\b\u0001\u00041\u0016\u0001\u00067fC\u0012,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u001c\u0001!I!!\b\u0002/]\f\u0017\u000e^+oi&d7+Z4nK:$8\u000fV5fe\u0016$Gc\u0001!\u0002 !9\u0011\u0011EA\r\u0001\u00041\u0012AD7j]:+XnU3h[\u0016tGo\u001d\u0005\u0007\u0003K\u0001A\u0011\u0002:\u0002#MLW.\u001e7bi\u0016\u0014V\r^3oi&|g\u000e\u0003\u0004\u0002*\u0001!\tA]\u0001(i\u0016\u001cH/\u0011:dQ&4X-\u00118e\r\u0016$8\r[*j]\u001edW\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0003\u0002(\u00055\u0002cA;\u00020%\u0019\u0011\u0011\u0007<\u0003\tQ+7\u000f\u001e")
public class TierIntegrationTransactionTest
extends IntegrationTestHarness {
    private final String kafka$tier$TierIntegrationTransactionTest$$topic;
    private final int partitions;
    private Map<Object, Object> partitionToLeader;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private Object configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        return this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    public String kafka$tier$TierIntegrationTransactionTest$$topic() {
        return this.kafka$tier$TierIntegrationTransactionTest$$topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private Map<Object, Object> partitionToLeader() {
        return this.partitionToLeader;
    }

    private void partitionToLeader_$eq(Map<Object, Object> x$1) {
        this.partitionToLeader = x$1;
    }

    public Seq<TopicPartition> kafka$tier$TierIntegrationTransactionTest$$topicPartitions() {
        return (Seq)package$.MODULE$.Range().apply(0, this.partitions()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTransactionTest $outer;

            public final TopicPartition apply(int p) {
                return new TopicPartition(this.$outer.kafka$tier$TierIntegrationTransactionTest$$topic(), p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @Before
    public void setUp() {
        Exit.setExitProcedure((Exit.Procedure)new Exit.Procedure(this){
            private final /* synthetic */ TierIntegrationTransactionTest $outer;

            public void execute(int statusCode, String message) {
                this.$outer.exited().set(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        super.setUp();
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        props.put("retention.ms", "-1");
        this.partitionToLeader_$eq(this.createTopic(this.kafka$tier$TierIntegrationTransactionTest$$topic(), this.partitions(), 1, props));
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        Assert.assertFalse((boolean)this.exited().get());
    }

    /*
     * WARNING - void declaration
     */
    private void produceRecords(int nBatches, int recordsPerBatch) {
        Properties props = new Properties();
        props.put("transactional.id", "1");
        Properties x$1 = props;
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, x$1);
        producer.initTransactions();
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nBatches).foreach$mVc$sp((Function1)new Serializable(this, recordsPerBatch, producer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TierIntegrationTransactionTest $outer;
                public final int recordsPerBatch$1;
                public final KafkaProducer producer$1;

                public final void apply(int b) {
                    this.apply$mcVI$sp(b);
                }

                public void apply$mcVI$sp(int b) {
                    boolean abortBatch = b % 2 == 0;
                    String key = abortBatch ? "aborted" : "committed";
                    IndexedSeq producerRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.recordsPerBatch$1).map((Function1)new Serializable(this, key, b){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$produceRecords$1 $outer;
                        private final String key$1;
                        private final int b$1;

                        public final ProducerRecord<byte[], byte[]> apply(int i) {
                            int m = this.$outer.recordsPerBatch$1 * this.b$1 + i;
                            long timestamp = (long)this.b$1 + 1L * (long)i;
                            return new ProducerRecord(this.$outer.kafka$tier$TierIntegrationTransactionTest$$anonfun$$$outer().kafka$tier$TierIntegrationTransactionTest$$topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)this.key$1.getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m)})).getBytes(StandardCharsets.UTF_8));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                            this.b$1 = b$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    this.producer$1.beginTransaction();
                    producerRecords.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$produceRecords$1 $outer;

                        public final RecordMetadata apply(ProducerRecord<byte[], byte[]> record) {
                            return (RecordMetadata)this.$outer.producer$1.send(record).get(10L, TimeUnit.SECONDS);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (abortBatch) {
                        this.producer$1.abortTransaction();
                    } else {
                        this.producer$1.commitTransaction();
                    }
                }

                public /* synthetic */ TierIntegrationTransactionTest kafka$tier$TierIntegrationTransactionTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.recordsPerBatch$1 = recordsPerBatch$1;
                    this.producer$1 = producer$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var4_7;
            var4_7.close();
            throw throwable;
        }
        producer.close();
    }

    public int kafka$tier$TierIntegrationTransactionTest$$getLeaderForTopicPartition(TopicPartition leaderTopicPartition) {
        return BoxesRunTime.unboxToInt((Object)this.partitionToLeader().apply((Object)BoxesRunTime.boxToInteger((int)leaderTopicPartition.partition())));
    }

    private void waitUntilSegmentsTiered(int minNumSegments) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, minNumSegments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTransactionTest $outer;
            public final int minNumSegments$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.kafka$tier$TierIntegrationTransactionTest$$topicPartitions().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitUntilSegmentsTiered$1 $outer;

                    public final boolean apply(TopicPartition tp) {
                        int leaderId = this.$outer.kafka$tier$TierIntegrationTransactionTest$$anonfun$$$outer().kafka$tier$TierIntegrationTransactionTest$$getLeaderForTopicPartition(tp);
                        Option<KafkaServer> server = this.$outer.kafka$tier$TierIntegrationTransactionTest$$anonfun$$$outer().serverForId(leaderId);
                        LogManager qual$1 = ((KafkaServer)server.get()).logManager();
                        TopicPartition x$4 = tp;
                        boolean x$5 = qual$1.getLog$default$2();
                        TierPartitionState tierPartitionState2 = ((AbstractLog)qual$1.getLog(x$4, x$5).get()).tierPartitionState();
                        long endOffset = tierPartitionState2.endOffset();
                        long committedEndOffset = tierPartitionState2.committedEndOffset();
                        return endOffset > 0L && committedEndOffset > 0L && endOffset == committedEndOffset && tierPartitionState2.numSegments() > this.$outer.minNumSegments$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TierIntegrationTransactionTest kafka$tier$TierIntegrationTransactionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.minNumSegments$1 = minNumSegments$1;
            }
        }, (Function0<String>)new Serializable(this, minNumSegments){
            public static final long serialVersionUID = 0L;
            private final int minNumSegments$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timeout waiting for at least ", " to be archived and materialized"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.minNumSegments$1)}));
            }
            {
                this.minNumSegments$1 = minNumSegments$1;
            }
        }, 60000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void simulateRetention() {
        this.kafka$tier$TierIntegrationTransactionTest$$topicPartitions().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTransactionTest $outer;

            public final void apply(TopicPartition tp) {
                boolean x$7;
                TopicPartition x$6;
                int leaderId = this.$outer.kafka$tier$TierIntegrationTransactionTest$$getLeaderForTopicPartition(tp);
                Option<KafkaServer> server = this.$outer.serverForId(leaderId);
                LogManager qual$2 = ((KafkaServer)server.get()).replicaManager().logManager();
                int numDeleted = ((AbstractLog)qual$2.getLog(x$6 = tp, x$7 = qual$2.getLog$default$2()).get()).deleteOldSegments();
                Assert.assertTrue((String)"tiered segments should have been deleted", (numDeleted > 0 ? 1 : 0) != 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiveAndFetchSingleTopicPartition() {
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(10);
        this.simulateRetention();
        TopicPartition topicPartition = (TopicPartition)this.kafka$tier$TierIntegrationTransactionTest$$topicPartitions().head();
        String brokerList = TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName());
        Properties consumerProps = new Properties();
        consumerProps.put("bootstrap.servers", brokerList);
        consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        consumerProps.put("max.poll.records", "50000");
        consumerProps.put("isolation.level", "read_committed");
        this.consumerConfig().setProperty("group.id", "foo");
        this.consumerConfig().setProperty("client.id", "foo");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps);
        try {
            ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
            partitions.add(topicPartition);
            partitions.add(new TopicPartition(this.kafka$tier$TierIntegrationTransactionTest$$topic(), 1));
            consumer.assign(partitions);
            consumer.seekToBeginning(partitions);
            ArrayList valuesRead = new ArrayList();
            while (valuesRead.size() < nBatches * recordsPerBatch / 2 - recordsPerBatch) {
                ConsumerRecords records2 = consumer.poll(Duration.ofMillis(1000L));
                records2.forEach((Consumer)new Consumer<ConsumerRecord<String, String>>(this, valuesRead){
                    private final ArrayList valuesRead$1;

                    public void accept(ConsumerRecord<String, String> r) {
                        Assert.assertNotEquals((String)"did not expect to find any aborted records", (Object)r.key(), (Object)"aborted");
                        this.valuesRead$1.add(BoxesRunTime.boxToInteger((int)Integer.parseInt((String)r.value())));
                    }
                    {
                        this.valuesRead$1 = valuesRead$1;
                    }
                });
            }
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.close();
            throw throwable;
        }
        consumer.close();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        String bean = "kafka.server:type=TierFetcher";
        String[] attrs = (String[])((Object[])new String[]{"BytesFetchedTotal"});
        List list = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName(bean), attrs).asList()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Attribute attr) {
                return BoxesRunTime.unboxToDouble((Object)attr.getValue());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
            double bytesFetchedTotal = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(0));
            double d = bytesFetchedTotal;
            double bytesFetchedTotal2 = d;
            Assert.assertTrue((String)"tier fetch metric shows no data fetched from tiered storage", (bytesFetchedTotal2 > 0.0 ? 1 : 0) != 0);
            List list2 = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks.archive:type=TierArchiver,name=BytesPerSec"), (String[])((Object[])new String[]{"MeanRate"})).asList()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Attribute attr) {
                    return BoxesRunTime.unboxToDouble((Object)attr.getValue());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            Some some2 = List$.MODULE$.unapplySeq((Seq)list2);
            if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
                double meanArchiveRate = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some2.get()).apply(0));
                double d2 = meanArchiveRate;
                double meanArchiveRate2 = d2;
                Assert.assertTrue((String)"tier archiver mean rate shows no data uploaded to tiered storage", (meanArchiveRate2 > 0.0 ? 1 : 0) != 0);
                return;
            }
            throw new MatchError((Object)list2);
        }
        throw new MatchError((Object)list);
    }

    public TierIntegrationTransactionTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
        this.configureMock();
        this.kafka$tier$TierIntegrationTransactionTest$$topic = UUID.randomUUID().toString();
        this.partitions = 1;
        this.partitionToLeader = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.exited = new AtomicBoolean(false);
    }
}

