/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.tier.StateScan;
import kafka.tier.StateSeek;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t2A!\u0001\u0002\u0001\u000f\t\tC+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0007>t7-\u001e:sK:\u001c\u0017\u0010V3ti*\u00111\u0001B\u0001\u0005i&,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011\u0005Q#\u0001\rsK\u0006$wK]5uK\u000e{gnY;se\u0016t7-\u001f+fgR$\u0012A\u0006\t\u0003\u0013]I!\u0001\u0007\u0006\u0003\tUs\u0017\u000e\u001e\u0015\u0003'i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000b),h.\u001b;\u000b\u0003}\t1a\u001c:h\u0013\t\tCD\u0001\u0003UKN$\b")
public class TierPartitionStateConcurrencyTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void readWriteConcurrencyTest() {
        File baseDir = TestUtils$.MODULE$.tempDir();
        String topic = UUID.randomUUID().toString();
        int partition = 0;
        UUID topicId = UUID.randomUUID();
        TopicIdPartition tpid = new TopicIdPartition(topic, topicId, partition);
        TopicPartition tp = tpid.topicPartition();
        int runLengthMs = 500;
        int nThreads = 8;
        int epoch = 0;
        FileTierPartitionState state = new FileTierPartitionState(baseDir, tp, true);
        state.setTopicId(tpid.topicId());
        state.beginCatchup();
        state.onCatchUpComplete();
        long startTime = System.currentTimeMillis();
        AtomicLong latestStartOffset = new AtomicLong(0L);
        AtomicReference exception = new AtomicReference();
        AtomicBoolean shutdown2 = new AtomicBoolean(false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), nThreads / 2).foreach$mVc$sp((Function1)new Serializable(this, state, latestStartOffset, exception, shutdown2){
            public static final long serialVersionUID = 0L;
            private final FileTierPartitionState state$1;
            private final AtomicLong latestStartOffset$1;
            private final AtomicReference exception$1;
            private final AtomicBoolean shutdown$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                new Thread(new StateSeek(this.state$1, this.shutdown$1, this.exception$1, this.latestStartOffset$1)).start();
            }
            {
                this.state$1 = state$1;
                this.latestStartOffset$1 = latestStartOffset$1;
                this.exception$1 = exception$1;
                this.shutdown$1 = shutdown$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), nThreads / 2).foreach$mVc$sp((Function1)new Serializable(this, state, latestStartOffset, exception, shutdown2){
            public static final long serialVersionUID = 0L;
            private final FileTierPartitionState state$1;
            private final AtomicLong latestStartOffset$1;
            private final AtomicReference exception$1;
            private final AtomicBoolean shutdown$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                new Thread(new StateScan(this.state$1, this.shutdown$1, this.exception$1, this.latestStartOffset$1)).start();
            }
            {
                this.state$1 = state$1;
                this.latestStartOffset$1 = latestStartOffset$1;
                this.exception$1 = exception$1;
                this.shutdown$1 = shutdown$1;
            }
        });
        try {
            state.append((AbstractTierMetadata)new TierTopicInitLeader(tpid, epoch, UUID.randomUUID(), 0), 0L);
            int size2 = 0;
            int i = 0;
            while (System.currentTimeMillis() < startTime + (long)runLengthMs) {
                TierTestUtils$.MODULE$.uploadWithMetadata((TierPartitionState)state, tpid, epoch, UUID.randomUUID(), (long)(i * 2), (long)(i * 2 + 1), (long)i, (long)i, i, false, true, TierTestUtils$.MODULE$.uploadWithMetadata$default$12());
                state.flush();
                latestStartOffset.set(i * 2);
                size2 += i;
                ++i;
            }
            shutdown2.set(true);
            Thread.sleep(10L);
            if (exception.get() != null) {
                ((Throwable)exception.get()).printStackTrace();
            }
            Assert.assertNull(exception.get());
        }
        catch (Throwable throwable) {
            void var10_10;
            var10_10.delete();
            throw throwable;
        }
        state.delete();
    }
}

