/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.server.KafkaServer;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class TierTestUtils$ {
    public static final TierTestUtils$ MODULE$;

    static {
        new TierTestUtils$();
    }

    public void ensureTierable(AbstractLog log2, long tierEndOffset, TopicPartition topicPartition, int leaderEpoch) {
        LogSegment activeSegment = log2.activeSegment();
        Object object = activeSegment.baseOffset() <= tierEndOffset && activeSegment.readNextOffset() > tierEndOffset ? log2.roll((Option)None$.MODULE$) : BoxedUnit.UNIT;
        Object object2 = tierEndOffset == log2.logEndOffset() ? log2.appendAsFollower(this.createRecords(5, topicPartition, log2.logEndOffset(), leaderEpoch)) : BoxedUnit.UNIT;
        log2.flush();
        Object object3 = log2.highWatermark() <= tierEndOffset ? BoxesRunTime.boxToLong((long)log2.updateHighWatermark(tierEndOffset + 1L)) : BoxedUnit.UNIT;
        Assert.assertTrue((BoxesRunTime.unboxToLong((Object)log2.firstUnstableOffset().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Long.MAX_VALUE;
            }
        })) > tierEndOffset ? 1 : 0) != 0);
    }

    public int ensureTierable$default$4() {
        return 0;
    }

    public MemoryRecords createRecords(int n, TopicPartition partition, long baseOffset, int leaderEpoch) {
        IndexedSeq recList;
        IndexedSeq x$3 = recList = (IndexedSeq)package$.MODULE$.Range().apply(0, n).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(int x$1) {
                return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        long x$4 = baseOffset;
        byte x$5 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$6 = TestUtils$.MODULE$.records$default$3();
        long x$7 = TestUtils$.MODULE$.records$default$4();
        short x$8 = TestUtils$.MODULE$.records$default$5();
        int x$9 = TestUtils$.MODULE$.records$default$6();
        int x$10 = TestUtils$.MODULE$.records$default$8();
        MemoryRecords records2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$3, x$5, x$6, x$7, x$8, x$9, x$4, x$10);
        ByteBuffer filtered = ByteBuffer.allocate(100 * n);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.batches()).asScala()).foreach((Function1)new Serializable(leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch$1;

            public final void apply(MutableRecordBatch x$2) {
                x$2.setPartitionLeaderEpoch(this.leaderEpoch$1);
            }
            {
                this.leaderEpoch$1 = leaderEpoch$1;
            }
        });
        records2.filterTo(partition, new MemoryRecords.RecordFilter(){

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                return MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY;
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return MemoryRecords.readableRecords((ByteBuffer)filtered);
    }

    public void awaitTierTopicPartition(KafkaServer broker, Integer partition) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(broker, partition){
            public static final long serialVersionUID = 0L;
            private final KafkaServer broker$1;
            private final Integer partition$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.broker$1.replicaManager().nonOfflinePartition(new TopicPartition("_confluent-tier-state", Predef$.MODULE$.Integer2int(this.partition$1))).isDefined();
            }
            {
                this.broker$1 = broker$1;
                this.partition$1 = partition$1;
            }
        }, (Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for replicas to join ISR";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public CompletableFuture<TierPartitionState.AppendResult> uploadWithMetadata(TierTopicManager tierTopicManager, TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long startOffset, long endOffset, long maxTimestamp, long lastModifiedTime, int size2, boolean hasAbortedTxnIndex, boolean hasEpochState, boolean hasProducerState) {
        CompletableFuture completableFuture;
        TierPartitionState.AppendResult result;
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, tierEpoch, objectId, startOffset, endOffset, maxTimestamp, size2, hasEpochState, hasAbortedTxnIndex, hasProducerState);
        TierPartitionState.AppendResult appendResult = result = (TierPartitionState.AppendResult)tierTopicManager.addMetadata((AbstractTierMetadata)uploadInitiate).get();
        TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
        if (!(appendResult != null ? !appendResult.equals(appendResult2) : appendResult2 != null)) {
            TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
            completableFuture = tierTopicManager.addMetadata((AbstractTierMetadata)uploadComplete);
        } else {
            completableFuture = CompletableFuture.completedFuture(result);
        }
        return completableFuture;
    }

    public TierPartitionState.AppendResult uploadWithMetadata(TierPartitionState tierPartitionState2, TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long startOffset, long endOffset, long maxTimestamp, long lastModifiedTime, int size2, boolean hasAbortedTxnIndex, boolean hasEpochState, boolean hasProducerState) {
        TierPartitionState.AppendResult appendResult;
        TierPartitionState.AppendResult result;
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, tierEpoch, objectId, startOffset, endOffset, maxTimestamp, size2, hasEpochState, hasAbortedTxnIndex, hasProducerState);
        TierPartitionState.AppendResult appendResult2 = result = tierPartitionState2.append((AbstractTierMetadata)uploadInitiate, 0L);
        TierPartitionState.AppendResult appendResult3 = TierPartitionState.AppendResult.ACCEPTED;
        if (!(appendResult2 != null ? !appendResult2.equals(appendResult3) : appendResult3 != null)) {
            TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
            appendResult = tierPartitionState2.append((AbstractTierMetadata)uploadComplete, 0L);
        } else {
            appendResult = result;
        }
        return appendResult;
    }

    public long uploadWithMetadata$default$7() {
        return 0L;
    }

    public long uploadWithMetadata$default$8() {
        return 0L;
    }

    public int uploadWithMetadata$default$9() {
        return 100;
    }

    public boolean uploadWithMetadata$default$10() {
        return false;
    }

    public boolean uploadWithMetadata$default$11() {
        return false;
    }

    public boolean uploadWithMetadata$default$12() {
        return false;
    }

    public Set<TopicIdPartition> randomTopicIdPartitions(int numTopicUpperBound, int numPartitionUpperBound) {
        ObjectRef topicPartitions2 = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        int numTopics = TestUtils$.MODULE$.random().nextInt(numTopicUpperBound) + 1;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).foreach$mVc$sp((Function1)new Serializable(numPartitionUpperBound, topicPartitions2){
            public static final long serialVersionUID = 0L;
            private final int numPartitionUpperBound$1;
            public final ObjectRef topicPartitions$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                int numPartitions = TestUtils$.MODULE$.random().nextInt(this.numPartitionUpperBound$1) + 1;
                UUID topicId = UUID.randomUUID();
                String topicName = TestUtils$.MODULE$.tempTopic();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)new Serializable(this, topicId, topicName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.randomTopicIdPartitions.1 $outer;
                    private final UUID topicId$1;
                    private final String topicName$1;

                    public final void apply(int partition) {
                        this.apply$mcVI$sp(partition);
                    }

                    public void apply$mcVI$sp(int partition) {
                        this.$outer.topicPartitions$1.elem = (Set)((Set)this.$outer.topicPartitions$1.elem).$plus((Object)new TopicIdPartition(this.topicName$1, this.topicId$1, partition));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topicId$1 = topicId$1;
                        this.topicName$1 = topicName$1;
                    }
                });
            }
            {
                this.numPartitionUpperBound$1 = numPartitionUpperBound$1;
                this.topicPartitions$1 = topicPartitions$1;
            }
        });
        return (Set)topicPartitions2.elem;
    }

    private TierTestUtils$() {
        MODULE$ = this;
    }
}

