/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.TestUtils$;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u000f\tiB+[3s)>\u0004\u0018nY'b]\u0006<WM]\"p[6LG\u000f^3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!A/[3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u0015!\u0002\u0001\"\u0001\u0016\u0003I)\u0017M\u001d7jKN$xJ\u001a4tKR$Vm\u001d;\u0015\u0003Y\u0001\"!C\f\n\u0005aQ!\u0001B+oSRD#a\u0005\u000e\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012!\u00026v]&$(\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"9\t!A+Z:u\u0011\u0015\u0019\u0003\u0001\"\u0001\u0016\u0003MygMZ:fi&swJ\\3O_R|E\u000f[3sQ\t\u0011#\u0004C\u0003'\u0001\u0011\u0005Q#\u0001\u000bpM\u001a\u001cX\r^:F[B$\u00180\u00138P]\u0016$\u0015N\u001d\u0015\u0003KiAQ!\u000b\u0001\u0005\u0002U\tQb\u001e:ji\u0016\u0014V-\u00193UKN$\bF\u0001\u0015\u001b\u0011\u0015a\u0003\u0001\"\u0001\u0016\u0003=1\u0017-\u001b7fI\u001acWo\u001d5UKN$\bFA\u0016\u001b\u0011\u0015y\u0003\u0001\"\u0001\u0016\u0003\u0005*hn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8SKN,Go\u001d)pg&$\u0018n\u001c8tQ\tq#\u0004C\u00033\u0001\u0011\u0005Q#A\u000fj]Z\fG.\u001b3WKJ\u001c\u0018n\u001c8SKN,Go\u001d)pg&$\u0018n\u001c8tQ\t\t$\u0004C\u00036\u0001\u0011\u0005Q#A\u000ej]Z\fG.\u001b3PM\u001a\u001cX\r^:MS:,\u0007k\\:ji&|gn\u001d\u0015\u0003ii\u0001")
public class TierTopicManagerCommitterTest {
    @Test
    public void earliestOffsetTest() {
        HashMap<Integer, Long> positions1 = new HashMap<Integer, Long>();
        HashMap<Integer, Long> positions2 = new HashMap<Integer, Long>();
        positions1.put(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.long2Long(5L));
        positions2.put(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.long2Long(2L));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)2L), TierTopicManagerCommitter.earliestOffsets(Arrays.asList((Object[])new Map[]{positions1, positions2})).get(BoxesRunTime.boxToInteger((int)3)));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)2L), TierTopicManagerCommitter.earliestOffsets(Arrays.asList((Object[])new Map[]{positions2, positions1})).get(BoxesRunTime.boxToInteger((int)3)));
    }

    @Test
    public void offsetInOneNotOther() {
        HashMap<Integer, Long> positions1 = new HashMap<Integer, Long>();
        positions1.put(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.long2Long(5L));
        HashMap<Integer, Long> positions2 = new HashMap<Integer, Long>();
        positions2.put(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.long2Long(5L));
        Assert.assertTrue((String)"Overall offset positions not reset, even though positions were missing.", (boolean)TierTopicManagerCommitter.earliestOffsets(Arrays.asList((Object[])new Map[]{positions1, positions2})).isEmpty());
    }

    @Test
    public void offsetsEmptyInOneDir() {
        HashMap positions1 = new HashMap();
        HashMap<Integer, Long> positions2 = new HashMap<Integer, Long>();
        positions2.put(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.long2Long(5L));
        Assert.assertTrue((String)"Overall offset positions not reset, even though positions were missing.", (boolean)TierTopicManagerCommitter.earliestOffsets(Arrays.asList((Object[])new Map[]{positions1, positions2})).isEmpty());
    }

    @Test
    public void writeReadTest() {
        String logDir = new StringBuilder().append((Object)System.getProperty("java.io.tmpdir")).append((Object)"/").append((Object)UUID.randomUUID().toString()).toString();
        File file = new File(logDir);
        file.mkdir();
        short numPartitions = 6;
        TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig((Supplier)new Supplier<Map<String, Object>>(this){

            public Map<String, Object> get() {
                return Collections.singletonMap("bootstrap.servers", "bootstrap");
            }
        }, null, numPartitions, 1, 33, "cluster99", Predef$.MODULE$.long2Long(200L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), Collections.singletonList(logDir));
        TierTopicManagerCommitter committer = new TierTopicManagerCommitter(tierTopicManagerConfig, (LogDirFailureChannel)EasyMock.mock(LogDirFailureChannel.class));
        committer.updatePosition(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.long2Long(1L));
        committer.updatePosition(Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.long2Long(4L));
        committer.updatePosition(Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.long2Long(5L));
        committer.flush(new ArrayList().iterator());
        TierTopicManagerCommitter committer2 = new TierTopicManagerCommitter(tierTopicManagerConfig, (LogDirFailureChannel)EasyMock.mock(LogDirFailureChannel.class));
        Option[] expectedPositions = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$, None$.MODULE$, new Some((Object)BoxesRunTime.boxToLong((long)1L)), None$.MODULE$, new Some((Object)BoxesRunTime.boxToLong((long)5L))});
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)numPartitions).foreach$mVc$sp((Function1)new Serializable(this, committer2, expectedPositions){
            public static final long serialVersionUID = 0L;
            private final TierTopicManagerCommitter committer2$1;
            private final Option[] expectedPositions$1;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                Assert.assertEquals((Object)this.expectedPositions$1[partitionId].getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }), (Object)this.committer2$1.positionFor(partitionId));
            }
            {
                this.committer2$1 = committer2$1;
                this.expectedPositions$1 = expectedPositions$1;
            }
        });
    }

    @Test
    public void failedFlushTest() {
        String logDir = new StringBuilder().append((Object)System.getProperty("java.io.tmpdir")).append((Object)"/").append((Object)UUID.randomUUID().toString()).toString();
        File file = new File(logDir);
        file.mkdir();
        short numPartitions = 6;
        TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig((Supplier)new Supplier<Map<String, Object>>(this){

            public Map<String, Object> get() {
                return Collections.singletonMap("bootstrap.servers", "bootstrap");
            }
        }, null, numPartitions, 1, 33, "cluster99", Predef$.MODULE$.long2Long(200L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), Collections.singletonList(logDir));
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        TierPartitionState tps = (TierPartitionState)EasyMock.mock(TierPartitionState.class);
        tps.flush();
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)new IOException("failed to flush"));
        EasyMock.expect((Object)tps.dir()).andReturn((Object)new File(logDir)).anyTimes();
        EasyMock.replay((Object[])new Object[]{tps});
        TierTopicManagerCommitter committer = new TierTopicManagerCommitter(tierTopicManagerConfig, logDirFailureChannel);
        committer.updatePosition(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.long2Long(1L));
        committer.updatePosition(Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.long2Long(4L));
        committer.updatePosition(Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.long2Long(5L));
        committer.flush(Collections.singletonList(tps).iterator());
        TierTopicManagerCommitter committer2 = new TierTopicManagerCommitter(tierTopicManagerConfig, logDirFailureChannel);
        Option[] expectedPositions = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$, None$.MODULE$, None$.MODULE$, None$.MODULE$, None$.MODULE$});
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)numPartitions).foreach$mVc$sp((Function1)new Serializable(this, committer2, expectedPositions){
            public static final long serialVersionUID = 0L;
            private final TierTopicManagerCommitter committer2$2;
            private final Option[] expectedPositions$2;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                Assert.assertEquals((Object)this.expectedPositions$2[partitionId].getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }), (Object)this.committer2$2.positionFor(partitionId));
            }
            {
                this.committer2$2 = committer2$2;
                this.expectedPositions$2 = expectedPositions$2;
            }
        });
        Assert.assertEquals((Object)System.getProperty("java.io.tmpdir").replaceFirst("/$", ""), (Object)logDirFailureChannel.takeNextOfflineLogDir());
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Test
    public void unsupportedVersionResetsPositions() {
        File testDir = TestUtils$.MODULE$.tempDir();
        File file = new File(new StringBuilder().append((Object)testDir.getAbsolutePath()).append((Object)"/tier.offsets").toString());
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter write = new BufferedWriter(fileWriter);
        write.write(Integer.toString(Predef$.MODULE$.Integer2int(TierTopicManagerCommitter.CURRENT_VERSION) + 1));
        write.newLine();
        write.write("0 3");
        write.newLine();
        write.flush();
        write.close();
        fileWriter.close();
        Assert.assertTrue((boolean)TierTopicManagerCommitter.committed((String)testDir.getAbsolutePath(), (LogDirFailureChannel)((LogDirFailureChannel)EasyMock.mock(LogDirFailureChannel.class))).isEmpty());
        return;
        {
            catch (Throwable throwable) {
                try {
                    void var5_4;
                    var5_4.flush();
                    var5_4.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    void var3_3;
                    var3_3.close();
                    throw throwable2;
                }
            }
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Test
    public void invalidVersionResetsPositions() {
        File testDir = TestUtils$.MODULE$.tempDir();
        File file = new File(new StringBuilder().append((Object)testDir.getAbsolutePath()).append((Object)"/tier.offsets").toString());
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter write = new BufferedWriter(fileWriter);
        write.write("aaa");
        write.newLine();
        write.write("0 3");
        write.newLine();
        write.flush();
        write.close();
        fileWriter.close();
        Assert.assertTrue((boolean)TierTopicManagerCommitter.committed((String)testDir.getAbsolutePath(), (LogDirFailureChannel)((LogDirFailureChannel)EasyMock.mock(LogDirFailureChannel.class))).isEmpty());
        return;
        {
            catch (Throwable throwable) {
                try {
                    void var5_4;
                    var5_4.flush();
                    var5_4.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    void var3_3;
                    var3_3.close();
                    throw throwable2;
                }
            }
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Test
    public void invalidOffsetsLinePositions() {
        File testDir = TestUtils$.MODULE$.tempDir();
        File file = new File(new StringBuilder().append((Object)testDir.getAbsolutePath()).append((Object)"/tier.offsets").toString());
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter write = new BufferedWriter(fileWriter);
        write.write("0");
        write.newLine();
        write.write("3");
        write.newLine();
        write.write("0 5");
        write.flush();
        write.close();
        fileWriter.close();
        Assert.assertTrue((boolean)TierTopicManagerCommitter.committed((String)testDir.getAbsolutePath(), (LogDirFailureChannel)((LogDirFailureChannel)EasyMock.mock(LogDirFailureChannel.class))).isEmpty());
        return;
        {
            catch (Throwable throwable) {
                try {
                    void var5_4;
                    var5_4.flush();
                    var5_4.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    void var3_3;
                    var3_3.close();
                    throw throwable2;
                }
            }
        }
    }
}

