/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00053A!\u0001\u0002\u0001\u000f\t\u0011B+[3s)>\u0004\u0018nY*fe\u0012+G+Z:u\u0015\t\u0019A!\u0001\u0003uS\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t\u0003)\u0012\u0001G:fe&\fG.\u001b>f\t\u0016\u001cXM]5bY&TX\rV3tiR\ta\u0003\u0005\u0002\n/%\u0011\u0001D\u0003\u0002\u0005+:LG\u000f\u000b\u0002\u00145A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005b\"\u0001\u0002+fgRDQa\t\u0001\u0005\n\u0011\n\u0011B]8v]\u0012$&/\u001b9\u0015\u0005Y)\u0003\"\u0002\u0014#\u0001\u00049\u0013!\u0001<\u0011\u0005!ZS\"A\u0015\u000b\u0005)\u0012\u0011A\u00023p[\u0006Lg.\u0003\u0002-S\t!\u0012IY:ue\u0006\u001cG\u000fV5fe6+G/\u00193bi\u0006DQA\f\u0001\u0005\u0002U\t\u0001$\\3uC\u0012\fG/Y%mY\u0016<\u0017\r\\#q_\u000eDG+Z:uQ\u0011i#\u0004M\u0019\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013A\r\t\u0003gmr!\u0001N\u001d\u000f\u0005UBT\"\u0001\u001c\u000b\u0005]2\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tQ$\"A\u0004qC\u000e\\\u0017mZ3\n\u0005qj$\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0011!H\u0003\u0005\u0006\u007f\u0001!\t!F\u0001\u0015S:LG/\u00137mK\u001e\fG.\u00129pG\"$Vm\u001d;)\tyR\u0002'\r")
public class TierTopicSerDeTest {
    @Test
    public void serializeDeserializeTest() {
        this.roundTrip((AbstractTierMetadata)new TierTopicInitLeader(new TopicIdPartition("8BOZItC97ECWLZAXG1twhNjHgq5uiQhMhI5TW9oDdnLsNqPQ8DL85rCWF1lMIkb0RjH37L86WWFiFXb68zEEAgnRSiNRBlfsEMOAbgRJ1J4GyiwjHmHqCEjC9tMfDZCjAnfYC2DxgFygZLacUmr0wi6yK9L8ShR7krsMlxEdTRarNFDZfnihFFmhFc0eHb0aRf4nvg2Gt9zeqSb3FDIdjrNbKtCi2V9VtXZjd014SO28Noi5CwEmuXD0crus1unE", UUID.randomUUID(), 0), 0, UUID.randomUUID(), 33));
        this.roundTrip((AbstractTierMetadata)new TierTopicInitLeader(new TopicIdPartition("my", UUID.randomUUID(), 199999), 1, UUID.randomUUID(), 99));
        this.roundTrip((AbstractTierMetadata)new TierSegmentUploadInitiate(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID(), 0L, 33333L, 99999L, 3333, false, true, false));
        this.roundTrip((AbstractTierMetadata)new TierSegmentUploadComplete(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID()));
        this.roundTrip((AbstractTierMetadata)new TierSegmentDeleteInitiate(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID()));
        this.roundTrip((AbstractTierMetadata)new TierSegmentDeleteComplete(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID()));
        this.roundTrip((AbstractTierMetadata)new TierPartitionDeleteInitiate(new TopicIdPartition("foo", UUID.randomUUID(), 0), 0, UUID.randomUUID()));
    }

    private void roundTrip(AbstractTierMetadata v) {
        byte[] key = v.serializeKey();
        byte[] value = v.serializeValue();
        AbstractTierMetadata v2 = (AbstractTierMetadata)AbstractTierMetadata.deserialize((byte[])key, (byte[])value).get();
        Assert.assertEquals((Object)v, (Object)v2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void metadataIllegalEpochTest() {
        new TierObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), -1, UUID.randomUUID(), 0L, 23252334L, 0L, 102, TierObjectMetadata.State.SEGMENT_DELETE_INITIATE, true, false, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void initIllegalEpochTest() {
        new TierTopicInitLeader(new TopicIdPartition("my-topic", UUID.randomUUID(), 0), -1, UUID.randomUUID(), 33);
    }
}

