/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import kafka.tier.fetcher.CancellationContext;
import org.junit.Assert;
import org.junit.Test;

public class CancellationContextTest {
    @Test
    public void cancellationChain() {
        CancellationContext rootContext = CancellationContext.newContext();
        CancellationContext l1 = rootContext.subContext();
        CancellationContext l2 = l1.subContext();
        CancellationContext l3 = l2.subContext();
        l3.cancel();
        Assert.assertTrue((String)"Canceling a context works", (boolean)l3.isCancelled());
        Assert.assertFalse((String)"Canceling the lowest context does not cancel the higher contexts", (boolean)l2.isCancelled());
    }

    @Test
    public void testCancellationWithMultipleChildren() {
        CancellationContext rootContext = CancellationContext.newContext();
        CancellationContext l1 = rootContext.subContext();
        CancellationContext l2 = rootContext.subContext();
        CancellationContext l3 = rootContext.subContext();
        l2.cancel();
        Assert.assertFalse((boolean)rootContext.isCancelled());
        Assert.assertFalse((boolean)l1.isCancelled());
        Assert.assertTrue((boolean)l2.isCancelled());
        Assert.assertFalse((boolean)l3.isCancelled());
        rootContext.cancel();
        Assert.assertTrue((boolean)rootContext.isCancelled());
        Assert.assertTrue((boolean)l1.isCancelled());
        Assert.assertTrue((boolean)l2.isCancelled());
        Assert.assertTrue((boolean)l2.isCancelled());
    }
}

