/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;

class FetchRequestTestUtils {
    FetchRequestTestUtils() {
    }

    static TierObjectStore ioExceptionThrowingTierObjectStore() {
        return new TierObjectStore(){

            public TierObjectStoreResponse getObject(TierObjectStore.ObjectMetadata objectMetadata, TierObjectStore.FileType objectFileType, Integer byteOffsetStart, Integer byteOffsetEnd) throws IOException {
                throw new IOException("");
            }

            public TierObjectStoreResponse getObject(TierObjectStore.ObjectMetadata objectMetadata, TierObjectStore.FileType fileType, Integer byteOffsetStart) throws IOException {
                throw new IOException("");
            }

            public TierObjectStoreResponse getObject(TierObjectStore.ObjectMetadata objectMetadata, TierObjectStore.FileType fileType) throws IOException {
                throw new IOException("");
            }

            public void putSegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<File> epochState) throws IOException {
                throw new IOException("");
            }

            public void deleteSegment(TierObjectStore.ObjectMetadata objectMetadata) throws IOException {
                throw new IOException("");
            }

            public void close() {
            }
        };
    }

    static TierObjectStore fileReturningTierObjectStore(final File offsetIndexFile, final File timestampIndexFile) {
        return new TierObjectStore(){

            public TierObjectStoreResponse getObject(TierObjectStore.ObjectMetadata objectMetadata, TierObjectStore.FileType objectFileType, Integer byteOffsetStart, Integer byteOffsetEnd) throws IOException {
                FileInputStream inputStream = null;
                switch (objectFileType) {
                    case OFFSET_INDEX: {
                        inputStream = new FileInputStream(offsetIndexFile);
                        break;
                    }
                    case TIMESTAMP_INDEX: {
                        inputStream = new FileInputStream(timestampIndexFile);
                    }
                }
                final FileInputStream finalInputStream = inputStream;
                return new TierObjectStoreResponse(){

                    public InputStream getInputStream() {
                        return finalInputStream;
                    }

                    public void close() {
                        try {
                            finalInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
            }

            public void putSegment(TierObjectStore.ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<File> epochState) throws IOException {
                throw new IOException("");
            }

            public void deleteSegment(TierObjectStore.ObjectMetadata objectMetadata) {
            }

            public void close() {
            }
        };
    }
}

