/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.TierLogSegment;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.state.TierUtils;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.DumpTierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenSetLike;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0001\u0003\u0001%\u0011a\u0003V5feB\u000b'\u000f^5uS>t7\u000b^1uKR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQa\u001d;bi\u0016T!!\u0002\u0004\u0002\tQLWM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003)\u0001i\u0011A\u0001\u0005\b-\u0001\u0011\r\u0011\"\u0001\u0018\u0003\u001d1\u0017m\u0019;pef,\u0012\u0001\u0007\t\u0003)eI!A\u0007\u0002\u00033QKWM\u001d)beRLG/[8o'R\fG/\u001a$bGR|'/\u001f\u0005\u00079\u0001\u0001\u000b\u0011\u0002\r\u0002\u0011\u0019\f7\r^8ss\u0002BqA\b\u0001C\u0002\u0013\u0005q$A\u0005qCJ,g\u000e\u001e#jeV\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005\u0011\u0011n\u001c\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0003GS2,\u0007BB\u0015\u0001A\u0003%\u0001%\u0001\u0006qCJ,g\u000e\u001e#je\u0002Bqa\u000b\u0001C\u0002\u0013\u0005q$A\u0002eSJDa!\f\u0001!\u0002\u0013\u0001\u0013\u0001\u00023je\u0002Bqa\f\u0001C\u0002\u0013\u0005\u0001'\u0001\u0002uaV\t\u0011\u0007\u0005\u00023u5\t1G\u0003\u00025k\u000511m\\7n_:T!a\u0002\u001c\u000b\u0005]B\u0014AB1qC\u000eDWMC\u0001:\u0003\ry'oZ\u0005\u0003wM\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004>\u0001\u0001\u0006I!M\u0001\u0004iB\u0004\u0003bB \u0001\u0005\u0004%\t\u0001Q\u0001\u0005iBLG-F\u0001B!\t\u00115)D\u0001\u0005\u0013\t!EA\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"1a\t\u0001Q\u0001\n\u0005\u000bQ\u0001\u001e9jI\u0002Bqa\u0001\u0001C\u0002\u0013\u0005\u0001*F\u0001J!\t!\"*\u0003\u0002L\u0005\t1b)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\r\u0003\u0004N\u0001\u0001\u0006I!S\u0001\u0007gR\fG/\u001a\u0011\t\u000f=\u0003!\u0019!C\u0001!\u0006IAn\\4D_:4\u0017nZ\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011AKB\u0001\u0004Y><\u0017B\u0001,T\u0005%aunZ\"p]\u001aLw\r\u0003\u0004Y\u0001\u0001\u0006I!U\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003\"\u0002.\u0001\t\u0003Y\u0016!B:fiV\u0004H#\u0001/\u0011\u0005-i\u0016B\u00010\r\u0005\u0011)f.\u001b;)\u0005e\u0003\u0007CA1e\u001b\u0005\u0011'BA29\u0003\u0015QWO\\5u\u0013\t)'M\u0001\u0004CK\u001a|'/\u001a\u0005\u0006O\u0002!\taW\u0001\ti\u0016\f'\u000fZ8x]\"\u0012a-\u001b\t\u0003C*L!a\u001b2\u0003\u000b\u00053G/\u001a:\t\u000b5\u0004A\u0011A.\u0002'I,\u0017\rZ,sSR,\u0007*Z1eKJ|e\u000e\\=)\u00051|\u0007CA1q\u0013\t\t(M\u0001\u0003UKN$\b\"B:\u0001\t\u0003Y\u0016\u0001G:fe&\fG.\u001b>f\t\u0016\u001cXM]5bY&TX\rV3ti\"\u0012!o\u001c\u0005\u0006m\u0002!\taW\u0001\u000fg\u0016<W.\u001a8u\u000f\u0006\u0004H+Z:uQ\t)x\u000eC\u0003z\u0001\u0011\u00051,\u0001\ntK\u001elWM\u001c;Pm\u0016\u0014H.\u00199UKN$\bF\u0001=p\u0011\u0015a\b\u0001\"\u0001\\\u0003=)\b\u000fZ1uK\u0016\u0003xn\u00195UKN$\bFA>p\u0011\u0015y\b\u0001\"\u0001\\\u0003M)\b\u000fZ1uK\u0016sGm\u00144gg\u0016$H+Z:uQ\tqx\u000e\u0003\u0004\u0002\u0006\u0001!\taW\u0001\u0016M2,8\u000f[!wC&d\u0017MY5mSRLH+Z:uQ\r\t\u0019a\u001c\u0005\u0007\u0003\u0017\u0001A\u0011A.\u0002AQ,7\u000f\u001e*f_B,gNR5mK\u00063G/\u001a:WKJ\u001c\u0018n\u001c8DQ\u0006tw-\u001a\u0015\u0004\u0003\u0013y\u0007BBA\t\u0001\u0011\u00051,\u0001\u0013uKN$xJ\\4pS:<W\u000b\u001d7pC\u0012tu\u000e\u001e,jg&\u0014G.\u001a+p%\u0016\fG-\u001a:tQ\r\tya\u001c\u0005\u0007\u0003/\u0001A\u0011A.\u0002IQ,7\u000f^'fi\u0006$\u0017\r^1SK\u0006$'+\u001a;ve:\u001ch+\u00197jIN+w-\\3oiND3!!\u0006p\u0011\u0019\ti\u0002\u0001C\u00017\u0006iC/Z:u\u001bVdG/\u001b9mK&s\u0017\u000e^5bi\u0016\u001c8kY1o]\u0016$7i\u001c:sK\u000e$H._(o%\u0016dw.\u00193)\u0007\u0005mq\u000e\u0003\u0004\u0002$\u0001!\taW\u0001\u001di\u0016\u001cH/\u00169m_\u0006$\u0017\t\u001e'po\u0016\u0014X\t]8dQ\u001a+gnY3eQ\r\t\tc\u001c\u0005\u0007\u0003S\u0001A\u0011A.\u0002/Q,7\u000f^(oO>LgnZ+qY>\fGMR3oG\u0016$\u0007fAA\u0014_\"1\u0011q\u0006\u0001\u0005\u0002m\u000b\u0001\u0006^3ti>swm\\5oOV\u0003Hn\\1e\r\u0016t7-\u001a3BMR,'\u000fT3bI\u0016\u00148\t[1oO\u0016D3!!\fp\u0011\u0019\t)\u0004\u0001C\u00017\u0006\tC/Z:u\r\u0016t7-\u001a3TK\u001elWM\u001c;IC:$G.\u001b8h\u001f:\u0014Vm\u001c9f]\"\u001a\u00111G8\t\r\u0005m\u0002\u0001\"\u0001\\\u0003\r\"Xm\u001d;GK:\u001cW\rZ*fO6,g\u000e\u001e%b]\u0012d\u0017N\\4P]\u0012+G.\u001a;j_:D3!!\u000fp\u0011\u0019\t\t\u0005\u0001C\u00017\u0006\u0011B/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;tQ\r\tyd\u001c\u0005\u0007\u0003\u000f\u0002A\u0011A.\u0002;Q,7\u000f\u001e#fY\u0016$XmU3h[\u0016tGo],ji\"|e/\u001a:mCBD3!!\u0012p\u0011\u0019\ti\u0005\u0001C\u00017\u00069C/Z:u\u000b:$wJ\u001a4tKRL5\u000f\u0016:bG.,GMR8s\t\u0016dW\r^3TK\u001elWM\u001c;tQ\r\tYe\u001c\u0005\u0007\u0003'\u0002A\u0011A.\u0002oQ,7\u000f^#oI>3gm]3u\u0013N$&/Y2lK\u00124uN]*fO6,g\u000e^:GK:\u001cW\rZ(o\t\u0016dW\r^3J]&$\u0018.\u0019;fQ\r\t\tf\u001c\u0005\u0007\u00033\u0002A\u0011A.\u0002-Q,7\u000f^'bi\u0016\u0014\u0018.\u00197ju\u0016$wJ\u001a4tKRD3!a\u0016p\u0011\u0019\ty\u0006\u0001C\u00017\u00061B/Z:u\u00132dWmZ1m)J\fgn]5uS>t7\u000fK\u0002\u0002^=Da!!\u001a\u0001\t\u0003Y\u0016A\t;fgRLE-Z7q_R,gnY=EK2,G/Z!gi\u0016\u00148i\\7qY\u0016$X\rK\u0002\u0002d=Da!a\u001b\u0001\t\u0003Y\u0016\u0001\b;fgRLE-Z7q_R,gnY=EK2\f\u00170\u001a3EK2,G/\u001a\u0015\u0004\u0003Sz\u0007BBA9\u0001\u0011\u00051,A\u0011uKN$\u0018\nZ3na>$XM\\2z'&lW\u000f\u001c;b]\u0016|Wo\u001d#fY\u0016$X\rK\u0002\u0002p=Da!a\u001e\u0001\t\u0003Y\u0016!\u0007;fgRLE-Z7q_R,g\u000e^3oGf4UM\\2j]\u001eD3!!\u001ep\u0011\u0019\ti\b\u0001C\u00017\u0006)C/Z:u\u001b\u0006$XM]5bY&T\u0018\r^5p]2K7\u000f^3oKJ\u001cu.\u001c9mKRLwN\u001c\u0015\u0004\u0003wz\u0007BBAB\u0001\u0011\u00051,\u0001\u0017uKN$\bK]3wS>,8/T1uKJL\u0017\r\\5{CRLwN\u001c'jgR,g.\u001a:DC:\u001cW\r\u001c7fI\"\u001a\u0011\u0011Q8\t\r\u0005%\u0005\u0001\"\u0001\\\u0003\u0015\"Xm\u001d;NCR,'/[1mSj\fG/[8o\u0019&\u001cH/\u001a8fe\u00063G/\u001a:DY>\u001cX\rK\u0002\u0002\b>Dq!a$\u0001\t\u0013\t\t*A\nuKN$H)\u001e9mS\u000e\fG/Z!qa\u0016tG\rF\u0004]\u0003'\u000b\u0019+a0\t\u0011\u0005U\u0015Q\u0012a\u0001\u0003/\u000b\u0001\"\\3uC\u0012\fG/\u0019\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0019\u0011Q\u0014\u0003\u0002\r\u0011|W.Y5o\u0013\u0011\t\t+a'\u0003)\u0005\u00137\u000f\u001e:bGR$\u0016.\u001a:NKR\fG-\u0019;b\u0011!\t)+!$A\u0002\u0005\u001d\u0016a\u00059sKZLw.^:Ue\u0006t7/\u001b;j_:\u001c\bCBAU\u0003s\u000b9J\u0004\u0003\u0002,\u0006Uf\u0002BAW\u0003gk!!a,\u000b\u0007\u0005E\u0006\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u0019\u0011q\u0017\u0007\u0002\u000fA\f7m[1hK&!\u00111XA_\u0005\r\u0019V-\u001d\u0006\u0004\u0003oc\u0001\u0002CAa\u0003\u001b\u0003\r!a1\u0002\u0011\u0015D\b/Z2uK\u0012\u0004B!!2\u0002X:!\u0011qYAj\u001d\u0011\tI-!5\u000f\t\u0005-\u0017q\u001a\b\u0005\u0003[\u000bi-C\u0001\b\u0013\t)a!\u0003\u0002\u0004\t%\u0019\u0011Q\u001b\u0002\u0002%QKWM\u001d)beRLG/[8o'R\fG/Z\u0005\u0005\u00033\fYN\u0001\u0007BaB,g\u000e\u001a*fgVdGOC\u0002\u0002V\nAq!a8\u0001\t\u0013\t\t/\u0001\u000fwC2LG-\u0019;f\u0007>t7o\u001c7f\tVl\u0007/\u001a3F]R\u0014\u0018.Z:\u0015\u000bq\u000b\u0019/a:\t\u000f\u0005\u0015\u0018Q\u001ca\u0001A\u0005a\u0001/\u0019:uSRLwN\u001c#je\"A\u0011\u0011^Ao\u0001\u0004\tY/A\u0006ok6\u001cVmZ7f]R\u001c\bcA\u0006\u0002n&\u0019\u0011q\u001e\u0007\u0003\u0007%sG\u000fC\u0004\u0002t\u0002!I!!>\u0002+\rDWmY6J]Z\fG.\u001b3GS2,'+Z:fiR9A,a>\u0002|\u0006u\bbBA}\u0003c\u0004\r\u0001I\u0001\bE\u0006\u001cX\rR5s\u0011\u0019y\u0013\u0011\u001fa\u0001c!A\u0011q`Ay\u0001\u0004\u0011\t!\u0001\u0003qCRD\u0007\u0003\u0002B\u0002\u0005\u0013q1a\u0003B\u0003\u0013\r\u00119\u0001D\u0001\u0007!J,G-\u001a4\n\t\t-!Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t\u001dA\u0002")
public class TierPartitionStateTest {
    private final TierPartitionStateFactory factory = new TierPartitionStateFactory(true);
    private final File parentDir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
    private final TopicPartition tp = Log$.MODULE$.parseTopicPartitionName(this.dir());
    private final TopicIdPartition tpid = new TopicIdPartition(this.tp().topic(), UUID.randomUUID(), this.tp().partition());
    private final FileTierPartitionState state = new FileTierPartitionState(this.dir(), this.tp(), true);
    private final LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);

    public TierPartitionStateFactory factory() {
        return this.factory;
    }

    public File parentDir() {
        return this.parentDir;
    }

    public File dir() {
        return this.dir;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public FileTierPartitionState state() {
        return this.state;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @Before
    public void setup() {
        this.state().setTopicId(this.tpid().topicId());
        this.state().beginCatchup();
        this.state().onCatchUpComplete();
        Mockito.when((Object)this.logConfig().tierEnable()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(true));
    }

    @After
    public void teardown() {
        this.state().close();
        this.dir().delete();
        this.parentDir().delete();
    }

    @Test
    public void readWriteHeaderOnly() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 9, UUID.randomUUID(), 0), 0L);
        Assert.assertEquals((long)9L, (long)this.state().tierEpoch());
        this.state().close();
        TierPartitionState reopenedState = this.factory().initState(this.dir(), this.tp(), this.logConfig());
        Assert.assertEquals((long)9L, (long)reopenedState.tierEpoch());
        reopenedState.close();
    }

    @Test
    public void serializeDeserializeTest() {
        int numSegments = 200;
        LongRef currentSegments = LongRef.create((long)0L);
        int epoch = 0;
        String path = this.state().flushedPath();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        IntRef size2 = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, currentSegments, epoch, size2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final LongRef currentSegments$1;
            private final int epoch$1;
            private final IntRef size$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$1, objectId, (long)(i * 2), (long)(i * 2 + 1), 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$1, objectId), 0L));
                this.size$1.elem += i;
                ++this.currentSegments$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentSegments$1 = currentSegments$1;
                this.epoch$1 = epoch$1;
                this.size$1 = size$1;
            }
        });
        this.state().flush();
        ObjectRef segmentOffsets = ObjectRef.create(this.state().segmentOffsets().iterator());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, segmentOffsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final ObjectRef segmentOffsets$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long startOffset = (long)i * 2L;
                Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)startOffset), ((java.util.Iterator)this.segmentOffsets$1.elem).next());
                Assert.assertEquals((long)startOffset, (long)((TierObjectMetadata)this.$outer.state().metadata(startOffset).get()).baseOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.segmentOffsets$1 = segmentOffsets$1;
            }
        });
        Assert.assertFalse((boolean)((java.util.Iterator)segmentOffsets.elem).hasNext());
        Assert.assertEquals((long)currentSegments.elem, (long)this.state().numSegments());
        Assert.assertEquals((long)size2.elem, (long)this.state().totalSize());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), this.state().startOffset().get());
        Assert.assertEquals((long)(currentSegments.elem * 2L - 1L), (long)this.state().committedEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(numSegments), numSegments * 2).foreach$mVc$sp((Function1)new Serializable(this, currentSegments, epoch, size2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final LongRef currentSegments$1;
            private final int epoch$1;
            private final IntRef size$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$1, objectId, (long)(i * 2), (long)(i * 2 + 1), 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$1, objectId), 0L));
                this.size$1.elem += i;
                ++this.currentSegments$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentSegments$1 = currentSegments$1;
                this.epoch$1 = epoch$1;
                this.size$1 = size$1;
            }
        });
        this.state().flush();
        segmentOffsets.elem = this.state().segmentOffsets().iterator();
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)currentSegments.elem)).foreach((Function1)new Serializable(this, segmentOffsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final ObjectRef segmentOffsets$1;

            public final void apply(long i) {
                this.apply$mcVJ$sp(i);
            }

            public void apply$mcVJ$sp(long i) {
                long startOffset = i * 2L;
                Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)startOffset), ((java.util.Iterator)this.segmentOffsets$1.elem).next());
                Assert.assertEquals((long)startOffset, (long)((TierObjectMetadata)this.$outer.state().metadata(startOffset).get()).baseOffset());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.segmentOffsets$1 = segmentOffsets$1;
            }
        });
        Assert.assertFalse((boolean)((java.util.Iterator)segmentOffsets.elem).hasNext());
        Assert.assertEquals((long)currentSegments.elem, (long)this.state().numSegments());
        Assert.assertEquals((long)size2.elem, (long)this.state().totalSize());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), this.state().startOffset().get());
        Assert.assertEquals((long)(currentSegments.elem * 2L - 1L), (long)this.state().committedEndOffset());
        this.state().close();
        this.checkInvalidFileReset(this.dir(), this.tp(), path);
    }

    @Test
    public void segmentGapTest() {
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        UUID objectId1 = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId1, 0L, 50L, 100L, 0, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId1), 0L));
        UUID objectId2 = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId2, 75L, 150L, 100L, 0, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId2), 0L));
        this.state().flush();
        Assert.assertEquals((Object)objectId1, (Object)((TierObjectMetadata)this.state().metadata(50L).get()).objectId());
        Assert.assertEquals((Object)objectId2, (Object)((TierObjectMetadata)this.state().metadata(51L).get()).objectId());
        Assert.assertFalse((boolean)this.state().metadata(151L).isPresent());
        this.state().close();
    }

    @Test
    public void segmentOverlapTest() {
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        UUID objectId1 = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId1, 0L, 50L, 100L, 0, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId1), 0L));
        UUID objectId2 = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId2, 25L, 150L, 100L, 0, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId2), 0L));
        this.state().flush();
        Assert.assertEquals((Object)objectId1, (Object)((TierObjectMetadata)this.state().metadata(24L).get()).objectId());
        Assert.assertEquals((Object)objectId1, (Object)((TierObjectMetadata)this.state().metadata(25L).get()).objectId());
        Assert.assertEquals((Object)objectId1, (Object)((TierObjectMetadata)this.state().metadata(50L).get()).objectId());
        Assert.assertEquals((Object)objectId2, (Object)((TierObjectMetadata)this.state().metadata(51L).get()).objectId());
        Assert.assertFalse((boolean)this.state().metadata(151L).isPresent());
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId1), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId1), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId2), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId2), 0L));
        this.state().flush();
        Assert.assertEquals((long)150L, (long)this.state().endOffset());
        Assert.assertEquals((long)150L, (long)this.state().committedEndOffset());
        UUID objectId3 = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId3, 75L, 175L, 100L, 0, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId3), 0L));
        this.state().flush();
        Assert.assertFalse((boolean)this.state().metadata(150L).isPresent());
        Assert.assertEquals((Object)objectId3, (Object)((TierObjectMetadata)this.state().metadata(151L).get()).objectId());
        Assert.assertEquals((Object)objectId3, (Object)((TierObjectMetadata)this.state().metadata(175L).get()).objectId());
        Assert.assertFalse((boolean)this.state().metadata(176L).isPresent());
        this.state().close();
        TierPartitionState reopenedState = this.factory().initState(this.dir(), this.tp(), this.logConfig());
        Assert.assertEquals((long)175L, (long)reopenedState.endOffset());
        Assert.assertEquals((long)175L, (long)reopenedState.committedEndOffset());
        Assert.assertFalse((boolean)reopenedState.metadata(74L).isPresent());
        Assert.assertEquals((Object)objectId3, (Object)((TierObjectMetadata)reopenedState.metadata(75L).get()).objectId());
        Assert.assertEquals((Object)objectId3, (Object)((TierObjectMetadata)reopenedState.metadata(175L).get()).objectId());
        Assert.assertFalse((boolean)reopenedState.metadata(176L).isPresent());
        reopenedState.close();
    }

    @Test
    public void updateEpochTest() {
        int n = 200;
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        IntRef size2 = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)new Serializable(this, epoch, size2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$2;
            private final IntRef size$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$2, objectId, (long)(i * 2), (long)(i * 2 + 1), 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$2, objectId), 0L));
                this.size$2.elem += i;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$2 = epoch$2;
                this.size$2 = size$2;
            }
        });
        this.state().flush();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch + 1, UUID.randomUUID(), 0), 0L);
        this.state().close();
        TierPartitionState reopenedState = this.factory().initState(this.dir(), this.tp(), this.logConfig());
        Assert.assertEquals((long)1L, (long)reopenedState.tierEpoch());
        Assert.assertEquals((long)size2.elem, (long)reopenedState.totalSize());
        reopenedState.close();
    }

    @Test
    public void updateEndOffsetTest() {
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), 0L));
        UUID objectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 100L, 100L, 100, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId), 0L));
        Assert.assertEquals((long)100L, (long)this.state().endOffset());
        Assert.assertEquals((long)-1L, (long)this.state().committedEndOffset());
        Assert.assertEquals((long)1L, (long)this.state().segmentOffsets().size());
        this.state().flush();
        Assert.assertEquals((long)100L, (long)this.state().endOffset());
        Assert.assertEquals((long)100L, (long)this.state().committedEndOffset());
        TierPartitionState reopenedState = this.factory().initState(this.dir(), this.tp(), this.logConfig());
        Assert.assertEquals((long)100L, (long)reopenedState.endOffset());
        Assert.assertEquals((long)100L, (long)reopenedState.committedEndOffset());
        reopenedState.close();
    }

    @Test
    public void flushAvailabilityTest() {
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), 0L));
        UUID objectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 100L, 100L, 100, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId), 0L));
        Assert.assertEquals((long)100L, (long)this.state().endOffset());
        Assert.assertEquals((long)-1L, (long)this.state().committedEndOffset());
        Assert.assertEquals((long)1L, (long)this.state().segmentOffsets().size());
        this.state().flush();
        Assert.assertEquals((long)100L, (long)this.state().endOffset());
        Assert.assertEquals((long)100L, (long)this.state().committedEndOffset());
        objectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 100L, 200L, 100L, 100, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId), 0L));
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), this.state().startOffset().get());
        Assert.assertEquals((long)100L, (long)this.state().committedEndOffset());
        Assert.assertEquals((long)200L, (long)this.state().endOffset());
        this.state().flush();
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), this.state().startOffset().get());
        Assert.assertEquals((long)200L, (long)this.state().committedEndOffset());
        int numSegments = this.state().segmentOffsets().size();
        this.state().close();
        this.validateConsoleDumpedEntries(this.dir(), numSegments);
    }

    @Test
    public void testReopenFileAfterVersionChange() {
        int numSegments = 200;
        int epoch = 0;
        byte initialVersion = this.state().version();
        long expectedEndOffset = 2 * numSegments - 1;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        IntRef size2 = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, epoch, size2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$3;
            private final IntRef size$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$3, objectId, (long)(i * 2), (long)(i * 2 + 1), 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$3, objectId), 0L));
                this.size$3.elem += i;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$3 = epoch$3;
                this.size$3 = size$3;
            }
        });
        this.state().flush();
        Assert.assertEquals((long)numSegments, (long)this.state().numSegments());
        Assert.assertEquals((long)expectedEndOffset, (long)this.state().endOffset());
        Assert.assertEquals((long)expectedEndOffset, (long)this.state().committedEndOffset());
        this.state().close();
        byte upgradedVersion = (byte)(initialVersion + 1);
        FileTierPartitionState upgradedState = new FileTierPartitionState(this.dir(), this.tp(), true, upgradedVersion);
        Assert.assertEquals((long)upgradedVersion, (long)upgradedState.version());
        Assert.assertEquals((long)numSegments, (long)upgradedState.numSegments());
        Assert.assertEquals((long)expectedEndOffset, (long)upgradedState.endOffset());
        Assert.assertEquals((long)expectedEndOffset, (long)upgradedState.committedEndOffset());
        upgradedState.close();
    }

    @Test
    public void testOngoingUploadNotVisibleToReaders() {
        int numSegments = 20;
        int epoch = 0;
        LongRef offset = LongRef.create((long)0L);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, epoch, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$4;
            private final LongRef offset$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$4, objectId, this.offset$1.elem, this.offset$1.elem + 1L, 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$4, objectId), 0L));
                ++this.offset$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$4 = epoch$4;
                this.offset$1 = offset$1;
            }
        });
        Assert.assertEquals((long)offset.elem, (long)this.state().endOffset());
        Assert.assertEquals((long)numSegments, (long)this.state().segmentOffsets().size());
        UUID inProgressObjectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, inProgressObjectId, offset.elem, offset.elem + 1L, 100L, 100, false, false, false), 0L));
        Assert.assertEquals((long)offset.elem, (long)this.state().endOffset());
        Assert.assertEquals((long)numSegments, (long)this.state().segmentOffsets().size());
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, inProgressObjectId), 0L));
        Assert.assertEquals((long)(offset.elem + 1L), (long)this.state().endOffset());
        Assert.assertEquals((long)(numSegments + 1), (long)this.state().segmentOffsets().size());
    }

    @Test
    public void testMetadataReadReturnsValidSegments() {
        int epoch = 0;
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L));
        UUID objectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 100L, 100L, 100, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId), 0L));
        UUID fencedObjectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, fencedObjectId, 101L, 200L, 100L, 100, false, false, false), 0L));
        UUID expectedObjectId = UUID.randomUUID();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), ++epoch, UUID.randomUUID(), 0), 0L);
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, expectedObjectId, 150L, 200L, 100L, 100, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, expectedObjectId), 0L));
        Assert.assertEquals((long)2L, (long)this.state().numSegments());
        Assert.assertEquals((long)1L, (long)this.state().fencedSegments().size());
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, fencedObjectId), 0L));
        Assert.assertEquals((long)2L, (long)this.state().numSegments());
        Assert.assertEquals((long)0L, (long)this.state().fencedSegments().size());
        Assert.assertTrue((boolean)this.state().metadata(149L).isPresent());
        Assert.assertEquals((Object)expectedObjectId, (Object)((TierObjectMetadata)this.state().metadata(149L).get()).objectId());
    }

    @Test
    public void testMultipleInitiatesScannedCorrectlyOnReload() {
        int epoch = 0;
        int offset = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, UUID.randomUUID(), (long)offset, (long)(offset + 1), 100L, 100, false, false, false), 0L));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), ++epoch, UUID.randomUUID(), 0), 0L);
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, UUID.randomUUID(), (long)(++offset), (long)(offset + 1), 100L, 100, false, false, false), 0L));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), ++epoch, UUID.randomUUID(), 0), 0L);
        Collection initialFenced = this.state().fencedSegments();
        Assert.assertEquals((long)2L, (long)initialFenced.size());
        this.state().close();
        FileTierPartitionState state2 = new FileTierPartitionState(this.dir(), this.tp(), true);
        Assert.assertFalse((boolean)state2.setTopicId(this.tpid().topicId()));
        Collection afterReloadFenced = state2.fencedSegments();
        Assert.assertEquals((Object)initialFenced, (Object)afterReloadFenced);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUploadAtLowerEpochFenced() {
        int numSegments = 20;
        IntRef epoch = IntRef.create((int)0);
        IntRef offset = IntRef.create((int)0);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, UUID.randomUUID(), 0), 0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, epoch, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final IntRef epoch$5;
            private final IntRef offset$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$5.elem, objectId, (long)this.offset$2.elem, (long)(this.offset$2.elem + 1), 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$5.elem, objectId), 0L));
                ++this.offset$2.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$5 = epoch$5;
                this.offset$2 = offset$2;
            }
        });
        epoch.elem = 1;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, UUID.randomUUID(), 0), 0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, epoch, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final IntRef epoch$5;
            private final IntRef offset$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$5.elem, objectId, (long)this.offset$2.elem, (long)(this.offset$2.elem + 1), 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$5.elem, objectId), 0L));
                ++this.offset$2.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$5 = epoch$5;
                this.offset$2 = offset$2;
            }
        });
        UUID fencedObjectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch.elem - 1, fencedObjectId, (long)offset.elem, (long)(offset.elem + 1), 100L, 100, false, false, false), 0L));
        Assert.assertEquals((long)0L, (long)this.state().fencedSegments().size());
        Assert.assertEquals((long)(numSegments * 2), (long)this.state().segmentOffsets().size());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.tp(), true);
        try {
            Assert.assertEquals((long)0L, (long)reopenedState.fencedSegments().size());
            Assert.assertEquals((long)(numSegments * 2), (long)reopenedState.segmentOffsets().size());
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        reopenedState.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOngoingUploadFenced() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, epoch, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$6;
            private final IntRef offset$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$6, objectId, (long)this.offset$3.elem, (long)(this.offset$3.elem + 1), 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$6, objectId), 0L));
                ++this.offset$3.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$6 = epoch$6;
                this.offset$3 = offset$3;
            }
        });
        ListBuffer abortedObjectIds = new ListBuffer();
        int numAbortedSegments = 5;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numAbortedSegments).foreach$mVc$sp((Function1)new Serializable(this, epoch, offset, abortedObjectIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$6;
            private final IntRef offset$3;
            private final ListBuffer abortedObjectIds$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.abortedObjectIds$1.$plus$eq((Object)UUID.randomUUID());
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$6, (UUID)this.abortedObjectIds$1.last(), (long)this.offset$3.elem, (long)(this.offset$3.elem + 1), 100L, 100, false, false, false), 0L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$6 = epoch$6;
                this.offset$3 = offset$3;
                this.abortedObjectIds$1 = abortedObjectIds$1;
            }
        });
        UUID ongoingUpload = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, ongoingUpload, (long)offset.elem, (long)(offset.elem + 1), 100L, 100, false, false, false), 0L));
        Assert.assertEquals((long)numAbortedSegments, (long)this.state().fencedSegments().size());
        Assert.assertEquals((Object)abortedObjectIds.toSet(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(TierObjectMetadata x$1) {
                return x$1.objectId();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((long)numSegments, (long)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.tp(), true);
        try {
            Assert.assertEquals((long)numAbortedSegments, (long)reopenedState.fencedSegments().size());
            Assert.assertEquals((Object)abortedObjectIds.toSet(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(reopenedState.fencedSegments()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final UUID apply(TierObjectMetadata x$2) {
                    return x$2.objectId();
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSet());
            Assert.assertEquals((long)numSegments, (long)reopenedState.numSegments());
            Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState.append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, ongoingUpload), 0L));
            Assert.assertEquals((Object)ongoingUpload, (Object)((TierObjectMetadata)reopenedState.metadata(Predef$.MODULE$.Long2long((Long)reopenedState.segmentOffsets().last())).get()).objectId());
        }
        catch (Throwable throwable) {
            void var7_7;
            var7_7.close();
            throw throwable;
        }
        reopenedState.close();
    }

    @Test
    public void testOngoingUploadFencedAfterLeaderChange() {
        int numSegments = 20;
        IntRef epoch = IntRef.create((int)0);
        IntRef offset = IntRef.create((int)0);
        IndexedSeq objectIds = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(int _) {
                return UUID.randomUUID();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, UUID.randomUUID(), 0), 0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, epoch, offset, objectIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final IntRef epoch$7;
            private final IntRef offset$4;
            private final IndexedSeq objectIds$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = (UUID)this.objectIds$1.apply(i);
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$7.elem, objectId, (long)this.offset$4.elem, (long)(this.offset$4.elem + 1), 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$7.elem, objectId), 0L));
                ++this.offset$4.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$7 = epoch$7;
                this.offset$4 = offset$4;
                this.objectIds$1 = objectIds$1;
            }
        });
        UUID abortedObjectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch.elem, abortedObjectId, (long)offset.elem, (long)(offset.elem + 1), 100L, 100, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch.elem, (UUID)objectIds.apply(0)), 0L));
        epoch.elem = 1;
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, UUID.randomUUID(), 0), 0L));
        Assert.assertEquals((long)2L, (long)this.state().fencedSegments().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{abortedObjectId, (UUID)objectIds.apply(0)})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(TierObjectMetadata x$3) {
                return x$3.objectId();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet());
        Assert.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch.elem - 1, abortedObjectId), 0L));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencedSegmentHandlingOnReopen() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), 0L);
        UUID abortedObjectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, abortedObjectId, 0L, 1L, 100L, 100, false, false, false), 0L));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 1, UUID.randomUUID(), 0), 0L);
        Optional fenced = this.state().fencedSegments().stream().findFirst();
        Assert.assertEquals((Object)((TierObjectMetadata)fenced.get()).objectId(), (Object)abortedObjectId);
        Assert.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, abortedObjectId), 0L));
        UUID completedObjectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 1, completedObjectId, 0L, 1L, 100L, 100, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 1, abortedObjectId), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 1, completedObjectId), 0L));
        Collection fencedBefore = this.state().fencedSegments();
        Assert.assertEquals((long)0L, (long)fencedBefore.size());
        Assert.assertEquals((Object)completedObjectId, (Object)((TierObjectMetadata)this.state().metadata(0L).get()).objectId());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.tp(), true);
        try {
            Assert.assertArrayEquals((Object[])fencedBefore.toArray(), (Object[])reopenedState.fencedSegments().toArray());
            Assert.assertTrue((boolean)reopenedState.metadata(0L).isPresent());
            Assert.assertEquals((Object)completedObjectId, (Object)((TierObjectMetadata)reopenedState.metadata(0L).get()).objectId());
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        reopenedState.close();
    }

    @Test
    public void testFencedSegmentHandlingOnDeletion() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), 0L);
        UUID abortedObjectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, abortedObjectId, 0L, 1L, 100L, 100, false, false, false), 0L));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 1, UUID.randomUUID(), 0), 0L);
        UUID completedObjectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 1, completedObjectId, 0L, 1L, 100L, 100, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 1, completedObjectId), 0L));
        Assert.assertEquals((Object)completedObjectId, (Object)((TierObjectMetadata)this.state().metadata(0L).get()).objectId());
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 1, abortedObjectId), 0L));
        Assert.assertEquals((Object)completedObjectId, (Object)((TierObjectMetadata)this.state().metadata(0L).get()).objectId());
    }

    @Test
    public void testDeleteSegments() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer objectIds = new ListBuffer();
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach((Function1)new Serializable(this, epoch, offset, objectIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$8;
            private final IntRef offset$5;
            private final ListBuffer objectIds$2;

            public final ListBuffer<UUID> apply(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$8, objectId, (long)this.offset$5.elem, (long)this.offset$5.elem, 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$8, objectId), 0L));
                ++this.offset$5.elem;
                return this.objectIds$2.$plus$eq((Object)objectId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$8 = epoch$8;
                this.offset$5 = offset$5;
                this.objectIds$2 = objectIds$2;
            }
        });
        int numSegmentsToDelete = 5;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegmentsToDelete).foreach$mVc$sp((Function1)new Serializable(this, epoch, objectIds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$8;
            private final ListBuffer objectIds$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.$outer.tpid(), this.epoch$8, (UUID)this.objectIds$2.apply(i)), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.$outer.tpid(), this.epoch$8, (UUID)this.objectIds$2.apply(i)), 0L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$8 = epoch$8;
                this.objectIds$2 = objectIds$2;
            }
        });
        ListBuffer validObjectIds = (ListBuffer)objectIds.takeRight(numSegments - numSegmentsToDelete);
        List foundObjectIds = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(TierUtils.tieredSegments((NavigableSet)this.state().segmentOffsets(), (TierPartitionState)this.state(), Optional.of(tierObjectStore))).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(TierLogSegment x$4) {
                return x$4.metadata().objectId();
            }
        }).toList();
        Assert.assertEquals((long)validObjectIds.size(), (long)this.state().numSegments());
        Assert.assertEquals((Object)validObjectIds, (Object)foundObjectIds);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteSegmentsWithOverlap() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer objectIds = new ListBuffer();
        ListBuffer endOffsets = new ListBuffer();
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        IntRef size2 = IntRef.create((int)0);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, epoch, offset, objectIds, endOffsets, size2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$9;
            private final IntRef offset$6;
            private final ListBuffer objectIds$3;
            private final ListBuffer endOffsets$1;
            private final IntRef size$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$9, objectId, (long)this.offset$6.elem, (long)(this.offset$6.elem + 10), 100L, i, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$9, objectId), 0L));
                this.objectIds$3.$plus$eq((Object)objectId);
                this.endOffsets$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)(this.offset$6.elem + 10)));
                this.offset$6.elem += 5;
                this.size$4.elem += i;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$9 = epoch$9;
                this.offset$6 = offset$6;
                this.objectIds$3 = objectIds$3;
                this.endOffsets$1 = endOffsets$1;
                this.size$4 = size$4;
            }
        });
        int numSegmentsToDelete = 5;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegmentsToDelete).foreach$mVc$sp((Function1)new Serializable(this, epoch, objectIds, size2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$9;
            private final ListBuffer objectIds$3;
            private final IntRef size$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.$outer.tpid(), this.epoch$9, (UUID)this.objectIds$3.apply(i)), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.$outer.tpid(), this.epoch$9, (UUID)this.objectIds$3.apply(i)), 0L));
                this.size$4.elem -= i;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$9 = epoch$9;
                this.objectIds$3 = objectIds$3;
                this.size$4 = size$4;
            }
        });
        ListBuffer validObjectIds = (ListBuffer)objectIds.takeRight(numSegments - numSegmentsToDelete);
        List foundObjectIds = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(TierUtils.tieredSegments((NavigableSet)this.state().segmentOffsets(), (TierPartitionState)this.state(), Optional.of(tierObjectStore))).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(TierLogSegment x$5) {
                return x$5.metadata().objectId();
            }
        }).toList();
        Assert.assertEquals((long)validObjectIds.size(), (long)this.state().numSegments());
        Assert.assertEquals((Object)validObjectIds, (Object)foundObjectIds);
        ListBuffer validEndOffsets = (ListBuffer)endOffsets.takeRight(numSegments - numSegmentsToDelete);
        List foundEndOffsets = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(TierUtils.tieredSegments((NavigableSet)this.state().segmentOffsets(), (TierPartitionState)this.state(), Optional.of(tierObjectStore))).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(TierLogSegment x$6) {
                return x$6.endOffset();
            }
        }).toList();
        Assert.assertEquals((Object)validEndOffsets, (Object)foundEndOffsets);
        Assert.assertEquals((long)size2.elem, (long)this.state().totalSize());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.tp(), true);
        try {
            Assert.assertEquals((long)size2.elem, (long)reopenedState.totalSize());
        }
        catch (Throwable throwable) {
            void var13_13;
            var13_13.close();
            throw throwable;
        }
        reopenedState.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEndOffsetIsTrackedForDeleteSegments() {
        int numSegments = 20;
        IntRef epoch = IntRef.create((int)0);
        IntRef offset = IntRef.create((int)0);
        ListBuffer objectIds = new ListBuffer();
        LongRef endOffset = LongRef.create((long)0L);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, UUID.randomUUID(), 0), 0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)new Serializable(this, epoch, offset, objectIds, endOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final IntRef epoch$10;
            private final IntRef offset$7;
            private final ListBuffer objectIds$4;
            private final LongRef endOffset$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                UUID objectId = UUID.randomUUID();
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$10.elem, objectId, (long)this.offset$7.elem, (long)(this.offset$7.elem + 10), 100L, 1, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$10.elem, objectId), 0L));
                this.objectIds$4.$plus$eq((Object)objectId);
                this.endOffset$1.elem = this.offset$7.elem + 10;
                this.offset$7.elem += 5;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$10 = epoch$10;
                this.offset$7 = offset$7;
                this.objectIds$4 = objectIds$4;
                this.endOffset$1 = endOffset$1;
            }
        });
        ObjectRef currentState = ObjectRef.create((Object)this.state());
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments / 2).foreach$mVc$sp((Function1)new Serializable(this, numSegments, epoch, objectIds, endOffset, currentState){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TierPartitionStateTest $outer;
                private final int numSegments$1;
                private final IntRef epoch$10;
                private final ListBuffer objectIds$4;
                private final LongRef endOffset$1;
                private final ObjectRef currentState$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)((FileTierPartitionState)this.currentState$1.elem).append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.$outer.tpid(), this.epoch$10.elem, (UUID)this.objectIds$4.apply(i)), 0L));
                    this.$outer.kafka$tier$state$TierPartitionStateTest$$maybeIncrementEpochAndValidateTierState$1((FileTierPartitionState)this.currentState$1.elem, true, this.endOffset$1.elem, this.numSegments$1 - (i + 1), this.epoch$10);
                    this.currentState$1.elem = new FileTierPartitionState(this.$outer.dir(), this.$outer.tp(), true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.numSegments$1 = numSegments$1;
                    this.epoch$10 = epoch$10;
                    this.objectIds$4 = objectIds$4;
                    this.endOffset$1 = endOffset$1;
                    this.currentState$1 = currentState$1;
                }
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(numSegments / 2), numSegments).foreach$mVc$sp((Function1)new Serializable(this, numSegments, epoch, objectIds, endOffset, currentState){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TierPartitionStateTest $outer;
                private final int numSegments$1;
                private final IntRef epoch$10;
                private final ListBuffer objectIds$4;
                private final LongRef endOffset$1;
                private final ObjectRef currentState$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)((FileTierPartitionState)this.currentState$1.elem).append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.$outer.tpid(), this.epoch$10.elem, (UUID)this.objectIds$4.apply(i)), 0L));
                    this.$outer.kafka$tier$state$TierPartitionStateTest$$maybeIncrementEpochAndValidateTierState$1((FileTierPartitionState)this.currentState$1.elem, false, this.endOffset$1.elem, this.numSegments$1 - (i + 1), this.epoch$10);
                    this.currentState$1.elem = new FileTierPartitionState(this.$outer.dir(), this.$outer.tp(), true);
                    Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)((FileTierPartitionState)this.currentState$1.elem).append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.$outer.tpid(), this.epoch$10.elem, (UUID)this.objectIds$4.apply(i)), 0L));
                    this.$outer.kafka$tier$state$TierPartitionStateTest$$maybeIncrementEpochAndValidateTierState$1((FileTierPartitionState)this.currentState$1.elem, false, this.endOffset$1.elem, this.numSegments$1 - (i + 1), this.epoch$10);
                    this.currentState$1.elem = new FileTierPartitionState(this.$outer.dir(), this.$outer.tp(), true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.numSegments$1 = numSegments$1;
                    this.epoch$10 = epoch$10;
                    this.objectIds$4 = objectIds$4;
                    this.endOffset$1 = endOffset$1;
                    this.currentState$1 = currentState$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var6_6;
            ((FileTierPartitionState)var6_6.elem).close();
            throw throwable;
        }
        ((FileTierPartitionState)currentState.elem).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEndOffsetIsTrackedForSegmentsFencedOnDeleteInitiate() {
        int epoch = 0;
        long offset = 0L;
        long endOffset = 0L;
        UUID objectId = UUID.randomUUID();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, offset, offset + 10L, 100L, 1, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId), 0L));
        endOffset = offset + 10L;
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId), 0L));
        objectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, offset += 5L, offset + 10L, 100L, 1, false, false, false), 0L));
        epoch = 1;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 1), 0L);
        Assert.assertEquals((long)2L, (long)this.state().fencedSegments().size());
        Assert.assertEquals((String)"FileTierPartitionState endOffset runtime value", (long)endOffset, (long)this.state().endOffset());
        Assert.assertEquals((String)"FileTierPartitionState totalSize runtime value", (long)0L, (long)this.state().totalSize());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.tp(), true);
        try {
            Assert.assertEquals((String)reopenedState.toString(), (long)2L, (long)reopenedState.fencedSegments().size());
            Assert.assertEquals((String)"FileTierPartitionState endOffset materialized value", (long)endOffset, (long)reopenedState.endOffset());
            Assert.assertEquals((String)"FileTierPartitionState totalSize materialized value", (long)0L, (long)reopenedState.totalSize());
        }
        catch (Throwable throwable) {
            void var7_5;
            var7_5.close();
            throw throwable;
        }
        reopenedState.close();
    }

    @Test
    public void testMaterializedOffset() {
        Assert.assertEquals((long)-1L, (long)this.state().lastConsumedSrcOffset());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), 100L);
        Assert.assertEquals((long)100L, (long)this.state().lastConsumedSrcOffset());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), 98L);
        Assert.assertEquals((long)100L, (long)this.state().lastConsumedSrcOffset());
        this.state().close();
        FileTierPartitionState restartState = new FileTierPartitionState(this.dir(), this.tp(), true);
        Assert.assertEquals((long)100L, (long)restartState.lastConsumedSrcOffset());
        Assert.assertEquals((long)2L, (long)this.state().version());
    }

    @Test
    public void testIllegalTransitions() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), 0L);
        this.assertIllegal$1((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, UUID.randomUUID()));
        this.assertIllegal$1((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 0, UUID.randomUUID()));
        this.assertIllegal$1((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), 0, UUID.randomUUID()));
        UUID objectId = UUID.randomUUID();
        TierSegmentDeleteComplete deleteComplete = new TierSegmentDeleteComplete(this.tpid(), 0, objectId);
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 10L, 100L, 100, false, false, false), 0L));
        this.assertIllegal$1((AbstractTierMetadata)deleteComplete);
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId), 0L));
        this.assertIllegal$1((AbstractTierMetadata)deleteComplete);
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 0, objectId), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)deleteComplete, 0L));
    }

    @Test
    public void testIdempotencyDeleteAfterComplete() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0);
        UUID objectId1 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1);
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1);
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1);
        UUID objectId2 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2);
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2);
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2);
        this.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend((AbstractTierMetadata)initLeader, (Seq<AbstractTierMetadata>)((Seq)Seq$.MODULE$.empty()), TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierSegmentMetadata[]{uploadInitiate1, uploadComplete1, deleteInitiate1, deleteComplete1, uploadInitiate2, uploadComplete2, deleteInitiate2, deleteComplete2}))).foreach((Function1)new Serializable(this, currentTransitions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final ListBuffer currentTransitions$1;

            public final ListBuffer<AbstractTierMetadata> apply(AbstractTierSegmentMetadata transition) {
                this.$outer.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)this.currentTransitions$1, TierPartitionState.AppendResult.ACCEPTED);
                return this.currentTransitions$1.$plus$eq((Object)transition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTransitions$1 = currentTransitions$1;
            }
        });
    }

    @Test
    public void testIdempotencyDelayedDelete() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0);
        UUID objectId1 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1);
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1);
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1);
        UUID objectId2 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2);
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2);
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2);
        this.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend((AbstractTierMetadata)initLeader, (Seq<AbstractTierMetadata>)((Seq)Seq$.MODULE$.empty()), TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierSegmentMetadata[]{uploadInitiate1, uploadComplete1, uploadInitiate2, uploadComplete2, deleteInitiate1, deleteComplete1, deleteInitiate2, deleteComplete2}))).foreach((Function1)new Serializable(this, currentTransitions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final ListBuffer currentTransitions$2;

            public final ListBuffer<AbstractTierMetadata> apply(AbstractTierSegmentMetadata transition) {
                this.$outer.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)this.currentTransitions$2, TierPartitionState.AppendResult.ACCEPTED);
                return this.currentTransitions$2.$plus$eq((Object)transition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTransitions$2 = currentTransitions$2;
            }
        });
    }

    @Test
    public void testIdempotencySimultaneousDelete() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0);
        UUID objectId1 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1);
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1);
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1);
        UUID objectId2 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2);
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2);
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2);
        this.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend((AbstractTierMetadata)initLeader, (Seq<AbstractTierMetadata>)((Seq)Seq$.MODULE$.empty()), TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierSegmentMetadata[]{uploadInitiate1, uploadComplete1, uploadInitiate2, uploadComplete2, deleteInitiate1, deleteInitiate2, deleteComplete1, deleteComplete2}))).foreach((Function1)new Serializable(this, currentTransitions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final ListBuffer currentTransitions$3;

            public final ListBuffer<AbstractTierMetadata> apply(AbstractTierSegmentMetadata transition) {
                this.$outer.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)this.currentTransitions$3, TierPartitionState.AppendResult.ACCEPTED);
                return this.currentTransitions$3.$plus$eq((Object)transition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTransitions$3 = currentTransitions$3;
            }
        });
    }

    @Test
    public void testIdempotentencyFencing() {
        TierTopicInitLeader initLeader1 = new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0);
        UUID objectId1 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1);
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1);
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1);
        TierTopicInitLeader initLeader2 = new TierTopicInitLeader(this.tpid(), 1, UUID.randomUUID(), 0);
        UUID fencedUploadId = UUID.randomUUID();
        TierSegmentUploadInitiate fencedUploadInitiate = new TierSegmentUploadInitiate(this.tpid(), 0, fencedUploadId, 10L, 20L, 100L, 100, false, false, false);
        UUID objectId2 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 1, objectId2, 10L, 20L, 100L, 100, false, false, false);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 1, objectId2);
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 1, objectId2);
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 1, objectId2);
        this.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend((AbstractTierMetadata)initLeader1, (Seq<AbstractTierMetadata>)((Seq)Seq$.MODULE$.empty()), TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierMetadata[]{uploadInitiate1, uploadComplete1, deleteInitiate1, deleteComplete1, initLeader2}))).foreach((Function1)new Serializable(this, currentTransitions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final ListBuffer currentTransitions$4;

            public final ListBuffer<AbstractTierMetadata> apply(AbstractTierMetadata transition) {
                this.$outer.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend(transition, (Seq<AbstractTierMetadata>)this.currentTransitions$4, TierPartitionState.AppendResult.ACCEPTED);
                return this.currentTransitions$4.$plus$eq((Object)transition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTransitions$4 = currentTransitions$4;
            }
        });
        this.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend((AbstractTierMetadata)fencedUploadInitiate, (Seq<AbstractTierMetadata>)currentTransitions, TierPartitionState.AppendResult.FENCED);
        currentTransitions.$plus$eq((Object)fencedUploadInitiate);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierSegmentMetadata[]{uploadInitiate2, uploadComplete2, deleteInitiate2, deleteComplete2}))).foreach((Function1)new Serializable(this, currentTransitions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final ListBuffer currentTransitions$4;

            public final ListBuffer<AbstractTierMetadata> apply(AbstractTierSegmentMetadata transition) {
                this.$outer.kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)this.currentTransitions$4, TierPartitionState.AppendResult.ACCEPTED);
                return this.currentTransitions$4.$plus$eq((Object)transition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTransitions$4 = currentTransitions$4;
            }
        });
    }

    @Test
    public void testMaterializationListenerCompletion() {
        int epoch = 3;
        TreeSet<Long> baseOffsets = new TreeSet<Long>();
        int numOffsetsInSegment = 49;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), 0L);
        IntRef baseOffset = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, epoch, baseOffsets, numOffsetsInSegment, baseOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final int epoch$11;
            private final TreeSet baseOffsets$1;
            private final int numOffsetsInSegment$1;
            private final IntRef baseOffset$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                UUID objectId = UUID.randomUUID();
                int endOffset = this.baseOffset$1.elem + this.numOffsetsInSegment$1;
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.$outer.tpid(), this.epoch$11, objectId, (long)this.baseOffset$1.elem, (long)endOffset, 100L, 100, false, false, false), 0L));
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.$outer.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.$outer.tpid(), this.epoch$11, objectId), 0L));
                this.baseOffsets$1.add(BoxesRunTime.boxToLong((long)this.baseOffset$1.elem));
                this.baseOffset$1.elem = endOffset + 1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.epoch$11 = epoch$11;
                this.baseOffsets$1 = baseOffsets$1;
                this.numOffsetsInSegment$1 = numOffsetsInSegment$1;
                this.baseOffset$1 = baseOffset$1;
            }
        });
        UUID lastObjectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, lastObjectId, (long)baseOffset.elem, (long)(baseOffset.elem + 49), 100L, 100, false, false, false), 0L));
        Assert.assertEquals((long)(BoxesRunTime.unboxToLong(baseOffsets.last()) + (long)numOffsetsInSegment), (long)this.state().endOffset());
        Assert.assertEquals((long)-1L, (long)this.state().committedEndOffset());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)baseOffsets.floor(BoxesRunTime.boxToLong((long)49L))), (long)((TierObjectMetadata)this.state().materializationListener(49L).get(0L, TimeUnit.MILLISECONDS)).baseOffset());
        Assert.assertEquals((long)(BoxesRunTime.unboxToLong(baseOffsets.last()) + (long)numOffsetsInSegment), (long)this.state().committedEndOffset());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)baseOffsets.floor(BoxesRunTime.boxToLong((long)50L))), (long)((TierObjectMetadata)this.state().materializationListener(50L).get(0L, TimeUnit.MILLISECONDS)).baseOffset());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)baseOffsets.floor(BoxesRunTime.boxToLong((long)155L))), (long)((TierObjectMetadata)this.state().materializationListener(155L).get(0L, TimeUnit.MILLISECONDS)).baseOffset());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)baseOffsets.floor(BoxesRunTime.boxToLong((long)199L))), (long)((TierObjectMetadata)this.state().materializationListener(199L).get(0L, TimeUnit.MILLISECONDS)).baseOffset());
        Future promise = this.state().materializationListener(200L);
        Assert.assertFalse((boolean)promise.isDone());
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, lastObjectId), 0L));
        Assert.assertTrue((boolean)promise.isDone());
        Assert.assertEquals((long)200L, (long)((TierObjectMetadata)promise.get()).baseOffset());
        Assert.assertEquals((Object)lastObjectId, (Object)((TierObjectMetadata)promise.get()).objectId());
        Assert.assertEquals((long)(200 + numOffsetsInSegment), (long)this.state().committedEndOffset());
        Assert.assertFalse((boolean)this.state().materializationListener(500L).isDone());
    }

    @Test
    public void testPreviousMaterializationListenerCancelled() {
        Future promise_1 = this.state().materializationListener(200L);
        Assert.assertFalse((boolean)promise_1.isDone());
        Future promise_2 = this.state().materializationListener(400L);
        Assert.assertFalse((boolean)promise_2.isDone());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, promise_1){
            public static final long serialVersionUID = 0L;
            private final Future promise_1$1;

            public final Object apply() {
                try {
                    return this.promise_1$1.get(0L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException executionException) {
                    throw executionException.getCause();
                }
            }
            {
                this.promise_1$1 = promise_1$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1041));
    }

    @Test
    public void testMaterializationListenerAfterClose() {
        this.state().close();
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;

            public final TierObjectMetadata apply() {
                return (TierObjectMetadata)this.$outer.state().materializationListener(200L).get(0L, TimeUnit.MILLISECONDS);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Exception.class), new Position("TierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1053));
    }

    public void kafka$tier$state$TierPartitionStateTest$$testDuplicateAppend(AbstractTierMetadata metadata, Seq<AbstractTierMetadata> previousTransitions, TierPartitionState.AppendResult expected) {
        Assert.assertEquals((String)metadata.toString(), (Object)expected, (Object)this.state().append(metadata, 0L));
        previousTransitions.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;

            public final void apply(AbstractTierMetadata metadata) {
                TierPartitionState.AppendResult result = this.$outer.state().append(metadata, 0L);
                Assert.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TierPartitionState.AppendResult[]{TierPartitionState.AppendResult.FENCED, TierPartitionState.AppendResult.ACCEPTED}))).apply((Object)result));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        NavigableSet segments = this.state().segmentOffsets();
        Collection fencedSegments = this.state().fencedSegments();
        long size2 = this.state().totalSize();
        Assert.assertEquals((Object)expected, (Object)this.state().append(metadata, 0L));
        Assert.assertEquals((Object)segments, (Object)this.state().segmentOffsets());
        Assert.assertEquals((Object)fencedSegments, (Object)this.state().fencedSegments());
        Assert.assertEquals((long)size2, (long)this.state().totalSize());
    }

    /*
     * WARNING - void declaration
     */
    private void validateConsoleDumpedEntries(File partitionDir, int numSegments) {
        PrintStream sysOut = System.out;
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        System.setOut(new PrintStream(contents));
        try {
            String[] args = new String[]{partitionDir.getAbsolutePath()};
            DumpTierPartitionState.main((String[])args);
        }
        catch (Throwable throwable) {
            void var3_3;
            System.setOut((PrintStream)var3_3);
            throw throwable;
        }
        System.setOut(sysOut);
        String[] lines = contents.toString().split("\n");
        int headerLines = Predef$.MODULE$.refArrayOps((Object[])lines).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return x$7.startsWith("Header");
            }
        });
        Assert.assertEquals((long)1L, (long)headerLines);
        int numLines = Predef$.MODULE$.refArrayOps((Object[])lines).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$8) {
                return x$8.startsWith("TierObjectMetadata");
            }
        });
        Assert.assertEquals((long)numSegments, (long)numLines);
    }

    private void checkInvalidFileReset(File baseDir, TopicPartition tp, String path) {
        FileChannel channel = FileChannel.open(Paths.get(path, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE);
        ByteBuffer buf = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort((short)80);
        buf.putInt(1);
        buf.flip();
        channel.position(channel.size());
        channel.write(buf);
        channel.close();
        FileTierPartitionState state = new FileTierPartitionState(baseDir, tp, true);
        Assert.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        Assert.assertEquals((long)0L, (long)state.segmentOffsets().size());
        Assert.assertEquals((long)0L, (long)state.fencedSegments().size());
        Assert.assertEquals((long)-1L, (long)state.tierEpoch());
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), 0L));
        UUID objectId = UUID.randomUUID();
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 100L, 100L, 100, false, false, false), 0L));
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId), 0L));
        Assert.assertEquals((long)0L, (long)state.tierEpoch());
        Assert.assertEquals((long)1L, (long)state.segmentOffsets().size());
        state.close();
    }

    /*
     * WARNING - void declaration
     */
    public final void kafka$tier$state$TierPartitionStateTest$$maybeIncrementEpochAndValidateTierState$1(FileTierPartitionState state, boolean isLeader, long expectedEndOffset, long expectedSize, IntRef epoch$10) {
        BoxedUnit boxedUnit;
        Assert.assertEquals((String)"FileTierPartitionState endOffset at run time", (long)expectedEndOffset, (long)state.endOffset());
        Assert.assertEquals((String)"FileTierPartitionState totalSize at run time", (long)expectedSize, (long)state.totalSize());
        if (isLeader) {
            ++epoch$10.elem;
            boxedUnit = state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch$10.elem, UUID.randomUUID(), 0), 0L);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        state.close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.tp(), true);
        try {
            Assert.assertEquals((String)"FileTierPartitionState endOffset materialized value", (long)expectedEndOffset, (long)reopenedState.endOffset());
            Assert.assertEquals((String)"FileTierPartitionState totalSize materialized value", (long)expectedSize, (long)reopenedState.totalSize());
        }
        catch (Throwable throwable) {
            void var8_6;
            var8_6.close();
            throw throwable;
        }
        reopenedState.close();
    }

    private final void assertIllegal$1(AbstractTierMetadata metadata) {
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, metadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierPartitionStateTest $outer;
            private final AbstractTierMetadata metadata$1;

            public final TierPartitionState.AppendResult apply() {
                return this.$outer.state().append(this.metadata$1, 0L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metadata$1 = metadata$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850));
    }
}

