/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.IOException;
import kafka.tier.store.AutoAbortingS3InputStream;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;

public class AutoAbortingS3InputStreamTest {
    @Test
    public void drainTest() throws IOException {
        S3ObjectInputStream inputStream = (S3ObjectInputStream)EasyMock.createNiceMock(S3ObjectInputStream.class);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 90;
            }
        });
        inputStream.close();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingS3InputStream autoAborting = new AutoAbortingS3InputStream(inputStream, 100L, 110L);
        int read1 = autoAborting.read(new byte[10]);
        Assert.assertEquals((long)10L, (long)read1);
        int read2 = autoAborting.read(new byte[10]);
        Assert.assertEquals((long)10L, (long)read2);
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }

    @Test
    public void excessiveDrainTest() throws IOException {
        S3ObjectInputStream inputStream = (S3ObjectInputStream)EasyMock.createNiceMock(S3ObjectInputStream.class);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        inputStream.abort();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingS3InputStream autoAborting = new AutoAbortingS3InputStream(inputStream, 100L, 300L);
        int read1 = autoAborting.read(new byte[10]);
        Assert.assertEquals((long)10L, (long)read1);
        int read2 = autoAborting.read(new byte[10]);
        Assert.assertEquals((long)10L, (long)read2);
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }

    @Test
    public void exceptionOnReadAttemptReread() throws IOException {
        S3ObjectInputStream inputStream = (S3ObjectInputStream)EasyMock.createNiceMock(S3ObjectInputStream.class);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andThrow((Throwable)new IOException("failed to read"));
        inputStream.abort();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingS3InputStream autoAborting = new AutoAbortingS3InputStream(inputStream, 100L, 300L);
        int read1 = autoAborting.read(new byte[10]);
        Assert.assertEquals((long)10L, (long)read1);
        Assert.assertThrows(IOException.class, () -> autoAborting.read(new byte[10]));
        Assert.assertThrows(IllegalStateException.class, () -> autoAborting.read(new byte[10]));
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }

    @Test
    public void abortTest() throws IOException {
        S3ObjectInputStream inputStream = (S3ObjectInputStream)EasyMock.createNiceMock(S3ObjectInputStream.class);
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Integer>(){

            public Integer answer() throws Throwable {
                return 10;
            }
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.anyObject())).andThrow((Throwable)new IOException("failed to read"));
        inputStream.abort();
        EasyMock.expectLastCall().andVoid();
        EasyMock.replay((Object[])new Object[]{inputStream});
        AutoAbortingS3InputStream autoAborting = new AutoAbortingS3InputStream(inputStream, 100L, 110L);
        int read1 = autoAborting.read(new byte[10]);
        Assert.assertEquals((long)10L, (long)read1);
        Assert.assertThrows(IOException.class, () -> autoAborting.read(new byte[10]));
        autoAborting.close();
        EasyMock.verify((Object[])new Object[]{inputStream});
    }
}

