/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.GcsTierObjectStore;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001\u0013\t1riY:US\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)1\u000f^8sK*\u0011QAB\u0001\u0005i&,'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u0015\u00015\t!\u0001C\u0003\u0017\u0001\u0011\u0005q#A\u0007uKN$8+\u001b8hY\u0016\u0004V\u000f\u001e\u000b\u00021A\u00111\"G\u0005\u000351\u0011A!\u00168ji\"\u0012Q\u0003\b\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nQA[;oSRT\u0011!I\u0001\u0004_J<\u0017BA\u0012\u001f\u0005\u0011!Vm\u001d;\t\u000b\u0015\u0002A\u0011A\f\u00029Q,7\u000f^*j]\u001edW\rU;u/&$\b.\u00112peR,G\r\u0016=og\"\u0012A\u0005\b\u0005\u0006Q\u0001!\taF\u0001%i\u0016\u001cHoU5oO2,\u0007+\u001e;Qe>$WoY3s'R\fG/Z#q_\u000eD7\u000b^1uK\"\u0012q\u0005\b")
public class GcsTierObjectStoreTest {
    @Test
    public void testSinglePut() {
        Storage storage = (Storage)Mockito.mock(Storage.class);
        Bucket bucket = (Bucket)Mockito.mock(Bucket.class);
        Mockito.when((Object)storage.get(ArgumentMatchers.anyString(), new Storage.BucketGetOption[]{(Storage.BucketGetOption)ArgumentMatchers.any(Storage.BucketGetOption.class)})).thenReturn((Object)bucket);
        Mockito.when((Object)storage.writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0])).thenReturn(Mockito.mock(WriteChannel.class));
        Mockito.when((Object)bucket.getLocation()).thenReturn((Object)"REGION");
        GcsTierObjectStoreConfig config = new GcsTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(3), "bucket", "region", Predef$.MODULE$.int2Integer(10240), Predef$.MODULE$.int2Integer(1024), "path");
        GcsTierObjectStore objectStore = new GcsTierObjectStore(storage, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false);
        File testFile = TestUtils$.MODULE$.tempFile();
        objectStore.putSegment(metadata, testFile, testFile, testFile, Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)3))).writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0]);
    }

    @Test
    public void testSinglePutWithAbortedTxns() {
        Storage storage = (Storage)Mockito.mock(Storage.class);
        Bucket bucket = (Bucket)Mockito.mock(Bucket.class);
        Mockito.when((Object)storage.get(ArgumentMatchers.anyString(), new Storage.BucketGetOption[]{(Storage.BucketGetOption)ArgumentMatchers.any(Storage.BucketGetOption.class)})).thenReturn((Object)bucket);
        Mockito.when((Object)storage.writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0])).thenReturn(Mockito.mock(WriteChannel.class));
        Mockito.when((Object)bucket.getLocation()).thenReturn((Object)"REGION");
        GcsTierObjectStoreConfig config = new GcsTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(3), "bucket", "region", Predef$.MODULE$.int2Integer(10240), Predef$.MODULE$.int2Integer(1024), "path");
        GcsTierObjectStore objectStore = new GcsTierObjectStore(storage, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, true);
        File testFile = TestUtils$.MODULE$.tempFile();
        ByteBuffer bb = ByteBuffer.allocate(0);
        objectStore.putSegment(metadata, testFile, testFile, testFile, Optional.empty(), Optional.of(bb), Optional.empty());
        ((Storage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)4))).writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0]);
    }

    @Test
    public void testSinglePutProducerStateEpochState() {
        Storage storage = (Storage)Mockito.mock(Storage.class);
        Bucket bucket = (Bucket)Mockito.mock(Bucket.class);
        Mockito.when((Object)storage.get(ArgumentMatchers.anyString(), new Storage.BucketGetOption[]{(Storage.BucketGetOption)ArgumentMatchers.any(Storage.BucketGetOption.class)})).thenReturn((Object)bucket);
        Mockito.when((Object)storage.writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0])).thenReturn(Mockito.mock(WriteChannel.class));
        Mockito.when((Object)bucket.getLocation()).thenReturn((Object)"REGION");
        GcsTierObjectStoreConfig config = new GcsTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(3), "bucket", "region", Predef$.MODULE$.int2Integer(10240), Predef$.MODULE$.int2Integer(1024), "path");
        GcsTierObjectStore objectStore = new GcsTierObjectStore(storage, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false);
        File testFile = TestUtils$.MODULE$.tempFile();
        objectStore.putSegment(metadata, testFile, testFile, testFile, Optional.of(testFile), Optional.empty(), Optional.of(testFile));
        ((Storage)Mockito.verify((Object)storage, (VerificationMode)Mockito.times((int)5))).writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0]);
    }
}

