/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A2A!\u0001\u0002\u0001\u0013\tY2k\r+jKJ|%M[3diN#xN]3D_:4\u0017n\u001a+fgRT!a\u0001\u0003\u0002\u000bM$xN]3\u000b\u0005\u00151\u0011\u0001\u0002;jKJT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAQA\u0006\u0001\u0005\u0002]\tQ\u0003^3tiZ\u000bG.\u001b3D_:4\u0017n\u001a(p\u0003V$\b\u000eF\u0001\u0019!\tY\u0011$\u0003\u0002\u001b\u0019\t!QK\\5uQ\t)B\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005)!.\u001e8ji*\t\u0011%A\u0002pe\u001eL!a\t\u0010\u0003\tQ+7\u000f\u001e\u0005\u0006K\u0001!\taF\u0001\u0018i\u0016\u001cHOV1mS\u0012\u001cuN\u001c4jO^KG\u000f[!vi\"D#\u0001\n\u000f\t\u000b!\u0002A\u0011A\f\u00027Q,7\u000f\u001e,bY&$7i\u001c8gS\u001e<\u0016\u000e\u001e5F]\u0012\u0004x.\u001b8uQ\t9C\u0004C\u0003,\u0001\u0011\u0005q#A\ruKN$\u0018J\u001c<bY&$7i\u001c8gS\u001etuNU3hS>t\u0007F\u0001\u0016\u001d\u0011\u0015q\u0003\u0001\"\u0001\u0018\u0003a!Xm\u001d;J]Z\fG.\u001b3D_:4\u0017n\u001a(p\u0017\u0016L\u0018\n\u0012\u0015\u0003[q\u0001")
public class S3TierObjectStoreConfigTest {
    @Test
    public void testValidConfigNoAuth() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        S3TierObjectStoreConfig s3Config = new S3TierObjectStoreConfig("clusterid", kafkaConfig);
        Predef$.MODULE$.assert(!s3Config.s3AwsAccessKeyId.isPresent());
        Predef$.MODULE$.assert(!s3Config.s3AwsSecretAccessKey.isPresent());
    }

    @Test
    public void testValidConfigWithAuth() {
        int x$21 = 0;
        String x$22 = "127.0.0.1:1";
        int x$23 = -1;
        boolean x$24 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$26 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$27 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$28 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$29 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$30 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$31 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$33 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$34 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$35 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$36 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$37 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$38 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$39 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$40 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$21, x$22, x$24, x$25, x$23, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        props.put(KafkaConfig$.MODULE$.TierS3AwsSecretAccessKeyProp(), "secret");
        props.put(KafkaConfig$.MODULE$.TierS3AwsAccessKeyIdProp(), "keyid");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        S3TierObjectStoreConfig s3Config = new S3TierObjectStoreConfig("clusterid", kafkaConfig);
        Predef$.MODULE$.assert(s3Config.s3AwsAccessKeyId.isPresent());
        Predef$.MODULE$.assert(s3Config.s3AwsSecretAccessKey.isPresent());
    }

    @Test
    public void testValidConfigWithEndpoint() {
        int x$41 = 0;
        String x$42 = "127.0.0.1:1";
        int x$43 = -1;
        boolean x$44 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$45 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$46 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$47 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$48 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$49 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$50 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$51 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$52 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$53 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$54 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$55 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$56 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$57 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$58 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$59 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$60 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$41, x$42, x$44, x$45, x$43, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        props.put(KafkaConfig$.MODULE$.TierS3EndpointOverrideProp(), "endpoint");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        S3TierObjectStoreConfig s3Config = new S3TierObjectStoreConfig("clusterid", kafkaConfig);
        Predef$.MODULE$.assert(s3Config.s3EndpointOverride.isPresent());
    }

    @Test
    public void testInvalidConfigNoRegion() {
        int x$61 = 0;
        String x$62 = "127.0.0.1:1";
        int x$63 = -1;
        boolean x$64 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$65 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$66 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$67 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$68 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$69 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$70 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$71 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$72 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$73 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$74 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$75 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$76 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$77 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$78 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$79 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$80 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$61, x$62, x$64, x$65, x$63, x$66, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, kafkaConfig){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig kafkaConfig$1;

            public final S3TierObjectStoreConfig apply() {
                return new S3TierObjectStoreConfig("clusterid", this.kafkaConfig$1);
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }

    @Test
    public void testInvalidConfigNoKeyID() {
        int x$81 = 0;
        String x$82 = "127.0.0.1:1";
        int x$83 = -1;
        boolean x$84 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$85 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$86 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$87 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$88 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$89 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$90 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$91 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$92 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$93 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$94 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$95 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$96 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$97 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$98 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$99 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$100 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$81, x$82, x$84, x$85, x$83, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        props.put(KafkaConfig$.MODULE$.TierS3AwsSecretAccessKeyProp(), "secret");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, kafkaConfig){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig kafkaConfig$2;

            public final S3TierObjectStoreConfig apply() {
                return new S3TierObjectStoreConfig("clusterid", this.kafkaConfig$2);
            }
            {
                this.kafkaConfig$2 = kafkaConfig$2;
            }
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
    }
}

