/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbstractPutObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.S3TierObjectStore;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001\u0013\t)2k\r+jKJ|%M[3diN#xN]3UKN$(BA\u0002\u0005\u0003\u0015\u0019Ho\u001c:f\u0015\t)a!\u0001\u0003uS\u0016\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005\u0011\u0001\"\u0002\f\u0001\t\u00039\u0012!\u0004;fgR\u001c\u0016N\\4mKB+H\u000fF\u0001\u0019!\tY\u0011$\u0003\u0002\u001b\u0019\t!QK\\5uQ\t)B\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005)!.\u001e8ji*\t\u0011%A\u0002pe\u001eL!a\t\u0010\u0003\tQ+7\u000f\u001e\u0005\u0006K\u0001!\taF\u0001\u001di\u0016\u001cHoU5oO2,\u0007+\u001e;XSRD\u0017IY8si\u0016$G\u000b\u001f8tQ\t!C\u0004C\u0003)\u0001\u0011\u0005q#\u0001\tuKN$X*\u001e7uSB\u000b'\u000f\u001e)vi\"\u0012q\u0005\b\u0005\u0006W\u0001!\taF\u0001%i\u0016\u001cHoU5oO2,\u0007+\u001e;Qe>$WoY3s'R\fG/Z#q_\u000eD7\u000b^1uK\"\u0012!\u0006\b")
public class S3TierObjectStoreTest {
    @Test
    public void testSinglePut() {
        int segmentSize = 100;
        int partSize = 200;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = new S3TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(3), "bucket", "region", "key", "id", "endpoint", "signer", "sseAlgorithm", Predef$.MODULE$.int2Integer(partSize), Predef$.MODULE$.int2Integer(0));
        S3TierObjectStore objectStore = new S3TierObjectStore(client, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false);
        File segmentData = (File)Mockito.mock(File.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)segmentSize));
        objectStore.putSegment(metadata, segmentData, null, null, Optional.empty(), Optional.empty(), Optional.empty());
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)3))).putObject((PutObjectRequest)ArgumentMatchers.any());
    }

    @Test
    public void testSinglePutWithAbortedTxns() {
        int segmentSize = 100;
        int partSize = 200;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = new S3TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(3), "bucket", "region", "key", "id", "endpoint", "signer", "sseAlgorithm", Predef$.MODULE$.int2Integer(partSize), Predef$.MODULE$.int2Integer(0));
        S3TierObjectStore objectStore = new S3TierObjectStore(client, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, true);
        File segmentData = (File)Mockito.mock(File.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)segmentSize));
        objectStore.putSegment(metadata, segmentData, null, null, Optional.empty(), Optional.of(ByteBuffer.allocate(0)), Optional.empty());
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)4))).putObject((PutObjectRequest)ArgumentMatchers.any());
    }

    @Test
    public void testMultiPartPut() {
        int segmentSize = 100;
        int partSize = 33;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = new S3TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(3), "bucket", "region", "key", "id", "endpoint", "signer", "sseAlgorithm", Predef$.MODULE$.int2Integer(partSize), Predef$.MODULE$.int2Integer(0));
        S3TierObjectStore objectStore = new S3TierObjectStore(client, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false);
        File segmentData = (File)Mockito.mock(File.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)segmentSize));
        Mockito.when((Object)client.initiateMultipartUpload((InitiateMultipartUploadRequest)ArgumentMatchers.any())).thenReturn(Mockito.mock(InitiateMultipartUploadResult.class));
        Mockito.when((Object)client.uploadPart((UploadPartRequest)ArgumentMatchers.any())).thenReturn(Mockito.mock(UploadPartResult.class));
        objectStore.putSegment(metadata, segmentData, null, null, Optional.empty(), Optional.of(ByteBuffer.allocate(0)), Optional.empty());
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)3))).putObject((PutObjectRequest)ArgumentMatchers.any());
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)((int)package$.MODULE$.ceil((double)segmentSize / (double)partSize))))).uploadPart((UploadPartRequest)ArgumentMatchers.any());
    }

    @Test
    public void testSinglePutProducerStateEpochState() {
        int segmentSize = 100;
        int partSize = 200;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = new S3TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(3), "bucket", "region", "key", "id", "endpoint", "signer", "sseAlgorithm", Predef$.MODULE$.int2Integer(partSize), Predef$.MODULE$.int2Integer(0));
        S3TierObjectStore objectStore = new S3TierObjectStore(client, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false);
        File segmentData = (File)Mockito.mock(File.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(PutObjectRequest.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)segmentSize));
        int producerIndexLength = 100;
        ByteBuffer producerIndexBuf = ByteBuffer.allocate(producerIndexLength);
        producerIndexBuf.limit(producerIndexLength);
        objectStore.putSegment(metadata, segmentData, null, null, Optional.of(segmentData), Optional.of(producerIndexBuf), Optional.of(segmentData));
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)6))).putObject((PutObjectRequest)captor.capture());
        Assert.assertEquals((long)producerIndexLength, (long)((AbstractPutObjectRequest)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(captor.getAllValues()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final PutObjectRequest apply(PutObjectRequest x$1) {
                return x$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PutObjectRequest x$2) {
                return x$2.getKey().contains(".transaction-index");
            }
        }).get()).getMetadata().getContentLength());
    }
}

