/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.File;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.log.AbstractLog;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t=b\u0001B\u0001\u0003\u0001-\u0011!$\u0011:dQ&4X\rV1tW&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u000f\u0005\u00148\r[5wK*\u0011QAB\u0001\u0006i\u0006\u001c8n\u001d\u0006\u0003\u000f!\tA\u0001^5fe*\t\u0011\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!I\u0001\u0004\u0001a\u0001\u0002\u0004%\t!G\u0001\tKb,7-\u001e;peV\t!\u0004\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005}\u0001\u0013\u0001B;uS2T\u0011!I\u0001\u0005U\u00064\u0018-\u0003\u0002$9\tyQ\t_3dkR|'oU3sm&\u001cW\rC\u0005&\u0001\u0001\u0007\t\u0019!C\u0001M\u0005aQ\r_3dkR|'o\u0018\u0013fcR\u0011qE\u000b\t\u0003\u001b!J!!\u000b\b\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0011\n\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007[\u0001\u0001\u000b\u0015\u0002\u000e\u0002\u0013\u0015DXmY;u_J\u0004\u0003bB\u0018\u0001\u0001\u0004%\u0019\u0001M\u0001\u0003K\u000e,\u0012!\r\t\u0003eQj\u0011a\r\u0006\u0003;9I!!N\u001a\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bbB\u001c\u0001\u0001\u0004%\t\u0001O\u0001\u0007K\u000e|F%Z9\u0015\u0005\u001dJ\u0004bB\u00167\u0003\u0003\u0005\r!\r\u0005\u0007w\u0001\u0001\u000b\u0015B\u0019\u0002\u0007\u0015\u001c\u0007\u0005C\u0005>\u0001\u0001\u0007\t\u0019!C\u0001}\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0002\u007fA\u0011\u0001)Q\u0007\u0002\r%\u0011!I\u0002\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:D\u0011\u0002\u0012\u0001A\u0002\u0003\u0007I\u0011A#\u0002)Q|\u0007/[2JIB\u000b'\u000f^5uS>tw\fJ3r)\t9c\tC\u0004,\u0007\u0006\u0005\t\u0019A \t\r!\u0003\u0001\u0015)\u0003@\u0003E!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\t\u0005\b\u0015\u0002\u0001\r\u0011\"\u0001L\u0003\u0019\u0019wN\u001c4jOV\tA\n\u0005\u0002N!6\taJ\u0003\u0002P\u0011\u000511/\u001a:wKJL!!\u0015(\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b'\u0002\u0001\r\u0011\"\u0001U\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0003OUCqa\u000b*\u0002\u0002\u0003\u0007A\n\u0003\u0004X\u0001\u0001\u0006K\u0001T\u0001\bG>tg-[4!\u0011\u001dI\u0006A1A\u0005\u0002i\u000b\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0003m\u0003\"!\u0014/\n\u0005us%\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019y\u0006\u0001)A\u00057\u0006\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u0013\u0005\u0004\u0001\u0019!a\u0001\n\u0003\u0011\u0017A\u0002;na\u0012K'/F\u0001d!\t!w-D\u0001f\u0015\t1\u0007%\u0001\u0002j_&\u0011\u0001.\u001a\u0002\u0005\r&dW\rC\u0005k\u0001\u0001\u0007\t\u0019!C\u0001W\u0006QA/\u001c9ESJ|F%Z9\u0015\u0005\u001db\u0007bB\u0016j\u0003\u0003\u0005\ra\u0019\u0005\u0007]\u0002\u0001\u000b\u0015B2\u0002\u000fQl\u0007\u000fR5sA!I\u0001\u000f\u0001a\u0001\u0002\u0004%\tAY\u0001\u0007Y><G)\u001b:\t\u0013I\u0004\u0001\u0019!a\u0001\n\u0003\u0019\u0018A\u00037pO\u0012K'o\u0018\u0013fcR\u0011q\u0005\u001e\u0005\bWE\f\t\u00111\u0001d\u0011\u00191\b\u0001)Q\u0005G\u00069An\\4ESJ\u0004\u0003b\u0002=\u0001\u0005\u0004%\t!_\u0001\t[>\u001c7\u000eV5nKV\t!\u0010\u0005\u0002|}6\tAP\u0003\u0002~\u0011\u0005)Q\u000f^5mg&\u0011q\u0010 \u0002\t\u001b>\u001c7\u000eV5nK\"9\u00111\u0001\u0001!\u0002\u0013Q\u0018!C7pG.$\u0016.\\3!\u0011%\t9\u0001\u0001b\u0001\n\u0003\tI!A\ruS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)Y2u_JLXCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\r\u0005)1\u000f^1uK&!\u0011QCA\b\u0005e!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GC\u000e$xN]=\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0017\t!\u0004^5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001a\u000b7\r^8ss\u0002B\u0011\"!\b\u0001\u0005\u0004%\t!a\b\u0002#QLWM\u001d'pO\u000e{W\u000e]8oK:$8/\u0006\u0002\u0002\"A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(!\t1\u0001\\8h\u0013\u0011\tY#!\n\u0003#QKWM\u001d'pO\u000e{W\u000e]8oK:$8\u000f\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0011\u0003I!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo\u001d\u0011\t\u0013\u0005M\u0002A1A\u0005\u0002\u0005U\u0012A\u0005;sC:\u001c\u0018\u000e^5p]^\u000b\u0017\u000e\u001e+j[\u0016,\"!a\u000e\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u00104\u0003!!WO]1uS>t\u0017\u0002BA!\u0003w\u0011aBR5oSR,G)\u001e:bi&|g\u000e\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001c\u0003M!(/\u00198tSRLwN\\,bSR$\u0016.\\3!\u0011%\tI\u0005\u0001b\u0001\n\u0003\tY%A\nuS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,7/\u0006\u0002\u0002NA11$a\u0014@\u0003'J1!!\u0015\u001d\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003\u001b\t)&\u0003\u0003\u0002X\u0005=!A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016D\u0001\"a\u0017\u0001A\u0003%\u0011QJ\u0001\u0015i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0011\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b\u0005)1/\u001a;vaR\tq\u0005\u000b\u0003\u0002^\u0005\u0015\u0004\u0003BA4\u0003cj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003_\n1a\u001c:h\u0013\u0011\t\u0019(!\u001b\u0003\r\t+gm\u001c:f\u0011\u001d\t9\b\u0001C\u0001\u0003C\n\u0001\u0002^3be\u0012|wO\u001c\u0015\u0005\u0003k\nY\b\u0005\u0003\u0002h\u0005u\u0014\u0002BA@\u0003S\u0012Q!\u00114uKJDq!a!\u0001\t\u0013\t))\u0001\u000em_\u001e\u0004&o\u001c<jI&twMU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0006\u0004\u0002\b\u00065\u0015q\u0012\t\u0004\u001b\u0006%\u0015bAAF\u001d\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bBB\u001f\u0002\u0002\u0002\u0007q\b\u0003\u0005\u0002\u0012\u0006\u0005\u0005\u0019AAJ\u0003-\t'm\u001d;sC\u000e$Hj\\4\u0011\t\u0005\r\u0012QS\u0005\u0005\u0003/\u000b)CA\u0006BEN$(/Y2u\u0019><\u0007bBAN\u0001\u0011%\u0011QT\u0001\u0019GJ,\u0017\r^3US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G\u0003BA*\u0003?Ca!PAM\u0001\u0004ydABAR\u0001\u0001\t)K\u0001\u000bN_\u000e\\G+[3s)>\u0004\u0018nY'b]\u0006<WM]\n\u0007\u0003C\u000b9+a-\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,!\u0003\u0011a\u0017M\\4\n\t\u0005E\u00161\u0016\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS1!!/\u0007\u0003\u0015!x\u000e]5d\u0013\u0011\ti,a.\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000fC\u0004\u0014\u0003C#\t!!1\u0015\u0005\u0005\r\u0007\u0003BAc\u0003Ck\u0011\u0001\u0001\u0005\t\u0003\u0013\f\t\u000b\"\u0011\u0002L\u0006q!-Z2p[\u0016\f%o\u00195jm\u0016\u0014HCBAg\u0003C\f)\u000fE\u0003\u001c\u0003\u001f\f\u0019.C\u0002\u0002Rr\u0011\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\t).a7\u000f\t\u00055\u0011q[\u0005\u0005\u00033\fy!\u0001\nUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0017\u0002BAo\u0003?\u0014A\"\u00119qK:$'+Z:vYRTA!!7\u0002\u0010!9\u00111]Ad\u0001\u0004y\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u0003O\f9\r1\u0001\u0002j\u0006IA/[3s\u000bB|7\r\u001b\t\u0004\u001b\u0005-\u0018bAAw\u001d\t\u0019\u0011J\u001c;\t\u0011\u0005E\u0018\u0011\u0015C!\u0003g\f1\"\u00193e\u001b\u0016$\u0018\rZ1uCR!\u0011QZA{\u0011!\t90a<A\u0002\u0005e\u0018!B3oiJL\b\u0003BA~\u0005\u0003i!!!@\u000b\u0007\u0005}h!\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0005\u0007\tiP\u0001\u000bBEN$(/Y2u)&,'/T3uC\u0012\fG/\u0019\u0005\t\u0005\u000f\t\t\u000b\"\u0011\u0003\n\u00059\u0011n\u001d*fC\u0012LHC\u0001B\u0006!\ri!QB\u0005\u0004\u0005\u001fq!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005'\u0001A\u0011AA1\u0003]!Xm\u001d;Be\u000eD\u0017N^3UCN\\W)\u001c9us2{w\r\u000b\u0003\u0003\u0012\t]\u0001\u0003BA4\u00053IAAa\u0007\u0002j\t!A+Z:u\u0011\u001d\u0011y\u0002\u0001C\u0001\u0003C\n1\u0005^3ti\u0006\u00138\r[5wKR\u000b7o[+qY>\fGm\u001d)s_\u0012,8-\u001a:Ti\u0006$X\r\u000b\u0003\u0003\u001e\t]\u0001b\u0002B\u0013\u0001\u0011\u0005\u0011\u0011M\u0001-i\u0016\u001cH/\u0011:dQ&4XM\u001d*fiJLWm](o\u0007>t7-\u001e:sK:$H)\u001a7fi\u0016\u0014VmY8sINDCAa\t\u0003\u0018!9!1\u0006\u0001\u0005\u0002\u0005\u0005\u0014\u0001\u000b;fgR\f%o\u00195jm\u0016\u0014X\t_2faRLwN\\(o!\u0006\u0014H/\u001b;j_:$U\r\\3uS>t\u0007\u0006\u0002B\u0015\u0005/\u0001")
public class ArchiveTaskIntegrationTest {
    private ExecutorService executor;
    private ExecutionContext ec = ExecutionContext$.MODULE$.fromExecutorService(this.executor());
    private TopicIdPartition topicIdPartition;
    private KafkaConfig config = null;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private File tmpDir;
    private File logDir;
    private final MockTime mockTime = new MockTime();
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, this.tierPartitionStateFactory());
    private final FiniteDuration transitionWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private final ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates = new ConcurrentHashMap();

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public void ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public void topicIdPartition_$eq(TopicIdPartition x$1) {
        this.topicIdPartition = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public FiniteDuration transitionWaitTime() {
        return this.transitionWaitTime;
    }

    public ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates() {
        return this.tierPartitionStates;
    }

    @Before
    public void setup() {
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.executor_$eq(Executors.newFixedThreadPool(1));
        int x$3 = 0;
        String x$4 = "127.0.0.1:1";
        int x$5 = -1;
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$18 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$20 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$21 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$22 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$3, x$4, x$6, x$7, x$5, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir());
        this.topicIdPartition_$eq(new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition()));
    }

    @After
    public void teardown() {
        this.executor().shutdownNow();
        this.brokerTopicStats().close();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.tierPartitionStates().values()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TierPartitionState tierPartitionState2) {
                tierPartitionState2.close();
                tierPartitionState2.delete();
            }
        });
        this.tierPartitionStates().clear();
        Utils.delete((File)this.tmpDir());
        Utils.delete((File)this.logDir());
    }

    private ReplicaManager logProvidingReplicaManager(TopicIdPartition topicIdPartition, AbstractLog abstractLog) {
        return (ReplicaManager)Mockito.when((Object)((ReplicaManager)Mockito.mock(ReplicaManager.class)).getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)abstractLog)).getMock();
    }

    /*
     * WARNING - void declaration
     */
    private TierPartitionState createTierPartitionState(TopicIdPartition topicIdPartition) {
        void var2_2;
        FileTierPartitionState tierPartitionState2 = new FileTierPartitionState(TestUtils$.MODULE$.tempDir(), topicIdPartition.topicPartition(), true);
        tierPartitionState2.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates().put(topicIdPartition, (TierPartitionState)tierPartitionState2);
        return var2_2;
    }

    @Test
    public void testArchiveTaskEmptyLog() {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore(new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        int leaderEpoch = 0;
        int x$23 = 0x500000;
        boolean x$24 = true;
        long x$25 = LogTest$.MODULE$.createLogConfig$default$1();
        long x$26 = LogTest$.MODULE$.createLogConfig$default$3();
        long x$27 = LogTest$.MODULE$.createLogConfig$default$4();
        long x$28 = LogTest$.MODULE$.createLogConfig$default$5();
        String x$29 = LogTest$.MODULE$.createLogConfig$default$6();
        int x$30 = LogTest$.MODULE$.createLogConfig$default$7();
        int x$31 = LogTest$.MODULE$.createLogConfig$default$8();
        int x$32 = LogTest$.MODULE$.createLogConfig$default$9();
        String x$33 = LogTest$.MODULE$.createLogConfig$default$10();
        long x$34 = LogTest$.MODULE$.createLogConfig$default$11();
        long x$35 = LogTest$.MODULE$.createLogConfig$default$13();
        long x$36 = LogTest$.MODULE$.createLogConfig$default$14();
        int x$37 = LogTest$.MODULE$.createLogConfig$default$15();
        long x$38 = LogTest$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTest$.MODULE$.createLogConfig(x$25, x$23, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$24, x$35, x$36, x$37, x$38);
        TierPartitionState tierPartitionState2 = this.createTierPartitionState(this.topicIdPartition());
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig)).thenReturn((Object)tierPartitionState2);
        MockTierTopicManager tierTopicManger = new MockTierTopicManager();
        tierTopicManger.becomeArchiver(this.topicIdPartition(), leaderEpoch);
        File x$39 = this.logDir();
        LogConfig x$40 = logConfig;
        BrokerTopicStats x$41 = this.brokerTopicStats();
        MockScheduler x$42 = this.mockTime().scheduler();
        MockTime x$43 = this.mockTime();
        Some x$44 = new Some((Object)this.tierLogComponents());
        long x$45 = LogTest$.MODULE$.createLog$default$6();
        long x$46 = LogTest$.MODULE$.createLog$default$7();
        int x$47 = LogTest$.MODULE$.createLog$default$8();
        int x$48 = LogTest$.MODULE$.createLog$default$9();
        AbstractLog log2 = LogTest$.MODULE$.createLog(x$39, x$40, x$41, x$42, (Time)x$43, x$45, x$46, x$47, x$48, (Option<TierLogComponents>)x$44);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), log2);
        ArchiveTask nextState = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManger, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assert.assertTrue((String)"expected to be in BeforeUpload", (boolean)(nextState.state() instanceof BeforeUpload));
        Assert.assertFalse((String)"expected task to not be cancelled", (boolean)nextState.ctx().isCancelled());
        Assert.assertEquals((String)"expected zero segments to be uploaded", (Object)tierObjectStore.getObjectCounts().getOrDefault(TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0)), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    @Test
    public void testArchiveTaskUploadsProducerState() {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore(new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        int leaderEpoch = 0;
        int x$49 = 1024;
        long x$50 = LogTest$.MODULE$.createLogConfig$default$1();
        long x$51 = LogTest$.MODULE$.createLogConfig$default$3();
        long x$52 = LogTest$.MODULE$.createLogConfig$default$4();
        long x$53 = LogTest$.MODULE$.createLogConfig$default$5();
        String x$54 = LogTest$.MODULE$.createLogConfig$default$6();
        int x$55 = LogTest$.MODULE$.createLogConfig$default$7();
        int x$56 = LogTest$.MODULE$.createLogConfig$default$8();
        int x$57 = LogTest$.MODULE$.createLogConfig$default$9();
        String x$58 = LogTest$.MODULE$.createLogConfig$default$10();
        long x$59 = LogTest$.MODULE$.createLogConfig$default$11();
        boolean x$60 = LogTest$.MODULE$.createLogConfig$default$12();
        long x$61 = LogTest$.MODULE$.createLogConfig$default$13();
        long x$62 = LogTest$.MODULE$.createLogConfig$default$14();
        int x$63 = LogTest$.MODULE$.createLogConfig$default$15();
        long x$64 = LogTest$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTest$.MODULE$.createLogConfig(x$50, x$49, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64);
        TierPartitionState tierPartitionState2 = this.createTierPartitionState(this.topicIdPartition());
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig)).thenReturn((Object)tierPartitionState2);
        File x$65 = this.logDir();
        LogConfig x$66 = logConfig;
        BrokerTopicStats x$67 = this.brokerTopicStats();
        MockScheduler x$68 = this.mockTime().scheduler();
        MockTime x$69 = this.mockTime();
        Some x$70 = new Some((Object)this.tierLogComponents());
        long x$71 = LogTest$.MODULE$.createLog$default$6();
        long x$72 = LogTest$.MODULE$.createLog$default$7();
        int x$73 = LogTest$.MODULE$.createLog$default$8();
        int x$74 = LogTest$.MODULE$.createLog$default$9();
        AbstractLog log2 = LogTest$.MODULE$.createLog(x$65, x$66, x$67, x$68, (Time)x$69, x$71, x$72, x$73, x$74, (Option<TierLogComponents>)x$70);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), log2);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.becomeArchiver(this.topicIdPartition(), leaderEpoch);
        long pid1 = 1L;
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this, log2, pid1, lastOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchiveTaskIntegrationTest $outer;
            private final AbstractLog log$1;
            private final long pid1$1;
            private final LongRef lastOffset$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Seq x$75 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(this.$outer.mockTime().milliseconds(), new byte[128])}));
                long x$76 = this.pid1$1;
                short x$77 = 0;
                int x$78 = i;
                byte x$79 = TestUtils$.MODULE$.records$default$2();
                CompressionType x$80 = TestUtils$.MODULE$.records$default$3();
                long x$81 = TestUtils$.MODULE$.records$default$7();
                int x$82 = TestUtils$.MODULE$.records$default$8();
                LogAppendInfo appendInfo = this.log$1.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$75, x$79, x$80, x$76, x$77, x$78, x$81, x$82), 0, this.log$1.appendAsLeader$default$3(), this.log$1.appendAsLeader$default$4());
                this.lastOffset$1.elem = appendInfo.lastOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
                this.pid1$1 = pid1$1;
                this.lastOffset$1 = lastOffset$1;
            }
        });
        log2.updateHighWatermark(lastOffset.elem);
        Assert.assertEquals((String)"expected 5 local log segments", (long)5L, (long)log2.localLogSegments().size());
        Assert.assertEquals((String)"expected 4 tierable segments", (long)4L, (long)log2.tierableLogSegments().size());
        List baseOffsets = ((TraversableOnce)log2.localLogSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$1) {
                return x$1.baseOffset();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        List snapshotFiles = (List)baseOffsets.flatMap((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$1;

            public final Iterable<File> apply(long x$2) {
                return Option$.MODULE$.option2Iterable(this.log$1.producerStateManager().snapshotFileForOffset(x$2));
            }
            {
                this.log$1 = log$1;
            }
        }, List$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"expected to be able to use segment base offset to get snapshot files for 4 segments", (long)4L, (long)snapshotFiles.size());
        ArchiveTask maybeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assert.assertEquals((String)"expected successful transition to Upload", Upload.class, maybeUpload.state().getClass());
        ArchiveTask maybeAfterUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assert.assertEquals((String)"expected successful transition to afterUpload", AfterUpload.class, maybeAfterUpload.state().getClass());
        ConcurrentHashMap objectCounts = tierObjectStore.getObjectCounts();
        Assert.assertEquals((String)"expected 1 segment file", (Object)BoxesRunTime.boxToInteger((int)1), objectCounts.get(TierObjectStore.FileType.SEGMENT));
        Assert.assertEquals((String)"expected 1 producer state", (Object)BoxesRunTime.boxToInteger((int)1), objectCounts.get(TierObjectStore.FileType.PRODUCER_STATE));
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)maybeAfterUpload.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, maybeAfterUpload.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assert.assertTrue((String)"expected successful transition to beforeUpload", (boolean)(maybeBeforeUpload.state() instanceof BeforeUpload));
        Assert.assertEquals((String)"expected 1 segment to be materialized", (long)tierPartitionState2.numSegments(), (long)1L);
        TierObjectMetadata metadata = (TierObjectMetadata)tierPartitionState2.metadata(0L).get();
        Assert.assertTrue((String)"expected hasProducerState metadata flag to be set", (boolean)metadata.hasProducerState());
    }

    @Test
    public void testArchiverRetriesOnConcurrentDeleteRecords() {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore(new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        int leaderEpoch = 0;
        int x$83 = 1024;
        long x$84 = LogTest$.MODULE$.createLogConfig$default$1();
        long x$85 = LogTest$.MODULE$.createLogConfig$default$3();
        long x$86 = LogTest$.MODULE$.createLogConfig$default$4();
        long x$87 = LogTest$.MODULE$.createLogConfig$default$5();
        String x$88 = LogTest$.MODULE$.createLogConfig$default$6();
        int x$89 = LogTest$.MODULE$.createLogConfig$default$7();
        int x$90 = LogTest$.MODULE$.createLogConfig$default$8();
        int x$91 = LogTest$.MODULE$.createLogConfig$default$9();
        String x$92 = LogTest$.MODULE$.createLogConfig$default$10();
        long x$93 = LogTest$.MODULE$.createLogConfig$default$11();
        boolean x$94 = LogTest$.MODULE$.createLogConfig$default$12();
        long x$95 = LogTest$.MODULE$.createLogConfig$default$13();
        long x$96 = LogTest$.MODULE$.createLogConfig$default$14();
        int x$97 = LogTest$.MODULE$.createLogConfig$default$15();
        long x$98 = LogTest$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTest$.MODULE$.createLogConfig(x$84, x$83, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$95, x$96, x$97, x$98);
        TierPartitionState tierPartitionState2 = this.createTierPartitionState(this.topicIdPartition());
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig)).thenReturn((Object)tierPartitionState2);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$99 = this.logDir();
        LogConfig x$100 = logConfig;
        BrokerTopicStats x$101 = this.brokerTopicStats();
        MockScheduler x$102 = this.mockTime().scheduler();
        MockTime x$103 = this.mockTime();
        Some x$104 = new Some((Object)this.tierLogComponents());
        long x$105 = LogTest$.MODULE$.createLog$default$6();
        long x$106 = LogTest$.MODULE$.createLog$default$7();
        int x$107 = LogTest$.MODULE$.createLog$default$8();
        int x$108 = LogTest$.MODULE$.createLog$default$9();
        AbstractLog log2 = LogTest$.MODULE$.createLog(x$99, x$100, x$101, x$102, (Time)x$103, x$105, x$106, x$107, x$108, (Option<TierLogComponents>)x$104);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), log2);
        long pid1 = 1L;
        tierTopicManager.becomeArchiver(this.topicIdPartition(), leaderEpoch);
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this, log2, pid1, lastOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchiveTaskIntegrationTest $outer;
            private final AbstractLog log$2;
            private final long pid1$2;
            private final LongRef lastOffset$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Seq x$109 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(this.$outer.mockTime().milliseconds(), new byte[128])}));
                long x$110 = this.pid1$2;
                short x$111 = 0;
                int x$112 = i;
                byte x$113 = TestUtils$.MODULE$.records$default$2();
                CompressionType x$114 = TestUtils$.MODULE$.records$default$3();
                long x$115 = TestUtils$.MODULE$.records$default$7();
                int x$116 = TestUtils$.MODULE$.records$default$8();
                LogAppendInfo appendInfo = this.log$2.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$109, x$113, x$114, x$110, x$111, x$112, x$115, x$116), 0, this.log$2.appendAsLeader$default$3(), this.log$2.appendAsLeader$default$4());
                this.lastOffset$2.elem = appendInfo.lastOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.pid1$2 = pid1$2;
                this.lastOffset$2 = lastOffset$2;
            }
        });
        log2.updateHighWatermark(lastOffset.elem);
        Assert.assertEquals((long)5L, (long)log2.localLogSegments().size());
        Assert.assertEquals((long)4L, (long)log2.tierableLogSegments().size());
        ArchiveTask maybeUpload_1 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        File segmentFileBeingUploaded = ((Upload)maybeUpload_1.state()).uploadableSegment().logSegmentFile();
        Assert.assertEquals(Upload.class, maybeUpload_1.state().getClass());
        Assert.assertEquals((Object)segmentFileBeingUploaded, (Object)((LogSegment)log2.localLogSegments().head()).log().file());
        LogSegment newFirstSegment = (LogSegment)log2.localLogSegments().toList().apply(3);
        File newFirstSegmentFile = newFirstSegment.log().file();
        log2.maybeIncrementLogStartOffset(newFirstSegment.baseOffset() + 3L);
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assert.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        ArchiveTask maybeUpload_2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assert.assertEquals(Upload.class, maybeUpload_2.state().getClass());
        Assert.assertEquals((Object)newFirstSegmentFile, (Object)((Upload)maybeUpload_2.state()).uploadableSegment().logSegmentFile());
    }

    @Test
    public void testArchiverExceptionOnPartitionDeletion() {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore(new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        int leaderEpoch = 0;
        int x$117 = 1024;
        long x$118 = LogTest$.MODULE$.createLogConfig$default$1();
        long x$119 = LogTest$.MODULE$.createLogConfig$default$3();
        long x$120 = LogTest$.MODULE$.createLogConfig$default$4();
        long x$121 = LogTest$.MODULE$.createLogConfig$default$5();
        String x$122 = LogTest$.MODULE$.createLogConfig$default$6();
        int x$123 = LogTest$.MODULE$.createLogConfig$default$7();
        int x$124 = LogTest$.MODULE$.createLogConfig$default$8();
        int x$125 = LogTest$.MODULE$.createLogConfig$default$9();
        String x$126 = LogTest$.MODULE$.createLogConfig$default$10();
        long x$127 = LogTest$.MODULE$.createLogConfig$default$11();
        boolean x$128 = LogTest$.MODULE$.createLogConfig$default$12();
        long x$129 = LogTest$.MODULE$.createLogConfig$default$13();
        long x$130 = LogTest$.MODULE$.createLogConfig$default$14();
        int x$131 = LogTest$.MODULE$.createLogConfig$default$15();
        long x$132 = LogTest$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTest$.MODULE$.createLogConfig(x$118, x$117, x$119, x$120, x$121, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132);
        TierPartitionState tierPartitionState2 = this.createTierPartitionState(this.topicIdPartition());
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig)).thenReturn((Object)tierPartitionState2);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$133 = this.logDir();
        LogConfig x$134 = logConfig;
        BrokerTopicStats x$135 = this.brokerTopicStats();
        MockScheduler x$136 = this.mockTime().scheduler();
        MockTime x$137 = this.mockTime();
        Some x$138 = new Some((Object)this.tierLogComponents());
        long x$139 = LogTest$.MODULE$.createLog$default$6();
        long x$140 = LogTest$.MODULE$.createLog$default$7();
        int x$141 = LogTest$.MODULE$.createLog$default$8();
        int x$142 = LogTest$.MODULE$.createLog$default$9();
        AbstractLog log2 = LogTest$.MODULE$.createLog(x$133, x$134, x$135, x$136, (Time)x$137, x$139, x$140, x$141, x$142, (Option<TierLogComponents>)x$138);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), log2);
        long pid1 = 1L;
        tierTopicManager.becomeArchiver(this.topicIdPartition(), leaderEpoch);
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)new Serializable(this, log2, pid1, lastOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchiveTaskIntegrationTest $outer;
            private final AbstractLog log$3;
            private final long pid1$3;
            private final LongRef lastOffset$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Seq x$143 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(this.$outer.mockTime().milliseconds(), new byte[128])}));
                long x$144 = this.pid1$3;
                short x$145 = 0;
                int x$146 = i;
                byte x$147 = TestUtils$.MODULE$.records$default$2();
                CompressionType x$148 = TestUtils$.MODULE$.records$default$3();
                long x$149 = TestUtils$.MODULE$.records$default$7();
                int x$150 = TestUtils$.MODULE$.records$default$8();
                LogAppendInfo appendInfo = this.log$3.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$143, x$147, x$148, x$144, x$145, x$146, x$149, x$150), 0, this.log$3.appendAsLeader$default$3(), this.log$3.appendAsLeader$default$4());
                this.lastOffset$3.elem = appendInfo.lastOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$3 = log$3;
                this.pid1$3 = pid1$3;
                this.lastOffset$3 = lastOffset$3;
            }
        });
        log2.updateHighWatermark(lastOffset.elem);
        Assert.assertEquals((long)5L, (long)log2.localLogSegments().size());
        Assert.assertEquals((long)4L, (long)log2.tierableLogSegments().size());
        log2.renameDir(Log$.MODULE$.logDeleteDirName(this.topicIdPartition().topicPartition()));
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assert.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        Predef$.MODULE$.assert(ctx.isCancelled());
        tierPartitionState2.delete();
    }

    public class MockTierTopicManager
    implements TierTopicAppender {
        public CompletableFuture<TierPartitionState.AppendResult> becomeArchiver(TopicIdPartition topicPartition, int tierEpoch) {
            TierPartitionState tierPartitionState2 = this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().tierPartitionStates().get(topicPartition);
            TierTopicInitLeader becomeLeaderMessage = new TierTopicInitLeader(topicPartition, tierEpoch, UUID.randomUUID(), 0);
            return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(Future$.MODULE$.successful((Object)tierPartitionState2.append((AbstractTierMetadata)becomeLeaderMessage, 0L)))).toCompletableFuture();
        }

        public CompletableFuture<TierPartitionState.AppendResult> addMetadata(AbstractTierMetadata entry) {
            TierPartitionState tierPartitionState2 = this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().tierPartitionStates().get(this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().topicIdPartition());
            return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(Future$.MODULE$.successful((Object)tierPartitionState2.append(entry, 0L)))).toCompletableFuture();
        }

        public boolean isReady() {
            return true;
        }

        public /* synthetic */ ArchiveTaskIntegrationTest kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer() {
            return ArchiveTaskIntegrationTest.this;
        }

        public MockTierTopicManager() {
            if (ArchiveTaskIntegrationTest.this == null) {
                throw null;
            }
        }
    }
}

