/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.OffsetIndex;
import kafka.log.ProducerStateManager;
import kafka.log.TimeIndex;
import kafka.log.UploadableSegment;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ReplicaManager;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u0001-\u0011q\"\u0011:dQ&4X\rV1tWR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq!\u0019:dQ&4XM\u0003\u0002\u0006\r\u0005)A/Y:lg*\u0011q\u0001C\u0001\u0005i&,'OC\u0001\n\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111CF\u0007\u0002))\u0011Q\u0003C\u0001\b[\u0016$(/[2t\u0013\t9BCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0001?\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0002AA\u0011\u0011EI\u0007\u0002\r%\u00111E\u0002\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:Da!\n\u0001!\u0002\u0013\u0001\u0013!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA!9q\u0005\u0001a\u0001\n\u0003A\u0013aA2uqV\t\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-\r\u00059a-\u001a;dQ\u0016\u0014\u0018B\u0001\u0018,\u0005M\u0019\u0015M\\2fY2\fG/[8o\u0007>tG/\u001a=u\u0011\u001d\u0001\u0004\u00011A\u0005\u0002E\nqa\u0019;y?\u0012*\u0017\u000f\u0006\u00023kA\u0011QbM\u0005\u0003i9\u0011A!\u00168ji\"9agLA\u0001\u0002\u0004I\u0013a\u0001=%c!1\u0001\b\u0001Q!\n%\nAa\u0019;yA!9!\b\u0001a\u0001\n\u0003Y\u0014\u0001\u0005;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s+\u0005a\u0004CA\u001fA\u001b\u0005q$BA \u0007\u0003\u0015!x\u000e]5d\u0013\t\teH\u0001\tUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\"91\t\u0001a\u0001\n\u0003!\u0015\u0001\u0006;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u00023\u000b\"9aGQA\u0001\u0002\u0004a\u0004BB$\u0001A\u0003&A(A\tuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u0002Bq!\u0013\u0001A\u0002\u0013\u0005!*A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(\u0007\u0003\u0015\u0019Ho\u001c:f\u0013\t\u0001VJA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0011\u001d\u0011\u0006\u00011A\u0005\u0002M\u000b1\u0003^5fe>\u0013'.Z2u'R|'/Z0%KF$\"A\r+\t\u000fY\n\u0016\u0011!a\u0001\u0017\"1a\u000b\u0001Q!\n-\u000b\u0001\u0003^5fe>\u0013'.Z2u'R|'/\u001a\u0011\t\u000fa\u0003\u0001\u0019!C\u00013\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005uC\u0011AB:feZ,'/\u0003\u0002`9\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bbB1\u0001\u0001\u0004%\tAY\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u00023G\"9a\u0007YA\u0001\u0002\u0004Q\u0006BB3\u0001A\u0003&!,A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0011\u001d9\u0007\u00011A\u0005\u0002!\fA\u0001^5nKV\t\u0011\u000e\u0005\u0002ki6\t1N\u0003\u0002m[\u0006)Q\u000f^5mg*\u0011an\\\u0001\u0007G>lWn\u001c8\u000b\u0005%\u0001(BA9s\u0003\u0019\t\u0007/Y2iK*\t1/A\u0002pe\u001eL!!^6\u0003\tQKW.\u001a\u0005\bo\u0002\u0001\r\u0011\"\u0001y\u0003!!\u0018.\\3`I\u0015\fHC\u0001\u001az\u0011\u001d1d/!AA\u0002%Daa\u001f\u0001!B\u0013I\u0017!\u0002;j[\u0016\u0004\u0003bB?\u0001\u0005\u0004%\tA`\u0001\bi6\u0004h)\u001b7f+\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0003S>T!!!\u0003\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\t\u0019A\u0001\u0003GS2,\u0007bBA\t\u0001\u0001\u0006Ia`\u0001\ti6\u0004h)\u001b7fA!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011\u0001\u0003;fCJ$un\u001e8\u0015\u0003IBC!a\u0005\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"I\fQA[;oSRLA!!\n\u0002 \t)\u0011I\u001a;fe\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005]\u0011A\u0007;fgR,5\u000f^1cY&\u001c\b.\u001b8h\u0019\u0016\fG-\u001a:tQ&\u0004\b\u0006BA\u0014\u0003[\u0001B!!\b\u00020%!\u0011\u0011GA\u0010\u0005\u0011!Vm\u001d;\t\u000f\u0005U\u0002\u0001\"\u0001\u0002\u0018\u0005YB/Z:u)&,'oU3h[\u0016tG/\u00138wC2LG-\u00129pG\"DC!a\r\u0002.!9\u00111\b\u0001\u0005\u0002\u0005]\u0011\u0001\b;fgRlU\r^1eCR\f7+\u001b>f\tV\u0014\u0018N\\4Va2|\u0017\r\u001a\u0015\u0005\u0003s\ti\u0003C\u0004\u0002B\u0001!\t!a\u0006\u00027Q,7\u000f^'fi\u0006$\u0017\r^1TSj,\u0017I\u001a;feV\u0003Hn\\1eQ\u0011\ty$!\f\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002\u0018\u0005\tC/Z:u\u000bb\u001cW\r\u001d;j_:$UO]5oO&s\u0017\u000e^5bi\u0016,\u0006\u000f\\8bI\"\"\u0011QIA\u0017\u0011\u001d\ti\u0005\u0001C\u0001\u0003/\ta\u0004^3tiN+w-\\3oi\u0012+G.\u001a;fI\u0012+(/\u001b8h+Bdw.\u00193)\t\u0005-\u0013Q\u0006\u0005\b\u0003'\u0002A\u0011AA\f\u0003\u0001\"Xm\u001d;V].twn\u001e8Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h+Bdw.\u00193)\t\u0005E\u0013Q\u0006\u0005\b\u00033\u0002A\u0011AA\f\u0003e!Xm\u001d;US\u0016\u00148+Z4nK:$hj\\*fO6,g\u000e^:)\t\u0005]\u0013Q\u0006\u0005\b\u0003?\u0002A\u0011AA\f\u0003\u0019\"Xm\u001d;US\u0016\u00148+Z4nK:$x+\u001b;i_V$H*Z1eKJ,\u0005o\\2i'R\fG/\u001a\u0015\u0005\u0003;\ni\u0003C\u0004\u0002f\u0001!\t!a\u0006\u0002GQ,7\u000f\u001e+jKJ\u001cVmZ7f]R<\u0016\u000e\u001e5MK\u0006$WM]#q_\u000eD7\u000b^1uK\"\"\u00111MA\u0017\u0011\u001d\tY\u0007\u0001C\u0001\u0003/\t\u0001\u0005^3ti\u0006\u00138\r[5wKJ$\u0016m]6TKR\u001c\b+Y;tK>s'+\u001a;ss\"\"\u0011\u0011NA\u0017\u0011\u001d\t\t\b\u0001C\u0001\u0003/\tq\u0005^3ti\u000e\u000bgnY3mY\u0016$\u0017I]2iSZ,G+Y:l\t>,7OT8u!J|wM]3tg\"\"\u0011qNA\u0017\u0011\u001d\t9\b\u0001C\u0001\u0003/\t\u0011\u0005^3ti\"\u000bg\u000e\u001a7f'\u0016<W.\u001a8u\t\u0016dW\r^3e\u000bb\u001cW\r\u001d;j_:DC!!\u001e\u0002.!9\u0011Q\u0010\u0001\u0005\u0002\u0005]\u0011A\u000e;fgRD\u0015M\u001c3mS:<gi\u001c:TK\u001elWM\u001c;EK2,G/\u001a3Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h)J\fgn]5uS>t\u0007\u0006BA>\u0003[Aq!a!\u0001\t\u0013\t))A\u0015uKN$X\t_2faRLwN\u001c%b]\u0012d\u0017N\\4EkJLgnZ%oSRL\u0017\r^3Va2|\u0017\r\u001a\u000b\u0005\u0003\u000f\u000bI\n\u0005\u0004\u0002\n\u0006=\u00151S\u0007\u0003\u0003\u0017S1!!$\u000f\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003#\u000bYI\u0001\u0004GkR,(/\u001a\t\u00049\u0005U\u0015bAAL\u0005\t\u0001\u0012I]2iSZ,G+Y:l'R\fG/\u001a\u0005\t\u00037\u000b\t\t1\u0001\u0002\u001e\u0006\tQ\r\u0005\u0003\u0002 \u0006=f\u0002BAQ\u0003WsA!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003OS\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\r\tiKD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t,a-\u0003\u0013\u0015C8-\u001a9uS>t'bAAW\u001d!9\u0011q\u0017\u0001\u0005\n\u0005e\u0016!\t;fgR,\u0005pY3qi&|g\u000eS1oI2Lgn\u001a#ve&tw-\u00169m_\u0006$GCBAD\u0003w\u000bi\f\u0003\u0005\u0002\u001c\u0006U\u0006\u0019AAO\u0011!\ty,!.A\u0002\u0005\u0005\u0017!\u00043fY\u0016$XmU3h[\u0016tG\u000fE\u0002\u000e\u0003\u0007L1!!2\u000f\u0005\u001d\u0011un\u001c7fC:Dq!!3\u0001\t\u0013\tY-\u0001\bn_\u000e\\Gj\\4TK\u001elWM\u001c;\u0015\t\u00055\u0017\u0011\u001c\t\u0005\u0003\u001f\f).\u0004\u0002\u0002R*\u0019\u00111\u001b\u0005\u0002\u00071|w-\u0003\u0003\u0002X\u0006E'A\u0003'pON+w-\\3oi\"1Q0a2A\u0002}Dq!!8\u0001\t\u0013\ty.\u0001\fn_\u000e\\G+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\u0011\t\t/!<\u0011\t\u0005\r\u0018\u0011^\u0007\u0003\u0003KT1!a:\u0007\u0003\u0015\u0019H/\u0019;f\u0013\u0011\tY/!:\u0003%QKWM\u001d)beRLG/[8o'R\fG/\u001a\u0005\t\u0003_\fY\u000e1\u0001\u0002r\u0006YA.Z1eKJ,\u0005o\\2i!\ri\u00111_\u0005\u0004\u0003kt!aA%oi\"9\u0011\u0011 \u0001\u0005\n\u0005m\u0018aD7pG.\f%m\u001d;sC\u000e$Hj\\4\u0015\t\u0005u(1\u0001\t\u0005\u0003\u001f\fy0\u0003\u0003\u0003\u0002\u0005E'aC!cgR\u0014\u0018m\u0019;M_\u001eD\u0001B!\u0002\u0002x\u0002\u0007\u0011QZ\u0001\u000bY><7+Z4nK:$\bb\u0002B\u0005\u0001\u0011%!1B\u0001\fi&,'oU3h[\u0016tG\u000f\u0006\u0004\u0003\u000e\te!1\u0004\t\u0005\u0005\u001f\u0011)\"\u0004\u0002\u0003\u0012)\u0019!1\u0003\u0004\u0002\r\u0011|W.Y5o\u0013\u0011\u00119B!\u0005\u0003%QKWM](cU\u0016\u001cG/T3uC\u0012\fG/\u0019\u0005\t\u0003'\u00149\u00011\u0001\u0002~\"A\u0011q\u001eB\u0004\u0001\u0004\t\t\u0010")
public class ArchiveTaskTest
implements KafkaMetricsGroup {
    private final TopicIdPartition topicIdPartition;
    private CancellationContext ctx;
    private TierTopicManager tierTopicManager;
    private TierObjectStore tierObjectStore;
    private ReplicaManager replicaManager;
    private Time time;
    private final File tmpFile;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.class.metricName((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.class.explicitMetricName((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.class.newGauge((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.class.newMeter((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.class.newHistogram((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.class.newTimer((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.class.removeMetric((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.class.removeMetric$default$2((KafkaMetricsGroup)this);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.class.newGauge$default$3((KafkaMetricsGroup)this);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.class.newTimer$default$4((KafkaMetricsGroup)this);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.class.newHistogram$default$2((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.class.newHistogram$default$3((KafkaMetricsGroup)this);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.class.newMeter$default$4((KafkaMetricsGroup)this);
    }

    private Logger logger$lzycompute() {
        ArchiveTaskTest archiveTaskTest = this;
        synchronized (archiveTaskTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(TierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public File tmpFile() {
        return this.tmpFile;
    }

    @After
    public void tearDown() {
        this.tmpFile().delete();
        this.ctx().cancel();
        Mockito.reset((Object[])new Object[]{this.tierTopicManager(), this.tierObjectStore(), this.replicaManager()});
    }

    @Test
    public void testEstablishingLeadership() {
        int leaderEpoch = 0;
        Mockito.when((Object)this.tierTopicManager().becomeArchiver(this.topicIdPartition(), leaderEpoch)).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        BeforeUpload nextState = (BeforeUpload)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).millis());
        Assert.assertEquals((String)"Expected task to establish leadership", (Object)new BeforeUpload(leaderEpoch), (Object)nextState);
        Mockito.when((Object)this.tierTopicManager().becomeArchiver(this.topicIdPartition(), leaderEpoch)).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.NOT_TIERABLE));
        Future illegal = (Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).millis());
        Assert.assertTrue((String)"Expected establishing leadership to fail", (boolean)((Try)illegal.value().get()).isFailure());
        Mockito.when((Object)this.tierTopicManager().becomeArchiver(this.topicIdPartition(), leaderEpoch)).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Future fenced = (Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).millis());
        Assert.assertTrue((String)"Expected establishing leadership to fail", (boolean)((Try)fenced.value().get()).isFailure());
        Mockito.when((Object)this.tierTopicManager().becomeArchiver(this.topicIdPartition(), leaderEpoch)).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed(new Object()));
        Future unknown = (Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).millis());
        Assert.assertTrue((String)"Expected establishing leadership to fail", (boolean)((Try)unknown.value().get()).isFailure());
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)4))).becomeArchiver(this.topicIdPartition(), leaderEpoch);
    }

    @Test
    public void testTierSegmentInvalidEpoch() {
        int leaderEpoch = 0;
        TierPartitionState tps = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch + 1))).getMock();
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log2 = this.mockAbstractLog(logSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log2));
        Mockito.when((Object)log2.tierPartitionState()).thenReturn((Object)tps);
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Assert.assertTrue((String)"Expected segment tiering to fail due to fencing", (boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)nextState, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).millis())).value().get()).isFailure());
    }

    @Test
    public void testMetadataSizeDuringUpload() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log2 = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.size(), true, true, true);
        long epochStateSize = 1000000000L;
        long producerStateSize = 2000000000L;
        int abortedTxnsLimit = 150;
        int abortedTxnsPos = 50;
        long expectedSize = (long)logSegment.size() + epochStateSize + producerStateSize + (long)(abortedTxnsLimit - abortedTxnsPos);
        File epochState = (File)Mockito.mock(File.class);
        File producerState = (File)Mockito.mock(File.class);
        ByteBuffer abortedTxns = ByteBuffer.wrap(new byte[abortedTxnsLimit]);
        abortedTxns.limit(abortedTxnsLimit);
        abortedTxns.position(abortedTxnsPos);
        Some epochStateOpt = new Some((Object)epochState);
        Some producerStateOpt = new Some((Object)producerState);
        Some abortedTxnsOpt = new Some((Object)abortedTxns);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)epochState.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)producerState.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)epochState.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)epochStateSize));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)producerState.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)producerStateSize));
        ((TierObjectStore)Mockito.doNothing().when((Object)this.tierObjectStore())).putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        UploadableSegment uploadableSegment = new UploadableSegment(log2, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.tierObjectStore(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assert.assertEquals((String)"metadata size of AfterUpload object is incorrect value", (long)expectedSize, (long)afterUpload.uploadedSize());
        Assert.assertTrue((String)"metadata size of AfterUpload object is negative and overflowed", (afterUpload.uploadedSize() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMetadataSizeAfterUpload() {
        int testUploadSize = 400;
        String metricName = "BytesPerSec";
        this.removeMetric(metricName, this.removeMetric$default$2());
        Meter byteRate = this.newMeter(metricName, "bytes per second", TimeUnit.SECONDS, this.newMeter$default$4());
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.size(), true, true, true);
        AfterUpload afterUpload = new AfterUpload(0, uploadInitiate, (long)testUploadSize);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)new Some((Object)byteRate), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assert.assertEquals((String)"tier archiver mean rate shows no data uploaded to tiered storage", (long)testUploadSize, (long)byteRate.count());
    }

    @Test
    public void testExceptionDuringInitiateUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringInitiateUpload(new IllegalStateException("illegal state"));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, nextState){
            public static final long serialVersionUID = 0L;
            private final Future nextState$1;

            public final ArchiveTaskState apply() {
                return (ArchiveTaskState)Await$.MODULE$.result((Awaitable)this.nextState$1, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
            }
            {
                this.nextState$1 = nextState$1;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
    }

    @Test
    public void testSegmentDeletedDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new NoSuchFileException("segment deleted"), true);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, nextState){
            public static final long serialVersionUID = 0L;
            private final Future nextState$2;

            public final ArchiveTaskState apply() {
                return (ArchiveTaskState)Await$.MODULE$.result((Awaitable)this.nextState$2, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
            }
            {
                this.nextState$2 = nextState$2;
            }
        }, ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
    }

    @Test
    public void testUnknownExceptionDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new IllegalStateException("illegal state"), false);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, nextState){
            public static final long serialVersionUID = 0L;
            private final Future nextState$3;

            public final ArchiveTaskState apply() {
                return (ArchiveTaskState)Await$.MODULE$.result((Awaitable)this.nextState$3, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
            }
            {
                this.nextState$3 = nextState$3;
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
    }

    @Test
    public void testTierSegmentNoSegments() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState2 = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
        AbstractLog emptyLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)emptyLog.tierableLogSegments()).thenReturn(JavaConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala()).getMock();
        Mockito.when((Object)emptyLog.tierPartitionState()).thenReturn((Object)tierPartitionState2);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)emptyLog));
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTaskState result = (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).millis());
        Assert.assertTrue((String)"Expected segment tiering to complete successfully, but not progress to AfterUpload", (boolean)(result instanceof BeforeUpload));
    }

    @Test
    public void testTierSegmentWithoutLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState2 = this.mockTierPartitionState(leaderEpoch);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)None$.MODULE$);
        AbstractLog log2 = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log2.tierPartitionState()).thenReturn((Object)tierPartitionState2);
        Mockito.when((Object)log2.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log2.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)log2.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)Nil$.MODULE$);
        UploadableSegment uploadableSegment = new UploadableSegment(log2, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log2.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log2));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        TierObjectMetadata metadata = this.tierSegment(log2, leaderEpoch);
        Assert.assertEquals((String)"expected start offset to be 0", (long)metadata.baseOffset(), (long)0L);
        Assert.assertEquals((String)"expected end offset to be 9", (long)metadata.endOffset(), (long)9L);
    }

    @Test
    public void testTierSegmentWithLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState2 = this.mockTierPartitionState(leaderEpoch);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        LeaderEpochFileCache mockLeaderEpochCache = (LeaderEpochFileCache)Mockito.mock(LeaderEpochFileCache.class);
        Mockito.when((Object)mockLeaderEpochCache.clone((LeaderEpochCheckpoint)ArgumentMatchers.any())).thenReturn((Object)mockLeaderEpochCache);
        Mockito.when((Object)mockLeaderEpochCache.file()).thenReturn((Object)this.tmpFile());
        long nextOffset = logSegment.readNextOffset();
        ((LeaderEpochFileCache)Mockito.doNothing().when((Object)mockLeaderEpochCache)).truncateFromEnd(nextOffset);
        AbstractLog log2 = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log2.tierPartitionState()).thenReturn((Object)tierPartitionState2);
        Mockito.when((Object)log2.leaderEpochCache()).thenReturn((Object)new Some((Object)mockLeaderEpochCache));
        Mockito.when((Object)log2.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)Nil$.MODULE$);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log2.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log2));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        UploadableSegment uploadableSegment = new UploadableSegment(log2, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, Option$.MODULE$.apply((Object)mockLeaderEpochCache.file()), (Option)None$.MODULE$);
        Mockito.when((Object)log2.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        TierObjectMetadata metadata = this.tierSegment(log2, leaderEpoch);
        Assert.assertTrue((String)"expected metadata to claim to have epoch state", (boolean)metadata.hasEpochState());
        ((TierObjectStore)Mockito.verify((Object)this.tierObjectStore(), (VerificationMode)Mockito.times((int)1))).putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull());
    }

    @Test
    public void testArchiverTaskSetsPauseOnRetry() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        Mockito.when((Object)this.tierTopicManager().becomeArchiver(this.topicIdPartition(), 0)).thenThrow(new Throwable[]{new TierMetadataRetriableException("something"), new TierObjectStoreRetriableException("foo", (Throwable)new RuntimeException("foo"))});
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assert.assertTrue((String)"expected the task to be paused", (boolean)result.pausedUntil().isDefined());
        Assert.assertFalse((String)"expected the task to not be canceled", (boolean)this.ctx().isCancelled());
        Instant pauseTime = (Instant)result.pausedUntil().get();
        this.time().sleep(100L);
        ArchiveTask result2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assert.assertTrue((String)"expected the task to be paused", (boolean)result2.pausedUntil().isDefined());
        Assert.assertFalse((String)"expected the task to not be canceled", (boolean)this.ctx().isCancelled());
        Instant pauseTime2 = (Instant)result2.pausedUntil().get();
        Assert.assertTrue((String)"expected the second pause time to be larger than the first", (boolean)pauseTime2.isAfter(pauseTime));
    }

    @Test
    public void testCancelledArchiveTaskDoesNotProgress() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        this.ctx().cancel();
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assert.assertTrue((String)"expected task to remain in BeforeLeader", (boolean)(result.state() instanceof BeforeLeader));
    }

    @Test
    public void testHandleSegmentDeletedException() {
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        BeforeLeader beforeLeader = new BeforeLeader(0);
        BeforeUpload beforeUpload = new BeforeUpload(0);
        Upload upload = new Upload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), (UploadableSegment)Mockito.mock(UploadableSegment.class));
        AfterUpload afterUpload = new AfterUpload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), 0L);
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, exception, beforeLeader){
            public static final long serialVersionUID = 0L;
            private final ArchiveTask.SegmentDeletedException exception$1;
            private final BeforeLeader beforeLeader$1;

            public final ArchiveTaskState apply() {
                return this.beforeLeader$1.handleSegmentDeletedException(this.exception$1);
            }
            {
                this.exception$1 = exception$1;
                this.beforeLeader$1 = beforeLeader$1;
            }
        }, ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        Assert.assertEquals(BeforeUpload.class, beforeUpload.handleSegmentDeletedException(exception).getClass());
        Assert.assertEquals(BeforeUpload.class, upload.handleSegmentDeletedException(exception).getClass());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, exception, afterUpload){
            public static final long serialVersionUID = 0L;
            private final ArchiveTask.SegmentDeletedException exception$1;
            private final AfterUpload afterUpload$1;

            public final ArchiveTaskState apply() {
                return this.afterUpload$1.handleSegmentDeletedException(this.exception$1);
            }
            {
                this.exception$1 = exception$1;
                this.afterUpload$1 = afterUpload$1;
            }
        }, ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
    }

    @Test
    public void testHandlingForSegmentDeletedExceptionDuringTransition() {
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log2 = this.mockAbstractLog(logSegment);
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log2));
        Mockito.when((Object)log2.tierPartitionState()).thenThrow(new Throwable[]{exception});
        BeforeUpload beforeUpload = (BeforeUpload)Mockito.mock(BeforeUpload.class);
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)beforeUpload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        ((BeforeUpload)Mockito.verify((Object)beforeUpload, (VerificationMode)Mockito.times((int)1))).handleSegmentDeletedException(exception);
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringInitiateUpload(Exception e) {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState2 = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log2 = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log2.tierPartitionState()).thenReturn((Object)tierPartitionState2);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState2.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log2));
        Mockito.when((Object)log2.tierableLogSegments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment})));
        Mockito.when((Object)log2.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenThrow(new Throwable[]{e});
        Mockito.when((Object)log2.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log2.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log2.createUploadableSegment(logSegment)).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringUpload(Exception e, boolean deleteSegment) {
        BoxedUnit boxedUnit;
        int leaderEpoch = 0;
        File fileToUse = this.tmpFile();
        if (deleteSegment) {
            fileToUse = (File)Mockito.mock(File.class);
            boxedUnit = Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fileToUse.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LogSegment logSegment = this.mockLogSegment(fileToUse);
        AbstractLog log2 = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.size(), false, false, false);
        UploadableSegment uploadableSegment = new UploadableSegment(log2, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        this.tierObjectStore().putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.tierObjectStore(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    private LogSegment mockLogSegment(File tmpFile) {
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.mock(OffsetIndex.class);
        Mockito.when((Object)offsetIndex.file()).thenReturn((Object)tmpFile);
        TimeIndex timeIndex = (TimeIndex)Mockito.mock(TimeIndex.class);
        Mockito.when((Object)timeIndex.file()).thenReturn((Object)tmpFile);
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        Mockito.when((Object)fileRecords.file()).thenReturn((Object)tmpFile);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.readNextOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)10L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.baseOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.largestTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1000));
        Mockito.when((Object)logSegment.log()).thenReturn((Object)fileRecords);
        Mockito.when((Object)logSegment.offsetIndex()).thenReturn((Object)offsetIndex);
        Mockito.when((Object)logSegment.timeIndex()).thenReturn((Object)timeIndex);
        return logSegment;
    }

    private TierPartitionState mockTierPartitionState(int leaderEpoch) {
        return (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog mockAbstractLog(LogSegment logSegment) {
        void var2_2;
        AbstractLog log2 = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log2.tierableLogSegments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment})));
        return var2_2;
    }

    private TierObjectMetadata tierSegment(AbstractLog log2, int leaderEpoch) {
        Future beforeUploadResult = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Upload upload = (Upload)Await$.MODULE$.result((Awaitable)beforeUploadResult, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.tierObjectStore(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)None$.MODULE$, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        TierSegmentUploadInitiate uploadInitiate = upload.uploadInitiate();
        return new TierObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.tierEpoch(), uploadInitiate.objectId(), uploadInitiate.baseOffset(), uploadInitiate.endOffset(), uploadInitiate.maxTimestamp(), uploadInitiate.size(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, uploadInitiate.hasEpochState(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState());
    }

    public ArchiveTaskTest() {
        Logging.class.$init$((Logging)this);
        KafkaMetricsGroup.class.$init$((KafkaMetricsGroup)this);
        this.topicIdPartition = new TopicIdPartition("foo", UUID.fromString("cbf4eaed-cc00-47dc-b08c-f1f5685f085d"), 0);
        this.ctx = CancellationContext.newContext();
        this.tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        this.tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        this.replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.time = new MockTime();
        this.tmpFile = TestUtils$.MODULE$.tempFile();
    }
}

