/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.StopLeadership;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.tier.tasks.archive.ArchiverTaskQueueTest$;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001-\u0011Q#\u0011:dQ&4XM\u001d+bg.\fV/Z;f)\u0016\u001cHO\u0003\u0002\u0004\t\u00059\u0011M]2iSZ,'BA\u0003\u0007\u0003\u0015!\u0018m]6t\u0015\t9\u0001\"\u0001\u0003uS\u0016\u0014(\"A\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001b\u0002\r\u0001\u0005\u0004%I!G\u0001\u0004GRDX#\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0005u1\u0011a\u00024fi\u000eDWM]\u0005\u0003?q\u00111cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqRDa!\t\u0001!\u0002\u0013Q\u0012\u0001B2uq\u0002Bqa\t\u0001C\u0002\u0013%A%\u0001\u0003uS6,W#A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!B\u0011!B;uS2\u001c\u0018B\u0001\u0016(\u0005!iunY6US6,\u0007B\u0002\u0017\u0001A\u0003%Q%A\u0003uS6,\u0007\u0005C\u0004/\u0001\t\u0007I\u0011B\u0018\u0002\r1\fw-T1q+\u0005\u0001\u0004\u0003B\u00197qqj\u0011A\r\u0006\u0003gQ\nq!\\;uC\ndWM\u0003\u00026\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]\u0012$aA'baB\u0011\u0011HO\u0007\u0002\r%\u00111H\u0002\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042!D\u001f@\u0013\tqdB\u0001\u0004PaRLwN\u001c\t\u0003\u001b\u0001K!!\u0011\b\u0003\t1{gn\u001a\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u0019\u0002\u000f1\fw-T1qA!9Q\t\u0001b\u0001\n\u00131\u0015\u0001C7bqR\u000b7o[:\u0016\u0003\u001d\u0003\"!\u0004%\n\u0005%s!aA%oi\"11\n\u0001Q\u0001\n\u001d\u000b\u0011\"\\1y)\u0006\u001c8n\u001d\u0011\t\u000f5\u0003!\u0019!C\u0005\u001d\u0006\t\u0012M]2iSZ,'\u000fV1tWF+X-^3\u0016\u0003=\u0003\"A\u0006)\n\u0005E\u0013!!E!sG\"Lg/\u001a:UCN\\\u0017+^3vK\"11\u000b\u0001Q\u0001\n=\u000b!#\u0019:dQ&4XM\u001d+bg.\fV/Z;fA!)Q\u000b\u0001C\u0001-\u0006qA/Z:u%\u0016lwN^3UCN\\G#A,\u0011\u00055A\u0016BA-\u000f\u0005\u0011)f.\u001b;)\u0005Q[\u0006C\u0001/b\u001b\u0005i&B\u00010`\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0017aA8sO&\u0011!-\u0018\u0002\u0005)\u0016\u001cH\u000fC\u0003e\u0001\u0011\u0005a+\u0001\u000buKN$\bk\u001c7m)\u0006\u001c8n\u0014:eKJLgn\u001a\u0015\u0003GnCQa\u001a\u0001\u0005\u0002Y\u000b\u0001\u0004^3tiB{G\u000e\u001c+bg.\u001cH*Z:t)\"\fg.T1yQ\t17\fC\u0003k\u0001\u0011\u0005a+A\u0006uKN$(,\u001a:p\u0019\u0006<\u0007FA5\\\u0011\u0015i\u0007\u0001\"\u0001W\u0003m!Xm\u001d;BI\u0012\u0014V\r\u001d7bG\u0016\u001cX\t_5ti&tw\rV1tW\"\u0012An\u0017\u0005\u0006a\u0002!I!]\u0001\u0006Y\u0006<gI\u001c\u000b\u0003yIDQa]8A\u0002Q\fA\u0001^1tWB\u0011a#^\u0005\u0003m\n\u00111\"\u0011:dQ&4X\rV1tW\")\u0001\u0010\u0001C\u0005s\u0006IQ\u000f\u001d3bi\u0016d\u0015m\u001a\u000b\u0004/jd\b\"B>x\u0001\u0004A\u0014\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u0015ix\u000f1\u0001@\u0003\ra\u0017m\u001a\u0005\u0007\u007f\u0002!I!!\u0001\u0002-1\fwmU8si\u0016$W\t\\5hS\ndW\rV1tWN,\"!a\u0001\u0011\u000b\u0005\u0015\u0011Q\u0003\u001d\u000f\t\u0005\u001d\u0011\u0011\u0003\b\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\n\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\f\u00033\u0011A\u0001T5ti*\u0019\u00111\u0003\b\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 \u00059\u0011\r\u001a3UCN\\G#B,\u0002\"\u0005\r\u0002BB>\u0002\u001c\u0001\u0007\u0001\bC\u0004\u0002&\u0005m\u0001\u0019A$\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u0003S\u0001A\u0011BA\u0016\u0003)\u0011X-\\8wKR\u000b7o\u001b\u000b\u0004/\u00065\u0002BB>\u0002(\u0001\u0007\u0001\b")
public class ArchiverTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final MockTime time = new MockTime();
    private final Map<TopicIdPartition, Option<Object>> lagMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final int maxTasks;
    private final ArchiverTaskQueue archiverTaskQueue = new ArchiverTaskQueue(this.ctx(), this.maxTasks(), (Time)this.time(), (Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ ArchiverTaskQueueTest $outer;

        public final Option<Object> apply(ArchiveTask task) {
            return this.$outer.kafka$tier$tasks$archive$ArchiverTaskQueueTest$$lagFn(task);
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));

    private CancellationContext ctx() {
        return this.ctx;
    }

    private MockTime time() {
        return this.time;
    }

    private Map<TopicIdPartition, Option<Object>> lagMap() {
        return this.lagMap;
    }

    private int maxTasks() {
        return this.maxTasks;
    }

    private ArchiverTaskQueue archiverTaskQueue() {
        return this.archiverTaskQueue;
    }

    @Test
    public void testRemoveTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        this.removeTask(partition_1);
        this.archiverTaskQueue().withAllTasks((Function1)new Serializable(this, partition_2, partition_3, partition_4){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition partition_2$1;
            private final TopicIdPartition partition_3$1;
            private final TopicIdPartition partition_4$1;

            public final void apply(Set<ArchiveTask> tasks) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.partition_2$1, this.partition_3$1, this.partition_4$1})), (Object)tasks.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicIdPartition apply(ArchiveTask x$1) {
                        return x$1.topicIdPartition();
                    }
                }, Set$.MODULE$.canBuildFrom()));
            }
            {
                this.partition_2$1 = partition_2$1;
                this.partition_3$1 = partition_3$1;
                this.partition_4$1 = partition_4$1;
            }
        });
        this.removeTask(partition_3);
        this.archiverTaskQueue().withAllTasks((Function1)new Serializable(this, partition_2, partition_4){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition partition_2$1;
            private final TopicIdPartition partition_4$1;

            public final void apply(Set<ArchiveTask> tasks) {
                Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.partition_2$1, this.partition_4$1})), (Object)tasks.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicIdPartition apply(ArchiveTask x$2) {
                        return x$2.topicIdPartition();
                    }
                }, Set$.MODULE$.canBuildFrom()));
            }
            {
                this.partition_2$1 = partition_2$1;
                this.partition_4$1 = partition_4$1;
            }
        });
    }

    @Test
    public void testPollTaskOrdering() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 5L);
        this.updateLag(partition_2, 10L);
        this.updateLag(partition_3, 1L);
        this.updateLag(partition_4, 15L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        List tasks = (List)this.archiverTaskQueue().poll().get();
        Assert.assertEquals((Object)this.lagSortedEligibleTasks().take(this.maxTasks()), (Object)((List)tasks.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicIdPartition apply(ArchiveTask x$3) {
                return x$3.topicIdPartition();
            }
        }, List$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testPollTasksLessThanMax() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 5L);
        this.updateLag(partition_2, 0L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_1})), (Object)((TraversableOnce)((List)this.archiverTaskQueue().poll().get()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicIdPartition apply(ArchiveTask x$4) {
                return x$4.topicIdPartition();
            }
        }, List$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testZeroLag() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 0L);
        this.updateLag(partition_2, 0L);
        this.updateLag(partition_3, 0L);
        this.updateLag(partition_4, 0L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.archiverTaskQueue().poll());
    }

    @Test
    public void testAddReplacesExistingTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        this.addTask(partition_1, 1);
        this.addTask(partition_3, 2);
        this.archiverTaskQueue().withAllTasks((Function1)new Serializable(this, partition_1, partition_2, partition_3, partition_4){
            public static final long serialVersionUID = 0L;
            public final TopicIdPartition partition_1$1;
            public final TopicIdPartition partition_2$2;
            public final TopicIdPartition partition_3$2;
            public final TopicIdPartition partition_4$2;

            public final void apply(Set<ArchiveTask> tasks) {
                Assert.assertEquals((long)1L, (long)((ArchiveTask)tasks.find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAddReplacesExistingTask$1 $outer;

                    public final boolean apply(ArchiveTask x$5) {
                        TopicIdPartition topicIdPartition = x$5.topicIdPartition();
                        TopicIdPartition topicIdPartition2 = this.$outer.partition_1$1;
                        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get()).state().leaderEpoch());
                Assert.assertEquals((long)0L, (long)((ArchiveTask)tasks.find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAddReplacesExistingTask$1 $outer;

                    public final boolean apply(ArchiveTask x$6) {
                        TopicIdPartition topicIdPartition = x$6.topicIdPartition();
                        TopicIdPartition topicIdPartition2 = this.$outer.partition_2$2;
                        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get()).state().leaderEpoch());
                Assert.assertEquals((long)2L, (long)((ArchiveTask)tasks.find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAddReplacesExistingTask$1 $outer;

                    public final boolean apply(ArchiveTask x$7) {
                        TopicIdPartition topicIdPartition = x$7.topicIdPartition();
                        TopicIdPartition topicIdPartition2 = this.$outer.partition_3$2;
                        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get()).state().leaderEpoch());
                Assert.assertEquals((long)0L, (long)((ArchiveTask)tasks.find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAddReplacesExistingTask$1 $outer;

                    public final boolean apply(ArchiveTask x$8) {
                        TopicIdPartition topicIdPartition = x$8.topicIdPartition();
                        TopicIdPartition topicIdPartition2 = this.$outer.partition_4$2;
                        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get()).state().leaderEpoch());
                Assert.assertEquals((long)4L, (long)tasks.size());
            }
            {
                this.partition_1$1 = partition_1$1;
                this.partition_2$2 = partition_2$2;
                this.partition_3$2 = partition_3$2;
                this.partition_4$2 = partition_4$2;
            }
        });
    }

    public Option<Object> kafka$tier$tasks$archive$ArchiverTaskQueueTest$$lagFn(ArchiveTask task) {
        return (Option)this.lagMap().apply((Object)task.topicIdPartition());
    }

    private void updateLag(TopicIdPartition topicIdPartition, long lag) {
        this.lagMap().update((Object)topicIdPartition, (Object)new Some((Object)BoxesRunTime.boxToLong((long)lag)));
    }

    private List<TopicIdPartition> lagSortedEligibleTasks() {
        return (List)((List)((TraversableLike)((SeqLike)this.lagMap().toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicIdPartition, Object> apply(Tuple2<TopicIdPartition, Option<Object>> x0$1) {
                Tuple2<TopicIdPartition, Option<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicIdPartition topicPartition = (TopicIdPartition)tuple2._1();
                    Option lag = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)topicPartition, lag.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<TopicIdPartition, Object> x0$2) {
                Tuple2<TopicIdPartition, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    long lag;
                    long l = lag = tuple2._2$mcJ$sp();
                    return l;
                }
                throw new MatchError(tuple2);
            }
        }, (Ordering)Ordering.Long$.MODULE$)).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicIdPartition, Object> x0$3) {
                Tuple2<TopicIdPartition, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    long lag = tuple2._2$mcJ$sp();
                    boolean bl = lag != 0L;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicIdPartition apply(Tuple2<TopicIdPartition, Object> x0$4) {
                Tuple2<TopicIdPartition, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicIdPartition topicIdPartition;
                    TopicIdPartition topicIdPartition2 = topicIdPartition = (TopicIdPartition)tuple2._1();
                    return topicIdPartition2;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private void addTask(TopicIdPartition topicIdPartition, int leaderEpoch) {
        this.archiverTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(topicIdPartition, leaderEpoch));
    }

    private void removeTask(TopicIdPartition topicIdPartition) {
        this.archiverTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(topicIdPartition));
    }

    public ArchiverTaskQueueTest() {
        this.maxTasks = 3;
    }
}

