/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogTest$;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001B\u0001\u0003\u0001-\u0011Q\u0003V5fe\u0006\u00138\r[5wKJ\u001cF/\u0019;f)\u0016\u001cHO\u0003\u0002\u0004\t\u00059\u0011M]2iSZ,'BA\u0003\u0007\u0003\u0015!\u0018m]6t\u0015\t9\u0001\"\u0001\u0003uS\u0016\u0014(\"A\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0003\r\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u001a\u0003\r\u0019G\u000f_\u000b\u00025A\u00111DH\u0007\u00029)\u0011QDB\u0001\bM\u0016$8\r[3s\u0013\tyBDA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH\u000fC\u0005\"\u0001\u0001\u0007\t\u0019!C\u0001E\u000591\r\u001e=`I\u0015\fHCA\u0012'!\tiA%\u0003\u0002&\u001d\t!QK\\5u\u0011\u001d9\u0003%!AA\u0002i\t1\u0001\u001f\u00132\u0011\u0019I\u0003\u0001)Q\u00055\u0005!1\r\u001e=!\u0011\u001dY\u0003A1A\u0005\u00021\n\u0001\"\\8dWRKW.Z\u000b\u0002[A\u0011a&M\u0007\u0002_)\u0011\u0001\u0007C\u0001\u0006kRLGn]\u0005\u0003e=\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007i\u0001\u0001\u000b\u0011B\u0017\u0002\u00135|7m\u001b+j[\u0016\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\u000ei&,'\u000fV8qS\u000et\u0015-\\3\u0016\u0003a\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\t1\fgn\u001a\u0006\u0002{\u0005!!.\u0019<b\u0013\ty$H\u0001\u0004TiJLgn\u001a\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001d\u0002\u001dQLWM\u001d+pa&\u001cg*Y7fA!91\t\u0001b\u0001\n\u0003!\u0015A\u0006;jKJ$v\u000e]5d\u001dVl\u0007+\u0019:uSRLwN\\:\u0016\u0003\u0015\u0003\"!\u0004$\n\u0005\u001ds!!B*i_J$\bBB%\u0001A\u0003%Q)A\fuS\u0016\u0014Hk\u001c9jG:+X\u000eU1si&$\u0018n\u001c8tA!91\n\u0001b\u0001\n\u0003a\u0015a\u00027pO\u0012K'o]\u000b\u0002\u001bB\u0019a*\u0015\u001d\u000e\u0003=S!\u0001\u0015\u001f\u0002\tU$\u0018\u000e\\\u0005\u0003%>\u0013\u0011\"\u0011:sCfd\u0015n\u001d;\t\rQ\u0003\u0001\u0015!\u0003N\u0003!awn\u001a#jeN\u0004\u0003b\u0002,\u0001\u0005\u0004%\taV\u0001\u0012_\nTWm\u0019;Ti>\u0014XmQ8oM&<W#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005m3\u0011!B:u_J,\u0017BA/[\u0005U!\u0016.\u001a:PE*,7\r^*u_J,7i\u001c8gS\u001eDaa\u0018\u0001!\u0002\u0013A\u0016AE8cU\u0016\u001cGo\u0015;pe\u0016\u001cuN\u001c4jO\u0002Bq!\u0019\u0001C\u0002\u0013\u0005!-A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f+\u0005\u0019\u0007CA-e\u0013\t)'LA\u000eN_\u000e\\\u0017J\\'f[>\u0014\u0018\u0010V5fe>\u0013'.Z2u'R|'/\u001a\u0005\u0007O\u0002\u0001\u000b\u0011B2\u0002!QLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004\u0003bB5\u0001\u0005\u0004%\tA[\u0001\u0012i&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014X#A6\u0011\u00051|W\"A7\u000b\u000594\u0011!\u0002;pa&\u001c\u0017B\u00019n\u0005E!\u0016.\u001a:U_BL7mQ8ogVlWM\u001d\u0005\u0007e\u0002\u0001\u000b\u0011B6\u0002%QLWM\u001d+pa&\u001c7i\u001c8tk6,'\u000f\t\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0003e!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GC\u000e$xN]=\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u0004\u0002\u000bM$\u0018\r^3\n\u0005mD(!\u0007+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015m\u0019;pefDa! \u0001!\u0002\u00131\u0018A\u0007;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015m\u0019;pef\u0004\u0003\u0002C@\u0001\u0001\u0004%\t!!\u0001\u0002'QLWM\u001d)beRLG/[8o'R\fG/Z:\u0016\u0005\u0005\r\u0001#B\u0007\u0002\u0006\u0005%\u0011bAA\u0004\u001d\t)\u0011I\u001d:bsB\u0019q/a\u0003\n\u0007\u00055\u0001P\u0001\nUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0007\"CA\t\u0001\u0001\u0007I\u0011AA\n\u0003]!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3t?\u0012*\u0017\u000fF\u0002$\u0003+A\u0011bJA\b\u0003\u0003\u0005\r!a\u0001\t\u0011\u0005e\u0001\u0001)Q\u0005\u0003\u0007\tA\u0003^5feB\u000b'\u000f^5uS>t7\u000b^1uKN\u0004\u0003\"CA\u000f\u0001\t\u0007I\u0011AA\u0010\u0003E!\u0018.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo]\u000b\u0003\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003OA\u0011a\u00017pO&!\u00111FA\u0013\u0005E!\u0016.\u001a:M_\u001e\u001cu.\u001c9p]\u0016tGo\u001d\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\"\u0005\u0011B/[3s\u0019><7i\\7q_:,g\u000e^:!\u0011%\t\u0019\u0004\u0001b\u0001\n\u0003\t)$\u0001\nuS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA\u001c!\u0011\tI$a\u000f\u000e\u0003\u0019I1!!\u0010\u0007\u0005I!\u0016.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003o\t1\u0003^5feJ+\u0007\u000f\\5dC6\u000bg.Y4fe\u0002B\u0011\"!\u0012\u0001\u0005\u0004%\t!a\u0012\u0002)\tdwnY6j]\u001e$\u0016m]6Fq\u0016\u001cW\u000f^8s+\t\tI\u0005\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\tyeT\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA*\u0003\u001b\u0012\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011!\t9\u0006\u0001Q\u0001\n\u0005%\u0013!\u00062m_\u000e\\\u0017N\\4UCN\\W\t_3dkR|'\u000f\t\u0005\n\u00037\u0002!\u0019!C\u0001\u0003;\nA\u0001^5nKV\u0011\u0011q\f\t\u0005\u0003C\n\u0019(\u0004\u0002\u0002d)\u0019\u0001'!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0007G>lWn\u001c8\u000b\u0007%\tYG\u0003\u0003\u0002n\u0005=\u0014AB1qC\u000eDWM\u0003\u0002\u0002r\u0005\u0019qN]4\n\t\u0005U\u00141\r\u0002\u0005)&lW\r\u0003\u0005\u0002z\u0001\u0001\u000b\u0011BA0\u0003\u0015!\u0018.\\3!\u0011%\ti\b\u0001b\u0001\n\u0003\ty(A\u0006nCb<\u0016-\u001b;US6,WCAAA!\u0011\t\u0019)a#\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003\u001fr\u0011\u0002BAG\u0003\u000b\u0013aBR5oSR,G)\u001e:bi&|g\u000e\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BAA\u00031i\u0017\r_,bSR$\u0016.\\3!\u0011-\t)\n\u0001a\u0001\u0002\u0004%\t!a&\u0002\u0011\tLH/\u001a*bi\u0016,\"!!'\u0011\t\u0005m\u0015QV\u0007\u0003\u0003;SA!a(\u0002\"\u0006!1m\u001c:f\u0015\u0011\t\u0019+!*\u0002\u000f5,GO]5dg*!\u0011qUAU\u0003\u0019I\u0018-\\7fe*\u0011\u00111V\u0001\u0004G>l\u0017\u0002BAX\u0003;\u0013Q!T3uKJD1\"a-\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00026\u0006a!-\u001f;f%\u0006$Xm\u0018\u0013fcR\u00191%a.\t\u0013\u001d\n\t,!AA\u0002\u0005e\u0005\u0002CA^\u0001\u0001\u0006K!!'\u0002\u0013\tLH/\u001a*bi\u0016\u0004\u0003bBA`\u0001\u0011\u0005\u0011\u0011Y\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002G!\"\u0011QXAc!\u0011\t9-!4\u000e\u0005\u0005%'\u0002BAf\u0003_\nQA[;oSRLA!a4\u0002J\n1!)\u001a4pe\u0016Dq!a5\u0001\t\u0003\t\t-\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t\t.a6\u0011\t\u0005\u001d\u0017\u0011\\\u0005\u0005\u00037\fIMA\u0003BMR,'\u000fC\u0004\u0002`\u0002!\t!!1\u00021Q,7\u000f^!xC&$\u0018N\\4MK\u0006$WM\u001d*fgVdG\u000f\u000b\u0003\u0002^\u0006\r\b\u0003BAd\u0003KLA!a:\u0002J\n!A+Z:u\u0011\u001d\tY\u000f\u0001C\u0001\u0003\u0003\fa\u0004^3ti\u0006;\u0018-\u001b;j]\u001edU-\u00193feJ+7/\u001e7u\r\u0016t7-\u001a3)\u0011\u0005%\u00181]Ax\u0003c\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003g\u0004B!!>\u0002|6\u0011\u0011q\u001f\u0006\u0004\u0003s4\u0011AC3yG\u0016\u0004H/[8og&!\u0011Q`A|\u0005m!\u0016.\u001a:Be\u000eD\u0017N^3s\r\u0016t7-\u001a3Fq\u000e,\u0007\u000f^5p]\"9!\u0011\u0001\u0001\u0005\u0002\u0005\u0005\u0017A\u0006;fgR\u0014UMZ8sKV\u0003Hn\\1e\r\u0016t7-\u001a3)\u0011\u0005}\u00181]Ax\u0003cDqAa\u0002\u0001\t\u0003\t\t-\u0001\u0012uKN$()\u001a4pe\u0016,\u0006\u000f\\8bIJ+GO]=XQ\u0016tgj\\*fO6,g\u000e\u001e\u0015\u0005\u0005\u000b\t\u0019\u000fC\u0004\u0003\u000e\u0001!\t!!1\u0002GQ,7\u000f\u001e\"fM>\u0014X-\u00169m_\u0006$\u0017\t\u001a<b]\u000e,7\u000fV8OKb$8\u000b^1uK\"\"!1BAr\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0003\u0003\f!\u0005^3ti\n+gm\u001c:f+Bdw.\u00193Pm\u0016\u0014H.\u00199qS:<7+Z4nK:$\b\u0006\u0002B\t\u0003GDqA!\u0007\u0001\t\u0013\u0011Y\"\u0001\rde\u0016\fG/\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$\u0002\"!\u0003\u0003\u001e\t5\"q\u0007\u0005\t\u0005?\u00119\u00021\u0001\u0003\"\u0005\u0019A-\u001b:\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQ1Aa\n=\u0003\tIw.\u0003\u0003\u0003,\t\u0015\"\u0001\u0002$jY\u0016D\u0001Ba\f\u0003\u0018\u0001\u0007!\u0011G\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004B!!\u000f\u00034%\u0019!Q\u0007\u0004\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0002\u0003B\u001d\u0005/\u0001\rAa\u000f\u0002\u001dQLWM]5oO\u0016s\u0017M\u00197fIB\u0019QB!\u0010\n\u0007\t}bBA\u0004C_>dW-\u00198")
public class TierArchiverStateTest {
    private CancellationContext ctx;
    private final MockTime mockTime = new MockTime();
    private final String tierTopicName;
    private final short tierTopicNumPartitions;
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(System.getProperty("java.io.tmpdir")));
    private final TierObjectStoreConfig objectStoreConfig = new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1));
    private final MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore(this.objectStoreConfig());
    private final TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private TierPartitionState[] tierPartitionStates = (TierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(TierPartitionState.class));
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), this.tierPartitionStateFactory());
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final ScheduledExecutorService blockingTaskExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Time time = Time.SYSTEM;
    private final FiniteDuration maxWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private Meter byteRate;

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public String tierTopicName() {
        return this.tierTopicName;
    }

    public short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public TierObjectStoreConfig objectStoreConfig() {
        return this.objectStoreConfig;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierPartitionState[] tierPartitionStates() {
        return this.tierPartitionStates;
    }

    public void tierPartitionStates_$eq(TierPartitionState[] x$1) {
        this.tierPartitionStates = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public ScheduledExecutorService blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public Time time() {
        return this.time;
    }

    public FiniteDuration maxWaitTime() {
        return this.maxWaitTime;
    }

    public Meter byteRate() {
        return this.byteRate;
    }

    public void byteRate_$eq(Meter x$1) {
        this.byteRate = x$1;
    }

    @Before
    public void setUp() {
        this.ctx_$eq(CancellationContext.newContext());
        KafkaMetricsGroup$.MODULE$.removeMetric("TierArchiver.UploadRate", KafkaMetricsGroup$.MODULE$.removeMetric$default$2());
        this.byteRate_$eq(KafkaMetricsGroup$.MODULE$.newMeter("TierArchiver.UploadRate", "bytes", TimeUnit.SECONDS, KafkaMetricsGroup$.MODULE$.newMeter$default$4()));
    }

    @After
    public void tearDown() {
        Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TierPartitionState x$1) {
                x$1.delete();
            }
        });
        this.ctx().cancel();
    }

    @Test
    public void testAwaitingLeaderResult() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.becomeArchiver(topicIdPartition, 0)).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        TierPartitionState tierPartitionState2 = this.createTierPartitionState(new File(this.logDirs().get(0)), topicIdPartition, true);
        this.tierReplicaManager().becomeLeader(tierPartitionState2, 1);
        AbstractLog log2 = (AbstractLog)Mockito.mock(AbstractLog.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log2));
        Mockito.when((Object)log2.tierPartitionState()).thenReturn((Object)tierPartitionState2);
        ArchiveTask task = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 0, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$));
        Future nextStage = task.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, task.transition$default$5(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assert.assertTrue((String)"Should advance to BeforeUpload", (boolean)(result.state() instanceof BeforeUpload));
    }

    @Test(expected=TierArchiverFencedException.class)
    public void testAwaitingLeaderResultFenced() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.becomeArchiver(topicIdPartition, 0)).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), topicIdPartition, (TierTopicAppender)tierTopicManager, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime());
    }

    @Test(expected=TierArchiverFencedException.class)
    public void testBeforeUploadFenced() {
        AbstractLog log2 = (AbstractLog)Mockito.mock(AbstractLog.class);
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log2));
        TierPartitionState tierPartitionState2 = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState2.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(Predef$.MODULE$.long2Long(-1L))));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState2.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)log2.tierPartitionState()).thenReturn((Object)tierPartitionState2);
        Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime());
    }

    @Test
    public void testBeforeUploadRetryWhenNoSegment() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        AbstractLog log2 = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log2.tierableLogSegments()).thenReturn((Object)List$.MODULE$.empty());
        Mockito.when((Object)log2.activeSegment()).thenReturn(null);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log2));
        TierPartitionState tierPartitionState2 = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState2.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(Predef$.MODULE$.long2Long(-1L))));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState2.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)log2.tierPartitionState()).thenReturn((Object)tierPartitionState2);
        ArchiveTaskState result = (ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime());
        Assert.assertTrue((String)"Should advance to BeforeUpload", (boolean)(result instanceof BeforeUpload));
    }

    @Test
    public void testBeforeUploadAdvancesToNextState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        TierPartitionState tierPartitionState2 = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState2.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(Predef$.MODULE$.long2Long(-1L))));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState2.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState2.segmentOffsets(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ConcurrentSkipListSet());
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        int x$2 = 150;
        int x$3 = 1;
        int x$4 = 65536;
        boolean x$5 = true;
        long x$6 = LogTest$.MODULE$.createLogConfig$default$1();
        long x$7 = LogTest$.MODULE$.createLogConfig$default$3();
        long x$8 = LogTest$.MODULE$.createLogConfig$default$4();
        long x$9 = LogTest$.MODULE$.createLogConfig$default$5();
        String x$10 = LogTest$.MODULE$.createLogConfig$default$6();
        int x$11 = LogTest$.MODULE$.createLogConfig$default$9();
        String x$12 = LogTest$.MODULE$.createLogConfig$default$10();
        long x$13 = LogTest$.MODULE$.createLogConfig$default$11();
        long x$14 = LogTest$.MODULE$.createLogConfig$default$13();
        long x$15 = LogTest$.MODULE$.createLogConfig$default$14();
        int x$16 = LogTest$.MODULE$.createLogConfig$default$15();
        long x$17 = LogTest$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTest$.MODULE$.createLogConfig(x$6, x$2, x$7, x$8, x$9, x$10, x$4, x$3, x$11, x$12, x$13, x$5, x$14, x$15, x$16, x$17);
        File logDir = Paths.get(TestUtils$.MODULE$.tempDir().getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig)).thenReturn((Object)tierPartitionState2);
        AbstractLog log2 = LogTest$.MODULE$.createLog(logDir, logConfig, new BrokerTopicStats(), this.mockTime().scheduler(), (Time)this.mockTime(), 0L, 0L, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), (Option<TierLogComponents>)new Some((Object)this.tierLogComponents()));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log2));
        log2.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log2.logEndOffset(), 0));
        log2.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log2.logEndOffset(), 0));
        log2.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log2.logEndOffset(), 0));
        log2.updateHighWatermark(log2.logEndOffset());
        ArchiveTaskState result = (ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime());
        Assert.assertTrue((String)"Should advance to AfterUpload", (boolean)(result instanceof Upload));
    }

    @Test
    public void testBeforeUploadOverlappingSegment() {
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        int x$18 = 1000;
        int x$19 = 1;
        int x$20 = 65536;
        boolean x$21 = true;
        long x$22 = LogTest$.MODULE$.createLogConfig$default$1();
        long x$23 = LogTest$.MODULE$.createLogConfig$default$3();
        long x$24 = LogTest$.MODULE$.createLogConfig$default$4();
        long x$25 = LogTest$.MODULE$.createLogConfig$default$5();
        String x$26 = LogTest$.MODULE$.createLogConfig$default$6();
        int x$27 = LogTest$.MODULE$.createLogConfig$default$9();
        String x$28 = LogTest$.MODULE$.createLogConfig$default$10();
        long x$29 = LogTest$.MODULE$.createLogConfig$default$11();
        long x$30 = LogTest$.MODULE$.createLogConfig$default$13();
        long x$31 = LogTest$.MODULE$.createLogConfig$default$14();
        int x$32 = LogTest$.MODULE$.createLogConfig$default$15();
        long x$33 = LogTest$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTest$.MODULE$.createLogConfig(x$22, x$18, x$23, x$24, x$25, x$26, x$20, x$19, x$27, x$28, x$29, x$21, x$30, x$31, x$32, x$33);
        File logDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils$.MODULE$.tempDir());
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(logDir);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        TierPartitionState tierPartitionState2 = this.createTierPartitionState(logDir, topicIdPartition, true);
        tierPartitionState2.beginCatchup();
        tierPartitionState2.onCatchUpComplete();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierPartitionStateFactory().mayEnableTiering(topicPartition, logConfig))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicIdPartition.topicPartition(), logConfig)).thenReturn((Object)tierPartitionState2);
        MergedLog log2 = Log$.MODULE$.apply(logDir, logConfig, 0L, 0L, (Scheduler)this.mockTime().scheduler(), new BrokerTopicStats(), (Time)this.mockTime(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10), (Option)new Some((Object)this.tierLogComponents()));
        log2.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log2.logEndOffset(), 0));
        log2.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log2.logEndOffset(), 0));
        log2.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log2.logEndOffset(), 0));
        log2.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log2.logEndOffset(), 0));
        tierPartitionState2.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), 0L);
        TierTestUtils$.MODULE$.uploadWithMetadata(tierPartitionState2, topicIdPartition, 0, UUID.randomUUID(), 0L, 60L, 15000L, 15000L, 1000, TierTestUtils$.MODULE$.uploadWithMetadata$default$10(), TierTestUtils$.MODULE$.uploadWithMetadata$default$11(), TierTestUtils$.MODULE$.uploadWithMetadata$default$12());
        int newTierEpoch = 1;
        tierPartitionState2.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, newTierEpoch, UUID.randomUUID(), 0), 0L);
        log2.updateHighWatermark(log2.logEndOffset());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log2));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<CompletableFuture<TierPartitionState.AppendResult>>(this, tierPartitionState2){
            private final TierPartitionState tierPartitionState$1;

            public CompletableFuture<TierPartitionState.AppendResult> answer(InvocationOnMock invocation) {
                AbstractTierMetadata metadata = (AbstractTierMetadata)invocation.getArgument(0);
                return CompletableFuture.completedFuture(this.tierPartitionState$1.append(metadata, 0L));
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
        ArchiveTaskState result = (ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(newTierEpoch), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime());
        Assert.assertTrue((String)"Should advance to Upload", (boolean)(result instanceof Upload));
    }

    private TierPartitionState createTierPartitionState(File dir, TopicIdPartition topicIdPartition, boolean tieringEnabled) {
        FileTierPartitionState tierPartitionState2 = new FileTierPartitionState(dir, topicIdPartition.topicPartition(), tieringEnabled);
        tierPartitionState2.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates_$eq((TierPartitionState[])Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates()).$colon$plus((Object)tierPartitionState2, ClassTag$.MODULE$.apply(TierPartitionState.class)));
        return tierPartitionState2;
    }

    public TierArchiverStateTest() {
        this.tierTopicName = "_confluent-tier-state";
        this.tierTopicNumPartitions = 1;
    }
}

