/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.MergedLog;
import kafka.log.TierLogSegment;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.tasks.delete.DeletionTask$;
import kafka.tier.tasks.delete.DeletionTaskQueue;
import kafka.tier.tasks.delete.DeletionTaskQueue$;
import kafka.tier.tasks.delete.DeletionTaskQueueTest$;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Queue;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u0001-\u0011Q\u0003R3mKRLwN\u001c+bg.\fV/Z;f)\u0016\u001cHO\u0003\u0002\u0004\t\u00051A-\u001a7fi\u0016T!!\u0002\u0004\u0002\u000bQ\f7o[:\u000b\u0005\u001dA\u0011\u0001\u0002;jKJT\u0011!C\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001C\u0002\u0013%\u0011$A\u0002dib,\u0012A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0019\tqAZ3uG\",'/\u0003\u0002 9\t\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\"1\u0011\u0005\u0001Q\u0001\ni\tAa\u0019;yA!91\u0005\u0001b\u0001\n\u0013!\u0013\u0001\u0002;j[\u0016,\u0012!\n\t\u0003MAj\u0011a\n\u0006\u0003Q%\nQ!\u001e;jYNT!AK\u0016\u0002\r\r|W.\\8o\u0015\tIAF\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<\u0017BA\u0019(\u0005\u0011!\u0016.\\3\t\rM\u0002\u0001\u0015!\u0003&\u0003\u0015!\u0018.\\3!\u0011\u001d)\u0004A1A\u0005\nY\n\u0001\"\\1y)\u0006\u001c8n]\u000b\u0002oA\u0011Q\u0002O\u0005\u0003s9\u00111!\u00138u\u0011\u0019Y\u0004\u0001)A\u0005o\u0005IQ.\u0019=UCN\\7\u000f\t\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\"\taa]3sm\u0016\u0014\u0018B\u0001#B\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDaA\u0012\u0001!\u0002\u0013y\u0014a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\t\u000f!\u0003!\u0019!C\u0005\u0013\u0006\tB-\u001a7fi&|g\u000eV1tWF+X-^3\u0016\u0003)\u0003\"AF&\n\u00051\u0013!!\u0005#fY\u0016$\u0018n\u001c8UCN\\\u0017+^3vK\"1a\n\u0001Q\u0001\n)\u000b!\u0003Z3mKRLwN\u001c+bg.\fV/Z;fA!)\u0001\u000b\u0001C\u0001#\u0006!B/Z:u!>dG\u000eV1tW>\u0013H-\u001a:j]\u001e$\u0012A\u0015\t\u0003\u001bMK!\u0001\u0016\b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001fZ\u0003\"a\u0016.\u000e\u0003aS!!\u0017\u0018\u0002\u000b),h.\u001b;\n\u0005mC&\u0001\u0002+fgRDQ!\u0018\u0001\u0005\u0002E\u000bQ\u0002^3tiN{'\u000f\u001e+bg.\u001c\bF\u0001/W\u0011\u0015\u0001\u0007\u0001\"\u0001R\u0003Q!Xm\u001d;Ti\u0006$X\r\u0016:b]NLG/[8og\"\u0012qL\u0016\u0005\u0006G\u0002!I\u0001Z\u0001\fg>\u0014H/\u001a3UCN\\7/F\u0001f!\r1g.\u001d\b\u0003O2t!\u0001[6\u000e\u0003%T!A\u001b\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011BA7\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001c9\u0003\t1K7\u000f\u001e\u0006\u0003[:\u0001\"A]:\u000e\u0003\u0019I!\u0001\u001e\u0004\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\"\u0002<\u0001\t\u00139\u0018!F;qI\u0006$X\rT1tiB\u0013xnY3tg\u0016$Wj\u001d\u000b\u0004%bT\b\"B=v\u0001\u0004\t\u0018\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u0015YX\u000f1\u0001}\u0003=a\u0017m\u001d;Qe>\u001cWm]:fI6\u001b\bCA\u0007~\u0013\tqhB\u0001\u0003M_:<\u0007bBA\u0001\u0001\u0011%\u00111A\u0001\u0012e\u0016$XM\u001c;j_:lU\r^1eCR\fG\u0003BA\u0003\u0003G\u0001B!a\u0002\u0002\u001e9!\u0011\u0011BA\r\u001d\u0011\tY!a\u0006\u000f\t\u00055\u0011Q\u0003\b\u0005\u0003\u001f\t\u0019BD\u0002i\u0003#I\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011bAA\u000e\u0005\u0005aA)\u001a7fi&|g\u000eV1tW&!\u0011qDA\u0011\u0005Y!U\r\\3uK\u0006\u001bH*Z1eKJlU\r^1eCR\f'bAA\u000e\u0005!1\u0011QE@A\u0002]\n1\u0002\\3bI\u0016\u0014X\t]8dQ\u0002")
public class DeletionTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final Time time = new MockTime();
    private final int maxTasks;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final DeletionTaskQueue deletionTaskQueue = new DeletionTaskQueue(this.ctx(), this.maxTasks(), 5L, this.time(), this.replicaManager(), DeletionTaskQueue$.MODULE$.$lessinit$greater$default$6());

    private CancellationContext ctx() {
        return this.ctx;
    }

    private Time time() {
        return this.time;
    }

    private int maxTasks() {
        return this.maxTasks;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private DeletionTaskQueue deletionTaskQueue() {
        return this.deletionTaskQueue;
    }

    @Test
    public void testPollTaskOrdering() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_1, 0));
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_2, 0));
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_3, 0));
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition_4, 0));
        this.updateLastProcessedMs(partition_1, 5L);
        this.updateLastProcessedMs(partition_2, 10L);
        this.updateLastProcessedMs(partition_3, 1L);
        this.updateLastProcessedMs(partition_4, 15L);
        List tasks = (List)this.deletionTaskQueue().poll().get();
        Assert.assertEquals((Object)this.sortedTasks().take(this.maxTasks()), (Object)((List)tasks.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicIdPartition apply(DeletionTask x$1) {
                return x$1.topicIdPartition();
            }
        }, List$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testSortTasks() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TopicIdPartition partition_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        DeletionTask task_1 = new DeletionTask(this.ctx().subContext(), partition_1, 5L, (DeletionTask.State)new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)this.retentionMetadata(0)), DeletionTask$.MODULE$.$lessinit$greater$default$5());
        DeletionTask task_2 = new DeletionTask(this.ctx().subContext(), partition_2, 5L, (DeletionTask.State)new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)this.retentionMetadata(1)), DeletionTask$.MODULE$.$lessinit$greater$default$5());
        DeletionTask task_3 = new DeletionTask(this.ctx().subContext(), partition_3, 5L, (DeletionTask.State)new DeletionTask.Delete((DeletionTask.StateMetadata)this.retentionMetadata(0), (Queue)Mockito.mock(Queue.class)), DeletionTask$.MODULE$.$lessinit$greater$default$5());
        DeletionTask task_4 = new DeletionTask(this.ctx().subContext(), partition_4, 5L, (DeletionTask.State)new DeletionTask.CompleteDelete((DeletionTask.StateMetadata)this.retentionMetadata(0), (Queue)Mockito.mock(Queue.class)), DeletionTask$.MODULE$.$lessinit$greater$default$5());
        DeletionTask task_5 = new DeletionTask(this.ctx().subContext(), partition_5, 5L, (DeletionTask.State)new DeletionTask.InitiateDelete((DeletionTask.StateMetadata)this.retentionMetadata(0), (Queue)Mockito.mock(Queue.class)), DeletionTask$.MODULE$.$lessinit$greater$default$5());
        task_1.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() - 100L))));
        task_2.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() - 300L))));
        task_3.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() + 100L))));
        task_4.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() - 200L))));
        task_5.lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().hiResClockMs() + 200L))));
        List taskList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeletionTask[]{task_1, task_2, task_3, task_4, task_5}));
        List sortedTasks2 = this.deletionTaskQueue().sortTasks(taskList);
        Assert.assertEquals((long)taskList.size(), (long)sortedTasks2.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeletionTask[]{task_3, task_4, task_5})), (Object)sortedTasks2.take(3).toSet());
        Assert.assertEquals((Object)task_2, (Object)sortedTasks2.apply(3));
        Assert.assertEquals((Object)task_1, (Object)sortedTasks2.apply(4));
    }

    @Test
    public void testStateTransitions() {
        TierTopicAppender tierTopicAppender = (TierTopicAppender)Mockito.mock(TierTopicAppender.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        TierObjectStore.ObjectMetadata tierObjectMetadata = (TierObjectStore.ObjectMetadata)Mockito.mock(TierObjectStore.ObjectMetadata.class);
        TopicIdPartition partition = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierPartitionState tierPartitionState2 = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        MergedLog log2 = (MergedLog)Mockito.mock(MergedLog.class);
        TierLogSegment tieredLogSegment = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        long fileDeleteDelayMs = 19000L;
        Properties properties = new Properties();
        properties.put(LogConfig$.MODULE$.RetentionMsProp(), "1");
        properties.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), ((Object)BoxesRunTime.boxToLong((long)fileDeleteDelayMs)).toString());
        LogConfig logConfig = new LogConfig((Map)properties, LogConfig$.MODULE$.apply$default$2());
        Mockito.when((Object)tierTopicAppender.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.replicaManager().getLog(partition.topicPartition())).thenReturn((Object)new Some((Object)log2));
        Mockito.when((Object)log2.tieredLogSegments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TierLogSegment[]{tieredLogSegment})));
        Mockito.when((Object)log2.config()).thenReturn((Object)logConfig);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log2.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)log2.tierPartitionState()).thenReturn((Object)tierPartitionState2);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment.maxTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.time().hiResClockMs()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tieredLogSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)100));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tieredLogSegment.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)50L));
        Mockito.when((Object)tieredLogSegment.metadata()).thenReturn((Object)tierObjectMetadata);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState2.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState2.fencedSegments()).thenReturn(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TierObjectMetadata[]{new TierObjectMetadata(partition, 0, UUID.randomUUID(), 100L, 3252334L, 1000L, 102, TierObjectMetadata.State.SEGMENT_FENCED, true, false, false)}))).asJava());
        Mockito.when((Object)tierObjectMetadata.topicIdPartition()).thenReturn((Object)partition);
        Mockito.when((Object)tierObjectMetadata.objectId()).thenReturn((Object)UUID.randomUUID());
        this.deletionTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(partition, 0));
        long nowMs = this.time().hiResClockMs();
        DeletionTask task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        Assert.assertEquals(DeletionTask.CollectDeletableSegments.class, task.state().getClass());
        Assert.assertEquals((Object)None$.MODULE$, (Object)task.pausedUntil());
        DeletionTask qual$1 = task;
        Time x$5 = this.time();
        TierTopicAppender x$6 = tierTopicAppender;
        TierObjectStore x$7 = tierObjectStore;
        ReplicaManager x$8 = this.replicaManager();
        Option x$9 = qual$1.transition$default$5();
        Future future = qual$1.transition(x$5, x$6, x$7, x$8, x$9, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
        Assert.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assert.assertEquals((Object)new Some((Object)Instant.ofEpochMilli(nowMs)), (Object)task.pausedUntil());
        this.deletionTaskQueue().done((TierTask)task);
        this.time().sleep(1L);
        long timeBeforeTransitionMs = this.time().hiResClockMs();
        DeletionTask qual$2 = task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        Time x$10 = this.time();
        TierTopicAppender x$11 = tierTopicAppender;
        TierObjectStore x$12 = tierObjectStore;
        ReplicaManager x$13 = this.replicaManager();
        Option x$14 = qual$2.transition$default$5();
        future = qual$2.transition(x$10, x$11, x$12, x$13, x$14, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
        Assert.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assert.assertTrue((boolean)task.pausedUntil().isDefined());
        Assert.assertEquals((Object)Instant.ofEpochMilli(timeBeforeTransitionMs).plusMillis(fileDeleteDelayMs), (Object)task.pausedUntil().get());
        this.deletionTaskQueue().done((TierTask)task);
        Assert.assertTrue((boolean)this.deletionTaskQueue().poll().isEmpty());
        Assert.assertEquals((long)1L, (long)this.deletionTaskQueue().taskCount());
        this.time().sleep(fileDeleteDelayMs + 1L);
        timeBeforeTransitionMs = this.time().hiResClockMs();
        DeletionTask qual$3 = task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        Time x$15 = this.time();
        TierTopicAppender x$16 = tierTopicAppender;
        TierObjectStore x$17 = tierObjectStore;
        ReplicaManager x$18 = this.replicaManager();
        Option x$19 = qual$3.transition$default$5();
        future = qual$3.transition(x$15, x$16, x$17, x$18, x$19, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
        Assert.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assert.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
        DeletionTask qual$4 = task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        Time x$20 = this.time();
        TierTopicAppender x$21 = tierTopicAppender;
        TierObjectStore x$22 = tierObjectStore;
        ReplicaManager x$23 = this.replicaManager();
        Option x$24 = qual$4.transition$default$5();
        future = qual$4.transition(x$20, x$21, x$22, x$23, x$24, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
        Assert.assertEquals(DeletionTask.InitiateDelete.class, task.state().getClass());
        Assert.assertTrue((boolean)task.pausedUntil().isDefined());
        Assert.assertEquals((Object)new Some((Object)Instant.ofEpochMilli(Math.addExact(nowMs, (long)DeletionTask$.MODULE$.FencedSegmentDeleteDelayMs()))), (Object)task.pausedUntil());
        this.deletionTaskQueue().done((TierTask)task);
        Assert.assertTrue((boolean)this.deletionTaskQueue().poll().isEmpty());
        Assert.assertEquals((long)1L, (long)this.deletionTaskQueue().taskCount());
        this.time().sleep((long)DeletionTask$.MODULE$.FencedSegmentDeleteDelayMs() - (fileDeleteDelayMs + 1L) + 1L);
        timeBeforeTransitionMs = this.time().hiResClockMs();
        DeletionTask qual$5 = task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        Time x$25 = this.time();
        TierTopicAppender x$26 = tierTopicAppender;
        TierObjectStore x$27 = tierObjectStore;
        ReplicaManager x$28 = this.replicaManager();
        Option x$29 = qual$5.transition$default$5();
        future = qual$5.transition(x$25, x$26, x$27, x$28, x$29, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
        Assert.assertEquals(DeletionTask.Delete.class, task.state().getClass());
        Assert.assertTrue((boolean)task.pausedUntil().isDefined());
        Assert.assertEquals((Object)Instant.ofEpochMilli(timeBeforeTransitionMs).plusMillis(fileDeleteDelayMs), (Object)task.pausedUntil().get());
        this.deletionTaskQueue().done((TierTask)task);
        Assert.assertTrue((boolean)this.deletionTaskQueue().poll().isEmpty());
        Assert.assertEquals((long)1L, (long)this.deletionTaskQueue().taskCount());
        this.time().sleep(fileDeleteDelayMs + 1L);
        timeBeforeTransitionMs = this.time().hiResClockMs();
        DeletionTask qual$6 = task = (DeletionTask)((IterableLike)this.deletionTaskQueue().poll().get()).head();
        Time x$30 = this.time();
        TierTopicAppender x$31 = tierTopicAppender;
        TierObjectStore x$32 = tierObjectStore;
        ReplicaManager x$33 = this.replicaManager();
        Option x$34 = qual$6.transition$default$5();
        future = qual$6.transition(x$30, x$31, x$32, x$33, x$34, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        task = (DeletionTask)Await$.MODULE$.result((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
        Assert.assertEquals(DeletionTask.CompleteDelete.class, task.state().getClass());
        Assert.assertTrue((boolean)task.pausedUntil().isEmpty());
        this.deletionTaskQueue().done((TierTask)task);
    }

    private List<TopicIdPartition> sortedTasks() {
        return (List)this.deletionTaskQueue().withAllTasks((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<TopicIdPartition> apply(Set<DeletionTask> tasks) {
                return (List)((List)tasks.toList().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<Object> apply(DeletionTask x$2) {
                        return x$2.lastProcessedMs();
                    }
                }, Ordering$.MODULE$.Option((Ordering)Ordering.Long$.MODULE$))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicIdPartition apply(DeletionTask x$3) {
                        return x$3.topicIdPartition();
                    }
                }, List$.MODULE$.canBuildFrom());
            }
        });
    }

    private void updateLastProcessedMs(TopicIdPartition topicIdPartition, long lastProcessedMs) {
        this.deletionTaskQueue().withAllTasks((Function1)new Serializable(this, topicIdPartition, lastProcessedMs){
            public static final long serialVersionUID = 0L;
            public final TopicIdPartition topicIdPartition$1;
            private final long lastProcessedMs$1;

            public final void apply(Set<DeletionTask> tasks) {
                ((DeletionTask)tasks.find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$updateLastProcessedMs$1 $outer;

                    public final boolean apply(DeletionTask x$4) {
                        TopicIdPartition topicIdPartition = x$4.topicIdPartition();
                        TopicIdPartition topicIdPartition2 = this.$outer.topicIdPartition$1;
                        return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get()).lastProcessedMs_$eq((Option)new Some((Object)BoxesRunTime.boxToLong((long)this.lastProcessedMs$1)));
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
                this.lastProcessedMs$1 = lastProcessedMs$1;
            }
        });
    }

    private DeletionTask.DeleteAsLeaderMetadata retentionMetadata(int leaderEpoch) {
        return new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), leaderEpoch);
    }

    public DeletionTaskQueueTest() {
        this.maxTasks = 3;
    }
}

