/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import java.io.File;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.OffsetIndex;
import kafka.log.TierLogSegment;
import kafka.log.TimeIndex;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.tasks.delete.DeletionTask$;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tEf\u0001B\u0001\u0003\u0001-\u0011\u0001\u0003R3mKRLwN\u001c+bg.$Vm\u001d;\u000b\u0005\r!\u0011A\u00023fY\u0016$XM\u0003\u0002\u0006\r\u0005)A/Y:lg*\u0011q\u0001C\u0001\u0005i&,'OC\u0001\n\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0004\u0019\u0001\t\u0007I\u0011A\r\u0002\rQ|\u0007/[22+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011a\u0017M\\4\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0007'R\u0014\u0018N\\4\t\r\r\u0002\u0001\u0015!\u0003\u001b\u0003\u001d!x\u000e]5dc\u0001Bq!\n\u0001C\u0002\u0013\u0005a%\u0001\nu_BL7-\u00133QCJ$\u0018\u000e^5p]~\u000bT#A\u0014\u0011\u0005!JS\"\u0001\u0004\n\u0005)2!\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u0019a\u0003\u0001)A\u0005O\u0005\u0019Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\02A!9a\u0006\u0001a\u0001\n\u0003y\u0013\u0001\u0006;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016|\u0016'F\u00011!\t\tD'D\u00013\u0015\t\u0019d!A\u0003ti\u0006$X-\u0003\u00026e\t\u0011B+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u001d9\u0004\u00011A\u0005\u0002a\n\u0001\u0004^5feB\u000b'\u000f^5uS>t7\u000b^1uK~\u000bt\fJ3r)\tID\b\u0005\u0002\u000eu%\u00111H\u0004\u0002\u0005+:LG\u000fC\u0004>m\u0005\u0005\t\u0019\u0001\u0019\u0002\u0007a$\u0013\u0007\u0003\u0004@\u0001\u0001\u0006K\u0001M\u0001\u0016i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XmX\u0019!\u0011\u001d\t\u0005A1A\u0005\u0002e\ta\u0001^8qS\u000e\u0014\u0004BB\"\u0001A\u0003%!$A\u0004u_BL7M\r\u0011\t\u000f\u0015\u0003!\u0019!C\u0001M\u0005\u0011Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\03\u0011\u00199\u0005\u0001)A\u0005O\u0005\u0019Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\03A!9\u0011\n\u0001a\u0001\n\u0003y\u0013\u0001\u0006;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016|&\u0007C\u0004L\u0001\u0001\u0007I\u0011\u0001'\u00021QLWM\u001d)beRLG/[8o'R\fG/Z03?\u0012*\u0017\u000f\u0006\u0002:\u001b\"9QHSA\u0001\u0002\u0004\u0001\u0004BB(\u0001A\u0003&\u0001'A\u000buS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,wL\r\u0011\t\u000fE\u0003!\u0019!C\u00013\u00051Ao\u001c9jGNBaa\u0015\u0001!\u0002\u0013Q\u0012a\u0002;pa&\u001c7\u0007\t\u0005\b+\u0002\u0011\r\u0011\"\u0001'\u0003I!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|gnX\u001a\t\r]\u0003\u0001\u0015!\u0003(\u0003M!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|gnX\u001a!\u0011\u001dI\u0006A1A\u0005\u0002i\u000baBZ3oG\u0016$7+Z4nK:$8/F\u0001\\!\ra\u0016mY\u0007\u0002;*\u0011alX\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u0019\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002c;\n!A*[:u!\t!w-D\u0001f\u0015\t1g!\u0001\u0004e_6\f\u0017N\\\u0005\u0003Q\u0016\u0014!\u0003V5fe>\u0013'.Z2u\u001b\u0016$\u0018\rZ1uC\"1!\u000e\u0001Q\u0001\nm\u000bqBZ3oG\u0016$7+Z4nK:$8\u000f\t\u0005\bY\u0002\u0001\r\u0011\"\u00010\u0003Q!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3`g!9a\u000e\u0001a\u0001\n\u0003y\u0017\u0001\u0007;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016|6g\u0018\u0013fcR\u0011\u0011\b\u001d\u0005\b{5\f\t\u00111\u00011\u0011\u0019\u0011\b\u0001)Q\u0005a\u0005)B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f?N\u0002\u0003b\u0002;\u0001\u0005\u0004%\t!^\u0001\u0004GRDX#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005e4\u0011a\u00024fi\u000eDWM]\u0005\u0003wb\u00141cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqRDa! \u0001!\u0002\u00131\u0018\u0001B2uq\u0002B\u0001b \u0001C\u0002\u0013\u0005\u0011\u0011A\u0001\u0011i&,'\u000fV8qS\u000el\u0015M\\1hKJ,\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003\u0007\u0003\u0015!x\u000e]5d\u0013\u0011\ti!a\u0002\u0003!QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\b\u0002CA\t\u0001\u0001\u0006I!a\u0001\u0002#QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\b\u0005C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0001\u0002\u0018\u0005yA/[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 \u0019\tQa\u001d;pe\u0016LA!a\t\u0002\u001e\tyA+[3s\u001f\nTWm\u0019;Ti>\u0014X\r\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\r\u0003A!\u0018.\u001a:PE*,7\r^*u_J,\u0007\u0005C\u0005\u0002,\u0001\u0011\r\u0011\"\u0001\u0002\u0018\u0005QR\r_2faRLwN\\1m)&,'o\u00142kK\u000e$8\u000b^8sK\"A\u0011q\u0006\u0001!\u0002\u0013\tI\"A\u000efq\u000e,\u0007\u000f^5p]\u0006dG+[3s\u001f\nTWm\u0019;Ti>\u0014X\r\t\u0005\n\u0003g\u0001!\u0019!C\u0001\u0003k\taB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u00028A!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>!\taa]3sm\u0016\u0014\u0018\u0002BA!\u0003w\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001c\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003\"CA%\u0001\t\u0007I\u0011AA&\u0003\u0011!\u0018.\\3\u0016\u0005\u00055\u0003\u0003BA(\u0003Gj!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0006kRLGn\u001d\u0006\u0005\u0003/\nI&\u0001\u0004d_6lwN\u001c\u0006\u0004\u0013\u0005m#\u0002BA/\u0003?\na!\u00199bG\",'BAA1\u0003\ry'oZ\u0005\u0005\u0003K\n\tF\u0001\u0005N_\u000e\\G+[7f\u0011!\tI\u0007\u0001Q\u0001\n\u00055\u0013!\u0002;j[\u0016\u0004\u0003\"CA7\u0001\t\u0007I\u0011AA8\u0003\u001d!X\u000e\u001d$jY\u0016,\"!!\u001d\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e\u001f\u0003\tIw.\u0003\u0003\u0002|\u0005U$\u0001\u0002$jY\u0016D\u0001\"a \u0001A\u0003%\u0011\u0011O\u0001\ti6\u0004h)\u001b7fA!Y\u00111\u0011\u0001A\u0002\u0003\u0007I\u0011AAC\u0003UawnZ,ji\"$\u0016.\u001a:fIN+w-\\3oiN,\"!a\"\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$\t\u0003\rawnZ\u0005\u0005\u0003#\u000bYIA\u0006BEN$(/Y2u\u0019><\u0007bCAK\u0001\u0001\u0007\t\u0019!C\u0001\u0003/\u000b\u0011\u0004\\8h/&$\b\u000eV5fe\u0016$7+Z4nK:$8o\u0018\u0013fcR\u0019\u0011(!'\t\u0013u\n\u0019*!AA\u0002\u0005\u001d\u0005\u0002CAO\u0001\u0001\u0006K!a\"\u0002-1|wmV5uQRKWM]3e'\u0016<W.\u001a8ug\u0002B1\"!)\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0006\u0006AQ-\u001c9us2{w\rC\u0006\u0002&\u0002\u0001\r\u00111A\u0005\u0002\u0005\u001d\u0016\u0001D3naRLHj\\4`I\u0015\fHcA\u001d\u0002*\"IQ(a)\u0002\u0002\u0003\u0007\u0011q\u0011\u0005\t\u0003[\u0003\u0001\u0015)\u0003\u0002\b\u0006IQ-\u001c9us2{w\r\t\u0005\f\u0003c\u0003\u0001\u0019!a\u0001\n\u0003\t))\u0001\u0010f[B$\u0018\u0010T8h/&$\b\u000eV5fe\u001a+gnY3e'\u0016<W.\u001a8ug\"Y\u0011Q\u0017\u0001A\u0002\u0003\u0007I\u0011AA\\\u0003\t*W\u000e\u001d;z\u0019><w+\u001b;i)&,'OR3oG\u0016$7+Z4nK:$8o\u0018\u0013fcR\u0019\u0011(!/\t\u0013u\n\u0019,!AA\u0002\u0005\u001d\u0005\u0002CA_\u0001\u0001\u0006K!a\"\u0002?\u0015l\u0007\u000f^=M_\u001e<\u0016\u000e\u001e5US\u0016\u0014h)\u001a8dK\u0012\u001cVmZ7f]R\u001c\b\u0005C\u0004\u0002B\u0002!\t!a1\u0002\u000bM,G/\u001e9\u0015\u0003eBC!a0\u0002HB!\u0011\u0011ZAh\u001b\t\tYM\u0003\u0003\u0002N\u0006}\u0013!\u00026v]&$\u0018\u0002BAi\u0003\u0017\u0014aAQ3g_J,\u0007bBAk\u0001\u0011\u0005\u00111Y\u0001\ti\u0016\f'\u000fZ8x]\"\"\u00111[Am!\u0011\tI-a7\n\t\u0005u\u00171\u001a\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003C\u0004A\u0011AAb\u0003q!Xm\u001d;D_2dWm\u0019;EK2,G/\u00192mKN+w-\\3oiNDC!a8\u0002fB!\u0011\u0011ZAt\u0013\u0011\tI/a3\u0003\tQ+7\u000f\u001e\u0005\b\u0003[\u0004A\u0011AAb\u0003\t\"Xm\u001d;D_2dWm\u0019;GK:\u001cW\r\u001a#fY\u0016$\u0018M\u00197f'\u0016<W.\u001a8ug\"\"\u00111^As\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003\u0007\fA\u0005^3ti\u000e{G\u000e\\3di\u0012+G.\u001a;bE2,7+Z4nK:$8/R7qifdun\u001a\u0015\u0005\u0003c\f)\u000fC\u0004\u0002z\u0002!\t!a1\u0002%Q,7\u000f^%oSRL\u0017\r^3EK2,G/\u001a\u0015\u0005\u0003o\f)\u000fC\u0004\u0002\u0000\u0002!\t!a1\u0002KQ,7\u000f^%oSRL\u0017\r^3EK2,G/Z$fi:+\u0007\u0010^*fO6,g\u000e\u001e#fY\u0006L\b\u0006BA\u007f\u0003KDqA!\u0002\u0001\t\u0003\t\u0019-A\u000euKN$\u0018J\\5uS\u0006$X\rR3mKR,w+\u001b;i\t\u0016d\u0017-\u001f\u0015\u0005\u0005\u0007\t)\u000fC\u0004\u0003\f\u0001!\t!a1\u0002\u0015Q,7\u000f\u001e#fY\u0016$X\r\u000b\u0003\u0003\n\u0005\u0015\bb\u0002B\t\u0001\u0011\u0005\u00111Y\u0001'i\u0016\u001cH\u000fR3mKR,7+Z4nK:$H+[3s\u001f\nTWm\u0019;Ti>\u0014X\r\u00165s_^\u001c\b\u0006\u0002B\b\u0003KDqAa\u0006\u0001\t\u0003\t\u0019-\u0001\u0017uKN$h)\u001a8dK\u0012$U\r\\3uKN+w-\\3oiRKWM](cU\u0016\u001cGo\u0015;pe\u0016$\u0006N]8xg\"\"!QCAs\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003\u0007\f!\u0003^3ti\u000e{W\u000e\u001d7fi\u0016$U\r\\3uK\"\"!1DAs\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003\u0007\fa\u0003^3ti\u000e{W\u000e\u001d7fi\u0016\fE\u000e\u001c#fY\u0016$Xm\u001d\u0015\u0005\u0005C\t)\u000fC\u0004\u0003*\u0001!\t!a1\u0002OQ,7\u000f\u001e#fY\u0016$X\rU1si&$\u0018n\u001c8XSRDgj\u001c+jKJ,GmU3h[\u0016tGo\u001d\u0015\u0005\u0005O\t)\u000fC\u0004\u00030\u0001!IA!\r\u0002!QLWM]3e\u0019><7+Z4nK:$H\u0003\u0003B\u001a\u0005s\u0011iDa\u0012\u0011\t\u0005%%QG\u0005\u0005\u0005o\tYI\u0001\bUS\u0016\u0014Hj\\4TK\u001elWM\u001c;\t\u000f\tm\"Q\u0006a\u0001O\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\t\u0005\u007f\u0011i\u00031\u0001\u0003B\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0011\u00075\u0011\u0019%C\u0002\u0003F9\u0011A\u0001T8oO\"A!\u0011\nB\u0017\u0001\u0004\u0011\t%A\u0005f]\u0012|eMZ:fi\"9!Q\n\u0001\u0005\n\t=\u0013AD7pG.dunZ*fO6,g\u000e\u001e\u000b\t\u0005#\u00129F!\u0017\u0003\\A!\u0011\u0011\u0012B*\u0013\u0011\u0011)&a#\u0003\u00151{wmU3h[\u0016tG\u000f\u0003\u0005\u0002n\t-\u0003\u0019AA9\u0011!\u0011yDa\u0013A\u0002\t\u0005\u0003\u0002\u0003B%\u0005\u0017\u0002\rA!\u0011\t\u000f\t}\u0003\u0001\"\u0003\u0003b\u00051Rn\\2l)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\rF\u00031\u0005G\u0012i\u0007\u0003\u0005\u0003f\tu\u0003\u0019\u0001B4\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u00075\u0011I'C\u0002\u0003l9\u00111!\u00138u\u0011%I&Q\fI\u0001\u0002\u0004\u0011y\u0007E\u0003\u0003r\t\u00055M\u0004\u0003\u0003t\tud\u0002\u0002B;\u0005wj!Aa\u001e\u000b\u0007\te$\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0019!q\u0010\b\u0002\u000fA\f7m[1hK&\u0019!Ma!\u000b\u0007\t}d\u0002C\u0004\u0003\b\u0002!IA!#\u0002\u001f5|7m[!cgR\u0014\u0018m\u0019;M_\u001e$b!a\"\u0003\f\nE\u0005\u0002\u0003BG\u0005\u000b\u0003\rAa$\u0002\u001dQLWM]3e'\u0016<W.\u001a8ugB1!\u0011\u000fBA\u0005gA\u0001Ba%\u0003\u0006\u0002\u0007!QS\u0001\u000eY>\u001c\u0017\r\\*fO6,g\u000e^:\u0011\r\tE$\u0011\u0011B)\u0011%\u0011I\nAI\u0001\n\u0013\u0011Y*\u0001\u0011n_\u000e\\G+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fI\u0011,g-Y;mi\u0012\u0012TC\u0001BOU\u0011\u0011yGa(,\u0005\t\u0005\u0006\u0003\u0002BR\u0005[k!A!*\u000b\t\t\u001d&\u0011V\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa+\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005_\u0013)KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DeletionTaskTest {
    private final String topic1;
    private final TopicIdPartition topicIdPartition_1 = new TopicIdPartition(this.topic1(), UUID.randomUUID(), 0);
    private TierPartitionState tierPartitionState_1 = this.mockTierPartitionState(0, this.mockTierPartitionState$default$2());
    private final String topic2;
    private final TopicIdPartition topicIdPartition_2 = new TopicIdPartition(this.topic2(), UUID.randomUUID(), 0);
    private TierPartitionState tierPartitionState_2 = this.mockTierPartitionState(0, this.mockTierPartitionState$default$2());
    private final String topic3;
    private final TopicIdPartition topicIdPartition_3 = new TopicIdPartition(this.topic3(), UUID.randomUUID(), 0);
    private final List<TierObjectMetadata> fencedSegments = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TierObjectMetadata[]{new TierObjectMetadata(this.topicIdPartition_3(), 0, UUID.randomUUID(), 100L, 3252334L, 1000L, 102, TierObjectMetadata.State.SEGMENT_FENCED, true, false, false), new TierObjectMetadata(this.topicIdPartition_3(), 0, UUID.randomUUID(), 4252334L, 5252334L, 5000L, 102, TierObjectMetadata.State.SEGMENT_FENCED, true, false, false)}));
    private TierPartitionState tierPartitionState_3 = this.mockTierPartitionState(0, this.fencedSegments());
    private final CancellationContext ctx = CancellationContext.newContext();
    private final TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private final TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final TierObjectStore exceptionalTierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final MockTime time = new MockTime();
    private final File tmpFile = TestUtils$.MODULE$.tempFile();
    private AbstractLog logWithTieredSegments;
    private AbstractLog emptyLog;
    private AbstractLog emptyLogWithTierFencedSegments;

    public String topic1() {
        return this.topic1;
    }

    public TopicIdPartition topicIdPartition_1() {
        return this.topicIdPartition_1;
    }

    public TierPartitionState tierPartitionState_1() {
        return this.tierPartitionState_1;
    }

    public void tierPartitionState_1_$eq(TierPartitionState x$1) {
        this.tierPartitionState_1 = x$1;
    }

    public String topic2() {
        return this.topic2;
    }

    public TopicIdPartition topicIdPartition_2() {
        return this.topicIdPartition_2;
    }

    public TierPartitionState tierPartitionState_2() {
        return this.tierPartitionState_2;
    }

    public void tierPartitionState_2_$eq(TierPartitionState x$1) {
        this.tierPartitionState_2 = x$1;
    }

    public String topic3() {
        return this.topic3;
    }

    public TopicIdPartition topicIdPartition_3() {
        return this.topicIdPartition_3;
    }

    public List<TierObjectMetadata> fencedSegments() {
        return this.fencedSegments;
    }

    public TierPartitionState tierPartitionState_3() {
        return this.tierPartitionState_3;
    }

    public void tierPartitionState_3_$eq(TierPartitionState x$1) {
        this.tierPartitionState_3 = x$1;
    }

    public CancellationContext ctx() {
        return this.ctx;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public TierObjectStore exceptionalTierObjectStore() {
        return this.exceptionalTierObjectStore;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpFile() {
        return this.tmpFile;
    }

    public AbstractLog logWithTieredSegments() {
        return this.logWithTieredSegments;
    }

    public void logWithTieredSegments_$eq(AbstractLog x$1) {
        this.logWithTieredSegments = x$1;
    }

    public AbstractLog emptyLog() {
        return this.emptyLog;
    }

    public void emptyLog_$eq(AbstractLog x$1) {
        this.emptyLog = x$1;
    }

    public AbstractLog emptyLogWithTierFencedSegments() {
        return this.emptyLogWithTierFencedSegments;
    }

    public void emptyLogWithTierFencedSegments_$eq(AbstractLog x$1) {
        this.emptyLogWithTierFencedSegments = x$1;
    }

    @Before
    public void setup() {
        LongRef baseOffset = LongRef.create((long)100L);
        ListBuffer tieredSegments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer localSegments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach$mVc$sp((Function1)new Serializable(this, baseOffset, tieredSegments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeletionTaskTest $outer;
            private final LongRef baseOffset$1;
            private final ListBuffer tieredSegments$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                TierLogSegment segment = this.$outer.kafka$tier$tasks$delete$DeletionTaskTest$$tieredLogSegment(this.$outer.topicIdPartition_1(), this.baseOffset$1.elem, this.baseOffset$1.elem + 50L);
                this.baseOffset$1.elem += 51L;
                this.tieredSegments$1.$plus$eq((Object)segment);
                this.$outer.time().sleep(50L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.baseOffset$1 = baseOffset$1;
                this.tieredSegments$1 = tieredSegments$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1)new Serializable(this, baseOffset, localSegments){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeletionTaskTest $outer;
            private final LongRef baseOffset$1;
            private final ListBuffer localSegments$1;

            public final ListBuffer<LogSegment> apply(int _) {
                LogSegment segment = this.$outer.kafka$tier$tasks$delete$DeletionTaskTest$$mockLogSegment(this.$outer.tmpFile(), this.baseOffset$1.elem, this.baseOffset$1.elem + 50L);
                this.baseOffset$1.elem += 51L;
                return this.localSegments$1.$plus$eq((Object)segment);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.baseOffset$1 = baseOffset$1;
                this.localSegments$1 = localSegments$1;
            }
        });
        Properties properties = new Properties();
        properties.put(LogConfig$.MODULE$.RetentionMsProp(), "300");
        LogConfig logConfig = new LogConfig((Map)properties, LogConfig$.MODULE$.apply$default$2());
        this.logWithTieredSegments_$eq(this.mockAbstractLog((List<TierLogSegment>)tieredSegments.toList(), (List<LogSegment>)localSegments.toList()));
        Mockito.when((Object)this.logWithTieredSegments().config()).thenReturn((Object)logConfig);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)this.logWithTieredSegments().logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        ((AbstractLog)Mockito.doAnswer((Answer)new Answer<Object>(this){
            private final /* synthetic */ DeletionTaskTest $outer;

            public Object answer(InvocationOnMock invocation) {
                long newStartOffset = BoxesRunTime.unboxToLong((Object)invocation.getArgument(0));
                return this.$outer.logWithTieredSegments().logStartOffset() < newStartOffset ? Mockito.when((Object)BoxesRunTime.boxToLong((long)this.$outer.logWithTieredSegments().logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)newStartOffset)) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).when((Object)this.logWithTieredSegments())).maybeIncrementLogStartOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()));
        this.emptyLog_$eq(this.mockAbstractLog((List<TierLogSegment>)List$.MODULE$.empty(), (List<LogSegment>)List$.MODULE$.empty()));
        Mockito.when((Object)this.emptyLog().config()).thenReturn((Object)logConfig);
        this.emptyLogWithTierFencedSegments_$eq(this.mockAbstractLog((List<TierLogSegment>)List$.MODULE$.empty(), (List<LogSegment>)List$.MODULE$.empty()));
        Mockito.when((Object)this.emptyLogWithTierFencedSegments().config()).thenReturn((Object)logConfig);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition_1().topicPartition())).thenReturn((Object)new Some((Object)this.logWithTieredSegments()));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition_2().topicPartition())).thenReturn((Object)new Some((Object)this.emptyLog()));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition_3().topicPartition())).thenReturn((Object)new Some((Object)this.emptyLogWithTierFencedSegments()));
        Mockito.when((Object)this.logWithTieredSegments().tierPartitionState()).thenReturn((Object)this.tierPartitionState_1());
        Mockito.when((Object)this.emptyLog().tierPartitionState()).thenReturn((Object)this.tierPartitionState_2());
        Mockito.when((Object)this.emptyLogWithTierFencedSegments().tierPartitionState()).thenReturn((Object)this.tierPartitionState_3());
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        this.exceptionalTierObjectStore().deleteSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("test exception", new Throwable("test exception from object store"))});
    }

    @After
    public void teardown() {
        this.tmpFile().delete();
    }

    @Test
    public void testCollectDeletableSegments() {
        DeletionTask.CollectDeletableSegments state = new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0));
        Future future = state.transition(this.topicIdPartition_1(), this.replicaManager(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), (Time)this.time(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask.State nextState = (DeletionTask.State)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.InitiateDelete.class, nextState.getClass());
        DeletionTask.InitiateDelete initiateDelete = (DeletionTask.InitiateDelete)nextState;
        Assert.assertTrue((boolean)initiateDelete.toDelete().nonEmpty());
    }

    @Test
    public void testCollectFencedDeletableSegments() {
        DeletionTask.CollectDeletableSegments state = new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0));
        Future future = state.transition(this.topicIdPartition_3(), this.replicaManager(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), (Time)this.time(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask.State nextState = (DeletionTask.State)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.InitiateDelete.class, nextState.getClass());
        DeletionTask.InitiateDelete initiateDelete = (DeletionTask.InitiateDelete)nextState;
        Assert.assertTrue((boolean)initiateDelete.toDelete().nonEmpty());
        Set expectedObjectIds = ((TraversableOnce)this.fencedSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(TierObjectMetadata fs) {
                return fs.objectId();
            }
        }, List$.MODULE$.canBuildFrom())).toSet();
        Set deletableObjectIds = ((TraversableOnce)initiateDelete.toDelete().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UUID apply(DeletionTask.DeleteObjectMetadata e) {
                return e.objectMetadata().objectId();
            }
        }, Queue$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((Object)expectedObjectIds, (Object)deletableObjectIds);
    }

    @Test
    public void testCollectDeletableSegmentsEmptyLog() {
        DeletionTask.CollectDeletableSegments state = new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0));
        Future future = state.transition(this.topicIdPartition_2(), this.replicaManager(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), (Time)this.time(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask.State nextState = (DeletionTask.State)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.CollectDeletableSegments.class, nextState.getClass());
    }

    @Test
    public void testInitiateDelete() {
        Iterable toDelete = (Iterable)((TraversableLike)((TraversableLike)this.logWithTieredSegments().tieredLogSegments().take(3)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TierObjectStore.ObjectMetadata apply(TierLogSegment x$1) {
                return x$1.metadata();
            }
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DeletionTask.DeleteObjectMetadata apply(TierObjectStore.ObjectMetadata x$2) {
                return new DeletionTask.DeleteObjectMetadata(x$2, (Option)None$.MODULE$);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        DeletionTask.InitiateDelete initiateDelete = new DeletionTask.InitiateDelete((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0), (Queue)toDelete.to(Queue$.MODULE$.canBuildFrom()));
        Assert.assertEquals((long)0L, (long)initiateDelete.getNextSegmentDelay(this.time().hiResClockMs()));
        Future future = initiateDelete.transition(this.topicIdPartition_1(), this.replicaManager(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), (Time)this.time(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask.State nextState = (DeletionTask.State)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.Delete.class, nextState.getClass());
        DeletionTask.Delete delete = (DeletionTask.Delete)nextState;
        Assert.assertEquals((long)toDelete.size(), (long)delete.toDelete().size());
        DeletionTask.DeleteObjectMetadata firstSegment = (DeletionTask.DeleteObjectMetadata)toDelete.head();
        TierSegmentDeleteInitiate expected = new TierSegmentDeleteInitiate(this.topicIdPartition_1(), 0, firstSegment.objectMetadata().objectId());
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)1))).addMetadata((AbstractTierMetadata)expected);
    }

    @Test
    public void testInitiateDeleteGetNextSegmentDelay() {
        long nowMs = this.time().hiResClockMs();
        int anyFenceDelayMs = 10;
        long timeToDelete = Math.addExact(nowMs, (long)anyFenceDelayMs);
        List toDelete = (List)((List)this.fencedSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TierObjectStore.ObjectMetadata apply(TierObjectMetadata x$3) {
                return new TierObjectStore.ObjectMetadata(x$3);
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, timeToDelete){
            public static final long serialVersionUID = 0L;
            private final long timeToDelete$1;

            public final DeletionTask.DeleteObjectMetadata apply(TierObjectStore.ObjectMetadata x$4) {
                return new DeletionTask.DeleteObjectMetadata(x$4, (Option)new Some((Object)BoxesRunTime.boxToLong((long)this.timeToDelete$1)));
            }
            {
                this.timeToDelete$1 = timeToDelete$1;
            }
        }, List$.MODULE$.canBuildFrom());
        DeletionTask.InitiateDelete initiateDelete = new DeletionTask.InitiateDelete((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0), (Queue)toDelete.to(Queue$.MODULE$.canBuildFrom()));
        this.time().sleep(4L);
        int elapsedTime = 4;
        int expectedDelay = Math.subtractExact(anyFenceDelayMs, elapsedTime);
        Assert.assertEquals((long)expectedDelay, (long)initiateDelete.getNextSegmentDelay(this.time().hiResClockMs()));
        this.time().sleep(8L);
        expectedDelay = Math.subtractExact(anyFenceDelayMs, elapsedTime += 8);
        Assert.assertEquals((long)expectedDelay, (long)initiateDelete.getNextSegmentDelay(this.time().hiResClockMs()));
    }

    @Test
    public void testInitiateDeleteWithDelay() {
        DeletionTask task = new DeletionTask(this.ctx().subContext(), this.topicIdPartition_3(), 5L, (DeletionTask.State)new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0)), DeletionTask$.MODULE$.$lessinit$greater$default$5());
        long timeBeforeTransitionMs = this.time().hiResClockMs();
        Future futureTask = task.transition((Time)this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)futureTask, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask nextTask = (DeletionTask)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.InitiateDelete.class, nextTask.state().getClass());
        Assert.assertTrue((boolean)task.pausedUntil().isDefined());
        Assert.assertEquals((Object)Instant.ofEpochMilli(timeBeforeTransitionMs).plusMillis(DeletionTask$.MODULE$.FencedSegmentDeleteDelayMs()), (Object)task.pausedUntil().get());
    }

    @Test
    public void testDelete() {
        Iterable toDelete = (Iterable)((TraversableLike)((TraversableLike)this.logWithTieredSegments().tieredLogSegments().take(3)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TierObjectStore.ObjectMetadata apply(TierLogSegment x$5) {
                return x$5.metadata();
            }
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeletionTaskTest $outer;

            public final DeletionTask.DeleteObjectMetadata apply(TierObjectStore.ObjectMetadata x$6) {
                return new DeletionTask.DeleteObjectMetadata(x$6, (Option)new Some((Object)BoxesRunTime.boxToLong((long)this.$outer.time().milliseconds())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        DeletionTask.Delete delete = new DeletionTask.Delete((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0), (Queue)toDelete.to(Queue$.MODULE$.canBuildFrom()));
        Future future = delete.transition(this.topicIdPartition_1(), this.replicaManager(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), (Time)this.time(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask.State nextState = (DeletionTask.State)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.CompleteDelete.class, nextState.getClass());
        DeletionTask.CompleteDelete completeDelete = (DeletionTask.CompleteDelete)nextState;
        Assert.assertEquals((long)toDelete.size(), (long)completeDelete.toDelete().size());
        ((TierObjectStore)Mockito.verify((Object)this.tierObjectStore(), (VerificationMode)Mockito.times((int)1))).deleteSegment(((DeletionTask.DeleteObjectMetadata)toDelete.head()).objectMetadata());
    }

    @Test
    public void testDeleteSegmentTierObjectStoreThrows() {
        DeletionTask task = new DeletionTask(this.ctx().subContext(), this.topicIdPartition_1(), 5L, (DeletionTask.State)new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0)), DeletionTask$.MODULE$.$lessinit$greater$default$5());
        Future futureTask = task.transition((Time)this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)futureTask, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask nextTask = (DeletionTask)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.InitiateDelete.class, nextTask.state().getClass());
        DeletionTask qual$1 = nextTask;
        MockTime x$11 = this.time();
        TierTopicManager x$12 = this.tierTopicManager();
        TierObjectStore x$13 = this.tierObjectStore();
        ReplicaManager x$14 = this.replicaManager();
        Option x$15 = qual$1.transition$default$5();
        futureTask = qual$1.transition((Time)x$11, (TierTopicAppender)x$12, x$13, x$14, x$15, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        result = (Future)Await$.MODULE$.ready((Awaitable)futureTask, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        nextTask = (DeletionTask)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.Delete.class, nextTask.state().getClass());
        DeletionTask qual$2 = nextTask;
        MockTime x$16 = this.time();
        TierTopicManager x$17 = this.tierTopicManager();
        TierObjectStore x$18 = this.exceptionalTierObjectStore();
        ReplicaManager x$19 = this.replicaManager();
        Option x$20 = qual$2.transition$default$5();
        futureTask = qual$2.transition((Time)x$16, (TierTopicAppender)x$17, x$18, x$19, x$20, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        result = (Future)Await$.MODULE$.ready((Awaitable)futureTask, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        nextTask = (DeletionTask)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.Delete.class, nextTask.state().getClass());
        DeletionTask qual$3 = nextTask;
        MockTime x$21 = this.time();
        TierTopicManager x$22 = this.tierTopicManager();
        TierObjectStore x$23 = this.tierObjectStore();
        ReplicaManager x$24 = this.replicaManager();
        Option x$25 = qual$3.transition$default$5();
        futureTask = qual$3.transition((Time)x$21, (TierTopicAppender)x$22, x$23, x$24, x$25, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        result = (Future)Await$.MODULE$.ready((Awaitable)futureTask, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        nextTask = (DeletionTask)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.CompleteDelete.class, nextTask.state().getClass());
    }

    @Test
    public void testFencedDeleteSegmentTierObjectStoreThrows() {
        DeletionTask task = new DeletionTask(this.ctx().subContext(), this.topicIdPartition_3(), 5L, (DeletionTask.State)new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0)), DeletionTask$.MODULE$.$lessinit$greater$default$5());
        Future futureTask = task.transition((Time)this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)futureTask, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask nextTask = (DeletionTask)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.InitiateDelete.class, nextTask.state().getClass());
        DeletionTask qual$4 = nextTask;
        MockTime x$26 = this.time();
        TierTopicManager x$27 = this.tierTopicManager();
        TierObjectStore x$28 = this.tierObjectStore();
        ReplicaManager x$29 = this.replicaManager();
        Option x$30 = qual$4.transition$default$5();
        futureTask = qual$4.transition((Time)x$26, (TierTopicAppender)x$27, x$28, x$29, x$30, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        result = (Future)Await$.MODULE$.ready((Awaitable)futureTask, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        nextTask = (DeletionTask)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.Delete.class, nextTask.state().getClass());
        DeletionTask qual$5 = nextTask;
        MockTime x$31 = this.time();
        TierTopicManager x$32 = this.tierTopicManager();
        TierObjectStore x$33 = this.exceptionalTierObjectStore();
        ReplicaManager x$34 = this.replicaManager();
        Option x$35 = qual$5.transition$default$5();
        futureTask = qual$5.transition((Time)x$31, (TierTopicAppender)x$32, x$33, x$34, x$35, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        result = (Future)Await$.MODULE$.ready((Awaitable)futureTask, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        nextTask = (DeletionTask)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.Delete.class, nextTask.state().getClass());
        DeletionTask qual$6 = nextTask;
        MockTime x$36 = this.time();
        TierTopicManager x$37 = this.tierTopicManager();
        TierObjectStore x$38 = this.tierObjectStore();
        ReplicaManager x$39 = this.replicaManager();
        Option x$40 = qual$6.transition$default$5();
        futureTask = qual$6.transition((Time)x$36, (TierTopicAppender)x$37, x$38, x$39, x$40, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        result = (Future)Await$.MODULE$.ready((Awaitable)futureTask, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        nextTask = (DeletionTask)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.CompleteDelete.class, nextTask.state().getClass());
    }

    @Test
    public void testCompleteDelete() {
        Iterable toDelete = (Iterable)((TraversableLike)((TraversableLike)this.logWithTieredSegments().tieredLogSegments().take(3)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TierObjectStore.ObjectMetadata apply(TierLogSegment x$7) {
                return x$7.metadata();
            }
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DeletionTask.DeleteObjectMetadata apply(TierObjectStore.ObjectMetadata x$8) {
                return new DeletionTask.DeleteObjectMetadata(x$8, (Option)None$.MODULE$);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        DeletionTask.CompleteDelete completeDelete = new DeletionTask.CompleteDelete((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0), (Queue)toDelete.to(Queue$.MODULE$.canBuildFrom()));
        Future future = completeDelete.transition(this.topicIdPartition_1(), this.replicaManager(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), (Time)this.time(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask.State nextState = (DeletionTask.State)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.InitiateDelete.class, nextState.getClass());
        DeletionTask.InitiateDelete initiateDelete = (DeletionTask.InitiateDelete)nextState;
        Assert.assertEquals((Object)toDelete.tail(), (Object)initiateDelete.toDelete());
        DeletionTask.DeleteObjectMetadata firstSegment = (DeletionTask.DeleteObjectMetadata)toDelete.head();
        TierSegmentDeleteComplete expected = new TierSegmentDeleteComplete(this.topicIdPartition_1(), 0, firstSegment.objectMetadata().objectId());
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)1))).addMetadata((AbstractTierMetadata)expected);
    }

    @Test
    public void testCompleteAllDeletes() {
        Iterable toDelete = (Iterable)((TraversableLike)((TraversableLike)this.logWithTieredSegments().tieredLogSegments().take(1)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TierObjectStore.ObjectMetadata apply(TierLogSegment x$9) {
                return x$9.metadata();
            }
        }, Iterable$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DeletionTask.DeleteObjectMetadata apply(TierObjectStore.ObjectMetadata x$10) {
                return new DeletionTask.DeleteObjectMetadata(x$10, (Option)None$.MODULE$);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        DeletionTask.CompleteDelete completeDelete = new DeletionTask.CompleteDelete((DeletionTask.StateMetadata)new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager(), 0), (Queue)toDelete.to(Queue$.MODULE$.canBuildFrom()));
        Future future = completeDelete.transition(this.topicIdPartition_1(), this.replicaManager(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), (Time)this.time(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask.State nextState = (DeletionTask.State)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.CollectDeletableSegments.class, nextState.getClass());
    }

    @Test
    public void testDeletePartitionWithNoTieredSegments() {
        DeletionTask.CollectDeletableSegments collectDeletableSegments = new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)new DeletionTask.DeletedPartitionMetadata(List$.MODULE$.empty()));
        Future future = collectDeletableSegments.transition(this.topicIdPartition_1(), this.replicaManager(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), (Time)this.time(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Future result = (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        DeletionTask.State nextState = (DeletionTask.State)((Try)result.value().get()).get();
        Assert.assertEquals(DeletionTask.PartitionDeleteComplete.class, nextState.getClass());
    }

    public TierLogSegment kafka$tier$tasks$delete$DeletionTaskTest$$tieredLogSegment(TopicIdPartition topicIdPartition, long baseOffset, long endOffset) {
        TierLogSegment segment = (TierLogSegment)Mockito.mock(TierLogSegment.class);
        int size2 = 200;
        TierObjectMetadata.State state = TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE;
        TierObjectMetadata metadata = new TierObjectMetadata(topicIdPartition, 0, UUID.randomUUID(), baseOffset, endOffset, this.time().milliseconds(), size2, state, true, false, true);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segment.startOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)baseOffset));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segment.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)endOffset));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segment.nextOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)(endOffset + 1L)));
        Mockito.when((Object)segment.metadata()).thenReturn((Object)new TierObjectStore.ObjectMetadata(metadata));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segment.maxTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.time().milliseconds()));
        return segment;
    }

    public LogSegment kafka$tier$tasks$delete$DeletionTaskTest$$mockLogSegment(File tmpFile, long baseOffset, long endOffset) {
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.mock(OffsetIndex.class);
        Mockito.when((Object)offsetIndex.file()).thenReturn((Object)tmpFile);
        TimeIndex timeIndex = (TimeIndex)Mockito.mock(TimeIndex.class);
        Mockito.when((Object)timeIndex.file()).thenReturn((Object)tmpFile);
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        Mockito.when((Object)fileRecords.file()).thenReturn((Object)tmpFile);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.readNextOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)(endOffset + 1L)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.baseOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)baseOffset));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.largestTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.time().milliseconds()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1000));
        Mockito.when((Object)logSegment.log()).thenReturn((Object)fileRecords);
        Mockito.when((Object)logSegment.offsetIndex()).thenReturn((Object)offsetIndex);
        Mockito.when((Object)logSegment.timeIndex()).thenReturn((Object)timeIndex);
        return logSegment;
    }

    /*
     * WARNING - void declaration
     */
    private TierPartitionState mockTierPartitionState(int leaderEpoch, List<TierObjectMetadata> fencedSegments) {
        void var3_3;
        TierPartitionState tierPartitionState2 = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState2.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)tierPartitionState2.fencedSegments()).thenReturn(JavaConverters$.MODULE$.seqAsJavaListConverter(fencedSegments).asJava());
        return var3_3;
    }

    private List<TierObjectMetadata> mockTierPartitionState$default$2() {
        return List$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog mockAbstractLog(List<TierLogSegment> tieredSegments, List<LogSegment> localSegments) {
        void var3_3;
        AbstractLog log2 = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log2.tieredLogSegments()).thenReturn(tieredSegments);
        Mockito.when((Object)log2.tierableLogSegments()).thenReturn(localSegments);
        return var3_3;
    }

    public DeletionTaskTest() {
        this.topic1 = "foo-0";
        this.topic2 = "foo-1";
        this.topic3 = "foo-2";
    }
}

