/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.Properties;
import java.util.UUID;
import kafka.tier.tools.TierMetadataDebugger;
import kafka.tier.tools.TierTopicMaterializationToolConfig;
import kafka.tier.tools.TierTopicMaterializationUtils;
import kafka.utils.CoreUtils;
import org.junit.Assert;
import org.junit.Test;

public class TierTopicMaterializationUtilsTest {
    @Test
    public void TierTopicMaterializationToolTest() {
        UUID uuid = UUID.randomUUID();
        Properties props = new Properties();
        props.put("bootstrap-server", "localhost:9092");
        props.put("source-topic-id", CoreUtils.uuidToBase64((UUID)uuid));
        props.put("source-partition", "10");
        props.put("start-offset", "4");
        props.put("working-dir", "/tmp/path");
        TierTopicMaterializationToolConfig config = new TierTopicMaterializationToolConfig(props);
        TierTopicMaterializationUtils tool = new TierTopicMaterializationUtils(config);
        Assert.assertEquals((Object)tool.config.materializationPath, (Object)"/tmp/path");
        Assert.assertEquals((Object)tool.config.userPartition, (Object)new Integer(10));
        Assert.assertEquals((Object)tool.config.userTopicId, (Object)uuid);
        Assert.assertEquals((Object)tool.config.endOffset, (Object)new Integer(-1));
        Assert.assertEquals((Object)tool.config.dumpHeader, (Object)false);
    }

    @Test
    public void TierTopicMaterializationToolSetupTest() {
        String[] args = new String[]{"--source-partition", "10", "--start-offset", "5"};
        Properties props = TierMetadataDebugger.fetchPropertiesFromArgs((String[])args);
        System.out.println(props);
        System.out.println("source-partition");
        TierTopicMaterializationUtils consumer = new TierTopicMaterializationUtils(new TierTopicMaterializationToolConfig(props));
        Assert.assertEquals((Object)consumer.config.startOffset, (Object)new Integer(0));
        Assert.assertEquals((Object)consumer.config.userPartition, (Object)new Integer(10));
        Assert.assertEquals((Object)consumer.config.userTopicId, (Object)TierTopicMaterializationToolConfig.EMPTY_UUID);
    }
}

